/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import de.core.DBTableFrame;
import de.core.DeepEdit;
import de.core.PLPException;
import de.core.PLPFrame;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Label;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import quick.dbtable.CellPropertiesModel;
import quick.dbtable.Column;
import quick.dbtable.DBTable;

public final class PLPEdLDCBFFr
extends JDialog {
    Label title;
    private DBTable dBTable1;
    private boolean isTableFDLoad = false;
    public static String[] monthsnames = new String[]{"Enero", "Febrero", "Marzo", "Abril", "Mayo", "Junio", "Julio", "Agosto", "Septiembre", "Octubre", "Noviembre", "Diciembre"};
    private static String[] blocknames;
    private Connection dBConn;
    private int numBloqs;
    private PLPFrame myPLPFr = null;

    public PLPEdLDCBFFr(Frame mF, int nb) {
        super(mF, "Edicion de Factores Curvas de Carga");
        int i;
        this.numBloqs = nb;
        if (!(mF instanceof PLPFrame)) {
            this.dispose();
            return;
        }
        this.myPLPFr = (PLPFrame)mF;
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            // empty catch block
        }
        this.dBTable1 = new DBTable();
        Font TextDialogFont = DeepEdit.TextFont;
        this.dBTable1.setFont(TextDialogFont);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.dBTable1, "Center");
        this.title = new Label("FACTORES SEMANALES DE CURVA DURACION DE CARGA");
        this.title.setForeground(Color.blue);
        this.title.setAlignment(1);
        this.dBTable1.add((Component)this.title, (Object)"North");
        this.dBTable1.setDatabaseDriver("sun.jdbc.odbc.JdbcOdbcDriver");
        this.dBTable1.setJdbcUrl("jdbc:odbc:PLPDB");
        this.dBTable1.setSelectSql("select * from Dem_FCDC_Semanal_" + this.numBloqs + "B Order by Mes, Semana");
        this.dBTable1.addDeleteSql("delete from Dem_FCDC_Semanal_" + this.numBloqs + "B where Id=?", "" + (this.numBloqs * 2 + 3));
        String str1 = "insert into Dem_FCDC_Semanal_" + this.numBloqs + "B (Mes,Semana";
        String str2 = "(?,?";
        String str3 = "1,2";
        int bm1 = this.numBloqs + 1;
        for (i = 1; i < bm1; ++i) {
            str1 = str1 + ",Bloq" + i + "_Fact_Dur,Bloq" + i + "_Fact_Dem";
            str2 = str2 + ",?,?";
            str3 = str3 + "," + (2 * i + 1) + "," + (2 * i + 2);
        }
        str1 = str1 + ") values " + str2 + ")";
        this.dBTable1.addInsertSql(str1, str3);
        str1 = "update Dem_FCDC_Semanal_" + this.numBloqs + "B set Mes=?,Semana=?";
        for (i = 1; i < bm1; ++i) {
            str1 = str1 + ",Bloq" + i + "_Fact_Dur=?,Bloq" + i + "_Fact_Dem=?";
        }
        str1 = str1 + " where Id=?";
        str3 = str3 + "," + (this.numBloqs * 2 + 3);
        this.dBTable1.addUpdateSql(str1, str3);
        this.dBTable1.createControlPanel();
        try {
            this.dBConn = this.myPLPFr.dbtrab;
            this.dBTable1.setConnection(this.dBConn);
            blocknames = this.loadBlocknames(this.numBloqs);
            this.dBTable1.createColumnModelFromQuery();
            this.dBTable1.setEditable(true);
            this.dBTable1.enableExcelCopyPaste();
            Column c = this.dBTable1.getColumn(0);
            c.setHeaderValue((Object)"Mes");
            c.setPreferredWidth(80);
            Hashtable<Integer, String> h = new Hashtable<Integer, String>();
            for (i = 1; i < 13; ++i) {
                h.put(new Integer(i), monthsnames[i - 1]);
            }
            this.dBTable1.setCellComponent(c, 5, h);
            c = this.dBTable1.getColumn(1);
            c.setHeaderValue((Object)"Semana");
            c.setPreferredWidth(80);
            h = new Hashtable();
            for (i = 1; i < 5; ++i) {
                h.put(new Integer(i), new String("Semana" + i));
            }
            this.dBTable1.setCellComponent(c, 5, h);
            for (i = 1; i < this.numBloqs + 1; ++i) {
                c = this.dBTable1.getColumn(2 * i);
                c.setType(8);
                c.setPrecision(15);
                c.setScale(12);
                c.setSigned(false);
                c.setHeaderValue((Object)("B: " + blocknames[i - 1] + "\nDuraci\u00f3n [%]"));
                c.setPreferredWidth(100);
                c = this.dBTable1.getColumn(2 * i + 1);
                c.setType(8);
                c.setPrecision(15);
                c.setScale(12);
                c.setSigned(false);
                c.setHeaderValue((Object)("B: " + blocknames[i - 1] + "\nDemanda [%]"));
                c.setPreferredWidth(100);
            }
            c = this.dBTable1.getColumn(2 * this.numBloqs + 2);
            c.setVisible(false);
            CellPropertiesModel simpleCellModel = new CellPropertiesModel(){
                Font TextDialogFont = DeepEdit.TextFont;

                public Font getFont(int row, int col) {
                    return this.TextDialogFont;
                }

                public int getAlignment(int row, int col) {
                    if (col == 0) {
                        return 2;
                    }
                    if (col == 1) {
                        return 0;
                    }
                    return 4;
                }
            };
            this.dBTable1.setSkin(DBTableFrame.getDBTableSkin());
            this.dBTable1.setCellPropertiesModel(simpleCellModel);
            String sqlS1 = "";
            String sqlS2 = "";
            sqlS1 = "update Dem_FCDC_Semanal_3B set ";
            for (i = 1; i < this.numBloqs + 1; ++i) {
                sqlS1 = sqlS1 + "Bloq" + i + "_Fact_Dur=?, ";
                sqlS1 = sqlS1 + "Bloq" + i + "_Fact_Dem=?";
                if (i != this.numBloqs) {
                    sqlS1 = sqlS1 + ", ";
                }
                sqlS2 = sqlS2 + (2 * i + 1) + "," + (2 * i + 2) + ",";
            }
            sqlS1 = sqlS1 + " where Mes=? and Semana=?";
            sqlS2 = sqlS2 + "2,1";
            this.dBTable1.addUpdateSql(sqlS1, sqlS2);
            this.dBTable1.refresh();
        }
        catch (SQLException e) {
            e.printStackTrace();
            System.out.println("Error: al leer 'Dem_FCDC_Semanal_3B' en PLPDB.");
            JOptionPane.showMessageDialog(this, "Error: problemas en coneccion con PLPDB", "", 0);
            return;
        }
        catch (PLPException e) {
            JOptionPane.showMessageDialog(this, "Error: No hay bloques definidos para ese numero", "", 0);
            return;
        }
        this.setSize(725, 550);
        this.setVisible(true);
    }

    private String[] loadBlocknames(int numBloqs) throws PLPException {
        int regcount = 0;
        String[] bnames = new String[numBloqs];
        try {
            Statement s = this.dBConn.createStatement();
            ResultSet r = s.executeQuery("SELECT * FROM Nombre_Bloques_CDC WHERE (Grupo_NumBloques=" + numBloqs + ")" + " ORDER BY Num_Bloque");
            while (r.next()) {
                int val = r.getInt("Num_Bloque");
                String tmpName = r.getString("Nombre_Bloque");
                if (val != ++regcount) {
                    throw new PLPException("datos inconsistentes");
                }
                if (val - 1 == numBloqs) break;
                bnames[val - 1] = tmpName;
            }
            s.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println(e + " ,al leer PLPDB, tabla Nombre_Bloques_CDC");
        }
        return bnames;
    }
}

