/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import de.core.DeepEdit;
import de.core.PIETInterurbano;
import java.awt.Choice;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

class PIETInterurbanoFrame
extends JDialog
implements ActionListener,
ItemListener {
    PIETInterurbano myPIET_IU;
    protected Font TextDialogFont;
    protected FontMetrics TextDialogFontMetrics;
    private JButton buttonCalc;
    private JButton buttonCancel;
    private JCheckBox chbUno;
    private JCheckBox chbAll;
    private Choice chSelAno;

    PIETInterurbanoFrame(PIETInterurbano ms, Frame frameToLock) {
        super(frameToLock, "Modelo InterUrbano", true);
        this.myPIET_IU = ms;
        this.TextDialogFont = DeepEdit.TextFont;
        this.TextDialogFontMetrics = this.getFontMetrics(this.TextDialogFont);
        this.setFont(this.TextDialogFont);
        this.getContentPane().setFont(this.TextDialogFont);
        JPanel respanel = new JPanel();
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c1 = new GridBagConstraints();
        GridBagConstraints cEL = new GridBagConstraints();
        c1.anchor = 17;
        cEL.anchor = 17;
        c1.gridwidth = 1;
        cEL.gridwidth = 0;
        gridbag = new GridBagLayout();
        respanel.setLayout(gridbag);
        this.chbAll = new JCheckBox("C\u00e1lculo para todos los a\u00f1os del horizonte", false);
        this.chbAll.setFont(this.TextDialogFont);
        gridbag.setConstraints(this.chbAll, cEL);
        respanel.add(this.chbAll);
        this.chbAll.addItemListener(this);
        this.chbUno = new JCheckBox("S\u00f3lo actualizaci\u00f3n para el a\u00f1o seleccionado", true);
        this.chbUno.setFont(this.TextDialogFont);
        gridbag.setConstraints(this.chbUno, cEL);
        respanel.add(this.chbUno);
        this.chbUno.addItemListener(this);
        ButtonGroup group = new ButtonGroup();
        group.add(this.chbAll);
        group.add(this.chbUno);
        this.chSelAno = new Choice();
        int i = PIETInterurbano.iniYear;
        while (true) {
            if (i > PIETInterurbano.endYear) break;
            this.chSelAno.add("" + i);
            ++i;
        }
        cEL.anchor = 13;
        this.chSelAno.setFont(this.TextDialogFont);
        gridbag.setConstraints(this.chSelAno, cEL);
        respanel.add(this.chSelAno);
        TitledBorder inB1 = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "Opciones de C\u00e1lculo y Resultados", 2, 2, this.TextDialogFont, Color.blue);
        respanel.setBorder(inB1);
        JPanel controlP = new JPanel();
        controlP.setLayout(new FlowLayout());
        this.buttonCalc = new JButton("Calcular");
        this.buttonCalc.setFont(this.TextDialogFont);
        controlP.add(this.buttonCalc);
        this.buttonCalc.addActionListener(this);
        this.buttonCancel = new JButton("Cancelar");
        this.buttonCancel.setFont(this.TextDialogFont);
        controlP.add(this.buttonCancel);
        this.buttonCancel.addActionListener(this);
        cEL.fill = 2;
        this.getContentPane().setLayout(gridbag);
        gridbag.setConstraints(respanel, cEL);
        this.getContentPane().add(respanel);
        gridbag.setConstraints(controlP, cEL);
        this.getContentPane().add(controlP);
        ((JPanel)this.getContentPane()).setBorder(BorderFactory.createEmptyBorder(4, 2, 4, 2));
        this.pack();
        this.setResizable(false);
        this.setLocation(400, 20);
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        Object obj = ev.getSource();
        String label = ev.getActionCommand();
        try {
            if (obj == this.buttonCalc) {
                int auxy = -1;
                if (this.chbUno.isSelected()) {
                    auxy = this.chSelAno.getSelectedIndex();
                }
                this.myPIET_IU.calcular(auxy, this.chbAll.isSelected());
                this.myPIET_IU.myIUFrame = null;
                this.dispose();
            } else {
                this.myPIET_IU.myIUFrame = null;
                this.dispose();
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, e, "Modelo InterUrbano", 0);
            System.setErr(System.out);
            System.out.println(e);
            this.dispose();
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.chSelAno.setEnabled(this.chbUno.isSelected());
    }
}

