/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import de.core.DeepEdit;
import de.core.DeepEditFrame;
import de.core.PIETException;
import de.core.PIETInterurbanoFrame;
import de.core.PietSchematic;
import de.core.comp;
import de.core.tdb_centroid;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.Vector;

public final class PIETInterurbano {
    private PietSchematic sch;
    private static Connection dBConn;
    private DeepEdit applet;
    private String[] prov_Names = null;
    private double[][] mx_Dist = null;
    private boolean[] es_Norte = null;
    private int[] cuadMCarga = null;
    private boolean[][][] modo_Is_Disp = null;
    private double[][] param_B = null;
    private double[] vel_medP = null;
    private double[] val_sub_tpo = null;
    private double rend_auto = 1.0;
    private double[] tarifa_modoP = null;
    private double[] tasa_ocupacion = null;
    private double[][] pib = null;
    private double[][] pob = null;
    private double[][] precio_Benc = null;
    private double[][][] mx_TPO = null;
    private double[][][] mx_TP_full = null;
    private double[][][] mx_TC_full = null;
    private static int numDiasCC;
    private static double numHorasCC;
    private static int numMesesCT;
    public static int iniYear;
    public static int endYear;
    static String[] modosKey;
    static int numModosP;
    static int numModos;
    private double[][][] fact_Emision = null;
    static String[] gasesKey;
    static String[] macZKey;
    static String[] modosCKey;
    private final int numModosC = modosCKey.length;
    private double[] tamMedEmb = null;
    private double[] tarifa_modoC = null;
    private double[] vel_medC = null;
    private double[][][] ln_fi = null;
    private double[][][] teta1 = null;
    private double[][][] teta2 = null;
    private double[][][] ft_CAMION = null;
    private double[][][] ft_TRENC = null;
    private double[][][] fc_CLV = null;
    private double[][][] fc_CPE = null;
    private double[][][] fc_TRENC = null;
    private double[][][] costViaje = null;
    private double[] fb_Origen = null;
    private double[] fb_Destin = null;
    private double[] fb_A = null;
    private double[] fb_B = null;
    private double[][][][][] mx_TPmz = null;
    private double[][][][][] mx_TCmz = null;
    private int num_Tvalues = 2;
    private final double fbON_A1 = 6218300.4036;
    private final double fbON_A2 = 6.82203;
    private final double fbDN_A1 = 7325003.0266;
    private final double fbDN_A2 = 5.93898;
    private final double fbOS_A1 = 3.759316;
    private final double fbOS_A2 = 0.95557;
    private final double fbDS_A1 = 3.4421;
    private final double fbDS_A2 = 0.9807;
    private final int nmaxIter = 50;
    private final double tolerance = 0.018;
    private final double fesc = 1000.0;
    public PIETInterurbanoFrame myIUFrame = null;
    private int targYear = -1;
    private boolean calcAll = true;

    PIETInterurbano(PietSchematic psch, Connection pdBConn, DeepEdit depApp) throws PIETException {
        this.sch = psch;
        dBConn = pdBConn;
        this.applet = depApp;
        System.out.println("-----------------------------------------------------");
        System.out.println("INICIO: Modelo de Actividad de Transporte Interurbano");
        System.out.println("-----------------------------------------------------");
        System.out.print("Cargando Opciones...");
        this.getOptions();
        System.out.println("OK !");
        this.loadZonesFromSchem();
        this.myIUFrame = new PIETInterurbanoFrame(this, DeepEditFrame.MyPietEditFrame);
    }

    PIETInterurbano(boolean ventana) throws PIETException {
        System.out.println("-----------------------------------------------------");
        System.out.println("INICIO: Modelo de Transporte y Emisiones Interurbano");
        System.out.println("-----------------------------------------------------");
        try {
            dBConn = PIETInterurbano.OpenDataBase("PIETDB", "", "");
            dBConn.setAutoCommit(true);
        }
        catch (Exception e) {
            throw new PIETException("no se puede leer PIETDB");
        }
        System.out.print("Cargando Opciones...");
        this.getOptions();
        System.out.print("OK !");
        this.loadZonesFromDB();
        if (ventana) {
            this.myIUFrame = new PIETInterurbanoFrame(this, null);
        }
    }

    public void calcTransPasajMacZ() throws PIETException {
        int ixyear = 0;
        int ixmodo = 0;
        double[][][] mx_T_temp = null;
        this.fb_A = new double[this.prov_Names.length];
        this.fb_B = new double[this.prov_Names.length];
        this.fb_Origen = new double[this.prov_Names.length];
        this.fb_Destin = new double[this.prov_Names.length];
        int from = this.calcAll ? 0 : this.targYear;
        int to = this.calcAll ? this.mx_TPmz.length : this.targYear + 1;
        mx_T_temp = new double[numModosP][this.prov_Names.length][this.prov_Names.length];
        for (ixyear = from; ixyear < to; ++ixyear) {
            int jx;
            int ix;
            this.calc_Fact_O_D(ixyear, this.fb_Origen, this.fb_Destin);
            for (ix = 0; ix < this.prov_Names.length; ++ix) {
                for (jx = 0; jx < this.prov_Names.length; ++jx) {
                    for (ixmodo = 0; ixmodo < this.numModosC; ++ixmodo) {
                        mx_T_temp[ixmodo][ix][jx] = 0.0;
                    }
                }
            }
            for (ixmodo = 0; ixmodo < numModosP; ++ixmodo) {
                for (ix = 0; ix < this.prov_Names.length; ++ix) {
                    for (jx = 0; jx < this.prov_Names.length; ++jx) {
                        if (!this.modo_Is_Disp[ixmodo][ix][jx]) continue;
                        this.costViaje[ixmodo][ix][jx] = (this.val_sub_tpo[ixmodo] / this.vel_medP[ixmodo] + this.tarifa_modoP[ixmodo]) * this.mx_Dist[ix][jx];
                    }
                }
            }
            ixmodo = 0;
            for (ix = 0; ix < this.prov_Names.length; ++ix) {
                for (jx = 0; jx < this.prov_Names.length; ++jx) {
                    if (!this.modo_Is_Disp[ixmodo][ix][jx]) continue;
                    double[] dArray = this.costViaje[ixmodo][ix];
                    int n = jx;
                    dArray[n] = dArray[n] + this.precio_Benc[ixyear][ix] * this.mx_Dist[ix][jx] / this.rend_auto;
                }
            }
            System.out.println("\nAjustando Matriz de transporte Pasajeros Ano " + (ixyear + iniYear));
            this.ajustarMxTransP(mx_T_temp, this.costViaje);
            for (ix = 0; ix < this.prov_Names.length; ++ix) {
                for (jx = 0; jx < this.prov_Names.length; ++jx) {
                    if (ix == jx) continue;
                    for (ixmodo = 0; ixmodo < numModosP; ++ixmodo) {
                        if (!this.modo_Is_Disp[ixmodo][ix][jx]) continue;
                        int mzo = this.cuadMCarga[ix];
                        int mzd = this.cuadMCarga[jx];
                        double[] dArray = this.mx_TPmz[ixyear][ixmodo][mzo][mzd];
                        dArray[0] = dArray[0] + mx_T_temp[ixmodo][ix][jx];
                        double[] dArray2 = this.mx_TPmz[ixyear][ixmodo][mzo][mzd];
                        dArray2[1] = dArray2[1] + mx_T_temp[ixmodo][ix][jx] * this.mx_Dist[ix][jx];
                    }
                }
            }
        }
        this.mx_TP_full = mx_T_temp;
    }

    public void calcular(int year, boolean pcalcAll) throws Exception {
        this.targYear = year;
        this.calcAll = pcalcAll;
        this.creacion_variables(this.prov_Names.length, endYear - iniYear + 1);
        this.loadData();
        this.check_GroundCx();
        this.calcTransPasajMacZ();
        this.calcTransCargaMacZ();
        this.writeFile();
        this.saveResults();
        System.out.println("-----------------------------------------------------");
        System.out.println("FIN: Modelo de Transporte y Emisiones Interurbano");
        System.out.println("-----------------------------------------------------");
    }

    public void calc_Fact_O_D(int year, double[] fb_O, double[] fb_D) throws PIETException {
        for (int ix = 0; ix < fb_O.length; ++ix) {
            if (this.es_Norte[ix]) {
                fb_O[ix] = 6218300.4036 + 6.82203 * this.pib[year][ix];
                fb_D[ix] = 7325003.0266 + 5.93898 * this.pib[year][ix];
                continue;
            }
            fb_O[ix] = Math.exp(3.759316 + 0.95557 * Math.log(this.pib[year][ix]));
            fb_D[ix] = Math.exp(3.4421 + 0.9807 * Math.log(this.pib[year][ix]));
        }
    }

    public void ajustarMxTransP(double[][][] mx_T_temp, double[][][] mat_Cost) throws PIETException {
        int jx;
        int ixmodo;
        int ix;
        double sum = 0.0;
        double beta = 0.0;
        double aux = 0.0;
        double maxMisMatch = 0.0;
        int iter = 0;
        for (ix = 0; ix < this.prov_Names.length; ++ix) {
            this.fb_B[ix] = 1.0;
            this.fb_A[ix] = 1.0;
        }
        do {
            ++iter;
            maxMisMatch = 0.0;
            for (ix = 0; ix < this.prov_Names.length; ++ix) {
                sum = 0.0;
                aux = this.fb_A[ix];
                for (ixmodo = 0; ixmodo < numModosP; ++ixmodo) {
                    beta = this.es_Norte[ix] ? this.param_B[0][ixmodo] : this.param_B[1][ixmodo];
                    for (jx = 0; jx < this.prov_Names.length; ++jx) {
                        if (ix == jx || !this.modo_Is_Disp[ixmodo][ix][jx]) continue;
                        sum += this.fb_B[jx] * this.fb_Destin[jx] * Math.exp(-beta * mat_Cost[ixmodo][ix][jx] / 1000.0) * this.mx_TPO[ixmodo][ix][jx];
                    }
                }
                this.fb_A[ix] = 1.0 / sum;
                aux -= this.fb_A[ix];
                if (!(Math.abs(aux /= this.fb_A[ix]) > maxMisMatch)) continue;
                maxMisMatch = Math.abs(aux);
            }
            for (jx = 0; jx < this.prov_Names.length; ++jx) {
                sum = 0.0;
                aux = this.fb_B[jx];
                for (ixmodo = 0; ixmodo < numModosP; ++ixmodo) {
                    for (ix = 0; ix < this.prov_Names.length; ++ix) {
                        double d = beta = this.es_Norte[ix] ? this.param_B[0][ixmodo] : this.param_B[1][ixmodo];
                        if (ix == jx || !this.modo_Is_Disp[ixmodo][ix][jx]) continue;
                        sum += this.fb_A[ix] * this.fb_Origen[ix] * Math.exp(-beta * mat_Cost[ixmodo][ix][jx] / 1000.0) * this.mx_TPO[ixmodo][ix][jx];
                    }
                }
                this.fb_B[jx] = 1.0 / sum;
                aux -= this.fb_B[jx];
                if (!(Math.abs(aux /= this.fb_B[jx]) > maxMisMatch)) continue;
                maxMisMatch = Math.abs(aux);
            }
            System.out.print("\r                                                   ");
            System.out.print("\r It[" + iter + "]: \t" + maxMisMatch * 100.0 + " [%]");
        } while (maxMisMatch > 0.018 && iter < 50);
        for (ixmodo = 0; ixmodo < numModosP; ++ixmodo) {
            for (ix = 0; ix < this.prov_Names.length; ++ix) {
                beta = this.es_Norte[ix] ? this.param_B[0][ixmodo] : this.param_B[1][ixmodo];
                for (jx = 0; jx < this.prov_Names.length; ++jx) {
                    if (ix == jx || !this.modo_Is_Disp[ixmodo][ix][jx]) continue;
                    mx_T_temp[ixmodo][ix][jx] = this.mx_TPO[ixmodo][ix][jx];
                    double[] dArray = mx_T_temp[ixmodo][ix];
                    int n = jx;
                    dArray[n] = dArray[n] * (this.fb_A[ix] * this.fb_Origen[ix] * this.fb_B[jx] * this.fb_Destin[jx] * Math.exp(-beta * mat_Cost[ixmodo][ix][jx] / 1000.0));
                }
            }
        }
    }

    public void calcTransCargaMacZ() throws PIETException {
        int jx;
        int ix;
        int ixyear = 0;
        int ixmodo = 0;
        double[][][] mx_TC_temp = null;
        double[][][] cost = null;
        double[][][] tpoV = null;
        double sum = 0.0;
        double[] ft = new double[this.numModosC];
        double[] fc = new double[this.numModosC];
        mx_TC_temp = new double[this.numModosC][this.prov_Names.length][this.prov_Names.length];
        cost = new double[this.numModosC][this.prov_Names.length][this.prov_Names.length];
        tpoV = new double[this.numModosC][this.prov_Names.length][this.prov_Names.length];
        for (ix = 0; ix < this.prov_Names.length; ++ix) {
            for (jx = 0; jx < this.prov_Names.length; ++jx) {
                if (ix == jx) continue;
                for (ixmodo = 0; ixmodo < this.numModosC; ++ixmodo) {
                    cost[ixmodo][ix][jx] = this.tarifa_modoC[ixmodo] * this.mx_Dist[ix][jx];
                    tpoV[ixmodo][ix][jx] = this.mx_Dist[ix][jx] / this.vel_medC[ixmodo];
                }
            }
        }
        int from = this.calcAll ? 0 : this.targYear;
        int to = this.calcAll ? this.mx_TCmz.length : this.targYear + 1;
        System.out.println("");
        for (ixyear = from; ixyear < to; ++ixyear) {
            int mzd;
            int mzo;
            for (ix = 0; ix < this.prov_Names.length; ++ix) {
                for (jx = 0; jx < this.prov_Names.length; ++jx) {
                    for (ixmodo = 0; ixmodo < this.numModosC; ++ixmodo) {
                        mx_TC_temp[ixmodo][ix][jx] = 0.0;
                    }
                }
            }
            System.out.print("Calculando Matriz de transporte de Carga Ano " + (ixyear + iniYear) + "...");
            for (ix = 0; ix < this.prov_Names.length; ++ix) {
                for (jx = 0; jx < this.prov_Names.length; ++jx) {
                    if (ix == jx) continue;
                    for (ixmodo = 0; ixmodo < this.numModosC; ++ixmodo) {
                        if (!this.modo_Is_Disp[ixmodo + numModosP][ix][jx]) continue;
                        mzo = this.cuadMCarga[ix];
                        mzd = this.cuadMCarga[jx];
                        if (ixmodo == 0 && mzo != mzd || ixmodo == 0 && mzo == mzd && mzo != 2) continue;
                        sum = this.ln_fi[ixmodo][mzo][mzd] + this.teta1[ixmodo][mzo][mzd] * Math.log(this.pob[ixyear][ix] * this.pob[ixyear][jx]) + this.teta2[ixmodo][mzo][mzd] * Math.log(this.pib[ixyear][ix] * this.pib[ixyear][jx]);
                        fc[0] = this.fc_TRENC[ixmodo][mzo][mzd];
                        ft[0] = this.ft_TRENC[ixmodo][mzo][mzd];
                        fc[1] = this.fc_CLV[ixmodo][mzo][mzd];
                        ft[1] = this.ft_CAMION[ixmodo][mzo][mzd];
                        fc[2] = this.fc_CPE[ixmodo][mzo][mzd];
                        ft[2] = this.ft_CAMION[ixmodo][mzo][mzd];
                        for (int ixmodo2 = 0; ixmodo2 < this.numModosC; ++ixmodo2) {
                            if (!this.modo_Is_Disp[ixmodo2 + numModosP][ix][jx]) continue;
                            sum += ft[ixmodo2] * Math.log(tpoV[ixmodo2][ix][jx] * 60.0) + fc[ixmodo2] * Math.log(cost[ixmodo2][ix][jx]);
                        }
                        if (sum > 0.0) {
                            mx_TC_temp[ixmodo][ix][jx] = Math.exp(sum);
                        }
                        if (ixmodo == 0) {
                            double[] dArray = mx_TC_temp[ixmodo][ix];
                            int n = jx;
                            dArray[n] = dArray[n] * (double)numMesesCT;
                            continue;
                        }
                        double[] dArray = mx_TC_temp[ixmodo][ix];
                        int n = jx;
                        dArray[n] = dArray[n] * ((double)numDiasCC * numHorasCC);
                    }
                }
            }
            for (ix = 0; ix < this.prov_Names.length; ++ix) {
                for (jx = 0; jx < this.prov_Names.length; ++jx) {
                    if (ix == jx) continue;
                    for (ixmodo = 0; ixmodo < this.numModosC; ++ixmodo) {
                        if (!this.modo_Is_Disp[ixmodo + numModosP][ix][jx]) continue;
                        mzo = this.cuadMCarga[ix];
                        mzd = this.cuadMCarga[jx];
                        double[] dArray = this.mx_TCmz[ixyear][ixmodo][mzo][mzd];
                        dArray[0] = dArray[0] + mx_TC_temp[ixmodo][ix][jx];
                        double[] dArray2 = this.mx_TCmz[ixyear][ixmodo][mzo][mzd];
                        dArray2[1] = dArray2[1] + mx_TC_temp[ixmodo][ix][jx] * this.mx_Dist[ix][jx];
                    }
                }
            }
            System.out.println(" OK!");
        }
        this.mx_TC_full = mx_TC_temp;
    }

    public void loadData() throws PIETException {
        try {
            int jx;
            String auxSt;
            int idyear;
            int modo;
            int ix;
            int idProv2;
            String name2;
            String name1;
            System.out.println("Inicio Lectura de Datos:");
            int numProv = this.prov_Names.length;
            int numyear = endYear - iniYear + 1;
            Statement s = dBConn.createStatement();
            System.out.print("\r                                                               \rCargando distancias entre provincias...");
            ResultSet r = s.executeQuery("SELECT * FROM DIJ");
            int idProv = 0;
            while (r.next()) {
                name1 = r.getString("zona_i");
                name2 = r.getString("zona_j");
                idProv = this.findId(this.prov_Names, name1);
                idProv2 = this.findId(this.prov_Names, name2);
                if (idProv <= -1 || idProv2 <= -1) continue;
                this.mx_Dist[idProv][idProv2] = r.getDouble("dij");
            }
            System.out.print("OK !");
            System.out.print("\r                                                               \rCargando cuadrantes provincias modelo de pasajeros...");
            r = s.executeQuery("SELECT * FROM IU_Cuadrantes WHERE (Cuadrante_M_Pasaj='NORTE')");
            while (r.next()) {
                name1 = r.getString("Provincia");
                idProv = this.findId(this.prov_Names, name1);
                if (idProv <= -1) continue;
                this.es_Norte[idProv] = true;
            }
            System.out.print("OK !");
            System.out.print("\r                                                               \rCargando cuadrantes provincias modelo de carga...");
            r = s.executeQuery("SELECT * FROM IU_Cuadrantes");
            while (r.next()) {
                name1 = r.getString("Provincia");
                idProv = this.findId(this.prov_Names, name1);
                ix = this.findId(macZKey, r.getString("Cuadrante_M_Carga"));
                if (idProv > -1 && ix > -1) {
                    this.cuadMCarga[idProv] = ix;
                    continue;
                }
                if (ix != -1) continue;
                throw new PIETException("Cuadrante modelo de carga no valido, PIETDB, Tabla:'IU_Cuadrantes'\nProvincia:'" + name1 + "'");
            }
            System.out.print("OK !");
            System.out.print("\r                                                               \rCargando disponiblidad por modo entre provincias...");
            r = s.executeQuery("SELECT * FROM IU_Dispon_Modo");
            while (r.next()) {
                name1 = r.getString("Origen");
                name2 = r.getString("Destino");
                idProv = this.findId(this.prov_Names, name1);
                idProv2 = this.findId(this.prov_Names, name2);
                if (idProv <= -1 || idProv2 <= -1) continue;
                for (modo = 0; modo < numModos - 1; ++modo) {
                    this.modo_Is_Disp[modo][idProv][idProv2] = r.getInt(modosKey[modo]) > 0;
                }
                this.modo_Is_Disp[modo][idProv][idProv2] = this.modo_Is_Disp[modo - 1][idProv][idProv2];
            }
            System.out.print("OK !");
            System.out.print("\r                                                               \rCargando factores de emisiones por modo...");
            r = s.executeQuery("SELECT * FROM IU_Factores_Emisiones WHERE (Ano>=" + iniYear + ") AND (Ano<=" + endYear + ") ORDER BY Modo, Ano");
            ix = iniYear;
            modo = 0;
            while (r.next()) {
                idyear = r.getInt("Ano");
                auxSt = r.getString("Modo");
                if (!auxSt.equals(modosKey[modo])) {
                    modo = this.findId(modosKey, auxSt);
                    if (ix == endYear + 1) {
                        ix = iniYear;
                    } else {
                        throw new PIETException("Factor de emision no encontrado, PIETDB, Tabla:'IU_Factores_Emisiones'\nmodo:" + auxSt + ", a\u00f1o:" + endYear);
                    }
                }
                if (idyear != ix) {
                    throw new PIETException("Factor de emision no encontrado, PIETDB, Tabla:'IU_Factores_Emisiones'\nmodo:" + modosKey[modo] + ", a\u00f1o:" + ix);
                }
                ++ix;
                if (modo > -1) {
                    for (jx = 0; jx < gasesKey.length; ++jx) {
                        this.fact_Emision[idyear - PIETInterurbano.iniYear][modo][jx] = r.getDouble(gasesKey[jx]);
                    }
                    continue;
                }
                throw new PIETException("Modo no v\u00e1lido, PIETDB, Tabla:'IU_Factores_Emisiones'\nmodo:" + auxSt);
            }
            System.out.print("OK !");
            System.out.print("\r                                                               \rCargando matriz de viajes observados...");
            r = s.executeQuery("SELECT * FROM IU_Num_Vjes_Modo_Obs");
            while (r.next()) {
                name1 = r.getString("Origen");
                name2 = r.getString("Destino");
                idProv = this.findId(this.prov_Names, name1);
                idProv2 = this.findId(this.prov_Names, name2);
                auxSt = r.getString("Modo");
                modo = this.findId(modosKey, auxSt);
                if (idProv > -1 && idProv2 > -1 && modo > -1 && modo < 4) {
                    this.mx_TPO[modo][idProv][idProv2] = r.getDouble("N_VIAJES");
                    continue;
                }
                if (modo != -1 && modo <= 3) continue;
                throw new PIETException("Modo no v\u00e1lido, PIETDB, Tabla:'IU_Num_Vjes_Modo_Obs'\nmodo:" + auxSt);
            }
            System.out.print("OK !");
            System.out.print("\r                                                               \rCargando parametros Beta modelo pasajeros...");
            r = s.executeQuery("SELECT * FROM IU_Param_Beta");
            while (r.next()) {
                name1 = r.getString("Cuadrante");
                auxSt = r.getString("Modo");
                modo = this.findId(modosKey, auxSt);
                ix = -1;
                if (name1.equals("NORTE")) {
                    ix = 0;
                } else if (name1.equals("SUR")) {
                    ix = 1;
                }
                if (ix < 0) {
                    throw new PIETException("Cuadrante no valido, PIETDB, Tabla:'IU_Param_Beta'\ncuadrante:" + name1);
                }
                if (modo == -1 || modo < 4) {
                    this.param_B[ix][modo] = r.getDouble("BETA");
                    continue;
                }
                throw new PIETException("Modo no valido, PIETDB, Tabla:'IU_Param_Beta'\nmodo:" + auxSt);
            }
            System.out.print("OK !");
            System.out.print("\r                                                               \rCargando parametros de modos modelo pasajeros...");
            for (modo = 0; modo < numModosP; ++modo) {
                r = s.executeQuery("SELECT * FROM IU_Param_Modo_Pasaj WHERE (Modo='" + modosKey[modo] + "')");
                ix = -1;
                while (r.next()) {
                    ++ix;
                    if (modo == 0) {
                        this.rend_auto = r.getDouble("Rendimiento");
                    }
                    this.val_sub_tpo[modo] = r.getDouble("VST");
                    this.tarifa_modoP[modo] = r.getDouble("TarifaKm");
                    this.vel_medP[modo] = r.getDouble("Vel_Med");
                    this.tasa_ocupacion[modo] = r.getDouble("TasaMed_Ocup");
                }
                if (ix < 0) {
                    throw new PIETException("Parametro no encontrado, PIETDB, Tabla:'IU_Param_Modo_Pasaj'\nmodo:" + modosKey[modo]);
                }
                if (ix <= 0) continue;
                throw new PIETException("Mas de un registro, PIETDB, Tabla:'IU_Param_Modo_Pasaj'\nmodo:" + modosKey[modo]);
            }
            System.out.print("OK !");
            System.out.print("\r                                                               \rCargando proyecciones de PIB por zonas...");
            for (idProv = 0; idProv < this.prov_Names.length; ++idProv) {
                r = s.executeQuery("SELECT * FROM PIB WHERE (zona='" + this.prov_Names[idProv] + "') AND (Ano>=" + iniYear + ") AND (ano<=" + endYear + ") ORDER BY ano");
                idyear = ix = iniYear;
                while (r.next()) {
                    idyear = r.getInt("ano");
                    if (idyear != ix) {
                        throw new PIETException("PIB no encontrado, PIETDB, Tabla:'PIB'\nzona:'" + this.prov_Names[idProv] + "', a\u00f1o:" + ix);
                    }
                    ++ix;
                    this.pib[idyear - PIETInterurbano.iniYear][idProv] = r.getDouble("PIB");
                }
                if (idyear == endYear) continue;
                throw new PIETException("PIB no encontrado, PIETDB, Tabla:'PIB'\nzona:'" + this.prov_Names[idProv] + "', a\u00f1o:" + endYear);
            }
            System.out.print("OK !");
            System.out.print("OK !");
            System.out.print("\r                                                               \rCargando proyecciones de Poblacion por zonas...");
            for (idProv = 0; idProv < this.prov_Names.length; ++idProv) {
                r = s.executeQuery("SELECT * FROM POB WHERE (zona='" + this.prov_Names[idProv] + "') AND (ano>=" + iniYear + ") AND (ano<=" + endYear + ") ORDER BY ano");
                idyear = ix = iniYear;
                while (r.next()) {
                    idyear = r.getInt("ano");
                    if (idyear != ix) {
                        throw new PIETException("Poblacion no encontrada, PIETDB, Tabla:'POB'\nzona:'" + this.prov_Names[idProv] + "', a\u00f1o:" + ix);
                    }
                    ++ix;
                    this.pob[idyear - PIETInterurbano.iniYear][idProv] = r.getDouble("POB");
                }
                if (idyear == endYear) continue;
                throw new PIETException("Poblacion no encontrada, PIETDB, Tabla:'POB'\nzona:'" + this.prov_Names[idProv] + "', a\u00f1o:" + endYear);
            }
            System.out.print("OK !");
            System.out.print("\r                                                               \rCargando Precios de Combustibles por zonas...");
            for (idProv = 0; idProv < this.prov_Names.length; ++idProv) {
                r = s.executeQuery("SELECT * FROM PED WHERE (zona='" + this.prov_Names[idProv] + "') AND (energetico='GASOLINA')" + " AND (ano>=" + iniYear + ") AND (ano<=" + endYear + ") ORDER BY ano");
                idyear = ix = iniYear;
                while (r.next()) {
                    idyear = r.getInt("ano");
                    if (idyear != ix) {
                        throw new PIETException("Precio Gasolina no encontrado, PIETDB, Tabla:'PED'\nzona:'" + this.prov_Names[idProv] + "', a\u00f1o:" + ix + "\nfavor ejecutar c\u00e1lculo de Precios Energ\u00e9ticos Dom\u00e9sticos");
                    }
                    ++ix;
                    this.precio_Benc[idyear - PIETInterurbano.iniYear][idProv] = r.getDouble("PED") / 1000.0;
                }
                if (idyear == endYear) continue;
                throw new PIETException("Precio Gasolina no encontrado, PIETDB, Tabla:'PED'\nzona:'" + this.prov_Names[idProv] + "', a\u00f1o:" + endYear + "\nfavor ejecutar c\u00e1lculo de Precios Energ\u00e9ticos Dom\u00e9sticos");
            }
            System.out.print("OK !");
            System.out.print("\r                                                               \rCargando parametros de modos modelo carga...");
            for (modo = 0; modo < this.numModosC; ++modo) {
                r = s.executeQuery("SELECT * FROM IU_Param_Modo_Carga WHERE (Modo='" + modosCKey[modo] + "')");
                ix = -1;
                while (r.next()) {
                    ++ix;
                    this.tamMedEmb[modo] = r.getDouble("TamMed_Emb");
                    this.tarifa_modoC[modo] = r.getDouble("TarifaKm");
                    this.vel_medC[modo] = r.getDouble("Vel_Med");
                }
                if (ix < 0) {
                    throw new PIETException("Parametro no encontrado, PIETDB, Tabla:'IU_Param_Modo_Carga'\nmodo:" + modosCKey[modo]);
                }
                if (ix <= 0) continue;
                throw new PIETException("Mas de un registro, PIETDB, Tabla:'IU_Param_Modo_Carga'\nmodo:" + modosCKey[modo]);
            }
            System.out.print("OK !");
            System.out.print("\r                                                               \rCargando parametros de modelo de carga...");
            for (modo = 0; modo < this.numModosC; ++modo) {
                r = s.executeQuery("SELECT * FROM IU_Param_Modelo_Carga WHERE (Modo='" + modosCKey[modo] + "')");
                while (r.next()) {
                    name1 = r.getString("Cuad_MC_Orig");
                    ix = this.findId(macZKey, name1);
                    name2 = r.getString("Cuad_MC_Dest");
                    jx = this.findId(macZKey, name2);
                    if (ix > -1 && jx > -1) {
                        double d = r.getDouble("ln_fi");
                        this.ln_fi[modo][jx][ix] = d;
                        this.ln_fi[modo][ix][jx] = d;
                        double d2 = r.getDouble("Teta1");
                        this.teta1[modo][jx][ix] = d2;
                        this.teta1[modo][ix][jx] = d2;
                        double d3 = r.getDouble("Teta2");
                        this.teta2[modo][jx][ix] = d3;
                        this.teta2[modo][ix][jx] = d3;
                        double d4 = r.getDouble("FT_CAMION");
                        this.ft_CAMION[modo][jx][ix] = d4;
                        this.ft_CAMION[modo][ix][jx] = d4;
                        double d5 = r.getDouble("FT_TRENC");
                        this.ft_TRENC[modo][jx][ix] = d5;
                        this.ft_TRENC[modo][ix][jx] = d5;
                        double d6 = r.getDouble("FC_CLV");
                        this.fc_CLV[modo][jx][ix] = d6;
                        this.fc_CLV[modo][ix][jx] = d6;
                        double d7 = r.getDouble("FC_CPE");
                        this.fc_CPE[modo][jx][ix] = d7;
                        this.fc_CPE[modo][ix][jx] = d7;
                        double d8 = r.getDouble("FC_TRENC");
                        this.fc_TRENC[modo][jx][ix] = d8;
                        this.fc_TRENC[modo][ix][jx] = d8;
                        continue;
                    }
                    if (jx < -1) {
                        name1 = name2;
                    }
                    throw new PIETException("Cuadrante no v\u00e1lido, PIETDB, Tabla:'IU_Param_Modelo_Carga'\ncuadrante:" + name1);
                }
            }
            boolean faltaDato = false;
            for (modo = 0; modo < this.numModosC; ++modo) {
                for (ix = 0; ix < macZKey.length; ++ix) {
                    for (jx = 0; jx <= ix; ++jx) {
                        double dato1 = this.ln_fi[modo][ix][jx] + this.teta1[modo][ix][jx] + this.teta2[modo][ix][jx] + this.ft_CAMION[modo][ix][jx] + this.ft_TRENC[modo][ix][jx] + this.fc_CLV[modo][ix][jx] + this.fc_CPE[modo][ix][jx] + this.fc_TRENC[modo][ix][jx];
                        faltaDato = dato1 == 0.0 && ix == 1 && modo != 0;
                        faltaDato = faltaDato || dato1 == 0.0 && ix == jx && modo != 0;
                        boolean bl = faltaDato = faltaDato || dato1 == 0.0 && ix == 2 && jx == 2;
                        if (!faltaDato) continue;
                        throw new PIETException("Par\u00e1mtros no encontrados, PIETDB, Tabla:'IU_Param_Modelo_Carga'\nmodo:" + modosCKey[modo] + " cuadrantes (Orig,Dest): (" + macZKey[ix] + "," + macZKey[jx] + ")");
                    }
                }
            }
            System.out.print("OK !");
            s.close();
            System.out.println("\nLectura de datos finalizada correctamente.");
        }
        catch (SQLException e) {
            throw new PIETException("No se puede leer PietDB InterUrbano\nVerificar Integridad de base de datos");
        }
    }

    public void saveResults() throws PIETException {
        System.out.println("\nEscribiendo Resultados en DB. ");
        String cols = "";
        String vals = "";
        String SQLInstruction = "";
        double datocheck = 0.0;
        try {
            int ixmodo;
            String valsAux2;
            int jx;
            String valsAux1;
            int ix;
            int ixyear;
            Statement s = dBConn.createStatement();
            SQLInstruction = "DELETE * FROM IU_Res_TransPasaj";
            if (!this.calcAll) {
                SQLInstruction = SQLInstruction + " WHERE (ano=" + (this.targYear + iniYear) + ")";
            }
            s.executeUpdate(SQLInstruction);
            System.out.print("Guardando en Tabla 'IU_Res_TransPasaj'... ");
            cols = "Ano, MacroZonaO, MacroZonaD, Modo, N_Viajes, Viajes_Dist";
            int from = this.calcAll ? 0 : this.targYear;
            int to = this.calcAll ? this.mx_TPmz.length : this.targYear + 1;
            for (ixyear = from; ixyear < to; ++ixyear) {
                for (ix = 0; ix < macZKey.length; ++ix) {
                    valsAux1 = "" + (ixyear + iniYear);
                    valsAux1 = valsAux1 + ",'" + macZKey[ix] + "'";
                    for (jx = 0; jx < macZKey.length; ++jx) {
                        valsAux2 = valsAux1 + ",'" + macZKey[jx] + "'";
                        for (ixmodo = 0; ixmodo < numModosP; ++ixmodo) {
                            vals = valsAux2 + ",'" + modosKey[ixmodo] + "'";
                            vals = vals + "," + this.mx_TPmz[ixyear][ixmodo][ix][jx][0];
                            vals = vals + "," + this.mx_TPmz[ixyear][ixmodo][ix][jx][1];
                            SQLInstruction = "INSERT INTO IU_Res_TransPasaj (" + cols + ")" + " VALUES (" + vals + ")";
                            s.executeUpdate(SQLInstruction);
                        }
                    }
                }
            }
            System.out.println("OK !");
            s = dBConn.createStatement();
            SQLInstruction = "DELETE * FROM IU_Res_Num_Vehic_Modo";
            if (!this.calcAll) {
                SQLInstruction = SQLInstruction + " WHERE (ano=" + (this.targYear + iniYear) + ")";
            }
            s.executeUpdate(SQLInstruction);
            System.out.print("Guardando en Tabla 'IU_Res_Num_Vehic_Modo'... ");
            cols = "Ano, MacroZonaO, MacroZonaD, Modo, N_Vehiculos, Vehiculos_Dist";
            from = this.calcAll ? 0 : this.targYear;
            to = this.calcAll ? this.mx_TPmz.length : this.targYear + 1;
            for (ixyear = from; ixyear < to; ++ixyear) {
                for (ix = 0; ix < macZKey.length; ++ix) {
                    valsAux1 = "" + (ixyear + iniYear);
                    valsAux1 = valsAux1 + ",'" + macZKey[ix] + "'";
                    for (jx = 0; jx < macZKey.length; ++jx) {
                        valsAux2 = valsAux1 + ",'" + macZKey[jx] + "'";
                        for (ixmodo = 0; ixmodo < numModosP; ++ixmodo) {
                            vals = valsAux2 + ",'" + modosKey[ixmodo] + "'";
                            vals = vals + "," + this.mx_TPmz[ixyear][ixmodo][ix][jx][0] / this.tasa_ocupacion[ixmodo];
                            vals = vals + "," + this.mx_TPmz[ixyear][ixmodo][ix][jx][1] / this.tasa_ocupacion[ixmodo];
                            SQLInstruction = "INSERT INTO IU_Res_Num_Vehic_Modo (" + cols + ")" + " VALUES (" + vals + ")";
                            s.executeUpdate(SQLInstruction);
                        }
                        for (ixmodo = 1; ixmodo < this.numModosC; ++ixmodo) {
                            vals = valsAux2 + ",'" + modosCKey[ixmodo] + "'";
                            vals = vals + "," + this.mx_TCmz[ixyear][ixmodo][ix][jx][0];
                            vals = vals + "," + this.mx_TCmz[ixyear][ixmodo][ix][jx][1];
                            SQLInstruction = "INSERT INTO IU_Res_Num_Vehic_Modo (" + cols + ")" + " VALUES (" + vals + ")";
                            s.executeUpdate(SQLInstruction);
                        }
                    }
                }
            }
            System.out.println("OK !");
            s = dBConn.createStatement();
            SQLInstruction = "DELETE * FROM IU_Res_Emisiones";
            if (!this.calcAll) {
                SQLInstruction = SQLInstruction + " WHERE (Ano=" + (this.targYear + iniYear) + ")";
            }
            s.executeUpdate(SQLInstruction);
            System.out.print("Guardando en Tabla 'IU_Res_Emisiones'... ");
            cols = "Ano, MacroZonaO, MacroZonaD, Modo";
            for (jx = 0; jx < gasesKey.length; ++jx) {
                cols = cols + "," + gasesKey[jx];
            }
            from = this.calcAll ? 0 : this.targYear;
            to = this.calcAll ? this.mx_TPmz.length : this.targYear + 1;
            for (ixyear = from; ixyear < to; ++ixyear) {
                for (ix = 0; ix < macZKey.length; ++ix) {
                    valsAux1 = "" + (ixyear + iniYear);
                    valsAux1 = valsAux1 + ",'" + macZKey[ix] + "'";
                    for (jx = 0; jx < macZKey.length; ++jx) {
                        int ixgas;
                        double dato1;
                        valsAux2 = valsAux1 + ",'" + macZKey[jx] + "'";
                        for (ixmodo = 0; ixmodo < numModosP; ++ixmodo) {
                            vals = valsAux2 + ",'" + modosKey[ixmodo] + "'";
                            dato1 = this.mx_TPmz[ixyear][ixmodo][ix][jx][1] / this.tasa_ocupacion[ixmodo];
                            datocheck = 0.0;
                            for (ixgas = 0; ixgas < gasesKey.length; ++ixgas) {
                                datocheck += this.fact_Emision[ixyear][ixmodo][ixgas];
                                vals = vals + "," + dato1 * this.fact_Emision[ixyear][ixmodo][ixgas] / 1000000.0;
                            }
                            if (datocheck == 0.0) continue;
                            SQLInstruction = "INSERT INTO IU_Res_Emisiones (" + cols + ")" + " VALUES (" + vals + ")";
                            s.executeUpdate(SQLInstruction);
                        }
                        for (ixmodo = 1; ixmodo < this.numModosC; ++ixmodo) {
                            vals = valsAux2 + ",'" + modosCKey[ixmodo] + "'";
                            dato1 = this.mx_TCmz[ixyear][ixmodo][ix][jx][1];
                            datocheck = 0.0;
                            for (ixgas = 0; ixgas < gasesKey.length; ++ixgas) {
                                datocheck += this.fact_Emision[ixyear][ixmodo + numModosP][ixgas];
                                vals = vals + "," + dato1 * this.fact_Emision[ixyear][ixmodo + numModosP][ixgas] / 1000000.0;
                            }
                            if (datocheck == 0.0) continue;
                            SQLInstruction = "INSERT INTO IU_Res_Emisiones (" + cols + ")" + " VALUES (" + vals + ")";
                            s.executeUpdate(SQLInstruction);
                        }
                    }
                }
            }
            System.out.println("OK !");
            s = dBConn.createStatement();
            SQLInstruction = "DELETE * FROM IU_Res_TransCarga";
            if (!this.calcAll) {
                SQLInstruction = SQLInstruction + " WHERE (ano=" + (this.targYear + iniYear) + ")";
            }
            s.executeUpdate(SQLInstruction);
            System.out.print("Guardando en Tabla 'IU_Res_TransCarga'... ");
            cols = "Ano, MacroZonaO, MacroZonaD, Modo, Carga, Carga_Dist";
            from = this.calcAll ? 0 : this.targYear;
            to = this.calcAll ? this.mx_TCmz.length : this.targYear + 1;
            for (ixyear = from; ixyear < to; ++ixyear) {
                for (ix = 0; ix < macZKey.length; ++ix) {
                    valsAux1 = "" + (ixyear + iniYear);
                    valsAux1 = valsAux1 + ",'" + macZKey[ix] + "'";
                    for (jx = 0; jx < macZKey.length; ++jx) {
                        valsAux2 = valsAux1 + ",'" + macZKey[jx] + "'";
                        for (ixmodo = 0; ixmodo < this.numModosC; ++ixmodo) {
                            vals = valsAux2 + ",'" + modosCKey[ixmodo] + "'";
                            if (this.mx_TCmz[ixyear][ixmodo][ix][jx][0] == 0.0) continue;
                            if (ixmodo != 0) {
                                vals = vals + "," + this.mx_TCmz[ixyear][ixmodo][ix][jx][0] * this.tamMedEmb[ixmodo];
                                vals = vals + "," + this.mx_TCmz[ixyear][ixmodo][ix][jx][1] * this.tamMedEmb[ixmodo];
                            } else {
                                vals = vals + "," + this.mx_TCmz[ixyear][ixmodo][ix][jx][0];
                                vals = vals + "," + this.mx_TCmz[ixyear][ixmodo][ix][jx][1];
                            }
                            SQLInstruction = "INSERT INTO IU_Res_TransCarga (" + cols + ")" + " VALUES (" + vals + ")";
                            s.executeUpdate(SQLInstruction);
                        }
                    }
                }
            }
            System.out.println("OK !");
            s.close();
        }
        catch (SQLException e) {
            throw new PIETException("No se pueden escribir resultados en PietDB InterUrbano\nVerificar integridad de base de datos");
        }
    }

    public void writeFile() throws Exception {
        int jx;
        int modo;
        int ix;
        if (this.calcAll) {
            return;
        }
        FileOutputStream os = null;
        os = new FileOutputStream(new File("./PietFiles/Resultados/IU_MxTrns_" + (iniYear + this.targYear) + ".csv"));
        PrintWriter myPW = new PrintWriter(os, true);
        myPW.println("Resultados Transporte InterUrbano A\u00f1o " + (iniYear + this.targYear));
        myPW.println("\nProvinicias Consideradas (Orden de Matrices)");
        for (ix = 0; ix < this.prov_Names.length; ++ix) {
            myPW.print("," + this.prov_Names[ix]);
        }
        myPW.println("\n\nResultados Transporte Pasajeros Viajes-A\u00f1o");
        for (modo = 0; modo < numModosP; ++modo) {
            myPW.println("\nModo " + modosKey[modo] + "\n");
            for (ix = 0; ix < this.mx_TP_full[modo].length; ++ix) {
                for (jx = 0; jx < this.mx_TP_full[modo][ix].length; ++jx) {
                    myPW.print("," + this.mx_TP_full[modo][ix][jx]);
                }
                myPW.println();
            }
        }
        myPW.println("\n\nResultados Transporte Carga Vehiculos/a\u00f1o (Camion) Toneladas/a\u00f1o (TRENC)");
        for (modo = 0; modo < this.numModosC; ++modo) {
            myPW.println("\nModo " + modosKey[modo + numModosP] + "\n");
            for (ix = 0; ix < this.mx_TC_full[modo].length; ++ix) {
                for (jx = 0; jx < this.mx_TC_full[modo][ix].length; ++jx) {
                    myPW.print("," + this.mx_TC_full[modo][ix][jx]);
                }
                myPW.println();
            }
        }
        myPW.flush();
        os.close();
    }

    public void getOptions() throws PIETException {
        int regcount = 0;
        double value = 0.0;
        try {
            Statement s = dBConn.createStatement();
            ResultSet r = s.executeQuery("SELECT * FROM OPTIONS");
            while (r.next()) {
                ++regcount;
                int baseYear = r.getInt("ano_base");
                iniYear = r.getInt("ano_ini");
                endYear = r.getInt("ano_fin");
                if (baseYear >= 1 && iniYear >= 1 && endYear >= 1 && endYear - iniYear >= 0) continue;
                throw new PIETException(" Dato err\u00f3neo o no encontrado en OPTIONS, PIETDB");
            }
            s.close();
        }
        catch (SQLException e) {
            throw new PIETException("No se puede leer PietDB Tabla 'OPTIONS'");
        }
    }

    public int findId(String[] array, String name) {
        for (int i = 0; i < array.length; ++i) {
            if (!array[i].equals(name)) continue;
            return i;
        }
        return -1;
    }

    public void creacion_variables(int numProv, int numyears) {
        this.mx_Dist = new double[numProv][numProv];
        this.es_Norte = new boolean[numProv];
        this.modo_Is_Disp = new boolean[numModos][numProv][numProv];
        this.param_B = new double[2][numModosP];
        this.vel_medP = new double[numModosP];
        this.val_sub_tpo = new double[numModosP];
        this.tarifa_modoP = new double[numModosP];
        this.tasa_ocupacion = new double[numModosP];
        this.pib = new double[numyears][numProv];
        this.pob = new double[numyears][numProv];
        this.precio_Benc = new double[numyears][numProv];
        this.mx_TPO = new double[numModosP][numProv][numProv];
        this.costViaje = new double[numModosP][numProv][numProv];
        this.fact_Emision = new double[numyears][numModos][gasesKey.length];
        this.cuadMCarga = new int[numProv];
        this.mx_TPmz = new double[numyears][numModosP][macZKey.length][macZKey.length][this.num_Tvalues];
        this.tamMedEmb = new double[this.numModosC];
        this.tarifa_modoC = new double[this.numModosC];
        this.vel_medC = new double[this.numModosC];
        this.ln_fi = new double[this.numModosC][macZKey.length][macZKey.length];
        this.teta1 = new double[this.numModosC][macZKey.length][macZKey.length];
        this.teta2 = new double[this.numModosC][macZKey.length][macZKey.length];
        this.ft_CAMION = new double[this.numModosC][macZKey.length][macZKey.length];
        this.ft_TRENC = new double[this.numModosC][macZKey.length][macZKey.length];
        this.fc_CLV = new double[this.numModosC][macZKey.length][macZKey.length];
        this.fc_CPE = new double[this.numModosC][macZKey.length][macZKey.length];
        this.fc_TRENC = new double[this.numModosC][macZKey.length][macZKey.length];
        this.mx_TCmz = new double[numyears][this.numModosC][macZKey.length][macZKey.length][this.num_Tvalues];
    }

    public void check_GroundCx() throws PIETException {
        int ixmodo;
        int jx;
        int ix;
        boolean[][] matCx = new boolean[this.prov_Names.length][this.prov_Names.length];
        System.out.print("Chequendo conectividad...");
        for (ix = 0; ix < this.prov_Names.length; ++ix) {
            for (jx = 0; jx < this.prov_Names.length; ++jx) {
                for (ixmodo = 0; ixmodo < numModosP; ++ixmodo) {
                    matCx[ix][jx] = matCx[ix][jx] || this.modo_Is_Disp[ixmodo][ix][jx];
                }
            }
        }
        int numnod = this.prov_Names.length;
        int[] grupnod1 = new int[numnod + 1];
        boolean[] ingrup1 = new boolean[numnod];
        grupnod1[0] = 1;
        grupnod1[1] = 0;
        ingrup1[0] = true;
        for (ix = 1; ix <= grupnod1[0]; ++ix) {
            for (jx = 0; jx < numnod; ++jx) {
                if (!matCx[grupnod1[ix]][jx] || ingrup1[jx]) continue;
                grupnod1[0] = grupnod1[0] + 1;
                grupnod1[grupnod1[0]] = jx;
                ingrup1[jx] = true;
            }
            if (grupnod1[0] == numnod) break;
        }
        if (grupnod1[0] < numnod) {
            int count = 0;
            for (ix = 0; ix < numnod; ++ix) {
                if (!ingrup1[ix]) continue;
                ++count;
            }
            if (count > numnod / 2) {
                for (ix = 0; ix < numnod && ingrup1[ix]; ++ix) {
                }
            } else {
                for (ix = 0; ix < numnod && !ingrup1[ix]; ++ix) {
                }
            }
            throw new PIETException("Se encontraron provincias asiladas, Modelo de Pasajeros\nProvincias: '" + this.prov_Names[ix] + "',...");
        }
        for (ix = 0; ix < this.prov_Names.length; ++ix) {
            for (jx = 0; jx < this.prov_Names.length; ++jx) {
                for (ixmodo = numModosP; ixmodo < numModos; ++ixmodo) {
                    matCx[ix][jx] = matCx[ix][jx] || this.modo_Is_Disp[ixmodo][ix][jx];
                }
            }
        }
        grupnod1 = new int[numnod + 1];
        ingrup1 = new boolean[numnod];
        grupnod1[0] = 1;
        grupnod1[1] = 0;
        ingrup1[0] = true;
        for (ix = 1; ix <= grupnod1[0]; ++ix) {
            for (jx = 0; jx < numnod; ++jx) {
                if (!matCx[grupnod1[ix]][jx] || ingrup1[jx]) continue;
                grupnod1[0] = grupnod1[0] + 1;
                grupnod1[grupnod1[0]] = jx;
                ingrup1[jx] = true;
            }
            if (grupnod1[0] == numnod) break;
        }
        if (grupnod1[0] < numnod) {
            int count = 0;
            for (ix = 0; ix < numnod; ++ix) {
                if (!ingrup1[ix]) continue;
                ++count;
            }
            if (count > numnod / 2) {
                for (ix = 0; ix < numnod && ingrup1[ix]; ++ix) {
                }
            } else {
                for (ix = 0; ix < numnod && !ingrup1[ix]; ++ix) {
                }
            }
            throw new PIETException("Se encontraron provincias asiladas, Modelo de Carga\nProvincias: '" + this.prov_Names[ix] + "',...");
        }
        System.out.println("OK !");
    }

    public static Connection OpenDataBase(String DBName, String user, String password) throws SQLException {
        try {
            Class.forName("sun.jdbc.odbc.JdbcOdbcDriver");
        }
        catch (Exception e) {
            String message = e.toString();
            System.out.println("Error: en Connection OpenDatabase " + message);
            return null;
        }
        String dsn = "jdbc:odbc:" + DBName;
        return DriverManager.getConnection(dsn, user, password);
    }

    public static void main(String[] args) {
        try {
            PIETInterurbano testPIU = new PIETInterurbano(true);
            System.setErr(System.out);
            testPIU.calcular(0, false);
            dBConn.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void loadZonesFromDB() throws PIETException {
        try {
            Statement s = dBConn.createStatement();
            Vector<String> auxV = new Vector<String>(40);
            System.out.print("\r                                                               \rCarga de provincias from DB...");
            ResultSet r = s.executeQuery("SELECT * FROM IU_Cuadrantes");
            while (r.next()) {
                auxV.add(r.getString("Provincia"));
            }
            this.prov_Names = new String[auxV.size()];
            for (int idProv = 0; idProv < auxV.size(); ++idProv) {
                this.prov_Names[idProv] = (String)auxV.elementAt(idProv);
            }
            System.out.println("OK ! " + this.prov_Names.length);
        }
        catch (SQLException e) {
            throw new PIETException("No se puede leer, PIETDB, Tabla:'IU_Cuadrantes'");
        }
    }

    private void loadZonesFromSchem() {
        System.out.print("\r                                                               \rCargando provincias del esquematico...");
        Vector<String> auxV = new Vector<String>(40);
        for (int ix = 0; ix < this.sch.Components.size(); ++ix) {
            comp TempComponent = (comp)this.sch.Components.elementAt(ix);
            if (!(TempComponent instanceof tdb_centroid)) continue;
            auxV.add(TempComponent.getName());
        }
        Collections.sort(auxV);
        this.prov_Names = new String[auxV.size()];
        for (int idProv = 0; idProv < auxV.size(); ++idProv) {
            this.prov_Names[idProv] = (String)auxV.elementAt(idProv);
        }
        System.out.println("OK ! " + this.prov_Names.length);
    }

    static {
        numDiasCC = 300;
        numHorasCC = 17.5;
        numMesesCT = 12;
        iniYear = 2003;
        endYear = 2015;
        modosKey = new String[]{"AUTO", "BUS", "TREN", "AVION", "TRENC", "CAMION_LV", "CAMION_PE"};
        numModosP = 4;
        numModos = modosKey.length;
        gasesKey = new String[]{"MP", "CO", "HC", "NOX"};
        macZKey = new String[]{"NORTE", "CENTRO", "SUR"};
        modosCKey = new String[]{"TRENC", "CAMION_LV", "CAMION_PE"};
    }
}

