/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import de.core.DeepEdit;
import de.core.PietSchematic;
import de.core.comp;
import de.core.tdb_arc;
import de.core.tdb_centroid;
import de.core.tdb_node;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.Statement;

public final class PIETInterUrbanoRoad {
    private PietSchematic sch;
    private Connection dBConn;
    private DeepEdit applet;
    public tdb_centroid[] mycentroids;
    public tdb_node[] mynodes;
    public tdb_arc[] myarcs;
    public int n_centroid = 0;
    public int n_node = 0;
    public int n_arc = 0;
    String pietWorkPath = "..\\run\\PIETFiles\\Resultados";
    FileOutputStream ActFOS;

    PIETInterUrbanoRoad(PietSchematic psch, Connection pdBConn, DeepEdit depApp, int analisis) {
        this.sch = psch;
        this.dBConn = pdBConn;
        this.applet = depApp;
        try {
            this.init();
            if (analisis == 1) {
                System.out.print("Creando GenericNodes ... ");
                this.writeFileGenericNodes();
                System.out.println("ok");
            }
            if (analisis == 2) {
                System.out.print("Creando GenericArcs  ... ");
                this.writeFileArcs();
                System.out.println("ok");
            }
        }
        catch (Exception e) {
            System.out.println("Problema en Rutina" + e);
            e.printStackTrace();
            return;
        }
    }

    public void init() throws Exception {
        comp TempComponent;
        int ix;
        int count = 0;
        this.n_centroid = 0;
        this.n_node = 0;
        this.n_arc = 0;
        for (ix = 0; ix < this.sch.Components.size(); ++ix) {
            TempComponent = (comp)this.sch.Components.elementAt(ix);
            if (TempComponent instanceof tdb_centroid) {
                ++this.n_centroid;
                continue;
            }
            if (TempComponent instanceof tdb_node) {
                ++this.n_node;
                continue;
            }
            if (!(TempComponent instanceof tdb_arc)) continue;
            ++this.n_arc;
        }
        this.mycentroids = new tdb_centroid[this.n_centroid];
        count = 0;
        for (ix = 0; ix < this.sch.Components.size(); ++ix) {
            TempComponent = (comp)this.sch.Components.elementAt(ix);
            if (!(TempComponent instanceof tdb_centroid)) continue;
            this.mycentroids[count] = (tdb_centroid)TempComponent;
            ++count;
        }
        this.mynodes = new tdb_node[this.n_node];
        count = 0;
        for (ix = 0; ix < this.sch.Components.size(); ++ix) {
            TempComponent = (comp)this.sch.Components.elementAt(ix);
            if (!(TempComponent instanceof tdb_node)) continue;
            this.mynodes[count] = (tdb_node)TempComponent;
            ++count;
        }
        this.myarcs = new tdb_arc[this.n_arc];
        count = 0;
        for (ix = 0; ix < this.sch.Components.size(); ++ix) {
            TempComponent = (comp)this.sch.Components.elementAt(ix);
            if (!(TempComponent instanceof tdb_arc)) continue;
            this.myarcs[count] = (tdb_arc)TempComponent;
            ++count;
        }
    }

    public void writeFileGenericNodes() throws Exception {
        String myname = "";
        String mytype = "";
        int myCx = 0;
        int myCy = 0;
        try {
            Statement s = this.dBConn.createStatement();
            s.executeUpdate("DELETE * FROM GenericNodes");
            for (int nc = 0; nc < this.n_centroid; ++nc) {
                myname = this.mycentroids[nc].getName();
                mytype = "Centroid";
                myCx = this.mycentroids[nc].Pos.x + 3;
                myCy = this.mycentroids[nc].Pos.y + 3;
                s.executeUpdate("INSERT INTO GenericNodes (nombre,tipo,Cx,Cy)VALUES ('" + myname + "','" + mytype + "'," + myCx + "," + myCy + ")");
            }
            for (int nn = 0; nn < this.n_node; ++nn) {
                myname = this.mynodes[nn].getName();
                mytype = "Node";
                myCx = this.mynodes[nn].Pos.x + 2;
                myCy = this.mynodes[nn].Pos.y + 2;
                s.executeUpdate("INSERT INTO GenericNodes (nombre,tipo,Cx,Cy)VALUES ('" + myname + "','" + mytype + "'," + myCx + "," + myCy + ")");
            }
            s.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("al escribir PIETDB: tabla GenericNodes");
        }
    }

    public void writeFileArcs() throws Exception {
        String myname = "";
        String myGN1 = "---";
        String myGN2 = "---";
        double mylenght = 0.0;
        int myCx1 = 0;
        int myCy1 = 0;
        int myCx2 = 0;
        int myCy2 = 0;
        int myCx = 0;
        int myCy = 0;
        try {
            Statement s = this.dBConn.createStatement();
            s.executeUpdate("DELETE * FROM GenericArcs");
            for (int na = 0; na < this.n_arc; ++na) {
                myname = this.myarcs[na].getName();
                myCx1 = this.myarcs[na].x1;
                myCy1 = this.myarcs[na].y1;
                myCx2 = this.myarcs[na].x2;
                myCy2 = this.myarcs[na].y2;
                myGN1 = "---";
                myGN2 = "---";
                for (int nc = 0; nc < this.n_centroid; ++nc) {
                    myCx = this.mycentroids[nc].Pos.x + 3;
                    myCy = this.mycentroids[nc].Pos.y + 3;
                    if (myCx1 == myCx && myCy1 == myCy) {
                        myGN1 = this.mycentroids[nc].getName();
                    }
                    if (myCx2 != myCx || myCy2 != myCy) continue;
                    myGN2 = this.mycentroids[nc].getName();
                }
                for (int nn = 0; nn < this.n_node; ++nn) {
                    myCx = this.mynodes[nn].Pos.x + 2;
                    myCy = this.mynodes[nn].Pos.y + 2;
                    if (myCx1 == myCx && myCy1 == myCy) {
                        myGN1 = this.mynodes[nn].getName();
                    }
                    if (myCx2 != myCx || myCy2 != myCy) continue;
                    myGN2 = this.mynodes[nn].getName();
                }
                mylenght = this.myarcs[na].getlength();
                s.executeUpdate("INSERT INTO GenericArcs (nombre,nombreGN1,nombreGN2,lenght)VALUES ('" + myname + "','" + myGN1 + "','" + myGN2 + "'," + mylenght + ")");
            }
            s.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("al escribir PIETDB: tabla GenericArcs");
        }
    }

    private PrintWriter openPWFile(String fname) throws Exception {
        this.ActFOS = new FileOutputStream(this.pietWorkPath + "\\" + fname);
        PrintWriter myWriter = new PrintWriter(this.ActFOS);
        return myWriter;
    }

    private void closeActFOS() throws Exception {
        this.ActFOS.close();
    }
}

