/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import de.core.DeepEdit;
import de.core.DeepEditFrame;
import de.core.PIETException;
import de.core.PietSchematic;
import de.core.comp;
import de.core.tdb_centroid;
import de.utils.StringUtil;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;

public final class PIETFF {
    private PietSchematic sch;
    private Connection dBConn;
    private DeepEdit applet;
    public int ano_ini = 2003;
    public int ano_base = 2003;
    public int ano_fin = 2015;
    public int numcat = 0;
    public int numzones = 0;
    public tdb_centroid[] mycentroids;
    private double[][] PEI = null;
    private double[][][] PED = null;
    private double[][] TESP = null;
    private double[][][] MED = null;
    private int[] idZoneRegion = null;
    private double[] D = null;
    private double[] IVA = null;
    private double[] T = null;
    String[] Region = new String[]{"RM", "I", "II", "III", "IV", "V", "VI", "VII", "VIII", "IX", "X", "XI", "XII"};
    String[] Cont = new String[]{"co", "hc", "mp", "nox", "sox"};
    String[] ENER = new String[]{"CARBON", "DIESEL", "GASLIC", "GASNAT", "GASOLINA", "KEROSENE", "PETCOMB", "ELECT"};
    String[] ENERUnit = new String[]{"$/ton", "$/m3", "$/m3", "$/m3", "$/m3", "$/m3", "$/m3", "$/MWh"};
    String[] DEMENUnit = new String[]{"---", "Mm3", "MTon", "---", "---", "Mm3", "Mton", "GWh"};
    public String[] VE = null;
    String pietWorkPath = "..\\run\\PIETFiles\\Resultados";
    FileOutputStream ActFOS;

    PIETFF(PietSchematic psch, Connection pdBConn, DeepEdit depApp) {
        this.sch = psch;
        this.dBConn = pdBConn;
        this.applet = depApp;
        System.out.println("-------------------------------------------------");
        System.out.println("INICIO: Calculo de Precios Energeticos Domesticos");
        System.out.println("-------------------------------------------------");
        try {
            this.getOptions();
            this.init();
            this.getData();
            this.calcPED();
            this.writeFilePEDArch();
            this.writeFilePED();
        }
        catch (Exception e) {
            System.out.println("Problema en Rutina" + e);
            DeepEditFrame.MyPietEditFrame.showError(e);
            return;
        }
        System.out.println("----------------------------------------------");
        System.out.println("FIN: Calculo de Precios Energeticos Domesticos");
        System.out.println("----------------------------------------------");
    }

    public void getOptions() throws Exception {
        int regcount = 0;
        Statement s = this.dBConn.createStatement();
        ResultSet r = s.executeQuery("SELECT * FROM OPTIONS");
        while (r.next()) {
            ++regcount;
            this.ano_base = r.getInt("ano_base");
            this.ano_ini = r.getInt("ano_ini");
            this.ano_fin = r.getInt("ano_fin");
            if (this.ano_base <= 0 || this.ano_ini <= 0 || this.ano_fin <= 0) {
                throw new PIETException(" Dato erroneo o no encontrado en OPTIONS, PIETDB");
            }
            System.out.println("Ano Base: " + this.ano_base + " Ano Inicio:" + this.ano_ini + " Ano Fin:" + this.ano_fin);
        }
        s.close();
    }

    public void init() throws Exception {
        comp TempComponent;
        int ix;
        int count = 0;
        this.numzones = 0;
        for (ix = 0; ix < this.sch.Components.size(); ++ix) {
            TempComponent = (comp)this.sch.Components.elementAt(ix);
            if (!(TempComponent instanceof tdb_centroid)) continue;
            ++this.numzones;
        }
        this.mycentroids = new tdb_centroid[this.numzones];
        count = 0;
        for (ix = 0; ix < this.sch.Components.size(); ++ix) {
            TempComponent = (comp)this.sch.Components.elementAt(ix);
            if (!(TempComponent instanceof tdb_centroid)) continue;
            TempComponent.setName(TempComponent.getName().toUpperCase());
            this.mycentroids[count] = (tdb_centroid)TempComponent;
            ++count;
        }
        this.PEI = new double[this.ano_fin - this.ano_ini + 1][this.ENER.length];
        this.MED = new double[this.ano_fin - this.ano_ini + 1][this.ENER.length][this.Region.length];
        this.TESP = new double[this.ano_fin - this.ano_ini + 1][this.ENER.length];
        this.PED = new double[this.ano_fin - this.ano_ini + 1][this.ENER.length][this.numzones];
        this.D = new double[this.ano_fin - this.ano_ini + 1];
        this.IVA = new double[this.ano_fin - this.ano_ini + 1];
        this.T = new double[this.ano_fin - this.ano_ini + 1];
        this.idZoneRegion = new int[this.numzones];
    }

    public void getData() throws Exception {
        int k;
        int ano;
        int regcount = 0;
        boolean auxi = false;
        double value = 0.0;
        double valueTESP = 0.0;
        double valueMED = 0.0;
        double valueD = 0.0;
        double valueIVA = 0.0;
        double valueT = 0.0;
        boolean count = false;
        int auxi1 = 0;
        int auxi2 = 0;
        boolean auxi3 = false;
        boolean numcont = false;
        String auxs1 = "";
        String auxs2 = "";
        String zonaSt = "";
        String regionSt = "";
        String cont = "";
        Statement s = this.dBConn.createStatement();
        ResultSet r = s.executeQuery("SELECT * FROM PEI WHERE (ano>=" + this.ano_ini + ") AND (ano<=" + this.ano_fin + ") ORDER BY ano");
        System.out.print("---> PEI... ");
        while (r.next()) {
            ++regcount;
            ano = r.getInt("ano");
            auxs1 = r.getString("energetico");
            value = r.getDouble("PEI");
            if (ano < this.ano_ini || ano > this.ano_fin) continue;
            auxi1 = this.ENERnum(auxs1);
            if (auxi1 == -1) {
                throw new PIETException("No se encuentra ENERGETICO: " + auxs1 + " en base de datos PEI.!!");
            }
            this.PEI[ano - this.ano_ini][auxi1] = value;
        }
        System.out.println(" ok");
        System.out.print("---> MED... ");
        for (k = 0; k < this.Region.length; ++k) {
            r = s.executeQuery("SELECT * FROM MED WHERE (region='" + this.Region[k] + "') AND (ano>=" + this.ano_ini + ") AND (ano<=" + this.ano_fin + ") ORDER BY ano");
            while (r.next()) {
                ++regcount;
                ano = r.getInt("ano");
                auxs1 = r.getString("energetico");
                valueMED = r.getDouble("MED");
                auxi1 = this.ENERnum(auxs1);
                if (auxi1 == -1) {
                    throw new PIETException("ENERGETICO no valido: " + auxs1 + ", PietDB, Tabla 'MED'");
                }
                this.MED[ano - this.ano_ini][auxi1][k] = valueMED;
            }
        }
        System.out.println(" ok");
        r = s.executeQuery("SELECT * FROM TESP WHERE (ano>=" + this.ano_ini + ") AND (ano<=" + this.ano_fin + ") ORDER BY ano");
        System.out.print("---> TESP... ");
        while (r.next()) {
            ano = r.getInt("ano");
            auxs1 = r.getString("energetico");
            valueTESP = r.getDouble("TESP");
            auxi1 = this.ENERnum(auxs1);
            if (auxi1 == -1) {
                throw new PIETException("ENERGETICO no valido: " + auxs1 + ", PietDB, Tabla 'TESP'");
            }
            this.TESP[ano - this.ano_ini][auxi1] = valueTESP;
        }
        System.out.println(" ok");
        r = s.executeQuery("SELECT * FROM ED WHERE (ano>=" + this.ano_ini + ") AND (ano<=" + this.ano_fin + ") ORDER BY ano");
        System.out.print("---> ED... ");
        regcount = this.ano_ini - 1;
        int anoi = 0;
        while (r.next()) {
            ano = r.getInt("ano");
            if (ano != ++regcount) {
                throw new PIETException("No se encuentran Datos, ano " + regcount + " en tabla ED!!");
            }
            valueD = r.getDouble("D");
            valueIVA = r.getDouble("IVA");
            valueT = r.getDouble("T");
            anoi = ano - this.ano_ini;
            this.D[anoi] = valueD;
            this.T[anoi] = valueT / 100.0;
            this.IVA[anoi] = valueIVA / 100.0;
        }
        System.out.println(" ok");
        System.out.print("---> ZONA... ");
        for (k = 0; k < this.numzones; ++k) {
            this.idZoneRegion[k] = -1;
        }
        r = s.executeQuery("SELECT * FROM ZONA");
        while (r.next()) {
            zonaSt = r.getString("ZONA");
            regionSt = r.getString("region");
            auxi1 = this.zonenum(zonaSt);
            auxi2 = this.findId(this.Region, regionSt);
            if (auxi1 <= -1 || auxi2 <= -1) continue;
            this.idZoneRegion[auxi1] = auxi2;
        }
        for (k = 0; k < this.numzones; ++k) {
            if (this.idZoneRegion[k] != -1) continue;
            throw new PIETException("Provincia no asignada a Region '" + this.mycentroids[k].getName() + "', PietDB tabla ZONA");
        }
        System.out.println(" ok");
        s.close();
    }

    public void calcPED() throws Exception {
        System.out.print("------> calcPED... ");
        for (int i = 0; i < this.ano_fin - this.ano_ini + 1; ++i) {
            for (int j = 0; j < this.ENER.length; ++j) {
                for (int k = 0; k < this.numzones; ++k) {
                    this.PED[i][j][k] = this.PEI[i][j] * this.D[i] * (1.0 + this.T[i]) * (1.0 + this.IVA[i]) * (1.0 + this.TESP[i][j]) * (1.0 + this.MED[i][j][this.idZoneRegion[k]]);
                }
            }
        }
        System.out.println(" ok");
    }

    public int zonenum(String cname) {
        for (int k = 0; k < this.numzones; ++k) {
            tdb_centroid Tempcentroid = this.mycentroids[k];
            if (!Tempcentroid.getName().equals(cname)) continue;
            return k;
        }
        return -1;
    }

    public int regionnum(String regionname) {
        for (int r = 0; r < 13; ++r) {
            if (!this.Region[r].equals(regionname)) continue;
            return r;
        }
        return -1;
    }

    public String regionStr(int num) {
        if (num > -1 || num < 13) {
            return this.Region[num];
        }
        return "NONE";
    }

    public int contnum(String cname) {
        for (int i = 0; i < 5; ++i) {
            if (!this.Cont[i].equals(cname)) continue;
            return i;
        }
        return -1;
    }

    public int VEnum(String cname) {
        for (int ve = 0; ve < 5; ++ve) {
            if (!this.VE[ve].equals(cname)) continue;
            return ve;
        }
        return -1;
    }

    public int ENERnum(String cname) {
        for (int j = 0; j < this.ENER.length; ++j) {
            if (!this.ENER[j].equals(cname)) continue;
            return j;
        }
        return -1;
    }

    public void writeFilePEDArch() throws Exception {
        System.out.print("---------> writeFile  PED...");
        String auxs1 = "";
        String auxs2 = "";
        PrintWriter myPWriter = this.openPWFile("PED.txt");
        myPWriter.println("------------------------------------------------------");
        myPWriter.println("# Resultados de Precios dom\u00e9sticos de Energ\u00e9ticos");
        myPWriter.println("------------------------------------------------------");
        myPWriter.println(StringUtil.strformat("Zona", 15) + StringUtil.strformat("Regi\u00f3n", 5) + StringUtil.strformat("A\u00f1o", 10) + StringUtil.strformat("Energ\u00e9tico", 20) + StringUtil.strformat("PED", 20) + StringUtil.strformat("Unidad", 15));
        myPWriter.println("----------------------------------------------------------------------------------------------------------");
        for (int k = 0; k < this.numzones; ++k) {
            auxs1 = StringUtil.strformat(this.mycentroids[k].getName(), 15) + StringUtil.strformat(this.mycentroids[k].region, 5);
            for (int i = 0; i < this.ano_fin - this.ano_ini + 1; ++i) {
                auxs2 = StringUtil.strformat(this.ano_ini + i + "", 10);
                for (int j = 0; j < this.ENER.length; ++j) {
                    myPWriter.println(auxs1 + auxs2 + StringUtil.strformat(this.ENER[j], 20) + StringUtil.strformat(this.PED[i][j][k] + "", 20) + StringUtil.strformat(this.ENERUnit[j], 15));
                }
            }
        }
        myPWriter.flush();
        this.closeActFOS();
        System.out.println(" ok");
    }

    public void writeFilePED() throws Exception {
        System.out.print("------------> writeDB  PED...");
        String auxs1 = "";
        String auxs2 = "";
        try {
            Statement s = this.dBConn.createStatement();
            s.executeUpdate("DELETE * FROM PED");
            for (int k = 0; k < this.numzones; ++k) {
                for (int i = 0; i < this.ano_fin - this.ano_ini + 1; ++i) {
                    for (int j = 0; j < this.ENER.length; ++j) {
                        s.executeUpdate("INSERT INTO PED (ano,zona,energetico,unidad,PED)VALUES (" + (this.ano_ini + i) + ",'" + this.mycentroids[k].getName() + "','" + this.ENER[j] + "','" + this.ENERUnit[j] + "'," + this.PED[i][j][k] + ")");
                    }
                }
            }
            s.close();
        }
        catch (Exception e) {
            DeepEditFrame.MyPietEditFrame.showError(e);
            throw new PIETException("No se puede escribir: tabla PED");
        }
        System.out.println(" ok");
    }

    private PrintWriter openPWFile(String fname) throws Exception {
        this.ActFOS = new FileOutputStream(this.pietWorkPath + "\\" + fname);
        PrintWriter myWriter = new PrintWriter(this.ActFOS);
        return myWriter;
    }

    private void closeActFOS() throws Exception {
        this.ActFOS.close();
    }

    public int findId(String[] array, String name) {
        for (int i = 0; i < array.length; ++i) {
            if (!array[i].equals(name)) continue;
            return i;
        }
        return -1;
    }
}

