/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import de.core.DeepEdit;
import de.core.PIETException;
import de.core.PietSchematic;
import de.core.comp;
import de.core.tdb_centroid;
import de.utils.StringUtil;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;

public final class PIETE {
    private PietSchematic sch;
    private Connection dBConn;
    private DeepEdit applet;
    public int ano_ini = 2002;
    public int ano_base = 2001;
    public int ano_fin = 2012;
    public int numcat = 0;
    public int numzones = 0;
    public tdb_centroid[] mycentroids;
    private double[][][] FAU = null;
    private double[][][] Data = null;
    private double[][][] Activity = null;
    private double[][][] ActivityA = null;
    private double[][][] DataEmi = null;
    private double[][][] DataCom = null;
    private double[][][][] Emi = null;
    public String[] Cont = null;
    public String[] VE = null;
    String pietWorkPath = "..\\run\\PIETFiles\\Resultados";
    FileOutputStream ActFOS;

    PIETE(PietSchematic psch, Connection pdBConn, DeepEdit depApp) {
        this.sch = psch;
        this.dBConn = pdBConn;
        this.applet = depApp;
        boolean ix = false;
        System.out.println("--------------------------------------------");
        System.out.println("INICIO: Modelo  E L E C T R I C O");
        System.out.println("--------------------------------------------");
        try {
            this.getOptions();
            this.init();
            this.getData();
            this.getEmi();
            this.calcActivity();
            this.writeFileActivity();
            this.calcActivityA();
            this.writeFileActivityA();
            this.calcEmi();
            this.writeFileEmi();
        }
        catch (Exception e) {
            System.out.println("Problema en Rutina" + e);
            e.printStackTrace();
            return;
        }
        System.out.println("--------------------------------------------");
        System.out.println("FIN: Modelo de Actividad de Transporte");
        System.out.println("--------------------------------------------");
    }

    public void getOptions() throws Exception {
        int regcount = 0;
        double value = 0.0;
        Statement s = this.dBConn.createStatement();
        ResultSet r = s.executeQuery("SELECT * FROM OPTIONS");
        while (r.next()) {
            ++regcount;
            this.ano_base = r.getInt("ano_base");
            this.ano_ini = r.getInt("ano_ini");
            this.ano_fin = r.getInt("ano_fin");
            if (this.ano_base <= 0 || this.ano_ini <= 0 || this.ano_fin <= 0) {
                throw new PIETException(" Dato erroneo o no encontrado en OPTIONS, PIETDB");
            }
            System.out.println("A\u00f1o Base: " + this.ano_base + " A\u00f1o Inicio:" + this.ano_ini + " A\u00f1o Fin:" + this.ano_fin);
        }
        s.close();
    }

    public void init() throws Exception {
        comp TempComponent;
        int ix;
        int count = 0;
        boolean auxi1 = false;
        int auxi2 = 0;
        double value = 0.0;
        String auxs1 = "";
        String auxs2 = "";
        this.Cont = new String[5];
        this.Cont[0] = "co";
        this.Cont[1] = "hc";
        this.Cont[2] = "mp";
        this.Cont[3] = "nox";
        this.Cont[4] = "sox";
        this.VE = new String[5];
        this.VE[0] = "ingr_viv";
        this.VE[1] = "km";
        this.VE[2] = "pib";
        this.VE[3] = "pob";
        this.VE[4] = "sup";
        this.numzones = 0;
        for (ix = 0; ix < this.sch.Components.size(); ++ix) {
            TempComponent = (comp)this.sch.Components.elementAt(ix);
            if (!(TempComponent instanceof tdb_centroid)) continue;
            ++this.numzones;
        }
        this.mycentroids = new tdb_centroid[this.numzones];
        count = 0;
        for (ix = 0; ix < this.sch.Components.size(); ++ix) {
            TempComponent = (comp)this.sch.Components.elementAt(ix);
            if (!(TempComponent instanceof tdb_centroid)) continue;
            TempComponent.setName(TempComponent.getName().toUpperCase());
            this.mycentroids[count] = (tdb_centroid)TempComponent;
            ++count;
        }
        Statement s = this.dBConn.createStatement();
        ResultSet r = s.executeQuery("SELECT * FROM FAU order by subcat");
        this.numcat = 0;
        while (r.next()) {
            auxi2 = r.getInt("subcat");
            this.numcat = Math.max(this.numcat, auxi2);
        }
        System.out.println("N\u00famero de Categr\u00edas: " + this.numcat);
        this.FAU = new double[this.numcat][5][2];
        for (int i = 0; i < this.numcat; ++i) {
            for (int j = 0; j < 5; ++j) {
                for (int k = 0; k < 2; ++k) {
                    this.FAU[i][j][k] = 0.0;
                }
            }
        }
        r = s.executeQuery("SELECT * FROM FAU order by subcat,var_exp");
        int nnumcat = 0;
        count = 0;
        while (r.next()) {
            nnumcat = r.getInt("subcat") - 1;
            count = this.VEnum(r.getString("var_exp"));
            this.FAU[nnumcat][count][0] = r.getDouble("coef");
            this.FAU[nnumcat][count][1] = r.getDouble("pot");
        }
        s.close();
    }

    public void getData() throws Exception {
        int auxi;
        int ano;
        int i;
        int regcount = 0;
        String region = "";
        String zona = "";
        double value = 0.0;
        this.Data = new double[this.numzones][this.ano_fin - this.ano_ini + 1][5];
        for (i = 0; i < this.numzones; ++i) {
            for (int j = 0; j < this.ano_fin - this.ano_ini + 1; ++j) {
                for (int k = 0; k < 5; ++k) {
                    this.Data[i][j][k] = 0.0;
                }
            }
        }
        Statement s = this.dBConn.createStatement();
        ResultSet r = s.executeQuery("SELECT * FROM IPV ORDER BY ano");
        while (r.next()) {
            ++regcount;
            ano = r.getInt("ano");
            zona = r.getString("zona");
            value = r.getDouble("IPV");
            if (ano >= this.ano_ini && ano <= this.ano_fin) {
                auxi = this.zonenum(zona);
                if (auxi == -1) {
                    System.out.println("Advertencia: IPV No se encuentra Zona: " + zona + " en diagrama.!!");
                } else {
                    this.Data[auxi][ano - this.ano_ini][0] = value;
                }
            }
            System.out.println("Zona:" + zona + " Ano: " + ano + " IPV:" + value);
        }
        r = s.executeQuery("SELECT * FROM CAM ORDER BY ano");
        while (r.next()) {
            ++regcount;
            ano = r.getInt("ano");
            zona = r.getString("zona");
            value = r.getDouble("CAM");
            if (ano >= this.ano_ini && ano <= this.ano_fin) {
                auxi = this.zonenum(zona);
                if (auxi == -1) {
                    System.out.println("Advertencia: CAM No se encuentra Zona: " + zona + " en diagrama.!!");
                } else {
                    this.Data[auxi][ano - this.ano_ini][1] = value;
                }
            }
            System.out.println("Zona:" + zona + " Ano: " + ano + " km Camino:" + value);
        }
        r = s.executeQuery("SELECT * FROM PIB ORDER BY ano");
        while (r.next()) {
            ++regcount;
            ano = r.getInt("ano");
            region = r.getString("zona");
            value = r.getDouble("PIB");
            if (ano >= this.ano_ini && ano <= this.ano_fin) {
                for (i = 0; i < this.numzones; ++i) {
                    tdb_centroid Tempcentroid = this.mycentroids[i];
                    if (!Tempcentroid.region.equals(region)) continue;
                    this.Data[i][ano - this.ano_ini][2] = value;
                }
            }
            System.out.println("Regi\u00f3n:" + region + " Ano: " + ano + " PIB:" + value);
        }
        r = s.executeQuery("SELECT * FROM POB ORDER BY ano");
        while (r.next()) {
            ++regcount;
            ano = r.getInt("ano");
            zona = r.getString("zona");
            value = r.getDouble("POB");
            if (ano >= this.ano_ini && ano <= this.ano_fin) {
                auxi = this.zonenum(zona);
                if (auxi == -1) {
                    System.out.println("Advertencia: POB No se encuentra Zona: " + zona + " en diagrama.!!");
                } else {
                    this.Data[auxi][ano - this.ano_ini][3] = value;
                }
            }
            System.out.println("Zona:" + zona + " Ano: " + ano + " POB:" + value);
        }
        s = this.dBConn.createStatement();
        r = s.executeQuery("SELECT * FROM ZONA ORDER BY ano");
        while (r.next()) {
            ++regcount;
            ano = r.getInt("ano");
            zona = r.getString("zona");
            value = r.getDouble("superficie");
            for (i = 0; i < this.ano_fin - this.ano_ini + 1; ++i) {
                auxi = this.zonenum(zona);
                if (auxi == -1) {
                    System.out.println("Advertencia: ZONA No se encuentra Zona: " + zona + " en diagrama.!!");
                    continue;
                }
                this.Data[auxi][i][4] = value;
            }
            System.out.println("Zona:" + zona + " Ano: " + ano + " Supeficie:" + value);
        }
        s.close();
    }

    public void calcActivity() throws Exception {
        boolean regcount = false;
        String region = "";
        String zona = "";
        double value = 0.0;
        this.Activity = new double[this.numzones][this.ano_fin - this.ano_ini + 1][this.numcat];
        double[] fac = new double[5];
        double[] face = new double[17];
        fac[0] = 690507.7851498683;
        fac[1] = 12378.0;
        fac[2] = 1.58045294256E7;
        fac[3] = 5409484.0;
        fac[4] = 67602.0;
        face[0] = 1.098333682E9;
        face[1] = 1.098333682E9;
        face[2] = 1.098333682E9;
        face[3] = 1.098333682E9;
        face[4] = 5.7292595E8;
        face[5] = 3.95031E8;
        face[6] = 3.39434E8;
        face[7] = 2.4092E8;
        face[8] = 2.38956E8;
        face[9] = 2.00095407E8;
        face[10] = 2.239197E9;
        face[11] = 2.48674E8;
        face[12] = 7.644743252E9;
        face[13] = 2.19376988E9;
        face[14] = 1.18087E8;
        face[15] = 3.253576616E9;
        face[16] = 1.12257281E9;
        for (int i = 0; i < this.numzones; ++i) {
            for (int j = 0; j < this.ano_fin - this.ano_ini + 1; ++j) {
                for (int k = 0; k < this.numcat; ++k) {
                    this.Activity[i][j][k] = 0.0;
                    for (int ve = 0; ve < 5; ++ve) {
                        if (this.Data[i][j][ve] == 0.0) continue;
                        double[] dArray = this.Activity[i][j];
                        int n = k;
                        dArray[n] = dArray[n] + this.FAU[k][ve][0] * Math.pow(this.Data[i][j][ve] / fac[ve], this.FAU[k][ve][1]);
                    }
                    double[] dArray = this.Activity[i][j];
                    int n = k;
                    dArray[n] = dArray[n] * face[k];
                }
            }
        }
    }

    public void calcActivityA() throws Exception {
        this.ActivityA = new double[this.numzones][this.ano_fin - this.ano_ini + 1][4];
        for (int i = 0; i < this.numzones; ++i) {
            for (int j = 0; j < this.ano_fin - this.ano_ini + 1; ++j) {
                int l;
                for (l = 0; l < 5; ++l) {
                    double[] dArray = this.ActivityA[i][j];
                    dArray[0] = dArray[0] + this.Activity[i][j][l];
                }
                for (l = 5; l < 12; ++l) {
                    double[] dArray = this.ActivityA[i][j];
                    dArray[1] = dArray[1] + this.Activity[i][j][l];
                }
                for (l = 12; l < 15; ++l) {
                    double[] dArray = this.ActivityA[i][j];
                    dArray[2] = dArray[2] + this.Activity[i][j][l];
                }
                for (l = 15; l < 17; ++l) {
                    double[] dArray = this.ActivityA[i][j];
                    dArray[3] = dArray[3] + this.Activity[i][j][l];
                }
            }
        }
    }

    public void getEmi() throws Exception {
        int ano;
        int i;
        int auxi;
        int regcount = 0;
        String region = "";
        String zona = "";
        String co = "";
        double value = 0.0;
        this.DataEmi = new double[this.numzones][5][18];
        this.DataCom = new double[this.numzones][this.ano_fin - this.ano_ini + 1][18];
        Statement s = this.dBConn.createStatement();
        ResultSet r = s.executeQuery("SELECT * FROM FE_TP");
        while (r.next()) {
            ++regcount;
            co = r.getString("co");
            zona = r.getString("zona");
            auxi = this.zonenum(zona);
            if (auxi < 0) continue;
            for (i = 0; i < 9; ++i) {
                this.DataEmi[auxi][this.contnum((String)co)][i] = r.getDouble("sub_" + (i + 1));
            }
        }
        r = s.executeQuery("SELECT * FROM FE_CARGA");
        while (r.next()) {
            ++regcount;
            co = r.getString("co");
            zona = r.getString("zona");
            auxi = this.zonenum(zona);
            if (auxi < 0) continue;
            for (i = 9; i < 13; ++i) {
                this.DataEmi[auxi][this.contnum((String)co)][i] = r.getDouble("sub_" + (i + 1));
            }
        }
        r = s.executeQuery("SELECT * FROM FE_VLP");
        while (r.next()) {
            ++regcount;
            co = r.getString("co");
            zona = r.getString("zona");
            auxi = this.zonenum(zona);
            if (auxi < 0) continue;
            for (i = 13; i < 16; ++i) {
                this.DataEmi[auxi][this.contnum((String)co)][i] = r.getDouble("sub_" + (i + 1));
            }
        }
        r = s.executeQuery("SELECT * FROM FE_VLC");
        while (r.next()) {
            ++regcount;
            co = r.getString("co");
            zona = r.getString("zona");
            auxi = this.zonenum(zona);
            if (auxi < 0) continue;
            for (i = 16; i < 18; ++i) {
                this.DataEmi[auxi][this.contnum((String)co)][i] = r.getDouble("sub_" + (i + 1));
            }
        }
        s = this.dBConn.createStatement();
        r = s.executeQuery("SELECT * FROM COMP_TP");
        while (r.next()) {
            ++regcount;
            ano = r.getInt("ano");
            zona = r.getString("zona");
            auxi = this.zonenum(zona);
            if (auxi < 0 || ano > this.ano_fin || ano < this.ano_ini) continue;
            for (i = 0; i < 9; ++i) {
                this.DataCom[auxi][ano - this.ano_ini][i] = r.getDouble("sub_" + (i + 1));
            }
        }
        r = s.executeQuery("SELECT * FROM COMP_CARGA");
        while (r.next()) {
            ++regcount;
            ano = r.getInt("ano");
            zona = r.getString("zona");
            auxi = this.zonenum(zona);
            if (auxi < 0 || ano > this.ano_fin || ano < this.ano_ini) continue;
            for (i = 9; i < 13; ++i) {
                this.DataCom[auxi][ano - this.ano_ini][i] = r.getDouble("sub_" + (i + 1));
            }
        }
        r = s.executeQuery("SELECT * FROM COMP_VLP");
        while (r.next()) {
            ++regcount;
            ano = r.getInt("ano");
            zona = r.getString("zona");
            auxi = this.zonenum(zona);
            if (auxi < 0 || ano > this.ano_fin || ano < this.ano_ini) continue;
            for (i = 13; i < 16; ++i) {
                this.DataCom[auxi][ano - this.ano_ini][i] = r.getDouble("sub_" + (i + 1));
            }
        }
        r = s.executeQuery("SELECT * FROM COMP_VLC");
        while (r.next()) {
            ++regcount;
            ano = r.getInt("ano");
            zona = r.getString("zona");
            auxi = this.zonenum(zona);
            if (auxi < 0 || ano > this.ano_fin || ano < this.ano_ini) continue;
            for (i = 16; i < 18; ++i) {
                this.DataCom[auxi][ano - this.ano_ini][i] = r.getDouble("sub_" + (i + 1));
            }
        }
        s.close();
    }

    public void calcEmi() throws Exception {
        int l;
        int k;
        int j;
        int i;
        this.Emi = new double[this.numzones][this.ano_fin - this.ano_ini + 1][4][5];
        for (i = 0; i < this.numzones; ++i) {
            for (j = 0; j < this.ano_fin - this.ano_ini + 1; ++j) {
                for (k = 0; k < 5; ++k) {
                    for (l = 0; l < 4; ++l) {
                        this.Emi[i][j][l][k] = 0.0;
                    }
                }
            }
        }
        for (i = 0; i < this.numzones; ++i) {
            for (j = 0; j < this.ano_fin - this.ano_ini + 1; ++j) {
                k = 0;
                while (k < 5) {
                    for (l = 0; l < 9; ++l) {
                        double[] dArray = this.Emi[i][j][0];
                        int n = k;
                        dArray[n] = dArray[n] + this.DataEmi[i][k][l] * this.DataCom[i][j][l] / 100.0;
                    }
                    for (l = 9; l < 13; ++l) {
                        double[] dArray = this.Emi[i][j][1];
                        int n = k;
                        dArray[n] = dArray[n] + this.DataEmi[i][k][l] * this.DataCom[i][j][l] / 100.0;
                    }
                    for (l = 13; l < 16; ++l) {
                        double[] dArray = this.Emi[i][j][2];
                        int n = k;
                        dArray[n] = dArray[n] + this.DataEmi[i][k][l] * this.DataCom[i][j][l] / 100.0;
                    }
                    for (l = 16; l < 18; ++l) {
                        double[] dArray = this.Emi[i][j][3];
                        int n = k;
                        dArray[n] = dArray[n] + this.DataEmi[i][k][l] * this.DataCom[i][j][l] / 100.0;
                    }
                    double[] dArray = this.Emi[i][j][0];
                    int n = k;
                    dArray[n] = dArray[n] * (this.ActivityA[i][j][0] / 1000000.0);
                    double[] dArray2 = this.Emi[i][j][1];
                    int n2 = k;
                    dArray2[n2] = dArray2[n2] * (this.ActivityA[i][j][1] / 1000000.0);
                    double[] dArray3 = this.Emi[i][j][2];
                    int n3 = k;
                    dArray3[n3] = dArray3[n3] * (this.ActivityA[i][j][2] / 1000000.0);
                    double[] dArray4 = this.Emi[i][j][3];
                    int n4 = k++;
                    dArray4[n4] = dArray4[n4] * (this.ActivityA[i][j][3] / 1000000.0);
                }
            }
        }
    }

    public int zonenum(String cname) {
        for (int i = 0; i < this.numzones; ++i) {
            tdb_centroid Tempcentroid = this.mycentroids[i];
            if (!Tempcentroid.getName().equals(cname)) continue;
            return i;
        }
        System.out.println("Caution: zonenum =" + cname);
        return -1;
    }

    public int contnum(String cname) {
        for (int i = 0; i < 5; ++i) {
            if (!this.Cont[i].equals(cname)) continue;
            return i;
        }
        System.out.println("Caution: contnum =" + cname);
        return -1;
    }

    public int VEnum(String cname) {
        for (int i = 0; i < 5; ++i) {
            if (!this.VE[i].equals(cname)) continue;
            return i;
        }
        System.out.println("Caution: VE num =" + cname);
        return -1;
    }

    public void writeFileActivity() throws Exception {
        String auxs1 = "";
        String auxs2 = "";
        PrintWriter myPWriter = this.openPWFile("FFActivity.txt");
        myPWriter.println("----------------------------------");
        myPWriter.println("# Resultados del Modelo FF");
        myPWriter.println("----------------------------------");
        myPWriter.println(StringUtil.strformat("Zona", 15) + " " + StringUtil.strformat("Regi\u00f3n", 5) + "  A\u00f1o  " + "  Subcategor\u00eda  " + " Actividad [Veh-km/a\u00f1o]");
        myPWriter.println("-----------------------------------------------------------------------------------------------");
        for (int i = 0; i < this.numzones; ++i) {
            auxs1 = StringUtil.strformat(this.mycentroids[i].getName(), 15) + " " + StringUtil.strformat(this.mycentroids[i].region, 5) + " ";
            for (int j = 0; j < this.ano_fin - this.ano_ini + 1; ++j) {
                auxs2 = this.ano_ini + j + " ";
                for (int k = 0; k < this.numcat; ++k) {
                    myPWriter.println(auxs1 + auxs2 + " Sub_" + (k + 1) + " " + this.Activity[i][j][k]);
                }
            }
        }
        myPWriter.flush();
        this.closeActFOS();
    }

    public void writeFileActivityA() throws Exception {
        String auxs1 = "";
        String auxs2 = "";
        PrintWriter myPWriter = this.openPWFile("FFActivityA.txt");
        myPWriter.println("----------------------------------");
        myPWriter.println("# Resultados del Modelo FF Agregado");
        myPWriter.println("----------------------------------");
        myPWriter.println(StringUtil.strformat("Zona", 15) + " " + StringUtil.strformat("Regi\u00f3n", 5) + "  A\u00f1o  " + "  Categor\u00eda  " + " Actividad [Veh-km/a\u00f1o]");
        myPWriter.println("-----------------------------------------------------------------------------------------------");
        for (int i = 0; i < this.numzones; ++i) {
            auxs1 = StringUtil.strformat(this.mycentroids[i].getName(), 15) + " " + StringUtil.strformat(this.mycentroids[i].region, 5) + " ";
            for (int j = 0; j < this.ano_fin - this.ano_ini + 1; ++j) {
                auxs2 = this.ano_ini + j + " ";
                for (int k = 0; k < 4; ++k) {
                    myPWriter.println(auxs1 + auxs2 + " Cat_" + (k + 1) + " " + this.ActivityA[i][j][k]);
                }
            }
        }
        myPWriter.flush();
        this.closeActFOS();
        try {
            Statement s = this.dBConn.createStatement();
            s.executeUpdate("DELETE * FROM ACTFF");
            for (int i = 0; i < this.numzones; ++i) {
                auxs1 = StringUtil.strformat(this.mycentroids[i].getName(), 15) + " " + StringUtil.strformat(this.mycentroids[i].region, 5) + " ";
                for (int j = 0; j < this.ano_fin - this.ano_ini + 1; ++j) {
                    auxs2 = this.ano_ini + j + " ";
                    for (int k = 0; k < 4; ++k) {
                        s.executeUpdate("INSERT INTO ACTFF (ano,zona,Modo,unidad,ACTFF)VALUES (" + (this.ano_ini + j) + ",'" + this.mycentroids[i].getName() + "','" + "Cat_" + (k + 1) + "','" + "Veh-km/a\u00f1o" + "'," + this.ActivityA[i][j][k] + ")");
                    }
                }
            }
            s.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("al escribir PIETDB: tabla ACTFF");
        }
    }

    public void writeFileEmi() throws Exception {
        String auxs1 = "";
        String auxs2 = "";
        PrintWriter myPWriter = this.openPWFile("FFEmi.txt");
        myPWriter.println("----------------------------------");
        myPWriter.println("# Resultados de Emisiones Modelo FF");
        myPWriter.println("----------------------------------");
        myPWriter.println(StringUtil.strformat("Zona", 15) + " " + StringUtil.strformat("Regi\u00f3n", 5) + "  A\u00f1o  " + "  Categor\u00eda  " + " Contaminante" + " Emisi\u00f3n [ton/a\u00f1o]");
        myPWriter.println("--------------------------------------------------------------------------------------------------------------------------");
        for (int i = 0; i < this.numzones; ++i) {
            auxs1 = StringUtil.strformat(this.mycentroids[i].getName(), 15) + " " + StringUtil.strformat(this.mycentroids[i].region, 5) + " ";
            for (int j = 0; j < this.ano_fin - this.ano_ini + 1; ++j) {
                auxs2 = this.ano_ini + j + " ";
                for (int k = 0; k < 4; ++k) {
                    myPWriter.println(auxs1 + auxs2 + " Cat_" + (k + 1) + " " + "co" + " " + this.Emi[i][j][k][0]);
                    myPWriter.println(auxs1 + auxs2 + " Cat_" + (k + 1) + " " + "hc" + " " + this.Emi[i][j][k][1]);
                    myPWriter.println(auxs1 + auxs2 + " Cat_" + (k + 1) + " " + "mp" + " " + this.Emi[i][j][k][2]);
                    myPWriter.println(auxs1 + auxs2 + " Cat_" + (k + 1) + " " + "nox" + " " + this.Emi[i][j][k][3]);
                    myPWriter.println(auxs1 + auxs2 + " Cat_" + (k + 1) + " " + "sox" + " " + this.Emi[i][j][k][4]);
                }
            }
        }
        myPWriter.flush();
        this.closeActFOS();
        try {
            Statement s = this.dBConn.createStatement();
            s.executeUpdate("DELETE * FROM EMIFF");
            for (int i = 0; i < this.numzones; ++i) {
                auxs1 = StringUtil.strformat(this.mycentroids[i].getName(), 15) + " " + StringUtil.strformat(this.mycentroids[i].region, 5) + " ";
                for (int j = 0; j < this.ano_fin - this.ano_ini + 1; ++j) {
                    auxs2 = this.ano_ini + j + " ";
                    for (int k = 0; k < 4; ++k) {
                        s.executeUpdate("INSERT INTO EMIFF (ano,zona,Modo,Cont,unidad,EMIFF)VALUES (" + (this.ano_ini + j) + ",'" + this.mycentroids[i].getName() + "','" + "Cat_" + (k + 1) + "','" + "co" + "','" + "ton/a\u00f1o" + "'," + this.Emi[i][j][k][0] + ")");
                        s.executeUpdate("INSERT INTO EMIFF (ano,zona,Modo,Cont,unidad,EMIFF)VALUES (" + (this.ano_ini + j) + ",'" + this.mycentroids[i].getName() + "','" + "Cat_" + (k + 1) + "','" + "hc" + "','" + "ton/a\u00f1o" + "'," + this.Emi[i][j][k][1] + ")");
                        s.executeUpdate("INSERT INTO EMIFF (ano,zona,Modo,Cont,unidad,EMIFF)VALUES (" + (this.ano_ini + j) + ",'" + this.mycentroids[i].getName() + "','" + "Cat_" + (k + 1) + "','" + "mp" + "','" + "ton/a\u00f1o" + "'," + this.Emi[i][j][k][2] + ")");
                        s.executeUpdate("INSERT INTO EMIFF (ano,zona,Modo,Cont,unidad,EMIFF)VALUES (" + (this.ano_ini + j) + ",'" + this.mycentroids[i].getName() + "','" + "Cat_" + (k + 1) + "','" + "nox" + "','" + "ton/a\u00f1o" + "'," + this.Emi[i][j][k][3] + ")");
                        s.executeUpdate("INSERT INTO EMIFF (ano,zona,Modo,Cont,unidad,EMIFF)VALUES (" + (this.ano_ini + j) + ",'" + this.mycentroids[i].getName() + "','" + "Cat_" + (k + 1) + "','" + "sox" + "','" + "ton/a\u00f1o" + "'," + this.Emi[i][j][k][4] + ")");
                    }
                }
            }
            s.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("al escribir PIETDB: tabla ACTFF");
        }
    }

    private PrintWriter openPWFile(String fname) throws Exception {
        this.ActFOS = new FileOutputStream(this.pietWorkPath + "\\" + fname);
        PrintWriter myWriter = new PrintWriter(this.ActFOS);
        return myWriter;
    }

    private void closeActFOS() throws Exception {
        this.ActFOS.close();
    }
}

