/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import de.core.DeepEdit;
import de.core.JImagePanel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;

public class OverviewFrame
extends JDialog {
    private static final String newline = "\n";
    private DeepEdit applet;
    private Image miimage = null;
    private JImagePanel ImagePane = null;
    private int www = 0;
    private int hhh = 0;
    public double facx = 0.0;
    public double facy = 0.0;

    public OverviewFrame(DeepEdit app) {
        super((Frame)DeepEdit.frame, "DeepEdit Overview System");
        this.applet = app;
        this.addNotify();
        JButton openButton = new JButton("Close");
        openButton.setFont(DeepEdit.TextFont);
        openButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OverviewFrame.this.miimage = null;
                OverviewFrame.this.dispose();
                ((OverviewFrame)OverviewFrame.this).applet.MyOverviewFrame = null;
            }
        });
        JButton saveButton = new JButton("Refresh");
        saveButton.setFont(DeepEdit.TextFont);
        saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("Update Overview");
                OverviewFrame.this.updateImage();
                OverviewFrame.this.validate();
                OverviewFrame.this.setVisible(true);
            }
        });
        JButton printButton = new JButton("Print");
        printButton.setFont(DeepEdit.TextFont);
        printButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("Overview to JPG File Tool (results/Overview.jpg)");
                try {
                    OverviewFrame.this.applet;
                    OverviewFrame.writeImageToJPG("results/Overview.jpg", DeepEdit.frame.overview2jpg());
                }
                catch (IOException ie) {
                    ie.printStackTrace();
                }
            }
        });
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(openButton);
        buttonPanel.add(saveButton);
        buttonPanel.add(printButton);
        openButton.setNextFocusableComponent(saveButton);
        saveButton.setNextFocusableComponent(openButton);
        printButton.setNextFocusableComponent(printButton);
        Container contentPane = this.getContentPane();
        contentPane.add((Component)buttonPanel, "North");
        if (this.ImagePane != null) {
            this.remove(this.ImagePane);
        }
        this.ImagePane = this.getOverviewPane();
        contentPane.add((Component)this.ImagePane, "Center");
        this.setSize(this.ImagePane.image.getWidth(this.ImagePane) + 6, this.ImagePane.image.getHeight(this.ImagePane) + 58);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                OverviewFrame.this.miimage = null;
                ((OverviewFrame)OverviewFrame.this).applet.MyOverviewFrame = null;
                OverviewFrame.this.dispose();
            }
        });
        this.setResizable(false);
        this.setLocationRelativeTo(DeepEdit.frame);
        this.setLocation(DeepEdit.frame.getWidth() - this.getWidth(), 0);
        this.setVisible(false);
    }

    public final JImagePanel getOverviewPane() {
        if (this.ImagePane == null) {
            this.miimage = DeepEdit.frame.overviewAction();
            this.www = this.miimage.getWidth(DeepEdit.frame);
            this.hhh = this.miimage.getHeight(DeepEdit.frame);
            this.ImagePane = (double)this.hhh / (double)this.www >= 4.5 ? new JImagePanel(this.miimage.getScaledInstance(-1, 650, 16), this) : ((double)this.hhh / (double)this.www < 2.6 && (double)(this.hhh * this.www) > 50000.0 ? new JImagePanel(this.miimage.getScaledInstance(250, -1, 16), this) : new JImagePanel(this.miimage.getScaledInstance(150, -1, 16), this));
        }
        this.updateImage();
        return this.ImagePane;
    }

    public static void writeImageToJPG(String filename, Image bufferedImage) throws IOException {
        File f = new File(filename);
        ImageIO.write((RenderedImage)((BufferedImage)bufferedImage), "jpg", f);
    }

    public void updateImage() {
        this.facx = (double)this.ImagePane.image.getWidth(this.ImagePane) / (double)this.www;
        this.facy = (double)this.ImagePane.image.getHeight(this.ImagePane) / (double)this.hhh;
        this.ImagePane.xx = (int)((double)DeepEdit.MySchematicPanel.GridXOffset * this.facx);
        this.ImagePane.yy = (int)((double)DeepEdit.MySchematicPanel.GridYOffset * this.facy);
        OverviewFrame overviewFrame = this;
        this.ImagePane.ww = (int)((double)DeepEdit.MySchematicPanel.getSize().width * this.facx / (double)overviewFrame.applet.getGridStep());
        OverviewFrame overviewFrame2 = this;
        this.ImagePane.hh = (int)((double)DeepEdit.MySchematicPanel.getSize().height * this.facy / (double)overviewFrame2.applet.getGridStep());
        this.ImagePane.repaint();
    }
}

