/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import de.core.DeepEdit;
import de.core.SimpleDialog;
import de.utils.StringUtil;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Color;
import java.awt.Event;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.TextField;

class OptionsFrame
extends Frame {
    DeepEdit applet;
    String sysname;
    String sref;
    String iniperiod;
    String endperiod;
    String actperiod;
    String actmonth;
    String stepperiod;
    String intrate;
    String scale;
    protected Font TextDialogFont;
    protected FontMetrics TextDialogFontMetrics;
    boolean peaksim;
    boolean customsim;
    boolean meansim;
    boolean lowsim;
    Checkbox peakCheckbox;
    Checkbox customCheckbox;
    Checkbox meanCheckbox;
    Checkbox lowCheckbox;
    TextField MyTextField1 = null;
    TextField MyTextField2 = null;
    TextField MyTextField3 = null;
    TextField MyTextField4 = null;
    TextField MyTextField5 = null;
    TextField MyTextField6 = null;
    TextField MyTextField7 = null;
    TextField MyTextField8 = null;

    public OptionsFrame(DeepEdit app) {
        super("DeepEdit Simulation Options");
        this.setBackground(Color.lightGray);
        this.applet = app;
        this.sysname = String.valueOf(DeepEdit.MySchematic.getsysname());
        this.sref = String.valueOf(DeepEdit.MySchematic.getsref());
        this.scale = String.valueOf(DeepEdit.MySchematic.getloadfac2() * 100.0);
        this.iniperiod = String.valueOf(DeepEdit.MySchematic.getiniperiod());
        this.endperiod = String.valueOf(DeepEdit.MySchematic.getendperiod());
        this.actperiod = String.valueOf(DeepEdit.MySchematic.getactperiod());
        this.stepperiod = String.valueOf(DeepEdit.MySchematic.getstepperiod());
        this.peaksim = DeepEdit.MySchematic.getpeaksim();
        this.customsim = DeepEdit.MySchematic.getcustomsim();
        this.meansim = DeepEdit.MySchematic.getmeansim();
        this.lowsim = DeepEdit.MySchematic.getlowsim();
        this.intrate = String.valueOf(DeepEdit.MySchematic.getintrate());
        this.TextDialogFont = DeepEdit.TextFont;
        this.TextDialogFontMetrics = this.getFontMetrics(this.TextDialogFont);
        this.setFont(this.TextDialogFont);
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        this.setLayout(gridbag);
        c.fill = 0;
        c.weightx = 1.0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.anchor = 13;
        this.makeLabel("SYSTEM NAME:", gridbag, c, Color.blue);
        c.anchor = 17;
        c.gridx = 1;
        c.gridwidth = 1;
        c.gridwidth = 0;
        this.MyTextField1 = this.makeTField(this.sysname, gridbag, c, 16);
        c.gridwidth = 6;
        c.gridx = -1;
        c.weightx = 0.0;
        c.gridwidth = 0;
        this.makeLabel(" ", gridbag, c);
        c.anchor = 10;
        c.gridwidth = 0;
        this.makeLabel("OPERATION INFORMATION", gridbag, c, Color.blue);
        c.gridwidth = 6;
        c.anchor = 17;
        this.makeLabel("Reference Power:", gridbag, c);
        this.MyTextField2 = this.makeTField(this.sref, gridbag, c, 10);
        this.makeLabel("MVA", gridbag, c);
        this.makeLabel("", gridbag, c);
        this.makeLabel("", gridbag, c);
        c.gridwidth = 0;
        this.makeLabel("", gridbag, c);
        c.gridwidth = 6;
        c.gridx = -1;
        c.weightx = 0.0;
        c.gridwidth = 0;
        this.makeLabel(" ", gridbag, c);
        c.anchor = 10;
        c.gridwidth = 0;
        this.makeLabel("SIMULATION INFORMATION", gridbag, c, Color.blue);
        c.anchor = 10;
        c.gridwidth = 0;
        this.makeLabel(" ", gridbag, c);
        c.gridwidth = 0;
        this.makeLabel("Time Horizon Information", gridbag, c);
        c.gridwidth = 6;
        c.anchor = 17;
        this.makeLabel("Initial Period:", gridbag, c);
        this.MyTextField3 = this.makeTField(this.iniperiod, gridbag, c, 10);
        this.makeLabel("year", gridbag, c);
        this.makeLabel("End Period:", gridbag, c);
        this.MyTextField4 = this.makeTField(this.endperiod, gridbag, c, 10);
        c.gridwidth = 0;
        this.makeLabel("year", gridbag, c);
        c.gridwidth = 6;
        c.anchor = 17;
        this.makeLabel("Current Period:", gridbag, c);
        this.MyTextField5 = this.makeTField(this.actperiod, gridbag, c, 10);
        this.makeLabel("year", gridbag, c);
        this.makeLabel("Period Step:", gridbag, c);
        this.MyTextField6 = this.makeTField(this.stepperiod, gridbag, c, 10);
        c.gridwidth = 0;
        this.makeLabel("year", gridbag, c);
        c.gridwidth = 0;
        this.makeLabel("Simulation Type", gridbag, c);
        c.gridwidth = 6;
        c.anchor = 17;
        CheckboxGroup myCheckboxgroup = new CheckboxGroup();
        this.peakCheckbox = new Checkbox("peak load   ", myCheckboxgroup, this.peaksim);
        this.add(this.peakCheckbox);
        this.makeLabel("", gridbag, c);
        this.makeLabel("", gridbag, c);
        this.meanCheckbox = new Checkbox("mean load   ", myCheckboxgroup, this.meansim);
        this.add(this.meanCheckbox);
        c.gridwidth = 0;
        this.makeLabel("", gridbag, c);
        c.gridwidth = 6;
        c.anchor = 17;
        this.lowCheckbox = new Checkbox("low load    ", myCheckboxgroup, this.lowsim);
        this.add(this.lowCheckbox);
        this.makeLabel("", gridbag, c);
        this.makeLabel("", gridbag, c);
        this.customCheckbox = new Checkbox("custom load ", myCheckboxgroup, this.customsim);
        this.add(this.customCheckbox);
        c.gridwidth = 0;
        this.makeLabel("", gridbag, c);
        c.gridwidth = 6;
        c.anchor = 17;
        this.makeLabel("Custom scale factor:", gridbag, c);
        this.MyTextField8 = this.makeTField(this.scale, gridbag, c, 10);
        this.makeLabel("%", gridbag, c);
        this.makeLabel("", gridbag, c);
        this.makeLabel("", gridbag, c);
        c.gridwidth = 0;
        this.makeLabel("", gridbag, c);
        c.anchor = 10;
        c.gridwidth = 0;
        this.makeLabel(" ", gridbag, c);
        c.gridwidth = 0;
        this.makeLabel("ECONOMIC INFORMATION", gridbag, c, Color.blue);
        c.gridwidth = 6;
        c.anchor = 13;
        this.makeLabel("Interest Rate:", gridbag, c);
        this.MyTextField7 = this.makeTField(this.intrate, gridbag, c, 10);
        this.makeLabel("%/year", gridbag, c);
        this.makeLabel("", gridbag, c);
        this.makeLabel("", gridbag, c);
        c.gridwidth = 0;
        this.makeLabel("", gridbag, c);
        c.gridwidth = 0;
        this.makeLabel(" ", gridbag, c);
        c.anchor = 10;
        c.gridwidth = 8;
        this.makeLabel(" ", gridbag, c);
        this.makeButton("OK", gridbag, c);
        this.makeLabel(" ", gridbag, c);
        this.makeButton("Cancel", gridbag, c);
        this.makeLabel(" ", gridbag, c);
        this.makeLabel(" ", gridbag, c);
        this.makeButton("Advanced", gridbag, c);
        c.gridwidth = 0;
        this.makeLabel(" ", gridbag, c);
        this.setIconImage(this.applet.getFrameIconImage());
        this.pack();
        this.setVisible(true);
    }

    public void makeButton(String name, GridBagLayout gridbag, GridBagConstraints c) {
        Button button = new Button(name);
        gridbag.setConstraints(button, c);
        this.add(button);
    }

    public void makeLabel(String name, GridBagLayout gridbag, GridBagConstraints c) {
        Label label = new Label(name);
        gridbag.setConstraints(label, c);
        this.add(label);
    }

    public TextField makeTField(String content, GridBagLayout gridbag, GridBagConstraints c, int width) {
        TextField tfield = new TextField(content, width);
        gridbag.setConstraints(tfield, c);
        this.add(tfield);
        return tfield;
    }

    public Checkbox makeCheckbox(String content, GridBagLayout gridbag, GridBagConstraints c, boolean b) {
        Checkbox Cbox = new Checkbox(content, null, b);
        gridbag.setConstraints(Cbox, c);
        this.add(Cbox);
        return Cbox;
    }

    @Override
    public boolean handleEvent(Event ev) {
        if (ev.id == 201) {
            this.setVisible(false);
            this.applet.MyOptionsFrame = null;
            return true;
        }
        return super.handleEvent(ev);
    }

    public void SetNewValues() {
        try {
            DeepEdit.MySchematic.setsysname(StringUtil.trimAndUndercore(this.MyTextField1.getText()));
            DeepEdit.MySchematic.setsref(Double.valueOf(this.MyTextField2.getText()));
            int auxini = Integer.parseInt(this.MyTextField3.getText());
            int auxend = Integer.parseInt(this.MyTextField4.getText());
            int auxstep = Integer.parseInt(this.MyTextField6.getText());
            int auxact = Integer.parseInt(this.MyTextField5.getText());
            if (auxend < auxini) {
                auxend = auxini;
            }
            if (auxact < auxini) {
                auxact = auxini;
            }
            if (auxact > auxend) {
                auxact = auxend;
            }
            if (auxstep > auxend - auxini) {
                auxstep = auxend - auxini;
            }
            DeepEdit.MySchematic.setiniperiod(auxini);
            DeepEdit.MySchematic.setendperiod(auxend);
            DeepEdit.MySchematic.setactperiod(auxact);
            DeepEdit.MySchematic.setstepperiod(auxstep);
            DeepEdit.MySchematic.setintrate(Double.valueOf(this.MyTextField7.getText()));
            DeepEdit.MySchematic.setpeaksim(this.peakCheckbox.getState());
            DeepEdit.MySchematic.setcustomsim(this.customCheckbox.getState());
            DeepEdit.MySchematic.setmeansim(this.meanCheckbox.getState());
            DeepEdit.MySchematic.setlowsim(this.lowCheckbox.getState());
            if (this.peakCheckbox.getState()) {
                DeepEdit.MySchematic.setloadfac1(0.0);
                DeepEdit.MySchematic.setloadfac2(1.0);
            } else if (this.meanCheckbox.getState()) {
                DeepEdit.MySchematic.setloadfac1(0.5);
                DeepEdit.MySchematic.setloadfac2(0.5);
            } else if (this.lowCheckbox.getState()) {
                DeepEdit.MySchematic.setloadfac1(1.0);
                DeepEdit.MySchematic.setloadfac2(0.0);
            } else {
                DeepEdit.MySchematic.setloadfac1(0.0);
                DeepEdit.MySchematic.setloadfac2(Double.valueOf(this.MyTextField8.getText()) / 100.0);
            }
        }
        catch (Exception e) {
            String message = e.toString();
            String[] DlgButtons = new String[]{"OK"};
            SimpleDialog ExceptionDialog = new SimpleDialog(DeepEdit.frame, "Reading Options information", message, DlgButtons, 1, 0, 0, 1);
        }
        this.repaint();
    }

    public void makeLabel(String name, GridBagLayout gridbag, GridBagConstraints c, Color cl) {
        Label label = new Label(name);
        gridbag.setConstraints(label, c);
        label.setForeground(cl);
        this.add(label);
    }

    @Override
    public boolean action(Event ev, Object arg) {
        if (ev.target instanceof Button) {
            String label = (String)arg;
            if (arg.equals("Cancel")) {
                this.setVisible(false);
                this.applet.MyOptionsFrame = null;
                return true;
            }
            if (arg.equals("OK")) {
                this.SetNewValues();
                DeepEdit.updateTime();
                this.setVisible(false);
                this.applet.MyOptionsFrame = null;
                return true;
            }
            if (arg.equals("Advanced")) {
                DeepEdit.showSchematicParameterGUI();
            }
        }
        return false;
    }
}

