/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import de.core.GaSerialEstadistica;
import de.core.Schematic;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.GZIPInputStream;
import org.apache.xmlrpc.WebServer;
import org.apache.xmlrpc.XmlRpc;
import org.apache.xmlrpc.XmlRpcHandler;

public class OptimiseServer
implements XmlRpcHandler {
    Schematic ActSchematic;
    public WebServer server;
    int numvar = 4;
    int horizon = 7;
    double invest;
    double opcost;
    public double[][][] estadistica;
    public double[][][] peajes_gen;
    public String[][][] nombre_gen;
    public double[][][] peajes_con;
    public String[][][] nombre_con;
    GaSerialEstadistica Datos;

    public OptimiseServer(Schematic sch) {
        this.ActSchematic = sch;
        this.simulation();
    }

    public long generaCromosoma(Vector params, int nbits) {
        double[] valores = new double[params.size()];
        long cromosoma = 0L;
        for (int i = 0; i < params.size(); ++i) {
            valores[i] = Math.round(Double.valueOf((String)params.elementAt(i)));
            cromosoma = (long)((double)cromosoma + valores[i] * Math.pow(2.0, nbits * i));
        }
        return cromosoma;
    }

    public Object execute(String request, Vector params) throws Exception {
        Hashtable<String, Number> result = new Hashtable<String, Number>();
        if (request.equals("init")) {
            result.put("numvar", new Integer(this.numvar));
            result.put("horizon", new Integer(this.horizon));
            System.out.println("Init Request finished ......");
            return result;
        }
        int nbits = (int)Math.ceil(Math.log(this.horizon) / Math.log(2.0));
        long cromosoma = 0L;
        double answer = 0.0;
        double co = 0.0;
        double ci = 0.0;
        Vector arbol = this.construyeArbol(params);
        for (int i = 0; i < arbol.size(); ++i) {
            cromosoma = this.generaCromosoma((Vector)((Hashtable)arbol.get(i)).get("params"), nbits);
            answer += this.evaluate(cromosoma) * (Double)((Hashtable)arbol.get(i)).get("peso");
            ci += this.invest * (Double)((Hashtable)arbol.get(i)).get("peso");
            co += this.opcost * (Double)((Hashtable)arbol.get(i)).get("peso");
        }
        result.put("fo", new Float(answer));
        result.put("co", new Float(co));
        result.put("ci", new Float(ci));
        result.put("cromosoma", new Float(cromosoma));
        System.out.println("Simulate Request finished, the request was : " + request);
        System.out.println("Parameters: " + params);
        return result;
    }

    private Vector construyeArbol(Vector params) {
        Vector arbol = new Vector();
        for (int i = 0; i < params.size(); ++i) {
            Vector pars;
            Double peso;
            Hashtable<String, Object> nodo_der;
            Hashtable<String, Serializable> nodo_izq;
            double floor = Math.floor(Double.parseDouble((String)params.get(i)));
            double p_floor = 1.0 - Double.parseDouble((String)params.get(i)) + floor;
            double ceil = Math.ceil(Double.parseDouble((String)params.get(i)));
            double p_ceil = 1.0 - ceil + Double.parseDouble((String)params.get(i));
            if (floor == ceil) {
                p_floor = 0.5;
                p_ceil = 0.5;
            }
            Vector old_arbol = (Vector)arbol.clone();
            for (int j = 0; j < old_arbol.size(); ++j) {
                nodo_izq = (Hashtable<String, Serializable>)arbol.get(j);
                nodo_der = new Hashtable<String, Object>();
                nodo_der.put("params", ((Vector)nodo_izq.get("params")).clone());
                peso = (Double)nodo_izq.get("peso");
                pars = (Vector)nodo_izq.get("params");
                pars.add(String.valueOf(floor));
                nodo_izq.put("peso", Double.valueOf(String.valueOf(peso * p_floor)));
                pars = (Vector)nodo_der.get("params");
                pars.add(String.valueOf(ceil));
                nodo_der.put("peso", Double.valueOf(String.valueOf(peso * p_ceil)));
                arbol.add(nodo_der);
            }
            if (old_arbol.size() != 0) continue;
            nodo_izq = new Hashtable<String, Serializable>();
            nodo_der = new Hashtable();
            pars = new Vector();
            pars.add(String.valueOf(ceil));
            peso = Double.valueOf(String.valueOf(p_ceil));
            nodo_izq.put("params", pars);
            nodo_izq.put("peso", peso);
            arbol.add(nodo_izq);
            pars = new Vector();
            pars.add(String.valueOf(floor));
            peso = Double.valueOf(String.valueOf(p_floor));
            nodo_der.put("params", pars);
            nodo_der.put("peso", peso);
            arbol.add(nodo_der);
        }
        return arbol;
    }

    public void start() {
        try {
            XmlRpc.setDebug((boolean)false);
            this.server = new WebServer(7070);
            this.server.addHandler("DeepEdit", (Object)this);
            System.out.println("Optimise Server up and running in port 7070");
        }
        catch (Exception exception) {
            System.err.println("OptimiseServer: " + exception.toString());
        }
    }

    public void simulation() {
        try {
            System.out.println("Comienzo lectura GaSerialEstadistica0.bin");
            String numero = "results/GA/GaSerialEstadistica0.bin";
            FileInputStream fis = new FileInputStream(numero);
            BufferedInputStream bis = new BufferedInputStream(fis);
            GZIPInputStream zis = new GZIPInputStream(bis);
            ObjectInputStream objIs = new ObjectInputStream(zis);
            this.Datos = (GaSerialEstadistica)objIs.readObject();
            System.out.println("Fin lectura GaSerialEstadistica0.bin");
            System.out.println("Generando Estructuras de Datos");
            System.out.println("Estructuras de Datos Generada");
            this.estadistica = this.Datos.Estadistica;
            this.peajes_gen = this.Datos.Peajes_gen;
            this.nombre_gen = this.Datos.Nombre_gen;
            this.peajes_con = this.Datos.Peajes_con;
            this.nombre_con = this.Datos.Nombre_con;
        }
        catch (NotSerializableException se) {
            System.err.println(se);
            se.printStackTrace();
        }
        catch (FileNotFoundException fe) {
            System.err.println(fe);
            fe.printStackTrace();
        }
        catch (IOException se) {
            System.err.println(se);
            se.printStackTrace();
        }
        catch (ClassNotFoundException ce) {
            System.err.println(ce);
            ce.printStackTrace();
        }
        this.ActSchematic.initOptimizationComponents();
    }

    public double evaluate(long genes) {
        this.invest = 0.0;
        double losses = 0.0;
        double unser = 0.0;
        this.opcost = 0.0;
        double auxfac = 0.0;
        double answer = 0.0;
        int[] estadoenperiodo = new int[this.ActSchematic.getendperiod() - this.ActSchematic.getiniperiod() + 1];
        this.ActSchematic.EvalSchematic(genes, System.out, estadoenperiodo);
        losses = 0.0;
        unser = 0.0;
        this.opcost = 0.0;
        auxfac = 0.0;
        this.invest = this.ActSchematic.EvalInvest();
        this.ActSchematic.settiposimula(1);
        answer = -this.invest;
        for (int ix = this.ActSchematic.getiniperiod(); ix < this.ActSchematic.getendperiod() + 1; ++ix) {
            auxfac = 1.0 / Math.pow(1.0 + this.ActSchematic.getintrate() / 100.0, ix - this.ActSchematic.getiniperiod());
            losses += this.estadistica[estadoenperiodo[ix - this.ActSchematic.getiniperiod()]][ix - this.ActSchematic.getiniperiod()][1] * 8760.0 * auxfac * 25.0;
            unser += this.estadistica[estadoenperiodo[ix - this.ActSchematic.getiniperiod()]][ix - this.ActSchematic.getiniperiod()][2] * 8760.0 * auxfac * 500.0;
            this.opcost += this.estadistica[estadoenperiodo[ix - this.ActSchematic.getiniperiod()]][ix - this.ActSchematic.getiniperiod()][0] * 8760.0 * auxfac;
            answer -= this.estadistica[estadoenperiodo[ix - this.ActSchematic.getiniperiod()]][ix - this.ActSchematic.getiniperiod()][0] * 8760.0 * auxfac;
        }
        return answer;
    }
}

