/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import de.core.CvaLinPartes;
import de.core.DeepEdit;
import de.core.Generator;
import de.core.Schematic;
import de.core.SimMDE_ptocva;
import de.core.SimpleDialog;
import de.core.comp;
import de.core.hdb_affl;
import de.core.hdb_comp;
import de.core.hdb_paspur;
import de.core.hdb_res;
import de.core.hdb_ser;
import de.core.mdb_sup;
import de.core.mdb_wheel;
import de.core.ndb_inj;
import de.core.simplexmax;
import de.utils.StringUtil;
import drasys.or.matrix.DenseVector;
import drasys.or.matrix.SparseMatrix;
import drasys.or.mp.Constraint;
import drasys.or.mp.Problem;
import drasys.or.mp.ProblemI;
import drasys.or.mp.Variable;
import drasys.or.mp.lp.DenseSimplex;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Vector;

public final class OneStageSOptOf {
    private mdb_sup supplier;
    private Generator[] thermalGen;
    private Generator[] resEleGen;
    private Generator[] serEleGen;
    private Generator[] ppEleGen;
    private hdb_res[] resHydGen;
    private hdb_ser[] serHydGen;
    private hdb_paspur[] ppHydGen;
    private Vector[] ppaff;
    private Vector[] seraff;
    private Vector[] resaff;
    private Vector bilatContracts;
    private CvaLinPartes EFB;
    private Schematic ActSchematic;
    public double EnergyTotOf;
    private double restotcapa;
    private String cpnyName;
    private double[][] A;
    private double[] Q;
    private double[] c;
    private double alfa;
    private double[] b;
    private double[] xmin;
    private double[] xmax;
    private int NT;
    private int NS;
    private int NE;
    private int NP;
    private int NTH;
    private int NTO;
    private int NTHO;
    private int stagedur;
    private int numResStates;
    private int numvar;
    private int numrest;
    private PrintWriter myPrintStream;
    public DenseVector sol_lp = null;
    private double[] ppSolGen;
    private double[] ppSolSpil;
    public double operBenef;
    public double finalResState;
    public double offerEn;
    public double hydroEnergy;
    private int[] lnames;
    private SimMDE_ptocva[] cveThmOfferEner;
    private SimMDE_ptocva[] cveHydOfferEner;

    public OneStageSOptOf(mdb_sup pSupplier, Schematic mySchem, int numStates, PrintWriter myP) {
        int sx;
        comp tempcomp;
        int ix;
        this.myPrintStream = myP;
        Generator tempGen = null;
        hdb_comp temphdb = null;
        mdb_wheel tempWheel = null;
        ndb_inj tempInj = null;
        this.supplier = pSupplier;
        this.cpnyName = this.supplier.getName();
        this.ActSchematic = mySchem;
        this.NTH = 0;
        this.NP = 0;
        this.NE = 0;
        this.NS = 0;
        this.NT = 0;
        this.numResStates = numStates;
        for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
            tempcomp = (comp)this.ActSchematic.Components.elementAt(ix);
            if (tempcomp instanceof hdb_comp) {
                temphdb = (hdb_comp)tempcomp;
                if (!temphdb.getowner().equals(this.cpnyName)) continue;
                if (temphdb instanceof hdb_paspur) {
                    ++this.NP;
                    continue;
                }
                if (temphdb instanceof hdb_res) {
                    ++this.NE;
                    continue;
                }
                if (!(temphdb instanceof hdb_ser)) continue;
                ++this.NS;
                continue;
            }
            if (!(tempcomp instanceof Generator) || !(tempGen = (Generator)tempcomp).getinv_owner().equals(this.cpnyName) || tempGen.getinv_type().equals("HydroS") || tempGen.getinv_type().equals("HydroR")) continue;
            ++this.NT;
        }
        this.NTH = this.NT + this.NE + this.NS;
        this.thermalGen = new Generator[this.NT];
        this.resEleGen = new Generator[this.NE];
        this.resHydGen = new hdb_res[this.NE];
        this.resaff = new Vector[this.NE];
        this.serEleGen = new Generator[this.NS];
        this.serHydGen = new hdb_ser[this.NS];
        this.seraff = new Vector[this.NS];
        this.ppEleGen = new Generator[this.NP];
        this.ppHydGen = new hdb_paspur[this.NP];
        this.ppaff = new Vector[this.NP];
        this.bilatContracts = new Vector();
        int indNP = 0;
        int indNE = 0;
        int indNS = 0;
        int indNT = 0;
        for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
            tempcomp = (comp)this.ActSchematic.Components.elementAt(ix);
            if (tempcomp instanceof hdb_comp) {
                temphdb = (hdb_comp)tempcomp;
                if (!temphdb.getowner().equals(this.cpnyName)) continue;
                if (temphdb instanceof hdb_paspur) {
                    this.ppHydGen[indNP] = (hdb_paspur)temphdb;
                    ++indNP;
                    continue;
                }
                if (temphdb instanceof hdb_res) {
                    this.resHydGen[indNE] = (hdb_res)temphdb;
                    ++indNE;
                    continue;
                }
                if (!(temphdb instanceof hdb_ser)) continue;
                this.serHydGen[indNS] = (hdb_ser)temphdb;
                ++indNS;
                continue;
            }
            if (!(tempcomp instanceof Generator) || !(tempGen = (Generator)tempcomp).getinv_owner().equals(this.cpnyName) || tempGen.getinv_type().equals("HydroS") || tempGen.getinv_type().equals("HydroR")) continue;
            this.thermalGen[indNT] = tempGen;
            ++indNT;
        }
        this.restotcapa = 0.0;
        for (ix = 0; ix < this.NE; ++ix) {
            this.restotcapa += (this.resHydGen[ix].getVmax() - this.resHydGen[ix].getVmin()) * 1000.0 / 3.6;
            if (!this.resHydGen[ix].getgrounded()) {
                sx = OneStageSOptOf.searchCompName(this.resHydGen[ix].getName(), this.supplier.Components);
                if (sx < 0) {
                    this.throwError("Cant\u00b4t find ElecGen to " + this.resHydGen[ix].getName() + " in supplier " + this.cpnyName);
                }
                if ((tempcomp = (comp)this.supplier.Components.elementAt(sx)) instanceof Generator) {
                    this.resEleGen[ix] = (Generator)tempcomp;
                } else {
                    this.throwError("ElecGen of " + this.resHydGen[ix].getName() + " in supplier " + this.cpnyName + " isn\u00b4t a Generator.");
                }
            }
            this.resaff[ix] = new Vector();
            for (sx = 0; sx < this.resHydGen[ix].riverUpComps.size(); ++sx) {
                tempcomp = (comp)this.resHydGen[ix].riverUpComps.elementAt(sx);
                if (!(tempcomp instanceof hdb_affl)) continue;
                this.resaff[ix].addElement(tempcomp);
            }
        }
        for (ix = 0; ix < this.NS; ++ix) {
            if (!this.serHydGen[ix].getgrounded()) {
                sx = OneStageSOptOf.searchCompName(this.serHydGen[ix].getName(), this.supplier.Components);
                if (sx < 0) {
                    this.throwError("Cant\u00b4t find ElecGen to " + this.serHydGen[ix].getName() + " in supplier " + this.cpnyName);
                }
                if ((tempcomp = (comp)this.supplier.Components.elementAt(sx)) instanceof Generator) {
                    this.serEleGen[ix] = (Generator)tempcomp;
                } else {
                    this.throwError("ElecGen of " + this.serHydGen[ix].getName() + " in supplier " + this.cpnyName + " isn\u00b4t a Generator.");
                }
            }
            this.seraff[ix] = new Vector();
            for (sx = 0; sx < this.serHydGen[ix].riverUpComps.size(); ++sx) {
                tempcomp = (comp)this.serHydGen[ix].riverUpComps.elementAt(sx);
                if (!(tempcomp instanceof hdb_affl)) continue;
                this.seraff[ix].addElement(tempcomp);
            }
        }
        for (ix = 0; ix < this.NP; ++ix) {
            if (!this.ppHydGen[ix].getgrounded()) {
                sx = OneStageSOptOf.searchCompName(this.ppHydGen[ix].getName(), this.supplier.Components);
                if (sx < 0) {
                    this.throwError("Cant\u00b4t find ElecGen to " + this.ppHydGen[ix].getName() + " in supplier " + this.cpnyName);
                }
                if ((tempcomp = (comp)this.supplier.Components.elementAt(sx)) instanceof Generator) {
                    this.ppEleGen[ix] = (Generator)tempcomp;
                } else {
                    this.throwError("ElecGen of " + this.ppHydGen[ix].getName() + " in supplier " + this.cpnyName + " isn\u00b4t a Generator.");
                }
            }
            this.ppaff[ix] = new Vector();
            for (sx = 0; sx < this.ppHydGen[ix].riverUpComps.size(); ++sx) {
                tempcomp = (comp)this.ppHydGen[ix].riverUpComps.elementAt(sx);
                if (!(tempcomp instanceof hdb_affl)) continue;
                this.ppaff[ix].addElement(tempcomp);
            }
        }
        for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
            tempcomp = (comp)this.ActSchematic.Components.elementAt(ix);
            if (!(tempcomp instanceof mdb_wheel) || !(tempInj = (ndb_inj)(tempWheel = (mdb_wheel)tempcomp).getparty1()).getinv_owner().equals(this.cpnyName)) continue;
            this.bilatContracts.addElement(tempWheel);
        }
        this.NTO = this.NT;
        this.NTHO = this.NTH;
        this.NT = 0;
        this.NTH -= this.NTO;
        this.numvar = this.NTH + this.NE + this.NS + this.NE + this.numResStates - 1 + 1;
        this.numrest = 1 + this.NE + this.NE + this.NS;
        this.c = new double[this.numvar];
        this.Q = new double[this.numvar];
        this.xmin = new double[this.numvar];
        this.xmax = new double[this.numvar];
        this.b = new double[this.numrest];
        this.A = new double[this.numrest][this.numvar];
        System.out.println("------------------Connectivity of the Hydro System --------------");
        for (ix = 0; ix < this.NE; ++ix) {
            if (this.resHydGen[ix].getTurbRecComp() != null) {
                System.out.println("Turbined of " + this.resHydGen[ix].getName() + " is received at " + this.resHydGen[ix].getTurbRecComp().getName());
            }
            if (this.resHydGen[ix].getSpilRecComp() == null) continue;
            System.out.println("Spilled of " + this.resHydGen[ix].getName() + " is received at " + this.resHydGen[ix].getSpilRecComp().getName());
        }
        for (ix = 0; ix < this.NS; ++ix) {
            if (this.serHydGen[ix].getTurbRecComp() != null) {
                System.out.println("Turbined of " + this.serHydGen[ix].getName() + " is received at " + this.serHydGen[ix].getTurbRecComp().getName());
            }
            if (this.serHydGen[ix].getSpilRecComp() == null) continue;
            System.out.println("Spilled of " + this.serHydGen[ix].getName() + " is received at " + this.serHydGen[ix].getSpilRecComp().getName());
        }
        this.myPrintStream.println("------------------Connectivity of the Hydro System --------------");
        for (ix = 0; ix < this.NE; ++ix) {
            if (this.resHydGen[ix].getTurbRecComp() != null) {
                this.myPrintStream.println("Turbined of " + this.resHydGen[ix].getName() + " is received at " + this.resHydGen[ix].getTurbRecComp().getName());
            }
            if (this.resHydGen[ix].getSpilRecComp() == null) continue;
            this.myPrintStream.println("Spilled of " + this.resHydGen[ix].getName() + " is received at " + this.resHydGen[ix].getSpilRecComp().getName());
        }
        for (ix = 0; ix < this.NS; ++ix) {
            if (this.serHydGen[ix].getTurbRecComp() != null) {
                this.myPrintStream.println("Turbined of " + this.serHydGen[ix].getName() + " is received at " + this.serHydGen[ix].getTurbRecComp().getName());
            }
            if (this.serHydGen[ix].getSpilRecComp() == null) continue;
            this.myPrintStream.println("Spilled of " + this.serHydGen[ix].getName() + " is received at " + this.serHydGen[ix].getSpilRecComp().getName());
        }
        this.myPrintStream.println("-----------------------------------------------------------------");
    }

    private static int isspillin(hdb_ser outputcomp, hdb_ser recipcomp) {
        if (outputcomp.getSpilRecComp() != null && outputcomp.getSpilRecComp() == recipcomp) {
            return 1;
        }
        return 0;
    }

    private static int isturbin(hdb_ser outputcomp, hdb_ser recipcomp) {
        if (outputcomp.getTurbRecComp() != null && outputcomp.getTurbRecComp() == recipcomp) {
            return 1;
        }
        return 0;
    }

    static int searchCompName(String name2find, Vector compvect) {
        for (int ix = 0; ix < compvect.size(); ++ix) {
            comp tempcomp = (comp)compvect.elementAt(ix);
            if (!tempcomp.getName().equals(name2find)) continue;
            return ix;
        }
        return -1;
    }

    public void constProblem(CvaLinPartes pEFB, double actEnPrice, int dur) {
        int indgj;
        hdb_affl tempaff;
        int jx;
        int ix;
        this.EFB = pEFB;
        this.numResStates = this.EFB.getNumPoints();
        this.stagedur = dur;
        this.alfa = 0.0;
        this.hydroEnergy = 0.0;
        this.ppSolGen = new double[this.NP];
        this.ppSolSpil = new double[this.NP];
        for (ix = 0; ix < this.ppHydGen.length; ++ix) {
            if (this.ppHydGen[ix].getgrounded()) {
                this.ppSolSpil[ix] = 0.0;
                this.ppSolGen[ix] = 0.0;
                continue;
            }
            double aux = 0.0;
            for (jx = 0; jx < this.ppaff[ix].size(); ++jx) {
                tempaff = (hdb_affl)this.ppaff[ix].elementAt(jx);
                aux += tempaff.getQ();
            }
            double auxtaff = aux;
            aux = (aux - this.ppHydGen[ix].getSpillmin()) * this.ppHydGen[ix].getWat2PowRate();
            this.ppSolGen[ix] = aux = Math.min(aux, this.ppEleGen[ix].getpmax());
            this.ppSolSpil[ix] = this.ppHydGen[ix].getWat2PowRate() != 0.0 ? auxtaff - aux / this.ppHydGen[ix].getWat2PowRate() : auxtaff;
            this.hydroEnergy += aux * (double)this.stagedur;
        }
        this.offerEn = 0.0;
        for (ix = 0; ix < this.NTO; ++ix) {
            if (!(this.thermalGen[ix].getinv_cost() <= actEnPrice)) continue;
            this.offerEn += this.thermalGen[ix].getpmax() * (double)this.stagedur;
        }
        this.alfa = (this.offerEn + this.hydroEnergy) * actEnPrice;
        if (this.NS == 0 && this.NE == 0) {
            return;
        }
        int to = this.NE;
        for (ix = 0; ix < to; ++ix) {
            this.c[ix] = 0.0;
            if (this.resHydGen[ix].getgrounded()) continue;
            this.c[ix] = actEnPrice;
        }
        int from = to;
        to += this.NS;
        int indgi = -1;
        for (ix = from; ix < to; ++ix) {
            this.c[ix] = 0.0;
            if (this.serHydGen[++indgi].getgrounded()) continue;
            this.c[ix] = actEnPrice;
        }
        from = to;
        to += this.NT;
        indgi = -1;
        for (ix = from; ix < to; ++ix) {
            this.c[ix] = 0.0;
            this.c[ix] = actEnPrice - this.thermalGen[++indgi].getbeta();
        }
        from = to;
        to += this.NE;
        for (ix = from; ix < to; ++ix) {
            this.c[ix] = -1.0E-14;
        }
        from = to;
        to += this.NS + this.NE;
        for (ix = from; ix < to; ++ix) {
            this.c[ix] = 0.0;
        }
        from = to;
        to += this.numResStates - 1;
        for (ix = from; ix < to; ++ix) {
            this.c[ix] = this.EFB.getSlope(ix - from + 1) * 3.6 / 1000.0;
        }
        this.c[this.numvar - 1] = 0.0;
        to = this.NS + this.NE;
        for (ix = 0; ix < to; ++ix) {
            this.Q[ix] = 0.0;
        }
        from = to;
        to += this.NT;
        for (ix = from; ix < to; ++ix) {
            this.Q[ix] = -2.0 * this.thermalGen[ix - from].getgamma();
        }
        from = to;
        to += this.NS + this.NE + this.NE + this.numResStates;
        for (ix = from; ix < to; ++ix) {
            this.Q[ix] = 0.0;
        }
        for (ix = 0; ix < this.numrest; ++ix) {
            this.b[ix] = 0.0;
            for (jx = 0; jx < this.numvar; ++jx) {
                this.A[ix][jx] = 0.0;
            }
        }
        int fromjx = this.NTH + this.NE + this.NS + this.NE;
        int tojx = fromjx + this.numResStates - 1;
        for (jx = fromjx; jx < tojx; ++jx) {
            this.A[0][jx] = 1.0;
        }
        this.A[0][tojx] = -1.0;
        this.b[0] = 0.0;
        from = 1;
        to = from + this.NE;
        for (ix = from; ix < to; ++ix) {
            this.A[ix][ix - from + this.NTH + this.NE + this.NS] = 1.0;
            this.A[ix][this.numvar - 1] = -(this.resHydGen[ix - from].getVmax() - this.resHydGen[ix - from].getVmin()) / this.restotcapa * 1000.0 / 3.6;
            this.b[ix] = this.resHydGen[ix - from].getVmin() * 1000.0 / 3.6;
        }
        from = to;
        to += this.NE;
        indgi = -1;
        for (ix = from; ix < to; ++ix) {
            ++indgi;
            fromjx = 0;
            tojx = this.NE;
            indgj = -1;
            jx = fromjx;
            while (jx < tojx) {
                this.A[ix][jx] = indgi == ++indgj ? 1.0 : (double)(-OneStageSOptOf.isturbin(this.resHydGen[indgj], this.resHydGen[indgi]));
                double[] dArray = this.A[ix];
                int n = jx++;
                dArray[n] = dArray[n] / this.resHydGen[indgj].getWat2PowRate();
            }
            fromjx = tojx;
            tojx += this.NS;
            indgj = -1;
            for (jx = fromjx; jx < tojx; ++jx) {
                this.A[ix][jx] = (double)(-OneStageSOptOf.isturbin(this.serHydGen[++indgj], this.resHydGen[indgi])) / this.serHydGen[indgj].getWat2PowRate();
            }
            fromjx = tojx + this.NT;
            tojx = fromjx + this.NE;
            indgj = -1;
            for (jx = fromjx; jx < tojx; ++jx) {
                this.A[ix][jx] = indgi == ++indgj ? 1.0 : (double)(-OneStageSOptOf.isspillin(this.resHydGen[indgj], this.resHydGen[indgi]));
            }
            fromjx = tojx;
            tojx += this.NS;
            indgj = -1;
            for (jx = fromjx; jx < tojx; ++jx) {
                this.A[ix][jx] = -OneStageSOptOf.isspillin(this.serHydGen[++indgj], this.resHydGen[indgi]);
            }
            this.A[ix][tojx + indgi] = 1.0 + 0.5 * this.resHydGen[indgi].getAvfiltf();
            this.b[ix] = this.resHydGen[indgi].getSimVini() * (1.0 - 0.5 * this.resHydGen[indgi].getAvfiltf()) * 1000.0 / 3.6;
            if (this.resaff[indgi] == null) continue;
            for (jx = 0; jx < this.resaff[indgi].size(); ++jx) {
                tempaff = (hdb_affl)this.resaff[indgi].elementAt(jx);
                int n = ix;
                this.b[n] = this.b[n] + tempaff.getQ() * (double)this.stagedur;
            }
        }
        from = to;
        to += this.NS;
        indgi = -1;
        for (ix = from; ix < to; ++ix) {
            ++indgi;
            fromjx = 0;
            tojx = this.NE;
            indgj = -1;
            for (jx = fromjx; jx < tojx; ++jx) {
                this.A[ix][jx] = (double)(-OneStageSOptOf.isturbin(this.resHydGen[++indgj], this.serHydGen[indgi])) / this.resHydGen[indgj].getWat2PowRate();
            }
            fromjx = tojx;
            tojx += this.NS;
            indgj = -1;
            jx = fromjx;
            while (jx < tojx) {
                this.A[ix][jx] = indgi == ++indgj ? 1.0 : (double)(-OneStageSOptOf.isturbin(this.serHydGen[indgj], this.serHydGen[indgi]));
                double[] dArray = this.A[ix];
                int n = jx++;
                dArray[n] = dArray[n] / this.serHydGen[indgj].getWat2PowRate();
            }
            fromjx = tojx + this.NT;
            tojx = fromjx + this.NE;
            indgj = -1;
            for (jx = fromjx; jx < tojx; ++jx) {
                this.A[ix][jx] = -OneStageSOptOf.isspillin(this.resHydGen[++indgj], this.serHydGen[indgi]);
            }
            fromjx = tojx;
            tojx += this.NS;
            indgj = -1;
            for (jx = fromjx; jx < tojx; ++jx) {
                this.A[ix][jx] = indgi == ++indgj ? 1.0 : (double)(-OneStageSOptOf.isspillin(this.serHydGen[indgj], this.serHydGen[indgi]));
            }
            this.b[ix] = 0.0;
            if (this.seraff[indgi] == null) continue;
            for (jx = 0; jx < this.seraff[indgi].size(); ++jx) {
                tempaff = (hdb_affl)this.seraff[indgi].elementAt(jx);
                int n = ix;
                this.b[n] = this.b[n] + tempaff.getQ() * (double)this.stagedur;
            }
        }
        for (ix = 0; ix < this.numvar; ++ix) {
            this.xmin[ix] = 0.0;
            this.xmax[ix] = 1.0E10;
        }
        to = this.NE;
        for (ix = 0; ix < to; ++ix) {
            if (this.resHydGen[ix].getgrounded()) continue;
            this.xmax[ix] = this.resEleGen[ix].getpmax() * (double)this.stagedur;
        }
        from = to;
        to += this.NS;
        indgi = -1;
        for (indgi = 0; indgi < this.NS; ++indgi) {
            if (this.serHydGen[indgi].getgrounded()) continue;
            this.xmax[indgi + from] = this.serEleGen[indgi].getpmax() * (double)this.stagedur;
        }
        from = to;
        to += this.NT;
        for (ix = from; ix < to; ++ix) {
            this.xmax[ix] = this.thermalGen[ix - from].getpmax() * (double)this.stagedur;
        }
        from = to;
        to += this.NE;
        indgi = -1;
        for (ix = from; ix < to; ++ix) {
            this.xmin[ix] = this.resHydGen[++indgi].getSpillmin() * (double)this.stagedur;
            this.xmax[ix] = this.resHydGen[indgi].getSpillmax() * (double)this.stagedur;
        }
        from = to;
        to += this.NS;
        indgi = -1;
        for (ix = from; ix < to; ++ix) {
            this.xmin[ix] = this.serHydGen[++indgi].getSpillmin() * (double)this.stagedur;
            this.xmax[ix] = this.serHydGen[indgi].getSpillmax() * (double)this.stagedur;
        }
        from = to;
        to += this.NE;
        indgi = -1;
        for (ix = from; ix < to; ++ix) {
            this.xmin[ix] = this.resHydGen[++indgi].getVmin() * 1000.0 / 3.6;
            this.xmax[ix] = this.resHydGen[indgi].getVmax() * 1000.0 / 3.6;
        }
        from = to;
        to += this.numResStates - 1;
        for (ix = from; ix < to; ++ix) {
            this.xmax[ix] = (this.EFB.getXpoint(ix - from + 1) - this.EFB.getXpoint(ix - from)) * 1000.0 / 3.6;
        }
        this.xmax[to] = this.restotcapa;
    }

    public double solveByLPS() {
        int i;
        double res = 0.0;
        double futben = 0.0;
        double[] auxXlimit = new double[this.numvar * 2];
        double[][] Xlimit = new double[this.numvar * 2][this.numvar];
        for (i = 0; i < this.numvar; ++i) {
            auxXlimit[i] = this.xmax[i];
            auxXlimit[i + this.numvar] = -this.xmin[i];
            Xlimit[i][i] = 1.0;
            Xlimit[i + this.numvar][i] = -1.0;
        }
        this.sol_lp = simplexmax.sol(new SparseMatrix(Xlimit), new DenseVector(auxXlimit), new SparseMatrix(this.A), new DenseVector(this.b), new DenseVector(this.c));
        if (this.sol_lp == null) {
            return 0.0;
        }
        for (i = 0; i < this.NTH; ++i) {
            res += this.sol_lp.elementAt(i) * this.c[i];
        }
        futben = this.EFB.evalIn(this.sol_lp.elementAt(this.numvar - 1) / 1000.0 * 3.6);
        this.operBenef = res += this.alfa;
        for (i = 0; i < this.NTH; ++i) {
            if (!(this.c[i] > 0.0)) continue;
            this.hydroEnergy += this.sol_lp.elementAt(i);
        }
        this.hydroEnergy /= (double)this.stagedur;
        this.finalResState = this.sol_lp.elementAt(this.numvar - 1) / this.restotcapa;
        return res + futben;
    }

    public double solveByOpRe() throws Exception {
        int i;
        Constraint tempConst;
        int jx;
        int ix;
        double res = 0.0;
        double futben = 0.0;
        if (this.NS == 0 && this.NE == 0) {
            this.offerEn += this.hydroEnergy;
            return this.alfa;
        }
        Problem lpprob = new Problem(this.numvar, this.numrest + this.numvar * 2);
        for (ix = 0; ix < this.numvar; ++ix) {
            Variable tempVar = (Variable)lpprob.newVariable("" + ix);
            tempVar.setType((byte)21);
            tempVar.setUpperBound(this.xmax[ix]);
            tempVar.setLowerBound(this.xmin[ix]);
            tempVar.setObjectiveCoefficient(-this.c[ix]);
        }
        for (jx = 0; jx < this.numrest; ++jx) {
            tempConst = (Constraint)lpprob.newConstraint("" + jx);
            tempConst.setType((byte)13);
            tempConst.setRightHandSide(this.b[jx]);
            for (ix = 0; ix < this.numvar; ++ix) {
                lpprob.setCoefficientAt(jx, ix, this.A[jx][ix]);
            }
        }
        for (jx = 0; jx < this.numvar; ++jx) {
            tempConst = (Constraint)lpprob.newConstraint("" + (jx + this.numrest));
            tempConst.setType((byte)11);
            tempConst.setRightHandSide(this.xmax[jx]);
            for (ix = 0; ix < this.numvar; ++ix) {
                lpprob.setCoefficientAt(this.numrest + jx, ix, 0.0);
            }
            lpprob.setCoefficientAt(this.numrest + jx, jx, 1.0);
        }
        for (jx = 0; jx < this.numvar; ++jx) {
            tempConst = (Constraint)lpprob.newConstraint("" + (jx + this.numrest + this.numvar));
            tempConst.setType((byte)12);
            tempConst.setRightHandSide(this.xmin[jx]);
            for (ix = 0; ix < this.numvar; ++ix) {
                lpprob.setCoefficientAt(this.numvar + this.numrest + jx, ix, 0.0);
            }
            lpprob.setCoefficientAt(this.numvar + this.numrest + jx, jx, 1.0);
        }
        DenseSimplex lpsolver = new DenseSimplex((ProblemI)lpprob);
        lpsolver.solve();
        res = 0.0;
        this.sol_lp = (DenseVector)lpsolver.getSolution();
        if (this.sol_lp == null) {
            return 0.0;
        }
        for (i = 0; i < this.NE + this.NS; ++i) {
            res += this.sol_lp.elementAt(i) * this.c[i];
        }
        futben = this.EFB.evalIn(this.sol_lp.elementAt(this.numvar - 1) / 1000.0 * 3.6);
        this.operBenef = res;
        for (i = 0; i < this.NE; ++i) {
            if (this.resHydGen[i].getgrounded()) continue;
            this.hydroEnergy += this.sol_lp.elementAt(i);
        }
        for (i = 0; i < this.NS; ++i) {
            if (this.serHydGen[i].getgrounded()) continue;
            this.hydroEnergy += this.sol_lp.elementAt(i + this.NE);
        }
        this.offerEn += this.hydroEnergy;
        this.finalResState = this.sol_lp.elementAt(this.numvar - 1) / this.restotcapa;
        for (i = 0; i < this.NE; ++i) {
            this.resHydGen[i].setSimVfin(this.sol_lp.elementAt(i + this.NTH + this.NE + this.NS) * 3.6 / 1000.0);
        }
        return res + futben;
    }

    public double solveByMinos() {
        int i;
        double res = 0.0;
        double futben = 0.0;
        double[] sol_lpAux = new double[this.numvar];
        FileInputStream is1 = null;
        try {
            FileOutputStream os = new FileOutputStream("./economic.dat");
            BufferedOutputStream bos = new BufferedOutputStream(os, 32768);
            PrintStream myPrintStream1 = new PrintStream(bos, false);
            System.out.println("Escritura de economic.dat");
            myPrintStream1.println(this.numvar);
            myPrintStream1.println(" ");
            myPrintStream1.println(this.numrest);
            myPrintStream1.println(" ");
            for (i = 0; i < this.numvar; ++i) {
                myPrintStream1.println(-this.c[i]);
            }
            myPrintStream1.println(" ");
            for (i = 0; i < this.numrest; ++i) {
                myPrintStream1.println(this.b[i]);
            }
            myPrintStream1.println(" ");
            for (i = 0; i < this.numrest; ++i) {
                for (int j = 0; j < this.numvar; ++j) {
                    myPrintStream1.println(this.A[i][j]);
                }
                myPrintStream1.println(" ");
            }
            myPrintStream1.println(" ");
            for (i = 0; i < this.numrest; ++i) {
                myPrintStream1.println(1);
            }
            myPrintStream1.println(" ");
            for (i = 0; i < this.numvar; ++i) {
                myPrintStream1.println(this.xmin[i]);
            }
            myPrintStream1.println(" ");
            for (i = 0; i < this.numvar; ++i) {
                myPrintStream1.println(this.xmax[i]);
            }
            myPrintStream1.println(" ");
            myPrintStream1.println("max");
            myPrintStream1.println("Resultados Minos");
            myPrintStream1.close();
        }
        catch (Exception e) {
            String message = e.toString();
            String[] DlgButtons = new String[]{"OK"};
            SimpleDialog ExceptionDialog = new SimpleDialog(DeepEdit.frame, "MTOS-economic.dat", message + " C1", DlgButtons, 1, 0, 0, 1);
            return 0.0;
        }
        System.out.println("Call Solver");
        try {
            this.Dorun(DeepEdit.PathDOS + "lineal.bat", DeepEdit.PathUNIX + "lineal.bat");
        }
        catch (Exception e) {
            String message = e.toString();
            String[] DlgButtons = new String[]{"OK"};
            SimpleDialog ExceptionDialog = new SimpleDialog(DeepEdit.frame, "Call Lineal", message + " C3", DlgButtons, 1, 0, 0, 1);
            return 0.0;
        }
        System.out.println("End Solver");
        try {
            String ln;
            is1 = new FileInputStream("./soluci.dat");
            i = 0;
            BufferedReader is = new BufferedReader(new InputStreamReader(is1));
            while ((ln = is.readLine()) != null) {
                if (i != 0) {
                    if (i <= this.numvar) {
                        sol_lpAux[i - 1] = Double.valueOf(ln);
                    }
                } else {
                    res = -Double.valueOf(ln).doubleValue();
                }
                ++i;
            }
            is.close();
            is = null;
        }
        catch (Exception e) {
            String message = e.toString();
            String[] DlgButtons = new String[]{"OK"};
            SimpleDialog ExceptionDialog = new SimpleDialog(DeepEdit.frame, "MTOS, reading soluci.dat", message + " C4", DlgButtons, 1, 0, 0, 1);
        }
        res = 0.0;
        this.sol_lp = new DenseVector(sol_lpAux);
        for (i = 0; i < this.NTH; ++i) {
            res += this.sol_lp.elementAt(i) * this.c[i];
        }
        futben = this.EFB.evalIn(this.sol_lp.elementAt(this.numvar - 1) / 1000.0 * 3.6);
        this.operBenef = res += this.alfa;
        for (i = 0; i < this.NTH; ++i) {
            if (!(this.c[i] > 0.0)) continue;
            this.hydroEnergy += this.sol_lp.elementAt(i);
        }
        this.hydroEnergy /= (double)this.stagedur;
        this.finalResState = this.sol_lp.elementAt(this.numvar - 1) / this.restotcapa;
        return res + futben;
    }

    private boolean updateProblem() {
        boolean allOK = true;
        return allOK;
    }

    private void throwError(String msg) {
        System.out.println(msg);
    }

    public void writeHeadList() {
        String tempStr;
        int ix;
        String head1 = "";
        String head2 = "";
        this.lnames = new int[this.NE + this.NS + this.NP + this.NT + (this.NE + this.NS + this.NP) + this.NE];
        int kx = 0;
        int from = 0;
        int to = this.NE;
        int jx = 0;
        for (ix = from; ix < to; ++ix) {
            tempStr = StringUtil.strformat(this.resHydGen[jx].getName(), 7);
            this.lnames[kx] = tempStr.length();
            head1 = head1 + tempStr + " ";
            head2 = head2 + StringUtil.strformat("Gen[MW]", this.lnames[kx]) + " ";
            ++kx;
            ++jx;
        }
        from = to;
        to += this.NS;
        jx = 0;
        for (ix = from; ix < to; ++ix) {
            tempStr = StringUtil.strformat(this.serHydGen[jx].getName(), 7);
            this.lnames[kx] = tempStr.length();
            head1 = head1 + tempStr + " ";
            head2 = head2 + StringUtil.strformat("Gen[MW]", this.lnames[kx]) + " ";
            ++kx;
            ++jx;
        }
        from = to;
        to += this.NP;
        jx = 0;
        for (ix = from; ix < to; ++ix) {
            tempStr = StringUtil.strformat(this.ppHydGen[jx].getName(), 7);
            this.lnames[kx] = tempStr.length();
            head1 = head1 + tempStr + " ";
            head2 = head2 + StringUtil.strformat("Gen[MW]", this.lnames[kx]) + " ";
            ++kx;
            ++jx;
        }
        from = to;
        to += this.NT;
        jx = 0;
        for (ix = from; ix < to; ++ix) {
            tempStr = StringUtil.strformat(this.thermalGen[jx].getName(), 7);
            this.lnames[kx] = tempStr.length();
            head1 = head1 + tempStr + " ";
            head2 = head2 + StringUtil.strformat("Gen[MW]", this.lnames[kx]) + " ";
            ++kx;
            ++jx;
        }
        from = to;
        to += this.NE;
        jx = 0;
        for (ix = from; ix < to; ++ix) {
            tempStr = StringUtil.strformat(this.resHydGen[jx].getName(), 7);
            this.lnames[kx] = tempStr.length();
            head1 = head1 + tempStr + " ";
            head2 = head2 + StringUtil.strformat("QS[m\u00b3s]", this.lnames[kx]) + " ";
            ++kx;
            ++jx;
        }
        from = to;
        to += this.NS;
        jx = 0;
        for (ix = from; ix < to; ++ix) {
            tempStr = StringUtil.strformat(this.serHydGen[jx].getName(), 7);
            this.lnames[kx] = tempStr.length();
            head1 = head1 + tempStr + " ";
            head2 = head2 + StringUtil.strformat("QS[m\u00b3s]", this.lnames[kx]) + " ";
            ++kx;
            ++jx;
        }
        from = to;
        to += this.NP;
        jx = 0;
        for (ix = from; ix < to; ++ix) {
            tempStr = StringUtil.strformat(this.ppHydGen[jx].getName(), 7);
            this.lnames[kx] = tempStr.length();
            head1 = head1 + tempStr + " ";
            head2 = head2 + StringUtil.strformat("QS[m\u00b3s]", this.lnames[kx]) + " ";
            ++kx;
            ++jx;
        }
        from = to;
        to += this.NE;
        jx = 0;
        for (ix = from; ix < to; ++ix) {
            tempStr = StringUtil.strformat(this.resHydGen[jx].getName(), 7);
            this.lnames[kx] = tempStr.length();
            head1 = head1 + tempStr + " ";
            head2 = head2 + StringUtil.strformat("Vf[Mm\u00b3]", this.lnames[kx]) + " ";
            ++kx;
            ++jx;
        }
        this.myPrintStream.println("HS   Stage  " + head1);
        this.myPrintStream.println("            " + head2);
    }

    public void writeResultList(int hyd, String simMonth) {
        double tempNum;
        int ix;
        String solString = "";
        if (this.sol_lp == null) {
            return;
        }
        solString = StringUtil.numformat(hyd, 2) + " ";
        solString = solString + StringUtil.strformat(simMonth, 7) + "  ";
        int kx = 0;
        int from = 0;
        int to = this.NE;
        int jx = 0;
        for (ix = from; ix < to; ++ix) {
            tempNum = this.sol_lp.elementAt(jx) / (double)this.stagedur;
            solString = this.resEleGen[jx] != null ? solString + StringUtil.numformat(tempNum, this.lnames[kx], 1) + " " : solString + StringUtil.numformat(-tempNum, this.lnames[kx], 1) + " ";
            ++kx;
            ++jx;
        }
        from = to;
        to += this.NS;
        jx = 0;
        for (ix = from; ix < to; ++ix) {
            tempNum = this.sol_lp.elementAt(ix) / (double)this.stagedur;
            solString = this.serEleGen[jx] != null ? solString + StringUtil.numformat(tempNum, this.lnames[kx], 1) + " " : solString + StringUtil.numformat(-tempNum, this.lnames[kx], 1) + " ";
            ++kx;
            ++jx;
        }
        from = to;
        to += this.NP;
        jx = 0;
        for (ix = from; ix < to; ++ix) {
            tempNum = this.ppSolGen[jx];
            solString = solString + StringUtil.numformat(tempNum, this.lnames[kx], 1) + " ";
            ++kx;
            ++jx;
        }
        to = to - this.NP + this.NT;
        for (ix = from; ix < to; ++ix) {
            tempNum = this.sol_lp.elementAt(ix) / (double)this.stagedur;
            solString = solString + StringUtil.numformat(tempNum, this.lnames[kx], 1) + " ";
            ++kx;
        }
        from = to;
        to += this.NE;
        for (ix = from; ix < to; ++ix) {
            tempNum = this.sol_lp.elementAt(ix) / (double)this.stagedur;
            solString = solString + StringUtil.numformat(tempNum, this.lnames[kx], 2) + " ";
            ++kx;
        }
        from = to;
        to += this.NS;
        for (ix = from; ix < to; ++ix) {
            tempNum = this.sol_lp.elementAt(ix) / (double)this.stagedur;
            solString = solString + StringUtil.numformat(tempNum, this.lnames[kx], 2) + " ";
            ++kx;
        }
        from = to;
        to += this.NP;
        jx = 0;
        for (ix = from; ix < to; ++ix) {
            tempNum = this.ppSolSpil[jx];
            solString = solString + StringUtil.numformat(tempNum, this.lnames[kx], 2) + " ";
            ++kx;
            ++jx;
        }
        to = to - this.NP + this.NE;
        jx = 0;
        for (ix = from; ix < to; ++ix) {
            tempNum = this.sol_lp.elementAt(ix) * 3.6 / 1000.0;
            solString = solString + StringUtil.numformat(tempNum, this.lnames[kx], 2) + " ";
            ++kx;
        }
        this.myPrintStream.println(solString);
    }

    public static void printMatrix(PrintWriter myPrintStream, double[][] m, int ii, int jj) {
        for (int i = 0; i < ii; ++i) {
            for (int j = 0; j < jj; ++j) {
                myPrintStream.print(m[i][j] + "\t \t \t");
            }
            myPrintStream.println();
        }
        myPrintStream.println();
    }

    public static void printVector(PrintWriter myPrintStream, double[] v, int ii) {
        for (int i = 0; i < ii; ++i) {
            myPrintStream.print(i + "\t" + v[i] + "\t");
            myPrintStream.println();
        }
        myPrintStream.println();
    }

    public void Dorun(String progname_pc, String progname_unix) {
        String OSName = System.getProperty("os.name");
        try {
            Process p;
            Runtime r = Runtime.getRuntime();
            r.gc();
            if (OSName.equals("Windows 95") || OSName.equals("Windows 2000") || OSName.equals("Windows 98") || OSName.equals("Windows NT") || OSName.equals("Windows XP")) {
                p = r.exec(progname_pc);
            } else {
                String[] commando = new String[]{"xterm", "-e", progname_unix};
                p = r.exec(commando);
            }
            p.waitFor();
            p.destroy();
            p = null;
            r.runFinalization();
            r = null;
        }
        catch (InterruptedException ie) {
            System.out.println("Error in Dorun-method of AnalysisTool!: " + ie);
        }
        catch (Exception e) {
            System.out.println("Error in Dorun-method of AnalysisTool!: " + e);
        }
    }

    public SimMDE_ptocva[] getHydOffer(CvaLinPartes pEFB, double actEnPrice, int dur) throws Exception {
        this.constProblem(pEFB, actEnPrice, dur);
        this.solveByOpRe();
        if (this.hydroEnergy == 0.0) {
            this.cveHydOfferEner = null;
            if (this.NE == 0) {
                return null;
            }
            this.hydroEnergy = 0.01;
        }
        SimMDE_ptocva tempPtoCva = new SimMDE_ptocva();
        tempPtoCva.precio = 1.0E-6;
        tempPtoCva.energia = this.hydroEnergy / (double)this.stagedur;
        this.cveHydOfferEner = new SimMDE_ptocva[2];
        this.cveHydOfferEner[0] = new SimMDE_ptocva();
        this.cveHydOfferEner[1] = tempPtoCva;
        this.myPrintStream.flush();
        return this.cveHydOfferEner;
    }

    public SimMDE_ptocva[] getThmOfferCve() throws Exception {
        int i;
        if (this.thermalGen.length == 0) {
            this.cveThmOfferEner = null;
            return null;
        }
        for (int n = this.thermalGen.length - 1; n > 0; --n) {
            int posmax = n;
            for (int j = 0; j < n; ++j) {
                if (!(this.thermalGen[j].getinv_cost() > this.thermalGen[posmax].getinv_cost())) continue;
                posmax = j;
            }
            if (posmax == n) continue;
            Generator tempGen = this.thermalGen[posmax];
            this.thermalGen[posmax] = this.thermalGen[n];
            this.thermalGen[n] = tempGen;
        }
        Vector<SimMDE_ptocva> tempCve = new Vector<SimMDE_ptocva>(this.thermalGen.length + 1);
        SimMDE_ptocva tempPtoCva = new SimMDE_ptocva();
        tempPtoCva.precio = this.thermalGen[0].getinv_cost();
        tempPtoCva.energia = this.thermalGen[0].getpmax();
        if (tempPtoCva.energia > 0.0) {
            tempCve.addElement(tempPtoCva);
        }
        for (i = 1; i < this.thermalGen.length; ++i) {
            if (this.thermalGen[i].getinv_cost() == tempPtoCva.precio) {
                tempPtoCva.energia += this.thermalGen[i].getpmax();
                continue;
            }
            SimMDE_ptocva tempPtoCva2 = new SimMDE_ptocva();
            tempPtoCva2.precio = this.thermalGen[i].getinv_cost();
            tempPtoCva2.energia = tempPtoCva.energia + this.thermalGen[i].getpmax();
            tempPtoCva = tempPtoCva2;
            tempCve.addElement(tempPtoCva);
        }
        this.cveThmOfferEner = new SimMDE_ptocva[tempCve.size() + 1];
        this.cveThmOfferEner[0] = new SimMDE_ptocva();
        for (i = 1; i <= tempCve.size(); ++i) {
            this.cveThmOfferEner[i] = (SimMDE_ptocva)tempCve.elementAt(i - 1);
        }
        return this.cveThmOfferEner;
    }

    private double getOptHydEner(double pPrice) throws Exception {
        double aux = this.hydroEnergy;
        if (this.NE > 0) {
            this.constProblem(this.EFB, pPrice, this.stagedur);
            this.solveByOpRe();
            aux = this.hydroEnergy;
        }
        return aux;
    }

    public double UpdateHydOffer(double pPrice) throws Exception {
        double newEnP0;
        if (this.cveHydOfferEner == null) {
            return 0.0;
        }
        if (this.NE == 0) {
            return 0.0;
        }
        this.cveHydOfferEner[1].energia = newEnP0 = this.getOptHydEner(pPrice) / (double)this.stagedur;
        return newEnP0;
    }

    public void doRestEnHydOpt(double pPrice, double restengy) throws Exception {
        if (this.cveHydOfferEner == null) {
            return;
        }
        if (this.NE == 0) {
            return;
        }
        this.constProblem(this.EFB, pPrice, this.stagedur);
        this.solvePwithResEngy(restengy * (double)this.stagedur);
    }

    public void setOutStr(PrintWriter outpF) {
        this.myPrintStream = outpF;
    }

    public double solvePwithResEngy(double maxEnergy) throws Exception {
        int i;
        Constraint tempConst;
        int jx;
        int ix;
        double res = 0.0;
        double futben = 0.0;
        if (this.NS == 0 && this.NE == 0) {
            return 0.0;
        }
        double maxEnSerHydEngy = maxEnergy - this.hydroEnergy;
        if (maxEnSerHydEngy < 0.0) {
            return 0.0;
        }
        Problem lpprob = new Problem(this.numvar, this.numrest + this.numvar * 2 + 1);
        for (ix = 0; ix < this.numvar; ++ix) {
            Variable tempVar = (Variable)lpprob.newVariable("" + ix);
            tempVar.setType((byte)21);
            tempVar.setUpperBound(this.xmax[ix]);
            tempVar.setLowerBound(this.xmin[ix]);
            tempVar.setObjectiveCoefficient(-this.c[ix]);
        }
        for (jx = 0; jx < this.numrest; ++jx) {
            tempConst = (Constraint)lpprob.newConstraint("" + jx);
            tempConst.setType((byte)13);
            tempConst.setRightHandSide(this.b[jx]);
            for (ix = 0; ix < this.numvar; ++ix) {
                lpprob.setCoefficientAt(jx, ix, this.A[jx][ix]);
            }
        }
        int restcount = this.numrest;
        tempConst = (Constraint)lpprob.newConstraint("" + restcount);
        tempConst.setType((byte)11);
        tempConst.setRightHandSide(maxEnSerHydEngy);
        int numgen = this.NE + this.NS;
        for (ix = 0; ix < numgen; ++ix) {
            lpprob.setCoefficientAt(restcount, ix, 1.0);
        }
        for (ix = numgen; ix < this.numvar; ++ix) {
            lpprob.setCoefficientAt(restcount, ix, 0.0);
        }
        ++restcount;
        for (jx = 0; jx < this.numvar; ++jx) {
            tempConst = (Constraint)lpprob.newConstraint("" + (restcount + jx));
            tempConst.setType((byte)11);
            tempConst.setRightHandSide(this.xmax[jx]);
            for (ix = 0; ix < this.numvar; ++ix) {
                lpprob.setCoefficientAt(restcount + jx, ix, 0.0);
            }
            lpprob.setCoefficientAt(restcount + jx, jx, 1.0);
        }
        restcount += this.numvar;
        for (jx = 0; jx < this.numvar; ++jx) {
            tempConst = (Constraint)lpprob.newConstraint("" + (restcount + jx));
            tempConst.setType((byte)12);
            tempConst.setRightHandSide(this.xmin[jx]);
            for (ix = 0; ix < this.numvar; ++ix) {
                lpprob.setCoefficientAt(restcount + jx, ix, 0.0);
            }
            lpprob.setCoefficientAt(restcount + jx, jx, 1.0);
        }
        DenseSimplex lpsolver = new DenseSimplex((ProblemI)lpprob);
        lpsolver.solve();
        res = 0.0;
        this.sol_lp = (DenseVector)lpsolver.getSolution();
        if (this.sol_lp == null) {
            return 0.0;
        }
        for (i = 0; i < this.NE + this.NS; ++i) {
            res += this.sol_lp.elementAt(i) * this.c[i];
        }
        futben = this.EFB.evalIn(this.sol_lp.elementAt(this.numvar - 1) / 1000.0 * 3.6);
        this.operBenef = res;
        for (i = 0; i < this.NE; ++i) {
            if (this.resHydGen[i].getgrounded()) continue;
            this.hydroEnergy += this.sol_lp.elementAt(i);
        }
        for (i = 0; i < this.NS; ++i) {
            if (this.serHydGen[i].getgrounded()) continue;
            this.hydroEnergy += this.sol_lp.elementAt(i + this.NE);
        }
        this.offerEn += this.hydroEnergy;
        this.finalResState = this.sol_lp.elementAt(this.numvar - 1) / this.restotcapa;
        for (i = 0; i < this.NE; ++i) {
            this.resHydGen[i].setSimVfin(this.sol_lp.elementAt(i + this.NTH + this.NE + this.NS) * 3.6 / 1000.0);
        }
        System.out.println("Hydro Energy of " + this.supplier.getName() + " restricted to " + this.hydroEnergy / (double)this.stagedur);
        return res + futben;
    }

    public void showHydroDispatch(boolean isHydroMarginal, double clrprice, double energy) {
        if (isHydroMarginal) {
            System.out.println(this.supplier.getName() + "_Hydro" + " is marginal.");
            this.myPrintStream.println(this.supplier.getName() + "_Hydro" + " is marginal.");
        }
    }

    public void showThermDispatch(double clrprice, double energy) {
        int ix;
        double sumEnergy = 0.0;
        for (ix = 0; ix < this.thermalGen.length && this.thermalGen[ix].getinv_cost() <= clrprice; ++ix) {
            sumEnergy += this.thermalGen[ix].getpmax();
        }
        if (sumEnergy > energy) {
            System.out.println(this.supplier.getName() + " unit:" + this.thermalGen[ix - 1].getName() + " is marginal.");
            this.myPrintStream.println(this.supplier.getName() + " unit:" + this.thermalGen[ix - 1].getName() + " is marginal.");
        }
    }

    public double getWheelsBalance(int actYear, int actMonth, double actEnPrice) {
        double wheelExpense = 0.0;
        double wheelIncome = 0.0;
        for (int ix = 0; ix < this.bilatContracts.size(); ++ix) {
            mdb_wheel tempWheel = (mdb_wheel)this.bilatContracts.elementAt(ix);
            if (tempWheel.getentry_period() > actYear || tempWheel.getexit_period() < actYear || tempWheel.getentry_period() == actYear && tempWheel.getentry_month() > actMonth || tempWheel.getexit_period() == actYear && tempWheel.getexit_month() < actMonth) continue;
            double aux = tempWheel.getenergy() * (double)this.stagedur;
            wheelIncome += aux * tempWheel.getprice();
            wheelExpense += aux * actEnPrice;
        }
        return wheelIncome - wheelExpense;
    }

    public double getOperHydE() {
        return this.hydroEnergy;
    }

    public double getOperThmBal(double actPrice) {
        double sumBalanc = 0.0;
        for (int ix = 0; ix < this.thermalGen.length; ++ix) {
            if (!(this.thermalGen[ix].getinv_cost() <= actPrice)) continue;
            sumBalanc += this.thermalGen[ix].getpmax() * (actPrice - this.thermalGen[ix].getbeta());
        }
        return sumBalanc * (double)this.stagedur;
    }

    public double getClearThermalOperRev(double clearP, double energiacas) {
        double sumRev = 0.0;
        double sumE = 0.0;
        double lastadd = 0.0;
        for (int ix = 0; ix < this.thermalGen.length && this.thermalGen[ix].getinv_cost() <= clearP; ++ix) {
            lastadd = this.thermalGen[ix].getpmax() * (clearP - this.thermalGen[ix].getbeta());
            sumRev += lastadd;
            sumE += this.thermalGen[ix].getpmax();
        }
        if (sumE > energiacas) {
            sumRev -= lastadd;
        }
        return sumRev * (double)this.stagedur;
    }

    public double getFutExBen() {
        return this.EFB.evalIn(this.sol_lp.elementAt(this.numvar - 1) / 1000.0 * 3.6);
    }
}

