/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import de.core.DeepEdit;
import de.core.Generator;
import de.core.Line;
import de.core.OPFGD;
import de.core.SimpleDialog;
import de.core.comp;
import de.core.ndb_branch;
import de.core.ndb_comp;
import de.core.ndb_inj;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

class OPFGDFrame
extends Frame
implements KeyListener,
ActionListener {
    OPFGD Myequiv;
    String ctrla;
    String owner = null;
    String nitera;
    String convergence;
    Choice MyChoiceOwner = null;
    Choice MyChoiceCtrla = null;
    Choice MyChoiceTol1 = null;
    Choice MyChoiceTol2 = null;
    Choice MyChoiceTol3 = null;
    Choice MyChoiceTol4 = null;
    TextField MyTextField1 = null;
    TextField MyTextField2 = null;
    Checkbox tap;
    Checkbox ups;
    protected Font TextDialogFont;
    protected FontMetrics TextDialogFontMetrics;
    comp TempComponent;
    ndb_comp Tempndb;
    ndb_branch Tempbran;
    Line TempLine;
    Choice MyChoiceLinres = null;

    OPFGDFrame(OPFGD ms) {
        super("DGOD Calculation Options");
        this.Myequiv = ms;
        this.setBackground(Color.lightGray);
        this.TextDialogFont = DeepEdit.TextFont;
        this.TextDialogFontMetrics = this.getFontMetrics(this.TextDialogFont);
        this.setFont(this.TextDialogFont);
        this.setLayout(new FlowLayout());
        Panel titelpanel = new Panel();
        Label titel = new Label("DGOD-SQP CALCULATION OPTIONS");
        titel.setForeground(Color.blue);
        titelpanel.add(titel);
        this.add(titelpanel);
        this.MyChoiceCtrla = new Choice();
        this.ctrla = "ALL CONTROL AREAS";
        Panel datapanelA = new Panel();
        datapanelA.setLayout(new GridLayout(13, 2));
        datapanelA.add(new Label("Select the Control Area"));
        this.Myequiv.ActSchematic.LoadCtrla(this.MyChoiceCtrla);
        datapanelA.add(this.MyChoiceCtrla);
        this.MyChoiceOwner = new Choice();
        this.owner = "ALL OWNER";
        datapanelA.add(new Label("Select the Owner"));
        int aux = 0;
        int cogen = 0;
        for (int ix = 0; ix < this.Myequiv.ActSchematic.Components.size(); ++ix) {
            comp TempComponent = (comp)this.Myequiv.ActSchematic.Components.elementAt(ix);
            if (!TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice() || !(TempComponent instanceof ndb_inj)) continue;
            Generator TempInj1 = (Generator)TempComponent;
            if (cogen == 0) {
                this.MyChoiceOwner.addItem(TempInj1.getinv_owner());
            } else {
                aux = 0;
                for (int cx = 0; cx < this.MyChoiceOwner.getItemCount(); ++cx) {
                    if (!this.MyChoiceOwner.getItem(cx).equals(TempInj1.getinv_owner())) continue;
                    ++aux;
                }
                if (aux == 0) {
                    this.MyChoiceOwner.addItem(TempInj1.getinv_owner());
                }
            }
            ++cogen;
        }
        datapanelA.add(this.MyChoiceOwner);
        datapanelA.add(new Label("Subproblems Solver"));
        this.MyChoiceTol1 = new Choice();
        this.MyChoiceTol1.addItem("Minos            ");
        this.MyChoiceTol1.addItem("Zoutendijk       ");
        this.MyChoiceTol1.addItem("Rosen            ");
        datapanelA.add(this.MyChoiceTol1);
        datapanelA.add(new Label("Iterations"));
        this.MyChoiceTol2 = new Choice();
        this.MyChoiceTol2.addItem("10               ");
        this.MyChoiceTol2.addItem("15               ");
        this.MyChoiceTol2.addItem("20               ");
        this.MyChoiceTol2.addItem("25               ");
        this.MyChoiceTol2.addItem("30               ");
        this.MyChoiceTol2.addItem("60               ");
        this.MyChoiceTol2.addItem("100              ");
        datapanelA.add(this.MyChoiceTol2);
        datapanelA.add(new Label("RHS Tolerance [%]"));
        this.MyChoiceTol3 = new Choice();
        this.MyChoiceTol3.addItem("0.001         ");
        this.MyChoiceTol3.addItem("0.0001       ");
        this.MyChoiceTol3.addItem("0.01        ");
        this.MyChoiceTol3.addItem("0.01         ");
        this.MyChoiceTol3.addItem("0.1          ");
        this.MyChoiceTol3.addItem("1            ");
        this.MyChoiceTol3.addItem("5            ");
        this.MyChoiceTol3.addItem("10           ");
        datapanelA.add(this.MyChoiceTol3);
        datapanelA.add(new Label("Cost Tolerance [%]"));
        this.MyChoiceTol4 = new Choice();
        this.MyChoiceTol4.addItem("0.001          ");
        this.MyChoiceTol4.addItem("0.0001       ");
        this.MyChoiceTol4.addItem("0.5       ");
        this.MyChoiceTol4.addItem("0.01         ");
        this.MyChoiceTol4.addItem("0.1          ");
        this.MyChoiceTol4.addItem("1            ");
        this.MyChoiceTol4.addItem("5            ");
        this.MyChoiceTol4.addItem("10           ");
        datapanelA.add(this.MyChoiceTol4);
        datapanelA.add(new Label("Line Limits"));
        this.MyChoiceLinres = new Choice();
        this.MyChoiceLinres.addItem("Active Power Flow");
        this.MyChoiceLinres.addItem("Current Flow");
        this.MyChoiceLinres.addItem("Not Considered");
        datapanelA.add(this.MyChoiceLinres);
        this.convergence = String.valueOf(this.Myequiv.ActSchematic.getconvergence());
        datapanelA.add(new Label("Limiter Power Factor"));
        this.MyTextField2 = new TextField(this.convergence, 16);
        datapanelA.add(this.MyTextField2);
        this.tap = new Checkbox("Taps as Variable", false);
        this.ups = new Checkbox("Specific Flow in UPFC", false);
        datapanelA.add(this.tap);
        datapanelA.add(this.ups);
        Panel control1 = new Panel();
        this.setLayout(new FlowLayout(1));
        Button button3 = new Button("Show Control Area");
        this.add(datapanelA);
        button3.setActionCommand("Show Control Area");
        button3.addActionListener(this);
        control1.add(button3);
        this.add(control1);
        this.setLayout(new FlowLayout(1));
        Button button4 = new Button("Reset");
        this.add(datapanelA);
        button4.setActionCommand("Reset");
        button4.addActionListener(this);
        control1.add(button4);
        this.add(control1);
        Panel control = new Panel();
        this.setLayout(new FlowLayout(1));
        Button button1 = new Button("Calculate");
        control.add(button1);
        button1.setActionCommand("Apply");
        button1.addActionListener(this);
        Button button2 = new Button(" Cancel ");
        control.add(button2);
        button2.setActionCommand("Cancel");
        button2.addActionListener(this);
        this.add(control);
        this.setBounds(200, 150, 350, 400);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                OPFGDFrame.this.setVisible(false);
                OPFGDFrame.this.dispose();
                OPFGDFrame.this.Myequiv.MyOPFGDFrame = null;
            }
        });
        this.setIconImage(ms.ActFrame.applet.getFrameIconImage());
        this.setVisible(true);
    }

    public void SetNewValues() {
        this.repaint();
    }

    @Override
    public void paint(Graphics g) {
    }

    @Override
    public void keyPressed(KeyEvent event) {
        if (event.getKeyCode() == 27) {
            this.setVisible(false);
            this.dispose();
            this.Myequiv.MyOPFGDFrame = null;
        }
    }

    @Override
    public void keyReleased(KeyEvent event) {
    }

    @Override
    public void keyTyped(KeyEvent event) {
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        Object obj = ev.getSource();
        String label = ev.getActionCommand();
        if (obj instanceof TextField || obj instanceof Button) {
            if (label.equals("Reset")) {
                this.restorecolor();
                this.Myequiv.MyOPFGDFrame = null;
                DeepEdit.MySchematicPanel.repaint();
            } else if (label.equals("Apply") || obj instanceof TextField) {
                this.setVisible(false);
                try {
                    this.SetNewValues();
                    int lin = -1;
                    lin = this.MyChoiceLinres.getSelectedItem().equals("Active Power Flow") ? 1 : (this.MyChoiceLinres.getSelectedItem().equals("Current Flow") ? 2 : (this.MyChoiceLinres.getSelectedItem().equals("Not Considered") ? 3 : -1));
                    if (lin == -1) {
                        System.out.println("ERROR : Serious Problems in Line Limits Selection,");
                        System.out.println("        You should call your provider");
                    }
                    this.Myequiv.setParameters(this.MyChoiceTol1.getSelectedItem(), this.MyChoiceTol2.getSelectedItem(), this.MyChoiceTol3.getSelectedItem(), this.MyChoiceTol4.getSelectedItem(), this.tap.getState(), lin, this.ups.getState(), this.MyChoiceCtrla.getSelectedItem(), this.MyChoiceOwner.getSelectedItem(), this.MyTextField2.getText());
                    this.Myequiv.Calculate(true, 1);
                }
                catch (Exception e) {
                    String message = e.toString();
                    String[] DlgButtons = new String[]{"Apply"};
                    SimpleDialog ExceptionDialog = new SimpleDialog(DeepEdit.frame, "Reading DGOD Parameter Information", message, DlgButtons, 1, 0, 0, 1);
                    this.dispose();
                    this.Myequiv.MyOPFGDFrame = null;
                }
            } else if (label.equals("Cancel")) {
                this.restorecolor();
                this.setVisible(false);
                this.dispose();
                this.Myequiv.MyOPFGDFrame = null;
            }
        }
        if (obj instanceof Button && label.equals("Show Control Area")) {
            this.restorecolor();
            this.visualization(this.MyChoiceCtrla.getSelectedItem());
            DeepEdit.MySchematicPanel.repaint();
            this.repaint();
        }
    }

    public void visualization(String ctrla1) {
        for (int fx = 0; fx < this.Myequiv.ActSchematic.Components.size(); ++fx) {
            ndb_comp Tempndb;
            comp TempComponent = (comp)this.Myequiv.ActSchematic.Components.elementAt(fx);
            if (!TempComponent.getactive() || !TempComponent.getinservice() || !TempComponent.getvalid() || !(Tempndb = (ndb_comp)TempComponent).getctrla().equals(ctrla1)) continue;
            Tempndb.setAlternatekv_Color(Color.red);
        }
    }

    private void restorecolor() {
        DeepEdit.MySchematic.restoreColor();
    }
}

