/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import de.core.DeepEdit;
import de.core.OPF;
import de.core.SimpleDialog;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

class OPFFrame
extends Frame
implements KeyListener,
ActionListener {
    OPF Myequiv;
    String ctrla;
    Choice MyChoiceCtrla = null;
    Choice MyChoiceTol1 = null;
    Choice MyChoiceTol2 = null;
    Choice MyChoiceTol3 = null;
    Choice MyChoiceTol4 = null;
    Choice MyChoiceLinres = null;
    Choice MyChoiceEscala = null;
    Choice MyChoiceUPFCMode = null;
    TextField PhaseAngle = null;
    TextField TurnsRatio = null;
    Checkbox tap;
    protected Font TextDialogFont;
    protected FontMetrics TextDialogFontMetrics;

    OPFFrame(OPF ms) {
        super("OPF Calculation Options");
        this.Myequiv = ms;
        this.setBackground(Color.lightGray);
        this.TextDialogFont = DeepEdit.TextFont;
        this.TextDialogFontMetrics = this.getFontMetrics(this.TextDialogFont);
        this.setFont(this.TextDialogFont);
        this.setLayout(new FlowLayout());
        Panel titelpanel = new Panel();
        Label titel = new Label("OPF-SQP CALCULATION OPTIONS");
        titel.setForeground(Color.blue);
        titelpanel.add(titel);
        this.add(titelpanel);
        this.MyChoiceCtrla = new Choice();
        this.ctrla = "ALL CONTROL AREAS";
        Panel datapanelA = new Panel();
        datapanelA.setLayout(new GridLayout(14, 2));
        datapanelA.add(new Label("Select the Control Area"));
        this.MyChoiceCtrla.addItem(this.ctrla);
        this.Myequiv.ActSchematic.LoadCtrla(this.MyChoiceCtrla);
        datapanelA.add(this.MyChoiceCtrla);
        datapanelA.add(new Label("Subproblems Solver"));
        this.MyChoiceTol1 = new Choice();
        this.MyChoiceTol1.addItem("Minos            ");
        this.MyChoiceTol1.addItem("Zoutendijk       ");
        this.MyChoiceTol1.addItem("Rosen            ");
        datapanelA.add(this.MyChoiceTol1);
        datapanelA.add(new Label("Iterations"));
        this.MyChoiceTol2 = new Choice();
        this.MyChoiceTol2.addItem("20               ");
        this.MyChoiceTol2.addItem("10               ");
        this.MyChoiceTol2.addItem("15               ");
        this.MyChoiceTol2.addItem("20               ");
        this.MyChoiceTol2.addItem("25               ");
        this.MyChoiceTol2.addItem("30               ");
        this.MyChoiceTol2.addItem("60               ");
        this.MyChoiceTol2.addItem("100              ");
        datapanelA.add(this.MyChoiceTol2);
        datapanelA.add(new Label("RHS Tolerance [%]"));
        this.MyChoiceTol3 = new Choice();
        this.MyChoiceTol3.addItem("0.01         ");
        this.MyChoiceTol3.addItem("0.001        ");
        this.MyChoiceTol3.addItem("0.0001       ");
        this.MyChoiceTol3.addItem("0.005        ");
        this.MyChoiceTol3.addItem("0.01         ");
        this.MyChoiceTol3.addItem("0.05         ");
        this.MyChoiceTol3.addItem("0.1          ");
        this.MyChoiceTol3.addItem("1            ");
        this.MyChoiceTol3.addItem("2            ");
        datapanelA.add(this.MyChoiceTol3);
        datapanelA.add(new Label("Cost Tolerance [%]"));
        this.MyChoiceTol4 = new Choice();
        this.MyChoiceTol4.addItem("0.01         ");
        this.MyChoiceTol4.addItem("0.0001       ");
        this.MyChoiceTol4.addItem("0.001        ");
        this.MyChoiceTol4.addItem("0.01         ");
        this.MyChoiceTol4.addItem("0.1          ");
        this.MyChoiceTol4.addItem("0.5          ");
        this.MyChoiceTol4.addItem("1            ");
        this.MyChoiceTol4.addItem("2            ");
        this.MyChoiceTol4.addItem("5            ");
        this.MyChoiceTol4.addItem("10           ");
        datapanelA.add(this.MyChoiceTol4);
        datapanelA.add(new Label("Line Limits"));
        this.MyChoiceLinres = new Choice();
        this.MyChoiceLinres.addItem("Not Considered");
        this.MyChoiceLinres.addItem("Active Power Flow");
        this.MyChoiceLinres.addItem("Current Flow");
        datapanelA.add(this.MyChoiceLinres);
        datapanelA.add(new Label("Step of Iterations"));
        this.MyChoiceEscala = new Choice();
        this.MyChoiceEscala.addItem("1            ");
        this.MyChoiceEscala.addItem("0.9          ");
        this.MyChoiceEscala.addItem("0.8          ");
        this.MyChoiceEscala.addItem("0.7          ");
        this.MyChoiceEscala.addItem("0.6          ");
        this.MyChoiceEscala.addItem("0.5          ");
        datapanelA.add(this.MyChoiceEscala);
        datapanelA.add(new Label("UPFC Control Mode"));
        this.MyChoiceUPFCMode = new Choice();
        this.MyChoiceUPFCMode.addItem("Unconstrained    ");
        this.MyChoiceUPFCMode.addItem("Complete (P,Q,V) ");
        this.MyChoiceUPFCMode.addItem("P and Q Flow     ");
        this.MyChoiceUPFCMode.addItem("Active Power Flow");
        this.MyChoiceUPFCMode.addItem("Voltage control  ");
        this.MyChoiceUPFCMode.addItem("Phase Shifter    ");
        datapanelA.add(this.MyChoiceUPFCMode);
        this.PhaseAngle = new TextField("0", 8);
        this.TurnsRatio = new TextField("1", 8);
        datapanelA.add(new Label("UPFC Phase Shifter Mode"));
        datapanelA.add(new Label(":   "));
        datapanelA.add(new Label("Phase Angle (deg)"));
        datapanelA.add(this.PhaseAngle);
        datapanelA.add(new Label("Turns Ratio"));
        datapanelA.add(this.TurnsRatio);
        this.tap = new Checkbox("Taps as Variable", false);
        datapanelA.add(this.tap);
        datapanelA.add(new Label(" "));
        this.add(datapanelA);
        Panel control = new Panel();
        this.setLayout(new FlowLayout(1));
        Button button1 = new Button("Calculate");
        control.add(button1);
        button1.setActionCommand("Apply");
        button1.addActionListener(this);
        Button button2 = new Button(" Cancel ");
        control.add(button2);
        button2.setActionCommand("Cancel");
        button2.addActionListener(this);
        this.add(control);
        this.setBounds(200, 150, 350, 400);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                OPFFrame.this.setVisible(false);
                OPFFrame.this.dispose();
                OPFFrame.this.Myequiv.MyOPFFrame = null;
            }
        });
        this.setIconImage(ms.applet.getFrameIconImage());
        this.setVisible(true);
    }

    @Override
    public void paint(Graphics g) {
    }

    @Override
    public void keyPressed(KeyEvent event) {
        if (event.getKeyCode() == 27) {
            this.setVisible(false);
            this.dispose();
            this.Myequiv.MyOPFFrame = null;
        }
    }

    @Override
    public void keyReleased(KeyEvent event) {
    }

    @Override
    public void keyTyped(KeyEvent event) {
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        Object obj = ev.getSource();
        String label = ev.getActionCommand();
        if (obj instanceof TextField || obj instanceof Button) {
            if (label.equals("Apply") || obj instanceof TextField) {
                this.setVisible(false);
                try {
                    int lin = -1;
                    lin = this.MyChoiceLinres.getSelectedItem().equals("Active Power Flow") ? 1 : (this.MyChoiceLinres.getSelectedItem().equals("Current Flow") ? 2 : (this.MyChoiceLinres.getSelectedItem().equals("Not Considered") ? 3 : -1));
                    if (lin == -1) {
                        System.out.println("ERROR : Serious Problems in Line Limits Selection,");
                        System.out.println("        You should call your provider");
                    }
                    int upfc_mode = -1;
                    if (this.MyChoiceUPFCMode.getSelectedItem().equals("Unconstrained    ")) {
                        upfc_mode = 0;
                    } else if (this.MyChoiceUPFCMode.getSelectedItem().equals("Complete (P,Q,V) ")) {
                        upfc_mode = 1;
                    } else if (this.MyChoiceUPFCMode.getSelectedItem().equals("P and Q Flow     ")) {
                        upfc_mode = 2;
                    } else if (this.MyChoiceUPFCMode.getSelectedItem().equals("Active Power Flow")) {
                        upfc_mode = 3;
                    } else if (this.MyChoiceUPFCMode.getSelectedItem().equals("Voltage control  ")) {
                        upfc_mode = 4;
                    } else if (this.MyChoiceUPFCMode.getSelectedItem().equals("Phase Shifter    ")) {
                        upfc_mode = 5;
                    }
                    double ang = Double.valueOf(this.PhaseAngle.getText());
                    double ratio = Double.valueOf(this.TurnsRatio.getText());
                    this.Myequiv.setParameters(this.MyChoiceTol1.getSelectedItem(), this.MyChoiceTol2.getSelectedItem(), this.MyChoiceTol3.getSelectedItem(), this.MyChoiceTol4.getSelectedItem(), this.tap.getState(), lin, this.MyChoiceEscala.getSelectedItem(), upfc_mode, ang, ratio);
                    this.Myequiv.Calculate(true, 1);
                }
                catch (Exception e) {
                    String message = e.toString();
                    String[] DlgButtons = new String[]{"Apply"};
                    SimpleDialog ExceptionDialog = new SimpleDialog(DeepEdit.frame, "Reading OPF Parameter Information", message, DlgButtons, 1, 0, 0, 1);
                }
            }
            this.dispose();
            this.Myequiv.MyOPFFrame = null;
        }
    }
}

