/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import VisualNumerics.math.Complex;
import de.core.AnalysisTool;
import de.core.Busbar;
import de.core.DeepEdit;
import de.core.Generator;
import de.core.Line;
import de.core.Load;
import de.core.OPFFrame;
import de.core.Schematic;
import de.core.SimpleDialog;
import de.core.ThreeWindingTrafo;
import de.core.Trafo;
import de.core.Upfc;
import de.core.comp;
import de.core.ndb_branch;
import de.core.ndb_inj;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.Vector;

public class OPF
extends AnalysisTool {
    OPFFrame MyOPFFrame = null;
    Complex[][] MatY;
    Complex[][] MatYact;
    double[][] MatX;
    double[] Pesp;
    double[] Qesp;
    double[] Vesp;
    double[][] PARupfc;
    int[][] TOupfc;
    int lr;
    protected Vector BusbarVectorI;
    int numbran = 0;
    int numnod = 0;
    int numgen = 0;
    int numtrafo = 0;
    int numlin = 0;
    int numupfc = 0;
    int numlast = 0;
    int numlastres = 0;
    int numvar = 0;
    int numres = 0;
    double[] BranchR;
    double[] BranchX;
    double[] BranchB;
    int[] BranchI;
    int[] BranchJ;
    int[] VarNode;
    int[] ResLast;
    boolean overiter = false;
    double mean_c = 1000000.0;
    double[] vec_xminabs;
    double[] vec_xmaxabs;
    double[] vec_xmin;
    double[] vec_xmax;
    double[] vec_xtemp;
    double[] vec_xtempabs;
    double[] vec_xant;
    double[] vec_c;
    double[] vec_RHS;
    double[] vec_OBJ;
    double[] vec_pf;
    double[] vec_lam;
    double[] DiagMat_Q;
    double[] node_p;
    double[] node_q;
    double[] penalty;
    int[] vec_clave;
    double totcost = 0.0;
    double totgen = 0.0;
    double totgenQ = 0.0;
    double totunserP = 0.0;
    double totunserQ = 0.0;
    double totloss = 0.0;
    double totdem = 0.0;
    double totdemQ = 0.0;
    int iteraciones;
    double tolerancia;
    double tolcost;
    double tolfeas;
    int metodo = 1;
    double escala;
    int modop_upfc;
    double ang_desfase;
    double mod_T;
    double[][] mat_W;
    double[][] mat_A;
    DeepEdit applet;
    PrintStream myPPrintStream;
    boolean isTapOptVariable = false;
    int linres = -1;
    boolean upfcres = false;
    double[] tapOrig;
    int[] TapNode;
    Complex[][] MatYSinTap;
    Complex[][] MatYSinTrafo;
    Complex[] ZthreeWinding;
    Complex[] Zreales;
    double[] react;
    double[] resistencias;
    double[] TranchR;
    double[] TranchX;
    double[] TranchB;
    int[] TranchI;
    int[] TranchJ;
    double[] LranchR;
    double[] LranchX;
    double[] LranchB;
    int[] LranchI;
    int[] LranchJ;
    private double sref = this.getSref();

    public OPF(Schematic sch, DeepEdit app) {
        super(sch);
        this.applet = app;
        System.out.println("---------- In OPF Calculation Tool ------------");
        if (this.MyOPFFrame == null) {
            this.MyOPFFrame = new OPFFrame(this);
        } else {
            this.MyOPFFrame.setVisible(true);
        }
    }

    public void Calculate(boolean sino, int modelo) {
        FileOutputStream os;
        boolean konv = false;
        double cost1 = 0.0;
        double cost2 = 0.0;
        double cost3 = 0.0;
        double tol = 0.0;
        FileInputStream is1 = null;
        int iteration = 0;
        int i = 0;
        int j = 0;
        String OPFdat = RESULT_FOLDER + File.separator + "OPF-SQP.dat";
        try {
            OPF.CreateDirectory(RESULT_FOLDER);
            os = new FileOutputStream(OPFdat);
            System.out.println("InitNetwork");
            this.initNetwork(os);
            if (!this.isTapOptVariable) {
                this.MatYact = this.MatY;
            }
            System.out.println("Creating a starting point...");
            this.startPoint();
            System.out.println("Writing costs to file...");
            this.make_vec_c();
            System.out.println("Creating Hessian matrix...");
            this.make_DiagMat_Q();
            System.out.println("Creating constraint A matrix...");
            this.make_mat_Afix();
            System.out.println("Creating RHS vector...");
            this.make_vec_clave();
            System.out.println("Storing system costs information...");
            cost1 = cost2 = this.make_cost();
            System.out.println("Initialization Finished");
            for (i = 0; i < this.numvar; ++i) {
                this.vec_xtemp[i] = 0.0;
            }
            for (i = 0; i < this.numres; ++i) {
                this.vec_lam[i] = 0.0;
            }
            this.lr = -1;
            this.lr = this.linres == 1 ? 2 * this.numlin : (this.linres == 2 ? this.numlin : 0);
            while (!konv && iteration < this.iteraciones) {
                System.out.println("OPF-iteration... " + ++iteration);
                if (this.isTapOptVariable) {
                    this.miupdateMatY();
                }
                this.make_vec_OBJ();
                System.out.println(" Armado A ");
                this.make_mat_A();
                System.out.println(" Armado RHS ");
                this.make_vec_RHS();
                System.out.println(" Armado W ");
                this.make_mat_W();
                this.update_UPFC_limits();
                this.update_vec_xlimits();
                this.myPPrintStream.println("ITERACION: " + iteration);
                this.myPPrintStream.println(" ");
                if (this.metodo == 1 || this.metodo == 2 || this.metodo == 3) {
                    SimpleDialog ExceptionDialog;
                    String message;
                    PrintStream myPrintStream;
                    BufferedOutputStream bos;
                    try {
                        os = new FileOutputStream("./economic.dat");
                        bos = new BufferedOutputStream(os, 32768);
                        myPrintStream = new PrintStream(bos, false);
                        System.out.println("Escritura de economic.dat");
                        myPrintStream.println(this.numvar);
                        myPrintStream.println(" ");
                        myPrintStream.println(this.numres);
                        myPrintStream.println(" ");
                        for (i = 0; i < this.numvar; ++i) {
                            myPrintStream.println(this.vec_OBJ[i]);
                        }
                        myPrintStream.println(" ");
                        for (i = 0; i < this.numres; ++i) {
                            myPrintStream.println(this.vec_RHS[i]);
                        }
                        myPrintStream.println(" ");
                        for (i = 0; i < this.numres; ++i) {
                            for (j = 0; j < this.numvar; ++j) {
                                myPrintStream.println(this.mat_A[i][j]);
                            }
                            myPrintStream.println(" ");
                        }
                        myPrintStream.println(" ");
                        for (i = 0; i < this.numres; ++i) {
                            myPrintStream.println(this.vec_clave[i]);
                        }
                        myPrintStream.println(" ");
                        for (i = 0; i < this.numvar; ++i) {
                            myPrintStream.println(this.vec_xmin[i]);
                        }
                        myPrintStream.println(" ");
                        for (i = 0; i < this.numvar; ++i) {
                            myPrintStream.println(this.vec_xmax[i]);
                        }
                        myPrintStream.println(" ");
                        myPrintStream.println("min");
                        myPrintStream.println("OPF");
                        myPrintStream.close();
                    }
                    catch (Exception e) {
                        message = e.toString();
                        String[] DlgButtons = new String[]{"OK"};
                        ExceptionDialog = new SimpleDialog(DeepEdit.frame, "OPF", message + " C1", DlgButtons, 1, 0, 0, 1);
                        return;
                    }
                    try {
                        os = new FileOutputStream("./matw.dat");
                        bos = new BufferedOutputStream(os, 32768);
                        myPrintStream = new PrintStream(bos, false);
                        myPrintStream.println(this.numvar);
                        myPrintStream.println(" ");
                        for (i = 0; i < this.numvar; ++i) {
                            for (j = 0; j < this.numvar; ++j) {
                                myPrintStream.println(this.mat_W[i][j]);
                            }
                            myPrintStream.println(" ");
                        }
                        myPrintStream.println(" ");
                        myPrintStream.close();
                    }
                    catch (Exception e) {
                        message = e.toString();
                        String[] DlgButtons = new String[]{"OK"};
                        ExceptionDialog = new SimpleDialog(DeepEdit.frame, "OPF-Matw", message + " C2", DlgButtons, 1, 0, 0, 1);
                        return;
                    }
                    System.out.println("Call Solver");
                    try {
                        OPF.Dorun("cmd /C " + DeepEdit.PathDOS + "cuadra.exe>sys.log", DeepEdit.PathUNIX + "cuadra > sys.log", false);
                    }
                    catch (Exception e) {
                        message = e.toString();
                        String[] DlgButtons = new String[]{"OK"};
                        ExceptionDialog = new SimpleDialog(DeepEdit.frame, "Call Cuadra", message + " C3", DlgButtons, 1, 0, 0, 1);
                        return;
                    }
                    System.out.println("End Solver");
                    try {
                        String ln;
                        is1 = new FileInputStream("./soluci.dat");
                        i = 0;
                        BufferedReader is = new BufferedReader(new InputStreamReader(is1));
                        while ((ln = is.readLine()) != null) {
                            if (i != 0) {
                                if (i <= this.numvar) {
                                    this.vec_xtemp[i - 1] = Double.valueOf(ln);
                                    int n = i - 1;
                                    this.vec_xtempabs[n] = this.vec_xtempabs[n] + this.escala * this.vec_xtemp[i - 1];
                                } else {
                                    this.vec_lam[i - this.numvar - 1] = Double.valueOf(ln);
                                }
                            } else {
                                cost3 = Double.valueOf(ln);
                            }
                            ++i;
                        }
                        is.close();
                        if (this.escala < 1.0) {
                            this.escala += 0.025;
                        }
                        if (this.escala >= 1.0) {
                            this.escala = 1.0;
                        }
                        is = null;
                    }
                    catch (Exception e) {
                        message = e.toString();
                        String[] DlgButtons = new String[]{"OK"};
                        ExceptionDialog = new SimpleDialog(DeepEdit.frame, "OPF, reading soluci.dat", message + " C4", DlgButtons, 1, 0, 0, 1);
                    }
                }
                cost2 = this.make_cost();
                System.out.println(" Armado RHS ");
                this.make_vec_RHS();
                tol = ((cost2 += cost3) - cost1) * (cost2 - cost1);
                double feasIndex = 0.0;
                double maxModRHS = -1.0;
                for (i = 0; i < 2 * this.numnod + this.numlastres; ++i) {
                    feasIndex += this.vec_RHS[i] * this.vec_RHS[i] * this.sref * this.sref;
                    if (!(Math.abs(this.vec_RHS[i] * this.sref) > maxModRHS)) continue;
                    maxModRHS = Math.abs(this.vec_RHS[i] * this.sref);
                }
                if (this.upfcres) {
                    if (this.modop_upfc == 1) {
                        for (i = this.numres - 3 * this.numupfc; i < this.numres; ++i) {
                            feasIndex += this.vec_RHS[i] * this.vec_RHS[i] * this.sref * this.sref;
                            if (!(Math.abs(this.vec_RHS[i] * this.sref) > maxModRHS)) continue;
                            maxModRHS = Math.abs(this.vec_RHS[i] * this.sref);
                        }
                    } else if (this.modop_upfc == 2 || this.modop_upfc == 5) {
                        for (i = this.numres - 2 * this.numupfc; i < this.numres; ++i) {
                            feasIndex += this.vec_RHS[i] * this.vec_RHS[i] * this.sref * this.sref;
                            if (!(Math.abs(this.vec_RHS[i] * this.sref) > maxModRHS)) continue;
                            maxModRHS = Math.abs(this.vec_RHS[i] * this.sref);
                        }
                    } else {
                        for (i = this.numres - this.numupfc; i < this.numres; ++i) {
                            feasIndex += this.vec_RHS[i] * this.vec_RHS[i] * this.sref * this.sref;
                            if (!(Math.abs(this.vec_RHS[i] * this.sref) > maxModRHS)) continue;
                            maxModRHS = Math.abs(this.vec_RHS[i] * this.sref);
                        }
                    }
                }
                this.myPPrintStream.println("   ");
                this.myPPrintStream.println(" Matriz A");
                for (i = 0; i < this.numres; ++i) {
                    for (j = 0; j < this.numvar - 1; ++j) {
                        this.myPPrintStream.print(" " + this.mat_A[i][j] + "    ");
                    }
                    this.myPPrintStream.println(" " + this.mat_A[i][this.numvar - 1] + "    ");
                }
                this.myPPrintStream.println("   ");
                this.myPPrintStream.println(" RHS ");
                for (i = 0; i < this.numres; ++i) {
                    this.myPPrintStream.println(" " + this.vec_RHS[i]);
                }
                this.myPPrintStream.println("   ");
                this.myPPrintStream.println(" Matriz W ");
                for (i = 0; i < this.numvar; ++i) {
                    for (j = 0; j < this.numvar - 1; ++j) {
                        this.myPPrintStream.print(" " + this.mat_W[i][j] + "    ");
                    }
                    this.myPPrintStream.println(" " + this.mat_W[i][this.numvar - 1] + "    ");
                }
                this.myPPrintStream.println("   ");
                this.myPPrintStream.println("Vector incremental[pu]");
                OPF.printVector(this.myPPrintStream, this.vec_xtemp, this.numvar);
                this.myPPrintStream.println("Vector absoluto[pu]");
                OPF.printVector(this.myPPrintStream, this.vec_xtempabs, this.numvar);
                this.myPPrintStream.println("Multiplicadores[pu]");
                OPF.printVector(this.myPPrintStream, this.vec_lam, this.numres);
                this.myPPrintStream.println("   ");
                feasIndex = Math.sqrt(feasIndex);
                System.out.println(" ----------------------------------------------");
                System.out.println(" RHS TOL [%]         = " + feasIndex * 100.0 / Math.sqrt(this.totdem * this.totdem + this.totdemQ * this.totdemQ));
                System.out.println(" COS TOL [%]         = " + Math.abs(cost2 - cost1) * 200.0 / (cost2 + cost1));
                System.out.println(" ----------------------------------------------");
                System.out.println(" Feasibility         = " + feasIndex);
                System.out.println(" Max corrimiento     = " + maxModRHS);
                System.out.println(" ----------------------------------------------");
                System.out.println(" Valor Absoluto      = " + Math.abs(cost2 - cost1));
                System.out.println(" 0.5 [%] costo medio = " + 0.005 * (cost2 + cost1) / 2.0);
                System.out.println(" ----------------------------------------------");
                System.out.println(" ----------------------------------------------");
                System.out.println(" Fun Ob [$]          = " + cost2);
                System.out.println(" ----------------------------------------------");
                this.myPPrintStream.println(" ----------------------------------------------");
                this.myPPrintStream.println(" RHS TOL [%]         = " + feasIndex * 100.0 / Math.sqrt(this.totdem * this.totdem + this.totdemQ * this.totdemQ));
                this.myPPrintStream.println(" COS TOL [%]         = " + Math.abs(cost2 - cost1) * 200.0 / (cost2 + cost1));
                this.myPPrintStream.println(" ----------------------------------------------");
                this.myPPrintStream.println(" Feasibility         = " + feasIndex);
                this.myPPrintStream.println(" Max corrimiento     = " + maxModRHS);
                this.myPPrintStream.println(" ----------------------------------------------");
                this.myPPrintStream.println(" Valor Absoluto      = " + Math.abs(cost2 - cost1));
                this.myPPrintStream.println(" 0.5 [%] costo medio = " + 0.005 * (cost2 + cost1) / 2.0);
                this.myPPrintStream.println(" ----------------------------------------------");
                this.myPPrintStream.println(" ----------------------------------------------");
                this.myPPrintStream.println(" Fun Ob [$]          = " + cost2);
                this.myPPrintStream.println(" ----------------------------------------------");
                boolean conv_upfc = true;
                boolean conv_line = true;
                if (this.numupfc > 0) {
                    for (i = 0; i < this.numupfc; ++i) {
                        if (this.vec_RHS[i + 2 * this.numnod + this.numlastres + this.lr + this.numupfc] >= -this.tolfeas && this.vec_RHS[i + 2 * this.numnod + this.numlastres + this.lr] >= -this.tolfeas) continue;
                        conv_upfc = false;
                    }
                }
                if (this.linres == 1) {
                    for (i = 2 * this.numnod + this.numlastres; i < 2 * this.numnod + this.numlastres + this.numlin; ++i) {
                        if (this.vec_RHS[i] >= -this.tolfeas) continue;
                        conv_line = false;
                    }
                    for (i = 2 * this.numnod + this.numlastres + this.numlin; i < 2 * this.numnod + this.numlastres + 2 * this.numlin; ++i) {
                        if (this.vec_RHS[i] <= this.tolfeas) continue;
                        conv_line = false;
                    }
                } else if (this.linres == 2) {
                    for (i = 2 * this.numnod + this.numlastres; i < 2 * this.numnod + this.numlastres + this.numlin; ++i) {
                        if (this.vec_RHS[i] >= -this.tolfeas) continue;
                        conv_line = false;
                    }
                }
                if (feasIndex <= this.tolfeas * Math.sqrt(this.totdem * this.totdem + this.totdemQ * this.totdemQ) / 100.0 && Math.abs(cost2 - cost1) <= this.tolcost * (cost2 + cost1) / 200.0 && conv_upfc && conv_line) {
                    System.out.println("   ");
                    System.out.println("          *************************  ");
                    System.out.println("          *Convergencia Encontrada*  ");
                    System.out.println("          *************************  ");
                    System.out.println("   ");
                    this.myPPrintStream.println("   ");
                    this.myPPrintStream.println("          *************************  ");
                    this.myPPrintStream.println("          *Convergencia Encontrada*  ");
                    this.myPPrintStream.println("          *************************  ");
                    this.myPPrintStream.println("   ");
                    konv = true;
                }
                cost1 = cost2;
                if (iteration == 1) {
                    konv = false;
                }
                if (iteration <= this.iteraciones) continue;
                this.overiter = true;
            }
            double fix_cost = 0.0;
            for (int ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
                comp TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
                if (!TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice() || !(TempComponent instanceof Generator)) continue;
                Generator TempGenerator = (Generator)TempComponent;
                fix_cost += TempGenerator.getalpha();
            }
            this.ActSchematic.setfitnes(-cost2);
            this.totcost = cost2;
            this.ActSchematic.settotcost(this.totcost);
            System.out.println("Before Writeresults");
            this.WriteResults();
            System.out.println("Writeresults");
            this.ActSchematic.settotgen(this.totgen);
            this.ActSchematic.settotunser(this.totunserP);
            this.totloss = this.totgen + this.totunserP - this.totdem;
            this.ActSchematic.settotloss(this.totloss);
            this.ActSchematic.settotdem(this.totdem);
            System.out.println("************************************************************");
            System.out.println(" Optimization Results");
            System.out.println(" Objective Function  [$]  = " + (cost2 + fix_cost));
            System.out.println("************************************************************");
            System.out.println(" Operation costs          = " + this.totcost);
            System.out.println(" Active Generation        = " + this.totgen);
            System.out.println(" Reactive Generation      = " + this.totgenQ);
            System.out.println(" Load Unserved            = " + this.totunserP);
            System.out.println(" Total Active Loss        = " + this.totloss + " <=> " + 100.0 * this.totloss / this.totdem + " [%]");
            System.out.println(" Total Active Demand      = " + this.totdem);
            System.out.println(" Total Reactive Demand    = " + this.totdemQ);
            System.out.println("************************************************************");
            this.myPPrintStream.println("************************************************************");
            this.myPPrintStream.println(" Optimization Results");
            this.myPPrintStream.println(" Objective Function  [$]  = " + (cost2 + fix_cost));
            this.myPPrintStream.println("************************************************************");
            this.myPPrintStream.println(" Operation costs          = " + this.totcost);
            this.myPPrintStream.println(" Active Generation        = " + this.totgen);
            this.myPPrintStream.println(" Reactive Generation      = " + this.totgenQ);
            this.myPPrintStream.println(" Load Unserved            = " + this.totunserP);
            this.myPPrintStream.println(" Total Active Loss        = " + this.totloss + " <=> " + 100.0 * this.totloss / this.totdem + " [%]");
            this.myPPrintStream.println(" Total Active Demand      = " + this.totdem);
            this.myPPrintStream.println(" Total Reactive Demand    = " + this.totdemQ);
            this.myPPrintStream.println("************************************************************");
            this.ActSchematic.Modified = false;
            this.ActSchematic.Modifiedstate = false;
            this.ActSchematic.changeGIS = true;
            DeepEdit.MySchematicPanel.repaint();
            os.close();
            this.IdidntRealize();
        }
        catch (Exception e) {
            String message = e.toString();
            String[] DlgButtons = new String[]{"OK"};
            SimpleDialog ExceptionDialog = new SimpleDialog(DeepEdit.frame, "OPF", message + " C5", DlgButtons, 1, 0, 0, 1);
            return;
        }
        try {
            this.myPPrintStream.close();
            if (os != null) {
                os.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        System.out.println("Results was written in ." + File.separator + "results" + File.separator + "OPF-SQP.dat");
    }

    public void initNetwork(FileOutputStream os) {
        Load TempLoad;
        Line TempLine;
        Busbar TempBusbar;
        comp TempComponent;
        Complex segundiag;
        Complex Zrama23;
        Complex invertapnodiag;
        Complex Afinal;
        this.myPPrintStream = new PrintStream(os);
        this.myPPrintStream.println("Datos, System Name:  " + this.ActSchematic.getsysname());
        int ix = 0;
        int i = 0;
        int j = 0;
        int c = 0;
        int count = 0;
        int count1 = 0;
        int count2 = 0;
        int count3 = 0;
        int count4 = 0;
        int count5 = 0;
        int count6 = 0;
        int countaux = 0;
        boolean countaux3 = false;
        int con1 = 10000;
        int con2 = 10000;
        int con3 = 10000;
        int parestrafo = 0;
        int fintrafo = 0;
        this.BusbarVectorI = new Vector();
        double ueb = 0.0;
        double res = 0.0;
        double z = 0.0;
        double reac = 0.0;
        double yy = 0.0;
        double y1 = 0.0;
        double y2 = 0.0;
        double b = 0.0;
        double rserie = 0.0;
        double xserie = 0.0;
        double gshunt = 0.0;
        double bshunt = 0.0;
        double Zk12 = 0.0;
        double Zk13 = 0.0;
        double Zk23 = 0.0;
        double tap1 = 1.0;
        double tap2 = 1.0;
        double tap3 = 1.0;
        double modulo = 0.0;
        double partimag = 0.0;
        double potapa1 = 0.0;
        double potapa2 = 0.0;
        double potapa3 = 0.0;
        double tapdiag1 = 0.0;
        double tapdiag2 = 0.0;
        double tapnodiag = 0.0;
        Complex A2 = Afinal = new Complex(0.0, 0.0);
        Complex A1 = Afinal;
        Complex ramaY3 = Afinal;
        Complex ramaY2 = Afinal;
        Complex ramaY1 = Afinal;
        Complex ramaY = Afinal;
        Complex invertapdiag2 = invertapnodiag = new Complex(0.0, 0.0);
        Complex invertapdiag1 = invertapnodiag;
        Complex neutro = new Complex(1.0, 0.0);
        Complex Zrama13 = Zrama23 = new Complex(0.0, 0.0);
        Complex Zrama12 = Zrama23;
        Complex primerdiag = segundiag = new Complex(0.0, 0.0);
        Complex factory = segundiag;
        Complex factor = segundiag;
        Complex auxc3 = segundiag;
        Complex invertA3 = segundiag;
        Complex A3 = segundiag;
        this.totdem = 0.0;
        this.totdemQ = 0.0;
        this.numnod = 0;
        this.numlin = 0;
        this.numbran = 0;
        this.numtran = 0;
        this.numtranthree = 0;
        this.numupfc = 0;
        this.numlast = 0;
        this.numlastres = 0;
        this.numgen = 0;
        this.numtrafo = 0;
        for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
            TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
            if (!TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice()) continue;
            if (TempComponent instanceof Busbar) {
                TempComponent.InformAllComponents();
                TempBusbar = (Busbar)TempComponent;
                this.myPPrintStream.println(this.numnod + "\t" + TempComponent.getName() + "\t" + TempBusbar.getctrla() + "\t" + "Barra Considerada");
                ++this.numnod;
                this.BusbarVectorI.addElement(TempComponent);
            }
            if (TempComponent instanceof ndb_branch) {
                if (TempComponent instanceof Line) {
                    TempLine = (Line)TempComponent;
                    TempLine.InformPartner(TempLine.ConnComps1, TempLine.getx1(), TempLine.gety1(), 1);
                    TempLine.InformPartner(TempLine.ConnComps2, TempLine.getx2(), TempLine.gety2(), 2);
                    ++this.numlin;
                }
                if (TempComponent instanceof Trafo) {
                    TempComponent.InformAllComponents();
                    ++this.numtran;
                    ++this.numtrafo;
                }
                if (TempComponent instanceof ThreeWindingTrafo) {
                    TempComponent.InformAllComponents();
                    this.numtran += 3;
                    this.numtrafo += 3;
                    this.numbran += 2;
                }
                if (TempComponent instanceof Upfc) {
                    TempComponent.InformAllComponents();
                    ++this.numupfc;
                }
                ++this.numbran;
            }
            if (TempComponent instanceof ndb_inj) {
                TempComponent.InformAllComponents();
                ++this.numgen;
            }
            if (!(TempComponent instanceof Load)) continue;
            TempComponent.InformAllComponents();
            TempLoad = (Load)TempComponent;
            if (TempLoad.getq0() != 0.0 && TempLoad.getp0() != 0.0) {
                ++this.numlastres;
            }
            ++this.numlast;
            this.totdem += TempLoad.getp0();
            this.totdemQ += TempLoad.getq0();
        }
        this.numvar = this.isTapOptVariable ? 2 * this.numgen + 2 * this.numlast + 2 * this.numnod + this.numtran + 3 * this.numupfc : 2 * this.numgen + 2 * this.numlast + 2 * this.numnod + 3 * this.numupfc;
        int lr = -1;
        lr = this.linres == 1 ? 2 * this.numlin : (this.linres == 2 ? this.numlin : 0);
        if (this.upfcres) {
            if (this.modop_upfc == 1) {
                this.numres = 2 * this.numnod + this.numlastres + lr + 5 * this.numupfc;
            } else if (this.modop_upfc == 2 || this.modop_upfc == 5) {
                this.numres = 2 * this.numnod + this.numlastres + lr + 4 * this.numupfc;
            } else if (this.modop_upfc == 3 || this.modop_upfc == 4) {
                this.numres = 2 * this.numnod + this.numlastres + lr + 3 * this.numupfc;
            }
        } else {
            this.numres = 2 * this.numnod + this.numlastres + lr + 2 * this.numupfc;
        }
        System.out.println("numvar= " + this.numvar);
        System.out.println("numres= " + this.numres);
        this.BranchR = new double[this.numbran];
        this.BranchX = new double[this.numbran];
        this.BranchB = new double[this.numbran];
        this.BranchI = new int[this.numbran];
        this.BranchJ = new int[this.numbran];
        this.react = new double[3];
        this.resistencias = new double[3];
        this.ZthreeWinding = new Complex[3];
        this.Zreales = new Complex[3];
        this.TranchR = new double[this.numtrafo];
        this.TranchX = new double[this.numtrafo];
        this.TranchB = new double[this.numtrafo];
        this.TranchI = new int[this.numtrafo];
        this.TranchJ = new int[this.numtrafo];
        this.LranchR = new double[this.numlin];
        this.LranchX = new double[this.numlin];
        this.LranchB = new double[this.numlin];
        this.LranchI = new int[this.numlin];
        this.LranchJ = new int[this.numlin];
        for (i = 0; i < 3; ++i) {
            this.react[i] = 0.0;
            this.resistencias[i] = 0.0;
            this.ZthreeWinding[i] = new Complex(1.0, 0.0);
            this.Zreales[i] = new Complex(0.0, 0.0);
        }
        if (this.numupfc > 0) {
            this.TOupfc = new int[this.numupfc][2];
            this.Pesp = new double[this.numupfc];
            this.Qesp = new double[this.numupfc];
            this.Vesp = new double[this.numupfc];
            this.PARupfc = new double[this.numupfc][6];
            for (i = 0; i < this.numupfc; ++i) {
                this.Pesp[i] = 0.0;
                this.Qesp[i] = 0.0;
                this.Vesp[i] = 0.0;
                for (j = 0; j < 2; ++j) {
                    this.TOupfc[i][j] = -1;
                }
                for (j = 0; j < 6; ++j) {
                    this.PARupfc[i][j] = 0.0;
                }
            }
        }
        this.VarNode = new int[this.numvar];
        this.ResLast = new int[this.numlastres];
        this.vec_clave = new int[this.numres];
        this.vec_xminabs = new double[this.numvar];
        this.vec_xmaxabs = new double[this.numvar];
        this.vec_xmin = new double[this.numvar];
        this.vec_xmax = new double[this.numvar];
        this.vec_xtemp = new double[this.numvar];
        this.vec_xtempabs = new double[this.numvar];
        this.vec_xant = new double[this.numvar];
        this.vec_lam = new double[this.numres];
        this.vec_c = new double[2 * this.numgen + 2 * this.numlast];
        this.vec_RHS = new double[this.numres];
        this.vec_OBJ = new double[this.numvar];
        this.vec_pf = new double[this.numlastres];
        this.DiagMat_Q = new double[2 * this.numgen + 2 * this.numlast];
        this.node_p = new double[this.numnod];
        this.node_q = new double[this.numnod];
        this.penalty = new double[this.numnod];
        this.MatY = new Complex[this.numnod][this.numnod];
        this.MatX = new double[this.numnod][this.numnod];
        this.MatYact = new Complex[this.numnod][this.numnod];
        this.mat_A = new double[this.numres][this.numvar];
        this.mat_W = new double[this.numvar][this.numvar];
        this.TapNode = new int[this.numtrafo];
        this.MatYSinTap = new Complex[this.numnod][this.numnod];
        this.tapOrig = new double[this.numtrafo];
        this.MatYSinTrafo = new Complex[this.numnod][this.numnod];
        for (i = 0; i < this.numnod; ++i) {
            for (j = 0; j < this.numnod; ++j) {
                this.MatY[i][j] = new Complex();
                this.MatYact[i][j] = new Complex();
                this.MatYSinTap[i][j] = new Complex();
                this.MatYSinTrafo[i][j] = new Complex();
            }
        }
        for (i = 0; i < this.numres; ++i) {
            for (j = 0; j < this.numvar; ++j) {
                this.mat_A[i][j] = 0.0;
            }
        }
        int countline = 0;
        for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
            Complex auxc2;
            Complex auxc1;
            TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
            if (!TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice()) continue;
            if (TempComponent instanceof Line && (con1 = this.numbus((TempLine = (Line)TempComponent).getcon1())) != 10000 && (con2 = this.numbus(TempLine.getcon2())) != 10000) {
                if (Math.sqrt(TempLine.getxx1() * TempLine.getb1()) * TempLine.getlen() > 0.1396) {
                    System.out.println("No approximations were considered while modeling line: " + TempLine.getName());
                    double[] param = OPF.getExactLineParam(TempLine.getr1(), TempLine.getxx1(), TempLine.getg1(), TempLine.getb1(), TempLine.getlen());
                    this.BranchR[count] = param[0];
                    this.BranchX[count] = param[1];
                    this.BranchB[count] = param[3];
                } else {
                    this.BranchX[count] = TempLine.getxx1() * TempLine.getlen();
                    this.BranchR[count] = TempLine.getr1() * TempLine.getlen();
                    this.BranchB[count] = TempLine.getb1() * TempLine.getlen() / 2.0;
                }
                double Ybase = this.sref / (TempLine.getun1() * TempLine.getun1());
                this.BranchX[count] = this.BranchX[count] * Ybase;
                this.BranchR[count] = this.BranchR[count] * Ybase;
                this.BranchB[count] = this.BranchB[count] / Ybase;
                this.BranchI[count] = con1;
                this.BranchJ[count] = con2;
                auxc1 = new Complex(this.BranchR[count], this.BranchX[count]);
                auxc2 = new Complex(1.0);
                auxc1 = auxc2.divide(auxc1);
                auxc2 = new Complex(0.0, this.BranchB[count]);
                this.MatY[this.BranchJ[count]][this.BranchI[count]].add(Complex.negate((Complex)auxc1));
                this.MatY[this.BranchI[count]][this.BranchJ[count]].add(Complex.negate((Complex)auxc1));
                this.MatY[this.BranchI[count]][this.BranchI[count]].add(Complex.add((Complex)auxc1, (Complex)auxc2));
                this.MatY[this.BranchJ[count]][this.BranchJ[count]].add(Complex.add((Complex)auxc1, (Complex)auxc2));
                this.MatYSinTap[this.BranchJ[count]][this.BranchI[count]].add(Complex.negate((Complex)auxc1));
                this.MatYSinTap[this.BranchI[count]][this.BranchJ[count]].add(Complex.negate((Complex)auxc1));
                this.MatYSinTap[this.BranchI[count]][this.BranchI[count]].add(Complex.add((Complex)auxc1, (Complex)auxc2));
                this.MatYSinTap[this.BranchJ[count]][this.BranchJ[count]].add(Complex.add((Complex)auxc1, (Complex)auxc2));
                this.MatYSinTrafo[this.BranchJ[count]][this.BranchI[count]].add(Complex.negate((Complex)auxc1));
                this.MatYSinTrafo[this.BranchI[count]][this.BranchJ[count]].add(Complex.negate((Complex)auxc1));
                this.MatYSinTrafo[this.BranchI[count]][this.BranchI[count]].add(Complex.add((Complex)auxc1, (Complex)auxc2));
                this.MatYSinTrafo[this.BranchJ[count]][this.BranchJ[count]].add(Complex.add((Complex)auxc1, (Complex)auxc2));
                this.MatX[con1][con2] = this.BranchX[count];
                this.MatX[con2][con1] = this.BranchX[count];
                this.LranchX[countline] = TempLine.getxx1() * TempLine.getlen() * this.sref / (TempLine.getun1() * TempLine.getun1());
                this.LranchR[countline] = TempLine.getr1() * TempLine.getlen() * this.sref / (TempLine.getun1() * TempLine.getun1());
                this.LranchB[countline] = TempLine.getb1() * TempLine.getlen() / 2.0 / this.sref * (TempLine.getun1() * TempLine.getun1());
                this.LranchI[countline] = con1;
                this.LranchJ[countline] = con2;
                ++count;
                ++countline;
            }
            if (TempComponent instanceof Trafo) {
                Trafo TempTrafo = (Trafo)TempComponent;
                TempTrafo.actualizet();
                TempTrafo.sett_re_old(TempTrafo.gett_re());
                con1 = this.numbus(TempTrafo.getcon1());
                if (con1 != 10000 && (con2 = this.numbus(TempTrafo.getcon2())) != 10000) {
                    ueb = TempTrafo.getun1() / TempTrafo.getun2() / (TempTrafo.getur1() / TempTrafo.getur2());
                    res = TempTrafo.getpcu() * 0.001 * ueb * ueb / TempTrafo.getsn() * this.sref / TempTrafo.getsn();
                    z = TempTrafo.getuk() * 0.01 * ueb * ueb * this.sref / TempTrafo.getsn();
                    b = TempTrafo.geti0() * 0.01 * 0.5 / this.sref * TempTrafo.getsn();
                    reac = TempTrafo.getuk() >= 0.0 ? Math.sqrt(z * z - res * res) : -Math.sqrt(z * z - res * res);
                    this.BranchX[count] = reac;
                    this.BranchR[count] = res;
                    this.BranchB[count] = b;
                    this.BranchI[count] = con1;
                    this.BranchJ[count] = con2;
                    this.TranchX[count3] = reac;
                    this.TranchR[count3] = res;
                    this.TranchB[count3] = b;
                    this.TranchI[count3] = con1;
                    this.TranchJ[count3] = con2;
                    auxc1 = new Complex(this.BranchR[count], this.BranchX[count]);
                    auxc2 = new Complex(1.0);
                    auxc1 = Complex.divide((Complex)auxc2, (Complex)auxc1);
                    auxc2 = new Complex(0.0, this.BranchB[count]);
                    this.MatYSinTap[this.BranchJ[count]][this.BranchI[count]].add(Complex.negate((Complex)auxc1));
                    this.MatYSinTap[this.BranchI[count]][this.BranchJ[count]].add(Complex.negate((Complex)auxc1));
                    this.MatYSinTap[this.BranchI[count]][this.BranchI[count]].add(Complex.add((Complex)auxc1, (Complex)auxc2));
                    this.MatYSinTap[this.BranchJ[count]][this.BranchJ[count]].add(Complex.add((Complex)auxc1, (Complex)auxc2));
                    if (TempTrafo.gett_im() == 0.0) {
                        factor = new Complex(TempTrafo.gett_re(), 0.0);
                        modulo = TempTrafo.gett_re();
                    } else {
                        partimag = TempTrafo.gett_im() * Math.PI / 180.0;
                        factor = new Complex(Math.cos(partimag), Math.sin(partimag));
                        modulo = 1.0;
                    }
                    this.MatY[this.BranchJ[count]][this.BranchI[count]].add(Complex.negate((Complex)Complex.divide((Complex)auxc1, (Complex)factor)));
                    this.MatY[this.BranchI[count]][this.BranchJ[count]].add(Complex.negate((Complex)Complex.divide((Complex)auxc1, (Complex)Complex.conjugate((Complex)factor))));
                    this.MatY[this.BranchI[count]][this.BranchI[count]].add(Complex.add((Complex)auxc1, (Complex)auxc2).divide(modulo * modulo));
                    this.MatY[this.BranchJ[count]][this.BranchJ[count]].add(Complex.add((Complex)auxc1, (Complex)auxc2));
                    this.tapOrig[count3] = TempTrafo.gett_re();
                    if (this.isTapOptVariable) {
                        this.vec_xmaxabs[count3 + 2 * this.numgen + 2 * this.numlast + 2 * this.numnod] = 100.0 / (100.0 - Math.abs(TempTrafo.getzsl()));
                        this.vec_xminabs[count3 + 2 * this.numgen + 2 * this.numlast + 2 * this.numnod] = 100.0 / (100.0 + Math.abs(TempTrafo.getzsl()));
                        this.vec_xtempabs[count3 + 2 * this.numgen + 2 * this.numlast + 2 * this.numnod] = 1.0;
                    }
                    this.MatX[con1][con2] = this.BranchX[count];
                    this.MatX[con2][con1] = this.BranchX[count];
                    ++count;
                    ++count3;
                }
            }
            if (TempComponent instanceof ThreeWindingTrafo) {
                ThreeWindingTrafo TempThreeWindingTrafo = (ThreeWindingTrafo)TempComponent;
                TempThreeWindingTrafo.actualizet();
                TempThreeWindingTrafo.sett_re_old(TempThreeWindingTrafo.gett_re());
                TempThreeWindingTrafo.sett_re1_old(TempThreeWindingTrafo.gett_re1());
                TempThreeWindingTrafo.sett_re2_old(TempThreeWindingTrafo.gett_re2());
                con1 = this.numbus(TempThreeWindingTrafo.getcon1());
                if (con1 > -1 && (con2 = this.numbus(TempThreeWindingTrafo.getcon2())) > -1 && (con3 = this.numbus(TempThreeWindingTrafo.getcon3())) > -1) {
                    potapa1 = TempThreeWindingTrafo.getsn() > TempThreeWindingTrafo.getsn1() ? TempThreeWindingTrafo.getsn1() : TempThreeWindingTrafo.getsn();
                    potapa2 = TempThreeWindingTrafo.getsn() > TempThreeWindingTrafo.getsn2() ? TempThreeWindingTrafo.getsn2() : TempThreeWindingTrafo.getsn();
                    potapa3 = TempThreeWindingTrafo.getsn1() > TempThreeWindingTrafo.getsn2() ? TempThreeWindingTrafo.getsn2() : TempThreeWindingTrafo.getsn1();
                    this.resistencias[0] = TempThreeWindingTrafo.getpcu() * (0.001 / potapa1) * (TempThreeWindingTrafo.getun1() * TempThreeWindingTrafo.getun1() / potapa1) * this.sref / TempThreeWindingTrafo.getsn();
                    this.resistencias[1] = TempThreeWindingTrafo.getpcu13() * (0.001 / potapa2) * (TempThreeWindingTrafo.getun1() * TempThreeWindingTrafo.getun1() / potapa2) * this.sref / TempThreeWindingTrafo.getsn1();
                    this.resistencias[2] = TempThreeWindingTrafo.getpcu23() * (0.001 / potapa3) * (TempThreeWindingTrafo.getun1() * TempThreeWindingTrafo.getun1() / potapa3) * this.sref / TempThreeWindingTrafo.getsn2();
                    this.resistencias[0] = this.resistencias[0] * TempThreeWindingTrafo.getsn() / (TempThreeWindingTrafo.getun1() * TempThreeWindingTrafo.getun1());
                    this.resistencias[1] = this.resistencias[1] * TempThreeWindingTrafo.getsn() / (TempThreeWindingTrafo.getun1() * TempThreeWindingTrafo.getun1());
                    this.resistencias[2] = this.resistencias[2] * TempThreeWindingTrafo.getsn() / (TempThreeWindingTrafo.getun1() * TempThreeWindingTrafo.getun1());
                    Zk12 = TempThreeWindingTrafo.getuk12() * 0.01 * (TempThreeWindingTrafo.getun1() * TempThreeWindingTrafo.getun1()) / potapa1 * this.sref / TempThreeWindingTrafo.getsn();
                    Zk13 = TempThreeWindingTrafo.getuk13() * 0.01 * (TempThreeWindingTrafo.getun1() * TempThreeWindingTrafo.getun1()) / potapa2 * this.sref / TempThreeWindingTrafo.getsn1();
                    Zk23 = TempThreeWindingTrafo.getuk23() * 0.01 * (TempThreeWindingTrafo.getun1() * TempThreeWindingTrafo.getun1()) / potapa3 * this.sref / TempThreeWindingTrafo.getsn2();
                    Zk12 = Zk12 * TempThreeWindingTrafo.getsn() / (TempThreeWindingTrafo.getun1() * TempThreeWindingTrafo.getun1());
                    Zk13 = Zk13 * TempThreeWindingTrafo.getsn() / (TempThreeWindingTrafo.getun1() * TempThreeWindingTrafo.getun1());
                    Zk23 = Zk23 * TempThreeWindingTrafo.getsn() / (TempThreeWindingTrafo.getun1() * TempThreeWindingTrafo.getun1());
                    b = TempThreeWindingTrafo.geti0() * 0.01 / this.sref * TempThreeWindingTrafo.getsn();
                    tap1 = TempThreeWindingTrafo.gett_re();
                    tap2 = TempThreeWindingTrafo.gett_re1();
                    tap3 = TempThreeWindingTrafo.gett_re2();
                    c = 0;
                    parestrafo = 0;
                    this.react[0] = TempThreeWindingTrafo.getuk12() >= 0.0 ? Math.sqrt(Zk12 * Zk12 - this.resistencias[0] * this.resistencias[0]) : -Math.sqrt(Zk12 * Zk12 - this.resistencias[0] * this.resistencias[0]);
                    this.react[1] = TempThreeWindingTrafo.getuk13() >= 0.0 ? Math.sqrt(Zk13 * Zk13 - this.resistencias[1] * this.resistencias[1]) : -Math.sqrt(Zk13 * Zk13 - this.resistencias[1] * this.resistencias[1]);
                    this.react[2] = TempThreeWindingTrafo.getuk23() >= 0.0 ? Math.sqrt(Zk23 * Zk23 - this.resistencias[2] * this.resistencias[2]) : -Math.sqrt(Zk23 * Zk23 - this.resistencias[2] * this.resistencias[2]);
                    this.ZthreeWinding[0] = new Complex(0.5 * (this.resistencias[0] + this.resistencias[1] - this.resistencias[2]), 0.5 * (this.react[0] + this.react[1] - this.react[2]));
                    this.ZthreeWinding[1] = new Complex(0.5 * (this.resistencias[0] + this.resistencias[2] - this.resistencias[1]), 0.5 * (this.react[0] + this.react[2] - this.react[1]));
                    this.ZthreeWinding[2] = new Complex(0.5 * (this.resistencias[1] + this.resistencias[2] - this.resistencias[0]), 0.5 * (this.react[1] + this.react[2] - this.react[0]));
                    Zrama12 = new Complex(this.resistencias[0], this.react[0]);
                    Zrama13 = new Complex(this.resistencias[1], this.react[1]);
                    Zrama23 = new Complex(this.resistencias[2], this.react[2]);
                    this.Zreales[0] = Complex.add((Complex)Zrama12, (Complex)Complex.divide((Complex)Complex.multiply((Complex)this.ZthreeWinding[0], (Complex)this.ZthreeWinding[1]), (Complex)this.ZthreeWinding[2]));
                    this.Zreales[1] = Complex.add((Complex)Zrama13, (Complex)Complex.divide((Complex)Complex.multiply((Complex)this.ZthreeWinding[0], (Complex)this.ZthreeWinding[2]), (Complex)this.ZthreeWinding[1]));
                    this.Zreales[2] = Complex.add((Complex)Zrama23, (Complex)Complex.divide((Complex)Complex.multiply((Complex)this.ZthreeWinding[1], (Complex)this.ZthreeWinding[2]), (Complex)this.ZthreeWinding[0]));
                    auxc3 = new Complex(0.0, b);
                    fintrafo = count + 3;
                    for (count = countaux = count; count < fintrafo; ++count) {
                        this.BranchX[count] = this.Zreales[c].im;
                        this.BranchR[count] = this.Zreales[c].re;
                        this.BranchB[count] = 0.0;
                        auxc1 = new Complex(this.BranchR[count], this.BranchX[count]);
                        auxc1 = new Complex(this.ZthreeWinding[c]);
                        auxc2 = new Complex(1.0);
                        auxc1 = Complex.divide((Complex)auxc2, (Complex)auxc1);
                        if (c == 0) {
                            ramaY1 = auxc1;
                        } else if (c == 1) {
                            ramaY2 = auxc1;
                        } else if (c == 2) {
                            ramaY3 = auxc1;
                        }
                        ++c;
                    }
                    A1 = Complex.divide((Complex)ramaY1, (Complex)Complex.add((Complex)ramaY1, (Complex)Complex.add((Complex)ramaY2, (Complex)ramaY3)));
                    A2 = Complex.divide((Complex)ramaY2, (Complex)Complex.add((Complex)ramaY1, (Complex)Complex.add((Complex)ramaY2, (Complex)ramaY3)));
                    A3 = Complex.add((Complex)ramaY1, (Complex)Complex.add((Complex)ramaY2, (Complex)ramaY3));
                    invertA3 = Complex.divide((Complex)neutro, (Complex)A3);
                    factory = Complex.multiply((Complex)A3, (Complex)auxc3);
                    for (count = countaux; count < fintrafo; ++count) {
                        if (parestrafo == 0) {
                            this.BranchI[count] = con1;
                            this.BranchJ[count] = con2;
                            this.TranchX[count3] = this.Zreales[0].im;
                            this.TranchR[count3] = this.Zreales[0].re;
                            this.TranchB[count3] = 0.0;
                            this.TranchI[count3] = con1;
                            this.TranchJ[count3] = con2;
                            this.tapOrig[count3] = TempThreeWindingTrafo.gett_re();
                            if (this.isTapOptVariable) {
                                this.vec_xmaxabs[count3 + 2 * this.numgen + 2 * this.numlast + 2 * this.numnod] = 100.0 / (100.0 - Math.abs(TempThreeWindingTrafo.getzsl()));
                                this.vec_xminabs[count3 + 2 * this.numgen + 2 * this.numlast + 2 * this.numnod] = 100.0 / (100.0 + Math.abs(TempThreeWindingTrafo.getzsl()));
                                this.vec_xtempabs[count3 + 2 * this.numgen + 2 * this.numlast + 2 * this.numnod] = 1.0;
                            }
                            this.MatX[con1][con2] = this.BranchX[count];
                            this.MatX[con2][con1] = this.BranchX[count];
                            Afinal = A1;
                            ramaY = ramaY2;
                            tapdiag1 = tap1 * tap1;
                            tapnodiag = tap1 * tap2;
                            tapdiag2 = tap2 * tap2;
                            if (TempThreeWindingTrafo.getlado() == "HV") {
                                System.out.println("HV");
                                primerdiag = factory;
                                segundiag = new Complex(0.0, 0.0);
                                this.BranchB[count] = b;
                                this.TranchB[count3] = b;
                            }
                        } else if (parestrafo == 1) {
                            this.BranchI[count] = con3;
                            this.BranchJ[count] = con1;
                            this.TranchX[count3] = this.Zreales[1].im;
                            this.TranchR[count3] = this.Zreales[1].re;
                            this.TranchB[count3] = 0.0;
                            this.TranchI[count3] = con3;
                            this.TranchJ[count3] = con1;
                            this.tapOrig[count3] = TempThreeWindingTrafo.gett_re2();
                            if (this.isTapOptVariable) {
                                this.vec_xmaxabs[count3 + 2 * this.numgen + 2 * this.numlast + 2 * this.numnod] = 100.0 / (100.0 - Math.abs(TempThreeWindingTrafo.getzsl2()));
                                this.vec_xminabs[count3 + 2 * this.numgen + 2 * this.numlast + 2 * this.numnod] = 100.0 / (100.0 + Math.abs(TempThreeWindingTrafo.getzsl2()));
                                this.vec_xtempabs[count3 + 2 * this.numgen + 2 * this.numlast + 2 * this.numnod] = 1.0;
                            }
                            this.MatX[con1][con3] = this.BranchX[count];
                            this.MatX[con3][con1] = this.BranchX[count];
                            Afinal = A1;
                            ramaY = ramaY3;
                            tapdiag1 = tap1 * tap1;
                            tapnodiag = tap1 * tap3;
                            tapdiag2 = tap3 * tap3;
                            if (TempThreeWindingTrafo.getlado() == "LV") {
                                System.out.println("LV");
                                primerdiag = new Complex(0.0, 0.0);
                                segundiag = factory;
                                this.BranchB[count] = b;
                                this.TranchB[count3] = b;
                            }
                        } else if (parestrafo == 2) {
                            this.BranchI[count] = con2;
                            this.BranchJ[count] = con3;
                            this.TranchX[count3] = this.Zreales[2].im;
                            this.TranchR[count3] = this.Zreales[2].re;
                            this.TranchB[count3] = 0.0;
                            this.TranchI[count3] = con2;
                            this.TranchJ[count3] = con3;
                            this.tapOrig[count3] = TempThreeWindingTrafo.gett_re1();
                            if (this.isTapOptVariable) {
                                this.vec_xmaxabs[count3 + 2 * this.numgen + 2 * this.numlast + 2 * this.numnod] = 100.0 / (100.0 - Math.abs(TempThreeWindingTrafo.getzsl1()));
                                this.vec_xminabs[count3 + 2 * this.numgen + 2 * this.numlast + 2 * this.numnod] = 100.0 / (100.0 + Math.abs(TempThreeWindingTrafo.getzsl1()));
                                this.vec_xtempabs[count3 + 2 * this.numgen + 2 * this.numlast + 2 * this.numnod] = 1.0;
                            }
                            this.MatX[con2][con3] = this.BranchX[count];
                            this.MatX[con3][con2] = this.BranchX[count];
                            Afinal = A2;
                            ramaY = ramaY3;
                            tapdiag1 = tap2 * tap2;
                            tapnodiag = tap2 * tap3;
                            tapdiag2 = tap3 * tap3;
                            if (TempThreeWindingTrafo.getlado() == "MV") {
                                System.out.println("MV");
                                primerdiag = factory;
                                segundiag = new Complex(0.0, 0.0);
                                this.BranchB[count] = b;
                                this.TranchB[count3] = b;
                            }
                        }
                        invertapdiag1 = new Complex(tapdiag1, 0.0);
                        invertapnodiag = new Complex(tapnodiag, 0.0);
                        invertapdiag2 = new Complex(tapdiag2, 0.0);
                        invertapdiag1 = Complex.divide((Complex)neutro, (double)tapdiag1);
                        invertapnodiag = Complex.divide((Complex)neutro, (double)tapnodiag);
                        invertapdiag2 = Complex.divide((Complex)neutro, (double)tapdiag2);
                        this.MatY[this.BranchJ[count]][this.BranchI[count]].add(Complex.negate((Complex)Complex.multiply((Complex)ramaY, (Complex)Complex.multiply((Complex)Afinal, (Complex)invertapnodiag))));
                        this.MatY[this.BranchI[count]][this.BranchJ[count]].add(Complex.negate((Complex)Complex.multiply((Complex)ramaY, (Complex)Complex.multiply((Complex)Afinal, (Complex)invertapnodiag))));
                        this.MatY[this.BranchI[count]][this.BranchI[count]].add(Complex.add((Complex)Complex.multiply((Complex)ramaY, (Complex)Complex.multiply((Complex)Afinal, (Complex)invertapdiag1)), (Complex)Complex.multiply((Complex)primerdiag, (Complex)Complex.multiply((Complex)invertA3, (Complex)invertapdiag1))));
                        this.MatY[this.BranchJ[count]][this.BranchJ[count]].add(Complex.add((Complex)Complex.multiply((Complex)ramaY, (Complex)Complex.multiply((Complex)Afinal, (Complex)invertapdiag2)), (Complex)Complex.multiply((Complex)segundiag, (Complex)Complex.multiply((Complex)invertA3, (Complex)invertapdiag2))));
                        this.MatYSinTap[this.BranchJ[count]][this.BranchI[count]].add(Complex.negate((Complex)Complex.multiply((Complex)ramaY, (Complex)Afinal)));
                        this.MatYSinTap[this.BranchI[count]][this.BranchJ[count]].add(Complex.negate((Complex)Complex.multiply((Complex)ramaY, (Complex)Afinal)));
                        this.MatYSinTap[this.BranchI[count]][this.BranchI[count]].add(Complex.add((Complex)Complex.multiply((Complex)ramaY, (Complex)Afinal), (Complex)Complex.multiply((Complex)primerdiag, (Complex)invertA3)));
                        this.MatYSinTap[this.BranchJ[count]][this.BranchJ[count]].add(Complex.add((Complex)Complex.multiply((Complex)ramaY, (Complex)Afinal), (Complex)Complex.multiply((Complex)segundiag, (Complex)invertA3)));
                        ++parestrafo;
                        ++count3;
                        primerdiag = new Complex(0.0, 0.0);
                        segundiag = new Complex(0.0, 0.0);
                    }
                }
            }
            if (TempComponent instanceof Upfc) {
                int onn = this.isTapOptVariable ? 2 * this.numgen + 2 * this.numlast + 2 * this.numnod + this.numtran : 2 * this.numgen + 2 * this.numlast + 2 * this.numnod;
                Upfc TempUpfc = (Upfc)TempComponent;
                con1 = this.numbus(TempUpfc.getcon1());
                if (con1 != 10000 && (con2 = this.numbus(TempUpfc.getcon2())) != 10000) {
                    double auxr = TempUpfc.getun1() * TempUpfc.getun1() / this.sref;
                    rserie = TempUpfc.getrboost() / auxr;
                    xserie = TempUpfc.getxboost() / auxr;
                    gshunt = 0.0;
                    bshunt = -1.0 / (TempUpfc.getxexc() / auxr);
                    this.BranchX[count] = xserie;
                    this.BranchR[count] = rserie;
                    this.BranchB[count] = bshunt;
                    this.BranchI[count] = con1;
                    this.BranchJ[count] = con2;
                    auxc1 = new Complex(this.BranchR[count], this.BranchX[count]);
                    auxc2 = new Complex(1.0);
                    auxc1 = Complex.divide((Complex)auxc2, (Complex)auxc1);
                    auxc2 = new Complex(0.0, this.BranchB[count]);
                    Complex auxzero = new Complex(0.0, 0.0);
                    this.MatY[this.BranchJ[count]][this.BranchI[count]].add(Complex.negate((Complex)auxc1));
                    this.MatY[this.BranchI[count]][this.BranchJ[count]].add(Complex.negate((Complex)auxc1));
                    this.MatY[this.BranchI[count]][this.BranchI[count]].add(Complex.add((Complex)auxc1, (Complex)auxc2));
                    this.MatY[this.BranchJ[count]][this.BranchJ[count]].add(Complex.add((Complex)auxc1, (Complex)auxzero));
                    if (TempUpfc.getsconv1() >= TempUpfc.getsconv2()) {
                        this.vec_xminabs[count6 + onn] = -TempUpfc.getsconv2() / this.sref;
                        this.vec_xmaxabs[count6 + onn] = TempUpfc.getsconv2() / this.sref;
                        this.vec_xtempabs[count6 + onn] = 0.24309;
                    } else {
                        this.vec_xminabs[count6 + onn] = -TempUpfc.getsconv1() / this.sref;
                        this.vec_xmaxabs[count6 + onn] = TempUpfc.getsconv1() / this.sref;
                        this.vec_xtempabs[count6 + onn] = 0.24309;
                    }
                    this.vec_xminabs[count6 + this.numupfc + onn] = -(TempUpfc.getsconv1() / this.sref);
                    this.vec_xmaxabs[count6 + this.numupfc + onn] = TempUpfc.getsconv1() / this.sref;
                    this.vec_xtempabs[count6 + this.numupfc + onn] = -9.941;
                    this.vec_xminabs[count6 + 2 * this.numupfc + onn] = -TempUpfc.getsconv2() / this.sref;
                    this.vec_xmaxabs[count6 + 2 * this.numupfc + onn] = TempUpfc.getsconv2() / this.sref;
                    this.vec_xtempabs[count6 + 2 * this.numupfc + onn] = -0.05836;
                    this.Pesp[count6] = TempUpfc.getpspec() / this.sref;
                    this.Qesp[count6] = TempUpfc.getqspec() / this.sref;
                    this.Vesp[count6] = TempUpfc.getvispec() / TempUpfc.getun1();
                    this.TOupfc[count6][0] = this.BranchI[count];
                    this.TOupfc[count6][1] = this.BranchJ[count];
                    this.PARupfc[count6][0] = rserie;
                    this.PARupfc[count6][1] = xserie;
                    this.PARupfc[count6][2] = gshunt;
                    this.PARupfc[count6][3] = bshunt;
                    this.PARupfc[count6][4] = TempUpfc.getbmax() / TempUpfc.getun1();
                    this.PARupfc[count6][5] = TempUpfc.getemax() / TempUpfc.getun1();
                    this.MatX[con1][con2] = this.BranchX[count];
                    this.MatX[con2][con1] = this.BranchX[count];
                    ++count;
                    ++count6;
                }
            }
            if (TempComponent instanceof ndb_inj) {
                ndb_inj TempInj = (ndb_inj)TempComponent;
                this.vec_xminabs[count1] = TempInj.getpmin() / this.sref;
                this.vec_xmaxabs[count1] = TempInj.getpmax() / this.sref;
                this.vec_xtempabs[count1] = TempInj.getName().equals("Generator_North") ? 0.8251 : (TempInj.getName().equals("Generator_South") ? 0.7571 : Math.max(this.vec_xminabs[count1], TempInj.getp() / this.sref));
                this.vec_xminabs[count1 + this.numgen] = TempInj.getqmin() / this.sref;
                this.vec_xmaxabs[count1 + this.numgen] = TempInj.getqmax() / this.sref;
                this.vec_xtempabs[count1 + this.numgen] = Math.max(this.vec_xminabs[count1 + this.numgen], TempInj.getq() / this.sref);
                ++count1;
            }
            if (TempComponent instanceof Load) {
                TempLoad = (Load)TempComponent;
                this.vec_xminabs[count2 + 2 * this.numgen] = 0.0;
                this.vec_xmaxabs[count2 + 2 * this.numgen] = TempLoad.getp0() / this.sref;
                this.vec_xminabs[count2 + 2 * this.numgen + this.numlast] = Math.min(TempLoad.getq0() / this.sref, 0.0);
                this.vec_xmaxabs[count2 + 2 * this.numgen + this.numlast] = Math.max(TempLoad.getq0() / this.sref, 0.0);
                if (TempLoad.getq0() != 0.0 && TempLoad.getp0() != 0.0) {
                    this.ResLast[count5] = count2;
                    this.vec_pf[count5] = -TempLoad.getp0() / TempLoad.getq0();
                    ++count5;
                }
                if (Math.abs(TempLoad.getp0()) < 0.09) {
                    this.vec_xminabs[count2 + 2 * this.numgen] = 0.0;
                    this.vec_xmaxabs[count2 + 2 * this.numgen] = 0.0;
                    this.vec_xminabs[count2 + 2 * this.numgen + this.numlast] = 0.0;
                    this.vec_xmaxabs[count2 + 2 * this.numgen + this.numlast] = 0.0;
                }
                ++count2;
            }
            if (!(TempComponent instanceof Busbar)) continue;
            TempBusbar = (Busbar)TempComponent;
            this.vec_xminabs[count4 + 2 * this.numgen + 2 * this.numlast] = TempBusbar.getumin();
            this.vec_xmaxabs[count4 + 2 * this.numgen + 2 * this.numlast] = TempBusbar.getumax();
            if (count4 == 0) {
                this.vec_xminabs[count4 + 2 * this.numgen + 2 * this.numlast + this.numnod] = 0.0;
                this.vec_xmaxabs[count4 + 2 * this.numgen + 2 * this.numlast + this.numnod] = 0.0;
            } else {
                this.vec_xminabs[count4 + 2 * this.numgen + 2 * this.numlast + this.numnod] = -Math.PI;
                this.vec_xmaxabs[count4 + 2 * this.numgen + 2 * this.numlast + this.numnod] = Math.PI;
            }
            ++count4;
        }
    }

    public static void printMatrix(PrintStream myPrintStream, Complex[][] m, int ii, int jj) {
        for (int i = 0; i < ii; ++i) {
            for (int j = 0; j < jj; ++j) {
                myPrintStream.print(m[i][j] + "\t ");
            }
            myPrintStream.println();
        }
        myPrintStream.println();
    }

    public static void printMatrix(PrintStream myPrintStream, double[][] m, int ii, int jj) {
        for (int i = 0; i < ii; ++i) {
            for (int j = 0; j < jj; ++j) {
                myPrintStream.print(m[i][j] + "\t ");
            }
            myPrintStream.println();
        }
        myPrintStream.println();
    }

    public static void printMatrix(double[][] m, int ii, int jj) {
        for (int i = 0; i < ii; ++i) {
            for (int j = 0; j < jj; ++j) {
                System.out.print(m[i][j] + "\t ");
            }
            System.out.println();
        }
        System.out.println();
    }

    public static void printVector(PrintStream myPrintStream, Complex[] v, int ii) {
        for (int i = 0; i < ii; ++i) {
            myPrintStream.print(i + "\t" + v[i] + "\t");
            myPrintStream.println();
        }
        myPrintStream.println();
    }

    public static void printVector(PrintStream myPrintStream, double[] v, int ii) {
        for (int i = 0; i < ii; ++i) {
            myPrintStream.print(i + "\t" + v[i] + "\t");
            myPrintStream.println();
        }
        myPrintStream.println();
    }

    public static void printVector(int[] v, int ii) {
        for (int i = 0; i < ii; ++i) {
            System.out.print(i + "\t" + v[i] + "\t");
            System.out.println();
        }
        System.out.println();
    }

    public void miupdateMatY() {
        int i;
        int aux = 2 * this.numgen + 2 * this.numlast + 2 * this.numnod;
        int kon1 = -1;
        int kon2 = -1;
        Complex AY = new Complex(0.0, 0.0);
        for (i = 0; i < this.numnod; ++i) {
            for (int j = 0; j < this.numnod; ++j) {
                this.MatYact[i][j].multiply(0.0);
                this.MatYact[i][j].add(this.MatYSinTrafo[i][j]);
            }
        }
        for (i = 0; i < this.numnod; ++i) {
            for (int k = 0; k < this.numtrafo; ++k) {
                if (this.TranchI[k] != i) continue;
                kon1 = this.TranchI[k];
                kon2 = this.TranchJ[k];
                Complex auxc1 = new Complex(this.TranchR[k], this.TranchX[k]);
                Complex auxc2 = new Complex(1.0);
                auxc1 = Complex.divide((Complex)auxc2, (Complex)auxc1);
                auxc2 = new Complex(0.0, this.TranchB[k]);
                Complex yij = new Complex(0.0, 0.0);
                Complex yji = new Complex(0.0, 0.0);
                Complex yii = new Complex(0.0, 0.0);
                Complex yjj = new Complex(0.0, 0.0);
                yij.add(Complex.negate((Complex)auxc1));
                yji.add(Complex.negate((Complex)auxc1));
                yjj.add(Complex.add((Complex)auxc1, (Complex)auxc2));
                yii.add(Complex.add((Complex)auxc1, (Complex)auxc2));
                Complex mula1 = new Complex(this.vec_xtempabs[aux + k], 0.0);
                Complex mula2 = new Complex(this.vec_xtempabs[aux + k] * this.vec_xtempabs[aux + k], 0.0);
                this.MatYact[kon1][kon1].add(Complex.multiply((Complex)yii, (Complex)mula2));
                this.MatYact[kon1][kon2].add(Complex.multiply((Complex)yij, (Complex)mula1));
                this.MatYact[kon2][kon1].add(Complex.multiply((Complex)yji, (Complex)mula1));
                this.MatYact[kon2][kon2].add(yjj);
            }
        }
    }

    public void update_vec_xlimits() {
        for (int i = 0; i < this.numvar; ++i) {
            this.vec_xmin[i] = this.vec_xminabs[i] - this.vec_xtempabs[i];
            this.vec_xmax[i] = this.vec_xmaxabs[i] - this.vec_xtempabs[i];
        }
    }

    public void make_vec_c() {
        comp TempComponent;
        int i = 0;
        int ix = 0;
        int count = 0;
        int count1 = 0;
        for (i = 0; i < 2 * this.numgen + 2 * this.numlast; ++i) {
            this.vec_c[i] = 0.0;
        }
        for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
            TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
            if (!TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice() || !(TempComponent instanceof ndb_inj)) continue;
            ndb_inj TempInj = (ndb_inj)TempComponent;
            this.vec_c[count] = TempInj.getbeta() * this.sref;
            this.VarNode[count] = this.numbus(TempInj.getcon2());
            this.VarNode[count + this.numgen] = this.numbus(TempInj.getcon2());
            ++count;
        }
        for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
            TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
            if (!TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice() || !(TempComponent instanceof Load)) continue;
            Load TempLoad = (Load)TempComponent;
            this.vec_c[count1 + 2 * this.numgen] = TempLoad.getbeta() * this.sref;
            this.VarNode[count1 + 2 * this.numgen] = this.numbus(TempLoad.getcon2());
            this.VarNode[count1 + 2 * this.numgen + this.numlast] = this.numbus(TempLoad.getcon2());
            int n = this.VarNode[count1 + 2 * this.numgen];
            this.node_p[n] = this.node_p[n] - TempLoad.getp0() / this.sref;
            this.myPPrintStream.println("p0 = " + TempLoad.getp0() / this.sref);
            int n2 = this.VarNode[count1 + 2 * this.numgen];
            this.node_q[n2] = this.node_q[n2] - TempLoad.getq0() / this.sref;
            ++count1;
        }
    }

    public void make_mat_Afix() {
        int i = 0;
        boolean j = false;
        int k = 0;
        int l = 0;
        boolean count = false;
        int offres = 0;
        int onnvar = 0;
        for (i = 0; i < this.numgen; ++i) {
            this.mat_A[this.VarNode[i]][i] = 1.0;
            this.mat_A[this.VarNode[i] + this.numnod][i + this.numgen] = 1.0;
        }
        for (i = 0; i < this.numlast; ++i) {
            this.mat_A[this.VarNode[i + 2 * this.numgen]][2 * this.numgen + i] = 1.0;
            this.mat_A[this.VarNode[i + 2 * this.numgen] + this.numnod][2 * this.numgen + this.numlast + i] = 1.0;
        }
        for (i = 0; i < this.numlastres; ++i) {
            this.mat_A[i + 2 * this.numnod][2 * this.numgen + this.ResLast[i]] = 1.0;
            this.mat_A[i + 2 * this.numnod][2 * this.numgen + this.numlast + this.ResLast[i]] = this.vec_pf[i];
        }
        onnvar = this.isTapOptVariable ? 2 * this.numgen + 2 * this.numlast + 2 * this.numnod + this.numtran : 2 * this.numgen + 2 * this.numlast + 2 * this.numnod;
        offres = this.linres == 1 ? 2 * this.numnod + this.numlastres + 2 * this.numlin : (this.linres == 2 ? 2 * this.numnod + this.numlastres + this.numlin : 2 * this.numnod + this.numlastres);
        if (this.numupfc > 0) {
            for (k = 0; k < this.numnod; ++k) {
                for (l = 0; l < this.numupfc; ++l) {
                    if (this.TOupfc[l][0] != k) continue;
                    this.mat_A[this.TOupfc[l][0]][onnvar + l] = -1.0;
                    this.mat_A[this.TOupfc[l][1]][onnvar + l] = 1.0;
                    this.mat_A[this.TOupfc[l][0] + this.numnod][onnvar + this.numupfc + l] = -1.0;
                    this.mat_A[this.TOupfc[l][1] + this.numnod][onnvar + 2 * this.numupfc + l] = -1.0;
                }
            }
        }
    }

    public void make_mat_W() {
        Line TempLine;
        comp TempComponent;
        int corvar;
        int con2;
        int con1;
        double v;
        double w;
        int i = 0;
        int j = 0;
        int k = 0;
        int off = 0;
        int offdos = 0;
        int onn = 0;
        double rserie = 0.0;
        double xserie = 0.0;
        double gshunt = 0.0;
        double bshunt = 0.0;
        double vboost = 0.0;
        double beta = 0.0;
        double vexc = 0.0;
        double epsilon = 0.0;
        double Pfe = 0.0;
        double Qe = 0.0;
        double Qb = 0.0;
        double VeMax = 0.0;
        double VbMax = 0.0;
        double alfa = 0.0;
        double delta = 0.0;
        double vnexc = 0.0;
        double vnboost = 0.0;
        double thexc = 0.0;
        double thboost = 0.0;
        off = 2 * this.numgen + 2 * this.numlast;
        offdos = this.isTapOptVariable ? 2 * this.numgen + 2 * this.numlast + 2 * this.numnod + this.numtran : 2 * this.numgen + 2 * this.numlast + 2 * this.numnod;
        if (this.linres == 1) {
            onn = 2 * this.numnod + this.numlastres + 2 * this.numlin;
        } else if (this.linres == 2) {
            onn = 2 * this.numnod + this.numlastres + this.numlin;
        } else if (this.linres == 3) {
            onn = 2 * this.numnod + this.numlastres;
        }
        for (i = 0; i < this.numvar; ++i) {
            for (j = 0; j < this.numvar; ++j) {
                this.mat_W[i][j] = 0.0;
            }
        }
        for (i = 0; i < off; ++i) {
            this.mat_W[i][i] = this.DiagMat_Q[i];
        }
        int nn = this.numnod;
        for (i = 0; i < nn; ++i) {
            double[] dArray = this.mat_W[off + i];
            int n = off + i;
            dArray[n] = dArray[n] - 2.0 * Complex.abs((Complex)this.MatYact[i][i]) * Math.cos(Complex.argument((Complex)this.MatYact[i][i])) * this.vec_lam[i];
            double[] dArray2 = this.mat_W[off + i];
            int n2 = off + i;
            dArray2[n2] = dArray2[n2] - 2.0 * Complex.abs((Complex)this.MatYact[i][i]) * Math.sin(-Complex.argument((Complex)this.MatYact[i][i])) * this.vec_lam[i + nn];
            for (j = 0; j < nn; ++j) {
                if (i == j) continue;
                w = -Complex.abs((Complex)this.MatYact[i][j]) * Math.cos(this.vec_xtempabs[off + nn + i] - this.vec_xtempabs[off + nn + j] - Complex.argument((Complex)this.MatYact[i][j]));
                double[] dArray3 = this.mat_W[i + off];
                int n3 = j + off;
                dArray3[n3] = dArray3[n3] + w * this.vec_lam[i];
                double[] dArray4 = this.mat_W[j + off];
                int n4 = i + off;
                dArray4[n4] = dArray4[n4] + w * this.vec_lam[i];
                w = -Complex.abs((Complex)this.MatYact[i][j]) * Math.sin(this.vec_xtempabs[off + nn + i] - this.vec_xtempabs[off + nn + j] - Complex.argument((Complex)this.MatYact[i][j]));
                double[] dArray5 = this.mat_W[i + off];
                int n5 = j + off;
                dArray5[n5] = dArray5[n5] + w * this.vec_lam[i + nn];
                double[] dArray6 = this.mat_W[j + off];
                int n6 = i + off;
                dArray6[n6] = dArray6[n6] + w * this.vec_lam[i + nn];
            }
        }
        for (i = 0; i < nn; ++i) {
            w = 0.0;
            v = 0.0;
            for (j = 0; j < nn; ++j) {
                if (j == i) continue;
                w += this.vec_xtempabs[off + j] * this.vec_xtempabs[off + i] * Complex.abs((Complex)this.MatYact[i][j]) * Math.cos(this.vec_xtempabs[off + nn + i] - this.vec_xtempabs[off + nn + j] - Complex.argument((Complex)this.MatYact[i][j]));
                v += this.vec_xtempabs[off + j] * this.vec_xtempabs[off + i] * Complex.abs((Complex)this.MatYact[i][j]) * Math.sin(this.vec_xtempabs[off + nn + i] - this.vec_xtempabs[off + nn + j] - Complex.argument((Complex)this.MatYact[i][j]));
            }
            double[] dArray = this.mat_W[i + nn + off];
            int n = i + nn + off;
            dArray[n] = dArray[n] + w * this.vec_lam[i];
            double[] dArray7 = this.mat_W[i + nn + off];
            int n7 = i + nn + off;
            dArray7[n7] = dArray7[n7] + v * this.vec_lam[i + nn];
            for (j = 0; j < nn; ++j) {
                if (j == i) continue;
                w = -this.vec_xtempabs[off + i] * this.vec_xtempabs[off + j] * Complex.abs((Complex)this.MatYact[i][j]) * Math.cos(this.vec_xtempabs[off + nn + i] - this.vec_xtempabs[off + nn + j] - Complex.argument((Complex)this.MatYact[i][j]));
                double[] dArray8 = this.mat_W[i + nn + off];
                int n8 = j + nn + off;
                dArray8[n8] = dArray8[n8] + this.vec_lam[i] * w;
                double[] dArray9 = this.mat_W[j + nn + off];
                int n9 = i + nn + off;
                dArray9[n9] = dArray9[n9] + this.vec_lam[i] * w;
                w = -this.vec_xtempabs[off + i] * this.vec_xtempabs[off + j] * Complex.abs((Complex)this.MatYact[i][j]) * Math.sin(this.vec_xtempabs[off + nn + i] - this.vec_xtempabs[off + nn + j] - Complex.argument((Complex)this.MatYact[i][j]));
                double[] dArray10 = this.mat_W[i + nn + off];
                int n10 = j + nn + off;
                dArray10[n10] = dArray10[n10] + this.vec_lam[i + nn] * w;
                double[] dArray11 = this.mat_W[j + nn + off];
                int n11 = i + nn + off;
                dArray11[n11] = dArray11[n11] + this.vec_lam[i + nn] * w;
            }
            for (j = 0; j < nn; ++j) {
                if (j == i) continue;
                w = this.vec_xtempabs[off + i] * this.vec_xtempabs[off + j] * Complex.abs((Complex)this.MatYact[i][j]) * Math.cos(this.vec_xtempabs[off + nn + i] - this.vec_xtempabs[off + nn + j] - Complex.argument((Complex)this.MatYact[i][j]));
                double[] dArray12 = this.mat_W[j + nn + off];
                int n12 = j + nn + off;
                dArray12[n12] = dArray12[n12] + this.vec_lam[i] * w;
                w = this.vec_xtempabs[off + i] * this.vec_xtempabs[off + j] * Complex.abs((Complex)this.MatYact[i][j]) * Math.sin(this.vec_xtempabs[off + nn + i] - this.vec_xtempabs[off + nn + j] - Complex.argument((Complex)this.MatYact[i][j]));
                double[] dArray13 = this.mat_W[j + nn + off];
                int n13 = j + nn + off;
                dArray13[n13] = dArray13[n13] + this.vec_lam[i + nn] * w;
            }
        }
        for (i = 0; i < nn; ++i) {
            w = 0.0;
            v = 0.0;
            for (j = 0; j < nn; ++j) {
                if (j == i) continue;
                w += this.vec_xtempabs[off + j] * Complex.abs((Complex)this.MatYact[i][j]) * Math.sin(this.vec_xtempabs[off + nn + i] - this.vec_xtempabs[off + nn + j] - Complex.argument((Complex)this.MatYact[i][j]));
                v -= this.vec_xtempabs[off + j] * Complex.abs((Complex)this.MatYact[i][j]) * Math.cos(this.vec_xtempabs[off + nn + i] - this.vec_xtempabs[off + nn + j] - Complex.argument((Complex)this.MatYact[i][j]));
            }
            double[] dArray = this.mat_W[i + off];
            int n = i + nn + off;
            dArray[n] = dArray[n] + w * this.vec_lam[i];
            double[] dArray14 = this.mat_W[i + off];
            int n14 = i + nn + off;
            dArray14[n14] = dArray14[n14] + v * this.vec_lam[i + nn];
            double[] dArray15 = this.mat_W[i + nn + off];
            int n15 = i + off;
            dArray15[n15] = dArray15[n15] + w * this.vec_lam[i];
            double[] dArray16 = this.mat_W[i + nn + off];
            int n16 = i + off;
            dArray16[n16] = dArray16[n16] + v * this.vec_lam[i + nn];
            for (j = 0; j < nn; ++j) {
                if (j == i) continue;
                w = -this.vec_xtempabs[off + j] * Complex.abs((Complex)this.MatYact[i][j]) * Math.sin(this.vec_xtempabs[off + nn + i] - this.vec_xtempabs[off + nn + j] - Complex.argument((Complex)this.MatYact[i][j]));
                double[] dArray17 = this.mat_W[i + off];
                int n17 = j + nn + off;
                dArray17[n17] = dArray17[n17] + this.vec_lam[i] * w;
                double[] dArray18 = this.mat_W[j + nn + off];
                int n18 = i + off;
                dArray18[n18] = dArray18[n18] + this.vec_lam[i] * w;
                w = this.vec_xtempabs[off + j] * Complex.abs((Complex)this.MatYact[i][j]) * Math.cos(this.vec_xtempabs[off + nn + i] - this.vec_xtempabs[off + nn + j] - Complex.argument((Complex)this.MatYact[i][j]));
                double[] dArray19 = this.mat_W[i + off];
                int n19 = j + nn + off;
                dArray19[n19] = dArray19[n19] + this.vec_lam[i + nn] * w;
                double[] dArray20 = this.mat_W[j + nn + off];
                int n20 = i + off;
                dArray20[n20] = dArray20[n20] + this.vec_lam[i + nn] * w;
            }
            for (j = 0; j < nn; ++j) {
                if (j == i) continue;
                w = this.vec_xtempabs[off + i] * Complex.abs((Complex)this.MatYact[i][j]) * Math.sin(this.vec_xtempabs[off + nn + i] - this.vec_xtempabs[off + nn + j] - Complex.argument((Complex)this.MatYact[i][j]));
                double[] dArray21 = this.mat_W[j + off];
                int n21 = i + nn + off;
                dArray21[n21] = dArray21[n21] + this.vec_lam[i] * w;
                double[] dArray22 = this.mat_W[i + nn + off];
                int n22 = j + off;
                dArray22[n22] = dArray22[n22] + this.vec_lam[i] * w;
                w = -this.vec_xtempabs[off + i] * Complex.abs((Complex)this.MatYact[i][j]) * Math.cos(this.vec_xtempabs[off + nn + i] - this.vec_xtempabs[off + nn + j] - Complex.argument((Complex)this.MatYact[i][j]));
                double[] dArray23 = this.mat_W[j + off];
                int n23 = i + nn + off;
                dArray23[n23] = dArray23[n23] + this.vec_lam[i + nn] * w;
                double[] dArray24 = this.mat_W[i + nn + off];
                int n24 = j + off;
                dArray24[n24] = dArray24[n24] + this.vec_lam[i + nn] * w;
            }
            for (j = 0; j < nn; ++j) {
                if (j == i) continue;
                w = -this.vec_xtempabs[off + i] * Complex.abs((Complex)this.MatYact[i][j]) * Math.sin(this.vec_xtempabs[off + nn + i] - this.vec_xtempabs[off + nn + j] - Complex.argument((Complex)this.MatYact[i][j]));
                double[] dArray25 = this.mat_W[j + off];
                int n25 = j + nn + off;
                dArray25[n25] = dArray25[n25] + this.vec_lam[i] * w;
                double[] dArray26 = this.mat_W[j + nn + off];
                int n26 = j + off;
                dArray26[n26] = dArray26[n26] + this.vec_lam[i] * w;
                w = this.vec_xtempabs[off + i] * Complex.abs((Complex)this.MatYact[i][j]) * Math.cos(this.vec_xtempabs[off + nn + i] - this.vec_xtempabs[off + nn + j] - Complex.argument((Complex)this.MatYact[i][j]));
                double[] dArray27 = this.mat_W[j + off];
                int n27 = j + nn + off;
                dArray27[n27] = dArray27[n27] + this.vec_lam[i + nn] * w;
                double[] dArray28 = this.mat_W[j + nn + off];
                int n28 = j + off;
                dArray28[n28] = dArray28[n28] + this.vec_lam[i + nn] * w;
            }
        }
        for (i = off; i < off + 2 * nn; ++i) {
            for (j = off; j < off + 2 * nn; ++j) {
                this.mat_W[i][j] = -this.mat_W[i][j];
            }
        }
        int m = 0;
        int mioff = off + 2 * nn;
        double pvaux = 0.0;
        double qvaux = 0.0;
        double ptaux = 0.0;
        double qtaux = 0.0;
        double pttaux = 0.0;
        double qttaux = 0.0;
        double VI = 0.0;
        double VJ = 0.0;
        double TI = 0.0;
        double TJ = 0.0;
        double YIJ = 0.0;
        double YJI = 0.0;
        double TIJ = 0.0;
        double TJI = 0.0;
        double YII = 0.0;
        double YJJ = 0.0;
        double TII = 0.0;
        double TJJ = 0.0;
        int I = -1;
        int J = -1;
        double t = 0.0;
        if (this.numtrafo > 0 && this.isTapOptVariable) {
            for (i = 0; i < nn; ++i) {
                Complex tyjj;
                Complex tyii;
                Complex tyji;
                Complex tyij;
                Complex tauxc2;
                Complex tauxc1;
                for (j = 0; j < nn; ++j) {
                    for (k = 0; k < this.numtrafo; ++k) {
                        if (this.TranchI[k] == i && j == i) {
                            I = this.TranchI[k];
                            J = this.TranchJ[k];
                            tauxc1 = new Complex(this.TranchR[k], this.TranchX[k]);
                            tauxc2 = new Complex(1.0);
                            tauxc1 = Complex.divide((Complex)tauxc2, (Complex)tauxc1);
                            tauxc2 = new Complex(0.0, this.TranchB[k]);
                            tyij = new Complex(0.0, 0.0);
                            tyji = new Complex(0.0, 0.0);
                            tyii = new Complex(0.0, 0.0);
                            tyjj = new Complex(0.0, 0.0);
                            tyij.add(Complex.negate((Complex)tauxc1));
                            tyji.add(Complex.negate((Complex)tauxc1));
                            tyjj.add(Complex.add((Complex)tauxc1, (Complex)tauxc2));
                            tyii.add(Complex.add((Complex)tauxc1, (Complex)tauxc2));
                            VI = this.vec_xtempabs[off + I];
                            VJ = this.vec_xtempabs[off + J];
                            TI = this.vec_xtempabs[off + this.numnod + I];
                            TJ = this.vec_xtempabs[off + this.numnod + J];
                            YIJ = Complex.abs((Complex)tyij);
                            TIJ = Complex.argument((Complex)tyij);
                            YII = Complex.abs((Complex)tyii);
                            TII = Complex.argument((Complex)tyii);
                            t = this.vec_xtempabs[mioff + k];
                            pvaux = 0.0;
                            qvaux = 0.0;
                            pvaux = -4.0 * VI * YII * t * Math.cos(-TII) - VJ * YIJ * Math.cos(TI - TJ - TIJ);
                            qvaux = -4.0 * VI * YII * t * Math.sin(-TII) - VJ * YIJ * Math.sin(TI - TJ - TIJ);
                            double[] dArray = this.mat_W[off + j];
                            int n = mioff + k;
                            dArray[n] = dArray[n] + (this.vec_lam[i] * pvaux + this.vec_lam[this.numnod + i] * qvaux);
                            double[] dArray29 = this.mat_W[mioff + k];
                            int n29 = off + j;
                            dArray29[n29] = dArray29[n29] + (this.vec_lam[i] * pvaux + this.vec_lam[this.numnod + i] * qvaux);
                            ptaux = 0.0;
                            qtaux = 0.0;
                            ptaux = VI * VJ * YIJ * Math.sin(TI - TJ - TIJ);
                            qtaux = -VI * VJ * YIJ * Math.cos(TI - TJ - TIJ);
                            double[] dArray30 = this.mat_W[off + this.numnod + j];
                            int n30 = mioff + k;
                            dArray30[n30] = dArray30[n30] + (this.vec_lam[i] * ptaux + this.vec_lam[this.numnod + i] * qtaux);
                            double[] dArray31 = this.mat_W[mioff + k];
                            int n31 = off + this.numnod + j;
                            dArray31[n31] = dArray31[n31] + (this.vec_lam[i] * ptaux + this.vec_lam[this.numnod + i] * qtaux);
                            continue;
                        }
                        if (this.TranchI[k] != i || j == i || this.TranchJ[k] != j) continue;
                        I = this.TranchI[k];
                        J = this.TranchJ[k];
                        tauxc1 = new Complex(this.TranchR[k], this.TranchX[k]);
                        tauxc2 = new Complex(1.0);
                        tauxc1 = Complex.divide((Complex)tauxc2, (Complex)tauxc1);
                        tauxc2 = new Complex(0.0, this.TranchB[k]);
                        tyij = new Complex(0.0, 0.0);
                        tyji = new Complex(0.0, 0.0);
                        tyii = new Complex(0.0, 0.0);
                        tyjj = new Complex(0.0, 0.0);
                        tyij.add(Complex.negate((Complex)tauxc1));
                        tyji.add(Complex.negate((Complex)tauxc1));
                        tyjj.add(Complex.add((Complex)tauxc1, (Complex)tauxc2));
                        tyii.add(Complex.add((Complex)tauxc1, (Complex)tauxc2));
                        VI = this.vec_xtempabs[off + I];
                        VJ = this.vec_xtempabs[off + J];
                        TI = this.vec_xtempabs[off + this.numnod + I];
                        TJ = this.vec_xtempabs[off + this.numnod + J];
                        YIJ = Complex.abs((Complex)tyij);
                        TIJ = Complex.argument((Complex)tyij);
                        YII = Complex.abs((Complex)tyii);
                        TII = Complex.argument((Complex)tyii);
                        t = this.vec_xtempabs[mioff + k];
                        pvaux = 0.0;
                        qvaux = 0.0;
                        pvaux = -VI * YIJ * Math.cos(TI - TJ - TIJ);
                        qvaux = -VI * YIJ * Math.sin(TI - TJ - TIJ);
                        double[] dArray = this.mat_W[off + j];
                        int n = mioff + k;
                        dArray[n] = dArray[n] + (this.vec_lam[i] * pvaux + this.vec_lam[this.numnod + i] * qvaux);
                        double[] dArray32 = this.mat_W[mioff + k];
                        int n32 = off + i;
                        dArray32[n32] = dArray32[n32] + (this.vec_lam[i] * pvaux + this.vec_lam[this.numnod + i] * qvaux);
                        ptaux = 0.0;
                        qtaux = 0.0;
                        ptaux = -VI * VJ * YIJ * Math.sin(TI - TJ - TIJ);
                        qtaux = VI * VJ * YIJ * Math.cos(TI - TJ - TIJ);
                        double[] dArray33 = this.mat_W[off + this.numnod + j];
                        int n33 = mioff + k;
                        dArray33[n33] = dArray33[n33] + (this.vec_lam[i] * ptaux + this.vec_lam[this.numnod + i] * qtaux);
                        double[] dArray34 = this.mat_W[mioff + k];
                        int n34 = off + this.numnod + j;
                        dArray34[n34] = dArray34[n34] + (this.vec_lam[i] * ptaux + this.vec_lam[this.numnod + i] * qtaux);
                    }
                }
                for (k = 0; k < this.numtrafo; ++k) {
                    if (this.TranchI[k] != i) continue;
                    I = this.TranchI[m];
                    J = this.TranchJ[m];
                    tauxc1 = new Complex(this.TranchR[k], this.TranchX[k]);
                    tauxc2 = new Complex(1.0);
                    tauxc1 = Complex.divide((Complex)tauxc2, (Complex)tauxc1);
                    tauxc2 = new Complex(0.0, this.TranchB[k]);
                    tyij = new Complex(0.0, 0.0);
                    tyji = new Complex(0.0, 0.0);
                    tyii = new Complex(0.0, 0.0);
                    tyjj = new Complex(0.0, 0.0);
                    tyij.add(Complex.negate((Complex)tauxc1));
                    tyji.add(Complex.negate((Complex)tauxc1));
                    tyjj.add(Complex.add((Complex)tauxc1, (Complex)tauxc2));
                    tyii.add(Complex.add((Complex)tauxc1, (Complex)tauxc2));
                    VI = this.vec_xtempabs[off + I];
                    TI = this.vec_xtempabs[off + this.numnod + I];
                    YII = Complex.abs((Complex)tyii);
                    TII = Complex.argument((Complex)tyii);
                    pttaux = 0.0;
                    qttaux = 0.0;
                    pttaux = -2.0 * VI * VI * YII * Math.cos(-TII);
                    qttaux = -2.0 * VI * VI * YII * Math.sin(-TII);
                    double[] dArray = this.mat_W[mioff + k];
                    int n = mioff + k;
                    dArray[n] = dArray[n] + (this.vec_lam[i] * pttaux + this.vec_lam[this.numnod + i] * qttaux);
                }
            }
        }
        if (this.linres == 1) {
            int ix = 0;
            int count = 0;
            con1 = 10000;
            con2 = 10000;
            corvar = 2 * this.numgen + 2 * this.numlast;
            for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
                TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
                if (!TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice() || !(TempComponent instanceof Line) || (con1 = this.numbus((TempLine = (Line)TempComponent).getcon1())) == 10000 || (con2 = this.numbus(TempLine.getcon2())) == 10000) continue;
                Complex Lauxc1 = new Complex(this.LranchR[count], this.LranchX[count]);
                Complex Lauxc2 = new Complex(1.0);
                Lauxc1 = Complex.divide((Complex)Lauxc2, (Complex)Lauxc1);
                Complex Lyij = new Complex(0.0, 0.0);
                Lyij.add(Lauxc1);
                double Yij = Complex.abs((Complex)Lyij);
                double Tij = Complex.argument((Complex)Lyij);
                double Vi = this.vec_xtempabs[corvar + con1];
                double Vj = this.vec_xtempabs[corvar + con2];
                double Ti = this.vec_xtempabs[corvar + this.numnod + con1];
                double Tj = this.vec_xtempabs[corvar + this.numnod + con2];
                double lam1 = this.vec_lam[2 * this.numnod + this.numlastres + count];
                double lam2 = this.vec_lam[2 * this.numnod + this.numlastres + this.numlin + count];
                double[] dArray = this.mat_W[corvar + con1];
                int n = corvar + con1;
                dArray[n] = dArray[n] - (lam1 * 2.0 * Yij * Math.cos(Tij) - lam2 * 2.0 * Yij * Math.cos(Tij));
                double[] dArray35 = this.mat_W[corvar + con1];
                int n35 = corvar + con2;
                dArray35[n35] = dArray35[n35] - (lam1 * (-Yij * Math.cos(Ti - Tj - Tij)) - lam2 * (-Yij * Math.cos(Ti - Tj - Tij)));
                double[] dArray36 = this.mat_W[corvar + con2];
                int n36 = corvar + con1;
                dArray36[n36] = dArray36[n36] - (lam1 * (-Yij * Math.cos(Ti - Tj - Tij)) - lam2 * (-Yij * Math.cos(Ti - Tj - Tij)));
                double[] dArray37 = this.mat_W[corvar + this.numnod + con1];
                int n37 = corvar + this.numnod + con1;
                dArray37[n37] = dArray37[n37] - (lam1 * (Vi * Vj * Yij * Math.cos(Ti - Tj - Tij)) - lam2 * (Vi * Vj * Yij * Math.cos(Ti - Tj - Tij)));
                double[] dArray38 = this.mat_W[corvar + this.numnod + con2];
                int n38 = corvar + this.numnod + con2;
                dArray38[n38] = dArray38[n38] - (lam1 * (Vi * Vj * Yij * Math.cos(Ti - Tj - Tij)) - lam2 * (Vi * Vj * Yij * Math.cos(Ti - Tj - Tij)));
                double[] dArray39 = this.mat_W[corvar + this.numnod + con1];
                int n39 = corvar + this.numnod + con2;
                dArray39[n39] = dArray39[n39] - (lam1 * (-Vi * Vj * Yij * Math.cos(Ti - Tj - Tij)) - lam2 * (-Vi * Vj * Yij * Math.cos(Ti - Tj - Tij)));
                double[] dArray40 = this.mat_W[corvar + this.numnod + con2];
                int n40 = corvar + this.numnod + con1;
                dArray40[n40] = dArray40[n40] - (lam1 * (-Vi * Vj * Yij * Math.cos(Ti - Tj - Tij)) - lam2 * (-Vi * Vj * Yij * Math.cos(Ti - Tj - Tij)));
                double[] dArray41 = this.mat_W[corvar + con1];
                int n41 = corvar + this.numnod + con1;
                dArray41[n41] = dArray41[n41] - (lam1 * (Vj * Yij * Math.sin(Ti - Tj - Tij)) - lam2 * (Vj * Yij * Math.sin(Ti - Tj - Tij)));
                double[] dArray42 = this.mat_W[corvar + this.numnod + con1];
                int n42 = corvar + con1;
                dArray42[n42] = dArray42[n42] - (lam1 * (Vj * Yij * Math.sin(Ti - Tj - Tij)) - lam2 * (Vj * Yij * Math.sin(Ti - Tj - Tij)));
                double[] dArray43 = this.mat_W[corvar + con1];
                int n43 = corvar + this.numnod + con2;
                dArray43[n43] = dArray43[n43] - (lam1 * (-Vj * Yij * Math.sin(Ti - Tj - Tij)) - lam2 * (-Vj * Yij * Math.sin(Ti - Tj - Tij)));
                double[] dArray44 = this.mat_W[corvar + this.numnod + con2];
                int n44 = corvar + con1;
                dArray44[n44] = dArray44[n44] - (lam1 * (-Vj * Yij * Math.sin(Ti - Tj - Tij)) - lam2 * (-Vj * Yij * Math.sin(Ti - Tj - Tij)));
                double[] dArray45 = this.mat_W[corvar + con2];
                int n45 = corvar + this.numnod + con2;
                dArray45[n45] = dArray45[n45] - (lam1 * (-Vi * Yij * Math.sin(Ti - Tj - Tij)) - lam2 * (-Vi * Yij * Math.sin(Ti - Tj - Tij)));
                double[] dArray46 = this.mat_W[corvar + this.numnod + con2];
                int n46 = corvar + con2;
                dArray46[n46] = dArray46[n46] - (lam1 * (-Vi * Yij * Math.sin(Ti - Tj - Tij)) - lam2 * (-Vi * Yij * Math.sin(Ti - Tj - Tij)));
                double[] dArray47 = this.mat_W[corvar + con2];
                int n47 = corvar + this.numnod + con1;
                dArray47[n47] = dArray47[n47] - (lam1 * (Vi * Yij * Math.sin(Ti - Tj - Tij)) - lam2 * (Vi * Yij * Math.sin(Ti - Tj - Tij)));
                double[] dArray48 = this.mat_W[corvar + this.numnod + con1];
                int n48 = corvar + con2;
                dArray48[n48] = dArray48[n48] - (lam1 * (Vi * Yij * Math.sin(Ti - Tj - Tij)) - lam2 * (Vi * Yij * Math.sin(Ti - Tj - Tij)));
                ++count;
            }
        } else if (this.linres == 2) {
            int ix = 0;
            int count = 0;
            con1 = 10000;
            con2 = 10000;
            corvar = 2 * this.numgen + 2 * this.numlast;
            for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
                TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
                if (!TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice() || !(TempComponent instanceof Line) || (con1 = this.numbus((TempLine = (Line)TempComponent).getcon1())) == 10000 || (con2 = this.numbus(TempLine.getcon2())) == 10000) continue;
                Complex Lauxc1 = new Complex(this.LranchR[count], this.LranchX[count]);
                Complex Lauxc2 = new Complex(1.0);
                Lauxc1 = Complex.divide((Complex)Lauxc2, (Complex)Lauxc1);
                Complex Lyij = new Complex(0.0, 0.0);
                Lyij.add(Lauxc1);
                double Yij = Complex.abs((Complex)Lyij);
                double Vi = this.vec_xtempabs[corvar + con1];
                double Vj = this.vec_xtempabs[corvar + con2];
                double Ti = this.vec_xtempabs[corvar + this.numnod + con1];
                double Tj = this.vec_xtempabs[corvar + this.numnod + con2];
                double lam = this.vec_lam[2 * this.numnod + this.numlastres + count];
                double[] dArray = this.mat_W[corvar + con1];
                int n = corvar + con1;
                dArray[n] = dArray[n] - lam * 2.0 * Yij * Yij;
                double[] dArray49 = this.mat_W[corvar + con1];
                int n49 = corvar + con2;
                dArray49[n49] = dArray49[n49] - lam * (-2.0 * Yij * Yij * Math.cos(Ti - Tj));
                double[] dArray50 = this.mat_W[corvar + con2];
                int n50 = corvar + con1;
                dArray50[n50] = dArray50[n50] - lam * (-2.0 * Yij * Yij * Math.cos(Ti - Tj));
                double[] dArray51 = this.mat_W[corvar + con2];
                int n51 = corvar + con2;
                dArray51[n51] = dArray51[n51] - lam * 2.0 * Yij * Yij;
                double[] dArray52 = this.mat_W[corvar + con1];
                int n52 = corvar + this.numnod + con1;
                dArray52[n52] = dArray52[n52] - lam * 2.0 * Yij * Yij * Vj * Math.sin(Ti - Tj);
                double[] dArray53 = this.mat_W[corvar + this.numnod + con1];
                int n53 = corvar + con1;
                dArray53[n53] = dArray53[n53] - lam * 2.0 * Yij * Yij * Vj * Math.sin(Ti - Tj);
                double[] dArray54 = this.mat_W[corvar + con1];
                int n54 = corvar + this.numnod + con2;
                dArray54[n54] = dArray54[n54] - lam * (-2.0 * Yij * Yij * Vj * Math.sin(Ti - Tj));
                double[] dArray55 = this.mat_W[corvar + this.numnod + con2];
                int n55 = corvar + con1;
                dArray55[n55] = dArray55[n55] - lam * (-2.0 * Yij * Yij * Vj * Math.sin(Ti - Tj));
                double[] dArray56 = this.mat_W[corvar + con2];
                int n56 = corvar + this.numnod + con2;
                dArray56[n56] = dArray56[n56] - lam * (-2.0 * Yij * Yij * Vi * Math.sin(Ti - Tj));
                double[] dArray57 = this.mat_W[corvar + this.numnod + con2];
                int n57 = corvar + con2;
                dArray57[n57] = dArray57[n57] - lam * (-2.0 * Yij * Yij * Vi * Math.sin(Ti - Tj));
                double[] dArray58 = this.mat_W[corvar + con2];
                int n58 = corvar + this.numnod + con1;
                dArray58[n58] = dArray58[n58] - lam * 2.0 * Yij * Yij * Vi * Math.sin(Ti - Tj);
                double[] dArray59 = this.mat_W[corvar + this.numnod + con1];
                int n59 = corvar + con2;
                dArray59[n59] = dArray59[n59] - lam * 2.0 * Yij * Yij * Vi * Math.sin(Ti - Tj);
                double[] dArray60 = this.mat_W[corvar + this.numnod + con1];
                int n60 = corvar + this.numnod + con1;
                dArray60[n60] = dArray60[n60] - lam * 2.0 * Yij * Yij * Vi * Vj * Math.cos(Ti - Tj);
                double[] dArray61 = this.mat_W[corvar + this.numnod + con1];
                int n61 = corvar + this.numnod + con2;
                dArray61[n61] = dArray61[n61] - lam * (-2.0 * Yij * Yij * Vi * Vj * Math.cos(Ti - Tj));
                double[] dArray62 = this.mat_W[corvar + this.numnod + con2];
                int n62 = corvar + this.numnod + con1;
                dArray62[n62] = dArray62[n62] - lam * (-2.0 * Yij * Yij * Vi * Vj * Math.cos(Ti - Tj));
                double[] dArray63 = this.mat_W[corvar + this.numnod + con2];
                int n63 = corvar + this.numnod + con2;
                dArray63[n63] = dArray63[n63] - lam * (2.0 * Yij * Yij * Vi * Vj * Math.cos(Ti - Tj));
                ++count;
            }
        }
        double pfaux1 = 0.0;
        double pfaux2 = 0.0;
        double qeaux = 0.0;
        double qbaux = 0.0;
        double pflam1 = 0.0;
        double pflam2 = 0.0;
        double qelam = 0.0;
        double qblam = 0.0;
        double psaux = 0.0;
        double qsaux = 0.0;
        double pslam = 0.0;
        double qslam = 0.0;
        if (this.numupfc > 0) {
            for (i = 0; i < this.numnod; ++i) {
                for (k = 0; k < this.numupfc; ++k) {
                    if (this.TOupfc[k][0] != i) continue;
                    rserie = this.PARupfc[k][0];
                    xserie = this.PARupfc[k][1];
                    gshunt = this.PARupfc[k][2];
                    bshunt = this.PARupfc[k][3];
                    VbMax = this.PARupfc[k][4];
                    VeMax = this.PARupfc[k][5];
                    int row = this.TOupfc[k][0];
                    int col = this.TOupfc[k][1];
                    Complex auxc1 = new Complex(rserie, xserie);
                    Complex auxc2 = new Complex(1.0);
                    auxc1 = Complex.divide((Complex)auxc2, (Complex)auxc1);
                    auxc2 = new Complex(0.0, bshunt);
                    double ybb = Complex.abs((Complex)auxc1);
                    double tbb = Complex.argument((Complex)auxc1);
                    double yee = Complex.abs((Complex)auxc2);
                    double tee = Complex.argument((Complex)auxc2);
                    Pfe = this.vec_xtempabs[offdos + k];
                    Qe = this.vec_xtempabs[offdos + this.numupfc + k];
                    Qb = this.vec_xtempabs[offdos + 2 * this.numupfc + k];
                    vnexc = this.vec_xtempabs[off + row];
                    vnboost = this.vec_xtempabs[off + col];
                    thexc = this.vec_xtempabs[off + this.numnod + row];
                    thboost = this.vec_xtempabs[off + this.numnod + col];
                    delta = thexc - thboost;
                    alfa = vnboost / vnexc;
                    pflam1 = this.vec_lam[onn + k];
                    pflam2 = this.vec_lam[onn + this.numupfc + k];
                    pfaux1 = -2.0 * (VbMax * VbMax * ybb * ybb);
                    pfaux2 = 2.0 / (vnexc * vnexc) * (Qe * Qe + Pfe * Pfe) - 2.0 * (VeMax * VeMax * yee * yee);
                    double[] dArray = this.mat_W[off + col];
                    int n = off + col;
                    dArray[n] = dArray[n] + (pflam1 * pfaux1 + pflam2 * pfaux2);
                    pfaux1 = 2.0;
                    pfaux2 = 2.0 + 2.0 * alfa * alfa - 4.0 * alfa * Math.cos(delta);
                    double[] dArray64 = this.mat_W[offdos + k];
                    int n64 = offdos + k;
                    dArray64[n64] = dArray64[n64] + (pflam1 * pfaux1 + pflam2 * pfaux2);
                    pfaux1 = 2.0;
                    pfaux2 = 2.0;
                    double[] dArray65 = this.mat_W[offdos + 2 * this.numupfc + k];
                    int n65 = offdos + 2 * this.numupfc + k;
                    dArray65[n65] = dArray65[n65] + (pflam1 * pfaux1 + pflam2 * pfaux2);
                    pfaux2 = 6.0 * (vnboost * vnboost / (vnexc * vnexc * vnexc * vnexc)) * (Qe * Qe + Pfe * Pfe) + 2.0 * (vnboost / (vnexc * vnexc * vnexc)) * (2.0 * Qe * Qb * Math.cos(delta) - 2.0 * Pfe * Qe * Math.sin(delta) - 2.0 * Pfe * Pfe * Math.cos(delta) - 2.0 * Qb * Pfe * Math.sin(delta));
                    double[] dArray66 = this.mat_W[off + row];
                    int n66 = off + row;
                    dArray66[n66] = dArray66[n66] + pflam2 * pfaux2;
                    pfaux2 = -4.0 * (vnboost / (vnexc * vnexc * vnexc)) * (Qe * Qe + Pfe * Pfe) - 1.0 / (vnexc * vnexc) * (2.0 * Qe * Qb * Math.cos(delta) - 2.0 * Pfe * Qe * Math.sin(delta) - 2.0 * Pfe * Pfe * Math.cos(delta) - 2.0 * Qb * Pfe * Math.sin(delta));
                    double[] dArray67 = this.mat_W[off + row];
                    int n67 = off + col;
                    dArray67[n67] = dArray67[n67] + pflam2 * pfaux2;
                    double[] dArray68 = this.mat_W[off + col];
                    int n68 = off + row;
                    dArray68[n68] = dArray68[n68] + pflam2 * pfaux2;
                    pfaux2 = -1.0 * (vnboost / (vnexc * vnexc)) * (-2.0 * Qe * Qb * Math.sin(delta) - 2.0 * Pfe * Qe * Math.cos(delta) + 2.0 * Pfe * Pfe * Math.sin(delta) - 2.0 * Qb * Pfe * Math.cos(delta));
                    double[] dArray69 = this.mat_W[off + row];
                    int n69 = off + this.numnod + row;
                    dArray69[n69] = dArray69[n69] + pflam2 * pfaux2;
                    double[] dArray70 = this.mat_W[off + this.numnod + row];
                    int n70 = off + row;
                    dArray70[n70] = dArray70[n70] + pflam2 * pfaux2;
                    pfaux2 = vnboost / (vnexc * vnexc) * (-2.0 * Qe * Qb * Math.sin(delta) - 2.0 * Pfe * Qe * Math.cos(delta) + 2.0 * Pfe * Pfe * Math.sin(delta) - 2.0 * Qb * Pfe * Math.cos(delta));
                    double[] dArray71 = this.mat_W[off + row];
                    int n71 = off + this.numnod + col;
                    dArray71[n71] = dArray71[n71] + pflam2 * pfaux2;
                    double[] dArray72 = this.mat_W[off + this.numnod + col];
                    int n72 = off + row;
                    dArray72[n72] = dArray72[n72] + pflam2 * pfaux2;
                    pfaux2 = -1.0 * (vnboost / (vnexc * vnexc)) * (-2.0 * Qe * Math.sin(delta) - 4.0 * Pfe * Math.cos(delta) - 2.0 * Qb * Math.sin(delta)) - 4.0 * Pfe * (vnboost * vnboost / (vnexc * vnexc * vnexc));
                    double[] dArray73 = this.mat_W[off + row];
                    int n73 = offdos + k;
                    dArray73[n73] = dArray73[n73] + pflam2 * pfaux2;
                    double[] dArray74 = this.mat_W[offdos + k];
                    int n74 = off + row;
                    dArray74[n74] = dArray74[n74] + pflam2 * pfaux2;
                    pfaux2 = -1.0 * (vnboost / (vnexc * vnexc)) * (2.0 * Qb * Math.cos(delta) - 2.0 * Pfe * Math.sin(delta)) - 4.0 * Qe * (vnboost * vnboost / (vnexc * vnexc * vnexc));
                    double[] dArray75 = this.mat_W[off + row];
                    int n75 = offdos + this.numupfc + k;
                    dArray75[n75] = dArray75[n75] + pflam2 * pfaux2;
                    double[] dArray76 = this.mat_W[offdos + this.numupfc + k];
                    int n76 = off + row;
                    dArray76[n76] = dArray76[n76] + pflam2 * pfaux2;
                    pfaux2 = -1.0 * (vnboost / (vnexc * vnexc)) * (2.0 * Qe * Math.cos(delta) - 2.0 * Pfe * Math.sin(delta));
                    double[] dArray77 = this.mat_W[off + row];
                    int n77 = offdos + 2 * this.numupfc + k;
                    dArray77[n77] = dArray77[n77] + pflam2 * pfaux2;
                    double[] dArray78 = this.mat_W[offdos + 2 * this.numupfc + k];
                    int n78 = off + row;
                    dArray78[n78] = dArray78[n78] + pflam2 * pfaux2;
                    pfaux2 = 1.0 / vnexc * (-2.0 * Qe * Qb * Math.sin(delta) - 2.0 * Pfe * Qe * Math.cos(delta) + 2.0 * Pfe * Pfe * Math.sin(delta) - 2.0 * Qb * Pfe * Math.cos(delta));
                    double[] dArray79 = this.mat_W[off + col];
                    int n79 = off + this.numnod + row;
                    dArray79[n79] = dArray79[n79] + pflam2 * pfaux2;
                    double[] dArray80 = this.mat_W[off + this.numnod + row];
                    int n80 = off + col;
                    dArray80[n80] = dArray80[n80] + pflam2 * pfaux2;
                    pfaux2 = -1.0 * (1.0 / vnexc) * (-2.0 * Qe * Qb * Math.sin(delta) - 2.0 * Pfe * Qe * Math.cos(delta) + 2.0 * Pfe * Pfe * Math.sin(delta) - 2.0 * Qb * Pfe * Math.cos(delta));
                    double[] dArray81 = this.mat_W[off + col];
                    int n81 = off + this.numnod + col;
                    dArray81[n81] = dArray81[n81] + pflam2 * pfaux2;
                    double[] dArray82 = this.mat_W[off + this.numnod + col];
                    int n82 = off + col;
                    dArray82[n82] = dArray82[n82] + pflam2 * pfaux2;
                    pfaux2 = 1.0 / vnexc * (-2.0 * Qe * Math.sin(delta) - 4.0 * Pfe * Math.cos(delta) - 2.0 * Qb * Math.sin(delta)) + 4.0 * Pfe * (vnboost / (vnexc * vnexc));
                    double[] dArray83 = this.mat_W[off + col];
                    int n83 = offdos + k;
                    dArray83[n83] = dArray83[n83] + pflam2 * pfaux2;
                    double[] dArray84 = this.mat_W[offdos + k];
                    int n84 = off + col;
                    dArray84[n84] = dArray84[n84] + pflam2 * pfaux2;
                    pfaux2 = 4.0 * (vnboost / (vnexc * vnexc)) * Qe + 1.0 / vnexc * (2.0 * Qb * Math.cos(delta) - 2.0 * Pfe * Math.sin(delta));
                    double[] dArray85 = this.mat_W[off + col];
                    int n85 = offdos + this.numupfc + k;
                    dArray85[n85] = dArray85[n85] + pflam2 * pfaux2;
                    double[] dArray86 = this.mat_W[offdos + this.numupfc + k];
                    int n86 = off + col;
                    dArray86[n86] = dArray86[n86] + pflam2 * pfaux2;
                    pfaux2 = 1.0 / vnexc * (2.0 * Qe * Math.cos(delta) - 2.0 * Pfe * Math.sin(delta));
                    double[] dArray87 = this.mat_W[off + col];
                    int n87 = offdos + 2 * this.numupfc + k;
                    dArray87[n87] = dArray87[n87] + pflam2 * pfaux2;
                    double[] dArray88 = this.mat_W[offdos + 2 * this.numupfc + k];
                    int n88 = off + col;
                    dArray88[n88] = dArray88[n88] + pflam2 * pfaux2;
                    pfaux2 = -2.0 * alfa * Qe * Qb * Math.cos(delta) + 2.0 * alfa * Pfe * Qe * Math.sin(delta) + 2.0 * alfa * Pfe * Pfe * Math.cos(delta) + 2.0 * alfa * Qb * Pfe * Math.sin(delta);
                    double[] dArray89 = this.mat_W[off + this.numnod + row];
                    int n89 = off + this.numnod + row;
                    dArray89[n89] = dArray89[n89] + pflam2 * pfaux2;
                    pfaux2 = 2.0 * alfa * Qe * Qb * Math.cos(delta) - 2.0 * alfa * Pfe * Qe * Math.sin(delta) - 2.0 * alfa * Pfe * Pfe * Math.cos(delta) - 2.0 * alfa * Qb * Pfe * Math.sin(delta);
                    double[] dArray90 = this.mat_W[off + this.numnod + row];
                    int n90 = off + this.numnod + col;
                    dArray90[n90] = dArray90[n90] + pflam2 * pfaux2;
                    double[] dArray91 = this.mat_W[off + this.numnod + col];
                    int n91 = off + this.numnod + row;
                    dArray91[n91] = dArray91[n91] + pflam2 * pfaux2;
                    pfaux2 = -2.0 * alfa * Qe * Math.cos(delta) + 4.0 * alfa * Pfe * Math.sin(delta) - 2.0 * alfa * Qb * Math.cos(delta);
                    double[] dArray92 = this.mat_W[off + this.numnod + row];
                    int n92 = offdos + k;
                    dArray92[n92] = dArray92[n92] + pflam2 * pfaux2;
                    double[] dArray93 = this.mat_W[offdos + k];
                    int n93 = off + this.numnod + row;
                    dArray93[n93] = dArray93[n93] + pflam2 * pfaux2;
                    pfaux2 = -2.0 * alfa * Qb * Math.sin(delta) - 2.0 * alfa * Pfe * Math.cos(delta);
                    double[] dArray94 = this.mat_W[off + this.numnod + row];
                    int n94 = offdos + this.numupfc + k;
                    dArray94[n94] = dArray94[n94] + pflam2 * pfaux2;
                    double[] dArray95 = this.mat_W[offdos + this.numupfc + k];
                    int n95 = off + this.numnod + row;
                    dArray95[n95] = dArray95[n95] + pflam2 * pfaux2;
                    pfaux2 = -2.0 * alfa * Qe * Math.sin(delta) - 2.0 * alfa * Pfe * Math.cos(delta);
                    double[] dArray96 = this.mat_W[off + this.numnod + row];
                    int n96 = offdos + 2 * this.numupfc + k;
                    dArray96[n96] = dArray96[n96] + pflam2 * pfaux2;
                    double[] dArray97 = this.mat_W[offdos + 2 * this.numupfc + k];
                    int n97 = off + this.numnod + row;
                    dArray97[n97] = dArray97[n97] + pflam2 * pfaux2;
                    pfaux2 = -2.0 * alfa * Qe * Qb * Math.cos(delta) + 2.0 * alfa * Pfe * Qe * Math.sin(delta) + 2.0 * alfa * Pfe * Pfe * Math.cos(delta) + 2.0 * alfa * Qb * Pfe * Math.sin(delta);
                    double[] dArray98 = this.mat_W[off + this.numnod + col];
                    int n98 = off + this.numnod + col;
                    dArray98[n98] = dArray98[n98] + pflam2 * pfaux2;
                    pfaux2 = 2.0 * alfa * Qe * Math.cos(delta) - 4.0 * alfa * Pfe * Math.sin(delta) + 2.0 * alfa * Qb * Math.cos(delta);
                    double[] dArray99 = this.mat_W[off + this.numnod + col];
                    int n99 = offdos + k;
                    dArray99[n99] = dArray99[n99] + pflam2 * pfaux2;
                    double[] dArray100 = this.mat_W[offdos + k];
                    int n100 = off + this.numnod + col;
                    dArray100[n100] = dArray100[n100] + pflam2 * pfaux2;
                    pfaux2 = 2.0 * alfa * Qb * Math.sin(delta) + 2.0 * alfa * Pfe * Math.cos(delta);
                    double[] dArray101 = this.mat_W[off + this.numnod + col];
                    int n101 = offdos + this.numupfc + k;
                    dArray101[n101] = dArray101[n101] + pflam2 * pfaux2;
                    double[] dArray102 = this.mat_W[offdos + this.numupfc + k];
                    int n102 = off + this.numnod + col;
                    dArray102[n102] = dArray102[n102] + pflam2 * pfaux2;
                    pfaux2 = 2.0 * alfa * Qe * Math.sin(delta) + 2.0 * alfa * Pfe * Math.cos(delta);
                    double[] dArray103 = this.mat_W[off + this.numnod + col];
                    int n103 = offdos + 2 * this.numupfc + k;
                    dArray103[n103] = dArray103[n103] + pflam2 * pfaux2;
                    double[] dArray104 = this.mat_W[offdos + 2 * this.numupfc + k];
                    int n104 = off + this.numnod + col;
                    dArray104[n104] = dArray104[n104] + pflam2 * pfaux2;
                    pfaux2 = -2.0 * alfa * Math.sin(delta);
                    double[] dArray105 = this.mat_W[offdos + k];
                    int n105 = offdos + this.numupfc + k;
                    dArray105[n105] = dArray105[n105] + pflam2 * pfaux2;
                    double[] dArray106 = this.mat_W[offdos + this.numupfc + k];
                    int n106 = offdos + k;
                    dArray106[n106] = dArray106[n106] + pflam2 * pfaux2;
                    pfaux2 = -2.0 * alfa * Math.sin(delta);
                    double[] dArray107 = this.mat_W[offdos + k];
                    int n107 = offdos + 2 * this.numupfc + k;
                    dArray107[n107] = dArray107[n107] + pflam2 * pfaux2;
                    double[] dArray108 = this.mat_W[offdos + 2 * this.numupfc + k];
                    int n108 = offdos + k;
                    dArray108[n108] = dArray108[n108] + pflam2 * pfaux2;
                    pfaux2 = 2.0 * alfa * alfa;
                    double[] dArray109 = this.mat_W[offdos + this.numupfc + k];
                    int n109 = offdos + this.numupfc + k;
                    dArray109[n109] = dArray109[n109] + pflam2 * pfaux2;
                    pfaux2 = 2.0 * alfa * Math.cos(delta);
                    double[] dArray110 = this.mat_W[offdos + this.numupfc + k];
                    int n110 = offdos + 2 * this.numupfc + k;
                    dArray110[n110] = dArray110[n110] + pflam2 * pfaux2;
                    double[] dArray111 = this.mat_W[offdos + 2 * this.numupfc + k];
                    int n111 = offdos + this.numupfc + k;
                    dArray111[n111] = dArray111[n111] + pflam2 * pfaux2;
                    if (!this.upfcres) continue;
                    if (this.modop_upfc == 1 || this.modop_upfc == 2) {
                        pslam = this.vec_lam[onn + 2 * this.numupfc + k];
                        qslam = this.vec_lam[onn + 3 * this.numupfc + k];
                    } else if (this.modop_upfc == 3) {
                        pslam = this.vec_lam[onn + 2 * this.numupfc + k];
                    }
                    psaux = Math.cos(thboost - thexc - tbb) * ybb;
                    double[] dArray112 = this.mat_W[off + row];
                    int n112 = off + col;
                    dArray112[n112] = dArray112[n112] + pslam * psaux;
                    double[] dArray113 = this.mat_W[off + col];
                    int n113 = off + row;
                    dArray113[n113] = dArray113[n113] + pslam * psaux;
                    psaux = -2.0 * Math.cos(thboost - thexc - tbb) * ybb;
                    double[] dArray114 = this.mat_W[off + col];
                    int n114 = off + col;
                    dArray114[n114] = dArray114[n114] + pslam * psaux;
                    psaux = vnexc * vnboost * Math.cos(thboost - thexc - tbb) * ybb;
                    double[] dArray115 = this.mat_W[off + this.numnod + row];
                    int n115 = off + this.numnod + col;
                    dArray115[n115] = dArray115[n115] + pslam * psaux;
                    double[] dArray116 = this.mat_W[off + this.numnod + col];
                    int n116 = off + this.numnod + row;
                    dArray116[n116] = dArray116[n116] + pslam * psaux;
                    double[] dArray117 = this.mat_W[off + this.numnod + row];
                    int n117 = off + this.numnod + row;
                    dArray117[n117] = dArray117[n117] + pslam * -psaux;
                    double[] dArray118 = this.mat_W[off + this.numnod + col];
                    int n118 = off + this.numnod + col;
                    dArray118[n118] = dArray118[n118] + pslam * -psaux;
                    psaux = vnexc * Math.sin(thboost - thexc - tbb) * ybb;
                    double[] dArray119 = this.mat_W[off + this.numnod + row];
                    int n119 = off + col;
                    dArray119[n119] = dArray119[n119] + pslam * psaux;
                    double[] dArray120 = this.mat_W[off + col];
                    int n120 = off + this.numnod + row;
                    dArray120[n120] = dArray120[n120] + pslam * psaux;
                    double[] dArray121 = this.mat_W[off + this.numnod + col];
                    int n121 = off + col;
                    dArray121[n121] = dArray121[n121] + pslam * -psaux;
                    double[] dArray122 = this.mat_W[off + col];
                    int n122 = off + this.numnod + col;
                    dArray122[n122] = dArray122[n122] + pslam * -psaux;
                    psaux = vnboost * Math.sin(thboost - thexc - tbb) * ybb;
                    double[] dArray123 = this.mat_W[off + this.numnod + col];
                    int n123 = off + row;
                    dArray123[n123] = dArray123[n123] + pslam * -psaux;
                    double[] dArray124 = this.mat_W[off + row];
                    int n124 = off + this.numnod + col;
                    dArray124[n124] = dArray124[n124] + pslam * -psaux;
                    double[] dArray125 = this.mat_W[off + this.numnod + row];
                    int n125 = off + row;
                    dArray125[n125] = dArray125[n125] + pslam * psaux;
                    double[] dArray126 = this.mat_W[off + row];
                    int n126 = off + this.numnod + row;
                    dArray126[n126] = dArray126[n126] + pslam * psaux;
                    qsaux = Math.sin(thboost - thexc - tbb) * ybb;
                    double[] dArray127 = this.mat_W[off + row];
                    int n127 = off + col;
                    dArray127[n127] = dArray127[n127] + qslam * qsaux;
                    double[] dArray128 = this.mat_W[off + col];
                    int n128 = off + row;
                    dArray128[n128] = dArray128[n128] + qslam * qsaux;
                    qsaux = 2.0 * Math.sin(thboost - thexc - tbb) * ybb;
                    double[] dArray129 = this.mat_W[off + col];
                    int n129 = off + col;
                    dArray129[n129] = dArray129[n129] + qslam * qsaux;
                    qsaux = vnexc * vnboost * Math.sin(thboost - thexc - tbb) * ybb;
                    double[] dArray130 = this.mat_W[off + this.numnod + row];
                    int n130 = off + this.numnod + col;
                    dArray130[n130] = dArray130[n130] + qslam * qsaux;
                    double[] dArray131 = this.mat_W[off + this.numnod + col];
                    int n131 = off + this.numnod + row;
                    dArray131[n131] = dArray131[n131] + qslam * qsaux;
                    double[] dArray132 = this.mat_W[off + this.numnod + row];
                    int n132 = off + this.numnod + row;
                    dArray132[n132] = dArray132[n132] + qslam * -qsaux;
                    double[] dArray133 = this.mat_W[off + this.numnod + col];
                    int n133 = off + this.numnod + col;
                    dArray133[n133] = dArray133[n133] + qslam * -qsaux;
                    qsaux = vnexc * Math.cos(thboost - thexc - tbb) * ybb;
                    double[] dArray134 = this.mat_W[off + this.numnod + row];
                    int n134 = off + col;
                    dArray134[n134] = dArray134[n134] + qslam * -qsaux;
                    double[] dArray135 = this.mat_W[off + col];
                    int n135 = off + this.numnod + row;
                    dArray135[n135] = dArray135[n135] + qslam * -qsaux;
                    double[] dArray136 = this.mat_W[off + this.numnod + col];
                    int n136 = off + col;
                    dArray136[n136] = dArray136[n136] + qslam * qsaux;
                    double[] dArray137 = this.mat_W[off + col];
                    int n137 = off + this.numnod + col;
                    dArray137[n137] = dArray137[n137] + qslam * qsaux;
                    qsaux = vnboost * Math.cos(thboost - thexc - tbb) * ybb;
                    double[] dArray138 = this.mat_W[off + this.numnod + col];
                    int n138 = off + row;
                    dArray138[n138] = dArray138[n138] + qslam * qsaux;
                    double[] dArray139 = this.mat_W[off + row];
                    int n139 = off + this.numnod + col;
                    dArray139[n139] = dArray139[n139] + qslam * qsaux;
                    double[] dArray140 = this.mat_W[off + this.numnod + row];
                    int n140 = off + row;
                    dArray140[n140] = dArray140[n140] + qslam * -qsaux;
                    double[] dArray141 = this.mat_W[off + row];
                    int n141 = off + this.numnod + row;
                    dArray141[n141] = dArray141[n141] + qslam * -qsaux;
                }
            }
        }
    }

    public void make_DiagMat_Q() {
        int i = 0;
        int ix = 0;
        int count = 0;
        int count1 = 0;
        for (i = 0; i < 2 * this.numlast + 2 * this.numgen; ++i) {
            this.DiagMat_Q[i] = 0.0;
        }
        for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
            comp TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
            if (!TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice()) continue;
            if (TempComponent instanceof ndb_inj) {
                ndb_inj TempInj = (ndb_inj)TempComponent;
                this.DiagMat_Q[count] = 2.0 * TempInj.getgamma() * this.sref * this.sref;
                ++count;
            }
            if (!(TempComponent instanceof Load)) continue;
            Load TempLoad = (Load)TempComponent;
            this.DiagMat_Q[count1 + 2 * this.numgen] = 2.0 * TempLoad.getgamma() * this.sref * this.sref;
            ++count1;
        }
    }

    public void startPoint() {
        int i;
        for (i = 0; i < 2 * this.numgen + 2 * this.numlast; ++i) {
            this.vec_xtempabs[i] = 0.0;
        }
        for (i = 2 * this.numgen + 2 * this.numlast; i < 2 * this.numgen + 2 * this.numlast + this.numnod; ++i) {
            this.vec_xtempabs[i] = 1.0;
        }
        for (i = 2 * this.numgen + 2 * this.numlast + this.numnod; i < 2 * this.numgen + 2 * this.numlast + 2 * this.numnod; ++i) {
            this.vec_xtempabs[i] = 0.0;
        }
        if (this.isTapOptVariable && this.numtrafo > 0) {
            for (i = 2 * this.numgen + 2 * this.numlast + 2 * this.numnod; i < 2 * this.numgen + 2 * this.numlast + 2 * this.numnod + this.numtrafo; ++i) {
                this.vec_xtempabs[i] = 1.0;
            }
        }
    }

    public double make_cost() {
        double cost = 0.0;
        for (int i = 0; i < 2 * this.numgen + 2 * this.numlast; ++i) {
            cost += this.vec_xtempabs[i] * (this.vec_c[i] + this.DiagMat_Q[i] / 2.0 * this.vec_xtempabs[i]);
        }
        return cost;
    }

    public int numbus(String Busbarname) {
        int ix = 0;
        for (ix = 0; ix < this.BusbarVectorI.size(); ++ix) {
            comp TempComponent = (comp)this.BusbarVectorI.elementAt(ix);
            if (TempComponent.getName().hashCode() != Busbarname.hashCode() || !TempComponent.getName().equals(Busbarname)) continue;
            return ix;
        }
        System.out.println(" No Busbar name found !! (" + Busbarname + ")");
        return 0;
    }

    public void make_vec_OBJ() {
        int i = 0;
        boolean ix = false;
        boolean count = false;
        for (i = 0; i < 2 * this.numgen + 2 * this.numlast; ++i) {
            this.vec_OBJ[i] = this.vec_c[i] + this.DiagMat_Q[i] * this.vec_xtempabs[i];
        }
    }

    public void make_mat_A() {
        Complex auxc2;
        Complex auxc1;
        int k;
        int i;
        double Yij;
        Line TempLine;
        comp TempComponent;
        int corvar;
        int corres;
        int con2;
        int con1;
        int ix;
        int j;
        double tij;
        double yij;
        int col;
        int row;
        int count = 0;
        boolean count1 = false;
        int off = 2 * this.numgen + 2 * this.numlast;
        int offdos = this.isTapOptVariable ? 2 * this.numgen + 2 * this.numlast + 2 * this.numnod + this.numtran : 2 * this.numgen + 2 * this.numlast + 2 * this.numnod;
        int onn = this.linres == 1 ? 2 * this.numnod + this.numlastres + 2 * this.numlin : (this.linres == 2 ? 2 * this.numnod + this.numlastres + this.numlin : 2 * this.numnod + this.numlastres);
        double rserie = 0.0;
        double xserie = 0.0;
        double gshunt = 0.0;
        double bshunt = 0.0;
        double vboost = 0.0;
        double beta = 0.0;
        double vexc = 0.0;
        double epsilon = 0.0;
        double Pfe = 0.0;
        double Qe = 0.0;
        double Qb = 0.0;
        double VeMax = 0.0;
        double VbMax = 0.0;
        double alfa = 0.0;
        double delta = 0.0;
        double vnexc = 0.0;
        double vnboost = 0.0;
        double thexc = 0.0;
        double thboost = 0.0;
        for (row = 0; row < 2 * this.numnod; ++row) {
            if (!this.isTapOptVariable) {
                for (col = off; col < off + 2 * this.numnod; ++col) {
                    this.mat_A[row][col] = 0.0;
                }
            }
            if (!this.isTapOptVariable) continue;
            for (col = off; col < off + 2 * this.numnod + this.numtran; ++col) {
                this.mat_A[row][col] = 0.0;
            }
        }
        for (row = 0; row < this.numnod; ++row) {
            for (col = 0; col < this.numnod; ++col) {
                yij = Complex.abs((Complex)this.MatYact[row][col]);
                tij = Complex.argument((Complex)this.MatYact[row][col]);
                if (row == col) {
                    double[] dArray = this.mat_A[row];
                    int n = col + off;
                    dArray[n] = dArray[n] + -2.0 * this.vec_xtempabs[row + off] * yij * Math.cos(tij);
                    for (j = 0; j < this.numnod; ++j) {
                        yij = Complex.abs((Complex)this.MatYact[row][j]);
                        tij = Complex.argument((Complex)this.MatYact[row][j]);
                        if (j == row) continue;
                        double[] dArray2 = this.mat_A[row];
                        int n2 = col + off;
                        dArray2[n2] = dArray2[n2] + -this.vec_xtempabs[j + off] * yij * Math.cos(this.vec_xtempabs[row + off + this.numnod] - this.vec_xtempabs[j + off + this.numnod] - tij);
                    }
                    continue;
                }
                double[] dArray = this.mat_A[row];
                int n = col + off;
                dArray[n] = dArray[n] + -this.vec_xtempabs[row + off] * yij * Math.cos(this.vec_xtempabs[row + off + this.numnod] - this.vec_xtempabs[col + off + this.numnod] - tij);
            }
        }
        for (row = 0; row < this.numnod; ++row) {
            for (col = 0; col < this.numnod; ++col) {
                yij = Complex.abs((Complex)this.MatYact[row][col]);
                tij = Complex.argument((Complex)this.MatYact[row][col]);
                if (row == col) {
                    double[] dArray = this.mat_A[row + this.numnod];
                    int n = col + off;
                    dArray[n] = dArray[n] + -2.0 * this.vec_xtempabs[row + off] * yij * Math.sin(-tij);
                    for (j = 0; j < this.numnod; ++j) {
                        yij = Complex.abs((Complex)this.MatYact[row][j]);
                        tij = Complex.argument((Complex)this.MatYact[row][j]);
                        if (j == row) continue;
                        double[] dArray3 = this.mat_A[row + this.numnod];
                        int n3 = col + off;
                        dArray3[n3] = dArray3[n3] + -this.vec_xtempabs[j + off] * yij * Math.sin(this.vec_xtempabs[row + off + this.numnod] - this.vec_xtempabs[j + off + this.numnod] - tij);
                    }
                    continue;
                }
                double[] dArray = this.mat_A[row + this.numnod];
                int n = col + off;
                dArray[n] = dArray[n] + -this.vec_xtempabs[row + off] * yij * Math.sin(this.vec_xtempabs[row + off + this.numnod] - this.vec_xtempabs[col + off + this.numnod] - tij);
            }
        }
        for (row = 0; row < this.numnod; ++row) {
            for (col = 0; col < this.numnod; ++col) {
                yij = Complex.abs((Complex)this.MatYact[row][col]);
                tij = Complex.argument((Complex)this.MatYact[row][col]);
                if (row == col) {
                    for (j = 0; j < this.numnod; ++j) {
                        yij = Complex.abs((Complex)this.MatYact[row][j]);
                        tij = Complex.argument((Complex)this.MatYact[row][j]);
                        if (j == row) continue;
                        double[] dArray = this.mat_A[row];
                        int n = col + off + this.numnod;
                        dArray[n] = dArray[n] + this.vec_xtempabs[j + off] * this.vec_xtempabs[row + off] * yij * Math.sin(this.vec_xtempabs[row + off + this.numnod] - this.vec_xtempabs[j + off + this.numnod] - tij);
                    }
                    continue;
                }
                double[] dArray = this.mat_A[row];
                int n = col + off + this.numnod;
                dArray[n] = dArray[n] + -this.vec_xtempabs[row + off] * this.vec_xtempabs[col + off] * yij * Math.sin(this.vec_xtempabs[row + off + this.numnod] - this.vec_xtempabs[col + off + this.numnod] - tij);
            }
        }
        for (row = 0; row < this.numnod; ++row) {
            for (col = 0; col < this.numnod; ++col) {
                yij = Complex.abs((Complex)this.MatYact[row][col]);
                tij = Complex.argument((Complex)this.MatYact[row][col]);
                if (row == col) {
                    for (j = 0; j < this.numnod; ++j) {
                        yij = Complex.abs((Complex)this.MatYact[row][j]);
                        tij = Complex.argument((Complex)this.MatYact[row][j]);
                        if (j == row) continue;
                        double[] dArray = this.mat_A[row + this.numnod];
                        int n = col + off + this.numnod;
                        dArray[n] = dArray[n] + -this.vec_xtempabs[row + off] * this.vec_xtempabs[j + off] * yij * Math.cos(this.vec_xtempabs[row + off + this.numnod] - this.vec_xtempabs[j + off + this.numnod] - tij);
                    }
                    continue;
                }
                double[] dArray = this.mat_A[row + this.numnod];
                int n = col + off + this.numnod;
                dArray[n] = dArray[n] + this.vec_xtempabs[col + off] * this.vec_xtempabs[row + off] * yij * Math.cos(this.vec_xtempabs[row + off + this.numnod] - this.vec_xtempabs[col + off + this.numnod] - tij);
            }
        }
        if (this.linres == 1) {
            ix = 0;
            count = 0;
            con1 = 10000;
            con2 = 10000;
            corres = 2 * this.numnod + this.numlastres;
            corvar = 2 * this.numgen + 2 * this.numlast;
            for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
                TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
                if (!TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice() || !(TempComponent instanceof Line) || (con1 = this.numbus((TempLine = (Line)TempComponent).getcon1())) == 10000 || (con2 = this.numbus(TempLine.getcon2())) == 10000) continue;
                Complex Lauxc1 = new Complex(this.LranchR[count], this.LranchX[count]);
                Complex Lauxc2 = new Complex(1.0);
                Lauxc1 = Complex.divide((Complex)Lauxc2, (Complex)Lauxc1);
                Complex Lyij = new Complex(0.0, 0.0);
                Lyij.add(Lauxc1);
                Yij = Complex.abs((Complex)Lyij);
                double Tij = Complex.argument((Complex)Lyij);
                double Vi = this.vec_xtempabs[corvar + con1];
                double Vj = this.vec_xtempabs[corvar + con2];
                double Ti = this.vec_xtempabs[corvar + this.numnod + con1];
                double Tj = this.vec_xtempabs[corvar + this.numnod + con2];
                this.mat_A[corres + count][corvar + con1] = 2.0 * Vi * Yij * Math.cos(Tij) - Vj * Yij * Math.cos(Ti - Tj - Tij);
                this.mat_A[corres + this.numlin + count][corvar + con1] = 2.0 * Vi * Yij * Math.cos(Tij) - Vj * Yij * Math.cos(Ti - Tj - Tij);
                this.mat_A[corres + count][corvar + con2] = -Vi * Yij * Math.cos(Ti - Tj - Tij);
                this.mat_A[corres + this.numlin + count][corvar + con2] = -Vi * Yij * Math.cos(Ti - Tj - Tij);
                this.mat_A[corres + count][corvar + this.numnod + con1] = Vi * Vj * Yij * Math.sin(Ti - Tj - Tij);
                this.mat_A[corres + this.numlin + count][corvar + this.numnod + con1] = Vi * Vj * Yij * Math.sin(Ti - Tj - Tij);
                this.mat_A[corres + count][corvar + this.numnod + con2] = -Vi * Vj * Yij * Math.sin(Ti - Tj - Tij);
                this.mat_A[corres + this.numlin + count][corvar + this.numnod + con2] = -Vi * Vj * Yij * Math.sin(Ti - Tj - Tij);
                ++count;
            }
        } else if (this.linres == 2) {
            ix = 0;
            count = 0;
            con1 = 10000;
            con2 = 10000;
            corres = 2 * this.numnod + this.numlastres;
            corvar = 2 * this.numgen + 2 * this.numlast;
            for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
                TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
                if (!TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice() || !(TempComponent instanceof Line) || (con1 = this.numbus((TempLine = (Line)TempComponent).getcon1())) == 10000 || (con2 = this.numbus(TempLine.getcon2())) == 10000) continue;
                Complex Lauxc1 = new Complex(this.LranchR[count], this.LranchX[count]);
                Complex Lauxc2 = new Complex(1.0);
                Lauxc1 = Complex.divide((Complex)Lauxc2, (Complex)Lauxc1);
                Complex Lyij = new Complex(0.0, 0.0);
                Lyij.add(Lauxc1);
                Yij = Complex.abs((Complex)Lyij);
                double Vi = this.vec_xtempabs[corvar + con1];
                double Vj = this.vec_xtempabs[corvar + con2];
                double Ti = this.vec_xtempabs[corvar + this.numnod + con1];
                double Tj = this.vec_xtempabs[corvar + this.numnod + con2];
                this.mat_A[corres + count][corvar + con1] = 2.0 * Yij * Yij * (Vi - Vj * Math.cos(Ti - Tj));
                this.mat_A[corres + count][corvar + con2] = 2.0 * Yij * Yij * (Vj - Vi * Math.cos(Ti - Tj));
                this.mat_A[corres + count][corvar + this.numnod + con1] = 2.0 * Yij * Yij * Vi * Vj * Math.sin(Ti - Tj);
                this.mat_A[corres + count][corvar + this.numnod + con2] = -2.0 * Yij * Yij * Vi * Vj * Math.sin(Ti - Tj);
                ++count;
            }
        }
        if (this.numtrafo > 0 && this.isTapOptVariable) {
            int corrvar = 2 * this.numgen + 2 * this.numlast + 2 * this.numnod;
            int off1 = 2 * this.numgen + 2 * this.numlast;
            double VI = 0.0;
            double VJ = 0.0;
            double TI = 0.0;
            double TJ = 0.0;
            double YIJ = 0.0;
            double YJI = 0.0;
            double TIJ = 0.0;
            double TJI = 0.0;
            double YII = 0.0;
            double TII = 0.0;
            double YJJ = 0.0;
            double TJJ = 0.0;
            int kon1 = -1;
            int kon2 = -1;
            for (i = 0; i < this.numnod; ++i) {
                for (k = 0; k < this.numtrafo; ++k) {
                    if (this.TranchI[k] != i) continue;
                    kon1 = this.TranchI[k];
                    kon2 = this.TranchJ[k];
                    VI = this.vec_xtempabs[off1 + kon1];
                    VJ = this.vec_xtempabs[off1 + kon2];
                    TI = this.vec_xtempabs[off1 + this.numnod + kon1];
                    TJ = this.vec_xtempabs[off1 + this.numnod + kon2];
                    auxc1 = new Complex(this.TranchR[k], this.TranchX[k]);
                    auxc2 = new Complex(1.0);
                    auxc1 = Complex.divide((Complex)auxc2, (Complex)auxc1);
                    auxc2 = new Complex(0.0, this.TranchB[k]);
                    YIJ = Complex.abs((Complex)Complex.negate((Complex)auxc1));
                    YJI = Complex.abs((Complex)Complex.negate((Complex)auxc1));
                    TIJ = Complex.argument((Complex)Complex.negate((Complex)auxc1));
                    TJI = Complex.argument((Complex)Complex.negate((Complex)auxc1));
                    YII = Complex.abs((Complex)Complex.add((Complex)auxc1, (Complex)auxc2));
                    TII = Complex.argument((Complex)Complex.add((Complex)auxc1, (Complex)auxc2));
                    YJJ = Complex.abs((Complex)Complex.add((Complex)auxc1, (Complex)auxc2));
                    TJJ = Complex.argument((Complex)Complex.add((Complex)auxc1, (Complex)auxc2));
                    double[] dArray = this.mat_A[kon1];
                    int n = corrvar + k;
                    dArray[n] = dArray[n] + -VI * VJ * YIJ * Math.cos(TI - TJ - TIJ);
                    double[] dArray4 = this.mat_A[this.numnod + kon1];
                    int n4 = corrvar + k;
                    dArray4[n4] = dArray4[n4] + -VI * VJ * YIJ * Math.sin(TI - TJ - TIJ);
                    double[] dArray5 = this.mat_A[kon2];
                    int n5 = corrvar + k;
                    dArray5[n5] = dArray5[n5] + -VJ * VI * YJI * Math.cos(TJ - TI - TJI);
                    double[] dArray6 = this.mat_A[this.numnod + kon2];
                    int n6 = corrvar + k;
                    dArray6[n6] = dArray6[n6] + -VJ * VI * YJI * Math.sin(TJ - TI - TJI);
                    double[] dArray7 = this.mat_A[kon1];
                    int n7 = corrvar + k;
                    dArray7[n7] = dArray7[n7] + -VI * VI * Math.cos(-TII) * 2.0 * YII * this.vec_xtempabs[corrvar + k];
                    double[] dArray8 = this.mat_A[this.numnod + kon1];
                    int n8 = corrvar + k;
                    dArray8[n8] = dArray8[n8] + -VI * VI * Math.sin(-TII) * 2.0 * YII * this.vec_xtempabs[corrvar + k];
                }
            }
        }
        if (this.numupfc > 0) {
            for (i = 0; i < this.numnod; ++i) {
                for (k = 0; k < this.numupfc; ++k) {
                    if (this.TOupfc[k][0] != i) continue;
                    rserie = this.PARupfc[k][0];
                    xserie = this.PARupfc[k][1];
                    gshunt = this.PARupfc[k][2];
                    bshunt = this.PARupfc[k][3];
                    VbMax = this.PARupfc[k][4];
                    VeMax = this.PARupfc[k][5];
                    row = this.TOupfc[k][0];
                    col = this.TOupfc[k][1];
                    auxc1 = new Complex(rserie, xserie);
                    auxc2 = new Complex(1.0);
                    auxc1 = Complex.divide((Complex)auxc2, (Complex)auxc1);
                    auxc2 = new Complex(0.0, bshunt);
                    double ybb = Complex.abs((Complex)auxc1);
                    double tbb = Complex.argument((Complex)auxc1);
                    double yee = Complex.abs((Complex)auxc2);
                    double tee = Complex.argument((Complex)auxc2);
                    Pfe = this.vec_xtempabs[offdos + k];
                    Qe = this.vec_xtempabs[offdos + this.numupfc + k];
                    Qb = this.vec_xtempabs[offdos + 2 * this.numupfc + k];
                    vnexc = this.vec_xtempabs[off + row];
                    vnboost = this.vec_xtempabs[off + col];
                    thexc = this.vec_xtempabs[off + this.numnod + row];
                    thboost = this.vec_xtempabs[off + this.numnod + col];
                    delta = thexc - thboost;
                    alfa = vnboost / vnexc;
                    this.mat_A[onn + k][off + col] = -2.0 * (VbMax * VbMax * ybb * ybb) * vnboost;
                    this.mat_A[onn + k][offdos + k] = 2.0 * Pfe;
                    this.mat_A[onn + k][offdos + 2 * this.numupfc + k] = 2.0 * Qb;
                    this.mat_A[onn + this.numupfc + k][off + row] = -2.0 * (vnboost * vnboost / (vnexc * vnexc * vnexc)) * (Qe * Qe + Pfe * Pfe) - vnboost / (vnexc * vnexc) * (2.0 * Qe * Qb * Math.cos(delta) - 2.0 * Pfe * Qe * Math.sin(delta) - 2.0 * Pfe * Pfe * Math.cos(delta) - 2.0 * Qb * Pfe * Math.sin(delta));
                    this.mat_A[onn + this.numupfc + k][off + col] = 2.0 * (vnboost / (vnexc * vnexc)) * (Qe * Qe + Pfe * Pfe) + 1.0 / vnexc * (2.0 * Qe * Qb * Math.cos(delta) - 2.0 * Pfe * Qe * Math.sin(delta) - 2.0 * Pfe * Pfe * Math.cos(delta) - 2.0 * Qb * Pfe * Math.sin(delta)) - 2.0 * (VeMax * VeMax * yee * yee) * vnboost;
                    this.mat_A[onn + this.numupfc + k][off + this.numnod + row] = -2.0 * alfa * Qe * Qb * Math.sin(delta) - 2.0 * alfa * Pfe * Qe * Math.cos(delta) + 2.0 * alfa * Pfe * Pfe * Math.sin(delta) - 2.0 * alfa * Qb * Pfe * Math.cos(delta);
                    this.mat_A[onn + this.numupfc + k][off + this.numnod + col] = 2.0 * alfa * Qe * Qb * Math.sin(delta) + 2.0 * alfa * Pfe * Qe * Math.cos(delta) - 2.0 * alfa * Pfe * Pfe * Math.sin(delta) + 2.0 * alfa * Qb * Pfe * Math.cos(delta);
                    this.mat_A[onn + this.numupfc + k][offdos + k] = -2.0 * alfa * Qe * Math.sin(delta) + 2.0 * Pfe + 2.0 * Pfe * alfa * alfa - 4.0 * alfa * Pfe * Math.cos(delta) - 2.0 * alfa * Qb * Math.sin(delta);
                    this.mat_A[onn + this.numupfc + k][offdos + this.numupfc + k] = 2.0 * Qe * alfa * alfa + 2.0 * alfa * Qb * Math.cos(delta) - 2.0 * alfa * Pfe * Math.sin(delta);
                    this.mat_A[onn + this.numupfc + k][offdos + 2 * this.numupfc + k] = 2.0 * alfa * Qe * Math.cos(delta) + 2.0 * Qb - 2.0 * alfa * Pfe * Math.sin(delta);
                    if (!this.upfcres) continue;
                    if (this.modop_upfc == 1 || this.modop_upfc == 2 || this.modop_upfc == 3) {
                        this.mat_A[onn + 2 * this.numupfc + k][off + row] = vnboost * Math.cos(thboost - thexc - tbb) * ybb;
                        this.mat_A[onn + 2 * this.numupfc + k][off + col] = vnexc * Math.cos(thboost - thexc - tbb) * ybb - 2.0 * vnboost * ybb * Math.cos(tbb);
                        this.mat_A[onn + 2 * this.numupfc + k][off + this.numnod + row] = vnexc * vnboost * Math.sin(thboost - thexc - tbb) * ybb;
                        this.mat_A[onn + 2 * this.numupfc + k][off + this.numnod + col] = -vnexc * vnboost * Math.sin(thboost - thexc - tbb) * ybb;
                        this.mat_A[onn + 2 * this.numupfc + k][offdos + k] = 1.0;
                    }
                    if (this.modop_upfc == 1 || this.modop_upfc == 2) {
                        this.mat_A[onn + 3 * this.numupfc + k][off + row] = vnboost * Math.sin(thboost - thexc - tbb) * ybb;
                        this.mat_A[onn + 3 * this.numupfc + k][off + col] = vnexc * Math.sin(thboost - thexc - tbb) * ybb + 2.0 * vnboost * ybb * Math.sin(tbb);
                        this.mat_A[onn + 3 * this.numupfc + k][off + this.numnod + row] = -vnexc * vnboost * Math.cos(thboost - thexc - tbb) * ybb;
                        this.mat_A[onn + 3 * this.numupfc + k][off + this.numnod + col] = vnexc * vnboost * Math.cos(thboost - thexc - tbb) * ybb;
                        this.mat_A[onn + 3 * this.numupfc + k][offdos + 2 * this.numupfc + k] = -1.0;
                    }
                    if (this.modop_upfc == 1) {
                        this.mat_A[onn + 4 * this.numupfc + k][off + row] = 1.0;
                        continue;
                    }
                    if (this.modop_upfc == 4) {
                        this.mat_A[onn + 2 * this.numupfc + k][off + row] = 1.0;
                        continue;
                    }
                    if (this.modop_upfc != 5) continue;
                    this.mat_A[onn + 2 * this.numupfc + k][off + row] = -this.mod_T;
                    this.mat_A[onn + 2 * this.numupfc + k][off + col] = 1.0;
                    this.mat_A[onn + 3 * this.numupfc + k][off + this.numnod + row] = 1.0;
                    this.mat_A[onn + 3 * this.numupfc + k][off + this.numnod + col] = -1.0;
                }
            }
        }
    }

    public void make_vec_RHS() {
        double Yij;
        Line TempLine;
        comp TempComponent;
        int corvar;
        int corres;
        int con2;
        int con1;
        int count;
        int ix;
        double tempa;
        int i = 0;
        int j = 0;
        int k = 0;
        double rserie = 0.0;
        double xserie = 0.0;
        double gshunt = 0.0;
        double bshunt = 0.0;
        double vboost = 0.0;
        double beta = 0.0;
        double vexc = 0.0;
        double epsilon = 0.0;
        double Pfe = 0.0;
        double Qe = 0.0;
        double Qb = 0.0;
        double VeMax = 0.0;
        double VbMax = 0.0;
        double alfa = 0.0;
        double delta = 0.0;
        double vnexc = 0.0;
        double vnboost = 0.0;
        double thexc = 0.0;
        double thboost = 0.0;
        int off = 2 * this.numgen + 2 * this.numlast;
        int offdos = this.isTapOptVariable ? 2 * this.numgen + 2 * this.numlast + 2 * this.numnod + this.numtran : 2 * this.numgen + 2 * this.numlast + 2 * this.numnod;
        int onn = this.linres == 1 ? 2 * this.numnod + this.numlastres + 2 * this.numlin : (this.linres == 2 ? 2 * this.numnod + this.numlastres + this.numlin : 2 * this.numnod + this.numlastres);
        for (i = 0; i < this.numres; ++i) {
            this.vec_RHS[i] = 0.0;
        }
        for (i = 0; i < this.numnod; ++i) {
            this.vec_RHS[i] = -this.node_p[i];
            this.vec_RHS[i + this.numnod] = -this.node_q[i];
        }
        for (i = 0; i < this.numgen; ++i) {
            int n = this.VarNode[i];
            this.vec_RHS[n] = this.vec_RHS[n] - this.vec_xtempabs[i];
            int n2 = this.VarNode[i] + this.numnod;
            this.vec_RHS[n2] = this.vec_RHS[n2] - this.vec_xtempabs[i + this.numgen];
        }
        for (i = 0; i < this.numlast; ++i) {
            int n = this.VarNode[i + 2 * this.numgen];
            this.vec_RHS[n] = this.vec_RHS[n] - this.vec_xtempabs[i + 2 * this.numgen];
            int n3 = this.VarNode[i + 2 * this.numgen] + this.numnod;
            this.vec_RHS[n3] = this.vec_RHS[n3] - this.vec_xtempabs[i + 2 * this.numgen + this.numlast];
        }
        off = 2 * this.numgen + 2 * this.numlast;
        i = 0;
        while (i < this.numnod) {
            tempa = 0.0;
            for (j = 0; j < this.numnod; ++j) {
                tempa += this.vec_xtempabs[i + off] * this.vec_xtempabs[j + off] * Complex.abs((Complex)this.MatYact[i][j]) * Math.cos(this.vec_xtempabs[i + off + this.numnod] - this.vec_xtempabs[j + off + this.numnod] - Complex.argument((Complex)this.MatYact[i][j]));
            }
            int n = i++;
            this.vec_RHS[n] = this.vec_RHS[n] + tempa;
        }
        off = 2 * this.numgen + 2 * this.numlast;
        for (i = 0; i < this.numnod; ++i) {
            tempa = 0.0;
            for (j = 0; j < this.numnod; ++j) {
                tempa += this.vec_xtempabs[i + off] * this.vec_xtempabs[j + off] * Complex.abs((Complex)this.MatYact[i][j]) * Math.sin(this.vec_xtempabs[i + off + this.numnod] - this.vec_xtempabs[j + off + this.numnod] - Complex.argument((Complex)this.MatYact[i][j]));
            }
            int n = i + this.numnod;
            this.vec_RHS[n] = this.vec_RHS[n] + tempa;
        }
        for (i = 0; i < this.numlastres; ++i) {
            this.vec_RHS[i + 2 * this.numnod] = -this.vec_xtempabs[this.ResLast[i] + 2 * this.numgen] - this.vec_pf[i] * this.vec_xtempabs[this.ResLast[i] + 2 * this.numgen + this.numlast];
        }
        if (this.numupfc > 0) {
            for (i = 0; i < this.numnod; ++i) {
                for (k = 0; k < this.numupfc; ++k) {
                    if (this.TOupfc[k][0] != i) continue;
                    int n = this.TOupfc[k][0];
                    this.vec_RHS[n] = this.vec_RHS[n] + this.vec_xtempabs[offdos + k];
                    int n4 = this.TOupfc[k][1];
                    this.vec_RHS[n4] = this.vec_RHS[n4] + -this.vec_xtempabs[offdos + k];
                    int n5 = this.TOupfc[k][0] + this.numnod;
                    this.vec_RHS[n5] = this.vec_RHS[n5] + this.vec_xtempabs[offdos + this.numupfc + k];
                    int n6 = this.TOupfc[k][1] + this.numnod;
                    this.vec_RHS[n6] = this.vec_RHS[n6] + this.vec_xtempabs[offdos + 2 * this.numupfc + k];
                }
            }
        }
        if (this.linres == 1) {
            ix = 0;
            count = 0;
            con1 = 10000;
            con2 = 10000;
            corres = 2 * this.numnod + this.numlastres;
            corvar = 2 * this.numgen + 2 * this.numlast;
            for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
                TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
                if (!TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice() || !(TempComponent instanceof Line) || (con1 = this.numbus((TempLine = (Line)TempComponent).getcon1())) == 10000 || (con2 = this.numbus(TempLine.getcon2())) == 10000) continue;
                Complex Lauxc1 = new Complex(this.LranchR[count], this.LranchX[count]);
                Complex Lauxc2 = new Complex(1.0);
                Lauxc1 = Complex.divide((Complex)Lauxc2, (Complex)Lauxc1);
                Complex Lyij = new Complex(0.0, 0.0);
                Lyij.add(Lauxc1);
                Yij = Complex.abs((Complex)Lyij);
                double Tij = Complex.argument((Complex)Lyij);
                double Vi = this.vec_xtempabs[corvar + con1];
                double Vj = this.vec_xtempabs[corvar + con2];
                double Ti = this.vec_xtempabs[corvar + this.numnod + con1];
                double Tj = this.vec_xtempabs[corvar + this.numnod + con2];
                double Pmax = TempLine.getsmax() / this.sref * TempLine.getsc();
                this.vec_RHS[corres + count] = Pmax - (Vi * Vi * Yij * Math.cos(Tij) - Vi * Vj * Yij * Math.cos(Ti - Tj - Tij));
                this.vec_RHS[corres + this.numlin + count] = -Pmax - (Vi * Vi * Yij * Math.cos(Tij) - Vi * Vj * Yij * Math.cos(Ti - Tj - Tij));
                ++count;
            }
        } else if (this.linres == 2) {
            ix = 0;
            count = 0;
            con1 = 10000;
            con2 = 10000;
            corres = 2 * this.numnod + this.numlastres;
            corvar = 2 * this.numgen + 2 * this.numlast;
            for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
                TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
                if (!TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice() || !(TempComponent instanceof Line) || (con1 = this.numbus((TempLine = (Line)TempComponent).getcon1())) == 10000 || (con2 = this.numbus(TempLine.getcon2())) == 10000) continue;
                Complex Lauxc1 = new Complex(this.LranchR[count], this.LranchX[count]);
                Complex Lauxc2 = new Complex(1.0);
                Lauxc1 = Complex.divide((Complex)Lauxc2, (Complex)Lauxc1);
                Complex Lyij = new Complex(0.0, 0.0);
                Lyij.add(Lauxc1);
                Yij = Complex.abs((Complex)Lyij);
                double Vi = this.vec_xtempabs[corvar + con1];
                double Vj = this.vec_xtempabs[corvar + con2];
                double Ti = this.vec_xtempabs[corvar + this.numnod + con1];
                double Tj = this.vec_xtempabs[corvar + this.numnod + con2];
                double I2ij = TempLine.getsmax() / this.sref * (TempLine.getsmax() / this.sref) * TempLine.getsc() * TempLine.getsc();
                this.vec_RHS[corres + count] = I2ij - Yij * Yij * (Vi * Vi + Vj * Vj - 2.0 * Vi * Vj * Math.cos(Ti - Tj));
                ++count;
            }
        }
        if (this.numupfc > 0) {
            for (i = 0; i < this.numnod; ++i) {
                for (k = 0; k < this.numupfc; ++k) {
                    if (this.TOupfc[k][0] != i) continue;
                    rserie = this.PARupfc[k][0];
                    xserie = this.PARupfc[k][1];
                    gshunt = this.PARupfc[k][2];
                    bshunt = this.PARupfc[k][3];
                    VbMax = this.PARupfc[k][4];
                    VeMax = this.PARupfc[k][5];
                    int row = this.TOupfc[k][0];
                    int col = this.TOupfc[k][1];
                    Complex auxc1 = new Complex(rserie, xserie);
                    Complex auxc2 = new Complex(1.0);
                    auxc1 = Complex.divide((Complex)auxc2, (Complex)auxc1);
                    auxc2 = new Complex(0.0, bshunt);
                    double ybb = Complex.abs((Complex)auxc1);
                    double tbb = Complex.argument((Complex)auxc1);
                    double yee = Complex.abs((Complex)auxc2);
                    double tee = Complex.argument((Complex)auxc2);
                    Pfe = this.vec_xtempabs[offdos + k];
                    Qe = this.vec_xtempabs[offdos + this.numupfc + k];
                    Qb = this.vec_xtempabs[offdos + 2 * this.numupfc + k];
                    vnexc = this.vec_xtempabs[off + row];
                    vnboost = this.vec_xtempabs[off + col];
                    thexc = this.vec_xtempabs[off + this.numnod + row];
                    thboost = this.vec_xtempabs[off + this.numnod + col];
                    delta = thexc - thboost;
                    alfa = vnboost / vnexc;
                    this.vec_RHS[onn + k] = -Qb * Qb - Pfe * Pfe + VbMax * vnboost * ybb * (VbMax * vnboost * ybb);
                    this.vec_RHS[onn + this.numupfc + k] = -1.0 * (alfa * alfa * Qe * Qe + 2.0 * alfa * Qe * Qb * Math.cos(delta) - 2.0 * alfa * Pfe * Qe * Math.sin(delta) + Qb * Qb + Pfe * Pfe + alfa * alfa * Pfe * Pfe - 2.0 * alfa * Pfe * Pfe * Math.cos(delta) - 2.0 * alfa * Qb * Pfe * Math.sin(delta) - VeMax * vnboost * yee * (VeMax * vnboost * yee));
                    if (!this.upfcres) continue;
                    if (this.modop_upfc == 1) {
                        this.vec_RHS[onn + 2 * this.numupfc + k] = -vnexc * vnboost * ybb * Math.cos(thboost - thexc - tbb) + vnboost * vnboost * ybb * Math.cos(tbb) - Pfe + this.Pesp[k];
                        this.vec_RHS[onn + 3 * this.numupfc + k] = -vnexc * vnboost * ybb * Math.sin(thboost - thexc - tbb) - vnboost * vnboost * ybb * Math.sin(tbb) + Qb + this.Qesp[k];
                        this.vec_RHS[onn + 4 * this.numupfc + k] = -vnexc + this.Vesp[k];
                        continue;
                    }
                    if (this.modop_upfc == 2) {
                        this.vec_RHS[onn + 2 * this.numupfc + k] = -vnexc * vnboost * ybb * Math.cos(thboost - thexc - tbb) + vnboost * vnboost * ybb * Math.cos(tbb) - Pfe + this.Pesp[k];
                        this.vec_RHS[onn + 3 * this.numupfc + k] = -vnexc * vnboost * ybb * Math.sin(thboost - thexc - tbb) - vnboost * vnboost * ybb * Math.sin(tbb) + Qb + this.Qesp[k];
                        continue;
                    }
                    if (this.modop_upfc == 3) {
                        this.vec_RHS[onn + 2 * this.numupfc + k] = -vnexc * vnboost * ybb * Math.cos(thboost - thexc - tbb) + vnboost * vnboost * ybb * Math.cos(tbb) - Pfe + this.Pesp[k];
                        continue;
                    }
                    if (this.modop_upfc == 4) {
                        this.vec_RHS[onn + 2 * this.numupfc + k] = -vnexc + this.Vesp[k];
                        continue;
                    }
                    if (this.modop_upfc != 5) continue;
                    this.vec_RHS[onn + 2 * this.numupfc + k] = this.mod_T * vnexc - vnboost;
                    this.vec_RHS[onn + 3 * this.numupfc + k] = thboost + this.ang_desfase * Math.PI / 180.0 - thexc;
                }
            }
        }
    }

    public void make_vec_clave() {
        int i;
        for (i = 0; i < 2 * this.numnod; ++i) {
            this.vec_clave[i] = 1;
        }
        for (i = 2 * this.numnod; i < 2 * this.numnod + this.numlastres; ++i) {
            this.vec_clave[i] = 1;
        }
        int lr = -1;
        lr = this.linres == 1 ? 2 * this.numlin : (this.linres == 2 ? this.numlin : 0);
        if (this.linres == 1) {
            for (i = 2 * this.numnod + this.numlastres; i < 2 * this.numnod + this.numlastres + this.numlin; ++i) {
                this.vec_clave[i] = 2;
            }
            for (i = 2 * this.numnod + this.numlastres + this.numlin; i < 2 * this.numnod + this.numlastres + 2 * this.numlin; ++i) {
                this.vec_clave[i] = 3;
            }
        } else if (this.linres == 2) {
            for (i = 2 * this.numnod + this.numlastres; i < 2 * this.numnod + this.numlastres + this.numlin; ++i) {
                this.vec_clave[i] = 2;
            }
        }
        if (this.numupfc > 0) {
            for (i = 2 * this.numnod + this.numlastres + lr; i < 2 * this.numnod + this.numlastres + lr + 2 * this.numupfc; ++i) {
                this.vec_clave[i] = 2;
            }
            if (this.upfcres) {
                for (i = 2 * this.numnod + this.numlastres + lr + 2 * this.numupfc; i < this.numres; ++i) {
                    this.vec_clave[i] = 1;
                }
            }
        }
    }

    public void WriteResults() {
        Complex ysh1 = new Complex();
        Complex ysh2 = new Complex();
        Complex ramashunt = new Complex(0.0, 0.0);
        Complex ybr = new Complex();
        Complex ybr12 = new Complex();
        Complex ybr21 = new Complex();
        Complex v1 = new Complex();
        Complex v2 = new Complex();
        Complex v3 = new Complex();
        Complex s1 = new Complex();
        Complex s2 = new Complex();
        Complex s12 = new Complex();
        Complex s21 = new Complex();
        Complex ctimag = new Complex();
        Complex unidad = new Complex(1.0, 0.0);
        Complex tapchange1 = new Complex();
        Complex tapchange2 = new Complex();
        Complex tapchange3 = new Complex();
        Complex cY12 = new Complex();
        Complex cY13 = new Complex();
        Complex cY23 = new Complex();
        Complex sumY1 = new Complex();
        Complex sumY2 = new Complex();
        Complex sumY3 = new Complex();
        Complex factor1 = new Complex();
        Complex factor2 = new Complex();
        Complex factor3 = new Complex();
        Complex auxramay12 = new Complex();
        Complex auxramay13 = new Complex();
        Complex auxramay23 = new Complex();
        double rserie = 0.0;
        double xserie = 0.0;
        double gshunt = 0.0;
        double bshunt = 0.0;
        double avisador = 0.0;
        double timag = 0.0;
        double VbMax = 0.0;
        double VeMax = 0.0;
        double vbf = 0.0;
        double vbq = 0.0;
        double vef = 0.0;
        double veq = 0.0;
        int row = 0;
        int col = 0;
        int off = 0;
        int offdos = 0;
        int onn = 0;
        double ybb = 0.0;
        double tbb = 0.0;
        double yee = 0.0;
        double tee = 0.0;
        double Pfe = 0.0;
        double Qe = 0.0;
        double Qb = 0.0;
        double vnexc = 0.0;
        double vnboost = 0.0;
        double thexc = 0.0;
        double thboost = 0.0;
        double delta = 0.0;
        double alfa = 0.0;
        off = 2 * this.numgen + 2 * this.numlast;
        offdos = this.isTapOptVariable ? 2 * this.numgen + 2 * this.numlast + 2 * this.numnod + this.numtran : 2 * this.numgen + 2 * this.numlast + 2 * this.numnod;
        onn = this.linres == 1 ? 2 * this.numnod + this.numlastres + 2 * this.numlin : (this.linres == 2 ? 2 * this.numnod + this.numlastres + this.numlin : 2 * this.numnod + this.numlastres);
        double ueb = 0.0;
        double res = 0.0;
        double z = 0.0;
        double reac = 0.0;
        double yy = 0.0;
        double y1 = 0.0;
        double y2 = 0.0;
        double b = 0.0;
        boolean i = false;
        boolean j = false;
        int ix = 0;
        int count = 0;
        boolean count1 = false;
        int count2 = 0;
        boolean count3 = false;
        int count4 = 0;
        int con1 = 10000;
        int con2 = 10000;
        int con3 = 10000;
        int auxoff = 2 * this.numgen + 2 * this.numlast;
        boolean c = false;
        double refdelta = 0.0;
        double lloss = 0.0;
        int nodo = 0;
        boolean linea = false;
        boolean trans = false;
        boolean carga = false;
        int rama = 0;
        int trafas = 0;
        this.totgen = 0.0;
        this.totgenQ = 0.0;
        this.totdem = 0.0;
        this.totdemQ = 0.0;
        int potas = 0;
        for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
            double q21;
            double p21;
            double q12;
            double p12;
            ndb_branch TempBran;
            comp TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
            if (!TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice()) continue;
            if (TempComponent instanceof Load) {
                Load TempLoad = (Load)TempComponent;
                double au1 = this.vec_xtempabs[2 * this.numgen + count2] * this.sref;
                double au2 = this.vec_xtempabs[2 * this.numgen + this.numlast + count2] * this.sref;
                if (Math.abs(au1) < 0.001) {
                    TempLoad.setunser_p(0.0);
                } else {
                    TempLoad.setunser_p(au1);
                }
                if (Math.abs(au2) < 0.001) {
                    TempLoad.setunser_q(0.0);
                } else {
                    TempLoad.setunser_q(au2);
                }
                this.totdem += TempLoad.getp0();
                this.totdemQ += TempLoad.getq0();
                this.totunserP += this.vec_xtempabs[2 * this.numgen + count2] * this.sref;
                this.totunserQ += this.vec_xtempabs[2 * this.numgen + this.numlast + count2] * this.sref;
                ++count2;
            }
            if (TempComponent instanceof ndb_inj) {
                ndb_inj TempInj = (ndb_inj)TempComponent;
                if (Math.abs(this.vec_xtempabs[potas] * this.sref) < 0.001) {
                    TempInj.setp(0.0);
                } else {
                    TempInj.setp(this.vec_xtempabs[potas] * this.sref);
                }
                if (Math.abs(this.vec_xtempabs[potas + this.numgen] * this.sref) < 0.001) {
                    TempInj.setq(0.0);
                } else {
                    TempInj.setq(this.vec_xtempabs[potas + this.numgen] * this.sref);
                }
                this.totgen += this.vec_xtempabs[potas] * this.sref;
                this.totgenQ += this.vec_xtempabs[potas + this.numgen] * this.sref;
                ++potas;
            }
            if (TempComponent instanceof Busbar) {
                int iy;
                Busbar TempBusbar = (Busbar)TempComponent;
                TempBusbar.setun2(this.vec_xtempabs[2 * this.numgen + 2 * this.numlast + nodo] * TempBusbar.getun1());
                double angulin = this.vec_xtempabs[2 * this.numgen + 2 * this.numlast + this.numnod + nodo] * 180.0 / Math.PI;
                if (Math.abs(angulin) > 0.001) {
                    TempBusbar.setdelta2(angulin);
                } else {
                    TempBusbar.setdelta2(0.0);
                }
                double spotin = this.vec_lam[nodo] / this.sref;
                if (Math.abs(spotin) > 0.001) {
                    if (this.numupfc > 0) {
                        if (this.modop_upfc == 1 || this.modop_upfc == 2 || this.modop_upfc == 3) {
                            for (iy = 0; iy < this.numupfc; ++iy) {
                                if (this.TOupfc[iy][1] == nodo) continue;
                                TempBusbar.setspot_p(spotin);
                            }
                        } else {
                            TempBusbar.setspot_p(spotin);
                        }
                    } else {
                        TempBusbar.setspot_p(spotin);
                    }
                } else {
                    TempBusbar.setspot_p(0.0);
                }
                spotin = this.vec_lam[this.numnod + nodo] / this.sref;
                if (Math.abs(spotin) > 0.001) {
                    if (this.numupfc > 0) {
                        for (iy = 0; iy < this.numupfc; ++iy) {
                            if (this.TOupfc[iy][1] == nodo) continue;
                            TempBusbar.setspot_q(spotin);
                        }
                    } else {
                        TempBusbar.setspot_q(spotin);
                    }
                } else {
                    TempBusbar.setspot_q(0.0);
                }
                ++nodo;
            }
            if (!(TempComponent instanceof ndb_branch) || (con1 = this.numbus((TempBran = (ndb_branch)TempComponent).getcon1())) <= -1 || (con2 = this.numbus(TempBran.getcon2())) <= -1) continue;
            ybr.re = this.BranchR[count];
            ybr.im = this.BranchX[count];
            ybr = Complex.divide((Complex)new Complex(1.0, 0.0), (Complex)ybr);
            ysh2.re = 0.0;
            ysh1.re = 0.0;
            ysh1.im = ysh2.im = this.BranchB[count];
            ybr12 = ybr21 = ybr;
            if (TempBran instanceof Trafo) {
                Trafo TempTrafo = (Trafo)TempBran;
                if (this.isTapOptVariable) {
                    TempTrafo.sett_re(1.0 / this.vec_xtempabs[2 * this.numgen + 2 * this.numlast + 2 * this.numnod + trafas]);
                }
                if (TempTrafo.gett_im() == 0.0) {
                    ysh2.add(Complex.multiply((Complex)ybr, (double)(1.0 - 1.0 / TempTrafo.gett_re())));
                    ysh1.add(Complex.multiply((Complex)ybr, (double)(1.0 - TempTrafo.gett_re())));
                    ysh1.divide(TempTrafo.gett_re() * TempTrafo.gett_re());
                    ybr = Complex.divide((Complex)ybr, (double)TempTrafo.gett_re());
                } else {
                    timag = TempTrafo.gett_im() * Math.PI / 180.0;
                    ctimag = new Complex(Math.cos(timag), Math.sin(timag));
                    ysh2.add(Complex.multiply((Complex)ybr, (Complex)Complex.subtract((Complex)unidad, (Complex)Complex.divide((Complex)unidad, (Complex)ctimag))));
                    ysh1.add(Complex.multiply((Complex)ybr, (Complex)Complex.subtract((Complex)unidad, (Complex)ctimag)));
                    ybr12 = Complex.divide((Complex)ybr12, (Complex)Complex.conjugate((Complex)ctimag));
                    ybr21 = Complex.divide((Complex)ybr21, (Complex)ctimag);
                    avisador = 1.0;
                }
                ++trafas;
            }
            if (TempBran instanceof Upfc) {
                Upfc TempUpfc = (Upfc)TempBran;
                ysh2.im = 0.0;
                rserie = this.PARupfc[count4][0];
                xserie = this.PARupfc[count4][1];
                gshunt = this.PARupfc[count4][2];
                bshunt = this.PARupfc[count4][3];
                VbMax = this.PARupfc[count4][4];
                VeMax = this.PARupfc[count4][5];
                row = this.TOupfc[count4][0];
                col = this.TOupfc[count4][1];
                Complex auxc1 = new Complex(rserie, xserie);
                Complex auxc2 = new Complex(1.0);
                auxc1 = Complex.divide((Complex)auxc2, (Complex)auxc1);
                auxc2 = new Complex(0.0, bshunt);
                ybb = Complex.abs((Complex)auxc1);
                tbb = Complex.argument((Complex)auxc1);
                yee = Complex.abs((Complex)auxc2);
                tee = Complex.argument((Complex)auxc2);
                Pfe = this.vec_xtempabs[offdos + count4];
                Qe = this.vec_xtempabs[offdos + this.numupfc + count4];
                Qb = this.vec_xtempabs[offdos + 2 * this.numupfc + count4];
                vnexc = this.vec_xtempabs[off + row];
                vnboost = this.vec_xtempabs[off + col];
                thexc = this.vec_xtempabs[off + this.numnod + row];
                thboost = this.vec_xtempabs[off + this.numnod + col];
                delta = thexc - thboost;
                alfa = vnboost / vnexc;
                vef = -(Qb * Math.cos(delta) - Pfe * Math.sin(delta) + alfa * Qe) / (vnboost * yee);
                veq = (Qb * Math.sin(delta) - Pfe * (alfa - Math.cos(delta))) / (vnboost * yee);
                vbf = -Qb / (vnboost * ybb);
                vbq = Pfe / (vnboost * ybb);
                if (this.isTapOptVariable) {
                    TempUpfc.setboostv(Math.sqrt(vbf * vbf + vbq * vbq) * TempUpfc.getun1());
                    TempUpfc.setexcv(Math.sqrt(vef * vef + veq * veq) * TempUpfc.getun1());
                    if (vbf > 0.0) {
                        TempUpfc.setboostang((Math.atan(vbq / vbf) + thboost - tbb - 1.5707963267948966) * 57.29577951308232);
                    } else {
                        TempUpfc.setboostang((Math.atan(vbq / vbf) + thboost + Math.PI - tbb - 1.5707963267948966) * 57.29577951308232);
                    }
                    if (vef > 0.0) {
                        TempUpfc.setexcang((Math.atan(veq / vef) + thexc - tee - 1.5707963267948966) * 57.29577951308232);
                    } else {
                        TempUpfc.setexcang((Math.atan(veq / vef) + thexc + Math.PI - tee - 1.5707963267948966) * 57.29577951308232);
                    }
                    TempUpfc.setpfinj(this.vec_xtempabs[auxoff + 2 * this.numnod + this.numtran + count4] * this.sref);
                    TempUpfc.setqeinj(this.vec_xtempabs[auxoff + 2 * this.numnod + this.numtran + this.numupfc + count4] * this.sref);
                    TempUpfc.setqbinj(this.vec_xtempabs[auxoff + 2 * this.numnod + this.numtran + 2 * this.numupfc + count4] * this.sref);
                } else {
                    TempUpfc.setboostv(Math.sqrt(vbf * vbf + vbq * vbq) * TempUpfc.getun1());
                    TempUpfc.setexcv(Math.sqrt(vef * vef + veq * veq) * TempUpfc.getun1());
                    if (vbf > 0.0) {
                        TempUpfc.setboostang((Math.atan(vbq / vbf) + thboost - tbb - 1.5707963267948966) * 57.29577951308232);
                    } else {
                        TempUpfc.setboostang((Math.atan(vbq / vbf) + thboost + Math.PI - tbb - 1.5707963267948966) * 57.29577951308232);
                    }
                    if (vef > 0.0) {
                        TempUpfc.setexcang((Math.atan(veq / vef) + thexc - tee - 1.5707963267948966) * 57.29577951308232);
                    } else {
                        TempUpfc.setexcang((Math.atan(veq / vef) + thexc + Math.PI - tee - 1.5707963267948966) * 57.29577951308232);
                    }
                    TempUpfc.setpfinj(this.vec_xtempabs[auxoff + 2 * this.numnod + count4] * this.sref);
                    TempUpfc.setqeinj(this.vec_xtempabs[auxoff + 2 * this.numnod + this.numupfc + count4] * this.sref);
                    TempUpfc.setqbinj(this.vec_xtempabs[auxoff + 2 * this.numnod + 2 * this.numupfc + count4] * this.sref);
                }
                if (this.upfcres && (this.modop_upfc == 1 || this.modop_upfc == 2 || this.modop_upfc == 3)) {
                    double spotp_upfc = this.vec_lam[2 * this.numnod + this.numlastres + this.lr + 2 * this.numupfc + count4] / this.sref;
                    double spotp_bus = this.vec_lam[col] / this.sref;
                    double spotq_bus = this.vec_lam[col + this.numnod] / this.sref;
                    ((Busbar)this.BusbarVectorI.elementAt(col)).setspot_p(spotp_upfc + spotp_bus);
                    if (this.modop_upfc != 3) {
                        double spotq_upfc = this.vec_lam[2 * this.numnod + this.numlastres + this.lr + 3 * this.numupfc + count4] / this.sref;
                        ((Busbar)this.BusbarVectorI.elementAt(col)).setspot_q(spotq_upfc + spotq_bus);
                    }
                }
            }
            if (!(TempBran instanceof ThreeWindingTrafo)) {
                v1.re = this.vec_xtempabs[auxoff + con1] * Math.cos(this.vec_xtempabs[auxoff + this.numnod + con1]);
                v1.im = this.vec_xtempabs[auxoff + con1] * Math.sin(this.vec_xtempabs[auxoff + this.numnod + con1]);
                v2.re = this.vec_xtempabs[auxoff + con2] * Math.cos(this.vec_xtempabs[auxoff + this.numnod + con2]);
                v2.im = this.vec_xtempabs[auxoff + con2] * Math.sin(this.vec_xtempabs[auxoff + this.numnod + con2]);
                if (!(TempBran instanceof Trafo)) {
                    s1 = Complex.multiply((Complex)v1, (Complex)Complex.conjugate((Complex)Complex.multiply((Complex)v1, (Complex)ysh1)));
                    s2 = Complex.multiply((Complex)v2, (Complex)Complex.conjugate((Complex)Complex.multiply((Complex)v2, (Complex)ysh2)));
                    s12 = Complex.multiply((Complex)v1, (Complex)Complex.conjugate((Complex)Complex.multiply((Complex)Complex.subtract((Complex)v1, (Complex)v2), (Complex)ybr)));
                    s21 = Complex.multiply((Complex)v2, (Complex)Complex.conjugate((Complex)Complex.multiply((Complex)Complex.subtract((Complex)v2, (Complex)v1), (Complex)ybr)));
                }
                if (TempBran instanceof Trafo) {
                    s1 = Complex.multiply((Complex)v1, (Complex)Complex.conjugate((Complex)Complex.multiply((Complex)v1, (Complex)ysh1)));
                    s2 = Complex.multiply((Complex)v2, (Complex)Complex.conjugate((Complex)Complex.multiply((Complex)v2, (Complex)ysh2)));
                    if (avisador == 0.0) {
                        s12 = Complex.multiply((Complex)v1, (Complex)Complex.conjugate((Complex)Complex.multiply((Complex)Complex.subtract((Complex)v1, (Complex)v2), (Complex)ybr)));
                        s21 = Complex.multiply((Complex)v2, (Complex)Complex.conjugate((Complex)Complex.multiply((Complex)Complex.subtract((Complex)v2, (Complex)v1), (Complex)ybr)));
                    } else if (avisador == 1.0) {
                        s12 = Complex.multiply((Complex)v1, (Complex)Complex.conjugate((Complex)Complex.multiply((Complex)Complex.subtract((Complex)v1, (Complex)v2), (Complex)ybr12)));
                        s21 = Complex.multiply((Complex)v2, (Complex)Complex.conjugate((Complex)Complex.multiply((Complex)Complex.subtract((Complex)v2, (Complex)v1), (Complex)ybr21)));
                        avisador = 0.0;
                    }
                }
                p12 = (double)Math.round((s1.re + s12.re) * 10000.0) / 10000.0;
                q12 = (double)Math.round((s1.im + s12.im) * 10000.0) / 10000.0;
                p21 = (double)Math.round((s2.re + s21.re) * 10000.0) / 10000.0;
                q21 = (double)Math.round((s2.im + s21.im) * 10000.0) / 10000.0;
                TempBran.setp12(p12);
                TempBran.setq12(q12);
                TempBran.setp21(p21);
                TempBran.setq21(q21);
                TempBran.setu1(this.vec_xtempabs[auxoff + con1] * TempBran.getun1());
                TempBran.setdelta2(this.vec_xtempabs[auxoff + this.numnod + con1] * 57.29577951308232);
                TempBran.setu2(this.vec_xtempabs[auxoff + con2] * TempBran.getun2());
                TempBran.setdelta3(this.vec_xtempabs[auxoff + this.numnod + con2] * 57.29577951308232);
            }
            if (TempBran instanceof ThreeWindingTrafo) {
                con3 = this.numbus(TempBran.getcon3());
                ThreeWindingTrafo TempThreeWindingTrafo = (ThreeWindingTrafo)TempBran;
                ++rama;
                v1.re = this.vec_xtempabs[auxoff + con1] * Math.cos(this.vec_xtempabs[auxoff + this.numnod + con1]);
                v1.im = this.vec_xtempabs[auxoff + con1] * Math.sin(this.vec_xtempabs[auxoff + this.numnod + con1]);
                v2.re = this.vec_xtempabs[auxoff + con2] * Math.cos(this.vec_xtempabs[auxoff + this.numnod + con2]);
                v2.im = this.vec_xtempabs[auxoff + con2] * Math.sin(this.vec_xtempabs[auxoff + this.numnod + con2]);
                v3.re = this.vec_xtempabs[auxoff + con3] * Math.cos(this.vec_xtempabs[auxoff + this.numnod + con3]);
                v3.im = this.vec_xtempabs[auxoff + con3] * Math.sin(this.vec_xtempabs[auxoff + this.numnod + con3]);
                TempThreeWindingTrafo.setu1(this.vec_xtempabs[auxoff + con1] * TempThreeWindingTrafo.getun1());
                TempThreeWindingTrafo.setu2(this.vec_xtempabs[auxoff + con2] * TempThreeWindingTrafo.getun2());
                TempThreeWindingTrafo.setu3(this.vec_xtempabs[auxoff + con3] * TempThreeWindingTrafo.getun3());
                if (this.isTapOptVariable) {
                    TempThreeWindingTrafo.sett_re(1.0 / this.vec_xtempabs[2 * this.numgen + 2 * this.numlast + 2 * this.numnod + trafas]);
                    TempThreeWindingTrafo.sett_re1(1.0 / this.vec_xtempabs[2 * this.numgen + 2 * this.numlast + 2 * this.numnod + trafas + 1]);
                    TempThreeWindingTrafo.sett_re2(1.0 / this.vec_xtempabs[2 * this.numgen + 2 * this.numlast + 2 * this.numnod + trafas + 2]);
                }
                tapchange1 = Complex.divide((Complex)new Complex(1.0, 0.0), (Complex)new Complex(TempThreeWindingTrafo.gett_re(), 0.0));
                tapchange2 = Complex.divide((Complex)new Complex(1.0, 0.0), (Complex)new Complex(TempThreeWindingTrafo.gett_re1(), 0.0));
                tapchange3 = Complex.divide((Complex)new Complex(1.0, 0.0), (Complex)new Complex(TempThreeWindingTrafo.gett_re2(), 0.0));
                ramashunt = new Complex(0.0, this.BranchB[count]);
                auxramay12 = new Complex(this.BranchR[count], this.BranchX[count]);
                auxramay13 = new Complex(this.BranchR[count + 1], this.BranchX[count + 1]);
                auxramay23 = new Complex(this.BranchR[count + 2], this.BranchX[count + 2]);
                cY12 = new Complex(Complex.divide((Complex)unidad, (Complex)auxramay12));
                cY13 = new Complex(Complex.divide((Complex)unidad, (Complex)auxramay13));
                cY23 = new Complex(Complex.divide((Complex)unidad, (Complex)auxramay23));
                sumY1 = Complex.add((Complex)cY12, (Complex)cY13);
                sumY2 = Complex.add((Complex)cY12, (Complex)cY23);
                sumY3 = Complex.add((Complex)cY13, (Complex)cY23);
                if (TempThreeWindingTrafo.getlado() == "HV") {
                    sumY1 = Complex.add((Complex)sumY1, (Complex)ramashunt);
                } else if (TempThreeWindingTrafo.getlado() == "MV") {
                    sumY2 = Complex.add((Complex)sumY2, (Complex)ramashunt);
                } else if (TempThreeWindingTrafo.getlado() == "LV") {
                    sumY3 = Complex.add((Complex)sumY3, (Complex)ramashunt);
                }
                cY12 = Complex.negate((Complex)Complex.multiply((Complex)cY12, (Complex)Complex.multiply((Complex)tapchange1, (Complex)tapchange2)));
                cY13 = Complex.negate((Complex)Complex.multiply((Complex)cY13, (Complex)Complex.multiply((Complex)tapchange1, (Complex)tapchange3)));
                cY23 = Complex.negate((Complex)Complex.multiply((Complex)cY23, (Complex)Complex.multiply((Complex)tapchange2, (Complex)tapchange3)));
                sumY1 = Complex.multiply((Complex)sumY1, (Complex)Complex.multiply((Complex)tapchange1, (Complex)tapchange1));
                sumY2 = Complex.multiply((Complex)sumY2, (Complex)Complex.multiply((Complex)tapchange2, (Complex)tapchange2));
                sumY3 = Complex.multiply((Complex)sumY3, (Complex)Complex.multiply((Complex)tapchange3, (Complex)tapchange3));
                factor1 = Complex.add((Complex)sumY1, (Complex)Complex.add((Complex)cY12, (Complex)cY13));
                factor2 = Complex.add((Complex)sumY2, (Complex)Complex.add((Complex)cY12, (Complex)cY23));
                factor3 = Complex.add((Complex)sumY3, (Complex)Complex.add((Complex)cY13, (Complex)cY23));
                s1 = Complex.multiply((Complex)v1, (Complex)Complex.conjugate((Complex)Complex.multiply((Complex)v1, (Complex)factor1)));
                s2 = Complex.multiply((Complex)v2, (Complex)Complex.conjugate((Complex)Complex.multiply((Complex)v2, (Complex)factor2)));
                Complex s3 = Complex.multiply((Complex)v3, (Complex)Complex.conjugate((Complex)Complex.multiply((Complex)v3, (Complex)factor3)));
                s12 = Complex.multiply((Complex)v1, (Complex)Complex.conjugate((Complex)Complex.multiply((Complex)Complex.subtract((Complex)v1, (Complex)v2), (Complex)Complex.negate((Complex)cY12))));
                s21 = Complex.multiply((Complex)v2, (Complex)Complex.conjugate((Complex)Complex.multiply((Complex)Complex.subtract((Complex)v2, (Complex)v1), (Complex)Complex.negate((Complex)cY12))));
                Complex s13 = Complex.multiply((Complex)v1, (Complex)Complex.conjugate((Complex)Complex.multiply((Complex)Complex.subtract((Complex)v1, (Complex)v3), (Complex)Complex.negate((Complex)cY13))));
                Complex s31 = Complex.multiply((Complex)v3, (Complex)Complex.conjugate((Complex)Complex.multiply((Complex)Complex.subtract((Complex)v3, (Complex)v1), (Complex)Complex.negate((Complex)cY13))));
                Complex s23 = Complex.multiply((Complex)v2, (Complex)Complex.conjugate((Complex)Complex.multiply((Complex)Complex.subtract((Complex)v2, (Complex)v3), (Complex)Complex.negate((Complex)cY23))));
                Complex s32 = Complex.multiply((Complex)v3, (Complex)Complex.conjugate((Complex)Complex.multiply((Complex)Complex.subtract((Complex)v3, (Complex)v2), (Complex)Complex.negate((Complex)cY23))));
                p12 = (double)Math.round((s1.re / 2.0 + s12.re) * 10000.0) / 10000.0;
                q12 = (double)Math.round((s1.im / 2.0 + s12.im) * 10000.0) / 10000.0;
                p21 = (double)Math.round((s2.re / 2.0 + s21.re) * 10000.0) / 10000.0;
                q21 = (double)Math.round((s2.im / 2.0 + s21.im) * 10000.0) / 10000.0;
                double p13 = (double)Math.round((s1.re / 2.0 + s13.re) * 10000.0) / 10000.0;
                double q13 = (double)Math.round((s1.im / 2.0 + s13.im) * 10000.0) / 10000.0;
                double p31 = (double)Math.round((s3.re / 2.0 + s31.re) * 10000.0) / 10000.0;
                double q31 = (double)Math.round((s3.im / 2.0 + s31.im) * 10000.0) / 10000.0;
                double p23 = (double)Math.round((s2.re / 2.0 + s23.re) * 10000.0) / 10000.0;
                double q23 = (double)Math.round((s2.im / 2.0 + s23.im) * 10000.0) / 10000.0;
                double p32 = (double)Math.round((s3.re / 2.0 + s32.re) * 10000.0) / 10000.0;
                double q32 = (double)Math.round((s3.im / 2.0 + s32.im) * 10000.0) / 10000.0;
                TempBran.setp12(p12);
                TempBran.setq12(q12);
                TempBran.setp21(p21);
                TempBran.setq21(q21);
                TempBran.setp13(p13);
                TempBran.setq13(q13);
                TempBran.setp31(p31);
                TempBran.setq31(q31);
                TempBran.setp23(p23);
                TempBran.setq23(q23);
                TempBran.setp32(p32);
                TempBran.setq32(q32);
                count += 2;
                trafas += 2;
                con3 = 10000;
            }
            ++count;
        }
    }

    public void setParameters(String solver, String iteras, String tolera1, String tolera2, boolean tapa, int lin, String scale, int upfc_mode, double ang, double ratio) {
        if (solver == "Minos            ") {
            this.metodo = 1;
        }
        if (solver == "Zoutendijk       ") {
            this.metodo = 2;
        }
        if (solver == "Rosen            ") {
            this.metodo = 1;
        }
        if (iteras == "5                ") {
            this.iteraciones = 5;
        }
        if (iteras == "6                ") {
            this.iteraciones = 6;
        }
        if (iteras == "7                ") {
            this.iteraciones = 7;
        }
        if (iteras == "8                ") {
            this.iteraciones = 8;
        }
        if (iteras == "9                ") {
            this.iteraciones = 9;
        }
        if (iteras == "10               ") {
            this.iteraciones = 10;
        }
        if (iteras == "15               ") {
            this.iteraciones = 15;
        }
        if (iteras == "20               ") {
            this.iteraciones = 20;
        }
        if (iteras == "25               ") {
            this.iteraciones = 25;
        }
        if (iteras == "30               ") {
            this.iteraciones = 30;
        }
        if (iteras == "60               ") {
            this.iteraciones = 60;
        }
        if (iteras == "100              ") {
            this.iteraciones = 100;
        }
        if (tolera1 == "0.5          ") {
            this.tolfeas = 0.5;
        }
        if (tolera1 == "0.0001       ") {
            this.tolfeas = 1.0E-4;
        }
        if (tolera1 == "0.001        ") {
            this.tolfeas = 0.001;
        }
        if (tolera1 == "0.01         ") {
            this.tolfeas = 0.01;
        }
        if (tolera1 == "0.1          ") {
            this.tolfeas = 0.1;
        }
        if (tolera1 == "1            ") {
            this.tolfeas = 1.0;
        }
        if (tolera1 == "5            ") {
            this.tolfeas = 5.0;
        }
        if (tolera1 == "10           ") {
            this.tolfeas = 10.0;
        }
        if (tolera2 == "0.001        ") {
            this.tolcost = 0.001;
        }
        if (tolera2 == "0.005        ") {
            this.tolcost = 0.005;
        }
        if (tolera2 == "0.01         ") {
            this.tolcost = 0.01;
        }
        if (tolera2 == "0.05         ") {
            this.tolcost = 0.05;
        }
        if (tolera2 == "0.1          ") {
            this.tolcost = 0.1;
        }
        if (tolera2 == "1            ") {
            this.tolcost = 1.0;
        }
        if (tolera2 == "2            ") {
            this.tolcost = 2.0;
        }
        if (scale == "1            ") {
            this.escala = 1.0;
        }
        if (scale == "0.9          ") {
            this.escala = 0.9;
        }
        if (scale == "0.8          ") {
            this.escala = 0.8;
        }
        if (scale == "0.7          ") {
            this.escala = 0.7;
        }
        if (scale == "0.6          ") {
            this.escala = 0.6;
        }
        if (scale == "0.5          ") {
            this.escala = 0.5;
        }
        this.isTapOptVariable = tapa;
        this.linres = lin == 1 ? 1 : (lin == 2 ? 2 : 3);
        if (upfc_mode != 0) {
            this.modop_upfc = upfc_mode;
            this.upfcres = true;
        } else {
            this.upfcres = false;
        }
        this.ang_desfase = ang;
        this.mod_T = ratio;
    }

    public void IdidntRealize() {
        this.MyOPFFrame = null;
        this.MatY = null;
        this.MatYact = null;
        this.MatYSinTap = null;
        this.MatYSinTrafo = null;
        this.BranchR = null;
        this.BranchX = null;
        this.BranchB = null;
        this.BranchI = null;
        this.BranchJ = null;
        this.VarNode = null;
        this.ResLast = null;
        this.Pesp = null;
        this.Qesp = null;
        this.Vesp = null;
        this.TOupfc = null;
        this.PARupfc = null;
        this.vec_xminabs = null;
        this.vec_xmaxabs = null;
        this.vec_xmin = null;
        this.vec_xmax = null;
        this.vec_xtemp = null;
        this.vec_xtempabs = null;
        this.vec_xant = null;
        this.vec_c = null;
        this.vec_RHS = null;
        this.vec_OBJ = null;
        this.vec_pf = null;
        this.vec_lam = null;
        this.DiagMat_Q = null;
        this.node_p = null;
        this.node_q = null;
        this.penalty = null;
        this.vec_clave = null;
        this.mat_W = null;
        this.mat_A = null;
    }

    public void update_UPFC_limits() {
        int i = 0;
        int k = 0;
        int off = 0;
        int offdos = 0;
        int onn = 0;
        double rserie = 0.0;
        double xserie = 0.0;
        double gshunt = 0.0;
        double bshunt = 0.0;
        double vboost = 0.0;
        double beta = 0.0;
        double vexc = 0.0;
        double epsilon = 0.0;
        double Pfe = 0.0;
        double Qe = 0.0;
        double Qb = 0.0;
        double VeMax = 0.0;
        double VbMax = 0.0;
        double alfa = 0.0;
        double delta = 0.0;
        double vnexc = 0.0;
        double vnboost = 0.0;
        double thexc = 0.0;
        double thboost = 0.0;
        if (this.numupfc > 0) {
            off = 2 * this.numgen + 2 * this.numlast;
            offdos = this.isTapOptVariable ? 2 * this.numgen + 2 * this.numlast + 2 * this.numnod + this.numtran : 2 * this.numgen + 2 * this.numlast + 2 * this.numnod;
            if (this.linres == 1) {
                onn = 2 * this.numnod + this.numlastres + 2 * this.numlin;
            } else if (this.linres == 2) {
                onn = 2 * this.numnod + this.numlastres + this.numlin;
            } else if (this.linres == 3) {
                onn = 2 * this.numnod + this.numlastres;
            }
            for (i = 0; i < this.numnod; ++i) {
                for (k = 0; k < this.numupfc; ++k) {
                    if (this.TOupfc[k][0] != i) continue;
                    rserie = this.PARupfc[k][0];
                    xserie = this.PARupfc[k][1];
                    gshunt = this.PARupfc[k][2];
                    bshunt = this.PARupfc[k][3];
                    VbMax = this.PARupfc[k][4];
                    VeMax = this.PARupfc[k][5];
                    int row = this.TOupfc[k][0];
                    int col = this.TOupfc[k][1];
                    Complex auxc1 = new Complex(rserie, xserie);
                    Complex auxc2 = new Complex(1.0);
                    auxc1 = Complex.divide((Complex)auxc2, (Complex)auxc1);
                    auxc2 = new Complex(0.0, bshunt);
                    double ybb = Complex.abs((Complex)auxc1);
                    double tbb = Complex.argument((Complex)auxc1);
                    double yee = Complex.abs((Complex)auxc2);
                    double tee = Complex.argument((Complex)auxc2);
                    Pfe = this.vec_xtempabs[offdos + k];
                    Qe = this.vec_xtempabs[offdos + this.numupfc + k];
                    Qb = this.vec_xtempabs[offdos + 2 * this.numupfc + k];
                    vnexc = this.vec_xtempabs[off + row];
                    vnboost = this.vec_xtempabs[off + col];
                    thexc = this.vec_xtempabs[off + this.numnod + row];
                    thboost = this.vec_xtempabs[off + this.numnod + col];
                    delta = thexc - thboost;
                    alfa = vnboost / vnexc;
                    this.vec_xmaxabs[offdos + k] = vnboost * VbMax * ybb;
                    this.vec_xminabs[offdos + k] = -vnboost * VbMax * ybb;
                    if (this.vec_xmaxabs[offdos + k] - Math.abs(Pfe) > 0.0) {
                        this.vec_xminabs[2 * this.numupfc + offdos + k] = -Math.sqrt(this.vec_xmaxabs[offdos + k] * this.vec_xmaxabs[offdos + k] - Pfe * Pfe);
                        this.vec_xmaxabs[2 * this.numupfc + offdos + k] = Math.sqrt(this.vec_xmaxabs[offdos + k] * this.vec_xmaxabs[offdos + k] - Pfe * Pfe);
                    } else {
                        this.vec_xminabs[2 * this.numupfc + offdos + k] = 0.0;
                        this.vec_xmaxabs[2 * this.numupfc + offdos + k] = 0.0;
                    }
                    if (VeMax * vnexc * yee * (VeMax * vnexc * yee) - (Pfe * (alfa - Math.cos(delta)) - Qb * Math.sin(delta)) * (Pfe * (alfa - Math.cos(delta)) - Qb * Math.sin(delta)) > 0.0) {
                        this.vec_xmaxabs[this.numupfc + offdos + k] = (Pfe * Math.sin(delta) - Qb * Math.cos(delta) + Math.sqrt(VeMax * vnexc * yee * (VeMax * vnexc * yee) - (Pfe * (alfa - Math.cos(delta)) - Qb * Math.sin(delta)) * (Pfe * (alfa - Math.cos(delta)) - Qb * Math.sin(delta)))) / alfa;
                        this.vec_xminabs[this.numupfc + offdos + k] = (Pfe * Math.sin(delta) - Qb * Math.cos(delta) - Math.sqrt(VeMax * vnexc * yee * (VeMax * vnexc * yee) - (Pfe * (alfa - Math.cos(delta)) - Qb * Math.sin(delta)) * (Pfe * (alfa - Math.cos(delta)) - Qb * Math.sin(delta)))) / alfa;
                        continue;
                    }
                    this.vec_xmaxabs[this.numupfc + offdos + k] = 0.0;
                    this.vec_xminabs[this.numupfc + offdos + k] = 0.0;
                }
            }
        }
    }
}

