/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import com.objectplanet.chart.LineChart;
import de.core.AnalysisTool;
import de.core.CvaLinPartes;
import de.core.DeepEdit;
import de.core.DeepEditFrame;
import de.core.MTOSException;
import de.core.MTOSFrame;
import de.core.OneStageSOptOf;
import de.core.Schematic;
import de.core.SimMDE;
import de.core.SimMDE_ptocva;
import de.core.SimMDE_taboferta;
import de.core.SimMDE_tabresultado;
import de.core.SimpleDialog;
import de.core.comp;
import de.core.hdb_affl;
import de.core.hdb_link;
import de.core.hdb_res;
import de.core.hdb_ser;
import de.core.hdb_unit;
import de.core.mdb_sup;
import java.awt.Frame;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Random;
import java.util.Vector;

public class MTOS
extends AnalysisTool {
    MTOSFrame MyMTOSFrame = null;
    public int begY = 0;
    public int endY = 0;
    public int begM = 0;
    public int endM = 0;
    public int NumSimulations = 0;
    public boolean YesCharts = false;
    protected Vector contracts;
    FileOutputStream os;
    String FileName = "./results/MTOS.dat";
    PrintWriter myPrintStream;
    comp TempComponent;
    DeepEdit applet;
    String errmsg;
    mdb_sup Supplier;
    String SupplierName = "";
    OneStageSOptOf SupOptClass;
    int connum = 0;
    public double annualDR = 10.0;
    public double stageDR = 8.29538114346162E-4;
    public static String[] monthNames = new String[]{"JAN", "FEB", "MAR", "APR", "MAY", "JUN", "JUL", "AUG", "SEP", "OCT", "NOV", "DEC"};
    private double[][][] qAff;
    private double[][] exPrices;
    private CvaLinPartes[] suppEFB;
    private hdb_affl[] supAff = null;
    private hdb_res[] supRes;
    private double supRCapa = 0.0;
    public int numStates = 10;
    public int numHydStat = 5;
    private double[] SuppStates;
    public int numStages;
    private int[] stagedur;
    private boolean cvasWasConstd;
    private Vector Vaff;
    private Vector Vres;
    private double[][] simStates;
    private int[][] simHydSec;
    public double iniState;
    private double[][] offerEn;
    private double[][] operNetBal;
    private Random myRandNumGen;
    private long mySeed;
    public int[] auxHSyears;
    public Frame f1;
    public Frame f2;
    public SimMDE_taboferta actOfferH;
    public SimMDE_taboferta actOfferT;
    public SimMDE_tabresultado actMResH;
    public SimMDE_tabresultado actMResT;
    private double actprice;
    private int actstage;
    private int acthydro;
    private boolean isOffDone = false;
    private boolean isHydroMarginal = false;
    private double negOpFDR = 0.0;

    public MTOS(Schematic sch, DeepEdit app) {
        super(sch);
        this.applet = app;
        this.setupRandGen(10000L);
        if (this.MyMTOSFrame == null) {
            this.MyMTOSFrame = new MTOSFrame(this);
        } else {
            this.MyMTOSFrame.setVisible(true);
        }
    }

    public MTOS(Schematic sch, DeepEdit app, String supName, int pbegM, int pbegY, int pendM, int pendY) throws Exception {
        super(sch);
        this.applet = app;
        this.SupplierName = supName;
        this.begM = pbegM;
        this.begY = pbegY;
        this.endM = pendM;
        this.endY = pendY;
        this.os = new FileOutputStream(this.FileName);
        this.myPrintStream = new PrintWriter(this.os, true);
        this.initProblem();
        this.readEFB();
        this.SupOptClass = new OneStageSOptOf(this.Supplier, this.ActSchematic, this.numStates, this.myPrintStream);
        this.actOfferH = new SimMDE_taboferta(this.SupplierName + "_Hydro", true);
        this.actOfferT = new SimMDE_taboferta(this.SupplierName + "_Thermal", true);
        this.actstage = 0;
        this.acthydro = 0;
        this.actprice = 25.0;
    }

    public void Calculate() throws Exception {
        int nummon = (this.endY - this.begY + 1) * 12 - this.begM - this.endM;
        double auxBal = 0.0;
        double minVol = 0.0;
        double auxNBDrate = 1.0;
        System.out.println("---------- MidTerm Optimal Competitive Market Started ------------");
        try {
            int ix;
            this.os = new FileOutputStream(this.FileName);
            this.myPrintStream = new PrintWriter(this.os, true);
            this.myPrintStream.println("--------------------------------------");
            this.myPrintStream.println("Deep-Edit MidTerm One Supplier Optimization");
            this.myPrintStream.println("--------------------------------------");
            this.myPrintStream.println(" ");
            this.myPrintStream.println(" ");
            this.myPrintStream.println("System Name             : " + this.ActSchematic.getsysname());
            this.myPrintStream.println("Optimization Time Horizon    : [" + this.begY + "," + this.begM + " - " + this.endY + "," + this.endM + "]");
            this.initProblem();
            if (this.supRes.length < 1) {
                MTOS.mtosWarning(DeepEdit.frame, "Supplier without reservoirs, so no EFB curves calculations needed.");
                return;
            }
            double[] expB = new double[this.numStates];
            this.SupOptClass = new OneStageSOptOf(this.Supplier, this.ActSchematic, this.numStates, this.myPrintStream);
            this.myPrintStream.println("\n-----------------------------------------------------------------");
            this.myPrintStream.println("                       Expected future benefits Curves");
            this.myPrintStream.println("                       -------------------------------");
            this.myPrintStream.print("           ");
            for (ix = 0; ix < this.numStates; ++ix) {
                this.myPrintStream.print("State" + (ix + 1) + "     ");
            }
            this.myPrintStream.print("\n           ");
            for (ix = 0; ix < this.numStates; ++ix) {
                this.myPrintStream.print(" [Mm\u00b3]     ");
            }
            this.myPrintStream.print("\n        ");
            for (ix = 0; ix < this.supRes.length; ++ix) {
                minVol += this.supRes[ix].getVmin();
            }
            for (ix = 0; ix < this.numStates; ++ix) {
                this.myPrintStream.print(MTOS.numformat(minVol + this.SuppStates[ix], 9, 1) + "  ");
            }
            this.myPrintStream.print("\n\nPeriod                         values in [MUS$]");
            this.myPrintStream.print("\n fin     ");
            this.myPrintStream.print(MTOS.numformat(this.suppEFB[this.numStages].evalIn(this.SuppStates[0]) / 1000.0, 9, 2) + "  ");
            for (ix = 1; ix < this.numStates; ++ix) {
                this.myPrintStream.print(MTOS.numformat((this.suppEFB[this.numStages].evalIn(this.SuppStates[ix]) - this.suppEFB[this.numStages].evalIn(this.SuppStates[ix - 1])) / 1000.0, 9, 2) + "  ");
            }
            if (this.suppEFB[this.numStages].checkConc()) {
                this.myPrintStream.print("   OK");
            } else {
                this.myPrintStream.print("   NO");
            }
            int mth = this.endM;
            int year = this.endY;
            for (int stage = this.numStages - 1; stage > 0; --stage) {
                System.out.println("------------  START PERIOD " + (stage + 1) + " -----------------------");
                if (mth < 1) {
                    mth = 12;
                    --year;
                }
                for (int st = 0; st < this.numStates; ++st) {
                    double sumActBal = 0.0;
                    double sumExpFB = 0.0;
                    for (int hyd = 0; hyd < this.numHydStat; ++hyd) {
                        this.actualizSchem(this.SuppStates[st], stage, hyd);
                        this.SupOptClass.constProblem(this.suppEFB[stage + 1], this.exPrices[stage][hyd], this.stagedur[stage]);
                        this.SupOptClass.solveByOpRe();
                        sumExpFB += this.SupOptClass.getFutExBen();
                        auxBal = this.getOperBalance(year, mth, this.exPrices[stage][hyd]);
                        if (auxBal < 0.0) {
                            auxNBDrate = Math.pow(1.0 + this.negOpFDR, 1 / (1 + st));
                            auxBal *= auxNBDrate;
                        }
                        sumActBal += auxBal;
                        System.out.print("*");
                    }
                    expB[st] = (sumActBal + sumExpFB) / (double)this.numHydStat / (1.0 + this.stageDR);
                    System.out.println("Problem calculation state " + (st + 1) + " finished");
                }
                this.suppEFB[stage] = new CvaLinPartes(this.SuppStates, expB);
                System.out.println("Expected Future Benefit constructed.");
                System.out.println("------------  END PERIOD " + (stage + 1) + " -----------------------");
                this.myPrintStream.print("\n" + MTOS.numformat(stage + 1, 4) + "     ");
                this.myPrintStream.print(MTOS.numformat(expB[0] / 1000.0, 9, 2) + "  ");
                for (ix = 1; ix < this.numStates; ++ix) {
                    this.myPrintStream.print(MTOS.numformat((expB[ix] - expB[ix - 1]) / 1000.0, 9, 2) + "  ");
                }
                if (this.suppEFB[stage].checkConc()) {
                    this.myPrintStream.print("   OK");
                } else {
                    this.myPrintStream.print("   NO");
                }
                this.myPrintStream.flush();
                --mth;
            }
            if (this.NumSimulations > 0) {
                this.doStalSim();
                this.myPrintStream.flush();
            } else {
                System.out.println("Execution without simulation !!");
            }
        }
        catch (Exception e) {
            String message = e.toString();
            System.out.println(e);
            String[] DlgButtons = new String[]{"OK"};
            SimpleDialog ExceptionDialog = new SimpleDialog(DeepEdit.frame, "MTOS  main", message, DlgButtons, 1, 0, 0, 1);
            return;
        }
        try {
            if (this.os != null) {
                this.os.close();
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
        if (this.FileName != null) {
            this.DoListResults(this.FileName);
        }
        this.writeDB();
        MTOS.closeMTOS();
        DeepEdit.MySchematicPanel.repaint();
        DeepEdit.frame.MyMTOS = null;
    }

    static void closeMTOS() throws SQLException {
        try {
            DeepEditFrame.conMTOS.commit();
            DeepEditFrame.conMTOS.close();
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    private void initProblem() throws Exception {
        int jx;
        int ix;
        comp tempcomp = null;
        hdb_link templink = null;
        hdb_unit tempHUnit = null;
        hdb_ser tempSer = null;
        Object tempIrr = null;
        mdb_sup tempSup = null;
        hdb_affl tempAff = null;
        hdb_res tempRes = null;
        boolean allok = false;
        int ixx = 0;
        boolean auxNumStages = false;
        int stcount = 0;
        this.Vaff = new Vector();
        this.Vres = new Vector();
        ixx = 0;
        allok = false;
        for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
            tempcomp = (comp)this.ActSchematic.Components.elementAt(ix);
            if (!(tempcomp instanceof mdb_sup)) continue;
            ++ixx;
            tempSup = (mdb_sup)tempcomp;
            if (!tempSup.getName().equals(this.SupplierName)) continue;
            this.Supplier = tempSup;
            System.out.println("Supplier " + this.SupplierName + " Finded.");
            allok = true;
            break;
        }
        if (!allok) {
            MTOS.mtosError("Supplier not found in schematic, " + this.SupplierName);
        }
        MTOS mTOS = this;
        mTOS.applet.SimulateSetUp();
        allok = false;
        for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
            tempcomp = (comp)this.ActSchematic.Components.elementAt(ix);
            if (!(tempcomp instanceof hdb_link)) continue;
            ++ixx;
            templink = (hdb_link)tempcomp;
            allok = templink.InformEndComponents();
            if (allok) continue;
            MTOS.mtosError("Wrongly connected link: " + templink.getName());
        }
        System.out.println("Links Initialized");
        for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
            tempcomp = (comp)this.ActSchematic.Components.elementAt(ix);
            if (!(tempcomp instanceof hdb_unit) || !(tempHUnit = (hdb_unit)tempcomp).getowner().equals(this.SupplierName)) continue;
            tempHUnit.InformRiverUpComps();
            if (tempHUnit.riverUpComps.size() == 0) {
                MTOS.mtosError("no water receiving hydro unit, " + tempHUnit.getName());
            }
            for (jx = 0; jx < tempHUnit.riverUpComps.size(); ++jx) {
                if (!(tempHUnit.riverUpComps.elementAt(jx) instanceof hdb_affl)) continue;
                tempAff = (hdb_affl)tempHUnit.riverUpComps.elementAt(jx);
                tempAff.setowner(this.SupplierName);
                this.Vaff.addElement(tempAff);
            }
            if (tempHUnit instanceof hdb_ser) {
                tempSer = (hdb_ser)tempHUnit;
                tempSer.InformRecipients();
                if (tempSer.getSpilRecComp() != null && !tempSer.getSpilRecComp().getowner().equals(this.SupplierName)) {
                    MTOS.mtosError("diferent supplier hydro units connected, " + tempSer.getName() + " and" + tempSer.getSpilRecComp().getName());
                }
                if (tempSer.getTurbRecComp() != null && !tempSer.getTurbRecComp().getowner().equals(this.SupplierName)) {
                    MTOS.mtosError("diferent supplier hydro units connected, " + tempSer.getName() + " and" + tempSer.getTurbRecComp().getName());
                }
            }
            if (!(tempHUnit instanceof hdb_res) || !(tempRes = (hdb_res)tempHUnit).getowner().equals(this.SupplierName)) continue;
            this.Vres.addElement(tempRes);
        }
        System.out.println("Num aff=" + this.Vaff.size());
        System.out.println("Num res=" + this.Vres.size());
        if (this.begY > this.endY) {
            MTOS.mtosError("years wrong period setting.");
        }
        if (this.endY == this.begY && this.begM > this.endM) {
            MTOS.mtosError("months wrong period setting.");
        }
        this.numStages = (this.endY - this.begY) * 12 + this.endM - this.begM + 1;
        this.suppEFB = new CvaLinPartes[this.numStages + 1];
        this.annualDR = this.ActSchematic.getintrate();
        this.stageDR = Math.pow(this.annualDR / 100.0 + 1.0, 0.0) - 1.0;
        this.supRes = new hdb_res[this.Vres.size()];
        this.supAff = this.Vaff.size() > 0 ? new hdb_affl[this.Vaff.size()] : null;
        for (ix = 0; ix < this.Vaff.size(); ++ix) {
            this.supAff[ix] = tempAff = (hdb_affl)this.Vaff.elementAt(ix);
        }
        this.supRCapa = 0.0;
        for (ix = 0; ix < this.Vres.size(); ++ix) {
            this.supRes[ix] = (hdb_res)this.Vres.elementAt(ix);
            this.supRCapa += this.supRes[ix].getVmax() - this.supRes[ix].getVmin();
        }
        System.out.println("hdb_units Initialized");
        try {
            int kx;
            ResultSet r;
            Statement s = DeepEditFrame.conMTOS.createStatement();
            stcount = 0;
            System.out.println("AnnualDR= " + this.annualDR);
            System.out.println("numStages= " + this.numStages);
            System.out.println("numStates= " + this.numStates);
            System.out.println("numHydroStats= " + this.numHydStat);
            if (this.supRes.length > 0) {
                int endY1;
                int endM1;
                this.SuppStates = new double[this.numStates];
                r = s.executeQuery("SELECT * FROM SupReservStates WHERE (SupplierName = '" + this.SupplierName + "')" + " ORDER BY State");
                for (stcount = 0; r.next() && stcount < this.numStates; ++stcount) {
                    this.SuppStates[stcount] = r.getDouble("Value") / 100.0 * this.supRCapa;
                }
                if (stcount < this.numStates) {
                    MTOS.mtosError("wrong reservoir states setting for " + this.SupplierName + " in MTOSDB");
                }
                System.out.println("Supplier Equivalent Reservoir States Read");
                double[] aux = new double[this.numStates];
                if (this.endM == 12) {
                    endM1 = 1;
                    endY1 = this.endY + 1;
                } else {
                    endM1 = this.endM + 1;
                    endY1 = this.endY;
                }
                r = s.executeQuery("SELECT * FROM SuplierPolcies WHERE (SupplierName = '" + this.SupplierName + "')" + " AND (Year = " + endY1 + ")" + " AND (Month = " + endM1 + ")");
                stcount = 0;
                while (r.next()) {
                    for (ix = 0; ix < this.numStates; ++ix) {
                        aux[ix] = r.getDouble("EFBvalueState" + (ix + 1));
                    }
                    ++stcount;
                }
                if (stcount == 0) {
                    MTOS.mtosError("no final EFB found, " + this.SupplierName + ", year " + endY1 + ", month " + endM1);
                }
                this.suppEFB[this.numStages] = new CvaLinPartes(this.SuppStates, aux);
                System.out.println("Final EFB Found and Read");
            }
            int auxBM = 0;
            int auxEM = 0;
            if (this.isHydraulicOwner()) {
                this.qAff = new double[this.supAff.length][this.numStages][this.numHydStat];
                this.auxHSyears = new int[this.numHydStat];
                r = s.executeQuery("SELECT * FROM AffluentCaudal WHERE (Year= " + this.begY + ")" + " AND (Affluent_Name = '" + this.supAff[0].getName() + "')" + " ORDER BY StatYear");
                for (stcount = 0; r.next() && stcount < this.numHydStat; ++stcount) {
                    this.auxHSyears[stcount] = r.getInt("StatYear");
                }
                if (stcount != this.numHydStat) {
                    MTOS.mtosError("inconsistency in number of Hydrological Statistics found in MTOSDB");
                }
                int auxstage = 0;
                for (ix = this.begY; ix <= this.endY; ++ix) {
                    for (jx = 0; jx < this.supAff.length; ++jx) {
                        r = s.executeQuery("SELECT * FROM AffluentCaudal WHERE (Year= " + ix + ")" + " AND (Affluent_Name = '" + this.supAff[jx].getName() + "')" + " ORDER BY StatYear");
                        auxBM = ix == this.begY ? this.begM : 1;
                        auxEM = ix == this.endY ? this.endM : 12;
                        stcount = 0;
                        while (r.next() && stcount < this.numHydStat) {
                            for (kx = auxBM - 1; kx < auxEM; ++kx) {
                                this.qAff[jx][auxstage][stcount] = r.getDouble(monthNames[kx]);
                                ++auxstage;
                            }
                            if (r.getInt("StatYear") != this.auxHSyears[stcount]) {
                                MTOS.mtosError("Hydro_Statistic " + this.auxHSyears[stcount] + " not found in MTOSDB for affluent " + this.supAff[ix].getName());
                            }
                            ++stcount;
                            auxstage -= auxEM - auxBM + 1;
                        }
                        if (stcount == this.numHydStat) continue;
                        MTOS.mtosError("Hydro_Statistic " + this.auxHSyears[stcount] + " not found in MTOSDB for affluent " + this.supAff[ix].getName());
                    }
                    auxstage += auxEM - auxBM + 1;
                }
                System.out.println("Hydrologies for implied affluent found and read");
            }
            this.stagedur = new int[this.numStages];
            jx = 0;
            for (ix = this.begY; ix <= this.endY; ++ix) {
                r = s.executeQuery("SELECT * FROM DurCalendar WHERE (Year = " + ix + ")");
                auxBM = ix == this.begY ? this.begM : 1;
                auxEM = ix == this.endY ? this.endM : 12;
                for (stcount = 0; r.next() && stcount <= 0; ++stcount) {
                    for (kx = auxBM - 1; kx < auxEM; ++kx) {
                        this.stagedur[jx] = r.getInt(monthNames[kx]);
                        ++jx;
                    }
                }
                if (stcount != 0) continue;
                MTOS.mtosError("no calendar found for year " + ix);
            }
            System.out.println("stages duration found and read");
            if (this.isHydraulicOwner()) {
                this.exPrices = new double[this.numStages][this.numHydStat];
                kx = 0;
                jx = 0;
                for (ix = this.begY; ix <= this.endY; ++ix) {
                    r = s.executeQuery("SELECT * FROM EnergyPrices WHERE (Year = " + ix + ")" + " ORDER BY StatHydYear");
                    auxBM = ix == this.begY ? this.begM : 1;
                    auxEM = ix == this.endY ? this.endM : 12;
                    stcount = 0;
                    while (r.next() && stcount < this.numHydStat) {
                        if (r.getInt("StatHydYear") != this.auxHSyears[stcount]) {
                            MTOS.mtosError("exPrice for hydro statistic " + this.auxHSyears[stcount] + " not found in MTOSDB for year " + ix);
                        }
                        for (kx = auxBM - 1; kx < auxEM; ++kx) {
                            this.exPrices[jx][stcount] = r.getDouble(monthNames[kx]);
                            ++jx;
                        }
                        ++stcount;
                        jx -= auxEM - auxBM + 1;
                    }
                    jx += auxEM - auxBM + 1;
                    if (stcount == this.numHydStat) continue;
                    MTOS.mtosError("no exPrices found for all hydrologies on year" + ix);
                }
                System.out.println("expected prices found and read.");
            }
        }
        catch (SQLException e) {
            System.out.println(e);
            MTOS.mtosError("invalid data on MTOSDB or bad connection to Data Base");
        }
    }

    private void actualizSchem(double iniRSt, int pstage, int hydro) {
        int ix = 0;
        for (ix = 0; ix < this.supAff.length; ++ix) {
            this.supAff[ix].setQ(this.qAff[ix][pstage][hydro]);
        }
        for (ix = 0; ix < this.supRes.length; ++ix) {
            this.supRes[ix].setSimVini(this.supRes[ix].getVmax() * iniRSt / this.supRCapa + this.supRes[ix].getVmin() * (1.0 - iniRSt / this.supRCapa));
        }
    }

    private void actualizSchemFR(int pstage, int hydro) {
        int ix = 0;
        if (!this.isHydraulicOwner()) {
            return;
        }
        for (ix = 0; ix < this.supAff.length; ++ix) {
            this.supAff[ix].setQ(this.qAff[ix][pstage][hydro]);
        }
        for (ix = 0; ix < this.supRes.length; ++ix) {
            this.supRes[ix].setSimVini(this.supRes[ix].getSimVfin());
        }
    }

    public void initSchemFR() {
        int ix = 0;
        if (this.supRes == null) {
            return;
        }
        for (ix = 0; ix < this.supRes.length; ++ix) {
            this.supRes[ix].setSimVfin(this.supRes[ix].getVini());
        }
    }

    private static void mtosError(String mensaje) throws MTOSException {
        throw new MTOSException(mensaje);
    }

    private static void mtosWarning(DeepEditFrame myframe, String mensaje) {
        String[] DlgButtons = new String[]{"OK"};
        SimpleDialog ExceptionDialog = new SimpleDialog(myframe, "MTOS  main", mensaje, DlgButtons, 1, 0, 0, 2);
    }

    void writeDB() throws Exception {
        int jx;
        int ix;
        double mayy = 0.0;
        int auxY = this.endY;
        int auxM = this.endM;
        if (auxM == 12) {
            auxM = 1;
            ++auxY;
        } else {
            ++auxM;
        }
        if (this.YesCharts) {
            for (ix = this.numStages; ix > 0; --ix) {
                mayy = Math.max(mayy, this.suppEFB[ix].getFpoint(this.numStates - 1));
            }
            LineChart chart = new LineChart(this.numStages, this.numStates, mayy);
            chart.setTitle("Expected Future Benefit Chart");
            for (ix = this.numStages; ix > 0; --ix) {
                if (auxM == 0) {
                    auxM = 12;
                    --auxY;
                }
                chart.setConnectedLinesOn(ix, true);
                chart.setSeriesLabel(ix - 1, "EFB " + monthNames[auxM - 1] + auxY);
                --auxM;
            }
            for (ix = this.numStages; ix > 0; --ix) {
                for (jx = 0; jx < this.numStates; ++jx) {
                    chart.setSampleValue(ix - 1, jx, this.suppEFB[ix].getFpoint(jx));
                }
            }
            String[] labels = new String[this.numStates];
            for (int k = 0; k < this.numStates; ++k) {
                labels[k] = "" + MTOS.numformat(this.SuppStates[k] * 100.0 / this.supRCapa, 3, 1);
            }
            chart.setSampleLabels(labels);
            chart.setTitleOn(true);
            chart.setLegendOn(true);
            chart.setValueLinesOn(true);
            chart.setRangeAdjusterOn(true);
            chart.setSampleLabelsOn(true);
            chart.setGridLinesOn(true);
            chart.setSampleScrollerOn(true);
            chart.setAutoLabelSpacingOn(true);
            chart.setLabel("State", "[%]");
            chart.setLabel("EFB", "[$]");
            this.f1 = new Frame("Expected Future Benefit Curves");
            this.f1.add("Center", chart);
            this.f1.setSize(600, 500);
            this.f1.setVisible(true);
        }
        try {
            Statement s = DeepEditFrame.conMTOS.createStatement();
            for (ix = this.begY; ix <= this.endY; ++ix) {
                int auxBM = ix == this.begY ? this.begM - 1 : 0;
                int auxEM = ix == this.endY ? this.endM + 1 : 13;
                s.executeUpdate("DELETE FROM SuplierPolcies WHERE (SupplierName = '" + this.SupplierName + "')" + " AND (Year = " + ix + ")" + " AND (Month > " + auxBM + ")" + " AND (Month < " + auxEM + ")");
            }
            System.out.println("old policies deleted.");
            auxY = this.endY;
            auxM = this.endM;
            for (ix = this.numStages - 1; ix > 0; --ix) {
                if (auxM == 0) {
                    auxM = 12;
                    --auxY;
                }
                String cols = "SupplierName, Year, Month";
                String vals = "'" + this.SupplierName + "'" + ", " + auxY + ", " + auxM;
                for (jx = 0; jx < this.numStates; ++jx) {
                    cols = cols + ", " + "EFBvalueState" + (jx + 1);
                    vals = vals + ", " + this.suppEFB[ix].getFpoint(jx);
                }
                s.executeUpdate("INSERT INTO SuplierPolcies (" + cols + ")" + " VALUES (" + vals + ")");
                --auxM;
            }
            System.out.println("new policies writed.");
            s.executeUpdate("UPDATE SimulateParam SET NumStages = " + this.numStages + ", " + " AnualDiscRate = " + this.annualDR + ", " + " NegOpPenaltyDR = " + this.negOpFDR + ", " + " StartMonth = " + this.begM + ", " + " StartYear = " + this.begY + ", " + " CvasWasConstructed = 1 " + " WHERE SupplierName = '" + this.SupplierName + "'");
            System.out.println("parameters updates.");
        }
        catch (SQLException e) {
            System.out.println(e);
            MTOS.mtosError("problems writing MTOSDB");
        }
    }

    public void doStalSim() throws Exception {
        int stage;
        int ix;
        int simcount;
        int k = 0;
        double mayy = 100.0;
        this.simHydSec = new int[this.NumSimulations][this.numStages];
        this.simStates = new double[this.NumSimulations][this.numStages];
        this.offerEn = new double[this.NumSimulations][this.numStages];
        this.operNetBal = new double[this.NumSimulations][this.numStages];
        System.out.println("\n-----------------------------------------------------------------");
        System.out.println("                       Simulation Process Running");
        System.out.println("                       --------------------------\n");
        this.myPrintStream.println("\n\n-----------------------------------------------------------------");
        this.myPrintStream.println("                         Simulation Results variables");
        this.myPrintStream.println("                       --------------[monthly]---------");
        for (simcount = 0; simcount < this.NumSimulations; ++simcount) {
            System.out.println("Simulation number " + (simcount + 1) + " calculation");
            System.out.print("*period:");
            this.initSchemFR();
            this.myPrintStream.println("\n");
            this.myPrintStream.print("**> Simulation Number: " + (simcount + 1) + ", IniResStates: ");
            for (ix = 0; ix < this.supRes.length; ++ix) {
                this.myPrintStream.print("" + this.supRes[ix].getName() + "= " + MTOS.numformat(this.supRes[ix].getVini(), 7, 2) + "[Mm\u00b3],  ");
            }
            this.myPrintStream.println();
            this.SupOptClass.writeHeadList();
            int mth = this.begM - 2;
            int year = this.begY;
            for (stage = 0; stage < this.numStages; ++stage) {
                int hyd;
                System.out.print(" " + (stage + 1));
                year = ++mth > 11 ? year + 1 : year;
                mth = mth > 11 ? 0 : mth;
                this.simHydSec[simcount][stage] = hyd = this.rand(this.numHydStat - 1);
                this.actualizSchemFR(stage, hyd);
                this.SupOptClass.constProblem(this.suppEFB[stage + 1], this.exPrices[stage][hyd], this.stagedur[stage]);
                this.SupOptClass.solveByOpRe();
                this.SupOptClass.writeResultList(this.auxHSyears[hyd], monthNames[mth] + year + "");
                this.simStates[simcount][stage] = this.SupOptClass.finalResState;
                this.operNetBal[simcount][stage] = this.getOperBalance(year, mth + 1, this.exPrices[stage][hyd]);
            }
            System.out.println("\n------ " + (simcount + 1) + " finished --------\n");
        }
        this.myPrintStream.println("\n\n-----------------------------------------------------------------");
        this.myPrintStream.println("                        Simulation EqReservoir States");
        this.myPrintStream.println("                       --------------[%]-------------");
        this.myPrintStream.print("Sim  ");
        for (stage = 0; stage < this.numStages; ++stage) {
            this.myPrintStream.print("Stage" + (stage + 1) + " ");
            if (stage >= 9) continue;
            this.myPrintStream.print(" ");
        }
        for (simcount = 0; simcount < this.NumSimulations; ++simcount) {
            this.myPrintStream.print("\n" + MTOS.numformat(simcount + 1, 3));
            for (stage = 0; stage < this.numStages; ++stage) {
                this.myPrintStream.print(MTOS.numformat(this.simStates[simcount][stage] * 100.0, 8, 2));
            }
        }
        this.myPrintStream.println("\n\n------------------- Estimated Net Stages Balances");
        this.myPrintStream.println("                       -------------[MUS$]------------");
        this.myPrintStream.print("Sim  ");
        for (stage = 0; stage < this.numStages; ++stage) {
            if (stage < 9) {
                this.myPrintStream.print(" ");
            }
            this.myPrintStream.print("Stage" + (stage + 1) + "  ");
        }
        for (simcount = 0; simcount < this.NumSimulations; ++simcount) {
            this.myPrintStream.print("\n" + MTOS.numformat(simcount + 1, 3));
            for (stage = 0; stage < this.numStages; ++stage) {
                this.myPrintStream.print(MTOS.numformat(this.operNetBal[simcount][stage] / 1000000.0, 9, 3));
            }
        }
        if (this.YesCharts) {
            LineChart chart = new LineChart(this.NumSimulations, this.numStages, mayy);
            chart.setTitle("Simulation State Trajectories");
            for (ix = 0; ix < this.NumSimulations; ++ix) {
                chart.setConnectedLinesOn(ix, true);
                chart.setSeriesLabel(ix, "Sim " + (ix + 1));
            }
            for (simcount = 0; simcount < this.NumSimulations; ++simcount) {
                for (stage = 0; stage < this.numStages; ++stage) {
                    chart.setSampleValue(simcount, stage, this.simStates[simcount][stage] * 100.0);
                }
            }
            String[] labels = new String[this.numStages];
            for (k = 0; k < this.numStages; ++k) {
                labels[k] = "" + k;
            }
            chart.setSampleLabels(labels);
            chart.setTitleOn(true);
            chart.setLegendOn(true);
            chart.setValueLinesOn(true);
            chart.setRangeAdjusterOn(true);
            chart.setSampleLabelsOn(true);
            chart.setGridLinesOn(true);
            chart.setSampleScrollerOn(true);
            chart.setAutoLabelSpacingOn(true);
            chart.setLabel("Period", "[#]");
            chart.setLabel("State", "[%]");
            this.f2 = new Frame("Simulation State Trajectories");
            this.f2.add("Center", chart);
            this.f2.setSize(300, 300);
            this.f2.pack();
            this.f2.setVisible(true);
        }
    }

    public void setupRandGen(long seed) {
        this.myRandNumGen = new Random(seed);
    }

    private int rand(int limit) {
        return (int)((double)(this.myRandNumGen.nextFloat() * (float)(limit + 1)) - 1.0E-10);
    }

    public int getNextRandHyd() {
        return this.rand(this.numHydStat - 1);
    }

    public boolean isHydraulicOwner() {
        boolean sino = false;
        if (this.supAff != null && this.supAff.length > 0) {
            sino = true;
        }
        return sino;
    }

    public void setupStepForward(int pstage, int pacthyd, double pprice) {
        this.actstage = pstage;
        this.acthydro = pacthyd;
        this.actprice = pprice;
        this.isOffDone = false;
        this.actualizSchemFR(this.actstage, this.acthydro);
    }

    private void readEFB() throws Exception {
        if (this.supRes.length < 1) {
            double[] aux = new double[]{};
            CvaLinPartes tempCva = new CvaLinPartes(aux, aux);
            for (int ix = 0; ix < this.numStages; ++ix) {
                this.suppEFB[ix] = tempCva;
            }
            return;
        }
        try {
            int aendM;
            int aendY;
            int abegM;
            int abegY;
            double[] aux = new double[this.numStates];
            Statement s = DeepEditFrame.conMTOS.createStatement();
            int stgecount = 0;
            if (this.begM == 12) {
                abegY = this.begY + 1;
                abegM = 1;
            } else {
                abegY = this.begY;
                abegM = this.begM + 1;
            }
            if (this.endM == 12) {
                aendY = this.endY + 1;
                aendM = 1;
            } else {
                aendY = this.endY;
                aendM = this.endM + 1;
            }
            for (int ix = abegY; ix <= aendY; ++ix) {
                int auxBM = ix == abegY ? abegM : 1;
                int auxEM = ix == aendY ? aendM : 12;
                for (int jx = auxBM; jx <= auxEM; ++jx) {
                    ResultSet r = s.executeQuery("SELECT * FROM SuplierPolcies WHERE (SupplierName = '" + this.SupplierName + "')" + " AND (Year = " + ix + ")" + " AND (Month = " + jx + ")");
                    int stcount = 0;
                    while (r.next()) {
                        for (int kx = 0; kx < this.numStates; ++kx) {
                            aux[kx] = r.getDouble("EFBvalueState" + (kx + 1));
                        }
                        ++stcount;
                    }
                    if (stcount == 0) {
                        MTOS.mtosError("no EFB found, " + this.SupplierName + ", year " + ix + ", month " + (jx + 1));
                    }
                    this.suppEFB[stgecount] = new CvaLinPartes(this.SuppStates, aux);
                    ++stgecount;
                }
            }
        }
        catch (SQLException e) {
            System.out.println(e);
            MTOS.mtosError("invalid data on MTOSDB or bad connection to Data Base");
        }
    }

    public void includeInMarket(SimMDE market) {
        this.initSchemFR();
        this.actMResH = new SimMDE_tabresultado(this.actOfferH);
        market.addMarketAgent(this.actOfferH, this.actMResH, true);
        this.actMResT = new SimMDE_tabresultado(this.actOfferT);
        market.addMarketAgent(this.actOfferT, this.actMResT, true);
    }

    public double doAnOffer(double pprice) throws Exception {
        double HydEner = 0.0;
        this.isHydroMarginal = false;
        if (this.isOffDone) {
            this.actprice = pprice;
            if (this.supRes.length > 0) {
                HydEner = this.SupOptClass.UpdateHydOffer(this.actprice);
            }
        } else {
            this.actprice = pprice;
            SimMDE_ptocva[] tempCve = this.SupOptClass.getThmOfferCve();
            if (tempCve != null) {
                this.actOfferT.setParticipa(true);
                this.actOfferT.setOffCurve(tempCve);
            } else {
                this.actOfferT.setParticipa(false);
            }
            tempCve = this.SupOptClass.getHydOffer(this.suppEFB[this.actstage], this.actprice, this.stagedur[this.actstage]);
            if (tempCve != null) {
                this.actOfferH.setParticipa(true);
                this.actOfferH.setOffCurve(tempCve);
                HydEner = tempCve[1].energia;
            } else {
                this.actOfferH.setParticipa(false);
            }
            this.isOffDone = true;
        }
        return HydEner;
    }

    public void doAMargHydOffer(double clrprice, double engy) {
        if (this.actOfferH.participa) {
            this.actOfferH.ofhora[1][1].precio = clrprice;
            this.actOfferH.ofhora[1][1].energia = engy;
        }
        this.isHydroMarginal = true;
    }

    public double getExPrice(int pstage, int phydro) {
        return this.exPrices[pstage][phydro];
    }

    public void setOutStr(PrintWriter outpF) {
        this.myPrintStream = outpF;
        this.SupOptClass.setOutStr(this.myPrintStream);
    }

    public void writeOff2Stream(PrintWriter myPrintStream) {
        this.actOfferH.write2Stream(myPrintStream);
        this.actOfferT.write2Stream(myPrintStream);
    }

    public void makeDispatch(double clrprice, double upperBoundPrice) throws Exception {
        this.actprice = clrprice;
        if (this.actOfferH.participa) {
            this.SupOptClass.showHydroDispatch(this.isHydroMarginal, clrprice, this.actMResH.energiacas[1]);
        }
        if (this.actOfferH.participa && this.isHydroMarginal) {
            this.SupOptClass.doRestEnHydOpt(upperBoundPrice, this.actMResH.energiacas[1]);
        }
        if (this.actOfferT.participa) {
            this.SupOptClass.showThermDispatch(clrprice, this.actMResT.energiacas[1]);
        }
    }

    public double getOperBalance(int actYear, int actMonth, double actEnPrice) {
        double aux = 0.0;
        aux = this.SupOptClass.getWheelsBalance(actYear, actMonth, actEnPrice);
        aux += this.SupOptClass.getOperHydE() * actEnPrice;
        return aux += this.SupOptClass.getOperThmBal(actEnPrice);
    }

    public void setNegOpFDR(double pFR) {
        this.negOpFDR = pFR;
    }

    public double getNegOpFDR() {
        return this.negOpFDR;
    }

    public double getClearOperRev(int actYear, int actMonth, double actEnPrice) {
        double aux = 0.0;
        if (this.actOfferH.participa) {
            aux = this.SupOptClass.getOperHydE() * actEnPrice;
        }
        if (this.actOfferT.participa) {
            aux += this.SupOptClass.getClearThermalOperRev(actEnPrice, this.actMResT.energiacas[1]);
        }
        return aux += this.SupOptClass.getWheelsBalance(actYear, actMonth, actEnPrice);
    }

    public double getEndResState() {
        double aux = -1.0;
        if (this.supRes != null && this.supRes.length > 0) {
            aux = this.SupOptClass.finalResState * 100.0;
        }
        return aux;
    }
}

