/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import com.objectplanet.chart.LineChart;
import de.core.AnalysisTool;
import de.core.DeepEdit;
import de.core.DeepEditFrame;
import de.core.MTMarketException;
import de.core.MTMarketFrame;
import de.core.MTOS;
import de.core.Schematic;
import de.core.SimMDE;
import de.core.SimMDE_ptocva;
import de.core.SimMDE_taboferta;
import de.core.SimMDE_tabresultado;
import de.core.SimpleDialog;
import java.awt.Frame;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.sql.ResultSet;
import java.sql.Statement;

public class MTMarket
extends AnalysisTool {
    public MTMarketFrame MyMTMarketFrame = null;
    public int begY = 0;
    public int endY = 0;
    public int begM = 0;
    public int endM = 0;
    public boolean YesCharts = false;
    private static String FileName = "./results/MTMarket.dat";
    private static String FileName2 = "./results/MTMarket_Sup.dat";
    private PrintWriter myPrintStream;
    private PrintWriter myPrintStream2;
    private FileOutputStream os;
    private FileOutputStream os2;
    private DeepEdit applet;
    private String errmsg;
    public String[] SupplierNames;
    private MTOS[] supMTOS;
    private double[] medDemand;
    private SimMDE_taboferta myDemOff;
    private SimMDE_tabresultado myDemMRes;
    private SimMDE myMarket;
    private int[][] simHydSec;
    private int numStages;
    public int numSim;
    private MTOS auxMTOS;
    public long randSeed;
    private double[][] simPrices;
    private double[] iniSPrices;
    public Frame f1;
    public Frame f2;
    private double[][][] supOperRev;
    private double[][] supEndResState;

    public MTMarket(Schematic sch, DeepEdit app) {
        super(sch);
        this.applet = app;
        if (this.MyMTMarketFrame == null) {
            this.MyMTMarketFrame = new MTMarketFrame(this);
        } else {
            this.MyMTMarketFrame.setVisible(true);
        }
    }

    private void initSimulation() throws Exception {
        int ix;
        this.os = new FileOutputStream(FileName);
        this.myPrintStream = new PrintWriter(this.os, true);
        this.os2 = new FileOutputStream(FileName2);
        this.myPrintStream2 = new PrintWriter(this.os2, true);
        if (this.SupplierNames.length < 1) {
            MTMarket.mtmarketError("No suppliers selected");
        }
        this.supMTOS = new MTOS[this.SupplierNames.length];
        for (ix = 0; ix < this.SupplierNames.length; ++ix) {
            this.supMTOS[ix] = new MTOS(this.ActSchematic, this.applet, this.SupplierNames[ix], this.begM, this.begY, this.endM, this.endY);
        }
        for (ix = 0; ix < this.SupplierNames.length; ++ix) {
            if (!this.supMTOS[ix].isHydraulicOwner()) continue;
            this.auxMTOS = this.supMTOS[ix];
            break;
        }
        if (this.auxMTOS == null) {
            MTMarket.mtmarketError("No (hydro)suppliers found, so no calculations needed.");
        }
        this.auxMTOS.setupRandGen(this.randSeed);
        Statement s = DeepEditFrame.conMTOS.createStatement();
        this.numStages = this.auxMTOS.numStages;
        this.medDemand = new double[this.numStages];
        this.simHydSec = new int[this.numSim][this.numStages];
        this.simPrices = new double[this.numSim][this.numStages];
        this.iniSPrices = new double[this.numStages];
        this.supOperRev = new double[this.supMTOS.length][this.numSim][this.numStages];
        this.supEndResState = new double[this.supMTOS.length][this.numSim];
        int stgecount = 0;
        for (ix = this.begY; ix <= this.endY; ++ix) {
            ResultSet r = s.executeQuery("SELECT * FROM MediumEnergyDemand WHERE (Year = " + ix + ")" + " ORDER BY Month");
            int auxBM = ix == this.begY ? this.begM : 1;
            int auxEM = ix == this.endY ? this.endM : 12;
            int stcount = auxBM;
            while (r.next()) {
                if (r.getInt("Month") != stcount) continue;
                this.medDemand[stgecount] = r.getDouble("MedEngyDem");
                ++stgecount;
                if (stcount == auxEM) break;
                ++stcount;
            }
            if (stcount == auxEM) continue;
            MTMarket.mtmarketError("no demand information found on MTOS for year " + ix + " , month " + stcount);
        }
        System.out.println("mean load found and read");
        this.myMarket = new SimMDE(this.ActSchematic, true);
        this.myDemOff = new SimMDE_taboferta("Market_Demand", false);
        this.myDemMRes = new SimMDE_tabresultado(this.myDemOff);
        this.myMarket.addMarketAgent(this.myDemOff, this.myDemMRes, false);
        for (ix = 0; ix < this.supMTOS.length; ++ix) {
            this.supMTOS[ix].includeInMarket(this.myMarket);
        }
        this.myMarket.initMarket();
    }

    private double doMarketEquil(int stage, int hydrology, double iniPrice) throws Exception {
        double[] aux2;
        int ix;
        double pcU;
        double iniPrice1 = 25.0;
        double clearPrice = 25.0;
        double obtprice = 25.0;
        double pcL = pcU = iniPrice;
        int itercount = 0;
        boolean isboundch = true;
        int typeP = -2;
        double[] UppHydEnOff = new double[this.supMTOS.length];
        double[] LowHydEnOff = new double[this.supMTOS.length];
        double[] aux1 = new double[this.supMTOS.length];
        System.out.print("Market Equilibrium for stage " + (stage + 1) + ":");
        for (itercount = 0; itercount < 2; ++itercount) {
            iniPrice1 = iniPrice;
            for (ix = 0; ix < this.supMTOS.length; ++ix) {
                aux1[ix] = this.supMTOS[ix].doAnOffer(iniPrice);
            }
            System.out.print("*");
            obtprice = this.myMarket.getClearPrice();
            if (obtprice > iniPrice) {
                pcU = obtprice;
                aux2 = aux1;
                aux1 = LowHydEnOff;
                LowHydEnOff = aux2;
            } else {
                pcL = obtprice;
                aux2 = aux1;
                aux1 = UppHydEnOff;
                UppHydEnOff = aux2;
            }
            iniPrice = obtprice;
            this.myPrintStream.flush();
        }
        double lbP = pcL;
        double ubP = pcU;
        if (iniPrice1 == obtprice) {
            clearPrice = obtprice;
            typeP = 0;
        } else {
            double lInter = pcU - pcL;
            double multip = 0.5;
            iniPrice = pcL + lInter * multip;
            for (itercount = 0; itercount < 20; ++itercount) {
                iniPrice1 = iniPrice;
                for (ix = 0; ix < this.supMTOS.length; ++ix) {
                    aux1[ix] = this.supMTOS[ix].doAnOffer(iniPrice);
                }
                System.out.print("*");
                obtprice = this.myMarket.getClearPrice();
                if (obtprice > iniPrice) {
                    pcU = obtprice;
                    lbP = iniPrice;
                    aux2 = aux1;
                    aux1 = LowHydEnOff;
                    LowHydEnOff = aux2;
                } else {
                    pcL = obtprice;
                    ubP = iniPrice;
                    aux2 = aux1;
                    aux1 = UppHydEnOff;
                    UppHydEnOff = aux2;
                }
                lInter = ubP - lbP;
                iniPrice = lbP + lInter / 2.0;
                if (Math.abs(iniPrice1 - obtprice) < 0.1) {
                    typeP = 0;
                    break;
                }
                if (pcL == pcU) {
                    typeP = 0;
                    break;
                }
                if (Math.abs(iniPrice1 - pcL) < 0.1) {
                    typeP = 1;
                    break;
                }
                if (Math.abs(iniPrice1 - pcU) < 0.1) {
                    typeP = 2;
                    break;
                }
                if (!(lInter < 0.14)) continue;
                typeP = -1;
                break;
            }
            if (typeP > -1) {
                switch (typeP) {
                    case 0: {
                        clearPrice = obtprice;
                        break;
                    }
                    case 1: {
                        clearPrice = pcL;
                        break;
                    }
                    case 2: {
                        clearPrice = pcU;
                    }
                }
            } else {
                clearPrice = lbP + (ubP - lbP) / 2.0;
                for (ix = 0; ix < this.supMTOS.length; ++ix) {
                    if (!(Math.abs(UppHydEnOff[ix] - LowHydEnOff[ix]) > 0.1)) continue;
                    this.supMTOS[ix].doAMargHydOffer(clearPrice, UppHydEnOff[ix]);
                }
                obtprice = this.myMarket.getClearPrice();
                if (Math.abs(obtprice - clearPrice) > 0.1) {
                    MTMarket.mtmarketError("Can't Reach Market Price Equilibrium");
                }
            }
        }
        if (typeP == -2) {
            MTMarket.mtmarketError("Can\u00b4t Reach Market Price Equilibrium");
        }
        this.myMarket.assignDispatch();
        System.out.print("\n>Mean Market Price=" + MTOS.numformat(clearPrice, 6, 2) + ", ");
        this.myPrintStream.print(">Mean Market Price=" + MTOS.numformat(clearPrice, 6, 2) + ", ");
        for (ix = 0; ix < this.supMTOS.length; ++ix) {
            this.supMTOS[ix].makeDispatch(clearPrice, ubP);
        }
        this.myPrintStream.println("upperBP=" + ubP + ", LowerBP=" + lbP + ", Type Price finded=" + typeP);
        this.myPrintStream.println("upperCP=" + pcU + ", LowerCP=" + pcL);
        return clearPrice;
    }

    public void Calculate() {
        double maxprice = 200.0;
        try {
            int i;
            this.initSimulation();
            for (i = 0; i < this.supMTOS.length; ++i) {
                this.supMTOS[i].setOutStr(this.myPrintStream);
            }
            SimMDE_ptocva actInelstDemand = new SimMDE_ptocva();
            actInelstDemand.precio = 200.0;
            for (int actsim = 0; actsim < this.numSim; ++actsim) {
                int actstage = 0;
                int mth = this.begM;
                int year = this.begY;
                System.out.println("\n---------------Calculation Started for Simulation " + (actsim + 1) + "--------------");
                this.myPrintStream.println("\n---------------Calculation Results for Simulation " + (actsim + 1) + "--------------");
                for (i = 0; i < this.supMTOS.length; ++i) {
                    this.supMTOS[i].initSchemFR();
                }
                for (actstage = 0; actstage < this.numStages; ++actstage) {
                    int acthyd;
                    System.out.println("\nCalculation Started for stage " + (actstage + 1));
                    this.myPrintStream.println("--------------- Stage " + (actstage + 1));
                    this.simHydSec[actsim][actstage] = acthyd = this.auxMTOS.getNextRandHyd();
                    actInelstDemand.energia = this.medDemand[actstage];
                    this.myDemOff.setInelastDemCurve(actInelstDemand);
                    double iniPrice = this.auxMTOS.getExPrice(actstage, acthyd);
                    for (i = 0; i < this.supMTOS.length; ++i) {
                        this.supMTOS[i].setupStepForward(actstage, acthyd, iniPrice);
                    }
                    this.simPrices[actsim][actstage] = this.doMarketEquil(actstage, acthyd, iniPrice);
                    for (i = 0; i < this.supMTOS.length; ++i) {
                        this.supOperRev[i][actsim][actstage] = this.supMTOS[i].getClearOperRev(year, mth, this.simPrices[actsim][actstage]);
                    }
                    if (mth == 12) {
                        mth = 1;
                        ++year;
                        continue;
                    }
                    ++mth;
                }
                for (i = 0; i < this.supMTOS.length; ++i) {
                    this.supEndResState[i][actsim] = this.supMTOS[i].getEndResState();
                }
            }
            this.writeSuppFile();
            if (FileName != null) {
                this.DoListResults(FileName);
            }
            this.DoListResults(FileName2);
            if (this.YesCharts) {
                this.showSimulationPrices();
            }
            this.writeDB();
        }
        catch (Exception e) {
            String message = e.toString();
            System.out.println(e);
            String[] DlgButtons = new String[]{"OK"};
            SimpleDialog ExceptionDialog = new SimpleDialog(DeepEdit.frame, "MTMarket  main", message, DlgButtons, 1, 0, 0, 1);
            e.printStackTrace();
            return;
        }
    }

    private void writeDBDeterministic() throws Exception {
        boolean existRecord = false;
        Statement s = DeepEditFrame.conMTOS.createStatement();
        s.executeUpdate("DELETE * FROM DeterministicSimulationPrices");
        int stagecount = 0;
        for (int year = this.begY; year <= this.endY; ++year) {
            int auxBM = year == this.begY ? this.begM : 1;
            int auxEM = year == this.endY ? this.endM : 12;
            for (int month = auxBM; month <= auxEM; ++month) {
                int acthydro = this.auxMTOS.auxHSyears[this.simHydSec[0][stagecount]];
                s.executeUpdate("INSERT INTO DeterministicSimulationPrices (Year, Month, Hydrology, MPrice) VALUES (" + year + ", " + month + ", " + acthydro + ", " + this.simPrices[0][stagecount] + ")");
                ++stagecount;
            }
        }
        DeepEditFrame.conMTOS.commit();
        System.out.println("Results of Deterministic Simulation added to Database");
    }

    private void writeDB() throws Exception {
        boolean existRecord = false;
        Statement s = DeepEditFrame.conMTOS.createStatement();
        for (int i = 0; i < this.numSim; ++i) {
            int stagecount = 0;
            for (int year = this.begY; year <= this.endY; ++year) {
                int auxBM = year == this.begY ? this.begM : 1;
                int auxEM = year == this.endY ? this.endM : 12;
                for (int month = auxBM; month <= auxEM; ++month) {
                    int acthydro = this.simHydSec[i][stagecount];
                    ResultSet r = s.executeQuery("SELECT * FROM SimulationMarketPrices WHERE (Year = " + year + ")" + " AND (Month = " + month + ")" + " AND (Hydrology = " + (acthydro + 1) + ")");
                    double sumP = 0.0;
                    int totSim = 0;
                    existRecord = false;
                    while (r.next()) {
                        sumP = r.getDouble("PricesSum");
                        totSim = r.getInt("NumSimulations");
                        existRecord = true;
                    }
                    ++totSim;
                    sumP += this.simPrices[i][stagecount];
                    if (existRecord) {
                        s.executeUpdate("UPDATE SimulationMarketPrices SET NumSimulations = " + totSim + ", " + " PricesSum = " + sumP + " " + " WHERE (Year = " + year + ")" + " AND (Month = " + month + ")" + " AND (Hydrology = " + (acthydro + 1) + ")");
                    } else {
                        s.executeUpdate("INSERT INTO SimulationMarketPrices (Year, Month, Hydrology, NumSimulations, PricesSum) VALUES (" + year + ", " + month + ", " + (acthydro + 1) + ", " + totSim + ", " + sumP + ")");
                    }
                    ++stagecount;
                }
            }
        }
        DeepEditFrame.conMTOS.commit();
        System.out.println("New Simulations for Mean Prices added to Database");
    }

    private void showSimulationPrices() throws Exception {
        double mayy = 150.0;
        LineChart chart = new LineChart(this.numSim, this.numStages, mayy);
        chart.setTitle("Simulation Price Trajectories");
        for (int ix = 0; ix < this.numSim; ++ix) {
            chart.setConnectedLinesOn(ix, true);
            chart.setSeriesLabel(ix, "Sim " + (ix + 1));
        }
        for (int simcount = 0; simcount < this.numSim; ++simcount) {
            for (int stage = 0; stage < this.numStages; ++stage) {
                chart.setSampleValue(simcount, stage, this.simPrices[simcount][stage]);
            }
        }
        String[] labels = new String[this.numStages];
        for (int k = 0; k < this.numStages; ++k) {
            labels[k] = "" + (k + 1);
        }
        chart.setSampleLabels(labels);
        chart.setTitleOn(true);
        chart.setLegendOn(true);
        chart.setValueLinesOn(true);
        chart.setRangeAdjusterOn(true);
        chart.setSampleLabelsOn(true);
        chart.setGridLinesOn(true);
        chart.setSampleScrollerOn(true);
        chart.setAutoLabelSpacingOn(true);
        chart.setLabel("EngyPrice", "[mills/kWh]");
        chart.setLabel("Period", "[month]");
        this.f2 = new Frame("Simulation Price Trajectories");
        this.f2.add("Center", chart);
        this.f2.setSize(300, 300);
        this.f2.setVisible(true);
        System.out.println("Simulation Price Trajectories showed");
    }

    private void showDeterministicSimulationPrices() throws Exception {
        double mayy = 150.0;
        LineChart chart = new LineChart(2, this.numStages, mayy);
        chart.setTitle("Simulation Deterministic && Estimated Prices");
        chart.setConnectedLinesOn(0, true);
        chart.setSeriesLabel(0, "DetermSimP");
        chart.setConnectedLinesOn(1, true);
        chart.setSeriesLabel(1, "EstimatedP");
        for (int stage = 0; stage < this.numStages; ++stage) {
            chart.setSampleValue(0, stage, this.simPrices[0][stage]);
            chart.setSampleValue(1, stage, this.iniSPrices[stage]);
        }
        String[] labels = new String[this.numStages];
        for (int k = 0; k < this.numStages; ++k) {
            labels[k] = "" + (k + 1);
        }
        chart.setSampleLabels(labels);
        chart.setTitleOn(true);
        chart.setLegendOn(true);
        chart.setValueLinesOn(true);
        chart.setRangeAdjusterOn(true);
        chart.setSampleLabelsOn(true);
        chart.setGridLinesOn(true);
        chart.setSampleScrollerOn(true);
        chart.setAutoLabelSpacingOn(true);
        chart.setLabel("EngyPrice", "[mills/kWh]");
        chart.setLabel("Period", "[month]");
        this.f2 = new Frame("Simulation Deterministic && Estimated Prices");
        this.f2.add("Center", chart);
        this.f2.setSize(300, 300);
        this.f2.setVisible(true);
        System.out.println("Simulation Deterministic && Estimated Prices showed");
    }

    public void deleteStatPrices() {
        try {
            Statement s = DeepEditFrame.conMTOS.createStatement();
            s.executeUpdate("DELETE * FROM SimulationMarketPrices");
        }
        catch (Exception e) {
            String message = "Error writing Data Base. Please check it";
            String[] DlgButtons = new String[]{"OK"};
            SimpleDialog ExceptionDialog = new SimpleDialog(DeepEdit.frame, "MTMarket  main", message, DlgButtons, 1, 0, 0, 1);
        }
        System.out.println("Statistic Prices Deleted.");
    }

    public void deterSimulation() {
        double maxprice = 200.0;
        System.out.println("Starting Deterministic Simulation!");
        try {
            int i;
            this.initSimulation();
            this.readHydrologies();
            for (i = 0; i < this.supMTOS.length; ++i) {
                this.supMTOS[i].setOutStr(this.myPrintStream);
            }
            SimMDE_ptocva actInelstDemand = new SimMDE_ptocva();
            actInelstDemand.precio = 200.0;
            int actsim = 0;
            int actstage = 0;
            int mth = this.begM;
            int year = this.begY;
            this.myPrintStream.println("\n---------------Calculation Results for Determinsitic Simulation --------------");
            for (i = 0; i < this.supMTOS.length; ++i) {
                this.supMTOS[i].initSchemFR();
            }
            for (actstage = 0; actstage < this.numStages; ++actstage) {
                System.out.println("\nCalculation Started for stage " + (actstage + 1));
                this.myPrintStream.println("--------------- Stage " + (actstage + 1));
                int acthyd = this.simHydSec[0][actstage];
                actInelstDemand.energia = this.medDemand[actstage];
                this.myDemOff.setInelastDemCurve(actInelstDemand);
                this.iniSPrices[actstage] = this.auxMTOS.getExPrice(actstage, acthyd);
                double iniPrice = this.iniSPrices[actstage];
                for (i = 0; i < this.supMTOS.length; ++i) {
                    this.supMTOS[i].setupStepForward(actstage, acthyd, iniPrice);
                }
                this.simPrices[actsim][actstage] = this.doMarketEquil(actstage, acthyd, iniPrice);
                for (i = 0; i < this.supMTOS.length; ++i) {
                    this.supOperRev[i][actsim][actstage] = this.supMTOS[i].getClearOperRev(year, mth, this.simPrices[actsim][actstage]);
                }
                if (mth == 12) {
                    mth = 1;
                    ++year;
                    continue;
                }
                ++mth;
            }
            for (i = 0; i < this.supMTOS.length; ++i) {
                this.supEndResState[i][actsim] = this.supMTOS[i].getEndResState();
            }
            this.writeSuppFile();
            if (FileName != null) {
                this.DoListResults(FileName);
            }
            this.DoListResults(FileName2);
            if (this.YesCharts) {
                this.showDeterministicSimulationPrices();
            }
            this.writeDBDeterministic();
        }
        catch (Exception e) {
            String message = e.toString();
            System.out.println(e);
            String[] DlgButtons = new String[]{"OK"};
            SimpleDialog ExceptionDialog = new SimpleDialog(DeepEdit.frame, "MTMarket  main", message, DlgButtons, 1, 0, 0, 1);
            e.printStackTrace();
            return;
        }
    }

    public void updateHydPrices() {
    }

    public void readHydrologies() throws Exception {
        Statement s = DeepEditFrame.conMTOS.createStatement();
        this.numStages = this.auxMTOS.numStages;
        int stgecount = 0;
        for (int ix = this.begY; ix <= this.endY; ++ix) {
            ResultSet r = s.executeQuery("SELECT * FROM DeterministicHydrology WHERE (Year = " + ix + ")" + " ORDER BY Month");
            int auxBM = ix == this.begY ? this.begM : 1;
            int auxEM = ix == this.endY ? this.endM : 12;
            int stcount = auxBM;
            while (r.next()) {
                if (r.getInt("Month") != stcount) continue;
                int temphyd = r.getInt("Hydrology");
                this.simHydSec[0][stgecount] = this.findhydroposition(temphyd);
                if (this.simHydSec[0][stgecount] < 0) {
                    MTMarket.mtmarketError("Deterministic Hydrology " + temphyd + " not valid.");
                }
                ++stgecount;
                if (stcount == auxEM) break;
                ++stcount;
            }
            if (stcount == this.endM) continue;
            MTMarket.mtmarketError("no or wrong deterministic hydrology information found on MTOS for year " + ix + " , month " + stcount);
        }
        System.out.println("Deterministic hydrology found and read");
    }

    private static void mtmarketError(String mensaje) throws MTMarketException {
        throw new MTMarketException(mensaje);
    }

    private int findhydroposition(int auxhydro) {
        int auxpos;
        for (auxpos = 0; auxpos < this.auxMTOS.auxHSyears.length && this.auxMTOS.auxHSyears[auxpos] != auxhydro; ++auxpos) {
        }
        if (auxpos == this.auxMTOS.auxHSyears.length) {
            auxpos = -1;
        }
        return auxpos;
    }

    private void writeSuppFile() {
        this.myPrintStream2.println("------------------ Supplier Commercial Results--------------------");
        this.myPrintStream2.println("----------------------- Values in [MUS$] -------------------------\n");
        for (int ix = 0; ix < this.supMTOS.length; ++ix) {
            this.myPrintStream2.println("-------- " + this.SupplierNames[ix] + "--------");
            this.writeHead1();
            for (int actsim = 0; actsim < this.numSim; ++actsim) {
                this.myPrintStream2.print(MTOS.numformat(actsim + 1, 5));
                this.myPrintStream2.print(" ");
                for (int actstage = 0; actstage < this.numStages; ++actstage) {
                    this.myPrintStream2.print(MTOS.numformat(this.supOperRev[ix][actsim][actstage] / 1000000.0, 9, 3));
                }
                if (this.supEndResState[ix][actsim] > -1.0) {
                    this.myPrintStream2.println(MTOS.numformat(this.supEndResState[ix][actsim], 9, 2));
                    continue;
                }
                this.myPrintStream2.println("   NA");
            }
            this.myPrintStream2.println("");
        }
    }

    private void writeHead1() {
        int jx;
        int mth = this.begM;
        int year = this.begY;
        this.myPrintStream2.print("NumSim  ");
        for (jx = 0; jx < this.numStages; ++jx) {
            this.myPrintStream2.print(year + MTOS.monthNames[mth - 1] + "  ");
            if (mth == 12) {
                mth = 1;
                ++year;
                continue;
            }
            ++mth;
        }
        this.myPrintStream2.println("EndResSte");
        this.myPrintStream2.print("------  ");
        for (jx = 0; jx < this.numStages; ++jx) {
            this.myPrintStream2.print("-------  ");
        }
        this.myPrintStream2.println("---[%]---");
    }
}

