/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import de.core.Busbar;
import de.core.DBReadTableFrame;
import de.core.DEMainChartFrame;
import de.core.DeepEdit;
import de.core.MMS;
import de.core.VoltageVisual;
import de.core.YearlyDEMainChartFrame;
import de.core.YearlyToolOverlaidXYPlot;
import de.core.YearlyToolStatisticalBarChart;
import de.core.comp;
import de.core.ndb_1pol;
import de.core.ndb_branch;
import de.core.ndb_comp;
import de.utils.StringUtil;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;
import org.jfree.ui.RefineryUtilities;

class MMSVisualFrameVolt
extends Frame
implements KeyListener,
ActionListener {
    private DeepEdit applet;
    MMS MyStat;
    protected Font TextDialogFont;
    protected FontMetrics TextDialogFontMetrics;
    Choice MyChoiceBus = null;
    Choice MyChoiceHydro = null;
    Choice MyChoiceBranch = null;
    Choice MyChoiceBlock = null;
    Choice MyChoiceMonth = null;
    Choice MyChoiceYear = null;
    boolean DB = false;
    public static YearlyDEMainChartFrame MyYearlyDEMainChartFrame = null;
    public static DEMainChartFrame MyDEMainChartFrame = null;
    VoltageVisual MyVoltageVisual = null;
    double fmax = 0.0;

    public MMSVisualFrameVolt(DEMainChartFrame MMyDEMainChartFrame, MMS ms, boolean DBo) {
        super("Yearly LF Statistics");
        int l;
        int l2;
        MyDEMainChartFrame = MMyDEMainChartFrame;
        this.MyStat = ms;
        this.setBackground(new Color(192, 192, 192));
        this.DB = DBo;
        this.TextDialogFont = DeepEdit.TextFont;
        this.TextDialogFontMetrics = this.getFontMetrics(this.TextDialogFont);
        this.setFont(this.TextDialogFont);
        this.setLayout(new BorderLayout());
        JPanel P1 = new JPanel();
        P1.setBackground(new Color(192, 192, 192));
        P1.setBorder(new EtchedBorder());
        P1.setFont(new Font("MS Sans Serif", 0, 10));
        P1.setLayout(new GridLayout(10, 1));
        Label titel1 = new Label("AC STUDIES OPTIONS");
        titel1.setForeground(Color.blue);
        P1.add(titel1);
        P1.add(new Label("Select Node"));
        this.MyChoiceBus = new Choice();
        for (int l3 = 0; l3 < this.MyStat.numallnod; ++l3) {
            this.MyChoiceBus.addItem(this.MyStat.NomNod[l3]);
        }
        P1.add(this.MyChoiceBus);
        Button buttonShowBus = new Button("Voltage Evolution");
        buttonShowBus.setActionCommand("Show Node");
        buttonShowBus.addActionListener(this);
        Button buttonShowVoltStatistics = new Button("Voltage Statistics");
        buttonShowVoltStatistics.setActionCommand("Voltage Statistics");
        buttonShowVoltStatistics.addActionListener(this);
        Button buttonShowVoltScenario = new Button("Show Voltage Scenario");
        buttonShowVoltScenario.setActionCommand("Show Voltage Scenario");
        buttonShowVoltScenario.addActionListener(this);
        Button buttonDataLoad = new Button("Show Load && Gen. Data");
        buttonDataLoad.setActionCommand("Show Load && Gen. Data");
        buttonDataLoad.addActionListener(this);
        P1.add(buttonShowBus);
        P1.add(buttonShowVoltStatistics);
        P1.add(buttonShowVoltScenario);
        P1.add(buttonDataLoad);
        this.add("East", P1);
        JPanel P2 = new JPanel();
        P2.setBackground(new Color(192, 192, 192));
        P2.setLayout(new GridLayout(10, 1));
        P2.setBorder(new EtchedBorder());
        P2.setFont(new Font("MS Sans Serif", 0, 10));
        Label titel2 = new Label("DC STUDIES OPTIONS");
        titel2.setForeground(Color.blue);
        P2.add(titel2);
        P2.add(new Label("Select Branch"));
        this.MyChoiceBranch = new Choice();
        for (int l4 = 0; l4 < this.MyStat.numallbran; ++l4) {
            this.MyChoiceBranch.addItem(this.MyStat.NomBra[l4]);
        }
        P2.add(this.MyChoiceBranch);
        Button buttonShowBranch = new Button("Show Branch");
        buttonShowBranch.setActionCommand("Show Branch");
        buttonShowBranch.addActionListener(this);
        Button buttonShowFlowScenario = new Button("Show Flow Scenario");
        buttonShowFlowScenario.setActionCommand("Show Flow Scenario");
        buttonShowFlowScenario.addActionListener(this);
        Button buttonShowTables = new Button("Show Line Data");
        buttonShowTables.setActionCommand("Show Line Data");
        buttonShowTables.addActionListener(this);
        Button buttonExitBranch = new Button("Exit");
        buttonExitBranch.setActionCommand("Exit");
        buttonExitBranch.addActionListener(this);
        P2.add(buttonShowBranch);
        P2.add(new Label(""));
        P2.add(buttonShowFlowScenario);
        P2.add(buttonShowTables);
        P2.add(new Label(""));
        P2.add(new Label(""));
        P2.add(buttonExitBranch);
        this.add("Center", P2);
        JPanel P3 = new JPanel();
        P3.setBackground(new Color(192, 192, 192));
        P3.setLayout(new GridLayout(10, 1));
        P3.setBorder(new EtchedBorder());
        P3.setFont(new Font("MS Sans Serif", 0, 10));
        Label titel3 = new Label("SELECT OPTIONS");
        titel3.setForeground(Color.blue);
        P3.add(titel3);
        P3.add(new Label("Select Hydro"));
        this.MyChoiceHydro = new Choice();
        for (l2 = 1; l2 <= this.MyStat.HydroNumberDB; ++l2) {
            this.MyChoiceHydro.addItem("h" + l2);
        }
        P3.add(this.MyChoiceHydro);
        P3.add(new Label("Select Block"));
        this.MyChoiceBlock = new Choice();
        for (l2 = 1; l2 <= this.MyStat.BlockNumberDB; ++l2) {
            this.MyChoiceBlock.addItem("b" + l2);
        }
        P3.add(this.MyChoiceBlock);
        String[] mes = new String[]{"Enero", "Febrero", "Marzo", "Abril", "Mayo", "Junio", "Julio", "Agosto", "Septiembre", "Octubre", "Noviembre", "Diciembre"};
        P3.add(new Label("Select Month"));
        this.MyChoiceMonth = new Choice();
        for (l = 0; l < 12; ++l) {
            this.MyChoiceMonth.addItem(mes[l]);
        }
        P3.add(this.MyChoiceMonth);
        P3.add(new Label("Select Year"));
        this.MyChoiceYear = new Choice();
        for (l = this.MyStat.InitialYearDB; l < this.MyStat.FinalYearDB; ++l) {
            this.MyChoiceYear.addItem("" + l);
        }
        P3.add(this.MyChoiceYear);
        this.add("West", P3);
        this.add("North", new Label("YEARLYTOOL STATISTICS PANEL"));
        this.setBounds(650, 150, 510, 250);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                MMSVisualFrameVolt.this.setVisible(false);
                MMSVisualFrameVolt.this.dispose();
                MMSVisualFrameVolt.this.MyStat.MyMMSFrame = null;
            }
        });
        this.setIconImage(ms.ActFrame.applet.getFrameIconImage());
        this.pack();
        this.setVisible(true);
    }

    @Override
    public void paint(Graphics g) {
    }

    public void chartSetUp1() {
        if (MyDEMainChartFrame == null) {
            MyDEMainChartFrame = new DEMainChartFrame(this.applet, "YearlyTool Graphics");
        }
    }

    public void chartSetUp2() {
        if (MyYearlyDEMainChartFrame == null) {
            MyYearlyDEMainChartFrame = new YearlyDEMainChartFrame(this.applet, "YearlyTool Graphics");
        }
    }

    @Override
    public void keyPressed(KeyEvent event) {
        if (event.getKeyCode() == 27) {
            this.setVisible(false);
            this.dispose();
            this.MyStat.MyMMSFrame = null;
        }
    }

    @Override
    public void keyReleased(KeyEvent event) {
    }

    @Override
    public void keyTyped(KeyEvent event) {
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        Object obj = ev.getSource();
        String label = ev.getActionCommand();
        if (obj instanceof Button) {
            int e;
            comp TempComponent;
            int numhydro = this.MyStat.HydroNumberDB;
            int numblock = this.MyStat.BlockNumberDB;
            int nummonth = this.MyStat.MonthNumberDB;
            int numyear = this.MyStat.YearNumberDB;
            String hydronom = "";
            String hydrolonom = " ";
            String blocknom = "";
            String blocklonom = "";
            int hydronum = -1;
            int blocknum = -1;
            String monthnom = "";
            String yearact = "";
            String yearini = "";
            int yearactnum = -1;
            int yearininum = -1;
            int yearnum = -1;
            int actualnum = -1;
            int totalhorizon = this.MyStat.MonthNumberDB * this.MyStat.BlockNumberDB * this.MyStat.YearNumberDB * this.MyStat.HydroNumberDB;
            if (label.equals("Show Node")) {
                int nodo = 0;
                int selected = -1;
                double yeablnod = this.MyStat.YearNumberDB * this.MyStat.BlockNumberDB * this.MyStat.numallnod;
                int yeamotbloc = this.MyStat.MonthNumberDB * this.MyStat.BlockNumberDB * this.MyStat.YearNumberDB;
                double[][] data2 = new double[2][yeamotbloc];
                String[] xetiq = new String[yeamotbloc];
                int year = 1;
                int mes = 1;
                int bloque = 1;
                int j = 0;
                block16: while (year <= numyear) {
                    for (int m = mes; m <= nummonth; ++m) {
                        for (int b = bloque; b <= numblock; ++b) {
                            int y = year;
                            xetiq[j] = "b" + b + "m" + m + "y" + y;
                            ++j;
                            if (b == numblock) break;
                        }
                        if (m != nummonth) continue;
                        ++year;
                        mes = 1;
                        continue block16;
                    }
                }
                for (int ix = 0; ix < this.MyStat.ActSchematic.Components.size(); ++ix) {
                    TempComponent = (comp)this.MyStat.ActSchematic.Components.elementAt(ix);
                    if (!TempComponent.getvalid() || !TempComponent.getinservice() || !(TempComponent instanceof ndb_1pol) || !(TempComponent instanceof Busbar)) continue;
                    if (TempComponent.getName().equals(this.MyChoiceBus.getSelectedItem())) {
                        Busbar bus = (Busbar)TempComponent;
                        selected = nodo;
                        break;
                    }
                    ++nodo;
                }
                String nombar = this.MyChoiceBus.getSelectedItem();
                String nomhydro = this.MyChoiceHydro.getSelectedItem();
                String hydrolo = nomhydro.substring(1, 2);
                int hydroeleg = Integer.parseInt(hydrolo);
                String[] estadisvolt = new String[]{StringUtil.numformat(this.MyStat.medAllVolt[nodo][hydroeleg - 1] / (double)(this.MyStat.MonthNumberDB * this.MyStat.YearNumberDB), 9, 4).trim(), StringUtil.numformat(Math.sqrt(this.MyStat.varAllVolt[nodo][hydroeleg - 1] / (double)(this.MyStat.MonthNumberDB * this.MyStat.YearNumberDB)), 9, 3).trim(), StringUtil.numformat(this.MyStat.maxAllVolt[nodo][hydroeleg - 1], 9, 3).trim(), StringUtil.numformat(this.MyStat.minAllVolt[nodo][hydroeleg - 1], 9, 3).trim()};
                boolean casoq = true;
                try {
                    Connection conYearlyStat = DeepEdit.OpenCSVasDB("database");
                    Statement s = conYearlyStat.createStatement();
                    String mul = this.MyChoiceBus.getSelectedItem();
                    ResultSet r = s.executeQuery("SELECT * FROM YearlyStatVolt.csv  WHERE Name='" + this.MyChoiceBus.getSelectedItem() + "'");
                    for (int k = 0; k < hydroeleg; ++k) {
                        r.next();
                    }
                    data2[0][0] = r.getDouble("Volt");
                    int i = 1;
                    while (r.next()) {
                        if (i >= yeamotbloc) continue;
                        for (int k = 0; k < numhydro - 1; ++k) {
                            r.next();
                        }
                        data2[0][i] = r.getDouble("Volt");
                        ++i;
                    }
                    conYearlyStat.commit();
                    conYearlyStat.close();
                    for (int uy = 0; uy < yeamotbloc; ++uy) {
                        data2[1][uy] = this.MyStat.medAllVolt[nodo][hydroeleg - 1] / (double)(this.MyStat.MonthNumberDB * this.MyStat.YearNumberDB);
                    }
                    casoq = false;
                }
                catch (Exception ee) {
                    ee.printStackTrace();
                    System.out.println("Error en Lectura de Estad\u00edsticas");
                    String message = ee.toString();
                }
                if (!casoq) {
                    this.chartSetUp1();
                    String[] seriesLabels = new String[]{"Voltaje", "Voltaje Medio"};
                    String[] graphLabels = new String[]{"Evoluci\u00f3n de Voltaje en Barra " + nombar + " " + "en hidrolog\u00eda h" + hydroeleg, "Tiempo[bloque]", "Voltaje[pu]"};
                    String mensaje = "Variacion temporal de la tensi\u00f3n en barra " + nombar;
                    MyDEMainChartFrame.addChart(mensaje, MyDEMainChartFrame.makeDefLineChart(data2, seriesLabels, xetiq, graphLabels), "Media:" + estadisvolt[0] + " " + "pu" + "  " + "Desv:" + estadisvolt[1] + "  " + "Max:" + estadisvolt[2] + " " + "pu" + "  " + "Min:" + estadisvolt[3] + " " + "pu");
                }
            }
            if (label.equals("Voltage Statistics")) {
                String nomhydro_vd = this.MyChoiceHydro.getSelectedItem();
                String hydrolo_vd = nomhydro_vd.substring(1, 2);
                int hydroeleg_vd = Integer.parseInt(hydrolo_vd);
                String mensajevs = "Estadistica de Voltaje en Hidrolog\u00eda h" + hydrolo_vd;
                int numbusbar = 0;
                for (int ix = 0; ix < this.MyStat.ActSchematic.Components.size(); ++ix) {
                    TempComponent = (comp)this.MyStat.ActSchematic.Components.elementAt(ix);
                    if (!TempComponent.getvalid() || !TempComponent.getinservice() || !(TempComponent instanceof ndb_1pol) || !(TempComponent instanceof Busbar)) continue;
                    ++numbusbar;
                }
                String[] nombusbar = new String[numbusbar];
                double[] meanvoltage = new double[numbusbar];
                double[] desvvoltage = new double[numbusbar];
                int inodo = 0;
                for (int jx = 0; jx < this.MyStat.ActSchematic.Components.size(); ++jx) {
                    TempComponent = (comp)this.MyStat.ActSchematic.Components.elementAt(jx);
                    if (!TempComponent.getvalid() || !TempComponent.getinservice() || !(TempComponent instanceof ndb_1pol) || !(TempComponent instanceof Busbar)) continue;
                    nombusbar[inodo] = TempComponent.getName();
                    meanvoltage[inodo] = this.MyStat.medAllVolt[inodo][hydroeleg_vd - 1] / (double)(this.MyStat.MonthNumberDB * this.MyStat.YearNumberDB);
                    desvvoltage[inodo] = Math.sqrt(this.MyStat.varAllVolt[inodo][hydroeleg_vd - 1] / (double)(this.MyStat.MonthNumberDB * this.MyStat.YearNumberDB));
                    ++inodo;
                }
                try {
                    YearlyToolStatisticalBarChart MyStatBar = new YearlyToolStatisticalBarChart(mensajevs, nombusbar, meanvoltage, desvvoltage);
                    MyStatBar.pack();
                    RefineryUtilities.centerFrameOnScreen((Window)((Object)MyStatBar));
                    MyStatBar.setVisible(true);
                }
                catch (Exception e2) {
                    System.out.println("NO SE MUESTRA EL GRAFICO JFREECHART");
                }
            }
            if (label.equals("Show Voltage Scenario")) {
                hydronom = this.MyChoiceHydro.getSelectedItem();
                hydrolonom = hydronom.substring(1, 2);
                hydronum = Integer.parseInt(hydrolonom);
                blocknom = this.MyChoiceBlock.getSelectedItem();
                blocklonom = blocknom.substring(1, 2);
                blocknum = Integer.parseInt(blocklonom);
                monthnom = this.MyChoiceMonth.getSelectedItem();
                int monthnum = 0;
                if (monthnom.equals("Enero")) {
                    monthnum = 1;
                }
                if (monthnom.equals("Febrero")) {
                    monthnum = 2;
                }
                if (monthnom.equals("Marzo")) {
                    monthnum = 3;
                }
                if (monthnom.equals("Abril")) {
                    monthnum = 4;
                }
                if (monthnom.equals("Mayo")) {
                    monthnum = 5;
                }
                if (monthnom.equals("Junio")) {
                    monthnum = 6;
                }
                if (monthnom.equals("Julio")) {
                    monthnum = 7;
                }
                if (monthnom.equals("Agosto")) {
                    monthnum = 8;
                }
                if (monthnom.equals("Septiembre")) {
                    monthnum = 9;
                }
                if (monthnom.equals("Octubre")) {
                    monthnum = 10;
                }
                if (monthnom.equals("Noviembre")) {
                    monthnum = 11;
                }
                if (monthnom.equals("Diciembre")) {
                    monthnum = 12;
                }
                yearact = this.MyChoiceYear.getSelectedItem();
                yearini = this.MyChoiceYear.getItem(0);
                yearactnum = Integer.parseInt(yearact);
                yearininum = Integer.parseInt(yearini);
                yearnum = yearactnum - yearininum + 1;
                actualnum = numhydro * numblock * nummonth * (yearnum - 1) + numhydro * numblock * (monthnum - 1) + numhydro * (blocknum - 1) + hydronum;
                try {
                    Connection conYearlyVolt = DeepEdit.OpenCSVasDB("database");
                    Statement[] ss = new Statement[this.MyChoiceBus.getItemCount()];
                    ResultSet[] rr = new ResultSet[this.MyChoiceBus.getItemCount()];
                    for (e = 0; e < this.MyChoiceBus.getItemCount(); ++e) {
                        ss[e] = conYearlyVolt.createStatement();
                        rr[e] = ss[e].executeQuery("SELECT * FROM YearlyStatVolt.csv  WHERE Name='" + this.MyChoiceBus.getItem(e) + "'");
                    }
                    for (e = 0; e < this.MyChoiceBus.getItemCount(); ++e) {
                        for (int k = 0; k < actualnum; ++k) {
                            rr[e].next();
                        }
                    }
                    int jk = 0;
                    for (int jx = 0; jx < this.MyStat.ActSchematic.Components.size(); ++jx) {
                        TempComponent = (comp)this.MyStat.ActSchematic.Components.elementAt(jx);
                        if (!TempComponent.getvalid() || !TempComponent.getinservice() || !(TempComponent instanceof ndb_1pol) || !(TempComponent instanceof Busbar)) continue;
                        String busname = TempComponent.getName();
                        System.out.println("Name from Schmatics " + busname);
                        Busbar TempBusbar = (Busbar)TempComponent;
                        TempBusbar.setun2(rr[jk].getDouble("Volt") * TempBusbar.getun1());
                        ++jk;
                    }
                    if (this.MyVoltageVisual != null) {
                        this.MyVoltageVisual = null;
                    }
                    DeepEdit cfr_ignored_0 = this.MyStat.applet;
                    this.MyVoltageVisual = new VoltageVisual(DeepEdit.MySchematic);
                    hydronom = "";
                    hydrolonom = " ";
                    blocknom = "";
                    blocklonom = "";
                    hydronum = -1;
                    blocknum = -1;
                    monthnom = "";
                    yearact = "";
                    yearini = "";
                    yearactnum = -1;
                    yearininum = -1;
                    yearnum = -1;
                    actualnum = -1;
                    conYearlyVolt.commit();
                    conYearlyVolt.close();
                }
                catch (Exception ee) {
                    ee.printStackTrace();
                    System.out.println("Error en Lectura de Estad\u00edsticas");
                    String message = ee.toString();
                }
            }
            if (label.equals("Show Flow Scenario")) {
                hydronom = this.MyChoiceHydro.getSelectedItem();
                hydrolonom = hydronom.substring(1, 2);
                hydronum = Integer.parseInt(hydrolonom);
                blocknom = this.MyChoiceBlock.getSelectedItem();
                blocklonom = blocknom.substring(1, 2);
                blocknum = Integer.parseInt(blocklonom);
                monthnom = this.MyChoiceMonth.getSelectedItem();
                int monthnum = 0;
                if (monthnom.equals("Enero")) {
                    monthnum = 1;
                }
                if (monthnom.equals("Febrero")) {
                    monthnum = 2;
                }
                if (monthnom.equals("Marzo")) {
                    monthnum = 3;
                }
                if (monthnom.equals("Abril")) {
                    monthnum = 4;
                }
                if (monthnom.equals("Mayo")) {
                    monthnum = 5;
                }
                if (monthnom.equals("Junio")) {
                    monthnum = 6;
                }
                if (monthnom.equals("Julio")) {
                    monthnum = 7;
                }
                if (monthnom.equals("Agosto")) {
                    monthnum = 8;
                }
                if (monthnom.equals("Septiembre")) {
                    monthnum = 9;
                }
                if (monthnom.equals("Octubre")) {
                    monthnum = 10;
                }
                if (monthnom.equals("Noviembre")) {
                    monthnum = 11;
                }
                if (monthnom.equals("Diciembre")) {
                    monthnum = 12;
                }
                yearact = this.MyChoiceYear.getSelectedItem();
                yearini = this.MyChoiceYear.getItem(0);
                yearactnum = Integer.parseInt(yearact);
                yearininum = Integer.parseInt(yearini);
                yearnum = yearactnum - yearininum + 1;
                actualnum = numhydro * numblock * nummonth * (yearnum - 1) + numhydro * numblock * (monthnum - 1) + numhydro * (blocknum - 1) + hydronum;
                try {
                    Connection conYearlyLine = DeepEdit.OpenCSVasDB("database");
                    Statement[] tt = new Statement[this.MyChoiceBranch.getItemCount()];
                    ResultSet[] pp = new ResultSet[this.MyChoiceBranch.getItemCount()];
                    for (e = 0; e < this.MyChoiceBranch.getItemCount(); ++e) {
                        tt[e] = conYearlyLine.createStatement();
                        pp[e] = tt[e].executeQuery("SELECT * FROM YearlyStatBranchPot.csv  WHERE Branch='" + this.MyChoiceBranch.getItem(e) + "'");
                    }
                    for (e = 0; e < this.MyChoiceBranch.getItemCount(); ++e) {
                        for (int k = 0; k < actualnum; ++k) {
                            pp[e].next();
                        }
                    }
                    int jk = 0;
                    for (int jx = 0; jx < this.MyStat.ActSchematic.Components.size(); ++jx) {
                        TempComponent = (comp)this.MyStat.ActSchematic.Components.elementAt(jx);
                        if (!TempComponent.getvalid() || !TempComponent.getinservice() || !(TempComponent instanceof ndb_comp) || !(TempComponent instanceof ndb_branch)) continue;
                        String branchname = TempComponent.getName();
                        System.out.println("Name from Schmatics " + branchname);
                        ndb_branch TempBranch = (ndb_branch)TempComponent;
                        TempBranch.setp12((double)Math.round(pp[jk].getDouble("Flux") * 10000.0) / 10000.0);
                        TempBranch.setp21(0.0);
                        TempBranch.setq12(0.0);
                        TempBranch.setq21(0.0);
                        ++jk;
                    }
                    this.MyStat.applet.SimulateStart();
                    hydronom = "";
                    hydrolonom = " ";
                    blocknom = "";
                    blocklonom = "";
                    hydronum = -1;
                    blocknum = -1;
                    monthnom = "";
                    yearact = "";
                    yearini = "";
                    yearactnum = -1;
                    yearininum = -1;
                    yearnum = -1;
                    actualnum = -1;
                    conYearlyLine.commit();
                    conYearlyLine.close();
                }
                catch (Exception ee) {
                    ee.printStackTrace();
                    System.out.println("Error en Lectura de Estad\u00edsticas");
                    String message = ee.toString();
                }
            }
            if (label.equals("Show Branch")) {
                int rama = 0;
                int selected = -1;
                String con1 = "na";
                String con2 = "na";
                for (int ix = 0; ix < this.MyStat.ActSchematic.Components.size(); ++ix) {
                    TempComponent = (comp)this.MyStat.ActSchematic.Components.elementAt(ix);
                    if (!TempComponent.getvalid() || !TempComponent.getinservice() || !(TempComponent instanceof ndb_comp) || !(TempComponent instanceof ndb_branch)) continue;
                    if (TempComponent.getName().equals(this.MyChoiceBranch.getSelectedItem())) {
                        ndb_branch tb = (ndb_branch)TempComponent;
                        this.fmax = tb.getsmax();
                        selected = rama;
                        con1 = tb.getcon1();
                        con2 = tb.getcon2();
                        break;
                    }
                    ++rama;
                }
                String titulo = "Distribuci\u00f3n Flujos Rama " + this.MyChoiceBranch.getSelectedItem() + "  desde  " + con1 + "  hasta  " + con2 + "";
                double[][] puntos = new double[4][2];
                double media = 0.0;
                double desv = 0.0;
                if (!this.DB) {
                    puntos[0][0] = 0.0;
                    puntos[0][1] = 100.0 * this.MyStat.maxAllFlujo[rama];
                    puntos[1][0] = this.MyStat.tPAll[rama] / this.MyStat.simDuration[rama] * 100.0;
                    puntos[1][1] = 0.0;
                    puntos[2][0] = (this.MyStat.tPAll[rama] + this.MyStat.tCAll[rama]) / this.MyStat.simDuration[rama] * 100.0;
                    puntos[2][1] = 0.0;
                    puntos[3][0] = (this.MyStat.tPAll[rama] + this.MyStat.tCAll[rama] + this.MyStat.tNAll[rama]) / this.MyStat.simDuration[rama] * 100.0;
                    puntos[3][1] = 100.0 * this.MyStat.minAllFlujo[rama];
                    media = 100.0 * this.MyStat.acumAllFlujo[rama];
                    desv = 100.0 * Math.sqrt(this.MyStat.varAllFlujo[rama]);
                } else {
                    try {
                        Connection conYearlyStat = DeepEdit.OpenCSVasDB("database");
                        Statement s = conYearlyStat.createStatement();
                        String mul = this.MyChoiceBranch.getSelectedItem();
                        ResultSet r = s.executeQuery("SELECT * FROM YearlyStatBranch.csv  WHERE Rama='" + mul + "'");
                        double sdur = 0.0;
                        r.next();
                        sdur = r.getDouble("Dur(h)");
                        puntos[0][0] = 0.0;
                        puntos[0][1] = r.getDouble("Flujo_Max(MW)");
                        double auxa = r.getDouble("Tiempo_Positivo(h)");
                        puntos[1][0] = auxa / sdur * 100.0;
                        puntos[1][1] = 0.0;
                        double auxc = r.getDouble("Tiempo_Cero(h)");
                        puntos[2][0] = puntos[1][0] + auxc / sdur * 100.0;
                        puntos[2][1] = 0.0;
                        double auxb = r.getDouble("Tiempo_Negativo(h)");
                        puntos[3][0] = puntos[2][0] + auxb / sdur * 100.0;
                        puntos[3][1] = r.getDouble("Flujo_Min(MW)");
                        media = r.getDouble("Flujo_Medio(MW)");
                        desv = r.getDouble("Desv(MW)");
                        conYearlyStat.commit();
                        conYearlyStat.close();
                    }
                    catch (Exception ee) {
                        ee.printStackTrace();
                        System.out.println("Error en Lectura de Estad\u00edsticas");
                        String message = ee.toString();
                    }
                }
                boolean casoq = false;
                if (Math.abs(puntos[0][0] - puntos[3][0]) < 1.0E-5) {
                    casoq = true;
                }
                if (!casoq) {
                    try {
                        YearlyToolOverlaidXYPlot MyXYPlot = new YearlyToolOverlaidXYPlot(titulo, puntos, media, desv, this.fmax);
                        MyXYPlot.pack();
                        RefineryUtilities.centerFrameOnScreen((Window)((Object)MyXYPlot));
                        MyXYPlot.setVisible(true);
                    }
                    catch (Exception e3) {
                        System.out.println("NO SE MUESTRA EL GRAFICO JFREECHART");
                    }
                }
            }
            if (label.equals("Show Line Data")) {
                try {
                    DBReadTableFrame showCSV = new DBReadTableFrame("database", "Estad\u00edsticas de Flujo por Ramas", "YearlyStatBranch.csv", 400, 600, "No Importa");
                }
                catch (Exception ee) {
                    ee.printStackTrace();
                    System.out.println("Error en Lectura de Estad\u00edsticas");
                    String message = ee.toString();
                }
            }
            if (label.equals("Show Load && Gen. Data")) {
                try {
                    DBReadTableFrame showCSV1 = new DBReadTableFrame("database", "Estad\u00edsticas de Generaci\u00f3n", "YearlyStatGen.csv", 400, 600, "No Importa");
                    DBReadTableFrame showCSV2 = new DBReadTableFrame("database", "Estad\u00edsticas de Demanda", "YearlyStatLoad.csv", 400, 600, "No Importa");
                }
                catch (Exception ee) {
                    ee.printStackTrace();
                    System.out.println("Error en Lectura de Estad\u00edsticas");
                    String message = ee.toString();
                }
            }
            if (label.equals("Exit")) {
                this.setVisible(false);
                this.dispose();
                this.MyStat.MyMMSVisualFrameVolt = null;
            }
        }
    }
}

