/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import de.core.DBReadTableFrame;
import de.core.DeepEdit;
import de.core.MMS;
import de.core.YearlyDEMainChartFrame;
import de.core.comp;
import de.core.ndb_branch;
import de.core.ndb_comp;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;

class MMSVisualFrame
extends Frame
implements KeyListener,
ActionListener {
    private DeepEdit applet;
    MMS MyStat;
    protected Font TextDialogFont;
    protected FontMetrics TextDialogFontMetrics;
    Choice MyChoiceBranch = null;
    boolean DB = false;
    public static YearlyDEMainChartFrame MyYearlyDEMainChartFrame = null;
    double fmax = 0.0;

    MMSVisualFrame(MMS ms, boolean DBo) {
        super("Yearly DCLF Statistic Options");
        this.MyStat = ms;
        this.setBackground(Color.lightGray);
        this.DB = DBo;
        this.TextDialogFont = DeepEdit.TextFont;
        this.TextDialogFontMetrics = this.getFontMetrics(this.TextDialogFont);
        this.setFont(this.TextDialogFont);
        this.setLayout(new FlowLayout());
        Panel P = new Panel();
        P.setLayout(new GridLayout(8, 1));
        Label titel = new Label("CALCULATION OPTIONS");
        titel.setForeground(Color.blue);
        P.add(titel);
        P.add(new Label("Select Branch"));
        this.MyChoiceBranch = new Choice();
        for (int l = 0; l < this.MyStat.numallbran; ++l) {
            this.MyChoiceBranch.addItem(this.MyStat.NomBra[l]);
        }
        Button buttonSelectedBranch = new Button("Selected Branch");
        buttonSelectedBranch.setActionCommand("Selected Branch");
        buttonSelectedBranch.addActionListener(this);
        P.add(this.MyChoiceBranch);
        Button buttonShowBranch = new Button("Show Branch");
        buttonShowBranch.setActionCommand("Show Branch");
        buttonShowBranch.addActionListener(this);
        Button buttonShowTables = new Button("Show Data");
        buttonShowTables.setActionCommand("Show Data");
        buttonShowTables.addActionListener(this);
        Button buttonExitBranch = new Button("Exit");
        buttonExitBranch.setActionCommand("Exit");
        buttonExitBranch.addActionListener(this);
        P.add(buttonShowBranch);
        P.add(buttonShowTables);
        P.add(buttonExitBranch);
        this.add(P);
        this.setBounds(550, 50, 210, 190);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                MMSVisualFrame.this.setVisible(false);
                MMSVisualFrame.this.dispose();
                MMSVisualFrame.this.MyStat.MyMMSFrame = null;
            }
        });
        this.setIconImage(ms.ActFrame.applet.getFrameIconImage());
        this.setVisible(true);
    }

    MMSVisualFrame(YearlyDEMainChartFrame MMyYearlyDEMainChartFrame, MMS ms, boolean DBo) {
        super("Yearly DCLF Statistic Options");
        MyYearlyDEMainChartFrame = MMyYearlyDEMainChartFrame;
        this.MyStat = ms;
        this.setBackground(Color.lightGray);
        this.DB = DBo;
        this.TextDialogFont = DeepEdit.TextFont;
        this.TextDialogFontMetrics = this.getFontMetrics(this.TextDialogFont);
        this.setFont(this.TextDialogFont);
        this.setLayout(new FlowLayout());
        Panel P = new Panel();
        P.setLayout(new GridLayout(8, 1));
        Label titel = new Label("CALCULATION OPTIONS");
        titel.setForeground(Color.blue);
        P.add(titel);
        P.add(new Label("Select Branch"));
        this.MyChoiceBranch = new Choice();
        for (int l = 0; l < this.MyStat.numallbran; ++l) {
            this.MyChoiceBranch.addItem(this.MyStat.NomBra[l]);
        }
        Button buttonSelectedBranch = new Button("Selected Branch");
        buttonSelectedBranch.setActionCommand("Selected Branch");
        buttonSelectedBranch.addActionListener(this);
        P.add(this.MyChoiceBranch);
        Button buttonShowBranch = new Button("Show Branch");
        buttonShowBranch.setActionCommand("Show Branch");
        buttonShowBranch.addActionListener(this);
        Button buttonShowTables = new Button("Show Data");
        buttonShowTables.setActionCommand("Show Data");
        buttonShowTables.addActionListener(this);
        Button buttonExitBranch = new Button("Exit");
        buttonExitBranch.setActionCommand("Exit");
        buttonExitBranch.addActionListener(this);
        P.add(buttonShowBranch);
        P.add(buttonShowTables);
        P.add(buttonExitBranch);
        this.add(P);
        this.setBounds(550, 50, 210, 190);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                MMSVisualFrame.this.setVisible(false);
                MMSVisualFrame.this.dispose();
                MMSVisualFrame.this.MyStat.MyMMSFrame = null;
            }
        });
        this.setVisible(true);
    }

    public void chartSetUp() {
        if (MyYearlyDEMainChartFrame == null) {
            MyYearlyDEMainChartFrame = new YearlyDEMainChartFrame(this.applet, "YearlyTool Graphics");
        }
    }

    @Override
    public void paint(Graphics g) {
    }

    @Override
    public void keyPressed(KeyEvent event) {
        if (event.getKeyCode() == 27) {
            this.setVisible(false);
            this.dispose();
            this.MyStat.MyMMSFrame = null;
        }
    }

    @Override
    public void keyReleased(KeyEvent event) {
    }

    @Override
    public void keyTyped(KeyEvent event) {
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        Object obj = ev.getSource();
        String label = ev.getActionCommand();
        if (obj instanceof Button) {
            comp TempComponent;
            if (label.equals("Selected Branch")) {
                for (int ix = 0; ix < this.MyStat.ActSchematic.Components.size(); ++ix) {
                    TempComponent = (comp)this.MyStat.ActSchematic.Components.elementAt(ix);
                    if (!TempComponent.getvalid() || !TempComponent.getinservice() || !(TempComponent instanceof ndb_branch) || !TempComponent.isSelected()) continue;
                    this.MyChoiceBranch.select(TempComponent.getName());
                    return;
                }
            }
            if (label.equals("Show Branch")) {
                int rama = 0;
                int selected = -1;
                String con1 = "na";
                String con2 = "na";
                for (int ix = 0; ix < this.MyStat.ActSchematic.Components.size(); ++ix) {
                    TempComponent = (comp)this.MyStat.ActSchematic.Components.elementAt(ix);
                    if (!TempComponent.getvalid() || !TempComponent.getinservice() || !(TempComponent instanceof ndb_comp) || !(TempComponent instanceof ndb_branch)) continue;
                    if (TempComponent.getName().equals(this.MyChoiceBranch.getSelectedItem())) {
                        ndb_branch tb = (ndb_branch)TempComponent;
                        this.fmax = tb.getsmax();
                        selected = rama;
                        con1 = tb.getcon1();
                        con2 = tb.getcon2();
                        break;
                    }
                    ++rama;
                }
                String titulo = "Distribuci\u00f3n Flujos Rama " + this.MyChoiceBranch.getSelectedItem() + "  desde  " + con1 + "  hasta  " + con2 + "";
                double[][] puntos = new double[4][2];
                double media = 0.0;
                double desv = 0.0;
                if (!this.DB) {
                    puntos[0][0] = 0.0;
                    puntos[0][1] = 100.0 * this.MyStat.maxAllFlujo[rama];
                    puntos[1][0] = this.MyStat.tPAll[rama] / this.MyStat.simDuration[rama] * 100.0;
                    puntos[1][1] = 0.0;
                    puntos[2][0] = (this.MyStat.tPAll[rama] + this.MyStat.tCAll[rama]) / this.MyStat.simDuration[rama] * 100.0;
                    puntos[2][1] = 0.0;
                    puntos[3][0] = (this.MyStat.tPAll[rama] + this.MyStat.tCAll[rama] + this.MyStat.tNAll[rama]) / this.MyStat.simDuration[rama] * 100.0;
                    puntos[3][1] = 100.0 * this.MyStat.minAllFlujo[rama];
                    media = 100.0 * this.MyStat.acumAllFlujo[rama];
                    desv = 100.0 * Math.sqrt(this.MyStat.varAllFlujo[rama]);
                } else {
                    try {
                        Connection conYearlyStat = DeepEdit.OpenCSVasDB("DataBase");
                        Statement s = conYearlyStat.createStatement();
                        String mul = this.MyChoiceBranch.getSelectedItem();
                        ResultSet r = s.executeQuery("SELECT * FROM YearlyStatBranch.csv  WHERE Rama='" + mul + "'");
                        double sdur = 0.0;
                        r.next();
                        sdur = r.getDouble("Dur(h)");
                        puntos[0][0] = 0.0;
                        puntos[0][1] = r.getDouble("Flujo_Max(MW)");
                        double auxa = r.getDouble("Tiempo_Positivo(h)");
                        puntos[1][0] = auxa / sdur * 100.0;
                        puntos[1][1] = 0.0;
                        double auxc = r.getDouble("Tiempo_Cero(h)");
                        puntos[2][0] = puntos[1][0] + auxc / sdur * 100.0;
                        puntos[2][1] = 0.0;
                        double auxb = r.getDouble("Tiempo_Negativo(h)");
                        puntos[3][0] = puntos[2][0] + auxb / sdur * 100.0;
                        puntos[3][1] = r.getDouble("Flujo_Min(MW)");
                        media = r.getDouble("Flujo_Medio(MW)");
                        desv = r.getDouble("Desv(MW)");
                        conYearlyStat.commit();
                        conYearlyStat.close();
                    }
                    catch (Exception ee) {
                        ee.printStackTrace();
                        System.out.println("Error en Lectura de Estad\u00edsticas");
                        String message = ee.toString();
                    }
                }
                boolean casoq = false;
                if (Math.abs(puntos[0][0] - puntos[3][0]) < 1.0E-5) {
                    casoq = true;
                }
                if (!casoq) {
                    this.chartSetUp();
                    MyYearlyDEMainChartFrame.doStatTie(MyYearlyDEMainChartFrame, titulo, puntos, media, desv, this.fmax);
                    MyYearlyDEMainChartFrame = null;
                }
            }
            if (label.equals("Show Data")) {
                try {
                    DBReadTableFrame showCSV = new DBReadTableFrame("database", "Estad\u00edsticas de Flujo por Ramas", "YearlyStatBranch.csv", 400, 600, "No Importa");
                    DBReadTableFrame showCSV1 = new DBReadTableFrame("database", "Estad\u00edsticas de Generaci\u00f3n", "YearlyStatGen.csv", 400, 600, "No Importa");
                    DBReadTableFrame showCSV2 = new DBReadTableFrame("database", "Estad\u00edsticas de Demanda", "YearlyStatLoad.csv", 400, 600, "No Importa");
                }
                catch (Exception ee) {
                    ee.printStackTrace();
                    System.out.println("Error en Lectura de Estad\u00edsticas");
                    String message = ee.toString();
                }
            }
            if (label.equals("Exit")) {
                this.setVisible(false);
                this.dispose();
                this.MyStat.MyMMSVisualFrame = null;
            }
        }
    }
}

