/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import de.core.DeepEdit;
import de.core.MMS;
import de.core.MMSVisualFrame;
import de.core.SimpleDialog;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import javax.swing.ButtonGroup;
import javax.swing.JRadioButton;

class MMSFrame
extends Frame
implements KeyListener,
ActionListener {
    MMS MyStat;
    String ctrla;
    protected Font TextDialogFont;
    protected FontMetrics TextDialogFontMetrics;
    Choice MyChoiceCtrla = null;
    Choice MyChoiceSDY = null;
    Choice MyChoiceEDY = null;
    Choice MyChoiceSDM = null;
    Choice MyChoiceEDM = null;
    Choice MyChoiceSDB = null;
    Choice MyChoiceEDB = null;
    Choice MyChoiceSDH = null;
    Choice MyChoiceEDH = null;
    Choice MyChoicetole = null;
    int InitialYearDB = -1;
    int InitialMonthDB = -1;
    int FinalYearDB = -1;
    int FinalMonthDB = -1;
    int BlockNumberDB = -1;
    int HydroNumberDB = -1;
    int YearNumberDB = -1;
    Checkbox reporte;
    Checkbox DBreporte;
    Checkbox graficos;
    JRadioButton flujoDC;
    JRadioButton flujoDClosses;
    JRadioButton flujoAC;
    String t1 = "1.0";
    String t01 = "0.1";
    String t001 = "0.01";
    int opDC = 0;
    double tolAC;

    public MMSFrame(MMS ms) {
        super("TPDB Calculation Options");
        int h;
        int b;
        int m;
        int y;
        try {
            Connection conTPDB = DeepEdit.OpenODBC_JDBCConnection("TPDB", true);
            Statement s = conTPDB.createStatement();
            ResultSet r4 = s.executeQuery("SELECT *\tFROM SimInfo");
            r4.next();
            this.InitialYearDB = r4.getInt("InitialYear");
            this.InitialMonthDB = r4.getInt("InitialMonth");
            this.YearNumberDB = r4.getInt("YearNumber");
            this.BlockNumberDB = r4.getInt("BlockNumber");
            this.HydroNumberDB = r4.getInt("HydroNumber");
            this.FinalYearDB = this.InitialYearDB + this.YearNumberDB - 1;
            this.FinalMonthDB = this.InitialMonthDB == 1 ? 12 : this.InitialMonthDB - 1;
            s.close();
            conTPDB.rollback();
            conTPDB.close();
        }
        catch (Exception e) {
            System.out.println("Error: al leer Base de Datos " + e);
            e.printStackTrace();
        }
        this.MyStat = ms;
        String[] mes = new String[12];
        this.setBackground(Color.lightGray);
        mes[0] = "Enero";
        mes[1] = "Febrero";
        mes[2] = "Marzo";
        mes[3] = "Abril";
        mes[4] = "Mayo";
        mes[5] = "Junio";
        mes[6] = "Julio";
        mes[7] = "Agosto";
        mes[8] = "Septiembre";
        mes[9] = "Octubre";
        mes[10] = "Noviembre";
        mes[11] = "Diciembre";
        this.ctrla = "ALL CONTROL AREAS";
        this.TextDialogFont = DeepEdit.TextFont;
        this.TextDialogFontMetrics = this.getFontMetrics(this.TextDialogFont);
        this.setFont(this.TextDialogFont);
        this.setLayout(new FlowLayout());
        Panel P = new Panel();
        P.setLayout(new GridLayout(30, 2));
        Label titel = new Label("CALCULATION OPTIONS");
        titel.setForeground(Color.blue);
        P.add(titel);
        P.add(new Label(" "));
        this.MyChoiceCtrla = new Choice();
        this.MyChoiceCtrla.addItem(this.ctrla);
        this.MyStat.ActSchematic.LoadCtrla(this.MyChoiceCtrla);
        P.add(new Label("Select Control Area"));
        P.add(this.MyChoiceCtrla);
        ButtonGroup mychDClf = new ButtonGroup();
        this.flujoDC = new JRadioButton("DC Load Flow for power in lines", true);
        this.flujoDC.setFont(this.TextDialogFont);
        mychDClf.add(this.flujoDC);
        P.add(this.flujoDC);
        P.add(new Label(" "));
        this.flujoDClosses = new JRadioButton("DC Load Flow with Ohmic losses", false);
        this.flujoDClosses.setFont(this.TextDialogFont);
        mychDClf.add(this.flujoDClosses);
        P.add(this.flujoDClosses);
        P.add(new Label(" "));
        this.flujoAC = new JRadioButton("AC Load Flow", false);
        this.flujoAC.setFont(this.TextDialogFont);
        P.add(this.flujoAC);
        P.add(new Label(" "));
        P.add(new Label("Tolerance Level AC Load Flow:"));
        this.MyChoicetole = new Choice();
        this.MyChoicetole.addItem(this.t1);
        this.MyChoicetole.addItem(this.t01);
        this.MyChoicetole.addItem(this.t001);
        P.add(this.MyChoicetole);
        this.reporte = new Checkbox("Make File Text Report", true);
        P.add(this.reporte);
        P.add(new Label(" "));
        this.DBreporte = new Checkbox("Make Data Base Report", true);
        P.add(this.DBreporte);
        P.add(new Label(" "));
        this.graficos = new Checkbox("Show Graphics", true);
        P.add(this.graficos);
        P.add(new Label(" "));
        Label aux = new Label(" Flows Information");
        aux.setForeground(Color.blue);
        P.add(aux);
        aux = new Label(" Year / Month / Block / Hydrology");
        aux.setForeground(Color.red);
        P.add(aux);
        aux = new Label(" First Flow : ");
        aux.setForeground(Color.blue);
        P.add(aux);
        aux = new Label(" " + this.InitialYearDB + " / " + this.InitialMonthDB + " / 1 / 1");
        aux.setForeground(Color.red);
        P.add(aux);
        aux = new Label(" Last Flow : ");
        aux.setForeground(Color.blue);
        P.add(aux);
        aux = new Label(" " + this.FinalYearDB + " / " + this.FinalMonthDB + " / " + this.BlockNumberDB + " / " + this.HydroNumberDB);
        aux.setForeground(Color.red);
        P.add(aux);
        P.add(new Label("FIRST DISTPATCH"));
        P.add(new Label(" "));
        this.MyChoiceSDY = new Choice();
        this.MyChoiceSDM = new Choice();
        this.MyChoiceSDB = new Choice();
        this.MyChoiceSDH = new Choice();
        for (y = this.InitialYearDB; y <= this.FinalYearDB; ++y) {
            this.MyChoiceSDY.addItem("" + y);
        }
        for (m = 0; m < 12; ++m) {
            this.MyChoiceSDM.addItem(mes[m]);
        }
        for (b = 0; b < this.BlockNumberDB; ++b) {
            this.MyChoiceSDB.addItem("" + (b + 1));
        }
        for (h = 0; h < this.HydroNumberDB; ++h) {
            this.MyChoiceSDH.addItem("" + (h + 1));
        }
        P.add(new Label("Initial Year"));
        P.add(this.MyChoiceSDY);
        P.add(new Label("Initial Month"));
        P.add(this.MyChoiceSDM);
        P.add(new Label("Initial Block"));
        P.add(this.MyChoiceSDB);
        P.add(new Label("Initial Hydro"));
        P.add(this.MyChoiceSDH);
        P.add(new Label("LAST DISTPATCH"));
        P.add(new Label(" "));
        this.MyChoiceEDY = new Choice();
        this.MyChoiceEDM = new Choice();
        this.MyChoiceEDB = new Choice();
        this.MyChoiceEDH = new Choice();
        for (y = this.InitialYearDB; y <= this.FinalYearDB; ++y) {
            this.MyChoiceEDY.addItem("" + y);
        }
        for (m = 0; m < 12; ++m) {
            this.MyChoiceEDM.addItem(mes[m]);
        }
        for (b = 0; b < this.BlockNumberDB; ++b) {
            this.MyChoiceEDB.addItem("" + (b + 1));
        }
        for (h = 0; h < this.HydroNumberDB; ++h) {
            this.MyChoiceEDH.addItem("" + (h + 1));
        }
        P.add(new Label("Final Year"));
        P.add(this.MyChoiceEDY);
        P.add(new Label("Final Month"));
        P.add(this.MyChoiceEDM);
        P.add(new Label("Final Block"));
        P.add(this.MyChoiceEDB);
        P.add(new Label("Final Hydro"));
        P.add(this.MyChoiceEDH);
        P.add(new Label(" "));
        P.add(new Label(" "));
        Button button1 = new Button("Calculate");
        button1.setActionCommand("Apply");
        button1.addActionListener(this);
        Button button2 = new Button(" Cancel ");
        button2.setActionCommand("Cancel");
        button2.addActionListener(this);
        P.add(button1);
        P.add(button2);
        P.add(new Label("   -----------------------------------------"));
        P.add(new Label("   -----------------------------------------"));
        titel = new Label("VISUALIZATION OPTIONS");
        titel.setForeground(Color.blue);
        P.add(titel);
        P.add(new Label(" "));
        Button button3 = new Button("GO");
        button3.setActionCommand("GO");
        button3.addActionListener(this);
        P.add(new Label("Visualizate Stored Results"));
        P.add(button3);
        this.add(P);
        this.setBounds(550, 50, 380, 615);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                MMSFrame.this.setVisible(false);
                MMSFrame.this.dispose();
                MMSFrame.this.MyStat.MyMMSFrame = null;
            }
        });
        this.setVisible(true);
    }

    @Override
    public void paint(Graphics g) {
    }

    @Override
    public void keyPressed(KeyEvent event) {
        if (event.getKeyCode() == 27) {
            this.setVisible(false);
            this.dispose();
            this.MyStat.MyMMSFrame = null;
        }
    }

    @Override
    public void keyReleased(KeyEvent event) {
    }

    @Override
    public void keyTyped(KeyEvent event) {
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        Object obj = ev.getSource();
        String label = ev.getActionCommand();
        if (obj instanceof TextField || obj instanceof Button) {
            if (label.equals("Apply") || obj instanceof TextField) {
                this.setVisible(false);
                try {
                    if (this.flujoDC.isSelected()) {
                        this.opDC = 1;
                        this.tolAC = Double.valueOf(this.MyChoicetole.getSelectedItem());
                        this.MyStat.Calculate(this.MyChoiceCtrla.getSelectedItem(), this.reporte.getState(), this.DBreporte.getState(), this.graficos.getState(), this.MyChoiceSDY.getSelectedItem(), this.MyChoiceSDM.getSelectedItem(), this.MyChoiceSDB.getSelectedItem(), this.MyChoiceSDH.getSelectedItem(), this.MyChoiceEDY.getSelectedItem(), this.MyChoiceEDM.getSelectedItem(), this.MyChoiceEDB.getSelectedItem(), this.MyChoiceEDH.getSelectedItem(), this.opDC, this.flujoAC.isSelected(), this.tolAC);
                    }
                    if (this.flujoDClosses.isSelected()) {
                        this.opDC = 2;
                        this.tolAC = Double.valueOf(this.MyChoicetole.getSelectedItem());
                        this.MyStat.Calculate(this.MyChoiceCtrla.getSelectedItem(), this.reporte.getState(), this.DBreporte.getState(), this.graficos.getState(), this.MyChoiceSDY.getSelectedItem(), this.MyChoiceSDM.getSelectedItem(), this.MyChoiceSDB.getSelectedItem(), this.MyChoiceSDH.getSelectedItem(), this.MyChoiceEDY.getSelectedItem(), this.MyChoiceEDM.getSelectedItem(), this.MyChoiceEDB.getSelectedItem(), this.MyChoiceEDH.getSelectedItem(), this.opDC, this.flujoAC.isSelected(), this.tolAC);
                    }
                }
                catch (Exception e) {
                    String message = e.toString();
                    String[] DlgButtons = new String[]{"Apply"};
                    SimpleDialog ExceptionDialog = new SimpleDialog(DeepEdit.frame, "Reading TP GGDF Parameter Information", message, DlgButtons, 1, 0, 0, 1);
                    e.printStackTrace();
                }
            } else if (label.equals("GO")) {
                MMS Mul = new MMS(this.MyStat.ActSchematic, true);
                MMSVisualFrame MyMMSVisualFrame = new MMSVisualFrame(Mul, true);
            }
            this.dispose();
            this.MyStat.MyMMSFrame = null;
        }
    }
}

