/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import de.core.AnalysisTool;
import de.core.Busbar;
import de.core.DEMainChartFrame;
import de.core.DeepEdit;
import de.core.DeepEditFrame;
import de.core.MMCorrelation;
import de.core.MMCredibility;
import de.core.MMMarketController;
import de.core.MMMarketShare;
import de.core.MMReservoirLevel;
import de.core.MMS2Frame;
import de.core.MMSpotPrice;
import de.core.MMTool;
import de.core.PieChartFrame;
import de.core.Schematic;
import de.core.StackedChartFrame;
import de.core.StripChartFrame;
import de.core.hdb_res;
import de.core.mdb_act;
import de.data.DE_GeneralEnums;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;

public class MMS2
extends AnalysisTool {
    public MMS2Frame MyMMS2Frame = null;
    public DeepEdit deepEdApp;
    public DEMainChartFrame MyDEMCF;
    protected int dbinitialyear;
    protected int dbinitialmonth;
    protected int dbfinalyear;
    protected int dbfinalmonth;
    protected int auxinitialyear;
    protected int auxinitialmonth;
    protected int auxfinalyear;
    protected int auxfinalmonth;
    protected int initialyear;
    protected int initialmonth;
    protected int finalyear;
    protected int finalmonth;
    protected MMSpotPrice MyMMSpotPrice;
    protected Busbar[] busbars;
    protected boolean spotprice;
    protected boolean cronological;
    protected boolean duration;
    protected boolean spotaverage;
    protected boolean spotestdesv;
    protected boolean spcompareperiods;
    double[][] spresults;
    double[][] spcompared;
    String[] spcomparednames;
    protected MMReservoirLevel MyMMReservoirLevel;
    protected hdb_res[] reservoirs;
    protected boolean reservoirlevel;
    protected boolean reservoircronological;
    protected boolean rlcompareperiods;
    protected double[][] rlresults;
    public double[][] rlcompared;
    public String[] rlcomparednames;
    protected MMMarketShare MyMMMarketShare;
    protected mdb_act[] actors;
    protected boolean marketshare;
    protected String fuel = "all";
    protected boolean controller;
    protected boolean capInst;
    protected boolean enGen;
    protected boolean marketpie;
    protected boolean marketcronological;
    protected boolean marketaverage;
    protected boolean marketestdesv;
    protected boolean mscompareperiods;
    protected double[][] msresults;
    public double[][] mscompared;
    public String[] mscomparednames;
    protected MMCredibility MyMMCredibility;
    protected mdb_act[] cactors;
    protected boolean credibilityindex;
    protected boolean cicronological;
    protected boolean cindex;
    protected boolean cicontroller;
    protected boolean callactors = false;
    protected double[][][] cresults;
    protected double[][] cresults2;
    protected double[][] cresults2b;
    protected MMCorrelation MyMMCorrelation;
    protected boolean analysis;
    protected boolean printav;
    protected boolean printcorr;
    protected boolean printcov;
    protected boolean printdev;

    public MMS2(Schematic sch, DeepEdit aapplet) {
        super(sch);
        this.deepEdApp = aapplet;
        System.out.println("---------- Market Monitoring ------------");
        this.initialyear = 0;
        this.initialmonth = 0;
        this.finalyear = 0;
        this.finalmonth = 0;
        try {
            Statement stmt = DeepEditFrame.conMMS.createStatement();
            ResultSet rs = stmt.executeQuery("SELECT firstyear, firstmonth, lastyear, lastmonth FROM general_information");
            rs.next();
            this.dbinitialyear = rs.getInt("firstyear");
            this.dbinitialmonth = rs.getInt("firstmonth");
            this.dbfinalyear = rs.getInt("lastyear");
            this.dbfinalmonth = rs.getInt("lastmonth");
        }
        catch (Exception e) {
            System.out.println("Exception: " + e);
        }
        this.initialyear = this.ActSchematic.iniperiod;
        this.initialmonth = this.ActSchematic.inimonth;
        this.finalyear = this.ActSchematic.endperiod;
        this.finalmonth = this.ActSchematic.endmonth;
        DeepEdit.frame.chartSetUp();
        this.MyDEMCF = DeepEditFrame.myMChartFrame;
        DeepEdit.frame.PowerEditorMenuItem.setEnabled(true);
        DeepEdit.frame.HydroEditorMenuItem.setEnabled(true);
        DeepEdit.frame.MarketEditorMenuItem.setEnabled(false);
        DeepEdit.frame.HydroMenu.setEnabled(false);
        DeepEdit.frame.NetworkMenu.setEnabled(false);
        DeepEdit.frame.MarketMenu.setEnabled(true);
        DeepEdit.MySchematicPanel.GridXOffsetPower = DeepEdit.MySchematicPanel.GridXOffset;
        DeepEdit.MySchematicPanel.GridYOffsetPower = DeepEdit.MySchematicPanel.GridYOffset;
        DeepEdit.MySchematicPanel.myHorizontal.setValue(DeepEdit.MySchematicPanel.GridXOffsetMarket);
        DeepEdit.MySchematicPanel.myVertical.setValue(DeepEdit.MySchematicPanel.GridYOffsetMarket);
        MMS2 mMS2 = this;
        DeepEdit.GridStepPower = mMS2.deepEdApp.getGridStep();
        this.deepEdApp.setGridStep(DeepEdit.GridStepMarket);
        DeepEdit.MySchematicPanel.AdjustScrollbars();
        DeepEdit.MySchematicPanel.CheckDimensions();
        this.deepEdApp.setEditor(DE_GeneralEnums.editor.Market);
        if (this.MyMMS2Frame == null) {
            this.MyMMS2Frame = new MMS2Frame(this);
        } else {
            this.MyMMS2Frame.setVisible(true);
        }
    }

    public void monitor() {
        int j;
        int i;
        int ele;
        int j2;
        int i2;
        int k;
        boolean[] existe;
        Vector cols;
        try {
            DeepEditFrame.conMMS.close();
            DeepEditFrame.conMMS = DeepEdit.OpenODBC_JDBCConnection("MMS", true);
        }
        catch (SQLException e) {
            System.out.println("Error: " + e);
        }
        String aux = " ";
        if (this.dbfinalyear < this.initialyear || this.dbfinalyear == this.initialyear && this.dbfinalmonth < this.initialmonth || this.dbinitialyear > this.finalyear || this.dbinitialyear == this.finalyear && this.dbinitialmonth > this.finalmonth) {
            aux = "Dates are out of database range. ";
            if (this.reservoirlevel) {
                this.reservoirlevel = false;
                aux = aux + "\nReservoir level will not be monitored. ";
            }
            if (this.spotprice) {
                this.spotprice = false;
                aux = aux + "\nSpot price will not be monitored. ";
            }
            if (this.marketshare) {
                this.marketshare = false;
                aux = aux + "\nMarket share will not be monitored.";
            }
            System.out.println(aux);
        }
        this.auxinitialyear = Math.max(this.initialyear, this.dbinitialyear);
        this.auxinitialmonth = this.initialyear == this.dbinitialyear ? Math.max(this.initialmonth, this.dbinitialmonth) : (this.initialyear < this.dbinitialyear ? this.dbinitialmonth : this.initialmonth);
        this.auxfinalyear = Math.min(this.finalyear, this.dbfinalyear);
        this.auxfinalmonth = this.finalyear == this.dbfinalyear && this.finalmonth > this.dbfinalmonth ? this.dbfinalmonth : (this.finalyear > this.dbfinalyear ? this.dbfinalmonth : this.finalmonth);
        if (this.reservoirlevel && this.reservoirs != null) {
            cols = MMTool.getColumns(DeepEditFrame.conMMS, "cotas");
            existe = new boolean[this.reservoirs.length];
            k = 0;
            for (i2 = 0; i2 < this.reservoirs.length; ++i2) {
                existe[i2] = false;
                for (j2 = 0; j2 < cols.size(); ++j2) {
                    String aux2 = (String)cols.elementAt(j2);
                    if (!this.reservoirs[i2].getName().equals(aux2)) continue;
                    existe[i2] = true;
                    ++k;
                }
                if (existe[i2]) continue;
                System.out.println("Reservoir " + this.reservoirs[i2].getName() + " not founded in MMS database and will not be monitored");
            }
            if (k == 0) {
                this.reservoirs = null;
                this.reservoirlevel = false;
                System.out.println("None of the reservoirs selected where in MMS database. \nReservoir level monitor will now stop.");
            } else {
                hdb_res[] auxreservoirs = new hdb_res[k];
                ele = 0;
                for (int i3 = 0; i3 < existe.length; ++i3) {
                    if (existe[i3]) {
                        auxreservoirs[ele] = this.reservoirs[i3];
                    }
                    ++ele;
                }
                this.reservoirs = auxreservoirs;
            }
        }
        if (this.spotprice && this.busbars != null) {
            cols = MMTool.getColumns(DeepEditFrame.conMMS, "cmg");
            existe = new boolean[this.busbars.length];
            k = 0;
            for (i2 = 0; i2 < this.busbars.length; ++i2) {
                existe[i2] = false;
                for (j2 = 0; j2 < cols.size(); ++j2) {
                    String aux2 = (String)cols.elementAt(j2);
                    if (!this.busbars[i2].getName().equals(aux2)) continue;
                    existe[i2] = true;
                    ++k;
                }
                if (existe[i2]) continue;
                System.out.println("Busbar " + this.busbars[i2].getName() + " not founded in MMS database and will not be monitored");
            }
            if (k == 0) {
                this.busbars = null;
                this.spotprice = false;
                System.out.println("None of the busbars selected where in MMS database. \nSpot price monitor will now stop.");
            } else {
                Busbar[] auxbusbars = new Busbar[k];
                ele = 0;
                for (int i4 = 0; i4 < existe.length; ++i4) {
                    if (existe[i4]) {
                        auxbusbars[ele] = this.busbars[i4];
                    }
                    ++ele;
                }
                this.busbars = auxbusbars;
            }
        }
        MMMarketController MyMMMarketController = null;
        if (this.marketshare || this.credibilityindex) {
            MyMMMarketController = new MMMarketController(this.ActSchematic, this.deepEdApp);
        }
        if (this.reservoirlevel && this.reservoirs != null) {
            this.rlresults = new double[MMTool.dateday(this.auxinitialyear, this.auxinitialmonth, this.auxfinalyear, this.auxfinalmonth).length][this.reservoirs.length];
            this.MyMMReservoirLevel = new MMReservoirLevel(this.ActSchematic, this.deepEdApp, "nodraw");
            this.MyMMReservoirLevel.reservoirs = this.reservoirs;
        }
        if (this.spotprice && this.busbars != null) {
            this.spresults = new double[MMTool.datehour(this.auxinitialyear, this.auxinitialmonth, this.auxfinalyear, this.auxfinalmonth).length][this.busbars.length];
            this.MyMMSpotPrice = new MMSpotPrice(this.ActSchematic, this.deepEdApp, "nodraw");
            this.MyMMSpotPrice.busbars = this.busbars;
        }
        if (this.marketshare) {
            int debugg1 = MMTool.dateday(this.auxinitialyear, this.auxinitialmonth, this.auxfinalyear, this.auxfinalmonth).length;
            this.msresults = this.actors == null ? new double[debugg1][1] : new double[debugg1][this.actors.length];
            this.MyMMMarketShare = new MMMarketShare(this.ActSchematic, this.deepEdApp, this.fuel);
            this.MyMMMarketShare.actors = this.actors;
            this.MyMMMarketShare.capInst = this.capInst;
            this.MyMMMarketShare.enGen = this.enGen;
            this.MyMMMarketShare.controller = this.controller;
        }
        if (this.credibilityindex && this.cactors != null) {
            int debugg1;
            if (!this.callactors) {
                debugg1 = MMTool.datemonth(this.initialyear, this.initialmonth, this.finalyear, this.finalmonth).length;
                this.cresults = new double[debugg1][this.cactors.length][MMTool.invstate().length];
                this.cresults2 = new double[debugg1][2];
                this.cresults2b = new double[debugg1][1];
            } else {
                debugg1 = MMTool.datemonth(this.initialyear, this.initialmonth, this.finalyear, this.finalmonth).length;
                this.cresults = new double[debugg1][1][MMTool.invstate().length];
                this.cresults2 = new double[debugg1][2];
                this.cresults2b = new double[debugg1][1];
            }
            this.MyMMCredibility = new MMCredibility(this.ActSchematic, this.deepEdApp, "different");
            this.MyMMCredibility.actors = this.cactors;
            this.MyMMCredibility.controller = this.cicontroller;
        }
        block8: for (i = this.initialyear; i <= this.finalyear; ++i) {
            for (j = 1; j <= 12; ++j) {
                if (i == this.initialyear && j == 1) {
                    j = this.initialmonth;
                }
                if (i == this.finalyear && j == this.finalmonth + 1) continue block8;
                if (!this.credibilityindex || this.cactors == null) continue;
                MyMMMarketController.ActYear = i;
                MyMMMarketController.ActMonth = j;
                MyMMMarketController.setcontroller();
                this.MyMMCredibility.ActYear = i;
                this.MyMMCredibility.ActMonth = j;
                this.MyMMCredibility.Calculate();
                this.addResults(this.MyMMCredibility.results3, this.cresults);
                this.addResults(this.MyMMCredibility.results2b, this.cresults2b);
            }
        }
        block10: for (i = this.auxinitialyear; i <= this.auxfinalyear; ++i) {
            for (j = 1; j <= 12; ++j) {
                if (i == this.auxinitialyear && j == 1) {
                    j = this.auxinitialmonth;
                }
                if (i == this.auxfinalyear && j == this.auxfinalmonth + 1) continue block10;
                if (this.reservoirlevel && this.reservoirs != null) {
                    this.MyMMReservoirLevel.ActYear = i;
                    this.MyMMReservoirLevel.ActMonth = j;
                    this.MyMMReservoirLevel.Calculate();
                    this.addResults(this.MyMMReservoirLevel.results2, this.rlresults);
                }
                if (this.spotprice && this.busbars != null) {
                    this.MyMMSpotPrice.ActYear = i;
                    this.MyMMSpotPrice.ActMonth = j;
                    this.MyMMSpotPrice.Calculate();
                    this.addResults(this.MyMMSpotPrice.results2, this.spresults);
                }
                if (!this.marketshare) continue;
                this.MyMMMarketShare.ActYear = i;
                this.MyMMMarketShare.ActMonth = j;
                this.MyMMMarketShare.Calculate();
                this.addResults(this.MyMMMarketShare.results2, this.msresults);
            }
        }
        if (this.credibilityindex && this.cactors != null) {
            this.cresults2 = MMCredibility.credibility(this.cresults, this.cresults2b);
        }
        if (this.reservoirlevel && this.rlcompareperiods) {
            this.rlcompareyears();
        }
        if (this.spotprice && this.spcompareperiods) {
            this.spcompareyears();
        }
        if (this.marketshare && this.mscompareperiods) {
            this.mscompareyears();
        }
        if (this.analysis && (this.reservoirlevel || this.marketshare || this.spotprice)) {
            this.MyMMCorrelation = new MMCorrelation(this.ActSchematic, this.deepEdApp, "nodraw");
            double[][] merged = null;
            String[] mergednames = null;
            if (this.spotprice) {
                double[][] aux2 = MMTool.hourly2dayly(this.spresults);
                if (merged == null) {
                    merged = new double[aux2.length][0];
                    mergednames = new String[]{};
                }
                merged = MMTool.merge(merged, aux2);
                mergednames = MMTool.mergenames(mergednames, this.MyMMSpotPrice.Names);
            }
            if (this.marketshare) {
                if (merged == null) {
                    merged = new double[this.msresults.length][0];
                    mergednames = new String[]{};
                }
                merged = MMTool.merge(merged, this.msresults);
                mergednames = MMTool.mergenames(mergednames, this.MyMMMarketShare.Names);
            }
            if (this.reservoirlevel) {
                if (merged == null) {
                    merged = new double[this.rlresults.length][0];
                    mergednames = new String[]{};
                }
                merged = MMTool.merge(merged, this.rlresults);
                mergednames = MMTool.mergenames(mergednames, this.MyMMReservoirLevel.Names);
            }
            this.MyMMCorrelation.data = merged;
            this.MyMMCorrelation.Names = mergednames;
            this.MyMMCorrelation.Calculate();
            System.out.println("");
            System.out.println("----------- Analysis Tools ------------");
            if (this.printav) {
                System.out.println("");
                System.out.println("Average");
                MMTool.mostrar(this.MyMMCorrelation.Names, this.MyMMCorrelation.average);
            }
            if (this.printcorr) {
                System.out.println("");
                System.out.println("Correlation Matrix");
                System.out.print("\t");
                MMTool.mostrar(this.MyMMCorrelation.Names);
                MMTool.mostrar(this.MyMMCorrelation.Names, this.MyMMCorrelation.correlation);
            }
            if (this.printcov) {
                System.out.println("");
                System.out.println("Covariance Matrix");
                System.out.print("\t");
                MMTool.mostrar(this.MyMMCorrelation.Names);
                MMTool.mostrar(this.MyMMCorrelation.Names, this.MyMMCorrelation.covariance);
            }
            if (this.printdev) {
                System.out.println("");
                System.out.println("Standard Deviation");
                MMTool.mostrar(this.MyMMCorrelation.Names, this.MyMMCorrelation.estdesv);
            }
        }
        if (this.reservoirlevel && this.reservoirs != null) {
            String comentario = this.auxinitialyear + "/" + this.auxinitialmonth + " to " + this.auxfinalyear + "/" + this.auxfinalmonth;
            if (this.reservoircronological) {
                StripChartFrame graf1 = new StripChartFrame("Reservoir Level", this.rlresults, this.MyMMReservoirLevel.Names, comentario, MMTool.dateday(this.auxinitialyear, this.auxinitialmonth, this.auxfinalyear, this.auxfinalmonth), "Date", "msnm");
                graf1.maxext = this.MyMMReservoirLevel.maximo;
                graf1.minext = this.MyMMReservoirLevel.minimo;
                graf1.eliminaceros = true;
                graf1.actualizar(this.rlresults, " ");
                this.MyDEMCF.addChart("Reservoir Level", graf1.getChart(), comentario);
            }
            if (this.rlcompareperiods) {
                StripChartFrame graf7 = new StripChartFrame("Reservoir Level: " + this.MyMMReservoirLevel.Names[0], this.rlcompared, this.rlcomparednames, comentario, MMTool.datedaymonth(this.auxinitialyear, 1, this.auxinitialyear, 12), "Date", "msnm");
                graf7.maxext = this.MyMMReservoirLevel.maximo;
                graf7.minext = this.MyMMReservoirLevel.minimo;
                graf7.eliminaceros = true;
                graf7.actualizar(this.rlcompared, " ");
                int indice = this.rlresults.length - 365 * (this.rlcompared[0].length - 1) - 1;
                double rldifference = (this.rlcompared[indice][this.rlcompared[0].length - 1] - this.rlcompared[indice][this.rlcompared[0].length - 2]) / (this.rlcompared[indice][this.rlcompared[0].length - 2] - this.MyMMReservoirLevel.minimo[0]) * 100.0;
                this.MyDEMCF.addChart("Reservoir Level: " + this.MyMMReservoirLevel.Names[0], graf7.getChart(), comentario + " Difference (with last period): " + MMTool.round(rldifference, 1) + "%");
            }
        }
        if (this.spotprice && this.busbars != null) {
            String comentario = this.auxinitialyear + "/" + this.auxinitialmonth + " to " + this.auxfinalyear + "/" + this.auxfinalmonth;
            if (this.cronological) {
                StripChartFrame graf2 = new StripChartFrame("Spot Price", this.spresults, this.MyMMSpotPrice.Names, comentario, MMTool.datehour(this.auxinitialyear, this.auxinitialmonth, this.auxfinalyear, this.auxfinalmonth), "Date", "US$/MWh");
                if (this.spotaverage) {
                    graf2.promedio = MMTool.promedio(this.spresults);
                    graf2.prom = true;
                }
                if (this.spotestdesv) {
                    graf2.desvestarriba = MMTool.dearriba(this.spresults);
                    graf2.desvestabajo = MMTool.deabajo(this.spresults);
                    graf2.de = true;
                }
                graf2.actualizar(this.spresults, " ");
                this.MyDEMCF.addChart("Spot Price", graf2.getChart(), comentario);
            }
            if (this.duration) {
                StripChartFrame graf3 = new StripChartFrame("Price Duration Curve", MMTool.sort(this.spresults), this.MyMMSpotPrice.Names, comentario, MMTool.percentLabel(this.spresults), "%", "US$/MWh");
                if (this.spotaverage) {
                    graf3.promedio = MMTool.promedio(this.spresults);
                    graf3.prom = true;
                }
                if (this.spotestdesv) {
                    graf3.desvestarriba = MMTool.dearriba(this.spresults);
                    graf3.desvestabajo = MMTool.deabajo(this.spresults);
                    graf3.de = true;
                }
                graf3.actualizar(MMTool.sort(this.spresults), " ");
                this.MyDEMCF.addChart("Spot Price", graf3.getChart(), comentario);
            }
            if (this.spcompareperiods) {
                StripChartFrame graf8 = new StripChartFrame("Spot Price: " + this.MyMMSpotPrice.Names[0], this.spcompared, this.spcomparednames, comentario, MMTool.datehourwithoutyear(this.auxinitialyear, 1, this.auxinitialyear, 12), "Date", "US$/MWh");
                if (this.spotaverage) {
                    graf8.promedio = MMTool.promedio(this.spcompared);
                    graf8.prom = true;
                }
                if (this.spotestdesv) {
                    graf8.desvestarriba = MMTool.dearriba(this.spcompared);
                    graf8.desvestabajo = MMTool.deabajo(this.spcompared);
                    graf8.de = true;
                }
                graf8.actualizar(this.spcompared, " ");
                this.MyDEMCF.addChart("Spot Price: " + this.MyMMSpotPrice.Names[0], graf8.getChart(), comentario);
            }
        }
        if (this.marketshare) {
            String comentario = this.auxinitialyear + "/" + this.auxinitialmonth + " to " + this.auxfinalyear + "/" + this.auxfinalmonth + "   HHI:" + MMTool.round(MMTool.HHI(this.msresults), 1);
            String titulo = this.enGen ? "Market Share: MWh" : "Market Share: MW";
            if (this.marketpie) {
                PieChartFrame graf4 = new PieChartFrame(titulo, this.msresults, this.MyMMMarketShare.Names, comentario);
                graf4.postfix = this.enGen ? "MWh" : "MW";
                graf4.actualizar(this.msresults, " ");
                this.MyDEMCF.addChart("Market Share", graf4.getChart(), comentario);
            }
            if (this.marketcronological) {
                StripChartFrame graf5 = new StripChartFrame("Market Share", this.msresults, this.MyMMMarketShare.Names, comentario, MMTool.dateday(this.auxinitialyear, this.auxinitialmonth, this.auxfinalyear, this.auxfinalmonth), "Date", "MWh");
                if (this.marketaverage) {
                    graf5.promedio = MMTool.promedio(this.msresults);
                    graf5.prom = true;
                }
                if (this.marketestdesv) {
                    graf5.desvestarriba = MMTool.dearriba(this.msresults);
                    graf5.desvestabajo = MMTool.deabajo(this.msresults);
                    graf5.de = true;
                }
                graf5.actualizar(this.msresults, " ");
                this.MyDEMCF.addChart("Market Share", graf5.getChart(), comentario);
            }
            if (this.mscompareperiods) {
                StripChartFrame graf9 = new StripChartFrame("Market Share: " + this.MyMMMarketShare.Names[0], this.mscompared, this.mscomparednames, comentario, MMTool.dateday(this.auxinitialyear, this.auxinitialmonth, this.auxfinalyear, this.auxfinalmonth), "Date", "MWh");
                if (this.marketaverage) {
                    graf9.promedio = MMTool.promedio(this.mscompared);
                    graf9.prom = true;
                }
                if (this.marketestdesv) {
                    graf9.desvestarriba = MMTool.dearriba(this.mscompared);
                    graf9.desvestabajo = MMTool.deabajo(this.mscompared);
                    graf9.de = true;
                }
                graf9.actualizar(this.mscompared, " ");
                this.MyDEMCF.addChart("Market Share: " + this.MyMMMarketShare.Names[0], graf9.getChart(), comentario + "  Growth (last 2 periods): " + MMTool.crecimiento(this.mscompared) + "%");
            }
        }
        if (this.credibilityindex && this.cactors != null && this.cicronological) {
            String comentario = this.initialmonth + "/" + this.initialyear + " to " + this.finalmonth + "/" + this.finalyear;
            String titulo = "";
            for (int i5 = 0; i5 < this.MyMMCredibility.Names.length; ++i5) {
                titulo = i5 == this.MyMMCredibility.Names.length - 1 ? titulo + this.MyMMCredibility.Names[i5] : titulo + this.MyMMCredibility.Names[i5] + " + ";
            }
            StackedChartFrame graf6 = new StackedChartFrame(titulo, this.cresults, MMTool.invstate(), comentario, MMTool.datemonth(this.initialyear, this.initialmonth, this.finalyear, this.finalmonth), "Date", "MW");
            graf6.valor2b = this.cresults2b;
            graf6.fann = true;
            graf6.indicefecha = MMTool.datemonth(this.initialyear, this.initialmonth, this.ActSchematic.actperiod, this.ActSchematic.actmonth).length - 1;
            graf6.fa = true;
            if (this.cindex) {
                graf6.valor = this.cresults2;
                graf6.cred = true;
                comentario = comentario + " CI Today: " + this.cresults2[graf6.indicefecha][0];
            }
            graf6.actualizar(this.cresults, "%");
            this.MyDEMCF.addChart("Installed Capacity", graf6.getChart(), comentario);
        }
        this.initialyear = this.ActSchematic.iniperiod;
        this.initialmonth = this.ActSchematic.inimonth;
        this.finalyear = this.ActSchematic.endperiod;
        this.finalmonth = this.ActSchematic.endmonth;
    }

    public void rlcompareyears() {
        int i;
        int periodos = this.auxfinalyear - this.auxinitialyear + 1;
        this.rlcompared = new double[365][periodos];
        this.rlcomparednames = new String[periodos];
        int k = MMTool.dateday(this.auxinitialyear, 1, this.auxinitialyear, this.auxinitialmonth - 1).length;
        for (i = 0; i < this.rlresults.length; ++i) {
            for (int p = 0; p < periodos; ++p) {
                if (k < MMTool.dateday(this.auxinitialyear, 1, this.auxinitialyear + p - 1, 12).length || k >= MMTool.dateday(this.auxinitialyear, 1, this.auxinitialyear + p, 12).length) continue;
                this.rlcompared[k - p * 365][p] = this.rlresults[i][0];
            }
            ++k;
        }
        for (i = 0; i < this.rlcomparednames.length; ++i) {
            this.rlcomparednames[i] = "" + (this.auxinitialyear + i);
        }
    }

    public void spcompareyears() {
        int i;
        int periodos = this.auxfinalyear - this.auxinitialyear + 1;
        this.spcompared = new double[8760][periodos];
        this.spcomparednames = new String[periodos];
        int k = 24 * MMTool.dateday(this.auxinitialyear, 1, this.auxinitialyear, this.auxinitialmonth - 1).length;
        System.out.println("k: " + k);
        for (i = 0; i < this.spresults.length; ++i) {
            for (int p = 0; p < periodos; ++p) {
                if (k < 24 * MMTool.dateday(this.auxinitialyear, 1, this.auxinitialyear + p - 1, 12).length || k >= 24 * MMTool.dateday(this.auxinitialyear, 1, this.auxinitialyear + p, 12).length) continue;
                this.spcompared[k - p * 365 * 24][p] = this.spresults[i][0];
            }
            ++k;
        }
        for (i = 0; i < this.spcomparednames.length; ++i) {
            this.spcomparednames[i] = "" + (this.auxinitialyear + i);
        }
    }

    public void mscompareyears() {
        int i;
        int periodos = this.auxfinalyear - this.auxinitialyear + 1;
        this.mscompared = new double[365][periodos];
        this.mscomparednames = new String[periodos];
        int k = MMTool.dateday(this.auxinitialyear, 1, this.auxinitialyear, this.auxinitialmonth - 1).length;
        System.out.println("k: " + k);
        for (i = 0; i < this.msresults.length; ++i) {
            for (int p = 0; p < periodos; ++p) {
                if (k < MMTool.dateday(this.auxinitialyear, 1, this.auxinitialyear + p - 1, 12).length || k >= MMTool.dateday(this.auxinitialyear, 1, this.auxinitialyear + p, 12).length) continue;
                this.mscompared[k - p * 365][p] = this.msresults[i][0];
            }
            ++k;
        }
        for (i = 0; i < this.mscomparednames.length; ++i) {
            this.mscomparednames[i] = "" + (this.auxinitialyear + i);
        }
    }

    private void addResults(double[][] newresults, double[][] results) {
        int j;
        int i;
        double[][] temp = new double[results.length][results[0].length];
        for (i = 0; i < results.length; ++i) {
            for (j = 0; j < results[0].length; ++j) {
                temp[i][j] = results[i][j];
            }
        }
        for (i = 0; i < results.length - newresults.length; ++i) {
            for (j = 0; j < results[0].length; ++j) {
                results[i][j] = temp[i + newresults.length][j];
            }
        }
        for (i = results.length - newresults.length; i < results.length; ++i) {
            for (j = 0; j < results[0].length; ++j) {
                results[i][j] = newresults[i - results.length + newresults.length][j];
            }
        }
    }

    private void addResults(double[][][] newresults, double[][][] results) {
        int k;
        int j;
        int i;
        double[][][] temp = new double[results.length][results[0].length][results[0][0].length];
        for (i = 0; i < results.length; ++i) {
            for (j = 0; j < results[0].length; ++j) {
                for (k = 0; k < results[0][0].length; ++k) {
                    temp[i][j][k] = results[i][j][k];
                }
            }
        }
        for (i = 0; i < results.length - newresults.length; ++i) {
            for (j = 0; j < results[0].length; ++j) {
                for (k = 0; k < results[0][0].length; ++k) {
                    results[i][j][k] = temp[i + newresults.length][j][k];
                }
            }
        }
        for (i = results.length - newresults.length; i < results.length; ++i) {
            for (j = 0; j < results[0].length; ++j) {
                for (k = 0; k < results[0][0].length; ++k) {
                    results[i][j][k] = newresults[i - results.length + newresults.length][j][k];
                }
            }
        }
    }
}

