/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import de.core.DEMainChartFrame;
import de.core.DeepEdit;
import de.core.DeepEditFrame;
import de.core.MMReservoirLevelFrame;
import de.core.MMTool;
import de.core.Schematic;
import de.core.StripChartFrame;
import de.core.hdb_res;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class MMReservoirLevel
extends MMTool {
    protected MMReservoirLevelFrame MyMMReservoirLevelFrame;
    protected boolean mustdraw;
    protected double[] maximo;
    protected double[] minimo;
    protected DEMainChartFrame MyDEMCF;
    protected hdb_res[] reservoirs;

    public MMReservoirLevel(Schematic sch, DeepEdit applet) {
        super(sch, applet);
        System.out.println("------ Reservoir Level ------");
        this.mustdraw = true;
        DeepEdit.frame.chartSetUp();
        this.MyDEMCF = DeepEditFrame.myMChartFrame;
        if (this.MyMMReservoirLevelFrame == null) {
            this.MyMMReservoirLevelFrame = new MMReservoirLevelFrame(this, this.ActDeepEdit);
        } else {
            this.MyMMReservoirLevelFrame.setVisible(true);
        }
    }

    public MMReservoirLevel(Schematic sch, DeepEdit applet, String different) {
        super(sch, applet);
        System.out.println("------ Reservoir Level ------");
        this.mustdraw = false;
    }

    public void Calculate() {
        int i;
        try {
            DeepEditFrame.conMMS.close();
            DeepEditFrame.conMMS = DeepEdit.OpenODBC_JDBCConnection("MMS", true);
        }
        catch (SQLException e) {
            System.out.println("Error: " + e);
        }
        this.Names = new String[this.reservoirs.length];
        this.maximo = new double[this.reservoirs.length];
        this.minimo = new double[this.reservoirs.length];
        for (i = 0; i < this.reservoirs.length; ++i) {
            this.Names[i] = this.reservoirs[i].getName();
        }
        this.results2 = new double[MMTool.days(this.ActMonth, this.ActYear)][this.reservoirs.length];
        for (i = 0; i < this.reservoirs.length; ++i) {
            try {
                this.results2 = MMTool.setcolumn(this.results2, i, this.levelDatabase(this.reservoirs[i].getName()));
                this.maximo[i] = this.maxDatabase(this.reservoirs[i].getName());
                this.minimo[i] = this.minDatabase(this.reservoirs[i].getName());
                continue;
            }
            catch (SQLException e) {
                System.out.println("Exception: " + e);
            }
        }
        if (this.mustdraw) {
            StripChartFrame graf1 = new StripChartFrame("Reservoir Level", this.results2, this.Names, this.month[this.ActMonth - 1] + "/" + this.ActYear, MMTool.dateday(this.ActYear, this.ActMonth, this.ActYear, this.ActMonth), "Date", "msnm");
            this.MyDEMCF.addChart("Reservoir Level", graf1.getChart(), this.month[this.ActMonth - 1] + "/" + this.ActYear);
        }
    }

    private double[] levelDatabase(String resName) throws SQLException {
        Statement stmt = DeepEditFrame.conMMS.createStatement();
        String query = "SELECT " + resName + " FROM cotas WHERE month(Fecha)=" + this.ActMonth + " and year(Fecha)=" + this.ActYear;
        ResultSet rs = stmt.executeQuery(query);
        double[] result = new double[MMTool.days(this.ActMonth, this.ActYear)];
        int x = 0;
        while (rs.next()) {
            result[x] = rs.getDouble(resName);
            ++x;
        }
        return result;
    }

    private double maxDatabase(String resName) throws SQLException {
        Statement stmt = DeepEditFrame.conMMS.createStatement();
        String query = "SELECT " + resName + " FROM reservoir_information WHERE Value='max'";
        ResultSet rs = stmt.executeQuery(query);
        double result = 0.0;
        while (rs.next()) {
            result = rs.getDouble(resName);
        }
        return result;
    }

    private double minDatabase(String resName) throws SQLException {
        Statement stmt = DeepEditFrame.conMMS.createStatement();
        String query = "SELECT " + resName + " FROM reservoir_information WHERE Value='min'";
        ResultSet rs = stmt.executeQuery(query);
        double result = 0.0;
        while (rs.next()) {
            result = rs.getDouble(resName);
        }
        return result;
    }
}

