/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import de.core.DEMainChartFrame;
import de.core.DeepEdit;
import de.core.DeepEditFrame;
import de.core.Generator;
import de.core.MMMarketShareFrame;
import de.core.MMTool;
import de.core.PieChartFrame;
import de.core.Schematic;
import de.core.StripChartFrame;
import de.core.comp;
import de.core.mdb_act;
import de.core.mdb_owner;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;

public class MMMarketShare
extends MMTool {
    protected MMMarketShareFrame MyMMMarketShareFrame;
    protected double[][] company_percent;
    protected double[][] company_controller;
    protected double[][] company_product;
    protected double[][][] company_MS;
    protected double[] all;
    protected String[] company_name;
    protected DEMainChartFrame MyDEMCF;
    protected boolean mustdraw;
    protected String fuel;
    protected boolean controller = false;
    protected boolean capInst;
    protected boolean enGen;
    protected mdb_act[] actors;
    protected String[] invesmenttype;

    public MMMarketShare(Schematic sch, DeepEdit applet) {
        super(sch, applet);
        System.out.println("----- Market Share -----");
        this.fuel = "all";
        this.defineIT();
        this.mustdraw = true;
        DeepEdit.frame.chartSetUp();
        this.MyDEMCF = DeepEditFrame.myMChartFrame;
        if (this.MyMMMarketShareFrame == null) {
            this.MyMMMarketShareFrame = new MMMarketShareFrame(this, this.ActDeepEdit);
        } else {
            this.MyMMMarketShareFrame.setVisible(true);
        }
    }

    public MMMarketShare(Schematic sch, DeepEdit applet, String ffuel) {
        super(sch, applet);
        System.out.println("----- Market Share -----");
        this.fuel = ffuel;
        this.defineIT();
        this.mustdraw = false;
    }

    private void defineIT() {
        this.invesmenttype = new String[13];
        this.invesmenttype[0] = "all";
        this.invesmenttype[1] = "Thermal";
        this.invesmenttype[2] = "HydroS";
        this.invesmenttype[3] = "HydroR";
        this.invesmenttype[4] = "Nuclear";
        this.invesmenttype[5] = "Geothermal";
        this.invesmenttype[6] = "Solar";
        this.invesmenttype[7] = "Wind";
        this.invesmenttype[8] = "InterCx";
        this.invesmenttype[9] = "Combined Cycle 2 States";
        this.invesmenttype[10] = "Combined Cycle 5 States";
        this.invesmenttype[11] = "4 State Unit";
        this.invesmenttype[12] = "Other";
    }

    public void Calculate() {
        try {
            DeepEditFrame.conMMS.close();
            DeepEditFrame.conMMS = DeepEdit.OpenODBC_JDBCConnection("MMS", true);
        }
        catch (SQLException e) {
            System.out.println("Error: " + e);
        }
        this.all = null;
        this.all = new double[MMTool.days(this.ActMonth, this.ActYear)];
        try {
            this.setarrays();
            this.fillarrays();
            this.fillMS();
            this.results();
        }
        catch (Exception e) {
            System.out.println("Exception: " + e);
        }
    }

    private void setarrays() {
        int ic = 0;
        int ix = 0;
        for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
            comp TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
            if (!MMTool.indate(TempComponent, this.ActYear, this.ActMonth) || !TempComponent.getinservice() || !(TempComponent instanceof mdb_act)) continue;
            ++ic;
        }
        int dias = MMTool.days(this.ActMonth, this.ActYear);
        this.company_percent = new double[ic][ic];
        this.company_product = new double[dias][ic];
        this.company_MS = new double[dias][ic][ic];
        this.company_controller = new double[ic][ic];
        this.company_name = new String[ic];
    }

    private void fillarrays() {
        mdb_owner TempMdb_owner;
        comp TempComponent;
        int ic = 0;
        int ix = 0;
        Vector avagen = null;
        try {
            avagen = MMTool.getColumns(DeepEditFrame.conMMS, "energiadiaria");
        }
        catch (Exception e) {
            System.out.println("" + e);
        }
        for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
            TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
            if (!MMTool.indate(TempComponent, this.ActYear, this.ActMonth) || !TempComponent.getinservice() || !(TempComponent instanceof mdb_act)) continue;
            mdb_act TempMdb_act = (mdb_act)TempComponent;
            this.company_name[ic] = TempMdb_act.getName();
            for (int i = 0; i < TempMdb_act.Components.size(); ++i) {
                if (!(TempMdb_act.Components.elementAt(i) instanceof Generator)) continue;
                Generator TempGenerator = (Generator)TempMdb_act.Components.elementAt(i);
                if (!this.fuel.equals("all") && !TempGenerator.inv_type.equals(this.fuel)) continue;
                if (this.capInst && MMTool.indate(TempGenerator, this.ActYear, this.ActMonth)) {
                    this.setColumn(this.company_product, TempGenerator.pmax, ic);
                    int t = 0;
                    while (t < this.company_product.length) {
                        int n = t++;
                        this.all[n] = this.all[n] + TempGenerator.pmax;
                    }
                    continue;
                }
                if (!this.enGen || !MMTool.indate(TempGenerator, this.ActYear, this.ActMonth)) continue;
                try {
                    boolean exists = false;
                    for (int zx = 0; zx < avagen.size(); ++zx) {
                        if (!TempGenerator.getName().equals(String.valueOf(avagen.elementAt(zx)))) continue;
                        exists = true;
                    }
                    if (exists) {
                        double[] aux = this.energyDatabase(TempGenerator.getName());
                        this.setColumn(this.company_product, aux, ic);
                        for (int t = 0; t < this.company_product.length; ++t) {
                            int n = t;
                            this.all[n] = this.all[n] + aux[t];
                        }
                        continue;
                    }
                    System.out.println("Generator " + TempGenerator.getName() + " not available in MMS database.");
                    continue;
                }
                catch (Exception e) {
                    System.out.println("Exception: " + e);
                }
            }
            ++ic;
        }
        for (int ia = 0; ia < this.company_name.length; ++ia) {
            for (int ib = 0; ib < this.company_name.length; ++ib) {
                if (ia == ib) {
                    this.company_percent[ia][ib] = 100.0;
                    this.company_controller[ia][ib] = 100.0;
                    continue;
                }
                this.company_percent[ia][ib] = 0.0;
                this.company_controller[ia][ib] = 0.0;
            }
        }
        for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
            TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
            if (!MMTool.indate(TempComponent, this.ActYear, this.ActMonth) || !TempComponent.getinservice() || !(TempComponent instanceof mdb_owner)) continue;
            TempMdb_owner = (mdb_owner)TempComponent;
            if (TempMdb_owner.party1 == null || TempMdb_owner.party2 == null) continue;
            for (int ia = 0; ia < this.company_name.length; ++ia) {
                if (!this.company_name[ia].equals(TempMdb_owner.party1.getName())) continue;
                for (int ib = 0; ib < this.company_name.length; ++ib) {
                    if (!this.company_name[ib].equals(TempMdb_owner.party2.getName())) continue;
                    this.company_percent[ia][ib] = TempMdb_owner.percent;
                }
            }
        }
        for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
            comp TempComp = (comp)this.ActSchematic.Components.elementAt(ix);
            if (!MMTool.indate(TempComp, this.ActYear, this.ActMonth) || !TempComp.getinservice() || !(TempComp instanceof mdb_owner)) continue;
            TempMdb_owner = (mdb_owner)TempComp;
            if (!TempMdb_owner.controller || TempMdb_owner.party1 == null || TempMdb_owner.party2 == null) continue;
            mdb_act TempParty1 = (mdb_act)TempMdb_owner.party1;
            mdb_act TempParty2 = (mdb_act)TempMdb_owner.party2;
            for (int i = 0; i < this.company_name.length; ++i) {
                if (!this.company_name[i].equals(TempParty1.getName())) continue;
                for (int j = 0; j < this.company_name.length; ++j) {
                    if (!this.company_name[j].equals(TempParty2.getName())) continue;
                    this.company_controller[i][j] = 100.0;
                }
            }
        }
    }

    private void fillMS() {
        int j;
        int i;
        int tiempo;
        int largo;
        if (!this.controller) {
            largo = this.company_name.length;
            for (tiempo = 0; tiempo < MMTool.days(this.ActMonth, this.ActYear); ++tiempo) {
                for (i = 0; i < largo; ++i) {
                    for (j = 0; j < largo; ++j) {
                        this.company_MS[tiempo][i][j] = i == j ? this.company_product[tiempo][i] : this.company_percent[i][j] / 100.0 * this.product(j, tiempo);
                    }
                }
            }
        }
        if (this.controller) {
            largo = this.company_name.length;
            for (tiempo = 0; tiempo < MMTool.days(this.ActMonth, this.ActYear); ++tiempo) {
                for (i = 0; i < largo; ++i) {
                    for (j = 0; j < largo; ++j) {
                        this.company_MS[tiempo][i][j] = i == j ? this.company_product[tiempo][i] : this.company_controller[i][j] / 100.0 * this.product_controller(j, tiempo);
                    }
                }
            }
        }
    }

    private double product(int x, int t) {
        double aux = 0.0;
        int largo = this.company_name.length;
        for (int k = 0; k < largo; ++k) {
            if (k == x) {
                aux += this.company_product[t][k];
                continue;
            }
            if (this.company_percent[x][k] == 0.0) continue;
            aux += this.company_percent[x][k] / 100.0 * this.product(k, t);
        }
        return aux;
    }

    private double product_controller(int x, int t) {
        double aux = 0.0;
        int largo = this.company_name.length;
        for (int k = 0; k < largo; ++k) {
            if (k == x) {
                aux += this.company_product[t][k];
                continue;
            }
            if (this.company_controller[x][k] == 0.0) continue;
            aux += this.company_controller[x][k] / 100.0 * this.product_controller(k, t);
        }
        return aux;
    }

    private double[] energyDatabase(String genName) throws SQLException {
        Statement stmt = DeepEditFrame.conMMS.createStatement();
        String query = "SELECT " + genName + " FROM energiadiaria WHERE month(Fecha)=" + this.ActMonth + " and year(Fecha)=" + this.ActYear;
        ResultSet rs = stmt.executeQuery(query);
        double[] result = new double[MMTool.days(this.ActMonth, this.ActYear)];
        int i = 0;
        while (rs.next()) {
            result[i] = rs.getInt(genName);
            ++i;
        }
        return result;
    }

    private void results() {
        int k = 0;
        if (this.actors != null) {
            int[] indices = new int[this.actors.length];
            this.results2 = new double[MMTool.days(this.ActMonth, this.ActYear)][this.actors.length];
            this.Names = new String[this.actors.length];
            for (int i = 0; i < this.actors.length; ++i) {
                this.Names[i] = this.actors[i].getName();
                for (int j = 0; j < this.company_name.length; ++j) {
                    if (!this.actors[i].ComponentName.equals(this.company_name[j])) continue;
                    indices[k] = j;
                    ++k;
                }
            }
            for (int tiempo = 0; tiempo < this.results2.length; ++tiempo) {
                for (int i = 0; i < indices.length; ++i) {
                    for (int j = 0; j < this.company_MS[0].length; ++j) {
                        double[] dArray = this.results2[tiempo];
                        int n = i;
                        dArray[n] = dArray[n] + this.company_MS[tiempo][indices[i]][j];
                    }
                }
            }
        } else {
            this.results2 = new double[MMTool.days(this.ActMonth, this.ActYear)][1];
            this.Names = new String[1];
            this.Names[0] = "System";
            for (int i = 0; i < this.results2.length; ++i) {
                this.results2[i][0] = this.all[i];
            }
        }
        if (this.mustdraw) {
            PieChartFrame a = new PieChartFrame("Debugging", this.results2, this.Names, MMTool.frase_animosa());
            this.MyDEMCF.addChart("Market Share", a.getChart(), MMTool.frase_animosa());
            String ejey = "";
            ejey = this.capInst ? "MW" : "MWh";
            StripChartFrame b = new StripChartFrame("Debugging", this.results2, this.Names, MMTool.frase_animosa(), MMTool.dateday(this.ActYear, this.ActMonth, this.ActYear, this.ActMonth), "Date", ejey);
            this.MyDEMCF.addChart("Market Share", b.getChart(), MMTool.frase_animosa());
        }
    }

    protected void setColumn(double[][] data2, double newdata, int column) {
        for (int i = 0; i < data2.length; ++i) {
            double[] dArray = data2[i];
            int n = column;
            dArray[n] = dArray[n] + newdata;
        }
    }

    protected void setColumn(double[][] data2, double[] newdata, int column) {
        for (int i = 0; i < data2.length; ++i) {
            double[] dArray = data2[i];
            int n = column;
            dArray[n] = dArray[n] + newdata[i];
        }
    }
}

