/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import de.core.DEMainChartFrame;
import de.core.DeepEdit;
import de.core.DeepEditFrame;
import de.core.Generator;
import de.core.MMCredibilityFrame;
import de.core.MMTool;
import de.core.PieChartFrame;
import de.core.Schematic;
import de.core.comp;
import de.core.mdb_act;
import de.core.mdb_owner;

public class MMCredibility
extends MMTool {
    protected MMCredibilityFrame MyMMCredibilityFrame;
    protected boolean mustdraw;
    protected DEMainChartFrame MyDEMCF;
    protected mdb_act[] allactors;
    protected double[][] instcap;
    protected double[] firstcap;
    protected double[][][] icfinal;
    protected double[][] firstfinal;
    protected double[][] compercent;
    protected double[][] comcontroller;
    protected double[][] instcapresults;
    protected double[] firstcapresults;
    protected double[] allresults;
    protected double allfirstresults;
    protected mdb_act[] actors;
    protected boolean controller;

    public MMCredibility(Schematic sch, DeepEdit applet) {
        super(sch, applet);
        System.out.println("------ Credibility ------");
        this.mustdraw = true;
        DeepEdit.frame.chartSetUp();
        this.MyDEMCF = DeepEditFrame.myMChartFrame;
        if (this.MyMMCredibilityFrame == null) {
            this.MyMMCredibilityFrame = new MMCredibilityFrame(this, this.ActDeepEdit);
        } else {
            this.MyMMCredibilityFrame.setVisible(true);
        }
    }

    public MMCredibility(Schematic sch, DeepEdit applet, String different) {
        super(sch, applet);
        System.out.println("------ Credibility ------");
        this.mustdraw = false;
    }

    public void Calculate() {
        int k;
        int j;
        int k2;
        int j2;
        int i;
        int largo;
        int i2;
        int ix;
        comp TempComponent;
        this.Names = new String[this.actors.length];
        for (int i3 = 0; i3 < this.actors.length; ++i3) {
            this.Names[i3] = this.actors[i3].getName();
        }
        int ic = 0;
        int contadorparaentiresystem = 0;
        for (int ix2 = 0; ix2 < this.ActSchematic.Components.size(); ++ix2) {
            TempComponent = (comp)this.ActSchematic.Components.elementAt(ix2);
            if (!(TempComponent instanceof mdb_act)) continue;
            ++contadorparaentiresystem;
            if (!MMTool.indate(TempComponent, this.ActYear, this.ActMonth) || !TempComponent.getinservice()) continue;
            ++ic;
        }
        int id = 0;
        this.allactors = new mdb_act[ic];
        for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
            TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
            if (!MMTool.indate(TempComponent, this.ActYear, this.ActMonth) || !TempComponent.getinservice() || !(TempComponent instanceof mdb_act)) continue;
            this.allactors[id] = (mdb_act)TempComponent;
            ++id;
        }
        this.instcap = new double[this.allactors.length][MMTool.invstate().length];
        this.firstcap = new double[this.allactors.length];
        this.allresults = new double[MMTool.invstate().length];
        this.allfirstresults = 0.0;
        for (ix = 0; ix < this.allactors.length; ++ix) {
            for (i2 = 0; i2 < this.allactors[ix].Components.size(); ++i2) {
                if (!(this.allactors[ix].Components.elementAt(i2) instanceof Generator)) continue;
                Generator TempGenerator = (Generator)this.allactors[ix].Components.elementAt(i2);
                for (int jx = 0; jx < MMTool.invstate().length; ++jx) {
                    if (!MMTool.invstate()[jx].equals(TempGenerator.invstate)) continue;
                    if (TempGenerator.inservice && MMTool.indate(TempGenerator, this.ActYear, this.ActMonth)) {
                        double[] dArray = this.instcap[ix];
                        int n = jx;
                        dArray[n] = dArray[n] + TempGenerator.pmax;
                        int n2 = jx;
                        this.allresults[n2] = this.allresults[n2] + TempGenerator.pmax;
                    }
                    if (!MMTool.infirstdate(TempGenerator, this.ActYear, this.ActMonth)) continue;
                    int n = ix;
                    this.firstcap[n] = this.firstcap[n] + TempGenerator.pmax;
                    this.allfirstresults += TempGenerator.pmax;
                }
            }
        }
        this.compercent = new double[this.allactors.length][this.allactors.length];
        this.comcontroller = new double[this.allactors.length][this.allactors.length];
        for (int ia = 0; ia < this.allactors.length; ++ia) {
            for (int ib = 0; ib < this.allactors.length; ++ib) {
                if (ia == ib) {
                    this.compercent[ia][ib] = 100.0;
                    this.comcontroller[ia][ib] = 100.0;
                    continue;
                }
                this.compercent[ia][ib] = 0.0;
                this.comcontroller[ia][ib] = 0.0;
            }
        }
        for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
            TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
            if (!MMTool.indate(TempComponent, this.ActYear, this.ActMonth) || !TempComponent.getinservice() || !(TempComponent instanceof mdb_owner)) continue;
            mdb_owner TempMdb_owner = (mdb_owner)TempComponent;
            if (TempMdb_owner.party1 == null || TempMdb_owner.party2 == null) continue;
            for (int ia = 0; ia < this.allactors.length; ++ia) {
                if (!this.allactors[ia].getName().equals(TempMdb_owner.party1.getName())) continue;
                for (int ib = 0; ib < this.allactors.length; ++ib) {
                    if (!this.allactors[ib].getName().equals(TempMdb_owner.party2.getName())) continue;
                    this.compercent[ia][ib] = TempMdb_owner.percent;
                    if (!TempMdb_owner.controller) continue;
                    this.comcontroller[ia][ib] = 100.0;
                }
            }
        }
        String[] invstate = MMTool.invstate();
        this.icfinal = new double[this.allactors.length][this.allactors.length][invstate.length];
        this.firstfinal = new double[this.allactors.length][this.allactors.length];
        if (!this.controller) {
            largo = this.allactors.length;
            for (i = 0; i < largo; ++i) {
                for (j2 = 0; j2 < largo; ++j2) {
                    this.firstfinal[i][j2] = i == j2 ? this.firstcap[i] : this.compercent[i][j2] / 100.0 * this.product(j2);
                    for (k2 = 0; k2 < invstate.length; ++k2) {
                        this.icfinal[i][j2][k2] = i == j2 ? this.instcap[i][k2] : this.compercent[i][j2] / 100.0 * this.product(j2, k2);
                    }
                }
            }
        }
        if (this.controller) {
            largo = this.allactors.length;
            for (i = 0; i < largo; ++i) {
                for (j2 = 0; j2 < largo; ++j2) {
                    this.firstfinal[i][j2] = i == j2 ? this.firstcap[i] : this.comcontroller[i][j2] / 100.0 * this.product_controller(j2);
                    for (k2 = 0; k2 < invstate.length; ++k2) {
                        this.icfinal[i][j2][k2] = i == j2 ? this.instcap[i][k2] : this.comcontroller[i][j2] / 100.0 * this.product_controller(j2, k2);
                    }
                }
            }
        }
        this.instcapresults = new double[this.allactors.length][invstate.length];
        this.firstcapresults = new double[this.allactors.length];
        for (i2 = 0; i2 < this.allactors.length; ++i2) {
            for (j = 0; j < this.allactors.length; ++j) {
                int n = i2;
                this.firstcapresults[n] = this.firstcapresults[n] + this.firstfinal[i2][j];
                for (k = 0; k < invstate.length; ++k) {
                    double[] dArray = this.instcapresults[i2];
                    int n3 = k;
                    dArray[n3] = dArray[n3] + this.icfinal[i2][j][k];
                }
            }
        }
        if (contadorparaentiresystem != this.actors.length) {
            this.results3 = new double[1][this.actors.length][MMTool.invstate().length];
            this.results2b = new double[1][1];
            for (i2 = 0; i2 < this.allactors.length; ++i2) {
                for (j = 0; j < this.actors.length; ++j) {
                    if (this.allactors[i2] != this.actors[j]) continue;
                    double[] dArray = this.results2b[0];
                    dArray[0] = dArray[0] + this.firstcapresults[i2];
                    for (k = 0; k < invstate.length; ++k) {
                        this.results3[0][j][k] = this.instcapresults[i2][k];
                    }
                }
            }
        } else {
            this.results3 = new double[1][1][MMTool.invstate().length];
            this.results2b = new double[1][1];
            this.Names = null;
            this.Names = new String[1];
            this.Names[0] = "Entire System";
            for (i2 = 0; i2 < this.allactors.length; ++i2) {
                this.results2b[0][0] = this.allfirstresults;
                for (int k3 = 0; k3 < invstate.length; ++k3) {
                    this.results3[0][0][k3] = this.allresults[k3];
                }
            }
        }
        this.results2 = new double[1][1];
        double creible = 0.0;
        double nocreible = 0.0;
        for (int j3 = 0; j3 < this.results3[0].length; ++j3) {
            for (int k4 = 0; k4 < this.results3[0][0].length; ++k4) {
                if (MMTool.binvstate()[k4]) {
                    creible += this.results3[0][j3][k4];
                    continue;
                }
                nocreible += this.results3[0][j3][k4];
            }
        }
        this.results2[0][0] = creible + nocreible == 0.0 ? 0.0 : creible / (creible + nocreible) * 100.0;
        if (this.mustdraw) {
            PieChartFrame graf1 = new PieChartFrame("Credibility Index", this.results3[0], this.Names, this.month[this.ActMonth - 1] + "/" + this.ActYear);
            this.MyDEMCF.addChart("Credibility Index", graf1.getChart(), this.month[this.ActMonth - 1] + "/" + this.ActYear);
        }
    }

    public static double[][] credibility(double[][][] x, double[][] y) {
        int i;
        double[] aux = new double[x.length];
        double[][] ret = new double[x.length][1];
        double ejecutados_t0 = 0.0;
        for (i = 0; i < aux.length; ++i) {
            double creible = 0.0;
            double nocreible = 0.0;
            for (int j = 0; j < x[0].length; ++j) {
                for (int k = 0; k < x[0][0].length; ++k) {
                    if (MMTool.binvstate()[k]) {
                        creible += x[i][j][k];
                        continue;
                    }
                    nocreible += x[i][j][k];
                }
            }
            if (i == 0) {
                ejecutados_t0 = creible;
            }
            aux[i] = y[i][0] == ejecutados_t0 ? 100.0 : (creible - ejecutados_t0) / (y[i][0] - ejecutados_t0) * 100.0;
        }
        for (i = 0; i < aux.length; ++i) {
            for (int ii = 0; ii < i + 1; ++ii) {
                double[] dArray = ret[i];
                dArray[0] = dArray[0] + aux[ii];
            }
            ret[i][0] = ret[i][0] / (double)(i + 1);
        }
        return ret;
    }

    private double product(int x) {
        double aux = 0.0;
        int largo = this.allactors.length;
        for (int k = 0; k < largo; ++k) {
            if (k == x) {
                aux += this.firstcap[k];
                continue;
            }
            if (this.compercent[x][k] == 0.0) continue;
            aux += this.compercent[x][k] / 100.0 * this.product(k);
        }
        return aux;
    }

    private double product(int x, int y) {
        double aux = 0.0;
        int largo = this.allactors.length;
        for (int k = 0; k < largo; ++k) {
            if (k == x) {
                aux += this.instcap[k][y];
                continue;
            }
            if (this.compercent[x][k] == 0.0) continue;
            aux += this.compercent[x][k] / 100.0 * this.product(k, y);
        }
        return aux;
    }

    private double product_controller(int x) {
        double aux = 0.0;
        int largo = this.allactors.length;
        for (int k = 0; k < largo; ++k) {
            if (k == x) {
                aux += this.firstcap[k];
                continue;
            }
            if (this.comcontroller[x][k] == 0.0) continue;
            aux += this.comcontroller[x][k] / 100.0 * this.product(k);
        }
        return aux;
    }

    private double product_controller(int x, int y) {
        double aux = 0.0;
        int largo = this.allactors.length;
        for (int k = 0; k < largo; ++k) {
            if (k == x) {
                aux += this.instcap[k][y];
                continue;
            }
            if (this.comcontroller[x][k] == 0.0) continue;
            aux += this.comcontroller[x][k] / 100.0 * this.product(k, y);
        }
        return aux;
    }
}

