/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import de.core.DeepEdit;
import de.core.MMTool;
import de.core.Schematic;

public class MMCorrelation
extends MMTool {
    protected boolean mustdraw = false;
    protected double[][] data;
    protected double[][] covariance;
    protected double[] estdesv;
    protected double[][] correlation;
    protected double[] average;

    public MMCorrelation(Schematic sch, DeepEdit applet, String different) {
        super(sch, applet);
    }

    public void Calculate() {
        int j;
        int i;
        this.covariance = new double[this.data[0].length][this.data[0].length];
        for (i = 0; i < this.data[0].length; ++i) {
            for (j = 0; j <= i; ++j) {
                this.covariance[i][j] = this.CalCov(this.getColumn(this.data, i), this.getColumn(this.data, j));
                this.covariance[j][i] = this.covariance[i][j];
            }
        }
        this.estdesv = new double[this.data[0].length];
        for (i = 0; i < this.data[0].length; ++i) {
            this.estdesv[i] = this.CalDesv(this.getColumn(this.data, i));
        }
        this.correlation = new double[this.data[0].length][this.data[0].length];
        for (i = 0; i < this.data[0].length; ++i) {
            for (j = 0; j <= i; ++j) {
                this.correlation[i][j] = this.covariance[i][j] / (this.estdesv[i] * this.estdesv[j]);
                this.correlation[j][i] = this.correlation[i][j];
            }
        }
        this.average = new double[this.data[0].length];
        for (int j2 = 0; j2 < this.data[0].length; ++j2) {
            this.average[j2] = this.CalAv(this.getColumn(this.data, j2));
        }
    }

    public double CalCov(double[] x, double[] y) {
        double ret = 0.0;
        double xav = this.CalAv(x);
        double yav = this.CalAv(y);
        for (int i = 0; i < x.length; ++i) {
            ret += (x[i] - xav) * (y[i] - yav);
        }
        return ret / (double)(x.length - 1);
    }

    public double CalDesv(double[] x) {
        double ret = 0.0;
        double xav = this.CalAv(x);
        for (int i = 0; i < x.length; ++i) {
            ret += (x[i] - xav) * (x[i] - xav);
        }
        return Math.pow(ret / (double)(x.length - 1), 0.5);
    }

    public double CalAv(double[] x) {
        double ret = 0.0;
        for (int i = 0; i < x.length; ++i) {
            ret += x[i];
        }
        return ret / (double)x.length;
    }

    public double[] getColumn(double[][] x, int y) {
        double[] ret = new double[x.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = x[i][y];
        }
        return ret;
    }
}

