/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import de.core.DeepEdit;
import de.core.Generator;
import de.core.Load;
import de.core.SimpleDialog;
import de.core.comp;
import de.core.ndb_1pol;
import de.core.ndb_comp;
import de.utils.StringUtil;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileNameExtensionFilter;

class LoadDispatchFrame
extends Frame
implements KeyListener,
ActionListener {
    DeepEdit applet;
    String ctrla;
    protected Font TextDialogFont;
    protected FontMetrics TextDialogFontMetrics;
    String[] mes = new String[12];
    Choice MyChoiceCtrla = null;
    Choice MyChoiceSDY = null;
    Choice MyChoiceSDM = null;
    Choice MyChoiceSDB = null;
    Choice MyChoiceSDH = null;
    int InitialYearDB = -1;
    int InitialMonthDB = -1;
    int FinalYearDB = -1;
    int FinalMonthDB = -1;
    int BlockNumberDB = -1;
    int HydroNumberDB = -1;
    int YearNumberDB = -1;
    int year1 = -1;
    int month1 = -1;
    int block1 = -1;
    int hidro1 = -1;
    int flow1 = -1;
    int dimDBGen = -1;
    int dimDBLoad = -1;
    int dimDBYear = -1;
    int ndem = -1;
    String[] NameGenDB;
    int[] IdDespDB;
    JFileChooser chooser = null;
    double[] PDB;
    String[] NameLDB;
    double[] PLDB;
    double blockTime;
    double TotDemDB;
    int HidYearNameLDB;
    private boolean one;
    private boolean directDx;
    Connection conTPDB = null;

    LoadDispatchFrame(DeepEdit app, Connection db) {
        super("Load Dispatch Options");
        this.mes[0] = "Enero";
        this.mes[1] = "Febrero";
        this.mes[2] = "Marzo";
        this.mes[3] = "Abril";
        this.mes[4] = "Mayo";
        this.mes[5] = "Junio";
        this.mes[6] = "Julio";
        this.mes[7] = "Agosto";
        this.mes[8] = "Septiembre";
        this.mes[9] = "Octubre";
        this.mes[10] = "Noviembre";
        this.mes[11] = "Diciembre";
        this.conTPDB = db;
        this.readDB();
        this.applet = app;
        this.ctrla = "ALL CONTROL AREAS";
        this.setBackground(Color.lightGray);
        this.TextDialogFont = DeepEdit.TextFont;
        this.TextDialogFontMetrics = this.getFontMetrics(this.TextDialogFont);
        this.setFont(this.TextDialogFont);
        this.setLayout(new FlowLayout());
        this.bringInfo();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                try {
                    LoadDispatchFrame.this.conTPDB.rollback();
                    LoadDispatchFrame.this.conTPDB.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                LoadDispatchFrame.this.setVisible(false);
                LoadDispatchFrame.this.dispose();
                LoadDispatchFrame.this.applet.MyLoadDispatchFrame = null;
            }
        });
        this.setVisible(true);
    }

    private void bringInfo() {
        Panel P = new Panel();
        P.setLayout(new GridLayout(13, 2));
        Label titel = new Label("CALCULATION OPTIONS");
        titel.setForeground(Color.blue);
        P.add(titel);
        P.add(new Label(" "));
        this.MyChoiceCtrla = new Choice();
        this.MyChoiceCtrla.addItem(this.ctrla);
        DeepEdit.MySchematic.LoadCtrla(this.MyChoiceCtrla);
        P.add(new Label("Select Control Area"));
        P.add(this.MyChoiceCtrla);
        Label aux = new Label(" Flows Information");
        aux.setForeground(Color.blue);
        P.add(aux);
        aux = new Label(" Year / Month / Block / Hydrology");
        aux.setForeground(Color.red);
        P.add(aux);
        aux = new Label(" First Flow : ");
        aux.setForeground(Color.blue);
        P.add(aux);
        aux = new Label(" " + this.InitialYearDB + " / " + this.InitialMonthDB + " / 1 / 1");
        aux.setForeground(Color.red);
        P.add(aux);
        aux = new Label(" Last Flow : ");
        aux.setForeground(Color.blue);
        P.add(aux);
        aux = new Label(" " + this.FinalYearDB + " / " + this.FinalMonthDB + " / " + this.BlockNumberDB + " / " + this.HydroNumberDB);
        aux.setForeground(Color.red);
        P.add(aux);
        P.add(new Label("DISTPACH SELECTION"));
        Button getDB = new Button("Select DB");
        getDB.setActionCommand("getDB");
        getDB.addActionListener(this);
        P.add(getDB);
        this.MyChoiceSDY = new Choice();
        this.MyChoiceSDM = new Choice();
        this.MyChoiceSDB = new Choice();
        this.MyChoiceSDH = new Choice();
        for (int y = this.InitialYearDB; y <= this.FinalYearDB; ++y) {
            this.MyChoiceSDY.addItem("" + y);
        }
        for (int m = 0; m < 12; ++m) {
            this.MyChoiceSDM.addItem(this.mes[m]);
        }
        for (int b = 0; b < this.BlockNumberDB; ++b) {
            this.MyChoiceSDB.addItem("" + (b + 1));
        }
        for (int h = 0; h < this.HydroNumberDB; ++h) {
            this.MyChoiceSDH.addItem("" + (h + 1));
        }
        P.add(new Label("Initial Year"));
        P.add(this.MyChoiceSDY);
        P.add(new Label("Initial Month"));
        P.add(this.MyChoiceSDM);
        P.add(new Label("Initial Block"));
        P.add(this.MyChoiceSDB);
        P.add(new Label("Initial Hydro"));
        P.add(this.MyChoiceSDH);
        P.add(new Label(" "));
        P.add(new Label(" "));
        Button button1 = new Button("Get Values");
        button1.setActionCommand("OK");
        button1.addActionListener(this);
        Button button2 = new Button("Cancel");
        button2.setActionCommand("Cancel");
        button2.addActionListener(this);
        P.add(button1);
        P.add(button2);
        this.add(P);
        this.pack();
    }

    private void readDB() {
        try {
            Statement s = this.conTPDB.createStatement();
            ResultSet r4 = s.executeQuery("SELECT *\tFROM SimInfo");
            r4.next();
            this.InitialYearDB = r4.getInt("InitialYear");
            this.InitialMonthDB = r4.getInt("InitialMonth");
            this.YearNumberDB = r4.getInt("YearNumber");
            this.BlockNumberDB = r4.getInt("BlockNumber");
            this.HydroNumberDB = r4.getInt("HydroNumber");
            this.FinalYearDB = this.InitialYearDB + this.YearNumberDB;
            this.one = this.HydroNumberDB == 1;
            this.FinalMonthDB = this.InitialMonthDB == 1 ? 12 : this.InitialMonthDB - 1;
            s.close();
            this.conTPDB.rollback();
        }
        catch (Exception e) {
            System.out.println("Not valid TPDB.");
        }
    }

    @Override
    public void paint(Graphics g) {
    }

    @Override
    public void keyPressed(KeyEvent event) {
        if (event.getKeyCode() == 27) {
            try {
                this.conTPDB.rollback();
                this.conTPDB.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.setVisible(false);
            this.dispose();
            this.applet.MyLoadDispatchFrame = null;
        }
    }

    @Override
    public void keyReleased(KeyEvent event) {
    }

    @Override
    public void keyTyped(KeyEvent event) {
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        Object obj = ev.getSource();
        String label = ev.getActionCommand();
        boolean todos = false;
        boolean ixx = false;
        if (obj instanceof TextField || obj instanceof Button) {
            if (label.equals("OK") || obj instanceof TextField) {
                try {
                    System.out.println(" Loading DataBase Information ... ");
                    this.LoadDataBase(this.MyChoiceSDY.getSelectedItem(), this.MyChoiceSDM.getSelectedItem(), this.MyChoiceSDB.getSelectedItem(), this.MyChoiceSDH.getSelectedItem());
                    System.out.println(" DataBase Information Loaded... ");
                    DeepEdit.MySchematic.setactperiod(this.year1);
                    DeepEdit.MySchematic.setactmonth(this.month1);
                    DeepEdit.MySchematic.Modifiedstate = true;
                    DeepEdit.MySchematic.Modified = true;
                    DeepEdit.MySchematic.CheckActive();
                    System.out.println(" Setting Network Information ");
                    this.SetDispatch();
                    System.out.println(" Network Information Done");
                }
                catch (Exception e) {
                    String message = e.toString();
                    String[] DlgButtons = new String[]{"Apply"};
                    SimpleDialog ExceptionDialog = new SimpleDialog(DeepEdit.frame, "Reading Load Dispatch information", message, DlgButtons, 1, 0, 0, 2);
                }
            } else if (label.equals("getDB")) {
                if (this.chooser == null) {
                    this.chooser = new JFileChooser(new File("." + File.separator + "database" + File.separator));
                }
                this.chooser.setFileSelectionMode(0);
                FileNameExtensionFilter filter = new FileNameExtensionFilter("Access DB", "mdb");
                this.chooser.setFileFilter(filter);
                int retorno = this.chooser.showOpenDialog(this);
                String addDB = "";
                if (retorno == 0) {
                    addDB = this.chooser.getSelectedFile().getAbsolutePath();
                    try {
                        String dsn = "jdbc:odbc:Driver={Microsoft Access Driver (*.mdb)};DBQ=" + addDB;
                        String user = "Administrator";
                        String password = "lilo";
                        System.out.println("New connection with Database:" + this.chooser.getSelectedFile().getName() + " is initialized.");
                        this.conTPDB = DriverManager.getConnection(dsn, user, password);
                        this.conTPDB.setAutoCommit(false);
                        this.applet.MyLoadDispatchFrame = new LoadDispatchFrame(this.applet, this.conTPDB);
                        this.dispose();
                    }
                    catch (Exception ex) {
                        System.out.println("File: " + this.chooser.getSelectedFile().getPath() + " is not a valid TPDB.");
                    }
                }
            } else {
                try {
                    this.conTPDB.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                System.out.println("");
                this.dispose();
                this.applet.MyLoadDispatchFrame = null;
            }
        }
    }

    public void LoadDataBase(String SDYa, String SDMa, String SDBa, String SDHa) {
        int i = 0;
        int j = 0;
        try {
            System.out.println("Loading TPDB Information ...");
            Statement s = this.conTPDB.createStatement();
            this.year1 = Integer.parseInt(SDYa);
            for (i = 0; i < 12; ++i) {
                if (!this.mes[i].equals(SDMa)) continue;
                this.month1 = i + 1;
            }
            this.block1 = Integer.parseInt(SDBa);
            this.hidro1 = Integer.parseInt(SDHa);
            this.flow1 = ((this.year1 - this.InitialYearDB) * 12 + (this.month1 - this.InitialMonthDB)) * this.BlockNumberDB * this.HydroNumberDB + (this.block1 - 1) * this.HydroNumberDB + this.hidro1;
            System.out.println("Y: " + this.year1 + " yini" + this.InitialYearDB);
            System.out.println("m: " + this.month1 + " mini" + this.InitialMonthDB);
            System.out.println("b: " + this.block1 + " bini" + this.BlockNumberDB);
            System.out.println("h: " + this.hidro1 + " bini" + this.HydroNumberDB);
            System.out.println("Flow " + this.flow1);
            int tflo = this.YearNumberDB * 12 * this.BlockNumberDB * this.HydroNumberDB;
            System.out.println(" ");
            System.out.println("----------------------------------------------------");
            System.out.println("                    SELECTED FLOW");
            System.out.println("----------------------------------------------------");
            System.out.println("     YEAR/   MONTH/   BLOCK/   HYDRO/   FLOW CODE");
            System.out.println(" " + StringUtil.numformat(this.year1, 8) + "/" + StringUtil.numformat(this.month1, 8) + "/" + StringUtil.numformat(this.block1, 8) + "/" + StringUtil.numformat(this.hidro1, 8) + "/" + StringUtil.numformat(this.flow1, 12));
            System.out.println(" ");
            DeepEdit.MySchematic.setactperiod(this.year1);
            DeepEdit.MySchematic.setactmonth(this.month1);
            DeepEdit.MySchematic.Modifiedstate = true;
            DeepEdit.MySchematic.Modified = true;
            DeepEdit.MySchematic.CheckActive();
            LoadDispatchFrame loadDispatchFrame = this;
            loadDispatchFrame.applet.updateTime();
            this.ndem = this.BlockNumberDB * 12;
            ResultSet r1 = s.executeQuery("SELECT IdDesp\tFROM generator WHERE IdDesp=" + this.flow1);
            i = 0;
            while (r1.next()) {
                ++i;
            }
            this.dimDBGen = i;
            this.NameGenDB = new String[this.dimDBGen];
            this.IdDespDB = new int[this.dimDBGen];
            this.PDB = new double[this.dimDBGen];
            for (i = 0; i < this.dimDBGen; ++i) {
                this.NameGenDB[i] = "nada";
                this.IdDespDB[i] = 12345;
                this.PDB[i] = 123456.0;
            }
            r1 = s.executeQuery("SELECT *\tFROM generator WHERE IdDesp=" + this.flow1);
            i = 0;
            while (r1.next()) {
                this.NameGenDB[i] = r1.getString("name").trim();
                this.IdDespDB[i] = r1.getInt("IdDesp");
                this.PDB[i] = r1.getDouble("p");
                ++i;
            }
            try {
                r1 = s.executeQuery("SELECT name FROM demand WHERE IdDesp=" + (this.flow1 - this.hidro1 + 1));
                i = 0;
                while (r1.next()) {
                    ++i;
                }
                this.dimDBLoad = i;
                this.NameLDB = new String[this.dimDBLoad];
                this.PLDB = new double[this.dimDBLoad];
                for (i = 0; i < this.dimDBLoad; ++i) {
                    this.NameLDB[i] = "nada";
                    this.PLDB[i] = 123456.0;
                }
                r1 = s.executeQuery("SELECT * FROM demand WHERE IdDesp=" + (this.flow1 - this.hidro1 + 1));
                i = 0;
                while (r1.next()) {
                    this.NameLDB[i] = r1.getString("name").trim();
                    this.PLDB[i] = r1.getDouble("p");
                    ++i;
                }
                this.directDx = true;
            }
            catch (Exception x) {
                System.out.println("Was not founded TPDB v2.0: " + x.getMessage());
                this.directDx = false;
                ResultSet r2 = s.executeQuery("SELECT name FROM load ORDER BY name");
                i = 0;
                while (r2.next()) {
                    ++i;
                }
                this.dimDBLoad = i;
                this.NameLDB = new String[this.dimDBLoad];
                this.PLDB = new double[this.dimDBLoad];
                for (i = 0; i < this.dimDBLoad; ++i) {
                    this.NameLDB[i] = "nada";
                    this.PLDB[i] = 123456.0;
                }
                r2 = s.executeQuery("SELECT * FROM load ORDER BY name");
                i = 0;
                j = this.one ? (this.year1 - this.InitialYearDB) * this.BlockNumberDB + this.month1 : this.BlockNumberDB * (this.month1 - 1) + this.block1;
                while (r2.next()) {
                    this.NameLDB[i] = r2.getString("name").trim();
                    this.PLDB[i] = r2.getDouble("d" + j);
                    ++i;
                }
                if (!this.one) {
                    ResultSet r3 = s.executeQuery("SELECT Year FROM loadPower ORDER BY Year");
                    i = 0;
                    while (r3.next()) {
                        ++i;
                    }
                    this.TotDemDB = 0.0;
                    this.HidYearNameLDB = 0;
                    r3 = s.executeQuery("SELECT * FROM loadPower WHERE Year = " + this.year1);
                    j = this.BlockNumberDB * (this.month1 - 1) + this.block1;
                    while (r3.next()) {
                        this.HidYearNameLDB = r3.getInt("Year");
                        this.TotDemDB = r3.getDouble("d" + j);
                    }
                }
                this.blockTime = 0.0;
                ResultSet r0 = s.executeQuery("SELECT * FROM blockTime");
                r0.next();
                this.blockTime = r0.getDouble("d" + j);
            }
            s.close();
            this.conTPDB.rollback();
        }
        catch (Exception e) {
            System.out.println("Error: al leer Base de Datos " + e);
            e.printStackTrace();
        }
    }

    public void SetDispatch() {
        Load TempLoad;
        Generator TempGenerator;
        ndb_comp TempNdb_comp;
        comp TempComponent;
        int ix = -1;
        int i = -1;
        int j = -1;
        double TotGen = 0.0;
        int numlast = 0;
        int numgen = 0;
        double TotDem = 0.0;
        boolean noesta = true;
        ix = 0;
        while (true) {
            if (ix >= DeepEdit.MySchematic.Components.size()) break;
            TempComponent = (comp)DeepEdit.MySchematic.Components.elementAt(ix);
            if (TempComponent instanceof ndb_comp && ((TempNdb_comp = (ndb_comp)TempComponent).getctrla().equals(this.ctrla) || this.ctrla.equals("ALL CONTROL AREAS")) && TempComponent.getactive() && TempComponent.getvalid() && TempComponent instanceof ndb_1pol && TempComponent.getinservice()) {
                if (TempComponent instanceof Generator) {
                    TempGenerator = (Generator)TempComponent;
                    TempGenerator.setp0(0.0);
                    TempGenerator.setp(0.0);
                    ++numgen;
                }
                if (TempComponent instanceof Load) {
                    TempLoad = (Load)TempComponent;
                    TempLoad.setgrate(0.0);
                    TempLoad.setp(0.0);
                    TempLoad.setpini(0.0);
                    ++numlast;
                }
            }
            ++ix;
        }
        ix = 0;
        while (true) {
            if (ix >= DeepEdit.MySchematic.Components.size()) break;
            TempComponent = (comp)DeepEdit.MySchematic.Components.elementAt(ix);
            if (TempComponent instanceof ndb_comp && ((TempNdb_comp = (ndb_comp)TempComponent).getctrla().equals(this.ctrla) || this.ctrla.equals("ALL CONTROL AREAS")) && TempComponent.getactive() && TempComponent.getvalid() && TempComponent instanceof ndb_1pol && TempComponent.getinservice() && TempComponent instanceof Generator) {
                TempGenerator = (Generator)TempComponent;
                noesta = true;
                for (i = 0; i < this.dimDBGen; ++i) {
                    if (!this.NameGenDB[i].equals(TempGenerator.getName())) continue;
                    TempGenerator.setp0(this.PDB[i]);
                    TempGenerator.setp(this.PDB[i]);
                    TotGen += this.PDB[i];
                    noesta = false;
                    break;
                }
                if (noesta) {
                    TempGenerator.setp(0.0);
                    TempGenerator.setp0(0.0);
                }
            }
            ++ix;
        }
        if (this.directDx) {
            ix = 0;
            while (true) {
                if (ix < DeepEdit.MySchematic.Components.size()) {
                    TempComponent = (comp)DeepEdit.MySchematic.Components.elementAt(ix);
                    if (TempComponent instanceof ndb_comp && ((TempNdb_comp = (ndb_comp)TempComponent).getctrla().equals(this.ctrla) || this.ctrla.equals("ALL CONTROL AREAS")) && TempComponent.getactive() && TempComponent.getvalid() && TempComponent instanceof ndb_1pol && TempComponent.getinservice() && TempComponent instanceof Load) {
                        TempLoad = (Load)TempComponent;
                        noesta = true;
                        double aux = 0.0;
                        for (i = 0; i < this.dimDBLoad; ++i) {
                            if (!this.NameLDB[i].equals(TempLoad.getName())) continue;
                            aux += this.PLDB[i];
                            noesta = false;
                        }
                        if (noesta) {
                            TempLoad.setp(0.0);
                            TempLoad.setpini(0.0);
                            TempLoad.setgrate(0.0);
                        } else {
                            TempLoad.setpini(aux);
                            TempLoad.setp(aux);
                            TotDem += aux;
                            TempLoad.setgrate(0.0);
                        }
                        TempLoad.updateload(DeepEdit.MySchematic.getsref(), DeepEdit.MySchematic.getactperiod(), DeepEdit.MySchematic.getactmonth(), 0.0, 1.0);
                    }
                    ++ix;
                    continue;
                }
                break;
            }
        } else {
            ix = 0;
            while (true) {
                if (ix >= DeepEdit.MySchematic.Components.size()) break;
                TempComponent = (comp)DeepEdit.MySchematic.Components.elementAt(ix);
                if (TempComponent instanceof ndb_comp && ((TempNdb_comp = (ndb_comp)TempComponent).getctrla().equals(this.ctrla) || this.ctrla.equals("ALL CONTROL AREAS")) && TempComponent.getactive() && TempComponent.getvalid() && TempComponent instanceof ndb_1pol && TempComponent.getinservice() && TempComponent instanceof Load) {
                    TempLoad = (Load)TempComponent;
                    noesta = true;
                    for (i = 0; i < this.dimDBLoad; ++i) {
                        if (!this.NameLDB[i].equals(TempLoad.getName())) continue;
                        if (!this.one) {
                            TempLoad.setpini(this.PLDB[i] * this.TotDemDB);
                            TempLoad.setp(this.PLDB[i] * this.TotDemDB);
                            TotDem += this.PLDB[i] * this.TotDemDB;
                        } else {
                            TempLoad.setpini(this.PLDB[i] * TotGen);
                            TempLoad.setp(this.PLDB[i] * TotGen);
                            TotDem += this.PLDB[i] * TotGen;
                        }
                        noesta = false;
                        TempLoad.setgrate(0.0);
                        break;
                    }
                    if (noesta) {
                        TempLoad.setp(0.0);
                        TempLoad.setpini(0.0);
                        TempLoad.setgrate(0.0);
                        System.out.println(" Carga " + TempLoad.getName() + " demanda 0 [MW] o no fue encontrada");
                    }
                    TempLoad.updateload(DeepEdit.MySchematic.getsref(), DeepEdit.MySchematic.getactperiod(), DeepEdit.MySchematic.getactmonth(), 0.0, 1.0);
                }
                ++ix;
            }
        }
        System.out.println(" ");
        System.out.println(" Validation Report ");
        System.out.println(" ----------------- ");
        System.out.println(" ");
        System.out.println("  Cargas en la Red           = " + numlast);
        System.out.println("  Cargas en la DB            = " + this.dimDBLoad);
        System.out.println(" ");
        System.out.println("  Generadores en la Red      = " + numgen);
        System.out.println("  Generadores en la DB       = " + this.dimDBGen);
        System.out.println(" ");
        System.out.println("  Total Generation (DB) [MW] = " + (int)TotGen);
        System.out.println("  Total Demand     (DB) [MW] = " + (int)TotDem);
        System.out.println("  Generation-Demand     [MW] = " + (int)(TotGen - TotDem));
        System.out.println(" ");
    }
}

