/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import de.core.Busbar;
import de.core.DeepEdit;
import de.core.DeepEditFrame;
import de.core.GraphicsUtil;
import de.core.OutputPin;
import de.core.Pin;
import de.core.comp;
import de.core.ndb_1pol;
import de.data.DE_GeneralEnums;
import de.data.ParameterData;
import de.utils.StringUtil;
import de.utils.Utils;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.io.PrintStream;
import java.sql.SQLException;
import java.sql.Statement;

public class Load
extends ndb_1pol {
    public double alpha;
    public double beta;
    public double gamma;
    protected double unser_p;
    protected double unser_q;
    protected double ldc_T;
    protected double ldc_pmin;
    protected double ldc_pmax;
    protected double vd_p = 0.0;
    protected double vd_q = 0.0;
    protected double grate;
    protected String place;
    protected double fcaPLP = 0.0;
    boolean loadVD = false;
    double p1;
    double q1;
    private double[][] p_SimStBlMat = null;
    private double[][][] plimits = null;
    public double demanda_ener = 0.0;

    public Load(Pin[][] PinGrid, int x, int y, int entryperiod, int exitperiod, int entrymonth, int exitmonth) {
        super(x, y, 4, 4, 1, 1, 2, 3, 0, 1, entryperiod, exitperiod, entrymonth, exitmonth);
        this.OPin[0] = new OutputPin("Load", 2, 1, 0, 2, 0, 0, 2);
        this.setName("Load");
        this.ClassName = "Load";
        this.inv_type = "A";
        this.lf_type = 1;
        this.lf_type_s = 1;
        this.ldc_pmin = 50.0;
        this.ldc_pmax = 100.0;
        this.vd_p = 0.0;
        this.vd_q = 0.0;
        this.grate = 0.0;
        this.beta = 500.0;
        this.inv_owner = "None";
        this.place = "NULL";
        this.RegisterPins(PinGrid, x, y);
    }

    public Load(Pin[][] PinGrid, int x, int y, String Name, String type, String owner, String ctrla, double cost, double un1, double un2, double ssmax, int lifetime, int entryperiod, int exitperiod, int entrymonth, int exitmonth, double ppini, double qqini, double aalpha, double bbeta, double ggamma, double lldc_T, double lldc_pmin, double lldc_pmax, double ggrate, double latitude, double longitude, String pplace, boolean iinservice, double ffcaPLP, double vvd_p, double vvd_q) {
        super(x, y, 4, 4, 1, 1, 2, 3, 0, 1, Name, type, owner, ctrla, cost, un1, un2, ssmax, lifetime, entryperiod, exitperiod, entrymonth, exitmonth, ppini, qqini, latitude, longitude);
        this.OPin[0] = new OutputPin("Load", 2, 1, 0, 2, 0, 0, 2);
        this.ClassName = "Load";
        this.alpha = aalpha;
        this.beta = bbeta;
        this.gamma = ggamma;
        this.ldc_T = lldc_T;
        this.grate = ggrate;
        this.place = pplace;
        this.inservice = iinservice;
        this.vd_p = vvd_p;
        this.vd_q = vvd_q;
        this.ldc_pmin = lldc_pmin;
        this.ldc_pmax = lldc_pmax;
        this.fcaPLP = ffcaPLP;
        if (ppini != 0.0 || qqini != 0.0) {
            this.setcosphi(ppini / Math.sqrt(ppini * ppini + qqini * qqini));
        } else {
            this.setcosphi(0.0);
        }
        this.RegisterPins(PinGrid, x, y);
    }

    public Load(comp CompToCopy, int xo, int yo) {
        super(CompToCopy, xo, yo);
    }

    public double getalpha() {
        return this.alpha;
    }

    public double getbeta() {
        return this.beta;
    }

    public double getgamma() {
        return this.gamma;
    }

    public double getunser_p() {
        return this.unser_p;
    }

    public double getunser_q() {
        return this.unser_q;
    }

    public double getldc_T() {
        return this.ldc_T;
    }

    public double getldc_pmin() {
        return this.ldc_pmin;
    }

    public double getldc_pmax() {
        return this.ldc_pmax;
    }

    public double getgrate() {
        return this.grate;
    }

    public String getplace() {
        return this.place;
    }

    public double getfcaPLP() {
        return this.fcaPLP;
    }

    public double getvd_p() {
        return this.vd_p;
    }

    public double getvd_q() {
        return this.vd_q;
    }

    public double getfcaSEEDS() {
        return this.fcaPLP;
    }

    @Override
    public double getp() {
        return this.getp0() * Math.pow(this.getun2(), this.getvd_p());
    }

    @Override
    public double getq() {
        return this.getq0() * Math.pow(this.getun2(), this.getvd_q());
    }

    public void setalpha(double n) {
        this.alpha = n;
    }

    public void setbeta(double n) {
        this.beta = n;
    }

    public void setgamma(double n) {
        this.gamma = n;
    }

    public void setunser_p(double n) {
        this.unser_p = n;
    }

    public void setunser_q(double n) {
        this.unser_q = n;
    }

    public void setldc_T(double n) {
        this.ldc_T = n;
    }

    public void setldc_pmin(double n) {
        this.ldc_pmin = n;
    }

    public void setldc_pmax(double n) {
        this.ldc_pmax = n;
    }

    public void setgrate(double n) {
        this.grate = n;
    }

    public void setplace(String n) {
        this.place = n;
    }

    public void setvd_p(double n) {
        this.vd_p = n;
    }

    public void setvd_q(double n) {
        this.vd_q = n;
    }

    public void setfcaPLP(double n) {
        this.fcaPLP = n;
    }

    @Override
    public comp Copy(int xo, int yo) {
        Load NewComponent = new Load(this, xo, yo);
        NewComponent.setfcaPLP(this.getfcaPLP());
        NewComponent.setun1(this.getun1());
        NewComponent.setp0(this.getp0());
        NewComponent.setq0(this.getq0());
        NewComponent.setpini(this.getpini());
        NewComponent.setqini(this.getqini());
        NewComponent.setalpha(this.getalpha());
        NewComponent.setbeta(this.getbeta());
        NewComponent.setgamma(this.getgamma());
        NewComponent.setgrate(this.getgrate());
        NewComponent.setldc_T(this.getldc_T());
        NewComponent.setldc_pmin(this.getldc_pmin());
        NewComponent.setldc_pmax(this.getldc_pmax());
        NewComponent.setsmax(this.getsmax());
        NewComponent.setvd_p(this.getvd_p());
        NewComponent.setvd_q(this.getvd_q());
        NewComponent.setlife_time(this.getlife_time());
        NewComponent.setentry_period(this.getentry_period());
        NewComponent.setexit_period(this.getexit_period());
        NewComponent.setinv_cost(this.getinv_cost());
        NewComponent.setinv_type(this.getinv_type());
        NewComponent.setinv_owner("None");
        NewComponent.setplace(this.getplace());
        NewComponent.setlatitude(this.getlatitude());
        NewComponent.setlongitude(this.getlongitude());
        NewComponent.setctrla(this.getctrla());
        return NewComponent;
    }

    public void draw(Graphics2D g, int xp, int yp, int gs, boolean Modifiedstate, boolean Simulate, boolean cycle, double sref, int actperiod, int actmonth, double loadfac1, double loadfac2, int typsim) {
        super.draw(g, xp, yp, gs);
        int x = this.Pos.x - xp;
        int y = this.Pos.y - yp;
        double pp = 0.0;
        double qq = 0.0;
        double gss = 0.0;
        double ixx = 0.0;
        String tipo = this.inv_type;
        if (!Simulate) {
            qq = this.getq0();
            pp = this.getp0();
            if (!this.inservice) {
                g.setColor(Color.black);
            } else {
                g.setColor(this.getkv_color1());
            }
            this.DrawOutputPins(g, x, y, gs);
            gss = gs;
            if (this.inv_type.equals("D")) {
                Polygon po = new Polygon();
                po.addPoint((x + 1) * gs, (y + 3) * gs);
                po.addPoint((int)(((double)x + 1.5) * (double)gs), (int)(((double)y + 4.0) * (double)gs));
                po.addPoint((int)(((double)x + 2.5) * (double)gs), (int)(((double)y + 4.0) * (double)gs));
                po.addPoint((x + 3) * gs, (int)(((double)y + 3.0) * (double)gs));
                po.addPoint((x + 1) * gs, (y + 3) * gs);
                g.fillPolygon(po);
                if (gs >= 4) {
                    g.setColor(Color.black);
                    g.drawPolygon(po);
                }
            } else if (pp == 0.0 && qq != 0.0) {
                if (!this.inservice) {
                    g.setColor(Color.black);
                } else {
                    g.setColor(Color.lightGray);
                }
                g.drawLine((int)(((double)x + 1.25) * (double)gs), (y + 4) * gs, (int)(((double)x + 2.75) * (double)gs), (y + 4) * gs);
                g.drawLine((int)(((double)x + 1.5) * (double)gs), (int)(((double)y + 4.25) * (double)gs), (int)(((double)x + 2.5) * (double)gs), (int)(((double)y + 4.25) * (double)gs));
                g.drawLine((int)(((double)x + 1.75) * (double)gs), (int)(((double)y + 4.5) * (double)gs), (int)(((double)x + 2.25) * (double)gs), (int)(((double)y + 4.5) * (double)gs));
                if (qq > 0.0) {
                    g.setColor(Color.black);
                    g.drawLine((x + 2) * gs, (y + 1) * gs, (x + 2) * gs, (y + 4) * gs);
                    g.setColor(this.getkv_color1());
                    for (int ix = 1; ix < gs * 3; ++ix) {
                        ixx = ix;
                        g.drawLine((int)(((double)x + 2.0) * gss + gss * Math.sin((ixx - 1.0) * Math.PI / gss)), (int)(((double)y + 1.0) * gss + (ixx - 1.0)), (int)(((double)x + 2.0) * gss + gss * Math.sin(ixx * Math.PI / gss)), (int)(((double)y + 1.0) * (double)gs + ixx));
                    }
                } else {
                    g.setColor(Color.black);
                    g.drawLine((x + 2) * gs, (y + 2) * gs, (x + 2) * gs, (int)(((double)y + 2.5) * (double)gs));
                    g.setColor(this.getkv_color1());
                    g.drawLine((x + 1) * gs, (y + 2) * gs, (x + 3) * gs, (y + 2) * gs);
                    g.drawLine((x + 2) * gs, (int)(((double)y + 2.5) * (double)gs), (x + 2) * gs, (int)(((double)y + 4.0) * (double)gs));
                    g.drawLine((x + 1) * gs, (int)(((double)y + 2.5) * (double)gs), (x + 3) * gs, (int)(((double)y + 2.5) * (double)gs));
                }
            } else {
                Polygon po = new Polygon();
                po.addPoint((x + 1) * gs, (y + 3) * gs);
                po.addPoint((x + 2) * gs, (int)(((double)y + 4.0) * (double)gs));
                po.addPoint((x + 3) * gs, (int)(((double)y + 3.0) * (double)gs));
                po.addPoint((x + 1) * gs, (y + 3) * gs);
                g.fillPolygon(po);
                if (gs >= 4) {
                    g.setColor(Color.black);
                    g.drawPolygon(po);
                }
            }
            if (this.inv_type.startsWith("CHP")) {
                g.setColor(Color.red);
                g.drawRect((x - 1) * gs, (y + 1) * gs, 2 * gs, 3 * gs);
                for (int ix = 1; ix < gs * 3; ++ix) {
                    ixx = ix;
                    g.drawLine((int)((double)x * gss + gss * Math.sin((ixx - 1.0) * Math.PI / gss)), (int)(((double)y + 1.0) * gss + (ixx - 1.0)), (int)((double)x * gss + gss * Math.sin(ixx * Math.PI / gss)), (int)(((double)y + 1.0) * (double)gs + ixx));
                }
            }
            if (!this.inservice) {
                g.setColor(Color.white);
            } else {
                g.setColor(TextColor1);
            }
            if (gs >= 6) {
                this.setq0(qq);
                this.setp0(pp);
                this.setp(this.getp0());
                this.setq(this.getq0());
            }
            if (!this.inservice) {
                g.setColor(Color.white);
            } else {
                g.setColor(TextColor2);
            }
            if (this.loadVD) {
                if (gs >= 0 && gs < 6) {
                    g.setFont(Font10);
                } else if (gs >= 6 && gs < 10) {
                    g.setFont(Font9);
                    g.drawString(this.ComponentName, (int)(((double)x + 3.0) * (double)gs), (int)(((double)y + 4.0) * (double)gs));
                    if (this.getinservice()) {
                        g.setColor(Color1);
                        g.drawString(StringUtil.printf(this.p1, 7, 2), (int)(((double)x + 3.0) * (double)gs), (int)(((double)y + 5.5) * (double)gs));
                        g.setColor(TextColor1);
                        g.drawString(StringUtil.printf(this.q1, 7, 2), (int)(((double)x + 3.0) * (double)gs), (int)(((double)y + 6.8) * (double)gs));
                    }
                } else if (gs >= 10 && gs <= 12) {
                    g.setFont(Font12);
                    g.drawString(this.ComponentName, (int)(((double)x + 3.0) * (double)gs), (int)(((double)y + 4.0) * (double)gs));
                    if (this.getinservice()) {
                        g.setColor(Color1);
                        g.drawString(StringUtil.printf(this.p1, 7, 2), (int)(((double)x + 3.0) * (double)gs), (int)(((double)y + 5.5) * (double)gs));
                        g.setColor(TextColor1);
                        g.drawString(StringUtil.printf(this.q1, 7, 2), (int)(((double)x + 3.0) * (double)gs), (int)(((double)y + 6.8) * (double)gs));
                    }
                } else if (gs >= 12 && gs < 18) {
                    g.setFont(Font14);
                    g.drawString(this.ComponentName, (int)(((double)x + 3.0) * (double)gs), (int)(((double)y + 4.0) * (double)gs));
                    if (this.getinservice()) {
                        g.setColor(Color1);
                        g.drawString(StringUtil.printf(this.p1, 7, 2), (int)(((double)x + 3.0) * (double)gs), (int)(((double)y + 5.0) * (double)gs));
                        g.setColor(TextColor1);
                        g.drawString(StringUtil.printf(this.q1, 7, 2), (int)(((double)x + 3.0) * (double)gs), (int)(((double)y + 6.0) * (double)gs));
                    }
                    if (!Modifiedstate && this.getinservice()) {
                        if (typsim == 3) {
                            g.setColor(TextColor3);
                            if (this.p0 == 0.0) {
                                g.drawString(StringUtil.printf(this.q / this.q0, 7, 2), (int)(((double)x + 3.0) * (double)gs), (int)(((double)y + 7.0) * (double)gs));
                            } else {
                                g.drawString(StringUtil.printf(this.p / this.p0, 7, 2), (int)(((double)x + 3.0) * (double)gs), (int)(((double)y + 7.0) * (double)gs));
                            }
                        } else if (!(typsim != 1 && typsim != 2 && typsim != 4 && typsim != 6 && typsim != 7 || this.unser_p == 0.0 && this.unser_q == 0.0)) {
                            g.setColor(Color1);
                            g.drawString("Unser. Energy !", (int)(((double)x + 2.0) * (double)gs), (int)(((double)y + 8.0) * (double)gs));
                        }
                    }
                }
            }
            if (!this.loadVD) {
                if (gs >= 0 && gs < 6) {
                    g.setFont(Font10);
                } else if (gs >= 6 && gs < 10) {
                    g.setFont(Font9);
                    g.drawString(this.ComponentName, (int)(((double)x + 3.0) * (double)gs), (int)(((double)y + 4.0) * (double)gs));
                    if (this.getinservice()) {
                        g.setColor(Color1);
                        g.drawString(StringUtil.printf(this.p, 7, 2), (int)(((double)x + 3.0) * (double)gs), (int)(((double)y + 5.5) * (double)gs));
                        g.setColor(TextColor1);
                        if (qq != 0.0) {
                            g.drawString(StringUtil.printf(this.q, 7, 2), (int)(((double)x + 3.0) * (double)gs), (int)(((double)y + 6.8) * (double)gs));
                        }
                    }
                } else if (gs >= 10 && gs <= 12) {
                    g.setFont(Font12);
                    g.drawString(this.ComponentName, (int)(((double)x + 3.0) * (double)gs), (int)(((double)y + 4.0) * (double)gs));
                    if (this.getinservice()) {
                        g.setColor(Color1);
                        g.drawString(StringUtil.printf(this.p, 7, 2), (int)(((double)x + 3.0) * (double)gs), (int)(((double)y + 5.5) * (double)gs));
                        g.setColor(TextColor1);
                        if (qq != 0.0) {
                            g.drawString(StringUtil.printf(this.q, 7, 2), (int)(((double)x + 3.0) * (double)gs), (int)(((double)y + 6.8) * (double)gs));
                        }
                    }
                } else if (gs >= 12 && gs < 18) {
                    g.setFont(Font14);
                    g.drawString(this.ComponentName, (int)(((double)x + 3.0) * (double)gs), (int)(((double)y + 4.0) * (double)gs));
                    if (this.getinservice()) {
                        g.setColor(Color1);
                        g.drawString(StringUtil.printf(this.p, 7, 2), (int)(((double)x + 3.0) * (double)gs), (int)(((double)y + 5.0) * (double)gs));
                        g.setColor(TextColor1);
                        if (qq != 0.0) {
                            g.drawString(StringUtil.printf(this.q, 7, 2), (int)(((double)x + 3.0) * (double)gs), (int)(((double)y + 6.0) * (double)gs));
                        }
                    }
                    if (!Modifiedstate && this.getinservice()) {
                        if (typsim == 3) {
                            g.setColor(TextColor3);
                            if (this.p0 == 0.0) {
                                g.drawString(StringUtil.printf(this.q / this.q0, 7, 2), (int)(((double)x + 3.0) * (double)gs), (int)(((double)y + 7.0) * (double)gs));
                            } else {
                                g.drawString(StringUtil.printf(this.p / this.p0, 7, 2), (int)(((double)x + 3.0) * (double)gs), (int)(((double)y + 7.0) * (double)gs));
                            }
                        } else if (!(typsim != 1 && typsim != 2 && typsim != 4 && typsim != 6 && typsim != 7 || this.unser_p == 0.0 && this.unser_q == 0.0)) {
                            g.setColor(Color1);
                            g.drawString("Unser. Energy !", (int)(((double)x + 2.0) * (double)gs), (int)(((double)y + 8.0) * (double)gs));
                        }
                    }
                }
            }
            if (!(Modifiedstate || !this.getinservice() || typsim != 1 && typsim != 2 && typsim != 4 || this.unser_p == 0.0 && this.unser_q == 0.0)) {
                g.setColor(Color1);
                g.drawString("Unser. Energy !", (int)(((double)x + 2.0) * (double)gs), (int)(((double)y + 8.0) * (double)gs));
            }
        } else if (this.p > 0.0) {
            if (!this.inservice) {
                g.setColor(Color.black);
            } else {
                g.setColor(Color.green);
            }
            if (cycle) {
                GraphicsUtil.drawArrow(g, (int)(((double)x + 2.0) * (double)gs), (int)(((double)y - 4.0) * (double)gs), (int)(((double)x + 2.0) * (double)gs), (y - 1) * gs, 1, (int)((double)gs * 1.5));
            } else {
                GraphicsUtil.drawArrow(g, (int)(((double)x + 2.0) * (double)gs), (int)(((double)y - 1.0) * (double)gs), (int)(((double)x + 2.0) * (double)gs), (y + 2) * gs, 1, (int)((double)gs * 1.5));
            }
        }
    }

    public void updateload(double sref, int actperiod, int actmonth, double fac1, double fac2) {
        this.setq0((this.ldc_pmin * fac1 + this.ldc_pmax * fac2) / 100.0 * this.getqini() * Math.pow(1.0 + this.grate / 100.0, ((double)(actperiod - this.entry_period) * 12.0 - (double)(this.entry_month - 1) + (double)(actmonth - 1)) / 12.0));
        this.setp0((this.ldc_pmin * fac1 + this.ldc_pmax * fac2) / 100.0 * this.getpini() * Math.pow(1.0 + this.grate / 100.0, ((double)(actperiod - this.entry_period) * 12.0 - (double)(this.entry_month - 1) + (double)(actmonth - 1)) / 12.0));
        this.setp(this.getp0());
        this.setq(this.getq0());
    }

    @Override
    public void Save(PrintStream myPrintStream) {
        myPrintStream.println("describe component " + this.ClassName);
        myPrintStream.println(" pos " + this.Pos.x + " " + this.Pos.y);
        myPrintStream.println(" Name " + this.ComponentName);
        myPrintStream.println(" type " + this.inv_type);
        myPrintStream.println(" owner " + this.inv_owner);
        myPrintStream.println(" cost " + this.inv_cost);
        myPrintStream.println(" un1 " + this.un[0]);
        myPrintStream.println(" lifetime " + this.life_time);
        myPrintStream.println(" entryperiod " + this.entry_period);
        myPrintStream.println(" exitperiod " + this.exit_period);
        myPrintStream.println(" entrymonth " + this.entry_month);
        myPrintStream.println(" exitmonth " + this.exit_month);
        myPrintStream.println(" pini " + this.pini);
        myPrintStream.println(" qini " + this.qini);
        myPrintStream.println(" alpha " + this.alpha);
        myPrintStream.println(" beta " + this.beta);
        myPrintStream.println(" gamma " + this.gamma);
        myPrintStream.println(" grate " + this.grate);
        myPrintStream.println(" ldc_T " + this.ldc_T);
        myPrintStream.println(" ldc_pmin " + this.ldc_pmin);
        myPrintStream.println(" ldc_pmax " + this.ldc_pmax);
        myPrintStream.println(" vd_p " + this.vd_p);
        myPrintStream.println(" vd_q " + this.vd_q);
        myPrintStream.println(" latitude " + this.latitude);
        myPrintStream.println(" longitude " + this.longitude);
        myPrintStream.println(" ctrla " + this.ctrla);
        myPrintStream.println(" place " + this.place);
        myPrintStream.println(" inservice  " + this.inservice);
        myPrintStream.println(" fcaPLP  " + this.fcaPLP);
        myPrintStream.println("end describe");
    }

    @Override
    public void SaveDatabase() throws SQLException {
        int x = 0;
        Statement stmt = DeepEditFrame.con.createStatement();
        String query = "INSERT INTO `Load` (XPos, YPos, Name, type, owner, ctrla, cost, un1, smax, lifetime, entryperiod, exitperiod, entrymonth, exitmonth, pini, qini, alpha, beta, gamma, ldc_T, ldc_pmin, ldc_pmax, grate, latitude, longitude, place,U,delta,p,q,p0,q0,spotp,spotq,unser_p,unser_q,con2,inservice,fcaPLP,vd_p,vd_q) VALUES (" + String.valueOf(this.Pos.x) + "," + String.valueOf(this.Pos.y) + ",'" + this.ComponentName + "','" + this.inv_type + "','" + this.inv_owner + "','" + this.ctrla + "'," + String.valueOf(this.inv_cost) + "," + String.valueOf(this.un[0]) + "," + String.valueOf(this.smax) + "," + String.valueOf(this.life_time) + "," + String.valueOf(this.entry_period) + "," + String.valueOf(this.exit_period) + "," + String.valueOf(this.entry_month) + "," + String.valueOf(this.exit_month) + "," + String.valueOf(this.pini) + "," + String.valueOf(this.qini) + "," + String.valueOf(this.alpha) + "," + String.valueOf(this.beta) + "," + String.valueOf(this.gamma) + "," + String.valueOf(this.ldc_T) + "," + String.valueOf(this.ldc_pmin) + "," + String.valueOf(this.ldc_pmax) + "," + String.valueOf(this.grate) + "," + String.valueOf(this.latitude) + "," + String.valueOf(this.longitude) + ",'" + this.place + "'," + String.valueOf(this.getun2()) + "," + String.valueOf(this.getdelta2()) + "," + String.valueOf(this.p) + "," + String.valueOf(this.q) + "," + String.valueOf(this.p0) + "," + String.valueOf(this.q0) + "," + String.valueOf(this.spot_p) + "," + String.valueOf(this.spot_q) + "," + String.valueOf(this.unser_p) + "," + String.valueOf(this.unser_q) + ",'" + this.con2 + "'," + (this.inservice ? 1 : 0) + "," + String.valueOf(this.fcaPLP) + "," + String.valueOf(this.vd_p) + "," + String.valueOf(this.vd_q) + ")";
        x = stmt.executeUpdate(query);
        stmt.close();
    }

    public String Statistic(int ix, double sref) {
        this.InformAllComponents();
        return StringUtil.printf(this.getName(), 25) + StringUtil.printf(this.getp(), 10, 2) + StringUtil.printf(this.getq(), 10, 2) + StringUtil.printf(this.pini, 10, 2) + StringUtil.printf(this.qini, 10, 2) + StringUtil.printf(this.getentry_period(), 10);
    }

    public boolean setPfromSimSt(int stage, int block) {
        if (this.p_SimStBlMat == null || this.p_SimStBlMat.length <= stage || this.p_SimStBlMat[stage].length <= block) {
            return false;
        }
        this.setp(this.p_SimStBlMat[stage][block]);
        this.setp0(this.p_SimStBlMat[stage][block]);
        return true;
    }

    public void setP_SimStBlMat(double[][] p_Matrix) {
        this.p_SimStBlMat = p_Matrix;
    }

    public void initializelimits(int n_stage, int n_blocks) {
        this.plimits = new double[n_stage][n_blocks][2];
        for (int i = 0; i < n_stage; ++i) {
            for (int j = 0; j < n_blocks; ++j) {
                for (int k = 0; k < 2; ++k) {
                    this.plimits[i][j][k] = 100.0;
                }
            }
        }
    }

    public void setlimits(int stage, int block) {
        if (this.plimits != null && stage < this.plimits.length && block < this.plimits[0].length) {
            this.setldc_pmin(this.plimits[stage][block][0]);
            this.setldc_pmax(this.plimits[stage][block][1]);
        } else {
            this.setldc_pmin(100.0);
            this.setldc_pmax(100.0);
        }
    }

    public void fill_limits(int stage, int block, double min, double max) {
        if (this.plimits != null && stage < this.plimits.length && block < this.plimits[0].length) {
            this.plimits[stage][block][0] = min;
            this.plimits[stage][block][1] = max;
        } else {
            System.out.println("Error filling power limits for load " + this.getName() + " in stage " + (stage + 1) + " block " + (block + 1));
        }
    }

    public double getLoadFactor() {
        double dBusbarIniLoad = 0.0;
        for (comp c : this.getConnectedComponentList()) {
            if (!(c instanceof Busbar)) continue;
            for (comp c2 : c.getConnectedComponentList()) {
                if (!(c2 instanceof Load)) continue;
                dBusbarIniLoad += ((Load)c2).getpini();
            }
        }
        if (this.pini == 0.0 && dBusbarIniLoad == 0.0) {
            return 1.0;
        }
        return Utils.safeDivision(this.pini, dBusbarIniLoad);
    }

    @Override
    public boolean getParameterInfo(String sParameterName, ParameterData oData) {
        String sValue = null;
        DE_GeneralEnums.databaseDataType eDataType = null;
        DE_GeneralEnums.parameterGroup eGroup = null;
        oData.seteGroup(DE_GeneralEnums.parameterGroup.Operation);
        if (sParameterName.equalsIgnoreCase("Name")) {
            sValue = this.getName();
            eDataType = DE_GeneralEnums.databaseDataType.StringValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("con2")) {
            sValue = this.getcon2();
            eDataType = DE_GeneralEnums.databaseDataType.StringValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("un1")) {
            sValue = String.valueOf(this.getun1());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("smax")) {
            sValue = String.valueOf(this.getsmax());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("inservicei")) {
            sValue = String.valueOf(this.getinservicei());
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("inservice")) {
            sValue = String.valueOf(this.getinservice());
            eDataType = DE_GeneralEnums.databaseDataType.BooleanValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("delta")) {
            sValue = String.valueOf(this.getdelta2());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("fcaPLP")) {
            sValue = String.valueOf(this.getfcaPLP());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("grate")) {
            sValue = String.valueOf(this.getgrate());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("ldc_pmin")) {
            sValue = String.valueOf(this.getldc_pmin());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("ldc_pmax")) {
            sValue = String.valueOf(this.getldc_pmax());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("ldc_T")) {
            sValue = String.valueOf(this.getldc_T());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("ldc_T")) {
            sValue = String.valueOf(this.getldc_T());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("pini")) {
            sValue = String.valueOf(this.getpini());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("qini")) {
            sValue = String.valueOf(this.getqini());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("unser_p")) {
            sValue = String.valueOf(this.getunser_p());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("unser_q")) {
            sValue = String.valueOf(this.getunser_q());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("unser_q")) {
            sValue = String.valueOf(this.getunser_q());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("U")) {
            sValue = String.valueOf(this.getun2());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("vd_p")) {
            sValue = String.valueOf(this.getvd_p());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("vd_q")) {
            sValue = String.valueOf(this.getvd_q());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("p0")) {
            sValue = String.valueOf(this.getp0());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("q0")) {
            sValue = String.valueOf(this.getq0());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("p")) {
            sValue = String.valueOf(this.getp());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("q")) {
            sValue = String.valueOf(this.getq());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("mpPLP")) {
            sValue = String.valueOf(0);
            eDataType = DE_GeneralEnums.databaseDataType.StringValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("ntmpPLP")) {
            sValue = String.valueOf(3);
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("olPLP")) {
            sValue = String.valueOf(100);
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("spotp")) {
            sValue = String.valueOf(this.getspot_p());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("spotq")) {
            sValue = String.valueOf(this.getspot_q());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("type")) {
            sValue = this.getinv_type();
            eDataType = DE_GeneralEnums.databaseDataType.StringValue;
            eGroup = DE_GeneralEnums.parameterGroup.Economic;
        } else if (sParameterName.equalsIgnoreCase("owner")) {
            sValue = this.getinv_owner();
            eDataType = DE_GeneralEnums.databaseDataType.StringValue;
            eGroup = DE_GeneralEnums.parameterGroup.Economic;
        } else if (sParameterName.equalsIgnoreCase("lifetime")) {
            sValue = String.valueOf(this.getlife_time());
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Economic;
        } else if (sParameterName.equalsIgnoreCase("entryperiod")) {
            sValue = String.valueOf(this.getentry_period());
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Economic;
        } else if (sParameterName.equalsIgnoreCase("exitperiod")) {
            sValue = String.valueOf(this.getexit_period());
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Economic;
        } else if (sParameterName.equalsIgnoreCase("cost")) {
            sValue = String.valueOf(this.getinv_cost());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Economic;
        } else if (sParameterName.equalsIgnoreCase("entrymonth")) {
            sValue = String.valueOf(this.getentry_month());
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Economic;
        } else if (sParameterName.equalsIgnoreCase("exitmonth")) {
            sValue = String.valueOf(this.getexit_month());
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Economic;
        } else if (sParameterName.equalsIgnoreCase("alpha")) {
            sValue = String.valueOf(this.getalpha());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Economic;
        } else if (sParameterName.equalsIgnoreCase("beta")) {
            sValue = String.valueOf(this.getalpha());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Economic;
        } else if (sParameterName.equalsIgnoreCase("gamma")) {
            sValue = String.valueOf(this.getgamma());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Economic;
        } else if (sParameterName.equalsIgnoreCase("ctrla")) {
            sValue = this.getctrla();
            eDataType = DE_GeneralEnums.databaseDataType.StringValue;
            eGroup = DE_GeneralEnums.parameterGroup.Location;
        } else if (sParameterName.equalsIgnoreCase("Xpos")) {
            sValue = String.valueOf(this.getxpos());
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Location;
        } else if (sParameterName.equalsIgnoreCase("Ypos")) {
            sValue = String.valueOf(this.getypos());
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Location;
        } else if (sParameterName.equalsIgnoreCase("latitude")) {
            sValue = String.valueOf(this.getlatitude());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Location;
        } else if (sParameterName.equalsIgnoreCase("longitude")) {
            sValue = String.valueOf(this.getlongitude());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Location;
        } else if (sParameterName.equalsIgnoreCase("place")) {
            sValue = this.getplace();
            eDataType = DE_GeneralEnums.databaseDataType.StringValue;
            eGroup = DE_GeneralEnums.parameterGroup.Location;
        }
        if (sValue != null) {
            oData.setValue(sValue, eDataType, eGroup);
        } else {
            ParameterData oDataOld = (ParameterData)this.mData.get(sParameterName);
            if (oDataOld == null && (oDataOld = DeepEdit.getDefaultParameterInfo(this.ClassName, sParameterName)) == null) {
                assert (false) : "Why are you looking for parameter '" + sParameterName + "' if it is not supported by object '" + this.ClassName + "?";
                return false;
            }
            oDataOld.copyParameterInto(oData);
        }
        return true;
    }

    @Override
    public boolean setParameterInfo(String sParameterName, ParameterData pData) {
        String sValue = pData.getValue();
        if (sParameterName.equalsIgnoreCase("Name")) {
            this.setName(sValue);
            return true;
        }
        if (sParameterName.equalsIgnoreCase("con2")) {
            this.setcon2(sValue);
            return true;
        }
        if (sParameterName.equalsIgnoreCase("un1")) {
            this.setun1(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("smax")) {
            this.setsmax(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("inservicei")) {
            this.setinservicei(Integer.parseInt(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("inservice")) {
            this.setinservice(Boolean.parseBoolean(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("delta")) {
            this.setdelta2(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("fcaPLP")) {
            this.setfcaPLP(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("grate")) {
            this.setgrate(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("ldc_pmin")) {
            this.setldc_pmin(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("ldc_pmax")) {
            this.setldc_pmax(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("ldc_T")) {
            this.setldc_T(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("ldc_T")) {
            this.setldc_T(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("pini")) {
            this.setpini(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("qini")) {
            this.setqini(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("unser_p")) {
            this.setunser_p(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("unser_q")) {
            this.setunser_q(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("unser_q")) {
            this.setunser_q(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("U")) {
            this.setun2(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("vd_p")) {
            this.setvd_p(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("vd_q")) {
            this.setvd_q(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("p0")) {
            this.setp0(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("q0")) {
            this.setq0(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("p")) {
            this.setp(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("q")) {
            this.setq(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("mpPLP")) {
            return true;
        }
        if (sParameterName.equalsIgnoreCase("ntmpPLP")) {
            return true;
        }
        if (sParameterName.equalsIgnoreCase("olPLP")) {
            return true;
        }
        if (sParameterName.equalsIgnoreCase("spotp")) {
            this.setspot_p(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("spotq")) {
            this.setspot_q(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("type")) {
            this.setinv_type(sValue);
            return true;
        }
        if (sParameterName.equalsIgnoreCase("owner")) {
            this.setinv_owner(sValue);
            return true;
        }
        if (sParameterName.equalsIgnoreCase("lifetime")) {
            this.setlife_time((int)Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("entryperiod")) {
            this.setentry_period((int)Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("exitperiod")) {
            this.setexit_period((int)Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("cost")) {
            this.setinv_cost(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("entrymonth")) {
            this.setentry_month((int)Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("exitmonth")) {
            this.setexit_month((int)Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("alpha")) {
            this.setalpha(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("beta")) {
            this.setalpha(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("gamma")) {
            this.setgamma(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("ctrla")) {
            this.setctrla(sValue);
            return true;
        }
        if (sParameterName.equalsIgnoreCase("Xpos")) {
            this.setxpos((int)Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("Ypos")) {
            this.setypos((int)Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("latitude")) {
            this.setlatitude(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("longitude")) {
            this.setlongitude(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("place")) {
            this.setplace(sValue);
            return true;
        }
        ParameterData pDataOld = (ParameterData)this.mData.get(sParameterName);
        if (pDataOld != null) {
            pDataOld.setValue(sValue);
        } else {
            this.mData.put(sParameterName, pData);
        }
        return true;
    }
}

