/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import de.core.Busbar;
import de.core.DeepEdit;
import de.core.DeepEditFrame;
import de.core.GraphicsUtil;
import de.core.InputPin;
import de.core.Pin;
import de.core.comp;
import de.core.ndb_branch;
import de.data.DE_GeneralEnums;
import de.data.ParameterData;
import de.utils.StringUtil;
import java.awt.Color;
import java.awt.Graphics2D;
import java.io.PrintStream;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;

class LineDC
extends ndb_branch {
    public double simx1;
    public double simx2;
    public double simy1;
    public double simy2;
    protected boolean above = true;
    public Vector ConnComps1;
    public Vector ConnComps2;
    protected double len = 0.0;
    protected double lresis = 0.0;
    public double potdrec = 0.0;
    public double potinv = 0.0;
    public double vinv = 0.0;
    public int nbridge = 0;
    public double mintapr = 0.0;
    public double mintapi = 0.0;
    public double maxtapr = 0.0;
    public double maxtapi = 0.0;
    public double minfir = 0.0;
    public double minext = 0.0;
    public double maxfir = 0.0;
    public double maxext = 0.0;
    public double resrec = 0.0;
    public double resinv = 0.0;
    public double reacrec = 0.0;
    public double reacinv = 0.0;
    public double sv = 0.0;
    public double id = 0.0;
    public double qrect = 0.0;
    public double qinver = 0.0;
    public double angfir = 0.0;
    public double angext = 0.0;

    public LineDC(Pin[][] PinGrid, int x, int y, int entryperiod, int exitperiod, int entrymonth, int exitmonth) {
        super(1, x, y, 2, entryperiod, exitperiod, entrymonth, exitmonth);
        this.setName("LineDC");
        this.ClassName = "LineDC";
        this.verhor = false;
        this.swapPS = false;
        this.project = "NONE";
        this.alternative = "NONE";
        this.suggest = false;
        this.IPin[0] = this.verhor ? new InputPin("A", 3, 1, 0, 3, 0, 0, 2) : new InputPin("A", 1, 3, 3, 0, 0, 0, 2);
        this.inv_type = "A";
        this.q21 = 0.0;
        this.p21 = 0.0;
        this.q12 = 0.0;
        this.p12 = 0.0;
        this.RegisterPins(PinGrid, x, y);
    }

    public LineDC(Pin[][] PinGrid, int x, int y, String Name, String type, String alias, String owner, String ctrla, double cost, double coym, double un1, double un2, double ppotdrec, double llresis, double ssmax, double ssn, int lifetime, int entryperiod, int exitperiod, int entrymonth, int exitmonth, double incomep, double incomeq, double mmintapr, double mmintapi, double mmaxtapr, double mmaxtapi, double ssv, double llen, boolean vverhor, boolean sswapPS, int pplanning, double mminext, double mminfir, double mmaxext, double mmaxfir, double rresrec, double rresinv, double rreacrec, double rreacinv, double vvinv, int nnbridge, double qqrect, double qqinver, String pproject, String aalternative, boolean ssuggest, double ssc, boolean iinservice) {
        super(1, x, y, 2, Name, type, alias, owner, ctrla, cost, coym, un1, un2, ssmax, lifetime, entryperiod, exitperiod, entrymonth, exitmonth, incomep, incomeq, vverhor, pplanning, ssc);
        this.project = pproject;
        this.alternative = aalternative;
        this.suggest = ssuggest;
        this.swapPS = sswapPS;
        this.ClassName = "LineDC";
        this.inservice = iinservice;
        this.vinv = vvinv;
        this.nbridge = nnbridge;
        this.potdrec = ppotdrec;
        this.lresis = llresis;
        this.mintapr = mmintapr;
        this.mintapi = mmintapi;
        this.maxtapr = mmaxtapr;
        this.maxtapi = mmaxtapi;
        this.minfir = mminfir;
        this.minext = mminext;
        this.maxfir = mmaxfir;
        this.maxext = mmaxext;
        this.resrec = rresrec;
        this.resinv = rresinv;
        this.reacrec = rreacrec;
        this.reacinv = rreacinv;
        this.qrect = qqrect;
        this.qinver = qqinver;
        this.sn = ssn;
        this.sv = ssv;
        this.len = llen;
        this.un[0] = un1;
        this.un[1] = un2;
        this.verhor = vverhor;
        this.IPin[0] = this.verhor ? new InputPin("A", 3, 1, 0, 3, 0, 0, 2) : new InputPin("A", 1, 3, 3, 0, 0, 0, 2);
        this.RegisterPins(PinGrid, x, y);
    }

    public LineDC(comp CompToCopy, int xo, int yo) {
        super(CompToCopy, xo, yo);
        this.project = "NONE";
        this.alternative = "NONE";
        this.suggest = false;
    }

    public double getlen() {
        return this.len;
    }

    public double getlresis() {
        return this.lresis;
    }

    public double getsv() {
        return this.sv;
    }

    public double getpotdrec() {
        return this.potdrec;
    }

    public double getmintapr() {
        return this.mintapr;
    }

    public double getmintapi() {
        return this.mintapi;
    }

    public double getmaxtapr() {
        return this.maxtapr;
    }

    public double getmaxtapi() {
        return this.maxtapi;
    }

    public double getminfir() {
        return this.minfir;
    }

    public double getminext() {
        return this.minext;
    }

    public double getmaxfir() {
        return this.maxfir;
    }

    public double getmaxext() {
        return this.maxext;
    }

    public double getresrec() {
        return this.resrec;
    }

    public double getresinv() {
        return this.resinv;
    }

    public double getreacinv() {
        return this.reacinv;
    }

    public double getreacrec() {
        return this.reacrec;
    }

    public double getvinv() {
        return this.vinv;
    }

    public double getqrect() {
        return this.qrect;
    }

    public double getqinver() {
        return this.qinver;
    }

    public double getnbridge() {
        return this.nbridge;
    }

    public double getpotinv() {
        return this.potinv;
    }

    public double getangfir() {
        return this.angfir;
    }

    public double getangext() {
        return this.angext;
    }

    public void setlen(double n) {
        this.len = n;
    }

    public void setvinv(double n) {
        this.vinv = n;
    }

    public void setmintapr(double n) {
        this.mintapr = n;
    }

    public void setmintapi(double n) {
        this.mintapi = n;
    }

    public void setmaxtapr(double n) {
        this.maxtapr = n;
    }

    public void setmaxtapi(double n) {
        this.maxtapi = n;
    }

    public void setminfir(double n) {
        this.minfir = n;
    }

    public void setmaxfir(double n) {
        this.maxfir = n;
    }

    public void setminext(double n) {
        this.minext = n;
    }

    public void setmaxext(double n) {
        this.maxext = n;
    }

    public void setreacrec(double n) {
        this.reacrec = n;
    }

    public void setreacinv(double n) {
        this.reacinv = n;
    }

    public void setlresis(double n) {
        this.lresis = n;
    }

    public void setresrec(double n) {
        this.resrec = n;
    }

    public void setresinv(double n) {
        this.resinv = n;
    }

    public void setnbridge(int n) {
        this.nbridge = n;
    }

    public void setsv(double n) {
        this.sv = n;
    }

    public void setqrect(double n) {
        this.qrect = n;
    }

    public void setqinver(double n) {
        this.qinver = n;
    }

    public void setpotdrec(double n) {
        this.potdrec = n;
    }

    public void setpotinv(double n) {
        this.potinv = n;
    }

    public void setangfir(double n) {
        this.angfir = n;
    }

    public void setangext(double n) {
        this.angext = n;
    }

    @Override
    public void setverhor(boolean n) {
        if (this.verhor != n) {
            this.RemovePinsGrid(DeepEdit.PinGrid);
            if (n) {
                this.setHitbox(4, 20, 1, 4, 4, 14);
                this.setPins(3, 1, 0, 3, 0, 0, 3, 21, 0, -3, 0, 0);
            } else {
                this.setHitbox(20, 4, 4, 1, 14, 4);
                this.setPins(1, 3, 3, 0, 0, 0, 21, 3, -3, 0, 0, 0);
            }
            this.verhor = n;
            this.RegisterPins(DeepEdit.PinGrid, this.getxpos(), this.getypos());
        }
    }

    @Override
    public comp Copy(int xo, int yo) {
        LineDC NewComponent = new LineDC(this, xo, yo);
        NewComponent.setun1(this.getun1());
        NewComponent.setun2(this.getun2());
        NewComponent.setlife_time(this.getlife_time());
        NewComponent.setentry_period(this.getentry_period());
        NewComponent.setexit_period(this.getexit_period());
        NewComponent.setcoym(this.getcoym());
        NewComponent.setinv_cost(this.getinv_cost());
        NewComponent.setinv_type(this.getinv_type());
        NewComponent.setinv_owner(this.getinv_owner());
        NewComponent.setm_incomep(this.getm_incomep());
        NewComponent.setm_incomeq(this.getm_incomeq());
        NewComponent.setverhor(this.getverhor());
        NewComponent.setswapPS(this.getswapPS());
        NewComponent.setsmax(this.getsmax());
        NewComponent.setsc(this.getsc());
        NewComponent.setsn(this.getsn());
        NewComponent.setverhor(this.getverhor());
        NewComponent.setswapPS(this.getswapPS());
        NewComponent.setreacrec(this.getreacrec());
        NewComponent.setreacinv(this.getreacinv());
        NewComponent.setctrla(this.getctrla());
        NewComponent.setalias(this.getalias());
        return NewComponent;
    }

    @Override
    public void SimulateSetUpFlows(double sref) {
        double belastung2;
        double counterflow = Math.abs(this.p12) + Math.abs(this.p21);
        double diffflow = Math.abs(this.p12) - Math.abs(this.p21);
        this.simx1 = 0.0;
        double belastung1 = Math.sqrt(Math.abs(this.p21) * Math.abs(this.p21) + Math.abs(this.q21) * Math.abs(this.q21));
        double belastung = Math.max(belastung1, belastung2 = Math.sqrt(Math.abs(this.p12) * Math.abs(this.p12) + Math.abs(this.q12) * Math.abs(this.q12))) / (this.getsmax() * this.sc) * sref;
        this.auxcolor = belastung >= 1.0 ? Color.red : (belastung >= 0.9 ? Color.magenta : (belastung >= 0.5 ? Color.orange : Color.green));
        if (counterflow == 0.0) {
            return;
        }
        if (this.verhor) {
            if (Math.abs(this.p12) > Math.abs(this.p21) || diffflow == 0.0 && this.p12 > this.p21) {
                this.simx1 = 3.0;
                this.simx2 = 3.0;
                if (this.swapPS) {
                    this.simy1 = 12.0;
                    this.simy2 = 2.0;
                } else {
                    this.simy1 = 2.0;
                    this.simy2 = 12.0;
                }
            } else {
                this.simx1 = 3.0;
                this.simx2 = 3.0;
                if (this.swapPS) {
                    this.simy1 = 2.0;
                    this.simy2 = 12.0;
                } else {
                    this.simy1 = 12.0;
                    this.simy2 = 2.0;
                }
            }
        } else if (Math.abs(this.p12) > Math.abs(this.p21) || diffflow == 0.0 && this.p12 > this.p21) {
            if (this.swapPS) {
                this.simx1 = 12.0;
                this.simx2 = 2.0;
            } else {
                this.simx1 = 2.0;
                this.simx2 = 12.0;
            }
            this.simy1 = 3.0;
            this.simy2 = 3.0;
        } else {
            if (this.swapPS) {
                this.simx1 = 2.0;
                this.simx2 = 12.0;
            } else {
                this.simx1 = 12.0;
                this.simx2 = 2.0;
            }
            this.simy1 = 3.0;
            this.simy2 = 3.0;
        }
    }

    public boolean InformRelativePosition(Vector ActVector) {
        boolean nc = false;
        int inp = -1;
        int out = -1;
        for (int ix = 0; ix < ActVector.size(); ++ix) {
            comp ConnectedComponent = (comp)ActVector.elementAt(ix);
            if (ConnectedComponent == this) continue;
            inp = ConnectedComponent.InformInput(this);
            if (inp != -1) {
                this.above = true;
            }
            if ((out = ConnectedComponent.InformOutput(this)) != -1) {
                this.above = false;
            }
            return true;
        }
        return false;
    }

    public String Statistic(int ix, double sref) {
        this.InformAllComponents();
        return " ";
    }

    public void draw(Graphics2D g, int xp, int yp, int gs, boolean Modifiedstate, boolean Simulate, boolean cycle, boolean ShowReactive, double sref) {
        super.draw(g, xp, yp, gs);
        int x = this.Pos.x - xp;
        int y = this.Pos.y - yp;
        boolean auxint = true;
        boolean relative1 = true;
        boolean relative2 = true;
        if (!Simulate) {
            if (!this.swapPS && !this.verhor) {
                g.setColor(this.getkv_color1());
                g.drawLine((x + 4) * gs, (y + 1) * gs, (x + 8) * gs, (y + 1) * gs);
                g.drawLine((x + 4) * gs, (y + 5) * gs, (x + 8) * gs, (y + 5) * gs);
                g.drawLine((x + 4) * gs, (y + 1) * gs, (x + 4) * gs, (y + 5) * gs);
                g.drawLine((x + 8) * gs, (y + 1) * gs, (x + 8) * gs, (y + 5) * gs);
                g.drawLine((x + 5) * gs, (y + 3) * gs, (x + 6) * gs, (y + 3) * gs);
                g.drawLine((x + 6) * gs, (y + 2) * gs, (x + 6) * gs, (y + 4) * gs);
                g.drawLine((x + 6) * gs, (y + 2) * gs, (x + 7) * gs, (y + 3) * gs);
                g.drawLine((x + 6) * gs, (y + 4) * gs, (x + 7) * gs, (y + 3) * gs);
                g.drawLine((x + 7) * gs, (y + 2) * gs, (x + 7) * gs, (y + 4) * gs);
                g.drawLine((x + 14) * gs, (y + 1) * gs, (x + 18) * gs, (y + 1) * gs);
                g.drawLine((x + 14) * gs, (y + 5) * gs, (x + 18) * gs, (y + 5) * gs);
                g.drawLine((x + 14) * gs, (y + 1) * gs, (x + 14) * gs, (y + 5) * gs);
                g.drawLine((x + 18) * gs, (y + 1) * gs, (x + 18) * gs, (y + 5) * gs);
                g.drawLine((x + 15) * gs, (y + 3) * gs, (x + 16) * gs, (y + 3) * gs);
                g.drawLine((x + 16) * gs, (y + 2) * gs, (x + 16) * gs, (y + 4) * gs);
                g.drawLine((x + 16) * gs, (y + 2) * gs, (x + 17) * gs, (y + 3) * gs);
                g.drawLine((x + 16) * gs, (y + 4) * gs, (x + 17) * gs, (y + 3) * gs);
                g.drawLine((x + 17) * gs, (y + 2) * gs, (x + 17) * gs, (y + 4) * gs);
                g.drawLine((x + 8) * gs, (y + 2) * gs, (x + 14) * gs, (y + 2) * gs);
                g.drawLine((x + 8) * gs, (y + 4) * gs, (x + 14) * gs, (y + 4) * gs);
                g.setColor(Color.gray);
                if (gs > 2 && gs < 4) {
                    g.setFont(Font8);
                } else if (gs >= 4 && gs < 8) {
                    g.setFont(Font8);
                    g.drawString(this.ComponentName, (x + 9) * gs, (y + 1) * gs);
                } else if (gs >= 8 && gs < 10) {
                    g.setFont(Font9);
                    g.drawString(this.ComponentName, (x + 9) * gs, (y + 1) * gs);
                } else if (gs >= 10 && gs < 14) {
                    g.setFont(Font12);
                    g.drawString(this.ComponentName, (x + 9) * gs, (y + 1) * gs);
                } else if (gs >= 14 && gs < 18) {
                    g.setFont(Font16);
                    g.drawString(this.ComponentName, (x + 9) * gs, (y + 1) * gs);
                }
            }
            if (this.swapPS && !this.verhor) {
                g.drawLine((x + 4) * gs, (y + 1) * gs, (x + 8) * gs, (y + 1) * gs);
                g.drawLine((x + 4) * gs, (y + 5) * gs, (x + 8) * gs, (y + 5) * gs);
                g.drawLine((x + 4) * gs, (y + 1) * gs, (x + 4) * gs, (y + 5) * gs);
                g.drawLine((x + 8) * gs, (y + 1) * gs, (x + 8) * gs, (y + 5) * gs);
                g.drawLine((x + 6) * gs, (y + 3) * gs, (x + 7) * gs, (y + 3) * gs);
                g.drawLine((x + 6) * gs, (y + 2) * gs, (x + 6) * gs, (y + 4) * gs);
                g.drawLine((x + 6) * gs, (y + 2) * gs, (x + 5) * gs, (y + 3) * gs);
                g.drawLine((x + 6) * gs, (y + 4) * gs, (x + 5) * gs, (y + 3) * gs);
                g.drawLine((x + 5) * gs, (y + 2) * gs, (x + 5) * gs, (y + 4) * gs);
                g.drawLine((x + 14) * gs, (y + 1) * gs, (x + 18) * gs, (y + 1) * gs);
                g.drawLine((x + 14) * gs, (y + 5) * gs, (x + 18) * gs, (y + 5) * gs);
                g.drawLine((x + 14) * gs, (y + 1) * gs, (x + 14) * gs, (y + 5) * gs);
                g.drawLine((x + 18) * gs, (y + 1) * gs, (x + 18) * gs, (y + 5) * gs);
                g.drawLine((x + 16) * gs, (y + 3) * gs, (x + 17) * gs, (y + 3) * gs);
                g.drawLine((x + 16) * gs, (y + 2) * gs, (x + 16) * gs, (y + 4) * gs);
                g.drawLine((x + 16) * gs, (y + 2) * gs, (x + 15) * gs, (y + 3) * gs);
                g.drawLine((x + 16) * gs, (y + 4) * gs, (x + 15) * gs, (y + 3) * gs);
                g.drawLine((x + 15) * gs, (y + 2) * gs, (x + 15) * gs, (y + 4) * gs);
                g.drawLine((x + 8) * gs, (y + 2) * gs, (x + 14) * gs, (y + 2) * gs);
                g.drawLine((x + 8) * gs, (y + 4) * gs, (x + 14) * gs, (y + 4) * gs);
                g.setColor(Color.gray);
                if (gs > 2 && gs < 4) {
                    g.setFont(Font8);
                } else if (gs >= 4 && gs < 8) {
                    g.setFont(Font8);
                    g.drawString(this.ComponentName, (x + 10) * gs, (y + 1) * gs);
                } else if (gs >= 8 && gs < 10) {
                    g.setFont(Font9);
                    g.drawString(this.ComponentName, (x + 10) * gs, (y + 1) * gs);
                } else if (gs >= 10 && gs < 14) {
                    g.setFont(Font12);
                    g.drawString(this.ComponentName, (x + 10) * gs, (y + 1) * gs);
                } else if (gs >= 14 && gs < 18) {
                    g.setFont(Font16);
                    g.drawString(this.ComponentName, (x + 10) * gs, (y + 1) * gs);
                }
            }
            if (!this.swapPS && this.verhor) {
                g.setColor(this.getkv_color1());
                g.drawLine((x + 1) * gs, (y + 4) * gs, (x + 5) * gs, (y + 4) * gs);
                g.drawLine((x + 1) * gs, (y + 8) * gs, (x + 5) * gs, (y + 8) * gs);
                g.drawLine((x + 1) * gs, (y + 4) * gs, (x + 1) * gs, (y + 8) * gs);
                g.drawLine((x + 5) * gs, (y + 4) * gs, (x + 5) * gs, (y + 8) * gs);
                g.drawLine((x + 3) * gs, (y + 5) * gs, (x + 3) * gs, (y + 6) * gs);
                g.drawLine((x + 2) * gs, (y + 6) * gs, (x + 4) * gs, (y + 6) * gs);
                g.drawLine((x + 2) * gs, (y + 6) * gs, (x + 3) * gs, (y + 7) * gs);
                g.drawLine((x + 4) * gs, (y + 6) * gs, (x + 3) * gs, (y + 7) * gs);
                g.drawLine((x + 2) * gs, (y + 7) * gs, (x + 4) * gs, (y + 7) * gs);
                g.drawLine((x + 1) * gs, (y + 14) * gs, (x + 5) * gs, (y + 14) * gs);
                g.drawLine((x + 1) * gs, (y + 18) * gs, (x + 5) * gs, (y + 18) * gs);
                g.drawLine((x + 1) * gs, (y + 14) * gs, (x + 1) * gs, (y + 18) * gs);
                g.drawLine((x + 5) * gs, (y + 14) * gs, (x + 5) * gs, (y + 18) * gs);
                g.drawLine((x + 3) * gs, (y + 15) * gs, (x + 3) * gs, (y + 16) * gs);
                g.drawLine((x + 2) * gs, (y + 16) * gs, (x + 4) * gs, (y + 16) * gs);
                g.drawLine((x + 2) * gs, (y + 16) * gs, (x + 3) * gs, (y + 17) * gs);
                g.drawLine((x + 4) * gs, (y + 16) * gs, (x + 3) * gs, (y + 17) * gs);
                g.drawLine((x + 2) * gs, (y + 17) * gs, (x + 4) * gs, (y + 17) * gs);
                g.drawLine((x + 2) * gs, (y + 8) * gs, (x + 2) * gs, (y + 14) * gs);
                g.drawLine((x + 4) * gs, (y + 8) * gs, (x + 4) * gs, (y + 14) * gs);
                g.setColor(Color.gray);
                if (gs > 2 && gs < 4) {
                    g.setFont(Font8);
                } else if (gs >= 4 && gs < 8) {
                    g.setFont(Font8);
                    g.drawString(this.ComponentName, (x + 5) * gs, (y + 11) * gs);
                } else if (gs >= 8 && gs < 10) {
                    g.setFont(Font9);
                    g.drawString(this.ComponentName, (x + 5) * gs, (y + 11) * gs);
                } else if (gs >= 10 && gs < 14) {
                    g.setFont(Font12);
                    g.drawString(this.ComponentName, (x + 5) * gs, (y + 11) * gs);
                } else if (gs >= 14 && gs < 18) {
                    g.setFont(Font16);
                    g.drawString(this.ComponentName, (x + 5) * gs, (y + 11) * gs);
                }
            }
            if (this.swapPS && this.verhor) {
                g.setColor(this.getkv_color1());
                g.drawLine((x + 1) * gs, (y + 4) * gs, (x + 5) * gs, (y + 4) * gs);
                g.drawLine((x + 1) * gs, (y + 8) * gs, (x + 5) * gs, (y + 8) * gs);
                g.drawLine((x + 1) * gs, (y + 4) * gs, (x + 1) * gs, (y + 8) * gs);
                g.drawLine((x + 5) * gs, (y + 4) * gs, (x + 5) * gs, (y + 8) * gs);
                g.drawLine((x + 3) * gs, (y + 6) * gs, (x + 3) * gs, (y + 7) * gs);
                g.drawLine((x + 2) * gs, (y + 6) * gs, (x + 4) * gs, (y + 6) * gs);
                g.drawLine((x + 2) * gs, (y + 6) * gs, (x + 3) * gs, (y + 5) * gs);
                g.drawLine((x + 4) * gs, (y + 6) * gs, (x + 3) * gs, (y + 5) * gs);
                g.drawLine((x + 2) * gs, (y + 5) * gs, (x + 4) * gs, (y + 5) * gs);
                g.drawLine((x + 1) * gs, (y + 14) * gs, (x + 5) * gs, (y + 14) * gs);
                g.drawLine((x + 1) * gs, (y + 18) * gs, (x + 5) * gs, (y + 18) * gs);
                g.drawLine((x + 1) * gs, (y + 14) * gs, (x + 1) * gs, (y + 18) * gs);
                g.drawLine((x + 5) * gs, (y + 14) * gs, (x + 5) * gs, (y + 18) * gs);
                g.drawLine((x + 3) * gs, (y + 16) * gs, (x + 3) * gs, (y + 17) * gs);
                g.drawLine((x + 2) * gs, (y + 16) * gs, (x + 4) * gs, (y + 16) * gs);
                g.drawLine((x + 2) * gs, (y + 16) * gs, (x + 3) * gs, (y + 15) * gs);
                g.drawLine((x + 4) * gs, (y + 16) * gs, (x + 3) * gs, (y + 15) * gs);
                g.drawLine((x + 2) * gs, (y + 15) * gs, (x + 4) * gs, (y + 15) * gs);
                g.drawLine((x + 2) * gs, (y + 8) * gs, (x + 2) * gs, (y + 14) * gs);
                g.drawLine((x + 4) * gs, (y + 8) * gs, (x + 4) * gs, (y + 14) * gs);
                g.setColor(Color.gray);
                if (gs > 2 && gs < 4) {
                    g.setFont(Font8);
                } else if (gs >= 4 && gs < 8) {
                    g.setFont(Font8);
                    g.drawString(this.ComponentName, (x + 5) * gs, (y + 11) * gs);
                } else if (gs >= 8 && gs < 10) {
                    g.setFont(Font9);
                    g.drawString(this.ComponentName, (x + 5) * gs, (y + 11) * gs);
                } else if (gs >= 10 && gs < 14) {
                    g.setFont(Font12);
                    g.drawString(this.ComponentName, (x + 5) * gs, (y + 11) * gs);
                } else if (gs >= 14 && gs < 18) {
                    g.setFont(Font16);
                    g.drawString(this.ComponentName, (x + 5) * gs, (y + 11) * gs);
                }
            }
            if (gs >= 4) {
                if (gs >= 4 && gs < 8) {
                    g.setFont(Font8);
                } else if (gs >= 8 && gs < 10) {
                    g.setFont(Font9);
                } else {
                    g.setFont(Font10);
                }
                if (!Modifiedstate && this.getinservice()) {
                    int y2;
                    int y1;
                    int x2;
                    int x1;
                    if (this.verhor) {
                        x1 = x + 3;
                        x2 = x + 3;
                        if (this.swapPS) {
                            y1 = y + 13;
                            y2 = y + 1;
                        } else {
                            y1 = y + 1;
                            y2 = y + 13;
                        }
                    } else {
                        y1 = y + 3;
                        y2 = y + 3;
                        if (this.swapPS) {
                            x1 = x + 13;
                            x2 = x + 1;
                        } else {
                            x1 = x + 1;
                            x2 = x + 13;
                        }
                    }
                    double counterflow = Math.abs(this.potdrec);
                    double belastung1 = Math.sqrt(Math.abs(this.p21) * Math.abs(this.p21) + Math.abs(this.q21) * Math.abs(this.q21));
                    double belastung2 = Math.sqrt(Math.abs(this.p12) * Math.abs(this.p12) + Math.abs(this.q12) * Math.abs(this.q12));
                    double belastung = Math.max(belastung1, belastung2) / (this.getsmax() * this.sc) * sref;
                    if (belastung >= 0.9) {
                        g.setColor(Color.red);
                    } else if (belastung >= 0.5) {
                        g.setColor(Color.orange);
                    } else {
                        g.setColor(Color.green);
                    }
                    if (this.verhor) {
                        g.fillArc((x + 6) * gs, (y + 6) * gs, 2 * gs, 2 * gs, 90 - (int)(belastung * 360.0), (int)(belastung * 360.0));
                        g.setColor(TextColor1);
                        g.drawOval((x + 6) * gs, (y + 6) * gs, 2 * gs, 2 * gs);
                    } else {
                        g.fillArc((x + 5) * gs, (y + 8) * gs, 2 * gs, 2 * gs, 90 - (int)(belastung * 360.0), (int)(belastung * 360.0));
                        g.setColor(TextColor1);
                        g.drawOval((x + 5) * gs, (y + 8) * gs, 2 * gs, 2 * gs);
                    }
                    if (counterflow != 0.0) {
                        int posy;
                        int posx;
                        relative1 = this.swapPS ? this.InformRelativePosition(this.OPin[0].ConnComps) : this.InformRelativePosition(this.IPin[0].ConnComps);
                        if (relative1) {
                            posx = (int)(((double)x1 - 0.5) * (double)gs);
                            posy = y1 * gs;
                            if (this.above) {
                                g.setColor(Color1);
                                if (this.potdrec != 0.0) {
                                    g.drawString(StringUtil.printf(Math.abs(this.potdrec), 10, 2), posx - 4 * gs, (int)((double)posy + 1.2 * (double)gs));
                                }
                                if (this.potdrec > 0.0) {
                                    GraphicsUtil.drawArrow(g, posx, posy + 2 * gs, posx, posy, 1, (int)((double)gs * 0.3));
                                } else if (this.potdrec < 0.0) {
                                    GraphicsUtil.drawArrow(g, posx, posy, posx, posy + 2 * gs, 1, (int)((double)gs * 0.3));
                                }
                                if (ShowReactive) {
                                    g.setColor(TextColor1);
                                    if (this.q21 != 0.0 || this.q12 != 0.0) {
                                        g.drawString(StringUtil.printf(Math.abs(this.q12) * sref, 10, 2), posx - 4 * gs, (int)((double)posy + 2.2 * (double)gs));
                                    }
                                    if (this.q12 > 0.0) {
                                        GraphicsUtil.drawArrow(g, posx + gs, posy + 2 * gs, posx + gs, posy, 1, (int)((double)gs * 0.3));
                                    } else if (this.q12 < 0.0) {
                                        GraphicsUtil.drawArrow(g, posx + gs, posy, posx + gs, posy + 2 * gs, 1, (int)((double)gs * 0.3));
                                    }
                                }
                            } else {
                                g.setColor(Color1);
                                if (this.potdrec != 0.0) {
                                    g.drawString(StringUtil.printf(Math.abs(this.potdrec), 10, 2), posx - 4 * gs, (int)((double)posy - 2.2 * (double)gs));
                                }
                                if (this.potdrec > 0.0) {
                                    GraphicsUtil.drawArrow(g, posx, posy - 2 * gs, posx, posy, 1, (int)((double)gs * 0.3));
                                } else if (this.potdrec < 0.0) {
                                    GraphicsUtil.drawArrow(g, posx, posy, posx, posy - 2 * gs, 1, (int)((double)gs * 0.3));
                                }
                                if (ShowReactive) {
                                    g.setColor(TextColor1);
                                    if (this.q21 != 0.0 || this.q12 != 0.0) {
                                        g.drawString(StringUtil.printf(Math.abs(this.q12) * sref, 10, 2), posx - 4 * gs, (int)((double)posy - 1.2 * (double)gs));
                                    }
                                    if (this.q12 > 0.0) {
                                        GraphicsUtil.drawArrow(g, posx + gs, posy - 2 * gs, posx + gs, posy, 1, (int)((double)gs * 0.3));
                                    } else if (this.q12 < 0.0) {
                                        GraphicsUtil.drawArrow(g, posx + gs, posy, posx + gs, posy - 2 * gs, 1, (int)((double)gs * 0.3));
                                    }
                                }
                            }
                        }
                        if (relative2 = this.swapPS ? this.InformRelativePosition(this.IPin[0].ConnComps) : this.InformRelativePosition(this.OPin[0].ConnComps)) {
                            posx = (int)(((double)x2 - 0.5) * (double)gs);
                            posy = y2 * gs;
                            if (this.above) {
                                g.setColor(Color1);
                                if (-this.potdrec != 0.0) {
                                    g.drawString(StringUtil.printf(Math.abs(this.potdrec), 10, 2), posx + 5 * gs, (int)((double)posy + 1.2 * (double)gs));
                                }
                                if (-this.potdrec > 0.0) {
                                    GraphicsUtil.drawArrow(g, posx + 8 * gs, posy + 2 * gs, posx + 8 * gs, posy, 1, (int)((double)gs * 0.3));
                                } else if (-this.potdrec < 0.0) {
                                    GraphicsUtil.drawArrow(g, posx + 8 * gs, posy, posx + 8 * gs, posy + 2 * gs, 1, (int)((double)gs * 0.3));
                                }
                                if (ShowReactive) {
                                    g.setColor(TextColor1);
                                    if (this.q21 != 0.0 || this.q12 != 0.0) {
                                        g.drawString(StringUtil.printf(Math.abs(this.q21) * sref, 10, 2), posx - 4 * gs, (int)((double)posy + 2.2 * (double)gs));
                                    }
                                    if (this.q21 > 0.0 && this.q21 != 0.0) {
                                        GraphicsUtil.drawArrow(g, posx + gs, posy + 2 * gs, posx + gs, posy, 1, (int)((double)gs * 0.3));
                                    } else if (this.q21 < 0.0 && this.q21 != 0.0) {
                                        GraphicsUtil.drawArrow(g, posx + gs, posy, posx + gs, posy + 2 * gs, 1, (int)((double)gs * 0.3));
                                    }
                                }
                            } else {
                                g.setColor(Color1);
                                if (-this.potdrec != 0.0) {
                                    g.drawString(StringUtil.printf(Math.abs(this.potdrec), 10, 2), posx + 5 * gs, (int)((double)posy - 2.2 * (double)gs));
                                }
                                if (-this.potdrec > 0.0) {
                                    GraphicsUtil.drawArrow(g, posx + 8 * gs, posy - 2 * gs, posx + 8 * gs, posy, 1, (int)((double)gs * 0.3));
                                } else if (-this.potdrec < 0.0) {
                                    GraphicsUtil.drawArrow(g, posx + 8 * gs, posy, posx + 8 * gs, posy - 2 * gs, 1, (int)((double)gs * 0.3));
                                }
                                if (ShowReactive) {
                                    g.setColor(TextColor1);
                                    if (this.q21 != 0.0 || this.q12 != 0.0) {
                                        g.drawString(StringUtil.printf(Math.abs(this.q21) * sref, 10, 2), posx - 4 * gs, (int)((double)posy - 1.2 * (double)gs));
                                    }
                                    if (this.q21 > 0.0 && this.q21 != 0.0) {
                                        GraphicsUtil.drawArrow(g, posx + gs, posy - 2 * gs, posx + gs, posy, 1, (int)((double)gs * 0.3));
                                    } else if (this.q21 < 0.0 && this.q21 != 0.0) {
                                        GraphicsUtil.drawArrow(g, posx + gs, posy, posx + gs, posy - 2 * gs, 1, (int)((double)gs * 0.3));
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else if (this.simx1 != 0.0) {
            g.setColor(this.auxcolor);
            if (cycle) {
                GraphicsUtil.drawArrow(g, (int)(((double)x + this.simx1) * (double)gs), (int)(((double)y + this.simy1) * (double)gs), (int)(((double)x + (this.simx2 + this.simx1) / 2.0) * (double)gs), (int)(((double)y + (this.simy2 + this.simy1) / 2.0) * (double)gs), 1, (int)((double)gs * 1.5));
            } else {
                GraphicsUtil.drawArrow(g, (int)(((double)x + (this.simx2 + this.simx1) / 2.0) * (double)gs), (int)(((double)y + (this.simy2 + this.simy1) / 2.0) * (double)gs), (int)(((double)x + this.simx2) * (double)gs), (int)(((double)y + this.simy2) * (double)gs), 1, (int)((double)gs * 1.5));
            }
        }
    }

    @Override
    public void SimulateLogic() {
    }

    @Override
    public boolean CheckIfComponentInDrawArea(int x1, int y1, int x2, int y2) {
        boolean aux = true;
        int cx1 = this.Pos.x + this.HitBox.x - 3;
        int cy1 = this.Pos.y + this.HitBox.y - 3;
        int cx2 = this.Pos.x + this.HitBox.x + this.HitBoxSize.width + 3;
        int cy2 = this.Pos.y + this.HitBox.y + this.HitBoxSize.height + 3;
        aux = x1 <= cx1 && y1 <= cy1 && cx1 <= x2 && cy1 <= y2 || x1 <= cx2 && y1 <= cy2 && cx2 <= x2 && cy2 <= y2;
        return aux;
    }

    @Override
    public void Save(PrintStream myPrintStream) {
        myPrintStream.println("describe component " + this.ClassName);
        myPrintStream.println(" pos " + this.Pos.x + " " + this.Pos.y);
        myPrintStream.println(" Name " + this.ComponentName);
        myPrintStream.println(" type " + this.inv_type);
        myPrintStream.println(" alias " + this.alias);
        myPrintStream.println(" owner " + this.inv_owner);
        myPrintStream.println(" ctrla " + this.ctrla);
        myPrintStream.println(" cost " + this.inv_cost);
        myPrintStream.println(" coym " + this.coym);
        myPrintStream.println(" un1 " + this.un[0]);
        myPrintStream.println(" un2 " + this.un[1]);
        myPrintStream.println(" mintapr " + this.mintapr);
        myPrintStream.println(" smax " + this.smax);
        myPrintStream.println(" sn " + this.sn);
        myPrintStream.println(" lifetime " + this.life_time);
        myPrintStream.println(" entryperiod " + this.entry_period);
        myPrintStream.println(" exitperiod " + this.exit_period);
        myPrintStream.println(" entrymonth " + this.entry_month);
        myPrintStream.println(" exitmonth " + this.exit_month);
        myPrintStream.println(" mintapi " + this.mintapi);
        myPrintStream.println(" vinv " + this.vinv);
        myPrintStream.println(" nbridge " + this.nbridge);
        myPrintStream.println(" potdrec " + this.potdrec);
        myPrintStream.println(" lresis " + this.lresis);
        myPrintStream.println(" maxtapr " + this.maxtapr);
        myPrintStream.println(" maxtapi " + this.maxtapi);
        myPrintStream.println(" minfir " + this.minfir);
        myPrintStream.println(" minext " + this.minext);
        myPrintStream.println(" maxfir " + this.maxfir);
        myPrintStream.println(" maxext " + this.maxext);
        myPrintStream.println(" resrec " + this.resrec);
        myPrintStream.println(" resinv " + this.resinv);
        myPrintStream.println(" reacrec " + this.reacrec);
        myPrintStream.println(" reacinv " + this.reacinv);
        myPrintStream.println(" qrect " + this.qrect);
        myPrintStream.println(" qinver " + this.qinver);
        myPrintStream.println(" len " + this.len);
        myPrintStream.println(" sv " + this.sv);
        myPrintStream.println(" incomep " + this.m_incomep);
        myPrintStream.println(" incomeq " + this.m_incomeq);
        myPrintStream.println(" verhor " + this.verhor);
        myPrintStream.println(" swapPS " + this.swapPS);
        myPrintStream.println(" planning " + this.planning);
        myPrintStream.println(" project " + this.project);
        myPrintStream.println(" alternative " + this.alternative);
        myPrintStream.println(" suggest " + this.suggest);
        myPrintStream.println(" inservice  " + this.inservice);
        myPrintStream.println("end describe");
    }

    @Override
    public void SaveDatabase() throws SQLException {
        int x = 0;
        Statement stmt = DeepEditFrame.con.createStatement();
        String query = "INSERT INTO LineDC (XPos, YPos, Name, type, alias, owner, ctrla, cost, coym, un1, un2, potdrec, lresis, smax, sn, lifetime, entryperiod, exitperiod, entrymonth, exitmonth, incomep, incomeq, mintapr, mintapi, maxtapr, maxtapi, sv, len, verhor, swapPS, planning,minext,minfir,maxext,maxfir,resrec,resinv,reacrec,reacinv,vinv,nbridge,qrect,qinver, project, alternative, suggest,con1,con2, sc, inservice) VALUES (" + String.valueOf(this.Pos.x) + "," + String.valueOf(this.Pos.y) + ",'" + this.ComponentName + "','" + this.inv_type + "','" + this.alias + "','" + this.inv_owner + "','" + this.ctrla + "'," + String.valueOf(this.inv_cost) + "," + String.valueOf(this.coym) + "," + String.valueOf(this.un[0]) + "," + String.valueOf(this.un[1]) + "," + String.valueOf(this.potdrec) + "," + String.valueOf(this.lresis) + "," + String.valueOf(this.smax) + "," + String.valueOf(this.sn) + "," + String.valueOf(this.life_time) + "," + String.valueOf(this.entry_period) + "," + String.valueOf(this.exit_period) + "," + String.valueOf(this.entry_month) + "," + String.valueOf(this.exit_month) + "," + String.valueOf(this.m_incomep) + "," + String.valueOf(this.m_incomeq) + "," + String.valueOf(this.mintapr) + "," + String.valueOf(this.mintapi) + "," + String.valueOf(this.maxtapr) + "," + String.valueOf(this.maxtapi) + "," + String.valueOf(this.sv) + "," + String.valueOf(this.len) + "," + (this.verhor ? 1 : 0) + "," + (this.swapPS ? 1 : 0) + "," + String.valueOf(this.planning) + "," + String.valueOf(this.minext) + "," + String.valueOf(this.minfir) + "," + String.valueOf(this.maxext) + "," + String.valueOf(this.maxfir) + "," + String.valueOf(this.resrec) + "," + String.valueOf(this.resinv) + "," + String.valueOf(this.reacrec) + "," + String.valueOf(this.reacinv) + "," + String.valueOf(this.vinv) + "," + String.valueOf(this.nbridge) + "," + String.valueOf(this.qrect) + "," + String.valueOf(this.qinver) + ",'" + this.project + "','" + this.alternative + "'," + (this.suggest ? 1 : 0) + ",'" + this.con1 + "','" + this.con2 + "'," + String.valueOf(this.sc) + "," + (this.inservice ? 1 : 0) + ")";
        x = stmt.executeUpdate(query);
        stmt.close();
    }

    @Override
    public void InformAllComponents() {
        comp ConnectedComponent;
        int ix;
        int nc = 0;
        int inp = -1;
        int out = -1;
        this.setcon1(" ");
        this.setcon2(" ");
        Busbar MyBusbar = null;
        for (int o = 0; o < this.Outputs; ++o) {
            for (ix = 0; ix < this.OPin[o].ConnComps.size(); ++ix) {
                ConnectedComponent = (comp)this.OPin[o].ConnComps.elementAt(ix);
                if (ConnectedComponent instanceof Busbar) {
                    MyBusbar = (Busbar)ConnectedComponent;
                }
                if (ConnectedComponent == this || !(ConnectedComponent instanceof Busbar)) continue;
                if (++nc > 1 && DeepEdit.PrintConnecWarnings) {
                    System.out.println(" !!!Error: mas de una componente al final de un LineDC!!!");
                }
                if ((inp = ConnectedComponent.InformInput(this)) != -1) {
                    if (this.swapPS) {
                        this.setcon1(ConnectedComponent.ComponentName);
                        this.ctrla1 = MyBusbar.getctrla();
                    } else {
                        this.setcon2(ConnectedComponent.ComponentName);
                        this.ctrla2 = MyBusbar.getctrla();
                    }
                }
                if ((out = ConnectedComponent.InformOutput(this)) == -1) continue;
                if (this.swapPS) {
                    this.setcon1(ConnectedComponent.ComponentName);
                    this.ctrla1 = MyBusbar.getctrla();
                    continue;
                }
                this.setcon2(ConnectedComponent.ComponentName);
                this.ctrla2 = MyBusbar.getctrla();
            }
        }
        nc = 0;
        for (int i = 0; i < this.Inputs; ++i) {
            for (ix = 0; ix < this.IPin[i].ConnComps.size(); ++ix) {
                ConnectedComponent = (comp)this.IPin[i].ConnComps.elementAt(ix);
                if (ConnectedComponent == this || !(ConnectedComponent instanceof Busbar)) continue;
                if (++nc > 1 && DeepEdit.PrintConnecWarnings) {
                    System.out.println(" !!!Error: mas de una componente al final de una linea Inputs= " + this.Inputs);
                }
                if ((inp = ConnectedComponent.InformInput(this)) != -1) {
                    if (this.swapPS) {
                        this.setcon2(ConnectedComponent.ComponentName);
                        this.ctrla2 = MyBusbar.getctrla();
                    } else {
                        this.setcon1(ConnectedComponent.ComponentName);
                        this.ctrla1 = MyBusbar.getctrla();
                    }
                }
                if ((out = ConnectedComponent.InformOutput(this)) == -1) continue;
                if (this.swapPS) {
                    this.setcon2(ConnectedComponent.ComponentName);
                    this.ctrla2 = MyBusbar.getctrla();
                    continue;
                }
                this.setcon1(ConnectedComponent.ComponentName);
                this.ctrla1 = MyBusbar.getctrla();
            }
        }
    }

    public void setm_incomep() {
        comp ConnectedComponent;
        int ix;
        Busbar MyBusbar = null;
        double costo_1 = 0.0;
        double costo_2 = 0.0;
        for (int o = 0; o < this.Outputs; ++o) {
            for (ix = 0; ix < this.OPin[o].ConnComps.size(); ++ix) {
                ConnectedComponent = (comp)this.OPin[o].ConnComps.elementAt(ix);
                if (!(ConnectedComponent instanceof Busbar)) continue;
                MyBusbar = (Busbar)ConnectedComponent;
                if (MyBusbar.getName().equals(this.getcon1())) {
                    costo_1 = MyBusbar.getspot_p();
                }
                if (!MyBusbar.getName().equals(this.getcon2())) continue;
                costo_2 = MyBusbar.getspot_p();
            }
        }
        for (int i = 0; i < this.Inputs; ++i) {
            for (ix = 0; ix < this.IPin[i].ConnComps.size(); ++ix) {
                ConnectedComponent = (comp)this.IPin[i].ConnComps.elementAt(ix);
                if (!(ConnectedComponent instanceof Busbar)) continue;
                MyBusbar = (Busbar)ConnectedComponent;
                if (MyBusbar.getName().equals(this.getcon2())) {
                    costo_2 = MyBusbar.getspot_p();
                }
                if (!MyBusbar.getName().equals(this.getcon1())) continue;
                costo_1 = MyBusbar.getspot_p();
            }
        }
        this.setm_incomep(-(this.getp21() * costo_2) - this.getp12() * costo_1);
    }

    @Override
    public boolean getParameterInfo(String sParameterName, ParameterData oData) {
        String sValue = null;
        DE_GeneralEnums.databaseDataType eDataType = null;
        DE_GeneralEnums.parameterGroup eGroup = null;
        oData.seteGroup(DE_GeneralEnums.parameterGroup.Operation);
        if (sParameterName.equalsIgnoreCase("Name")) {
            sValue = this.getName();
            eDataType = DE_GeneralEnums.databaseDataType.StringValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("alias")) {
            sValue = this.getalias();
            eDataType = DE_GeneralEnums.databaseDataType.StringValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("con1")) {
            sValue = this.getcon1();
            eDataType = DE_GeneralEnums.databaseDataType.StringValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("con2")) {
            sValue = this.getcon2();
            eDataType = DE_GeneralEnums.databaseDataType.StringValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("un1")) {
            sValue = String.valueOf(this.getun1());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("un2")) {
            sValue = String.valueOf(this.getun2());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("sn")) {
            sValue = String.valueOf(this.getsn());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("smax")) {
            sValue = String.valueOf(this.getsmax());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("len")) {
            sValue = String.valueOf(this.getlen());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("sc")) {
            sValue = String.valueOf(this.getsc());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("inservicei")) {
            sValue = String.valueOf(this.getinservicei());
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("inservice")) {
            sValue = String.valueOf(this.getinservice());
            eDataType = DE_GeneralEnums.databaseDataType.BooleanValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("lresis")) {
            sValue = String.valueOf(this.getlresis());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("maxext")) {
            sValue = String.valueOf(this.getmaxext());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("maxfir")) {
            sValue = String.valueOf(this.getmaxfir());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("minext")) {
            sValue = String.valueOf(this.getminext());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("minfir")) {
            sValue = String.valueOf(this.getminfir());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("maxtapi")) {
            sValue = String.valueOf(this.getmaxtapi());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("maxtapr")) {
            sValue = String.valueOf(this.getmaxtapr());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("mintapi")) {
            sValue = String.valueOf(this.getmintapi());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("mintapr")) {
            sValue = String.valueOf(this.getmintapr());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("nbridge")) {
            sValue = String.valueOf(this.getnbridge());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("potdrec")) {
            sValue = String.valueOf(this.getpotdrec());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("qinver")) {
            sValue = String.valueOf(this.getqinver());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("qrect")) {
            sValue = String.valueOf(this.getqrect());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("reacinv")) {
            sValue = String.valueOf(this.getreacinv());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("reacrec")) {
            sValue = String.valueOf(this.getreacrec());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("resinv")) {
            sValue = String.valueOf(this.getresinv());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("resrec")) {
            sValue = String.valueOf(this.getresrec());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("sv")) {
            sValue = String.valueOf(this.getsv());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("vinv")) {
            sValue = String.valueOf(this.getvinv());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("type")) {
            sValue = this.getinv_type();
            eDataType = DE_GeneralEnums.databaseDataType.StringValue;
            eGroup = DE_GeneralEnums.parameterGroup.Economic;
        } else if (sParameterName.equalsIgnoreCase("owner")) {
            sValue = this.getinv_owner();
            eDataType = DE_GeneralEnums.databaseDataType.StringValue;
            eGroup = DE_GeneralEnums.parameterGroup.Economic;
        } else if (sParameterName.equalsIgnoreCase("lifetime")) {
            sValue = String.valueOf(this.getlife_time());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Economic;
        } else if (sParameterName.equalsIgnoreCase("entryperiod")) {
            sValue = String.valueOf(this.getentry_period());
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Economic;
        } else if (sParameterName.equalsIgnoreCase("exitperiod")) {
            sValue = String.valueOf(this.getexit_period());
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Economic;
        } else if (sParameterName.equalsIgnoreCase("cost")) {
            sValue = String.valueOf(this.getinv_cost());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Economic;
        } else if (sParameterName.equalsIgnoreCase("entrymonth")) {
            sValue = String.valueOf(this.getentry_month());
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Economic;
        } else if (sParameterName.equalsIgnoreCase("exitmonth")) {
            sValue = String.valueOf(this.getexit_month());
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Economic;
        } else if (sParameterName.equalsIgnoreCase("coym")) {
            sValue = String.valueOf(this.getcoym());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Economic;
        } else if (sParameterName.equalsIgnoreCase("alternative")) {
            sValue = this.getalternative();
            eDataType = DE_GeneralEnums.databaseDataType.StringValue;
            eGroup = DE_GeneralEnums.parameterGroup.Economic;
        } else if (sParameterName.equalsIgnoreCase("planning")) {
            sValue = String.valueOf(this.getplanning());
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Economic;
        } else if (sParameterName.equalsIgnoreCase("project")) {
            sValue = this.getproject();
            eDataType = DE_GeneralEnums.databaseDataType.StringValue;
            eGroup = DE_GeneralEnums.parameterGroup.Economic;
        } else if (sParameterName.equalsIgnoreCase("incomep")) {
            sValue = String.valueOf(this.getm_incomep());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Economic;
        } else if (sParameterName.equalsIgnoreCase("incomeq")) {
            sValue = String.valueOf(this.getm_incomeq());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Economic;
        } else if (sParameterName.equalsIgnoreCase("suggest")) {
            sValue = String.valueOf(this.getsuggest());
            eDataType = DE_GeneralEnums.databaseDataType.BooleanValue;
            eGroup = DE_GeneralEnums.parameterGroup.Economic;
        } else if (sParameterName.equalsIgnoreCase("ctrla")) {
            sValue = this.getctrla();
            eDataType = DE_GeneralEnums.databaseDataType.StringValue;
            eGroup = DE_GeneralEnums.parameterGroup.Location;
        } else if (sParameterName.equalsIgnoreCase("Xpos")) {
            sValue = String.valueOf(this.getxpos());
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Location;
        } else if (sParameterName.equalsIgnoreCase("Ypos")) {
            sValue = String.valueOf(this.getypos());
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Location;
        } else if (sParameterName.equalsIgnoreCase("swapPS")) {
            sValue = String.valueOf(this.getswapPS());
            eDataType = DE_GeneralEnums.databaseDataType.BooleanValue;
            eGroup = DE_GeneralEnums.parameterGroup.Location;
        } else if (sParameterName.equalsIgnoreCase("verhor")) {
            sValue = String.valueOf(this.getverhor());
            eDataType = DE_GeneralEnums.databaseDataType.BooleanValue;
            eGroup = DE_GeneralEnums.parameterGroup.Location;
        }
        if (sValue != null) {
            oData.setValue(sValue, eDataType, eGroup);
        } else {
            ParameterData oDataOld = (ParameterData)this.mData.get(sParameterName);
            if (oDataOld == null && (oDataOld = DeepEdit.getDefaultParameterInfo(this.ClassName, sParameterName)) == null) {
                assert (false) : "Why are you looking for parameter '" + sParameterName + "' if it is not supported by object '" + this.ClassName + "?";
                return false;
            }
            oDataOld.copyParameterInto(oData);
        }
        return true;
    }

    @Override
    public boolean setParameterInfo(String sParameterName, ParameterData pData) {
        String sValue = pData.getValue();
        if (sParameterName.equalsIgnoreCase("Name")) {
            this.setName(sValue);
            return true;
        }
        if (sParameterName.equalsIgnoreCase("alias")) {
            this.setalias(sValue);
            return true;
        }
        if (sParameterName.equalsIgnoreCase("con1")) {
            this.setcon1(sValue);
            return true;
        }
        if (sParameterName.equalsIgnoreCase("con2")) {
            this.setcon2(sValue);
            return true;
        }
        if (sParameterName.equalsIgnoreCase("un1")) {
            this.setun1(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("un2")) {
            this.setun2(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("sn")) {
            this.setsn(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("smax")) {
            this.setsmax(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("inservicei")) {
            this.setinservicei(Integer.parseInt(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("inservice")) {
            this.setinservice(Boolean.parseBoolean(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("sc")) {
            this.setsc(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("len")) {
            this.setlen(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("lresis")) {
            this.setlresis(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("maxext")) {
            this.setmaxext(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("maxfir")) {
            this.setmaxfir(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("minext")) {
            this.setminext(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("minfir")) {
            this.setminfir(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("maxtapi")) {
            this.setmaxtapi(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("maxtapr")) {
            this.setmaxtapr(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("mintapi")) {
            this.setmintapi(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("mintapr")) {
            this.setmintapr(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("nbridge")) {
            this.setnbridge((int)Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("potdrec")) {
            this.setpotdrec(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("qinver")) {
            this.setqinver(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("qrect")) {
            this.setqrect(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("reacinv")) {
            this.setreacinv(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("reacrec")) {
            this.setreacrec(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("resinv")) {
            this.setresinv(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("resrec")) {
            this.setresrec(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("sv")) {
            this.setsv(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("vinv")) {
            this.setvinv(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("type")) {
            this.setinv_type(sValue);
            return true;
        }
        if (sParameterName.equalsIgnoreCase("owner")) {
            this.setinv_owner(sValue);
            return true;
        }
        if (sParameterName.equalsIgnoreCase("lifetime")) {
            this.setlife_time((int)Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("entryperiod")) {
            this.setentry_period((int)Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("exitperiod")) {
            this.setexit_period((int)Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("cost")) {
            this.setinv_cost((int)Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("entrymonth")) {
            this.setentry_month((int)Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("exitmonth")) {
            this.setexit_month((int)Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("coym")) {
            this.setcoym(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("alternative")) {
            this.setalternative(sValue);
            return true;
        }
        if (sParameterName.equalsIgnoreCase("planning")) {
            this.setplanning((int)Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("project")) {
            this.setproject(sValue);
            return true;
        }
        if (sParameterName.equalsIgnoreCase("incomep")) {
            this.setm_incomep(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("incomeq")) {
            this.setm_incomeq(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("suggest")) {
            this.setsuggest(Boolean.parseBoolean(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("ctrla")) {
            this.setctrla(sValue);
            return true;
        }
        if (sParameterName.equalsIgnoreCase("Xpos")) {
            this.setxpos((int)Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("Ypos")) {
            this.setypos((int)Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("swapPS")) {
            this.setswapPS(Boolean.parseBoolean(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("verhor")) {
            this.setverhor(Boolean.parseBoolean(sValue));
            return true;
        }
        ParameterData pDataOld = (ParameterData)this.mData.get(sParameterName);
        if (pDataOld != null) {
            pDataOld.setValue(sValue);
        } else {
            this.mData.put(sParameterName, pData);
        }
        return true;
    }
}

