/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import de.core.Busbar;
import de.core.DeepEdit;
import de.core.DeepEditFrame;
import de.core.GraphicsUtil;
import de.core.InputPin;
import de.core.JMapObject;
import de.core.Pin;
import de.core.Schematic;
import de.core.comp;
import de.core.ndb_branch;
import de.core.ndb_comp;
import de.data.DE_GeneralEnums;
import de.data.ParameterData;
import de.utils.StringUtil;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.io.PrintStream;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Vector;

public class Line
extends ndb_branch {
    protected double r1 = 0.0;
    protected double xx1 = 0.0;
    protected double g1 = 0.0;
    protected double b1 = 0.0;
    protected double r0 = 0.0;
    protected double x0 = 0.0;
    protected double g0 = 0.0;
    protected double b0 = 0.0;
    protected double len = 1.0;
    protected JMapObject mo;
    protected int x1;
    protected int y1;
    protected int x2;
    protected int y2;
    public int ChangingWire = 0;
    public int ChangingWirePoly = 0;
    public int[] xpoly = new int[32];
    public int[] ypoly = new int[32];
    protected int npoly;
    public double[] xpolysim = new double[500];
    public double[] ypolysim = new double[500];
    protected int npolysim;
    protected int pospolysim;
    protected boolean above = true;
    public Vector ConnComps1;
    public Vector ConnComps2;
    private int nCircuits;

    public Line(Pin[][] PinGrid, int x, int y, int entryperiod, int exitperiod, int entrymonth, int exitmonth) {
        super(1, x, y, 0, entryperiod, exitperiod, entrymonth, exitmonth);
        this.setName("Line");
        this.ClassName = "Line";
        this.npolysim = 0;
        this.x1 = x;
        this.y1 = y;
        this.project = "NONE";
        this.alternative = "NONE";
        this.suggest = false;
        this.entry_period = entryperiod;
        this.exit_period = exitperiod;
        this.un[0] = 220.0;
        this.un[1] = 220.0;
        this.IPin[0] = new InputPin("A", 3, 1, 0, 3, 0, 0, 2);
        this.inv_type = "A";
        this.q21 = 0.0;
        this.p21 = 0.0;
        this.q12 = 0.0;
        this.p12 = 0.0;
        this.sc = 1.0;
        this.nCircuits = 1;
    }

    public Line(Pin[][] PinGrid, int Xpos1, int Ypos1, int Xpos2, int Ypos2, int entryperiod, int exitperiod, int entrymonth, int exitmonth) {
        this(PinGrid, Xpos1, Ypos1, entryperiod, exitperiod, entrymonth, exitmonth);
        this.x1 = Xpos1;
        this.x2 = Xpos2;
        this.y1 = Ypos1;
        this.y2 = Ypos2;
        this.PlacePinsHere(PinGrid);
    }

    public Line(Pin[][] PinGrid, int rx1, int ry1, int rx2, int ry2, String Name, String type, String alias, String owner, String ctrla, double cost, double coym, double un1, double un2, double ssmax, int lifetime, int entryperiod, int exitperiod, int entrymonth, int exitmonth, double incomep, double incomeq, double rr1, double xxx1, double gg1, double bb1, double llen, int[] xxpoly, int[] yypoly, int nnpoly, double ssn, int pplanning, String pproject, String aalternative, boolean ssuggest, double ssc, boolean iinservice) {
        super(Name, type, alias, owner, ctrla, cost, coym, ssmax, lifetime, entryperiod, exitperiod, entrymonth, exitmonth, incomep, incomeq, pplanning, ssc);
        this.project = pproject;
        this.alternative = aalternative;
        this.suggest = ssuggest;
        this.ClassName = "Line";
        this.inservice = iinservice;
        this.npolysim = 0;
        this.x1 = rx1;
        this.y1 = ry1;
        this.x2 = rx2;
        this.y2 = ry2;
        this.sn = ssn;
        this.r1 = rr1;
        this.xx1 = xxx1;
        this.g1 = gg1;
        this.b1 = bb1;
        this.len = llen;
        this.un[0] = un1;
        this.un[1] = un2;
        for (int i = 0; i < nnpoly; ++i) {
            this.xpoly[i] = xxpoly[i];
            this.ypoly[i] = yypoly[i];
        }
        this.npoly = nnpoly;
        this.q21 = 0.0;
        this.p21 = 0.0;
        this.q12 = 0.0;
        this.p12 = 0.0;
        this.nCircuits = 1;
        this.PlacePinsHere(PinGrid);
    }

    public Line(comp CompToCopy, int xo, int yo) {
        super(CompToCopy, xo, yo);
        this.project = "NONE";
        this.alternative = "NONE";
        this.suggest = false;
    }

    public double getr1() {
        return this.r1;
    }

    public double getxx1() {
        return this.xx1;
    }

    public double getg1() {
        return this.g1;
    }

    public double getb1() {
        return this.b1;
    }

    public double getr0() {
        return this.r0;
    }

    public double getx0() {
        return this.x0;
    }

    public double getg0() {
        return this.g0;
    }

    public double getb0() {
        return this.b0;
    }

    public double getlen() {
        return this.len;
    }

    public int getx1() {
        return this.x1;
    }

    public int getx2() {
        return this.x2;
    }

    public int gety1() {
        return this.y1;
    }

    public int gety2() {
        return this.y2;
    }

    public int getnpoly() {
        return this.npoly;
    }

    public int getCircuits() {
        return this.nCircuits;
    }

    public JMapObject getmo() {
        return this.mo;
    }

    @Override
    public double getSeriesResistance(double Sref) {
        return this.getr1() * this.getlen() * Sref / (this.getun1() * this.getun1());
    }

    @Override
    public double getSeriesReactance(double Sref) {
        return this.getxx1() * this.getlen() * Sref / (this.getun1() * this.getun1());
    }

    public void setr1(double n) {
        this.r1 = n;
    }

    public void setxx1(double n) {
        this.xx1 = n;
    }

    public void setg1(double n) {
        this.g1 = n;
    }

    public void setb1(double n) {
        this.b1 = n;
    }

    public void setr0(double n) {
        this.r0 = n;
    }

    public void setx0(double n) {
        this.x0 = n;
    }

    public void setg0(double n) {
        this.g0 = n;
    }

    public void setb0(double n) {
        this.b0 = n;
    }

    public void setlen(double n) {
        this.len = n;
    }

    public void setx1(int n) {
        this.x1 = n;
    }

    public void setx2(int n) {
        this.x2 = n;
    }

    public void sety1(int n) {
        this.y1 = n;
    }

    public void sety2(int n) {
        this.y2 = n;
    }

    public void setnpoly(int n) {
        this.npoly = n;
    }

    public void setCircuits(int n) {
        this.nCircuits = n;
    }

    public void setmo(JMapObject n) {
        this.mo = n;
    }

    @Override
    public comp Copy(int xo, int yo) {
        Line NewComponent = new Line(this, xo, yo);
        NewComponent.x1 = this.x1 - xo;
        NewComponent.y1 = this.y1 - yo;
        NewComponent.x2 = this.x2 - xo;
        NewComponent.y2 = this.y2 - yo;
        NewComponent.setplanning(this.getplanning());
        NewComponent.setName(this.getName());
        NewComponent.setun1(this.getun1());
        NewComponent.setsmax(this.getsmax());
        NewComponent.setsc(this.getsc());
        NewComponent.setsn(this.getsn());
        NewComponent.setr1(this.getr1());
        NewComponent.setxx1(this.getxx1());
        NewComponent.setb1(this.getb1());
        NewComponent.setg1(this.getg1());
        NewComponent.setlen(this.getlen());
        NewComponent.setlife_time(this.getlife_time());
        NewComponent.setentry_period(this.getentry_period());
        NewComponent.setexit_period(this.getexit_period());
        NewComponent.setinv_cost(this.getinv_cost());
        NewComponent.setcoym(this.getcoym());
        NewComponent.setinv_type(this.getinv_type());
        NewComponent.setinv_owner(this.getinv_owner());
        for (int i = 0; i < this.getnpoly(); ++i) {
            NewComponent.xpoly[i] = this.xpoly[i] - xo;
            NewComponent.ypoly[i] = this.ypoly[i] - yo;
        }
        NewComponent.setnpoly(this.getnpoly());
        return NewComponent;
    }

    @Override
    public void CheckPosition(DeepEdit app) {
        int MaxXPoints = DeepEdit.getMaxXPoints();
        int MaxYPoints = DeepEdit.getMaxYPoints();
        if (this.x1 < 1) {
            this.x1 = 1;
        }
        if (this.x1 >= MaxXPoints) {
            this.x1 = MaxXPoints - 1;
        }
        if (this.y1 < 1) {
            this.y1 = 1;
        }
        if (this.y1 >= MaxYPoints) {
            this.y1 = MaxYPoints - 1;
        }
        if (this.x2 < 1) {
            this.x2 = 1;
        }
        if (this.x2 >= MaxXPoints) {
            this.x2 = MaxXPoints - 1;
        }
        if (this.y2 < 1) {
            this.y2 = 1;
        }
        if (this.y2 >= MaxYPoints) {
            this.y2 = MaxYPoints - 1;
        }
        for (int i = 0; i < this.npoly; ++i) {
            if (this.xpoly[i] < 1) {
                this.xpoly[i] = 1;
            }
            if (this.xpoly[i] >= MaxXPoints) {
                this.xpoly[i] = MaxXPoints - 1;
            }
            if (this.ypoly[i] < 1) {
                this.ypoly[i] = 1;
            }
            if (this.ypoly[i] < MaxYPoints) continue;
            this.ypoly[i] = MaxYPoints - 1;
        }
    }

    public void InformAllComponents(Vector ActVector, int x, int y, PrintStream myPrintStream, int endline, String sysname) {
        Busbar MyBusbar = null;
        int nc = 0;
        int inp = -1;
        int out = -1;
        for (int ix = 0; ix < ActVector.size(); ++ix) {
            comp ConnectedComponent = (comp)ActVector.elementAt(ix);
            if (ConnectedComponent instanceof Busbar) {
                MyBusbar = (Busbar)ConnectedComponent;
            }
            if (ConnectedComponent == this || !(ConnectedComponent instanceof Busbar)) continue;
            if (++nc > 1) {
                System.out.println(" !!!Error: mas de una componente al final de una linea!!! " + this.getName() + " " + ConnectedComponent.getName());
            }
            if (endline == 1) {
                this.nocona = false;
            }
            if (endline == 2) {
                this.nocone = false;
            }
            if ((inp = ConnectedComponent.InformInput(this)) != -1) {
                myPrintStream.println(" pot_top" + endline + "     " + "\"" + sysname + "." + ConnectedComponent.ComponentName + ".FeldIn" + inp + ".AT:2\"");
                if (endline == 1) {
                    this.setcon1(ConnectedComponent.ComponentName);
                    this.ctrla1 = MyBusbar.getctrla();
                }
                if (endline == 2) {
                    this.setcon2(ConnectedComponent.ComponentName);
                    this.ctrla2 = MyBusbar.getctrla();
                }
            }
            if ((out = ConnectedComponent.InformOutput(this)) == -1) continue;
            myPrintStream.println(" pot_top" + endline + "     " + "\"" + sysname + "." + ConnectedComponent.ComponentName + ".FeldOut" + out + ".AT:2\"");
            if (endline == 1) {
                this.setcon1(ConnectedComponent.ComponentName);
                this.ctrla1 = MyBusbar.getctrla();
            }
            if (endline != 2) continue;
            this.setcon2(ConnectedComponent.ComponentName);
            this.ctrla2 = MyBusbar.getctrla();
        }
    }

    @Override
    public void InformAllComponents() {
        Busbar TempBusbar;
        comp tempComp;
        int ii;
        this.setcon1(" ");
        this.setcon2(" ");
        int NconBars = 0;
        Pin mypin = DeepEdit.PinGrid[this.x1][this.y1];
        if (mypin != null && mypin.ComponentsSize() > 0) {
            for (ii = 0; ii < mypin.ComponentsSize(); ++ii) {
                tempComp = mypin.GetComponent(ii);
                if (!(tempComp instanceof Busbar)) continue;
                TempBusbar = (Busbar)tempComp;
                ++NconBars;
                this.setcon1(TempBusbar.getName());
                this.ctrla1 = TempBusbar.getctrla();
            }
            if (NconBars == 0 && DeepEdit.PrintConnecWarnings) {
                System.out.println("WARNING: Sender end of ndb_branch Component '" + this.getName() + "' is not connected to any busbar");
            }
        }
        NconBars = 0;
        mypin = DeepEdit.PinGrid[this.x2][this.y2];
        if (mypin != null && mypin.ComponentsSize() > 0) {
            for (ii = 0; ii < mypin.ComponentsSize(); ++ii) {
                tempComp = mypin.GetComponent(ii);
                if (!(tempComp instanceof Busbar)) continue;
                TempBusbar = (Busbar)tempComp;
                ++NconBars;
                this.setcon2(TempBusbar.getName());
                this.ctrla2 = TempBusbar.getctrla();
            }
            if (NconBars == 0 && DeepEdit.PrintConnecWarnings) {
                System.out.println("WARNING: Receiver end of ndb_branch Component '" + this.getName() + "' is not connected to any busbar");
            }
        }
    }

    public String InformAllComponents(Vector ActVector, int x, int y, int endline) {
        Busbar MyBusbar = null;
        int nc = 0;
        int inp = -1;
        int out = -1;
        for (int ix = 0; ix < ActVector.size(); ++ix) {
            comp ConnectedComponent = (comp)ActVector.elementAt(ix);
            if (ConnectedComponent instanceof Busbar) {
                MyBusbar = (Busbar)ConnectedComponent;
            }
            if (ConnectedComponent == this || !(ConnectedComponent instanceof Busbar)) continue;
            if (++nc > 1) {
                System.out.println(" !!!Error: mas de una componente al final de una linea!!! " + this.getName() + " " + ConnectedComponent.getName());
            }
            if (endline == 1) {
                this.nocona = false;
            }
            if (endline == 2) {
                this.nocone = false;
            }
            if ((inp = ConnectedComponent.InformInput(this)) != -1) {
                if (endline == 1) {
                    this.setcon1(ConnectedComponent.ComponentName);
                    this.ctrla1 = MyBusbar.getctrla();
                }
                if (endline == 2) {
                    this.setcon2(ConnectedComponent.ComponentName);
                    this.ctrla2 = MyBusbar.getctrla();
                }
                return ConnectedComponent.ComponentName;
            }
            out = ConnectedComponent.InformOutput(this);
            if (out == -1) continue;
            if (endline == 1) {
                this.setcon1(ConnectedComponent.ComponentName);
                this.ctrla1 = MyBusbar.getctrla();
            }
            if (endline == 2) {
                this.setcon2(ConnectedComponent.ComponentName);
                this.ctrla2 = MyBusbar.getctrla();
            }
            return ConnectedComponent.ComponentName;
        }
        return "Not Conn.";
    }

    public void InformPartner(Vector ActVector, int x, int y, int endline) {
        Busbar MyBusbar = null;
        int nc = 0;
        int inp = -1;
        int out = -1;
        for (int ix = 0; ix < ActVector.size(); ++ix) {
            comp ConnectedComponent = (comp)ActVector.elementAt(ix);
            if (ConnectedComponent instanceof Busbar) {
                MyBusbar = (Busbar)ConnectedComponent;
            }
            if (ConnectedComponent == this || !(ConnectedComponent instanceof Busbar)) continue;
            if (++nc > 2 && DeepEdit.PrintConnecWarnings) {
                System.out.println(" !!!Error: mas de una componente al final de una linea!!! " + this.getName());
            }
            if (endline == 1) {
                this.nocona = false;
                inp = ConnectedComponent.InformInput(this);
                if (inp != -1) {
                    this.setcon1(ConnectedComponent.ComponentName);
                    this.ctrla1 = MyBusbar.getctrla();
                }
                if ((out = ConnectedComponent.InformOutput(this)) == -1) continue;
                this.setcon1(ConnectedComponent.ComponentName);
                this.ctrla1 = MyBusbar.getctrla();
                continue;
            }
            this.nocone = false;
            inp = ConnectedComponent.InformInput(this);
            if (inp != -1) {
                this.setcon2(ConnectedComponent.ComponentName);
                this.ctrla2 = MyBusbar.getctrla();
            }
            if ((out = ConnectedComponent.InformOutput(this)) == -1) continue;
            this.setcon2(ConnectedComponent.ComponentName);
            this.ctrla2 = MyBusbar.getctrla();
        }
    }

    public boolean InformRelativePosition(Vector ActVector, int x, int y, int endline) {
        boolean nc = false;
        int inp = -1;
        int out = -1;
        for (int ix = 0; ix < ActVector.size(); ++ix) {
            comp ConnectedComponent = (comp)ActVector.elementAt(ix);
            if (ConnectedComponent == this || !(ConnectedComponent instanceof Busbar)) continue;
            inp = ConnectedComponent.InformInput(this);
            if (inp != -1) {
                this.above = true;
            }
            if ((out = ConnectedComponent.InformOutput(this)) != -1) {
                this.above = false;
            }
            return true;
        }
        return false;
    }

    @Override
    public comp[] getConnectedComponentList() {
        ArrayList<comp> lComp = new ArrayList<comp>();
        comp TempComponent = this.getReceiverComponent();
        if (TempComponent != null) {
            lComp.add(TempComponent);
        }
        if ((TempComponent = this.getSenderComponent()) != null) {
            lComp.add(TempComponent);
        }
        comp[] myConnectedComponents = lComp.toArray(new comp[lComp.size()]);
        return myConnectedComponents;
    }

    @Override
    public void SimulateSetUp(int x, int y, Vector ActComps) {
        if (x == this.x1 && y == this.y1) {
            this.ConnComps1 = ActComps;
        }
        if (x == this.x2 && y == this.y2) {
            this.ConnComps2 = ActComps;
        }
    }

    @Override
    public void SimulateSetUpFlows(double sref) {
        double belastung2;
        int i = 0;
        double counterflow = Math.abs(this.p12) + Math.abs(this.p21);
        double diffflow = Math.abs(this.p12) - Math.abs(this.p21);
        this.npolysim = 0;
        double belastung1 = Math.sqrt(Math.abs(this.p21) * Math.abs(this.p21) + Math.abs(this.q21) * Math.abs(this.q21));
        double belastung = Math.max(belastung1, belastung2 = Math.sqrt(Math.abs(this.p12) * Math.abs(this.p12) + Math.abs(this.q12) * Math.abs(this.q12))) / (this.getsmax() * this.sc) * sref;
        this.auxcolor = belastung >= 1.0 ? Color.red : (belastung >= 0.9 ? Color.magenta : (belastung >= 0.5 ? Color.orange : Color.green));
        if (counterflow == 0.0) {
            return;
        }
        if (Math.abs(this.p12) > Math.abs(this.p21) || diffflow == 0.0 && this.p12 > this.p21) {
            if (this.npoly > 0) {
                ++this.npolysim;
                this.xpolysim[this.npolysim - 1] = this.x1;
                this.ypolysim[this.npolysim - 1] = this.y1;
                this.calcnumint(this.x1, this.y1, this.xpoly[0], this.ypoly[0]);
                for (i = 0; i < this.npoly - 1; ++i) {
                    this.calcnumint(this.xpoly[i], this.ypoly[i], this.xpoly[i + 1], this.ypoly[i + 1]);
                }
                this.calcnumint(this.xpoly[this.npoly - 1], this.ypoly[this.npoly - 1], this.x2, this.y2);
            } else {
                ++this.npolysim;
                this.xpolysim[this.npolysim - 1] = this.x1;
                this.ypolysim[this.npolysim - 1] = this.y1;
                this.calcnumint(this.x1, this.y1, this.x2, this.y2);
            }
        } else if (this.npoly > 0) {
            ++this.npolysim;
            this.xpolysim[this.npolysim - 1] = this.x2;
            this.ypolysim[this.npolysim - 1] = this.y2;
            this.calcnumint(this.x2, this.y2, this.xpoly[this.npoly - 1], this.ypoly[this.npoly - 1]);
            for (i = this.npoly - 1; i > 0; --i) {
                this.calcnumint(this.xpoly[i], this.ypoly[i], this.xpoly[i - 1], this.ypoly[i - 1]);
            }
            this.calcnumint(this.xpoly[0], this.ypoly[0], this.x1, this.y1);
        } else {
            ++this.npolysim;
            this.xpolysim[this.npolysim - 1] = this.x2;
            this.ypolysim[this.npolysim - 1] = this.y2;
            this.calcnumint(this.x2, this.y2, this.x1, this.y1);
        }
    }

    public void calcnumint(int px1, int py1, int px2, int py2) {
        int i = 0;
        double numint = Math.sqrt((double)(px1 - px2) * (double)(px1 - px2) + (double)(py1 - py2) * (double)(py1 - py2)) / 2.0;
        if (numint > 500.0) {
            numint = 500.0;
        }
        for (i = 0; i < (int)numint; ++i) {
            ++this.npolysim;
            this.xpolysim[this.npolysim - 1] = (double)px1 + (double)(px2 - px1) / numint * (double)(i + 1);
            this.ypolysim[this.npolysim - 1] = (double)py1 + (double)(py2 - py1) / numint * (double)(i + 1);
        }
    }

    @Override
    public boolean AdjustPosition(Pin[][] PinGrid, int x, int y) {
        int nx1 = this.x1;
        int ny1 = this.y1;
        int nx2 = this.x2;
        int ny2 = this.y2;
        if ((this.ChangingWire & 1) == 1) {
            nx1 += x;
            ny1 += y;
        }
        if ((this.ChangingWire & 2) == 2) {
            nx2 += x;
            ny2 += y;
        }
        for (int i = 0; i < this.npoly; ++i) {
            if (this.ChangingWirePoly != i + 1 && this.ChangingWire != 3) continue;
            int n = i;
            this.xpoly[n] = this.xpoly[n] + x;
            int n2 = i;
            this.ypoly[n2] = this.ypoly[n2] + y;
        }
        if (nx1 == nx2 && ny1 == ny2) {
            return false;
        }
        this.x1 = nx1;
        this.y1 = ny1;
        this.x2 = nx2;
        this.y2 = ny2;
        return true;
    }

    @Override
    public void RemovePinsGrid(Pin[][] PinGrid) {
        this.RemovePin(PinGrid[this.x1][this.y1]);
        this.RemovePin(PinGrid[this.x2][this.y2]);
    }

    @Override
    public void RegisterPins(Pin[][] PinGrid, int x, int y) {
        if (PinGrid == null) {
            return;
        }
        if (this.x1 > PinGrid.length) {
            this.x1 = PinGrid.length;
        }
        if (this.x2 > PinGrid.length) {
            this.x2 = PinGrid.length;
        }
        if (this.y1 > PinGrid[0].length) {
            this.y1 = PinGrid[0].length;
        }
        if (this.y2 > PinGrid[0].length) {
            this.y2 = PinGrid[0].length;
        }
        if (PinGrid[this.x1][this.y1] == null) {
            PinGrid[this.x1][this.y1] = new Pin();
        }
        if (PinGrid[this.x2][this.y2] == null) {
            PinGrid[this.x2][this.y2] = new Pin();
        }
        this.RegisterPin(PinGrid[this.x1][this.y1]);
        this.RegisterPin(PinGrid[this.x2][this.y2]);
    }

    @Override
    public void PlacePinsHere(Pin[][] PinGrid) {
        if (PinGrid == null) {
            return;
        }
        this.RegisterPins(PinGrid, 0, 0);
    }

    public void Set2ndCoord(Pin[][] PinGrid, int x, int y) {
        this.x2 = x;
        this.y2 = y;
    }

    public void draw(Graphics2D g, int xp, int yp, int gs, boolean Modifiedstate, boolean Simulate, boolean cycle, boolean ShowReactive, double sref, int actperiod, int actmonth, int typsim) {
        int auxint = 1;
        this.auxs = DeepEdit.ShowAlias ? this.alias : this.ComponentName;
        if (!Simulate) {
            int i;
            if (!this.inservice) {
                g.setColor(Color.black);
            } else {
                g.setColor(this.getkv_color1());
            }
            if (this.lw != 1) {
                auxint = Math.max(DeepEdit.getGridStep() * this.lw / 6, 2);
            }
            if (this.npoly > 0) {
                GraphicsUtil.drawLine(g, (this.x1 - xp) * gs, (this.y1 - yp) * gs, (this.xpoly[0] - xp) * gs, (this.ypoly[0] - yp) * gs, auxint);
                for (i = 0; i < this.npoly - 1; ++i) {
                    GraphicsUtil.drawLine(g, (this.xpoly[i] - xp) * gs, (this.ypoly[i] - yp) * gs, (this.xpoly[i + 1] - xp) * gs, (this.ypoly[i + 1] - yp) * gs, auxint);
                }
                GraphicsUtil.drawLine(g, (this.xpoly[this.npoly - 1] - xp) * gs, (this.ypoly[this.npoly - 1] - yp) * gs, (this.x2 - xp) * gs, (this.y2 - yp) * gs, auxint);
            } else {
                GraphicsUtil.drawLine(g, (this.x1 - xp) * gs, (this.y1 - yp) * gs, (this.x2 - xp) * gs, (this.y2 - yp) * gs, auxint);
            }
            if (this.getplanning() != 0) {
                if (!this.inservice) {
                    g.setColor(Color.black);
                } else {
                    g.setColor(Color1);
                }
                if (this.getplanning() == 2) {
                    g.setColor(Color2);
                }
                g.fillRect((int)(((double)(this.x1 - xp) - 0.3) * (double)gs), (int)(((double)(this.y1 - yp) - 0.3) * (double)gs), (int)((double)gs * 0.8), (int)((double)gs * 0.8));
                g.fillRect((int)(((double)(this.x2 - xp) - 0.3) * (double)gs), (int)(((double)(this.y2 - yp) - 0.3) * (double)gs), (int)((double)gs * 0.8), (int)((double)gs * 0.8));
            }
            if (this.isSelected()) {
                Stroke g_old = g.getStroke();
                if (!this.inservice) {
                    g.setColor(Color.white);
                } else if (this.IsReceiverConnected() && this.IsSenderConnected()) {
                    g.setStroke(new BasicStroke(3.0f));
                } else {
                    g.setColor(Color.BLACK);
                }
                if ((this.ChangingWire & 1) == 1) {
                    g.drawRect((int)(((double)(this.x1 - xp) - 0.25) * (double)gs), (int)(((double)(this.y1 - yp) - 0.25) * (double)gs), gs / 2, gs / 2);
                }
                if (this.ChangingWire == 3) {
                    for (i = 0; i < this.npoly; ++i) {
                        g.drawRect((int)(((double)(this.xpoly[i] - xp) - 0.25) * (double)gs), (int)(((double)(this.ypoly[i] - yp) - 0.25) * (double)gs), gs / 2, gs / 2);
                    }
                }
                if ((this.ChangingWire & 2) == 2) {
                    g.drawRect((int)(((double)(this.x2 - xp) - 0.25) * (double)gs), (int)(((double)(this.y2 - yp) - 0.25) * (double)gs), gs / 2, gs / 2);
                }
                g.setStroke(g_old);
            }
            if (!this.inservice) {
                g.setColor(Color.white);
            } else {
                g.setColor(TextColor1);
            }
            for (i = 0; i < this.npoly; ++i) {
                if (this.ChangingWirePoly != i + 1) continue;
                g.drawRect((int)(((double)(this.xpoly[i] - xp) - 0.25) * (double)gs), (int)(((double)(this.ypoly[i] - yp) - 0.25) * (double)gs), gs / 2, gs / 2);
            }
            if (!this.inservice) {
                g.setColor(Color.white);
            } else {
                g.setColor(TextColor2);
            }
            if (gs >= 0 && gs < 8) {
                g.setFont(Font10);
            }
            if (gs >= 6 && gs < 8) {
                g.setFont(Font9);
                if (this.npoly > 0) {
                    g.drawString(this.auxs, (int)((double)(this.xpoly[this.npoly / 2] - xp) + 0.5) * gs, (int)((double)(this.ypoly[this.npoly / 2] - yp) - 0.5) * gs);
                } else {
                    g.drawString(this.auxs, (int)((0.5 * (double)(this.x1 + this.x2 - 2 * xp) + 0.5) * (double)gs), (int)((0.5 * (double)(this.y1 + this.y2 - 2 * yp) - 0.5) * (double)gs));
                }
            } else if (gs >= 8 && gs < 10) {
                g.setFont(Font12);
                if (this.npoly > 0) {
                    g.drawString(this.auxs, (int)((double)(this.xpoly[this.npoly / 2] - xp) + 0.5) * gs, (int)((double)(this.ypoly[this.npoly / 2] - yp) - 0.5) * gs);
                } else {
                    g.drawString(this.auxs, (int)((0.5 * (double)(this.x1 + this.x2 - 2 * xp) + 0.5) * (double)gs), (int)((0.5 * (double)(this.y1 + this.y2 - 2 * yp) - 0.5) * (double)gs));
                }
            } else if (gs >= 10 && gs < 14) {
                g.setFont(Font14);
                if (this.npoly > 0) {
                    g.drawString(this.auxs, (int)((double)(this.xpoly[this.npoly / 2] - xp) + 0.5) * gs, (int)((double)(this.ypoly[this.npoly / 2] - yp) - 0.5) * gs);
                } else {
                    g.drawString(this.auxs, (int)((0.5 * (double)(this.x1 + this.x2 - 2 * xp) + 0.5) * (double)gs), (int)((0.5 * (double)(this.y1 + this.y2 - 2 * yp) - 0.5) * (double)gs));
                }
            } else if (gs >= 14 && gs < 18) {
                g.setFont(Font14);
                if (this.npoly > 0) {
                    g.drawString(this.auxs, (int)((double)(this.xpoly[this.npoly / 2] - xp) + 0.5) * gs, (int)((double)(this.ypoly[this.npoly / 2] - yp) - 0.5) * gs);
                } else {
                    g.drawString(this.auxs, (int)((0.5 * (double)(this.x1 + this.x2 - 2 * xp) + 0.5) * (double)gs), (int)((0.5 * (double)(this.y1 + this.y2 - 2 * yp) - 0.5) * (double)gs));
                }
            }
            if (gs >= 4) {
                if (gs >= 4) {
                    g.setFont(Font9);
                } else if (gs >= 8) {
                    g.setFont(Font10);
                } else if (gs >= 12) {
                    g.setFont(Font12);
                }
                if (!Modifiedstate && this.getinservice()) {
                    this.InformPartner(this.ConnComps1, this.x1, this.y1, 1);
                    this.InformPartner(this.ConnComps2, this.x2, this.y2, 2);
                    double counterflow = Math.abs(this.p12) + Math.abs(this.p21) + Math.abs(this.q21) + Math.abs(this.q12);
                    double belastung1 = Math.sqrt(Math.abs(this.p21) * Math.abs(this.p21) + Math.abs(this.q21) * Math.abs(this.q21));
                    double belastung2 = Math.sqrt(Math.abs(this.p12) * Math.abs(this.p12) + Math.abs(this.q12) * Math.abs(this.q12));
                    double belastung = Math.max(belastung1, belastung2) / (this.getsmax() * this.sc) * sref;
                    if (this.npoly > 0) {
                        if (belastung >= 1.0) {
                            g.setColor(Color.red);
                        } else if (belastung >= 0.9) {
                            g.setColor(Color.magenta);
                        } else if (belastung >= 0.5) {
                            g.setColor(Color.orange);
                        } else {
                            g.setColor(Color.green);
                        }
                        g.fillArc((int)((double)(this.xpoly[this.npoly / 2] - xp) + 0.5) * gs, (int)((double)(this.ypoly[this.npoly / 2] - yp) + 0.5) * gs, 2 * gs, 2 * gs, 90 - (int)Math.max(belastung * 360.0, 4.0), (int)Math.max(belastung * 360.0, 4.0));
                        g.setColor(TextColor1);
                        g.drawOval((int)((double)(this.xpoly[this.npoly / 2] - xp) + 0.5) * gs, (int)((double)(this.ypoly[this.npoly / 2] - yp) + 0.5) * gs, 2 * gs, 2 * gs);
                    } else {
                        if (belastung >= 1.0) {
                            g.setColor(Color.red);
                        } else if (belastung >= 0.9) {
                            g.setColor(Color.magenta);
                        } else if (belastung >= 0.5) {
                            g.setColor(Color.orange);
                        } else {
                            g.setColor(Color.green);
                        }
                        g.fillArc((int)((0.5 * (double)(this.x1 + this.x2 - 2 * xp) + 0.5) * (double)gs), (int)((0.5 * (double)(this.y1 + this.y2 - 2 * yp) - 0.5) * (double)gs), 2 * gs, 2 * gs, 90 - (int)Math.max(belastung * 360.0, 4.0), (int)Math.max(belastung * 360.0, 4.0));
                        g.setColor(TextColor1);
                        g.drawOval((int)((0.5 * (double)(this.x1 + this.x2 - 2 * xp) + 0.5) * (double)gs), (int)((0.5 * (double)(this.y1 + this.y2 - 2 * yp) - 0.5) * (double)gs), 2 * gs, 2 * gs);
                    }
                    if (counterflow != 0.0) {
                        int posy;
                        int posx;
                        if (this.InformRelativePosition(this.ConnComps1, this.x1, this.y1, 1)) {
                            posx = (int)(((double)(this.x1 - xp) - 0.5) * (double)gs);
                            posy = (this.y1 - yp) * gs;
                            if (this.above) {
                                g.setColor(Color1);
                                if (this.p21 != 0.0 || this.p12 != 0.0) {
                                    g.drawString(StringUtil.printf(Math.abs(this.p12) * sref, 10, 2), posx - 4 * gs, (int)((double)posy + 1.2 * (double)gs));
                                }
                                if (this.p12 > 0.0) {
                                    GraphicsUtil.drawArrow(g, posx, posy + 2 * gs, posx, posy, 1, (int)((double)gs * 0.3));
                                } else if (this.p12 < 0.0) {
                                    GraphicsUtil.drawArrow(g, posx, posy, posx, posy + 2 * gs, 1, (int)((double)gs * 0.3));
                                }
                                if (ShowReactive) {
                                    g.setColor(TextColor1);
                                    if (this.q21 != 0.0 || this.q12 != 0.0) {
                                        g.drawString(StringUtil.printf(Math.abs(this.q12) * sref, 10, 2), posx - 4 * gs, (int)((double)posy + 2.2 * (double)gs));
                                    }
                                    if (this.q12 > 0.0) {
                                        GraphicsUtil.drawArrow(g, posx + gs, posy + 2 * gs, posx + gs, posy, 1, (int)((double)gs * 0.3));
                                    } else if (this.q12 < 0.0) {
                                        GraphicsUtil.drawArrow(g, posx + gs, posy, posx + gs, posy + 2 * gs, 1, (int)((double)gs * 0.3));
                                    }
                                }
                            } else {
                                g.setColor(Color1);
                                if (this.p21 != 0.0 || this.p12 != 0.0) {
                                    g.drawString(StringUtil.printf(Math.abs(this.p12) * sref, 10, 2), posx - 4 * gs, (int)((double)posy - 2.2 * (double)gs));
                                }
                                if (this.p12 > 0.0) {
                                    GraphicsUtil.drawArrow(g, posx, posy - 2 * gs, posx, posy, 1, (int)((double)gs * 0.3));
                                } else if (this.p12 < 0.0) {
                                    GraphicsUtil.drawArrow(g, posx, posy, posx, posy - 2 * gs, 1, (int)((double)gs * 0.3));
                                }
                                if (ShowReactive) {
                                    g.setColor(TextColor1);
                                    if (this.q21 != 0.0 || this.q12 != 0.0) {
                                        g.drawString(StringUtil.printf(Math.abs(this.q12) * sref, 10, 2), posx - 4 * gs, (int)((double)posy - 1.2 * (double)gs));
                                    }
                                    if (this.q12 > 0.0) {
                                        GraphicsUtil.drawArrow(g, posx + gs, posy - 2 * gs, posx + gs, posy, 1, (int)((double)gs * 0.3));
                                    } else if (this.q12 < 0.0) {
                                        GraphicsUtil.drawArrow(g, posx + gs, posy, posx + gs, posy - 2 * gs, 1, (int)((double)gs * 0.3));
                                    }
                                }
                            }
                        }
                        if (this.InformRelativePosition(this.ConnComps2, this.x2, this.y2, 1)) {
                            posx = (int)(((double)(this.x2 - xp) - 0.5) * (double)gs);
                            posy = (this.y2 - yp) * gs;
                            if (this.above) {
                                g.setColor(Color1);
                                if (this.p21 != 0.0 || this.p12 != 0.0) {
                                    g.drawString(StringUtil.printf(Math.abs(this.p21) * sref, 10, 2), posx - 4 * gs, (int)((double)posy + 1.2 * (double)gs));
                                }
                                if (this.p21 > 0.0 && this.p21 != 0.0) {
                                    GraphicsUtil.drawArrow(g, posx, posy + 2 * gs, posx, posy, 1, (int)((double)gs * 0.3));
                                } else if (this.p21 < 0.0 && this.p21 != 0.0) {
                                    GraphicsUtil.drawArrow(g, posx, posy, posx, posy + 2 * gs, 1, (int)((double)gs * 0.3));
                                }
                                if (ShowReactive) {
                                    g.setColor(TextColor1);
                                    if (this.q21 != 0.0 || this.q12 != 0.0) {
                                        g.drawString(StringUtil.printf(Math.abs(this.q21) * sref, 10, 2), posx - 4 * gs, (int)((double)posy + 2.2 * (double)gs));
                                    }
                                    if (this.q21 > 0.0 && this.q21 != 0.0) {
                                        GraphicsUtil.drawArrow(g, posx + gs, posy + 2 * gs, posx + gs, posy, 1, (int)((double)gs * 0.3));
                                    } else if (this.q21 < 0.0 && this.q21 != 0.0) {
                                        GraphicsUtil.drawArrow(g, posx + gs, posy, posx + gs, posy + 2 * gs, 1, (int)((double)gs * 0.3));
                                    }
                                }
                            } else {
                                g.setColor(Color1);
                                if (this.p21 != 0.0 || this.p12 != 0.0) {
                                    g.drawString(StringUtil.printf(Math.abs(this.p21) * sref, 10, 2), posx - 4 * gs, (int)((double)posy - 2.2 * (double)gs));
                                }
                                if (this.p21 > 0.0 && this.p21 != 0.0) {
                                    GraphicsUtil.drawArrow(g, posx, posy - 2 * gs, posx, posy, 1, (int)((double)gs * 0.3));
                                } else if (this.p21 < 0.0 && this.p21 != 0.0) {
                                    GraphicsUtil.drawArrow(g, posx, posy, posx, posy - 2 * gs, 1, (int)((double)gs * 0.3));
                                }
                                if (ShowReactive) {
                                    g.setColor(TextColor1);
                                    if (this.q21 != 0.0 || this.q12 != 0.0) {
                                        g.drawString(StringUtil.printf(Math.abs(this.q21) * sref, 10, 2), posx - 4 * gs, (int)((double)posy - 1.2 * (double)gs));
                                    }
                                    if (this.q21 > 0.0 && this.q21 != 0.0) {
                                        GraphicsUtil.drawArrow(g, posx + gs, posy - 2 * gs, posx + gs, posy, 1, (int)((double)gs * 0.3));
                                    } else if (this.q21 < 0.0 && this.q21 != 0.0) {
                                        GraphicsUtil.drawArrow(g, posx + gs, posy, posx + gs, posy - 2 * gs, 1, (int)((double)gs * 0.3));
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else if (this.npolysim > 0) {
            if (this.pospolysim == this.npolysim - 1) {
                this.pospolysim = 0;
            }
            g.setColor(this.auxcolor);
            GraphicsUtil.drawArrow(g, (int)((this.xpolysim[this.pospolysim] - (double)xp) * (double)gs), (int)((this.ypolysim[this.pospolysim] - (double)yp) * (double)gs), (int)((this.xpolysim[this.pospolysim + 1] - (double)xp) * (double)gs), (int)((this.ypolysim[this.pospolysim + 1] - (double)yp) * (double)gs), 1, (int)((double)gs * 1.5));
            ++this.pospolysim;
        }
    }

    public int sgn(int val) {
        if (val > 0) {
            return 1;
        }
        if (val < 0) {
            return -1;
        }
        return 0;
    }

    public boolean CheckIfPointInWire(int a, int b, int c, int d, int x, int y) {
        int n;
        int u = c - a;
        int v = d - b;
        int d1x = this.sgn(u);
        int d1y = this.sgn(v);
        int d2x = this.sgn(u);
        int d2y = 0;
        int m = Math.abs(u);
        if (m <= (n = Math.abs(v))) {
            d2x = 0;
            d2y = this.sgn(v);
            m = Math.abs(v);
            n = Math.abs(u);
        }
        int s = m / 2;
        for (int i = 0; i < m; ++i) {
            if (Math.abs(x - a) < 2 && Math.abs(y - b) < 2) {
                return true;
            }
            if ((s += n) >= m) {
                s -= m;
                a += d1x;
                b += d1y;
                continue;
            }
            a += d2x;
            b += d2y;
        }
        return false;
    }

    @Override
    public boolean CheckIfComponentClicked(int x, int y) {
        int i;
        if (x == this.x1 && y == this.y1) {
            this.ChangingWire = 1;
            return true;
        }
        if (x == this.x2 && y == this.y2) {
            this.ChangingWire = 2;
            return true;
        }
        for (i = 0; i < this.npoly; ++i) {
            if (Math.abs(x - this.xpoly[i]) > 2 || Math.abs(y - this.ypoly[i]) > 2) continue;
            this.ChangingWirePoly = i + 1;
            return true;
        }
        if (this.npoly == 0) {
            if (this.CheckIfPointInWire(this.x1, this.y1, this.x2, this.y2, x, y)) {
                this.ChangingWire = 3;
                return true;
            }
        } else {
            if (this.CheckIfPointInWire(this.x1, this.y1, this.xpoly[0], this.ypoly[0], x, y)) {
                this.ChangingWire = 3;
                return true;
            }
            if (this.CheckIfPointInWire(this.xpoly[this.npoly - 1], this.ypoly[this.npoly - 1], this.x2, this.y2, x, y)) {
                this.ChangingWire = 3;
                return true;
            }
            for (i = 0; i < this.npoly - 1; ++i) {
                if (!this.CheckIfPointInWire(this.xpoly[i], this.ypoly[i], this.xpoly[i + 1], this.ypoly[i + 1], x, y)) continue;
                this.ChangingWire = 3;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isLocatedAt(int x, int y) {
        return this.CheckIfPointInWire(this.x1, this.y1, this.x2, this.y2, x, y);
    }

    @Override
    public boolean CheckIfComponentInSelectBox(int tx1, int ty1, int tx2, int ty2) {
        this.setSelected(false);
        this.ChangingWire = 0;
        this.ChangingWirePoly = 0;
        if (tx1 <= this.x1 && this.x1 <= tx2 && ty1 <= this.y1 && this.y1 <= ty2) {
            this.ChangingWire |= 1;
            this.setSelected(true);
        }
        if (tx1 <= this.x2 && this.x2 <= tx2 && ty1 <= this.y2 && this.y2 <= ty2) {
            this.ChangingWire |= 2;
            this.setSelected(true);
        }
        for (int i = 0; i < this.npoly; ++i) {
            if (tx1 > this.xpoly[i] || this.xpoly[i] > tx2 || ty1 > this.ypoly[i] || this.ypoly[i] > ty2) continue;
            this.ChangingWirePoly = i + 1;
            this.setSelected(true);
        }
        return this.isSelected();
    }

    @Override
    public boolean CheckIfComponentInDrawArea(int tx1, int ty1, int tx2, int ty2) {
        int y2min;
        int cy2;
        int cy1;
        int cx2;
        int cx1;
        if (this.x1 < this.x2) {
            cx1 = this.x1;
            cx2 = this.x2;
        } else {
            cx1 = this.x2;
            cx2 = this.x1;
        }
        if (this.y1 < this.y2) {
            cy1 = this.y1;
            cy2 = this.y2;
        } else {
            cy1 = this.y2;
            cy2 = this.y1;
        }
        for (int i = 0; i < this.npoly; ++i) {
            if (cx1 > this.xpoly[i]) {
                cx1 = this.xpoly[i];
            }
            if (cx2 < this.xpoly[i]) {
                cx2 = this.xpoly[i];
            }
            if (cy1 > this.ypoly[i]) {
                cy1 = this.ypoly[i];
            }
            if (cy2 >= this.ypoly[i]) continue;
            cy2 = this.ypoly[i];
        }
        int x1max = cx1 > tx1 ? cx1 : tx1;
        int x2min = cx2 < tx2 ? cx2 : tx2;
        int y1max = cy1 > ty1 ? cy1 : ty1;
        int n = y2min = cy2 < ty2 ? cy2 : ty2;
        return x1max <= x2min && y1max <= y2min;
    }

    @Override
    public void Save(PrintStream myPrintStream) {
        myPrintStream.println("describe component Line");
        myPrintStream.println(" pos " + this.x1 + " " + this.y1);
        myPrintStream.println(" pos2 " + this.x2 + " " + this.y2);
        for (int i = 0; i < this.npoly; ++i) {
            myPrintStream.println(" pospoly " + this.xpoly[i] + " " + this.ypoly[i]);
        }
        myPrintStream.println(" Name " + this.ComponentName);
        myPrintStream.println(" type " + this.inv_type);
        myPrintStream.println(" alias " + this.alias);
        myPrintStream.println(" owner " + this.inv_owner);
        myPrintStream.println(" ctrla " + this.ctrla);
        myPrintStream.println(" cost " + this.inv_cost);
        myPrintStream.println(" coym " + this.coym);
        myPrintStream.println(" un1 " + this.un[0]);
        myPrintStream.println(" smax " + this.smax);
        myPrintStream.println(" sc " + this.sc);
        myPrintStream.println(" sn " + this.sn);
        myPrintStream.println(" lifetime " + this.life_time);
        myPrintStream.println(" entryperiod " + this.entry_period);
        myPrintStream.println(" exitperiod " + this.exit_period);
        myPrintStream.println(" entrymonth " + this.entry_month);
        myPrintStream.println(" exitmonth " + this.exit_month);
        myPrintStream.println(" r1 " + this.r1);
        myPrintStream.println(" xx1 " + this.xx1);
        myPrintStream.println(" g1 " + this.g1);
        myPrintStream.println(" b1 " + this.b1);
        myPrintStream.println(" len " + this.len);
        myPrintStream.println(" planning " + this.planning);
        myPrintStream.println(" project " + this.project);
        myPrintStream.println(" alternative " + this.alternative);
        myPrintStream.println(" suggest " + this.suggest);
        myPrintStream.println(" inservice  " + this.inservice);
        myPrintStream.println("end describe");
    }

    @Override
    public void SaveDatabase() throws SQLException {
        int i = 0;
        Statement stmt = DeepEditFrame.con.createStatement();
        String query = "INSERT INTO Line (XPos, YPos, XPos2, YPos2, Name, type, alias, owner, ctrla, cost, coym, un1, smax, sc, lifetime, entryperiod, exitperiod, entrymonth, exitmonth, incomep, incomeq, r1, xx1, g1, b1, len, sn, planning,numpoly,U1,U2,delta1,delta2,p12,q12,p21,q21,project,alternative,suggest,con1,con2,inservice";
        for (i = 0; i < this.npoly; ++i) {
            query = query + ", pospolyx" + String.valueOf(i + 1);
        }
        for (i = 0; i < this.npoly; ++i) {
            query = query + ", pospolyy" + String.valueOf(i + 1);
        }
        query = query + ") VALUES (" + String.valueOf(this.x1) + "," + String.valueOf(this.y1) + "," + String.valueOf(this.x2) + "," + String.valueOf(this.y2) + ",'" + this.ComponentName + "','" + this.inv_type + "','" + this.alias + "','" + this.inv_owner + "','" + this.ctrla + "'," + String.valueOf(this.inv_cost) + "," + String.valueOf(this.coym) + "," + String.valueOf(this.un[0]) + "," + String.valueOf(this.smax) + "," + String.valueOf(this.sc) + "," + String.valueOf(this.life_time) + "," + String.valueOf(this.entry_period) + "," + String.valueOf(this.exit_period) + "," + String.valueOf(this.entry_month) + "," + String.valueOf(this.exit_month) + "," + String.valueOf(this.m_incomep) + "," + String.valueOf(this.m_incomeq) + "," + String.valueOf(this.r1) + "," + String.valueOf(this.xx1) + "," + String.valueOf(this.g1) + "," + String.valueOf(this.b1) + "," + String.valueOf(this.len) + "," + String.valueOf(this.sn) + "," + String.valueOf(this.planning) + "," + String.valueOf(this.npoly) + "," + String.valueOf(this.getu1()) + "," + String.valueOf(this.getu2()) + "," + String.valueOf(this.getdelta1()) + "," + String.valueOf(this.getdelta2()) + "," + String.valueOf(this.p12) + "," + String.valueOf(this.q12) + "," + String.valueOf(this.p21) + "," + String.valueOf(this.q21) + ",'" + this.project + "','" + this.alternative + "'," + (this.suggest ? 1 : 0) + ",'" + this.con1 + "','" + this.con2 + "'," + (this.inservice ? 1 : 0);
        for (i = 0; i < this.npoly; ++i) {
            query = query + "," + String.valueOf(this.xpoly[i]);
        }
        for (i = 0; i < this.npoly; ++i) {
            query = query + "," + String.valueOf(this.ypoly[i]);
        }
        query = query + ")";
        try {
            stmt.executeUpdate(query);
        }
        catch (SQLException e) {
            System.out.println("Error saving parameters of line: " + this.getName() + " to database when executing query:");
            System.out.println(query);
            System.out.println(e.getMessage());
        }
        stmt.close();
    }

    public String Statistic(int ix, double sref) {
        this.nocona = true;
        this.nocone = true;
        this.setcon1(" ");
        this.setcon2(" ");
        this.InformAllComponents();
        String linea = StringUtil.printf(ix, 4) + " " + StringUtil.printf(this.ComponentName, 40) + " " + StringUtil.printf(this.con1, 20) + " " + StringUtil.printf(this.con2, 20) + " " + StringUtil.printf(this.inv_cost, 10, 2) + " " + StringUtil.printf(this.coym, 10, 2) + " " + StringUtil.printf(this.inv_type, 10) + " " + StringUtil.printf(this.inv_owner, 10) + " " + StringUtil.printf(this.life_time, 4) + " " + StringUtil.printf(this.entry_period, 5) + " " + StringUtil.printf(this.sn, 10, 2) + " " + StringUtil.printf(this.smax, 10, 2) + " " + StringUtil.printf(this.sc, 10, 4) + " " + StringUtil.printf(this.smax / this.un[0] / Math.sqrt(3.0) / sref * 1000.0, 10, 2) + " " + StringUtil.printf(this.un[0], 10, 2) + " " + StringUtil.printf(this.r1, 10, 5) + " " + StringUtil.printf(this.xx1, 10, 5) + " " + StringUtil.printf(this.g1, 12, 5) + " " + StringUtil.printf(this.b1, 12, 5) + " " + StringUtil.printf(this.len, 10, 2) + " " + StringUtil.printf(this.getSeriesResistance(sref), 10, 5) + " " + StringUtil.printf(this.getSeriesReactance(sref), 10, 5);
        return linea;
    }

    public boolean TryPlaceJunction(Schematic ActSchematic, Pin[][] PinGrid, int x, int y, int gs) {
        int i;
        if (x == this.x1 && y == this.y1) {
            return false;
        }
        if (x == this.x2 && y == this.y2) {
            return false;
        }
        for (i = 0; i < this.npoly; ++i) {
            if (Math.abs(x - this.xpoly[i]) > 2 || Math.abs(y - this.ypoly[i]) > 2) continue;
            --this.npoly;
            for (int j = i; j < this.npoly; ++j) {
                this.xpoly[j] = this.xpoly[j + 1];
                this.ypoly[j] = this.ypoly[j + 1];
            }
            return true;
        }
        if (this.npoly == 0) {
            if (this.CheckIfPointInWire(this.x1 * gs, this.y1 * gs, this.x2 * gs, this.y2 * gs, x * gs, y * gs)) {
                this.xpoly[this.npoly] = x;
                this.ypoly[this.npoly] = y;
                ++this.npoly;
                this.ChangingWirePoly = this.npoly;
                return true;
            }
        } else {
            if (this.CheckIfPointInWire(this.x1 * gs, this.y1 * gs, this.xpoly[0] * gs, this.ypoly[0] * gs, x * gs, y * gs)) {
                for (i = this.npoly; i > 0; --i) {
                    this.xpoly[i] = this.xpoly[i - 1];
                    this.ypoly[i] = this.ypoly[i - 1];
                }
                this.xpoly[0] = x;
                this.ypoly[0] = y;
                ++this.npoly;
                this.ChangingWirePoly = 1;
                return true;
            }
            if (this.CheckIfPointInWire(this.xpoly[this.npoly - 1] * gs, this.ypoly[this.npoly - 1] * gs, this.x2 * gs, this.y2 * gs, x * gs, y * gs)) {
                this.xpoly[this.npoly] = x;
                this.ypoly[this.npoly] = y;
                ++this.npoly;
                this.ChangingWirePoly = this.npoly;
                return true;
            }
            for (i = 0; i < this.npoly - 1; ++i) {
                if (!this.CheckIfPointInWire(this.xpoly[i] * gs, this.ypoly[i] * gs, this.xpoly[i + 1] * gs, this.ypoly[i + 1] * gs, x * gs, y * gs)) continue;
                for (int j = this.npoly; j > i; --j) {
                    this.xpoly[j] = this.xpoly[j - 1];
                    this.ypoly[j] = this.ypoly[j - 1];
                }
                this.xpoly[i + 1] = x;
                this.ypoly[i + 1] = y;
                ++this.npoly;
                this.ChangingWirePoly = i + 1;
                return true;
            }
        }
        return false;
    }

    public void setm_incomep() {
        comp ConnectedComponent;
        int ix;
        Busbar MyBusbar = null;
        double costo_1 = 0.0;
        double costo_2 = 0.0;
        for (ix = 0; ix < this.ConnComps1.size(); ++ix) {
            ConnectedComponent = (comp)this.ConnComps1.elementAt(ix);
            if (!(ConnectedComponent instanceof Busbar) || !(MyBusbar = (Busbar)ConnectedComponent).getName().equals(this.getcon1())) continue;
            costo_1 = MyBusbar.getspot_p();
        }
        for (ix = 0; ix < this.ConnComps2.size(); ++ix) {
            ConnectedComponent = (comp)this.ConnComps2.elementAt(ix);
            if (!(ConnectedComponent instanceof Busbar) || !(MyBusbar = (Busbar)ConnectedComponent).getName().equals(this.getcon2())) continue;
            costo_2 = MyBusbar.getspot_p();
        }
        this.setm_incomep(-(this.getp21() * costo_2) - this.getp12() * costo_1);
    }

    @Override
    public comp getReceiverComponent() {
        if (this.x2 < 0 || this.y2 < 0) {
            return null;
        }
        Pin mypin = DeepEdit.PinGrid[this.x2][this.y2];
        if (mypin != null && mypin.ComponentsSize() > 0) {
            for (int ii = 0; ii < mypin.ComponentsSize(); ++ii) {
                comp tempComp = mypin.GetComponent(ii);
                if (tempComp == null || !(tempComp instanceof ndb_comp) || tempComp == this) continue;
                return tempComp;
            }
        }
        return null;
    }

    @Override
    public comp getSenderComponent() {
        if (this.x1 < 0 || this.y1 < 0) {
            return null;
        }
        Pin mypin = DeepEdit.PinGrid[this.x1][this.y1];
        if (mypin != null && mypin.ComponentsSize() > 0) {
            for (int ii = 0; ii < mypin.ComponentsSize(); ++ii) {
                comp tempComp = mypin.GetComponent(ii);
                if (tempComp == null || !(tempComp instanceof ndb_comp) || tempComp == this) continue;
                return tempComp;
            }
        }
        return null;
    }

    public boolean IsReceiverConnected() {
        comp TempComponent = this.getReceiverComponent();
        return TempComponent != null && TempComponent instanceof Busbar;
    }

    public boolean IsSenderConnected() {
        comp TempComponent = this.getSenderComponent();
        return TempComponent != null && TempComponent instanceof Busbar;
    }

    @Override
    public void saveToFile(PrintStream ps) {
        ps.println("describe component " + this.getClassName());
        for (ParameterData pData : this.getAllParametersInfo()) {
            if (pData.getName().startsWith("pospoly")) continue;
            ps.println(" " + pData.getName() + " " + pData.getValue());
        }
        for (int i = 1; i <= this.getnpoly(); ++i) {
            ParameterData pPospolyxData = new ParameterData("pospolyx" + i);
            String dPospolyx = this.getParamaterValue("pospolyx" + i);
            String dPospolyy = this.getParamaterValue("pospolyy" + i);
            ps.println(" pospolyx" + i + " " + dPospolyx);
            ps.println(" pospolyy" + i + " " + dPospolyy);
        }
        ps.println("end describe component");
    }

    @Override
    public boolean getParameterInfo(String sParameterName, ParameterData oData) {
        String sValue = null;
        DE_GeneralEnums.databaseDataType eDataType = null;
        DE_GeneralEnums.parameterGroup eGroup = null;
        oData.seteGroup(DE_GeneralEnums.parameterGroup.Operation);
        if (sParameterName.equalsIgnoreCase("Name")) {
            sValue = this.getName();
            eDataType = DE_GeneralEnums.databaseDataType.StringValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("alias")) {
            sValue = this.getalias();
            eDataType = DE_GeneralEnums.databaseDataType.StringValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("con1")) {
            sValue = this.getcon1();
            eDataType = DE_GeneralEnums.databaseDataType.StringValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("con2")) {
            sValue = this.getcon2();
            eDataType = DE_GeneralEnums.databaseDataType.StringValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("p12")) {
            sValue = String.valueOf(this.getp12());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("p21")) {
            sValue = String.valueOf(this.getp21());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("q12")) {
            sValue = String.valueOf(this.getq12());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("q21")) {
            sValue = String.valueOf(this.getq21());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("un1")) {
            sValue = String.valueOf(this.getun1());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("sn")) {
            sValue = String.valueOf(this.getsn());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("smax")) {
            sValue = String.valueOf(this.getsmax());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("r1")) {
            sValue = String.valueOf(this.getr1());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("xx1")) {
            sValue = String.valueOf(this.getxx1());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("b1")) {
            sValue = String.valueOf(this.getb1());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("g1")) {
            sValue = String.valueOf(this.getg1());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("len")) {
            sValue = String.valueOf(this.getlen());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("sc")) {
            sValue = String.valueOf(this.getsc());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("U1")) {
            sValue = String.valueOf(this.getu1());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("U2")) {
            sValue = String.valueOf(this.getu2());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("delta1")) {
            sValue = String.valueOf(this.getdelta1());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("delta2")) {
            sValue = String.valueOf(this.getdelta2());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("inservicei")) {
            sValue = String.valueOf(this.getinservicei());
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("inservice")) {
            sValue = String.valueOf(this.getinservice());
            eDataType = DE_GeneralEnums.databaseDataType.BooleanValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("type")) {
            sValue = this.getinv_type();
            eDataType = DE_GeneralEnums.databaseDataType.StringValue;
            eGroup = DE_GeneralEnums.parameterGroup.Economic;
        } else if (sParameterName.equalsIgnoreCase("owner")) {
            sValue = this.getinv_owner();
            eDataType = DE_GeneralEnums.databaseDataType.StringValue;
            eGroup = DE_GeneralEnums.parameterGroup.Economic;
        } else if (sParameterName.equalsIgnoreCase("lifetime")) {
            sValue = String.valueOf(this.getlife_time());
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Economic;
        } else if (sParameterName.equalsIgnoreCase("entryperiod")) {
            sValue = String.valueOf(this.getentry_period());
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Economic;
        } else if (sParameterName.equalsIgnoreCase("exitperiod")) {
            sValue = String.valueOf(this.getexit_period());
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Economic;
        } else if (sParameterName.equalsIgnoreCase("cost")) {
            sValue = String.valueOf(this.getinv_cost());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Economic;
        } else if (sParameterName.equalsIgnoreCase("entrymonth")) {
            sValue = String.valueOf(this.getentry_month());
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Economic;
        } else if (sParameterName.equalsIgnoreCase("exitmonth")) {
            sValue = String.valueOf(this.getexit_month());
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Economic;
        } else if (sParameterName.equalsIgnoreCase("coym")) {
            sValue = String.valueOf(this.getcoym());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Economic;
        } else if (sParameterName.equalsIgnoreCase("alternative")) {
            sValue = this.getalternative();
            eDataType = DE_GeneralEnums.databaseDataType.StringValue;
            eGroup = DE_GeneralEnums.parameterGroup.Economic;
        } else if (sParameterName.equalsIgnoreCase("planning")) {
            sValue = String.valueOf(this.getplanning());
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Economic;
        } else if (sParameterName.equalsIgnoreCase("project")) {
            sValue = this.getproject();
            eDataType = DE_GeneralEnums.databaseDataType.StringValue;
            eGroup = DE_GeneralEnums.parameterGroup.Economic;
        } else if (sParameterName.equalsIgnoreCase("incomep")) {
            sValue = String.valueOf(this.getm_incomep());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Economic;
        } else if (sParameterName.equalsIgnoreCase("incomeq")) {
            sValue = String.valueOf(this.getm_incomeq());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Economic;
        } else if (sParameterName.equalsIgnoreCase("suggest")) {
            sValue = String.valueOf(this.getsuggest());
            eDataType = DE_GeneralEnums.databaseDataType.BooleanValue;
            eGroup = DE_GeneralEnums.parameterGroup.Economic;
        } else if (sParameterName.equalsIgnoreCase("ctrla")) {
            sValue = this.getctrla();
            eDataType = DE_GeneralEnums.databaseDataType.StringValue;
            eGroup = DE_GeneralEnums.parameterGroup.Location;
        } else if (sParameterName.equalsIgnoreCase("XPos")) {
            sValue = String.valueOf(this.getx1());
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Location;
        } else if (sParameterName.equalsIgnoreCase("YPos")) {
            sValue = String.valueOf(this.gety1());
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Location;
        } else if (sParameterName.equalsIgnoreCase("XPos2")) {
            sValue = String.valueOf(this.getx2());
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Location;
        } else if (sParameterName.equalsIgnoreCase("YPos2")) {
            sValue = String.valueOf(this.gety2());
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Location;
        } else if (sParameterName.equalsIgnoreCase("numpoly")) {
            sValue = String.valueOf(this.getnpoly());
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Specific;
        } else if (sParameterName.equalsIgnoreCase("pospolyx1")) {
            sValue = String.valueOf(this.xpoly[0]);
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Specific;
        } else if (sParameterName.equalsIgnoreCase("pospolyy1")) {
            sValue = String.valueOf(this.ypoly[0]);
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Specific;
        } else if (sParameterName.equalsIgnoreCase("pospolyx2")) {
            sValue = String.valueOf(this.xpoly[1]);
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Specific;
        } else if (sParameterName.equalsIgnoreCase("pospolyy2")) {
            sValue = String.valueOf(this.ypoly[1]);
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Specific;
        } else if (sParameterName.equalsIgnoreCase("pospolyx3")) {
            sValue = String.valueOf(this.xpoly[2]);
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Specific;
        } else if (sParameterName.equalsIgnoreCase("pospolyy3")) {
            sValue = String.valueOf(this.ypoly[2]);
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Specific;
        } else if (sParameterName.equalsIgnoreCase("pospolyx4")) {
            sValue = String.valueOf(this.xpoly[3]);
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Specific;
        } else if (sParameterName.equalsIgnoreCase("pospolyy4")) {
            sValue = String.valueOf(this.ypoly[3]);
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Specific;
        } else if (sParameterName.equalsIgnoreCase("pospolyx5")) {
            sValue = String.valueOf(this.xpoly[4]);
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Specific;
        } else if (sParameterName.equalsIgnoreCase("pospolyy5")) {
            sValue = String.valueOf(this.ypoly[4]);
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Specific;
        } else if (sParameterName.equalsIgnoreCase("pospolyx6")) {
            sValue = String.valueOf(this.xpoly[5]);
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Specific;
        } else if (sParameterName.equalsIgnoreCase("pospolyy6")) {
            sValue = String.valueOf(this.ypoly[5]);
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Specific;
        } else if (sParameterName.equalsIgnoreCase("pospolyx7")) {
            sValue = String.valueOf(this.xpoly[6]);
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Specific;
        } else if (sParameterName.equalsIgnoreCase("pospolyy7")) {
            sValue = String.valueOf(this.ypoly[6]);
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Specific;
        } else if (sParameterName.equalsIgnoreCase("pospolyx8")) {
            sValue = String.valueOf(this.xpoly[7]);
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Specific;
        } else if (sParameterName.equalsIgnoreCase("pospolyy8")) {
            sValue = String.valueOf(this.ypoly[7]);
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Specific;
        } else if (sParameterName.equalsIgnoreCase("pospolyx9")) {
            sValue = String.valueOf(this.xpoly[8]);
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Specific;
        } else if (sParameterName.equalsIgnoreCase("pospolyy9")) {
            sValue = String.valueOf(this.ypoly[8]);
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Specific;
        } else if (sParameterName.equalsIgnoreCase("pospolyx10")) {
            sValue = String.valueOf(this.xpoly[9]);
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Specific;
        } else if (sParameterName.equalsIgnoreCase("pospolyy10")) {
            sValue = String.valueOf(this.ypoly[9]);
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Specific;
        } else if (sParameterName.equalsIgnoreCase("pospolyx11")) {
            sValue = String.valueOf(this.xpoly[10]);
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Specific;
        } else if (sParameterName.equalsIgnoreCase("pospolyy11")) {
            sValue = String.valueOf(this.ypoly[10]);
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Specific;
        } else if (sParameterName.equalsIgnoreCase("pospolyx12")) {
            sValue = String.valueOf(this.xpoly[11]);
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Specific;
        } else if (sParameterName.equalsIgnoreCase("pospolyy12")) {
            sValue = String.valueOf(this.ypoly[11]);
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Specific;
        } else if (sParameterName.equalsIgnoreCase("pospolyx13")) {
            sValue = String.valueOf(this.xpoly[12]);
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Specific;
        } else if (sParameterName.equalsIgnoreCase("pospolyy13")) {
            sValue = String.valueOf(this.ypoly[12]);
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Specific;
        } else if (sParameterName.equalsIgnoreCase("pospolyx14")) {
            sValue = String.valueOf(this.xpoly[13]);
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Specific;
        } else if (sParameterName.equalsIgnoreCase("pospolyy14")) {
            sValue = String.valueOf(this.ypoly[13]);
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Specific;
        } else if (sParameterName.equalsIgnoreCase("pospolyx15")) {
            sValue = String.valueOf(this.xpoly[14]);
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Specific;
        } else if (sParameterName.equalsIgnoreCase("pospolyy15")) {
            sValue = String.valueOf(this.ypoly[14]);
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Specific;
        }
        if (sValue != null) {
            oData.setValue(sValue, eDataType, eGroup);
        } else {
            ParameterData oDataOld = (ParameterData)this.mData.get(sParameterName);
            if (oDataOld == null && (oDataOld = DeepEdit.getDefaultParameterInfo(this.ClassName, sParameterName)) == null) {
                assert (false) : "Why are you looking for parameter '" + sParameterName + "' if it is not supported by object '" + this.ClassName + "?";
                return false;
            }
            oDataOld.copyParameterInto(oData);
        }
        return true;
    }

    @Override
    public boolean setParameterInfo(String sParameterName, ParameterData pData) {
        String sValue = pData.getValue();
        if (sParameterName.equalsIgnoreCase("Name")) {
            this.setName(sValue);
            return true;
        }
        if (sParameterName.equalsIgnoreCase("alias")) {
            this.setalias(sValue);
            return true;
        }
        if (sParameterName.equalsIgnoreCase("con1")) {
            this.setcon1(sValue);
            return true;
        }
        if (sParameterName.equalsIgnoreCase("con2")) {
            this.setcon2(sValue);
            return true;
        }
        if (sParameterName.equalsIgnoreCase("un1")) {
            this.setun1(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("sn")) {
            this.setsn(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("smax")) {
            this.setsmax(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("U1")) {
            this.setu1(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("U2")) {
            this.setu2(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("delta1")) {
            this.setdelta1(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("delta2")) {
            this.setdelta2(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("inservicei")) {
            this.setinservicei(Integer.parseInt(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("inservice")) {
            this.setinservice(Boolean.parseBoolean(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("xx1")) {
            this.setxx1(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("r1")) {
            this.setr1(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("b1")) {
            this.setb1(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("g1")) {
            this.setg1(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("p12")) {
            this.setp12(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("p21")) {
            this.setp21(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("q12")) {
            this.setq12(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("q21")) {
            this.setq21(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("sc")) {
            this.setsc(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("len")) {
            this.setlen(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("type")) {
            this.setinv_type(sValue);
            return true;
        }
        if (sParameterName.equalsIgnoreCase("owner")) {
            this.setinv_owner(sValue);
            return true;
        }
        if (sParameterName.equalsIgnoreCase("lifetime")) {
            this.setlife_time((int)Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("entryperiod")) {
            this.setentry_period((int)Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("exitperiod")) {
            this.setexit_period((int)Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("cost")) {
            this.setinv_cost((int)Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("entrymonth")) {
            this.setentry_month((int)Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("exitmonth")) {
            this.setexit_month((int)Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("coym")) {
            this.setcoym(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("alternative")) {
            this.setalternative(sValue);
            return true;
        }
        if (sParameterName.equalsIgnoreCase("planning")) {
            this.setplanning((int)Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("project")) {
            this.setproject(sValue);
            return true;
        }
        if (sParameterName.equalsIgnoreCase("incomep")) {
            this.setm_incomep(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("incomeq")) {
            this.setm_incomeq(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("suggest")) {
            this.setsuggest(Boolean.parseBoolean(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("ctrla")) {
            this.setctrla(sValue);
            return true;
        }
        if (sParameterName.equalsIgnoreCase("XPos")) {
            this.setx1((int)Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("YPos")) {
            this.sety1((int)Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("XPos2")) {
            this.setx2((int)Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("YPos2")) {
            this.sety2((int)Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("numpoly")) {
            this.setnpoly((int)Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("pospolyx1")) {
            this.xpoly[0] = (int)Double.parseDouble(sValue);
            return true;
        }
        if (sParameterName.equalsIgnoreCase("pospolyy1")) {
            this.ypoly[0] = (int)Double.parseDouble(sValue);
            return true;
        }
        if (sParameterName.equalsIgnoreCase("pospolyx2")) {
            this.xpoly[1] = (int)Double.parseDouble(sValue);
            return true;
        }
        if (sParameterName.equalsIgnoreCase("pospolyy2")) {
            this.ypoly[1] = (int)Double.parseDouble(sValue);
            return true;
        }
        if (sParameterName.equalsIgnoreCase("pospolyx3")) {
            this.xpoly[2] = (int)Double.parseDouble(sValue);
            return true;
        }
        if (sParameterName.equalsIgnoreCase("pospolyy3")) {
            this.ypoly[2] = (int)Double.parseDouble(sValue);
            return true;
        }
        if (sParameterName.equalsIgnoreCase("pospolyx4")) {
            this.xpoly[3] = (int)Double.parseDouble(sValue);
            return true;
        }
        if (sParameterName.equalsIgnoreCase("pospolyy4")) {
            this.ypoly[3] = (int)Double.parseDouble(sValue);
            return true;
        }
        if (sParameterName.equalsIgnoreCase("pospolyx5")) {
            this.xpoly[4] = (int)Double.parseDouble(sValue);
            return true;
        }
        if (sParameterName.equalsIgnoreCase("pospolyy5")) {
            this.ypoly[4] = (int)Double.parseDouble(sValue);
            return true;
        }
        if (sParameterName.equalsIgnoreCase("pospolyx6")) {
            this.xpoly[5] = (int)Double.parseDouble(sValue);
            return true;
        }
        if (sParameterName.equalsIgnoreCase("pospolyy6")) {
            this.ypoly[5] = (int)Double.parseDouble(sValue);
            return true;
        }
        if (sParameterName.equalsIgnoreCase("pospolyx7")) {
            this.xpoly[6] = (int)Double.parseDouble(sValue);
            return true;
        }
        if (sParameterName.equalsIgnoreCase("pospolyy7")) {
            this.ypoly[6] = (int)Double.parseDouble(sValue);
            return true;
        }
        if (sParameterName.equalsIgnoreCase("pospolyx8")) {
            this.xpoly[7] = (int)Double.parseDouble(sValue);
            return true;
        }
        if (sParameterName.equalsIgnoreCase("pospolyy8")) {
            this.ypoly[7] = (int)Double.parseDouble(sValue);
            return true;
        }
        if (sParameterName.equalsIgnoreCase("pospolyx9")) {
            this.xpoly[8] = (int)Double.parseDouble(sValue);
            return true;
        }
        if (sParameterName.equalsIgnoreCase("pospolyy9")) {
            this.ypoly[8] = (int)Double.parseDouble(sValue);
            return true;
        }
        if (sParameterName.equalsIgnoreCase("pospolyx10")) {
            this.xpoly[9] = (int)Double.parseDouble(sValue);
            return true;
        }
        if (sParameterName.equalsIgnoreCase("pospolyy10")) {
            this.ypoly[9] = (int)Double.parseDouble(sValue);
            return true;
        }
        if (sParameterName.equalsIgnoreCase("pospolyx11")) {
            this.xpoly[10] = (int)Double.parseDouble(sValue);
            return true;
        }
        if (sParameterName.equalsIgnoreCase("pospolyy11")) {
            this.ypoly[10] = (int)Double.parseDouble(sValue);
            return true;
        }
        if (sParameterName.equalsIgnoreCase("pospolyx12")) {
            this.xpoly[11] = (int)Double.parseDouble(sValue);
            return true;
        }
        if (sParameterName.equalsIgnoreCase("pospolyy12")) {
            this.ypoly[11] = (int)Double.parseDouble(sValue);
            return true;
        }
        if (sParameterName.equalsIgnoreCase("pospolyx13")) {
            this.xpoly[12] = (int)Double.parseDouble(sValue);
            return true;
        }
        if (sParameterName.equalsIgnoreCase("pospolyy13")) {
            this.ypoly[12] = (int)Double.parseDouble(sValue);
            return true;
        }
        if (sParameterName.equalsIgnoreCase("pospolyx14")) {
            this.xpoly[13] = (int)Double.parseDouble(sValue);
            return true;
        }
        if (sParameterName.equalsIgnoreCase("pospolyy14")) {
            this.ypoly[13] = (int)Double.parseDouble(sValue);
            return true;
        }
        if (sParameterName.equalsIgnoreCase("pospolyx15")) {
            this.xpoly[14] = (int)Double.parseDouble(sValue);
            return true;
        }
        if (sParameterName.equalsIgnoreCase("pospolyy15")) {
            this.ypoly[14] = (int)Double.parseDouble(sValue);
            return true;
        }
        ParameterData pDataOld = (ParameterData)this.mData.get(sParameterName);
        if (pDataOld != null) {
            pDataOld.setValue(sValue);
        } else {
            this.mData.put(sParameterName, pData);
        }
        return true;
    }
}

