/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import de.core.DataSet;
import de.core.Lee_pcpcnfli;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;

public class Lee_plpdata {
    public ArrayList<Double> Generation = new ArrayList();
    public ArrayList<Double> Flows = new ArrayList();
    public ArrayList<Double> MarginalCost = new ArrayList();
    public ArrayList<Double> LoadDemand = new ArrayList();
    public ArrayList<Double> LineResistance = new ArrayList();
    public ArrayList<Double> LineReactance = new ArrayList();
    public ArrayList<Double> LineLimits = new ArrayList();
    public ArrayList<String> GeneratorNames = new ArrayList();
    public ArrayList<String> LineNames = new ArrayList();
    public ArrayList<String> BusbarNames = new ArrayList();
    public ArrayList<String> BusbarIds = new ArrayList();
    public ArrayList<String> LineBusbarFrom = new ArrayList();
    public ArrayList<String> LineBusbarTo = new ArrayList();
    private static final boolean USE_NEWCSVREADER = false;

    public static String getPLPCenCsvFileName() {
        return File.separator + "plpcen.csv";
    }

    public static String getPLPLinCsvFileName() {
        return File.separator + "plplin.csv";
    }

    public static String getPLPCnlinCsvFileName() {
        return File.separator + "plpcnfli.dat";
    }

    public static String getPLPBarCsvFileName() {
        return File.separator + "plpbar.csv";
    }

    public static String getPLPSerCsvFileName() {
        return File.separator + "plpser.csv";
    }

    public void ReadGenPLP(String strCsvFileName, int stage, int sim) {
        ArrayList[] TempValues = new ArrayList[2];
        int[] returnColumns = new int[]{5, 10};
        String[] FilterNames = new String[]{"Etapa", "Hidro"};
        String[] Filters = new String[]{String.valueOf(stage), String.valueOf("Sim" + sim)};
        this.GetValuesNames(strCsvFileName + Lee_plpdata.getPLPCenCsvFileName(), returnColumns, FilterNames, Filters, TempValues);
        this.GeneratorNames = TempValues[0];
        for (String s : TempValues[1]) {
            this.Generation.add(Double.parseDouble(s));
        }
    }

    public void ReadFlowPLP(String strCsvFileName, int stage, int sim) {
        ArrayList[] TempValues = new ArrayList[2];
        int[] returnColumns = new int[]{5, 8};
        String[] FilterNames = new String[]{"Etapa", "Hidro"};
        String[] Filters = new String[]{String.valueOf(stage), String.valueOf("Sim" + sim)};
        this.GetValuesNames(strCsvFileName + Lee_plpdata.getPLPLinCsvFileName(), returnColumns, FilterNames, Filters, TempValues);
        this.LineNames = TempValues[0];
        for (String s : TempValues[1]) {
            this.Flows.add(Double.parseDouble(s));
        }
    }

    public void ReadLineDataPLP(String strCsvFileName, int stage, int sim) {
        assert (this.LineNames != null) : "You need to call ReadFlowPLP() before calling this method!!";
        Lee_pcpcnfli dataplpcnfli = new Lee_pcpcnfli();
        dataplpcnfli.readdata(strCsvFileName + Lee_plpdata.getPLPCnlinCsvFileName());
        String[] TempLineNames = dataplpcnfli.nombre_linea;
        if (this.LineNames.size() != TempLineNames.length) {
            System.out.println("WARNING: No coinciden el numero de lineas en plplin.csv (" + this.LineNames.size() + ") con lineas en plpcnfli.dat (" + TempLineNames.length + ")");
        }
        Object[] zeros = new Double[this.LineNames.size()];
        Object[] blanks = new String[this.LineNames.size()];
        Arrays.fill(zeros, (Object)0.0);
        Arrays.fill(blanks, "");
        this.LineLimits = new ArrayList<Object>(Arrays.asList(zeros));
        this.LineResistance = new ArrayList<Object>(Arrays.asList(zeros));
        this.LineReactance = new ArrayList<Object>(Arrays.asList(zeros));
        this.LineBusbarFrom = new ArrayList<Object>(Arrays.asList(blanks));
        this.LineBusbarTo = new ArrayList<Object>(Arrays.asList(blanks));
        block0: for (int i = 0; i < this.LineNames.size(); ++i) {
            String tempLineList = this.LineNames.get(i).replaceAll(" ", "");
            for (int j = 0; j < TempLineNames.length; ++j) {
                String tempLineArray = TempLineNames[j].replaceAll(" ", "");
                if (!tempLineList.equals(tempLineArray)) continue;
                this.LineLimits.set(i, dataplpcnfli.LineLimits[j]);
                this.LineResistance.set(i, dataplpcnfli.Resistance[j]);
                this.LineReactance.set(i, dataplpcnfli.Reactance[j]);
                this.LineBusbarFrom.set(i, this.FindBusbarNameinCsv(dataplpcnfli.barraini_linea[j]));
                this.LineBusbarTo.set(i, this.FindBusbarNameinCsv(dataplpcnfli.barrafin_linea[j]));
                continue block0;
            }
        }
    }

    public void ReadCmgPLP(String strCsvFileName, int stage, int sim) {
        int[] returnColumns = new int[]{4, 5, 6, 7};
        String[] FilterNames = new String[]{"Etapa", "Hidro"};
        String[] Filters = new String[]{String.valueOf(stage), String.valueOf("Sim" + sim)};
        ArrayList[] TempValues = new ArrayList[4];
        this.GetValuesNames(strCsvFileName + Lee_plpdata.getPLPBarCsvFileName(), returnColumns, FilterNames, Filters, TempValues);
        this.BusbarIds = TempValues[0];
        this.BusbarNames = TempValues[1];
        for (String s : TempValues[2]) {
            this.MarginalCost.add(Double.parseDouble(s));
        }
        for (String s : TempValues[3]) {
            this.LoadDemand.add(Double.parseDouble(s));
        }
    }

    private static void readCsvFile3(String strCsvFileName, String[] ColValueReturn, String[] Filters, String[] FilterNames, ArrayList<String>[] Values2) {
    }

    private static void readCsvFile2(String strCsvFileName, String[] ColValueReturn, String[] Filters, String[] FilterNames, ArrayList<String>[] Values2) {
    }

    private static ArrayList readCsvFile(String strCsvFileName, int[] ColValueReturn, String[] FilterNames, String[] FilterValues2) throws FileNotFoundException, IOException {
        String line;
        File inputFile = new File(strCsvFileName);
        BufferedReader in = new BufferedReader(new FileReader(inputFile));
        int countLine = 0;
        ArrayList<DataSet> DataSets = new ArrayList<DataSet>();
        System.out.print("Leyendo " + inputFile.getName() + ". Por favor espere");
        int[] FilterColumn = new int[FilterValues2.length];
        long time = System.currentTimeMillis();
        while ((line = in.readLine()) != null) {
            line = line.replaceAll(" ", "");
            String[] opoint = line.split(",");
            if (countLine == 0) {
                String[] header = opoint;
                block1: for (int i = 0; i < FilterNames.length; ++i) {
                    for (int j = 0; j < header.length; ++j) {
                        if (!header[j].equals(FilterNames[i])) continue;
                        FilterColumn[i] = j;
                        continue block1;
                    }
                }
            } else {
                int nFilterFound = 0;
                for (int ncol = 0; ncol < FilterColumn.length; ++ncol) {
                    if (!opoint[FilterColumn[ncol]].equals(FilterValues2[ncol])) continue;
                    ++nFilterFound;
                }
                if (nFilterFound == FilterValues2.length) {
                    String[] strValueReturn = new String[ColValueReturn.length];
                    for (int i = 0; i < ColValueReturn.length; ++i) {
                        strValueReturn[i] = opoint[ColValueReturn[i] - 1];
                    }
                    DataSet ds = new DataSet(strValueReturn, FilterValues2);
                    DataSets.add(ds);
                }
            }
            if (countLine % 100000 == 0) {
                System.out.print(".");
            }
            ++countLine;
        }
        System.out.println("");
        System.out.println("Finished reading file '" + inputFile.getName() + "'. Total time : " + (System.currentTimeMillis() - time) / 1000L + "[sec]");
        return DataSets;
    }

    private void GetValuesNames(String strCsvFileName, int[] returnColumns, String[] FilterNames, String[] FilterValues2, ArrayList<String>[] Values2) {
        try {
            ArrayList mydatasets = Lee_plpdata.readCsvFile(strCsvFileName, returnColumns, FilterNames, FilterValues2);
            for (int i = 0; i < returnColumns.length; ++i) {
                Values2[i] = new ArrayList();
            }
            for (DataSet myds : mydatasets) {
                for (int i = 0; i < myds.values.length; ++i) {
                    Values2[i].add(myds.values[i]);
                }
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace(System.out);
        }
        catch (IOException e) {
            e.printStackTrace(System.out);
        }
        catch (NumberFormatException e) {
            e.printStackTrace(System.out);
        }
    }

    private String FindBusbarNameinCsv(int index) {
        assert (this.BusbarIds != null) : "You need to initialize first! Call ReadCmgPLP first";
        for (int i = 0; i < this.BusbarIds.size(); ++i) {
            if (!this.BusbarIds.get(i).equals(String.valueOf(index))) continue;
            return this.BusbarNames.get(i);
        }
        return null;
    }
}

