/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import de.core.DeepEdit;
import de.core.ProgressBar;
import de.core.ProgressLabel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Label;
import java.awt.Point;
import java.awt.Toolkit;
import javax.swing.JFrame;

public class LaunchProgressFrame
extends JFrame {
    private ProgressBar theProgressBar;
    public Label WindowLabel;
    private ProgressLabel PercentLabel;
    private String WindowString;
    private int textHeight;
    private int textWidth;
    private FontMetrics textFontMetrics;
    private Font textFont;
    FlowLayout WindowLayout;

    public LaunchProgressFrame(String FrameTitle, long TotalItems) {
        super(FrameTitle);
        this.setResizable(false);
        this.setBackground(Color.lightGray);
        this.addNotify();
        this.theProgressBar = new ProgressBar(TotalItems);
        this.WindowString = " " + FrameTitle + " ";
        this.textFont = DeepEdit.TextFont;
        this.WindowLabel = new Label(this.WindowString);
        this.WindowLabel.setFont(this.textFont);
        this.PercentLabel = new ProgressLabel(TotalItems);
        this.PercentLabel.setFont(this.textFont);
        this.textFontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(this.textFont);
        this.textHeight = this.textFontMetrics.getMaxAscent() + this.textFontMetrics.getMaxDecent();
        this.textWidth = this.textFontMetrics.stringWidth(this.WindowString);
        if (this.textWidth > 150) {
            this.resize((int)(1.15 * (double)this.textWidth), (int)(4.5 * (double)this.textHeight) + 35);
        } else {
            this.resize(172, (int)(4.5 * (double)this.textHeight) + 35);
        }
        this.getContentPane().setLayout(new FlowLayout());
        this.getContentPane().add(this.WindowLabel);
        this.getContentPane().add(this.theProgressBar);
        this.getContentPane().add(this.PercentLabel);
        Point p = DeepEdit.frame.getLocation();
        Dimension psize = DeepEdit.frame.getSize();
        this.getContentPane().setPreferredSize(new Dimension(200, 65));
        this.setLocationRelativeTo(DeepEdit.frame);
        this.setLocation(DeepEdit.frame.getSize().width / 2 - 100, 100);
        this.pack();
        this.setAlwaysOnTop(true);
    }

    public LaunchProgressFrame(String FrameTitle, long TotalItems, Color bCol, Dimension barDim) {
        super(FrameTitle);
        this.setResizable(false);
        this.setBackground(Color.lightGray);
        this.addNotify();
        this.theProgressBar = new ProgressBar(TotalItems, bCol, barDim);
        this.WindowString = " " + FrameTitle + " ";
        this.textFont = DeepEdit.TextFont;
        this.WindowLabel = new Label(this.WindowString, 1);
        this.WindowLabel.setFont(this.textFont);
        this.PercentLabel = new ProgressLabel(TotalItems);
        this.PercentLabel.setFont(this.textFont);
        this.textFontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(this.textFont);
        this.textHeight = this.textFontMetrics.getMaxAscent() + this.textFontMetrics.getMaxDecent();
        this.textWidth = this.textFontMetrics.stringWidth(this.WindowString);
        if (this.textWidth > 150) {
            this.resize((int)(1.15 * (double)this.textWidth), (int)(4.5 * (double)this.textHeight) + 35);
        } else {
            this.resize(172, (int)(4.5 * (double)this.textHeight) + 35);
        }
        this.getContentPane().setLayout(new FlowLayout());
        this.getContentPane().add(this.WindowLabel);
        this.getContentPane().add(this.theProgressBar);
        this.getContentPane().add(this.PercentLabel);
        this.setAlwaysOnTop(true);
    }

    public void setProgressLabel(String sWindowLabel) {
        this.WindowLabel.setText(sWindowLabel);
    }

    public void updateProgress() {
        this.theProgressBar.updateProgress();
        this.PercentLabel.updateProgress();
        this.repaint();
    }

    public void updateProgress(long increment) {
        this.theProgressBar.updateProgress(increment);
        this.PercentLabel.updateProgress(increment);
        this.repaint();
    }

    public void show(Point p, Dimension psize) {
        this.setLocation(p);
        this.getContentPane().setPreferredSize(psize);
        this.pack();
        this.setVisible(true);
    }
}

