/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import VisualNumerics.math.Complex;
import de.core.Busbar;
import de.core.DeepEdit;
import de.core.Generator;
import de.core.JavaShC;
import de.core.comp;
import de.core.ndb_branch;
import de.core.ndb_comp;
import de.utils.Utils;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

class JavaShCVisualFrame
extends Frame
implements KeyListener,
ActionListener {
    protected Font TextDialogFont;
    protected FontMetrics TextDialogFontMetrics;
    JavaShC MyJavaShC = null;
    Button button1;
    Button button2;
    Button button3;
    Checkbox partgen;
    double[] scalelog;
    comp TempComponent;

    public JavaShCVisualFrame(JavaShC ShC, String ctrla) {
        super("Java Three-Phase Balanced Fault");
        this.setBackground(Color.lightGray);
        this.MyJavaShC = ShC;
        this.TextDialogFont = DeepEdit.TextFont;
        this.TextDialogFontMetrics = this.getFontMetrics(this.TextDialogFont);
        this.setFont(this.TextDialogFont);
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        this.setLayout(gridbag);
        c.fill = 0;
        c.weightx = 1.0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.anchor = 10;
        c.gridwidth = 0;
        Utils.makeLabel((Frame)this, "BALANCED THREE-PHASE FAULT VISUALIZATION", gridbag, c, Color.blue);
        c.anchor = 17;
        c.gridwidth = 0;
        Utils.makeLabel((Frame)this, " Visualization of Fault Current Partipation", gridbag, c, Color.black);
        c.anchor = 17;
        c.gridwidth = 0;
        Utils.makeLabel((Frame)this, " Faulted Busbar:  " + this.MyJavaShC.BadBusbar.getName(), gridbag, c, Color.red);
        c.gridwidth = 3;
        c.gridx = -1;
        c.weightx = 0.0;
        c.anchor = 17;
        Utils.makeLabel(this, " Short Circuit Participations:       ", gridbag, c);
        this.button1 = new Button("Show");
        this.button1.setActionCommand("ShowG");
        this.button1.addActionListener(this);
        gridbag.setConstraints(this.button1, c);
        this.add(this.button1);
        c.gridwidth = 3;
        c.gridx = -1;
        c.weightx = 0.0;
        c.anchor = 17;
        c.gridwidth = 0;
        this.button3 = new Button("Exit");
        this.button3.setActionCommand("Exit");
        this.button3.addActionListener(this);
        gridbag.setConstraints(this.button3, c);
        this.add(this.button3);
        c.anchor = 13;
        c.weightx = 0.0;
        c.gridwidth = 0;
        this.partgen = new Checkbox(" Generators Only  ", false);
        this.add(this.partgen);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                JavaShCVisualFrame.this.restorecolor();
                JavaShCVisualFrame.this.setVisible(false);
                JavaShCVisualFrame.this.dispose();
                try {
                    JavaShCVisualFrame.this.MyJavaShC.MyColorSpec.setVisible(false);
                    JavaShCVisualFrame.this.MyJavaShC.MyColorSpec.dispose();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                JavaShCVisualFrame.this.MyJavaShC.MyJavaShCVisualFrame = null;
                DeepEdit.MySchematicPanel.repaint();
            }
        });
        this.setIconImage(this.MyJavaShC.deepEdApp.getFrameIconImage());
        this.pack();
        this.setResizable(false);
        this.setLocation(160, 0);
        this.setVisible(true);
    }

    @Override
    public void keyPressed(KeyEvent event) {
        if (event.getKeyCode() == 27) {
            this.setVisible(false);
            this.dispose();
            try {
                this.MyJavaShC.MyColorSpec.setVisible(false);
                this.MyJavaShC.MyColorSpec.dispose();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.MyJavaShC.MyJavaShCVisualFrame = null;
        }
    }

    @Override
    public void keyReleased(KeyEvent event) {
    }

    @Override
    public void keyTyped(KeyEvent event) {
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        Object obj = ev.getSource();
        String label = ev.getActionCommand();
        if (obj instanceof Button) {
            if (label.equals("Exit")) {
                this.restorecolor();
                this.setVisible(false);
                this.dispose();
                try {
                    this.MyJavaShC.MyColorSpec.setVisible(false);
                    this.MyJavaShC.MyColorSpec.dispose();
                }
                catch (Exception e) {
                    // empty catch block
                }
                this.MyJavaShC.MyJavaShCVisualFrame = null;
                DeepEdit.MySchematicPanel.repaint();
            } else if (label.equals("ShowG")) {
                this.visualG();
                DeepEdit.MySchematicPanel.repaint();
                this.repaint();
            } else if (label.equals("ShowL")) {
                DeepEdit.MySchematicPanel.repaint();
                this.repaint();
            }
        }
    }

    public void visualG() {
        Object BTempLine = null;
        Object Tempndb_branch = null;
        Generator TempGenerator = null;
        int countgen = 0;
        int countbranch = 0;
        double acum = 0.0;
        double anteil = 0.0;
        double Ifmax = Complex.abs((Complex)this.MyJavaShC.IFalla);
        for (int ix = 0; ix < this.MyJavaShC.ActSchematic.Components.size(); ++ix) {
            comp TempComponent = (comp)this.MyJavaShC.ActSchematic.Components.elementAt(ix);
            if (!TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice() || !(TempComponent instanceof ndb_comp)) continue;
            ndb_comp Tempndb = (ndb_comp)TempComponent;
            ndb_comp.CaptionColor = Color.gray;
            ndb_comp.TextColor1 = Color.gray;
            ndb_comp.TextColor2 = Color.gray;
            ndb_comp.TextColor3 = Color.gray;
            ndb_comp.Color1 = Color.darkGray;
            ndb_comp.Color2 = Color.darkGray;
            ndb_comp.Color3 = Color.darkGray;
            Tempndb.setAlternatekv_Color(Color.darkGray);
            Tempndb.lw = 1;
            if (TempComponent instanceof Busbar) {
                if (TempComponent.getName() != this.MyJavaShC.barra) continue;
                Tempndb.setAlternatekv_Color(Color.red);
                continue;
            }
            if (TempComponent instanceof Generator) {
                TempGenerator = (Generator)TempComponent;
                double Ifgen = Complex.abs((Complex)this.MyJavaShC.Ifgen[countgen]) / Ifmax;
                Tempndb.setAlternatekv_Color(this.getShortCircuitColor(Ifgen));
                ++countgen;
                continue;
            }
            if (TempComponent instanceof ndb_branch) {
                if (this.partgen.getState()) {
                    Tempndb.setAlternatekv_Color(Color.darkGray);
                    continue;
                }
                double Ifbranch = Complex.abs((Complex)this.MyJavaShC.Ifbranch[countbranch]) / Ifmax;
                Tempndb.setAlternatekv_Color(this.getShortCircuitColor(Ifbranch));
                Tempndb.lw = (int)(Ifbranch * 30.0);
                ++countbranch;
                continue;
            }
            Tempndb.setAlternatekv_Color(Color.darkGray);
        }
    }

    private void restorecolor() {
        DeepEdit.MySchematic.restoreColor();
    }

    private Color getShortCircuitColor(double f) {
        int ii = 0;
        double[] scalelog = new double[10];
        if (this.MyJavaShC.ifpromedio == 0.0) {
            for (ii = 0; ii < 10; ++ii) {
                scalelog[ii] = 0.0;
            }
        } else if (this.MyJavaShC.ifpromedio > 1.0) {
            double rr = 1.0;
        } else {
            double rr = this.MyJavaShC.ifpromedio;
            double A = Math.pow((1.0 - rr) / rr, 2.0) - 1.0;
            double C = 0.5 / (Math.log((1.0 - rr) / rr) / Math.log(10.0));
            scalelog = new double[10];
            for (ii = 0; ii < 10; ++ii) {
                double Y = ((double)ii + 1.0) / 10.0;
                scalelog[ii] = (Math.pow(10.0, Y / C) - 1.0) / A;
            }
        }
        Color acolor = f == 0.0 ? Color.black : (f > 0.0 && f < scalelog[0] ? new Color(0, 14, 190) : (f >= scalelog[0] && f < scalelog[1] ? new Color(0, 17, 236) : (f >= scalelog[1] && f < scalelog[2] ? new Color(57, 71, 255) : (f >= scalelog[2] && f < scalelog[3] ? new Color(125, 134, 255) : (f >= scalelog[3] && f < scalelog[4] ? new Color(195, 199, 255) : (f >= scalelog[4] && f < scalelog[5] ? new Color(195, 199, 255) : (f >= scalelog[5] && f < scalelog[6] ? new Color(255, 255, 255) : (f >= scalelog[6] && f < scalelog[7] ? new Color(255, 202, 201) : (f >= scalelog[7] && f < scalelog[8] ? new Color(254, 166, 164) : (f >= scalelog[8] && f < scalelog[9] ? new Color(254, 108, 104) : (f >= scalelog[9] && f < 1.0 ? new Color(253, 46, 41) : Color.red)))))))))));
        return acolor;
    }
}

