/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import de.core.Busbar;
import de.core.DeepEdit;
import de.core.JavaShC;
import de.core.Schematic;
import de.core.comp;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.UIManager;

class JavaShCFrame
implements KeyListener,
ActionListener,
ItemListener {
    private JavaShC MyJavaShC;
    private String ctrla;
    private String selectmaxmin;
    private String rzeta = "0.0";
    private String xzeta = "0.0";
    protected Font TextDialogFont;
    protected FontMetrics TextDialogFontMetrics;
    private JComboBox MyChoiceMethod;
    private JComboBox MyChoiceCtrla;
    private JComboBox MyChoicename;
    private JComboBox MyChoicetoler;
    private JComboBox MyChoiceAmethod;
    private JRadioButton[] option = new JRadioButton[2];
    private JButton buttonSB;
    private JCheckBox doFile;
    private JCheckBox usetransimp;
    private JCheckBox uselineshunt;
    private JCheckBox completereport;
    private JTextField MyTextField1a = null;
    private JTextField MyTextField1b = null;
    private JTextField cfactortext = null;
    private String methoda = "IEC909";
    private String methodb = "Complete";
    private String selectedmethod = new String("IEC909");
    private JPanel iecdata;
    private JPanel completedata;
    private JPanel ieccomplete;
    private JPanel control;
    private JDialog panel;

    JavaShCFrame(DeepEdit deepApplet, Schematic sch) {
        comp TempComponent;
        int ix;
        String lookAndFeel = UIManager.getSystemLookAndFeelClassName();
        try {
            UIManager.setLookAndFeel(lookAndFeel);
        }
        catch (Exception e) {
            // empty catch block
        }
        this.MyJavaShC = new JavaShC(deepApplet, sch);
        this.panel = new JDialog((Frame)DeepEdit.frame, false);
        this.panel.setTitle("Java Balanced Three-Phase Fault Study");
        this.ctrla = "ALL CONTROL AREAS";
        this.TextDialogFont = DeepEdit.TextFont;
        JPanel principal1 = new JPanel();
        principal1.setLayout(new BoxLayout(principal1, 3));
        JLabel titel1 = new JLabel("  GENERAL CALCULATION OPTIONS:  ");
        titel1.setForeground(Color.blue);
        titel1.setAlignmentX(0.5f);
        titel1.setBorder(BorderFactory.createEmptyBorder(10, 0, 10, 0));
        titel1.setFont(this.TextDialogFont);
        titel1.setVisible(true);
        principal1.add(titel1);
        JPanel metodo = new JPanel();
        JLabel methodL = new JLabel("Method: ", 2);
        methodL.setFont(this.TextDialogFont);
        metodo.add(methodL);
        String[] methods = new String[]{this.methoda, this.methodb};
        this.MyChoiceMethod = new JComboBox<String>(methods);
        this.MyChoiceMethod.setSelectedIndex(0);
        this.MyChoiceMethod.setFont(this.TextDialogFont);
        this.MyChoiceMethod.addItemListener(this);
        this.MyChoiceMethod.setMaximumSize(new Dimension(100, 20));
        metodo.add(this.MyChoiceMethod);
        principal1.add(metodo);
        JPanel ubica = new JPanel();
        ubica.setLayout(new GridLayout(0, 2));
        ubica.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
        ubica.setBorder(BorderFactory.createEmptyBorder(10, 30, 10, 30));
        JLabel ubicaL1 = new JLabel("Select Control Area:");
        ubicaL1.setFont(this.TextDialogFont);
        ubica.add(ubicaL1);
        String[] controlareas = new String[]{this.ctrla};
        this.MyChoiceCtrla = new JComboBox<String>(controlareas);
        this.MyChoiceCtrla.setFont(this.TextDialogFont);
        ubica.add(this.MyChoiceCtrla);
        JLabel ubicaL2 = new JLabel("Select Busbar:    ");
        ubicaL2.setFont(this.TextDialogFont);
        ubica.add(ubicaL2);
        int countN = 0;
        for (ix = 0; ix < this.MyJavaShC.ActSchematic.Components.size(); ++ix) {
            TempComponent = (comp)this.MyJavaShC.ActSchematic.Components.elementAt(ix);
            if (!TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice() || !(TempComponent instanceof Busbar)) continue;
            ++countN;
        }
        String[] busbararea = new String[countN];
        countN = 0;
        for (ix = 0; ix < this.MyJavaShC.ActSchematic.Components.size(); ++ix) {
            TempComponent = (comp)this.MyJavaShC.ActSchematic.Components.elementAt(ix);
            if (!TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice() || !(TempComponent instanceof Busbar)) continue;
            TempComponent.InformAllComponents();
            busbararea[countN] = TempComponent.getName();
            ++countN;
        }
        this.MyChoicename = new JComboBox<String>(busbararea);
        this.MyChoicename.setFont(this.TextDialogFont);
        ubica.add(this.MyChoicename);
        ubica.add(new JLabel(" ", 2));
        this.buttonSB = new JButton("SelectedBusbar");
        this.buttonSB.addActionListener(this);
        this.buttonSB.setFont(this.TextDialogFont);
        ubica.add(this.buttonSB);
        this.doFile = new JCheckBox("Output File", false);
        this.doFile.setFont(this.TextDialogFont);
        this.doFile.addItemListener(this);
        ubica.add(this.doFile);
        this.completereport = new JCheckBox("all elements?", true);
        this.completereport.setFont(this.TextDialogFont);
        this.completereport.setEnabled(false);
        ubica.add(this.completereport);
        principal1.add(ubica);
        JPanel impedances = new JPanel();
        impedances.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
        impedances.setLayout(new GridLayout(0, 2));
        impedances.setBorder(BorderFactory.createEmptyBorder(10, 30, 10, 30));
        JLabel impedancesL1 = new JLabel("   Set Impedance    R   = ");
        impedancesL1.setFont(this.TextDialogFont);
        impedances.add(impedancesL1);
        this.MyTextField1a = new JTextField("0.0", 5);
        this.MyTextField1a.setFont(this.TextDialogFont);
        impedances.add(this.MyTextField1a);
        JLabel impedancesL2 = new JLabel("   Set Impedance    X   = ");
        impedancesL2.setFont(this.TextDialogFont);
        impedances.add(impedancesL2);
        this.MyTextField1b = new JTextField("0.0", 5);
        this.MyTextField1b.setFont(this.TextDialogFont);
        impedances.add(this.MyTextField1b);
        principal1.add(impedances);
        this.control = new JPanel();
        this.control.setLayout(new FlowLayout());
        JButton button1 = new JButton("    Calculate    ");
        button1.setFont(this.TextDialogFont);
        this.control.add(button1);
        button1.setActionCommand("Apply");
        button1.addActionListener(this);
        JButton button2 = new JButton("     Cancel     ");
        button2.setFont(this.TextDialogFont);
        this.control.add(button2);
        button2.setActionCommand("Cancel");
        button2.addActionListener(this);
        principal1.add(this.control);
        JPanel principal2 = new JPanel();
        principal2.setLayout(new BoxLayout(principal2, 3));
        principal2.setAlignmentX(0.0f);
        JLabel titel2 = new JLabel("  ADVANCED OPTIONS:  ");
        titel2.setForeground(Color.blue);
        titel2.setAlignmentX(0.5f);
        titel2.setBorder(BorderFactory.createEmptyBorder(10, 0, 10, 0));
        titel2.setFont(this.TextDialogFont);
        principal2.add(titel2);
        this.iecdata = new JPanel();
        this.iecdata.setLayout(new BoxLayout(this.iecdata, 3));
        this.iecdata.setMaximumSize(new Dimension(250, 50));
        this.iecdata.setMinimumSize(new Dimension(250, 50));
        this.iecdata.setPreferredSize(new Dimension(250, 50));
        JPanel maxminopt = new JPanel();
        maxminopt.setLayout(new BoxLayout(maxminopt, 0));
        this.option[0] = new JRadioButton("Maximum", true);
        this.option[1] = new JRadioButton("Minimum");
        this.option[0].setFont(this.TextDialogFont);
        this.option[1].setFont(this.TextDialogFont);
        ButtonGroup maxmin = new ButtonGroup();
        maxmin.add(this.option[0]);
        maxmin.add(this.option[1]);
        maxminopt.add(this.option[0]);
        maxminopt.add(this.option[1]);
        this.iecdata.add(maxminopt);
        this.iecdata.add(Box.createRigidArea(new Dimension(0, 10)));
        JPanel tolerpanel = new JPanel();
        tolerpanel.setLayout(new BoxLayout(tolerpanel, 0));
        JLabel tol = new JLabel("Tolerance: ", 2);
        tol.setAlignmentX(0.0f);
        tol.setFont(this.TextDialogFont);
        tolerpanel.add(tol);
        String[] tolerancetext = new String[]{"+/- 6%", "+/- 10%"};
        this.MyChoicetoler = new JComboBox<String>(tolerancetext);
        this.MyChoicetoler.setSelectedIndex(0);
        this.MyChoicetoler.setMaximumSize(new Dimension(80, 20));
        this.MyChoicetoler.setFont(this.TextDialogFont);
        tolerpanel.add(this.MyChoicetoler);
        this.iecdata.add(tolerpanel);
        this.completedata = new JPanel();
        this.completedata.setLayout(new BoxLayout(this.completedata, 3));
        this.completedata.setMaximumSize(new Dimension(250, 50));
        this.completedata.setMinimumSize(new Dimension(250, 50));
        this.completedata.setPreferredSize(new Dimension(250, 50));
        JPanel factorpane = new JPanel();
        factorpane.setLayout(new BoxLayout(factorpane, 0));
        JLabel factorpaneL = new JLabel("Voltage Factor c: ");
        factorpaneL.setFont(this.TextDialogFont);
        factorpane.add(factorpaneL);
        this.cfactortext = new JTextField("1.0", 2);
        this.cfactortext.setFont(this.TextDialogFont);
        factorpane.add(this.cfactortext);
        factorpane.add(Box.createHorizontalGlue());
        factorpane.setMaximumSize(new Dimension(150, 15));
        JPanel usetrans = new JPanel();
        usetrans.setLayout(new BoxLayout(usetrans, 3));
        this.usetransimp = new JCheckBox("Transient Impedances", false);
        this.usetransimp.setFont(this.TextDialogFont);
        this.usetransimp.setEnabled(false);
        usetrans.add(this.usetransimp);
        JPanel useline = new JPanel();
        useline.setLayout(new BoxLayout(useline, 3));
        this.uselineshunt = new JCheckBox("Include Line Suceptances", false);
        this.uselineshunt.setFont(this.TextDialogFont);
        this.uselineshunt.setEnabled(true);
        useline.add(this.uselineshunt);
        this.completedata.add(factorpane);
        this.completedata.add(this.usetransimp);
        this.completedata.add(useline);
        this.ieccomplete = new JPanel(new CardLayout());
        this.ieccomplete.setMaximumSize(new Dimension(250, 100));
        this.ieccomplete.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), this.selectedmethod, 1, 2, this.TextDialogFont, Color.darkGray), BorderFactory.createEmptyBorder(5, 5, 5, 20)));
        this.ieccomplete.add((Component)this.iecdata, this.methoda);
        this.ieccomplete.add((Component)this.completedata, this.methodb);
        principal2.add(this.ieccomplete);
        principal2.add(Box.createRigidArea(new Dimension(0, 10)));
        JPanel asimetpanel = new JPanel();
        asimetpanel.setLayout(new BoxLayout(asimetpanel, 2));
        asimetpanel.setMaximumSize(new Dimension(250, 100));
        asimetpanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "R/X Method", 1, 2, this.TextDialogFont, Color.darkGray), BorderFactory.createEmptyBorder(10, 5, 10, 5)));
        JLabel asimetpanelL = new JLabel("Peak Current R/X Method: ", 2);
        asimetpanelL.setFont(this.TextDialogFont);
        asimetpanel.add(asimetpanelL);
        String[] Amethods = new String[]{"C", "B"};
        this.MyChoiceAmethod = new JComboBox<String>(Amethods);
        this.MyChoiceAmethod.setSelectedIndex(0);
        this.MyChoiceAmethod.setMaximumSize(new Dimension(50, 20));
        this.MyChoiceAmethod.setFont(this.TextDialogFont);
        asimetpanel.add(this.MyChoiceAmethod);
        principal2.add(asimetpanel);
        JTabbedPane opciontabs = new JTabbedPane();
        opciontabs.addTab("General", principal1);
        opciontabs.addTab("Advanced", principal2);
        opciontabs.setFont(this.TextDialogFont);
        opciontabs.setSelectedIndex(0);
        this.panel.getContentPane().add(opciontabs);
        this.panel.pack();
        this.panel.setVisible(true);
        this.panel.setLocation(200, 50);
        this.panel.setIconImage(deepApplet.getFrameIconImage());
        this.panel.setResizable(false);
        this.panel.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                JavaShCFrame.this.panel.setVisible(false);
                DeepEdit cfr_ignored_0 = ((JavaShCFrame)JavaShCFrame.this).MyJavaShC.deepEdApp;
                DeepEdit.frame.setEnabled(true);
                JavaShCFrame.this.panel.dispose();
                DeepEdit cfr_ignored_1 = ((JavaShCFrame)JavaShCFrame.this).MyJavaShC.deepEdApp;
                DeepEdit.frame.setVisible(true);
            }
        });
    }

    public void paint(Graphics g) {
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        ItemSelectable source = e.getItemSelectable();
        if (source == this.MyChoiceMethod) {
            CardLayout cl = (CardLayout)this.ieccomplete.getLayout();
            String selectedmethod = (String)e.getItem();
            cl.show(this.ieccomplete, selectedmethod);
            this.ieccomplete.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), selectedmethod, 1, 2, this.TextDialogFont, Color.darkGray), BorderFactory.createEmptyBorder(5, 5, 5, 20)));
            if (selectedmethod.equals("IEC909")) {
                this.option[0].setVisible(true);
                this.option[1].setVisible(true);
            } else {
                this.option[0].setVisible(false);
                this.option[1].setVisible(false);
            }
        } else if (source == this.doFile) {
            if (e.getStateChange() == 1) {
                this.completereport.setEnabled(true);
            } else {
                this.completereport.setEnabled(false);
            }
        }
    }

    @Override
    public void keyPressed(KeyEvent event) {
        if (event.getKeyCode() == 27) {
            this.panel.setVisible(false);
            DeepEdit cfr_ignored_0 = this.MyJavaShC.deepEdApp;
            DeepEdit.frame.setEnabled(true);
            DeepEdit cfr_ignored_1 = this.MyJavaShC.deepEdApp;
            DeepEdit.frame.setVisible(true);
            this.panel.dispose();
        }
    }

    @Override
    public void keyReleased(KeyEvent event) {
    }

    @Override
    public void keyTyped(KeyEvent event) {
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        Object obj = ev.getSource();
        String label = ev.getActionCommand();
        boolean noneselected = true;
        if (obj instanceof JButton && label.equals("SelectedBusbar")) {
            for (int ix = 0; ix < this.MyJavaShC.ActSchematic.Components.size(); ++ix) {
                comp TempComponent = (comp)this.MyJavaShC.ActSchematic.Components.elementAt(ix);
                if (!TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice() || !(TempComponent instanceof Busbar) || !TempComponent.isSelected()) continue;
                noneselected = false;
                this.MyChoicename.setSelectedItem(TempComponent.getName());
                return;
            }
            if (noneselected) {
                if (this.MyChoicename.getSelectedIndex() != -1) {
                    this.MyChoicename.setSelectedIndex(0);
                }
                JLabel message = new JLabel("No Busbar Selected!  Please select a Busbar from Schematic");
                message.setFont(this.TextDialogFont);
                JOptionPane.showMessageDialog(this.panel, message, "Java Error ", 0);
                return;
            }
        }
        if (obj instanceof JTextField || obj instanceof JButton) {
            if (label.equals("Apply") || obj instanceof JTextField) {
                this.control.removeAll();
                JLabel frasefinal = new JLabel(" ... Short Circuit Calculation ...", 0);
                frasefinal.setForeground(Color.blue);
                this.control.add(frasefinal);
                this.panel.setVisible(true);
                this.panel.setVisible(false);
                try {
                    boolean outputtxt;
                    double aux1 = 0.0;
                    aux1 = this.MyTextField1a.equals("0.0") ? 0.0 : Double.valueOf(this.MyTextField1a.getText());
                    double aux2 = 0.0;
                    aux2 = this.MyTextField1b.equals("0.0") ? 0.0 : Double.valueOf(this.MyTextField1b.getText());
                    double cfactor = Double.valueOf(this.cfactortext.getText());
                    boolean transimp = this.usetransimp.getSelectedObjects() != null;
                    boolean lineimp = this.uselineshunt.isSelected();
                    this.selectmaxmin = this.option[0].getSelectedObjects() != null ? "Maximum" : "Minimum";
                    boolean completeout = false;
                    if (this.doFile.isSelected()) {
                        outputtxt = true;
                        completeout = this.completereport.isSelected();
                    } else {
                        outputtxt = false;
                    }
                    this.ctrla = (String)this.MyChoiceCtrla.getSelectedItem();
                    this.MyJavaShC.setParameters((String)this.MyChoiceMethod.getSelectedItem(), (String)this.MyChoicename.getSelectedItem(), outputtxt, aux1, aux2, this.selectmaxmin, (String)this.MyChoicetoler.getSelectedItem(), cfactor, transimp, (String)this.MyChoiceAmethod.getSelectedItem(), lineimp, completeout, this.ctrla);
                    Thread ShCThread = new Thread((Runnable)this.MyJavaShC, "Thread-Calculate");
                    ShCThread.start();
                    this.panel.dispose();
                }
                catch (Exception e) {
                    JLabel lblMessage = new JLabel(e.getMessage());
                    lblMessage.setFont(DeepEdit.TextFont);
                    JOptionPane.showMessageDialog(DeepEdit.frame, lblMessage, "Short circuit validation error", 0);
                    System.out.println(e.getMessage());
                    System.out.println(e.getStackTrace());
                }
            }
            if (label.equals("Cancel")) {
                this.panel.dispose();
            }
        }
    }
}

