/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import VisualNumerics.math.Complex;
import de.core.AnalysisTool;
import de.core.Busbar;
import de.core.DeepEdit;
import de.core.Generator;
import de.core.JavaShCException;
import de.core.JavaShCFrame;
import de.core.JavaShCVisualFrame;
import de.core.Line;
import de.core.Load;
import de.core.Schematic;
import de.core.ShCColorSpec;
import de.core.ThreeWindingTrafo;
import de.core.Trafo;
import de.core.comp;
import de.core.ndb_branch;
import de.core.ndb_comp;
import de.core.ndb_inj;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JOptionPane;

public final class JavaShC
extends AnalysisTool
implements Runnable {
    JavaShCFrame MyJavaShCFrame = null;
    JavaShCVisualFrame MyJavaShCVisualFrame = null;
    ShCColorSpec MyColorSpec = null;
    Complex[][] MatZaux;
    double[] BranchR;
    double[] BranchX;
    double[] BranchB;
    int[] BranchI;
    int[] BranchJ;
    double[] VBus;
    double[] ABus;
    double[] BranchXd;
    protected Vector BusbarVectorI;
    private JavaShC MyJavaShC;
    protected DeepEdit deepEdApp;
    String ctrla = null;
    String barra = null;
    boolean rep = false;
    double rzeta = 0.0;
    double xzeta = 0.0;
    boolean sigue = true;
    String[] NomNod;
    int numbra = 0;
    int ngcero = 0;
    boolean[] BusGen;
    int[] NumBusGen;
    Busbar BadBusbar = null;
    static final int TIERRA_ENUM = -1;
    int numref = -1;
    int[] ZDataC1;
    int[] ZDataC2;
    double[] ZDataC3;
    double[] ZDataC4;
    int[] IdNod;
    Complex IFalla;
    PrintStream myPPrintStream;
    int numbraf = 0;
    int numgenf = 0;
    String method;
    String[] Nombranch;
    String[] Nomgen;
    String maxmin;
    double[] ZDataC5;
    Complex[] Ifbranchf;
    Complex[] Ifgenf;
    Complex[] Ifbranch;
    Complex[] Ifgen;
    Complex[] Vpre;
    Complex[] Vpost;
    Complex[] Eint;
    Complex[] Sconj;
    double Sk;
    double Ifpick = 0.0;
    double factork = 0.0;
    double[] RLoad;
    double[] XLoad;
    int[] NumBusLoad;
    String[] NomGen;
    String[] NomBranch;
    String[] NomGenf;
    String[] NomBranchf;
    String tolerance;
    boolean transimp = false;
    boolean compout = false;
    String rxMethod;
    double cfactor;
    int[] TipoBranch;
    int numbusgen = 0;
    int numshunt = 0;
    boolean[] BusShunt;
    boolean[] BusLoad;
    boolean uselineshunt;
    double ifpromedio;
    double[] scalelog;
    private double sref = 100.0;

    public JavaShC(DeepEdit deepApplet, Schematic sch) {
        super(sch, DeepEdit.frame);
        this.deepEdApp = deepApplet;
        this.sref = this.getSref();
        System.out.println("---------- 3 Phase Short Circuit Calculation Started ------------");
    }

    public void Calculate() throws JavaShCException, IOException {
        long inicio = System.currentTimeMillis();
        System.out.println(" Java Short Circuit Calculation ....");
        System.out.println(" -");
        System.out.println(" -");
        System.out.println(" Verification for errors        ....");
        this.Verifica();
        System.out.println(" Verification done");
        System.out.println(" -");
        boolean once = false;
        while (!once) {
            System.out.println(" Getting network parameters ....");
            this.InitNetwork();
            System.out.println(" InitNetwork done");
            System.out.println(" -");
            System.out.println(" Making Zdata               ....");
            this.BuildZData();
            System.out.println(" BuildZData done");
            System.out.println(" -");
            System.out.println(" Making Z                   ....");
            this.BuildZMatrix();
            System.out.println(" BuildZMatrix done");
            System.out.println(" -");
            System.out.println(" Fault Current Calculation  ....");
            this.CalculaIFault(this.BadBusbar);
            System.out.println(" CalculaIFalla done");
            System.out.println(" -");
            once = true;
        }
        System.out.println("\nExec Time= " + (System.currentTimeMillis() - inicio) + "ms.");
        String strOutFile = AnalysisTool.RESULT_FOLDER + File.separator + "JavaShCInfo.dat";
        JavaShC.CreateDirectory(AnalysisTool.RESULT_FOLDER);
        FileOutputStream os = new FileOutputStream(strOutFile);
        this.myPPrintStream = new PrintStream(os);
        if (this.rep) {
            int i;
            String methodprint;
            System.out.println("inicio de impresiones");
            this.myPPrintStream.println(" ");
            this.myPPrintStream.println("  ----------------------------------------------------------------------------");
            this.myPPrintStream.println(" |                     Balanced Three-Phase Short Circuit Results             |");
            this.myPPrintStream.println(" |----------------------------------------------------------------------------|");
            if (this.method == "IEC909" && this.maxmin == "Maximum") {
                methodprint = "IEC 60909-0    2001  |   Maximun Level                          |";
            } else if (this.method == "IEC909" && this.maxmin == "Minimum") {
                methodprint = "IEC 60909-0    2001  |   Minimun Level                          |";
            } else {
                String cfactorprint = this.Formato(this.cfactor);
                methodprint = "Complete             |   Tension Factor c: " + cfactorprint + "            |";
            }
            this.myPPrintStream.println(" |   Method:  " + methodprint);
            this.myPPrintStream.println(" |----------------------------------------------------------------------------|");
            this.myPPrintStream.println(" |     Name               Voltage          Sk''          Ik''          Ip     |");
            this.myPPrintStream.println(" |                          [pu]           [pu]          [pu]         [pu]    |");
            this.myPPrintStream.println(" |----------------------------------------------------------------------------|");
            String nameprint = this.FormatoString(this.barra);
            String Vfprint = this.Formato(Complex.abs((Complex)this.Vpost[this.numref]));
            this.Sk = Math.sqrt(3.0) * Complex.abs((Complex)this.Vpre[this.numref]) * Complex.abs((Complex)this.IFalla);
            String Skprint = this.Formato(this.Sk);
            String IFprint = this.Formato(Complex.abs((Complex)this.IFalla));
            String Ipprint = this.Formato(this.Ifpick);
            this.myPPrintStream.println(" |     " + nameprint + "    " + Vfprint + "     " + Skprint + "     " + IFprint + "     " + Ipprint + " |");
            if (this.numbraf > 0) {
                this.myPPrintStream.println(" |                                                                            |");
                this.myPPrintStream.println(" | Adjacent Line Contributions:                                               |");
                for (i = 0; i < this.numbraf; ++i) {
                    nameprint = this.FormatoString(this.NomBranchf[i]);
                    IFprint = this.Formato(Complex.abs((Complex)this.Ifbranchf[i]));
                    Ipprint = this.Formato(Complex.abs((Complex)this.Ifbranchf[i]) * this.factork * Math.sqrt(2.0));
                    this.myPPrintStream.println(" |     " + nameprint + "                                " + IFprint + "     " + Ipprint + " |");
                }
            }
            if (this.numgenf > 0) {
                this.myPPrintStream.println(" |                                                                            |");
                this.myPPrintStream.println(" | Adjacent Machine Contributions:                                            |");
                for (i = 0; i < this.numgenf; ++i) {
                    nameprint = this.FormatoString(this.NomGenf[i]);
                    IFprint = this.Formato(Complex.abs((Complex)this.Ifgenf[i]));
                    Ipprint = this.Formato(Complex.abs((Complex)this.Ifgenf[i]) * this.factork * Math.sqrt(2.0));
                    this.myPPrintStream.println(" |     " + nameprint + "                                " + IFprint + "     " + Ipprint + " |");
                }
            }
            if (this.compout) {
                this.myPPrintStream.println(" |                                                                            |");
                this.myPPrintStream.println(" | Complete Line Contributions:                                               |");
                for (i = 0; i < this.numbra; ++i) {
                    nameprint = this.FormatoString(this.NomBranch[i]);
                    IFprint = this.Formato(Complex.abs((Complex)this.Ifbranch[i]));
                    Ipprint = this.Formato(Complex.abs((Complex)this.Ifbranch[i]) * this.factork * Math.sqrt(2.0));
                    this.myPPrintStream.println(" |     " + nameprint + "                                " + IFprint + "     " + Ipprint + " |");
                }
                this.myPPrintStream.println(" |                                                                            |");
                this.myPPrintStream.println(" | Complete Machine Contributions:                                            |");
                for (i = 0; i < this.numgen; ++i) {
                    nameprint = this.FormatoString(this.NomGen[i]);
                    IFprint = this.Formato(Complex.abs((Complex)this.Ifgen[i]));
                    Ipprint = this.Formato(Complex.abs((Complex)this.Ifgen[i]) * this.factork * Math.sqrt(2.0));
                    this.myPPrintStream.println(" |     " + nameprint + "                                " + IFprint + "     " + Ipprint + " |");
                }
            }
            this.myPPrintStream.println("  ---------------------------------------------------------------------------- ");
            this.myPPrintStream.println(" ");
            os.close();
        }
        try {
            this.myPPrintStream.close();
            if (os != null) {
                os.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (this.MyJavaShCVisualFrame == null) {
            this.MyJavaShCVisualFrame = new JavaShCVisualFrame(this, this.ctrla);
        } else {
            this.MyJavaShCVisualFrame.setVisible(true);
            this.MyJavaShCVisualFrame.toFront();
        }
        this.ifpromedio /= Complex.abs((Complex)this.IFalla);
        if (this.MyColorSpec == null) {
            this.MyColorSpec = new ShCColorSpec(this.ifpromedio, "Color for Java Short Circuit");
        } else {
            this.MyColorSpec.setVisible(true);
            this.MyColorSpec.toFront();
        }
        if (this.rep) {
            try {
                this.DoListResults("./results/JavaShCInfo.dat");
            }
            catch (Exception e) {
                System.out.println(e + ": error al abrir ZFileViewer");
            }
        }
    }

    public void Verifica() throws JavaShCException {
        int numBusbar = 0;
        for (int ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
            ndb_comp TempNdb_comp;
            comp TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
            if (TempComponent instanceof Busbar) {
                Busbar TempBusbar = (Busbar)TempComponent;
                if (TempComponent.getName().equals(this.barra)) {
                    if (!TempBusbar.getactive()) {
                        throw new JavaShCException("Selected Busbar selected is not active");
                    }
                    if (!TempBusbar.getvalid()) {
                        throw new JavaShCException("Selected Busbar selected is not valid");
                    }
                    if (!TempBusbar.getinservice()) {
                        throw new JavaShCException("Selected Busbar selected is in service");
                    }
                    if (!TempBusbar.getctrla().equals(this.ctrla) && !this.ctrla.equals("ALL CONTROL AREAS")) {
                        throw new JavaShCException("Selected Busbar selected is not in supported Control Area");
                    }
                }
                ++numBusbar;
                continue;
            }
            if (!(TempComponent instanceof ndb_comp) || !(TempNdb_comp = (ndb_comp)TempComponent).getctrla().equals(this.ctrla) && !this.ctrla.equals("ALL CONTROL AREAS") || !(TempComponent instanceof Generator) || !TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice()) continue;
            Generator TempGenerator = (Generator)TempComponent;
            if (TempGenerator.getxd1() == 0.0) {
                throw new JavaShCException(" Invalid Input data: xd1 = 0.0 in Generator " + TempGenerator.getName() + ". Adjust to any other value");
            }
            if (TempGenerator.getsn() != 0.0) continue;
            throw new JavaShCException(" Invalid Input data: Own-Power Base (Sn) = 0.0 in Generator " + TempGenerator.getName() + ". Adjust to any other value");
        }
        if (numBusbar < 2) {
            throw new JavaShCException("Not valid System or control area has less than 2 bars");
        }
        if (DeepEdit.MySchematic.Modifiedstate && this.method.equals("Complete")) {
            throw new JavaShCException("No valid Load Flow data found!  Please run simulation tool first");
        }
        if (this.method.equals("Complete")) {
            if (DeepEdit.MySchematic.gettypsim() != 0) {
                if (DeepEdit.MySchematic.gettypsim() != 11 && this.sigue) {
                    throw new JavaShCException("\"WARNING! AC Load Flow recommended! Innacurated results expected");
                }
            }
        }
    }

    public void InitNetwork() throws JavaShCException {
        Complex segundiag;
        Complex Zrama23;
        Complex invertapnodiag;
        Complex Afinal;
        Complex factor;
        Complex auxc3;
        comp TempComponent = null;
        ndb_comp TempNdb_comp = null;
        Busbar TempBusbar = null;
        ndb_branch TempBran = null;
        Line TempLine = null;
        Trafo TempTrafo = null;
        Generator TempGenerator = null;
        ndb_inj TempNdb_inj = null;
        Load TempLoad = null;
        int i = 0;
        boolean j = false;
        int countBus = 0;
        int countBra = 0;
        int countLin = 0;
        int countTra = 0;
        int count3Tra = 0;
        int countGen = 0;
        int countLoad = 0;
        int con1 = -1;
        int con2 = -1;
        int con3 = -1;
        this.BusbarVectorI = new Vector();
        double ueb = 0.0;
        double res = 0.0;
        double z = 0.0;
        double reac = 0.0;
        double b = 0.0;
        int countbusgen = 0;
        double reVBus = 0.0;
        double imVBus = 0.0;
        double[] react = new double[3];
        double[] resistencias = new double[3];
        Complex[] ZthreeWinding = new Complex[3];
        Complex[] Zreales = new Complex[3];
        int c = 0;
        boolean parestrafo = false;
        int fintrafo = 0;
        double Zk12 = 0.0;
        double Zk13 = 0.0;
        double Zk23 = 0.0;
        double tap1 = 1.0;
        double tap2 = 1.0;
        double tap3 = 1.0;
        double potapa1 = 0.0;
        double potapa2 = 0.0;
        double potapa3 = 0.0;
        Complex auxc2 = auxc3 = new Complex(0.0, 0.0);
        Complex auxc1 = auxc3;
        Complex factory = factor = new Complex(0.0, 0.0);
        Complex invertA3 = Afinal = new Complex(0.0, 0.0);
        Complex A3 = Afinal;
        Complex A2 = Afinal;
        Complex A1 = Afinal;
        Complex ramaY3 = Afinal;
        Complex ramaY2 = Afinal;
        Complex ramaY1 = Afinal;
        Complex ramaY = Afinal;
        Complex neutro = new Complex(1.0, 0.0);
        Complex invertapdiag2 = invertapnodiag = new Complex(0.0, 0.0);
        Complex invertapdiag1 = invertapnodiag;
        Complex Zrama13 = Zrama23 = new Complex(0.0, 0.0);
        Complex Zrama12 = Zrama23;
        Complex primerdiag = segundiag = new Complex(0.0, 0.0);
        int countshunt = 0;
        for (int ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
            TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
            if (!(TempComponent instanceof ndb_comp) || !(TempNdb_comp = (ndb_comp)TempComponent).getctrla().equals(this.ctrla) && !this.ctrla.equals("ALL CONTROL AREAS") || !TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice()) continue;
            if (TempComponent instanceof Busbar) {
                TempComponent.InformAllComponents();
                TempBusbar = (Busbar)TempComponent;
                this.BusbarVectorI.addElement(TempComponent);
                ++countBus;
            }
            if (TempComponent instanceof Load) {
                ++countLoad;
            }
            if (TempComponent instanceof ndb_branch) {
                TempBran = (ndb_branch)TempComponent;
                if (TempComponent instanceof Line) {
                    TempLine = (Line)TempBran;
                    TempLine.InformPartner(TempLine.ConnComps1, TempLine.getx1(), TempLine.gety1(), 1);
                    TempLine.InformPartner(TempLine.ConnComps2, TempLine.getx2(), TempLine.gety2(), 2);
                    ++countLin;
                }
                if (TempComponent instanceof Trafo) {
                    TempComponent.InformAllComponents();
                    TempTrafo = (Trafo)TempBran;
                    ++countTra;
                }
                if (TempComponent instanceof ThreeWindingTrafo) {
                    TempComponent.InformAllComponents();
                    ++count3Tra;
                    countBra += 2;
                }
                ++countBra;
            }
            if (!(TempComponent instanceof ndb_inj)) continue;
            TempComponent.InformAllComponents();
            if (!(TempComponent instanceof Generator)) continue;
            TempGenerator = (Generator)TempComponent;
            ++countGen;
        }
        this.numnod = countBus;
        this.numbra = countBra;
        this.numlin = countLin;
        this.numtran = countTra;
        this.numtranthree = count3Tra;
        this.numgen = countGen;
        this.numload = countLoad;
        this.BusGen = new boolean[this.numnod];
        this.NumBusGen = new int[this.numgen];
        this.NomGen = new String[this.numgen];
        this.BranchR = new double[this.numbra];
        this.BranchX = new double[this.numbra];
        this.BranchB = new double[this.numbra];
        this.BranchXd = new double[this.numgen];
        this.BranchI = new int[this.numbra];
        this.BranchJ = new int[this.numbra];
        this.NomBranch = new String[this.numbra];
        this.NomNod = new String[this.numnod];
        this.VBus = new double[this.numnod];
        this.ABus = new double[this.numnod];
        this.Vpre = new Complex[this.numnod];
        this.Sconj = new Complex[this.numgen];
        this.RLoad = new double[this.numload];
        this.XLoad = new double[this.numload];
        this.NumBusLoad = new int[this.numload];
        this.BusLoad = new boolean[this.numnod];
        this.BusShunt = new boolean[this.numnod];
        countBus = 0;
        countBra = -1;
        countLin = 0;
        countTra = 0;
        countGen = 0;
        countLoad = 0;
        countshunt = 0;
        for (i = 0; i < this.numnod; ++i) {
            this.BusGen[i] = false;
            this.BusLoad[i] = false;
            this.BusShunt[i] = false;
        }
        for (int ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
            int mula;
            TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
            if (!(TempComponent instanceof ndb_comp) || !(TempNdb_comp = (ndb_comp)TempComponent).getctrla().equals(this.ctrla) && !this.ctrla.equals("ALL CONTROL AREAS") || !TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice()) continue;
            if (TempComponent instanceof Busbar) {
                TempBusbar = (Busbar)TempComponent;
                this.NomNod[countBus] = TempComponent.getName();
                if (TempComponent.getName().equals(this.barra)) {
                    this.BadBusbar = (Busbar)TempComponent;
                    this.numref = this.numbus(this.BadBusbar.getName());
                }
                if (this.method.equals("IEC909") && this.maxmin.equals("Maximum")) {
                    this.Vpre[countBus] = TempBusbar.getun1() <= 1.0 ? (this.tolerance.equals("+/- 6%") ? new Complex(1.05, 0.0) : new Complex(1.1, 0.0)) : new Complex(1.1, 0.0);
                } else if (this.method.equals("IEC909") && this.maxmin.equals("Minimum")) {
                    this.Vpre[countBus] = TempBusbar.getun1() <= 1.0 ? new Complex(0.95, 0.0) : new Complex(1.0, 0.0);
                } else {
                    this.VBus[countBus] = TempBusbar.getun2() * this.cfactor;
                    this.ABus[countBus] = TempBusbar.getdelta2();
                    double vref = TempBusbar.getun1();
                    reVBus = this.VBus[countBus] * Math.cos(Math.toRadians(this.ABus[countBus])) / vref;
                    imVBus = this.VBus[countBus] * Math.sin(Math.toRadians(this.ABus[countBus])) / vref;
                    this.Vpre[countBus] = new Complex(reVBus, imVBus);
                    this.Vpre[countBus] = Complex.multiply((Complex)this.Vpre[countBus], (double)this.cfactor);
                }
                ++countBus;
                continue;
            }
            if (TempComponent instanceof Load) {
                TempComponent.InformAllComponents();
                TempLoad = (Load)TempComponent;
                double Pload = TempLoad.getp0() / this.sref;
                double Qload = TempLoad.getq0() / this.sref;
                this.RLoad[countLoad] = Pload / (Pload * Pload + Qload * Qload);
                this.XLoad[countLoad] = Qload / (Pload * Pload + Qload * Qload);
                this.NumBusLoad[countLoad] = mula = this.numbus(TempLoad.getcon2());
                if (!this.BusLoad[mula]) {
                    this.BusLoad[mula] = true;
                    if (!this.BusShunt[mula]) {
                        this.BusShunt[mula] = true;
                        ++countshunt;
                    }
                }
                ++countLoad;
                continue;
            }
            if (TempComponent instanceof ndb_branch) {
                ++countBra;
                con1 = this.numbus(TempComponent.getcon1());
                con2 = this.numbus(TempComponent.getcon2());
                if (TempComponent instanceof Line) {
                    TempLine = (Line)TempComponent;
                    if (con1 != -1 && con2 != -1) {
                        if (Math.sqrt(TempLine.getxx1() * TempLine.getb1()) * TempLine.getlen() > 0.1396) {
                            System.out.println("No approximations were considered while modeling line: " + TempLine.getName());
                            double[] param = JavaShC.getExactLineParam(TempLine.getr1(), TempLine.getxx1(), TempLine.getg1(), TempLine.getb1(), TempLine.getlen());
                            this.BranchR[countBra] = param[0];
                            this.BranchX[countBra] = param[1];
                            this.BranchB[countBra] = param[3];
                        } else {
                            this.BranchX[countBra] = TempLine.getxx1() * TempLine.getlen();
                            this.BranchR[countBra] = TempLine.getr1() * TempLine.getlen();
                            this.BranchB[countBra] = TempLine.getb1() * TempLine.getlen() / 2.0;
                        }
                    } else {
                        throw new JavaShCException("Branch '" + TempLine.getName() + " is not connected to any busbar. Use View->View Connections to visualize connection errors");
                    }
                    this.BranchX[countBra] = this.BranchX[countBra] * this.sref / (TempLine.getun1() * TempLine.getun1());
                    this.BranchR[countBra] = this.BranchR[countBra] * this.sref / (TempLine.getun1() * TempLine.getun1());
                    this.BranchB[countBra] = this.BranchB[countBra] / 2.0 / this.sref * (TempLine.getun1() * TempLine.getun1());
                    this.BranchI[countBra] = con1;
                    this.BranchJ[countBra] = con2;
                    this.NomBranch[countBra] = TempLine.getName();
                    ++countLin;
                    continue;
                }
                if (TempComponent instanceof Trafo) {
                    TempTrafo = (Trafo)TempComponent;
                    TempTrafo.actualizet();
                    if (con1 == -1 || con2 == -1) {
                        throw new JavaShCException("Branch '" + TempComponent.getName() + " is not connected to any busbar. Use View->View Connections to visualize connection errors");
                    }
                    ueb = TempTrafo.getun1() / TempTrafo.getun2() / (TempTrafo.getur1() / TempTrafo.getur2());
                    res = TempTrafo.getpcu() * 0.001 * ueb * ueb / TempTrafo.getsn() * this.sref / TempTrafo.getsn();
                    z = TempTrafo.getuk() * 0.01 * ueb * ueb * this.sref / TempTrafo.getsn();
                    double relunur = TempTrafo.getun1() / TempTrafo.getur1();
                    b = TempTrafo.geti0() * 0.01 * 0.5 * (TempTrafo.getsn() / this.sref) / (relunur * relunur);
                    reac = TempTrafo.getuk() >= 0.0 ? Math.sqrt(z * z - res * res) : -Math.sqrt(z * z - res * res);
                    this.BranchX[countBra] = reac;
                    this.BranchR[countBra] = res;
                    this.BranchB[countBra] = b;
                    this.BranchI[countBra] = con1;
                    this.BranchJ[countBra] = con2;
                    this.NomBranch[countBra] = TempTrafo.getName();
                    ++countTra;
                    continue;
                }
                if (!(TempComponent instanceof ThreeWindingTrafo)) continue;
                ThreeWindingTrafo TempThreeWindingTrafo = (ThreeWindingTrafo)TempComponent;
                TempThreeWindingTrafo.actualizet();
                if (con1 == -1 || con2 == -1 || (con3 = this.numbus(TempThreeWindingTrafo.getcon3())) <= -1) continue;
                potapa1 = TempThreeWindingTrafo.getsn() > TempThreeWindingTrafo.getsn1() ? TempThreeWindingTrafo.getsn1() : TempThreeWindingTrafo.getsn();
                potapa2 = TempThreeWindingTrafo.getsn() > TempThreeWindingTrafo.getsn2() ? TempThreeWindingTrafo.getsn2() : TempThreeWindingTrafo.getsn();
                potapa3 = TempThreeWindingTrafo.getsn1() > TempThreeWindingTrafo.getsn2() ? TempThreeWindingTrafo.getsn2() : TempThreeWindingTrafo.getsn1();
                resistencias[0] = TempThreeWindingTrafo.getpcu() * (0.001 / potapa1) * (TempThreeWindingTrafo.getun1() * TempThreeWindingTrafo.getun1() / potapa1) * this.sref / TempThreeWindingTrafo.getsn();
                resistencias[1] = TempThreeWindingTrafo.getpcu13() * (0.001 / potapa2) * (TempThreeWindingTrafo.getun1() * TempThreeWindingTrafo.getun1() / potapa2) * this.sref / TempThreeWindingTrafo.getsn1();
                resistencias[2] = TempThreeWindingTrafo.getpcu23() * (0.001 / potapa3) * (TempThreeWindingTrafo.getun1() * TempThreeWindingTrafo.getun1() / potapa3) * this.sref / TempThreeWindingTrafo.getsn2();
                resistencias[0] = resistencias[0] * potapa1 / (TempThreeWindingTrafo.getun1() * TempThreeWindingTrafo.getun1());
                resistencias[1] = resistencias[1] * potapa2 / (TempThreeWindingTrafo.getun1() * TempThreeWindingTrafo.getun1());
                resistencias[2] = resistencias[2] * potapa3 / (TempThreeWindingTrafo.getun1() * TempThreeWindingTrafo.getun1());
                Zk12 = TempThreeWindingTrafo.getuk12() * 0.01 * (TempThreeWindingTrafo.getun1() * TempThreeWindingTrafo.getun1()) / potapa1 * this.sref / TempThreeWindingTrafo.getsn();
                Zk13 = TempThreeWindingTrafo.getuk13() * 0.01 * (TempThreeWindingTrafo.getun1() * TempThreeWindingTrafo.getun1()) / potapa2 * this.sref / TempThreeWindingTrafo.getsn1();
                Zk23 = TempThreeWindingTrafo.getuk23() * 0.01 * (TempThreeWindingTrafo.getun1() * TempThreeWindingTrafo.getun1()) / potapa3 * this.sref / TempThreeWindingTrafo.getsn2();
                Zk12 = Zk12 * potapa1 / (TempThreeWindingTrafo.getun1() * TempThreeWindingTrafo.getun1());
                Zk13 = Zk13 * potapa2 / (TempThreeWindingTrafo.getun1() * TempThreeWindingTrafo.getun1());
                Zk23 = Zk23 * potapa3 / (TempThreeWindingTrafo.getun1() * TempThreeWindingTrafo.getun1());
                b = TempThreeWindingTrafo.geti0() * 0.01 / this.sref * TempThreeWindingTrafo.getsn();
                tap1 = TempThreeWindingTrafo.gett_re();
                tap2 = TempThreeWindingTrafo.gett_re1();
                tap3 = TempThreeWindingTrafo.gett_re2();
                c = 0;
                parestrafo = false;
                react[0] = TempThreeWindingTrafo.getuk12() >= 0.0 ? Math.sqrt(Zk12 * Zk12 - resistencias[0] * resistencias[0]) : -Math.sqrt(Zk12 * Zk12 - resistencias[0] * resistencias[0]);
                react[1] = TempThreeWindingTrafo.getuk13() >= 0.0 ? Math.sqrt(Zk13 * Zk13 - resistencias[1] * resistencias[1]) : -Math.sqrt(Zk13 * Zk13 - resistencias[1] * resistencias[1]);
                react[2] = TempThreeWindingTrafo.getuk23() >= 0.0 ? Math.sqrt(Zk23 * Zk23 - resistencias[2] * resistencias[2]) : -Math.sqrt(Zk23 * Zk23 - resistencias[2] * resistencias[2]);
                ZthreeWinding[0] = new Complex(0.5 * (resistencias[0] + resistencias[1] - resistencias[2]), 0.5 * (react[0] + react[1] - react[2]));
                ZthreeWinding[1] = new Complex(0.5 * (resistencias[0] + resistencias[2] - resistencias[1]), 0.5 * (react[0] + react[2] - react[1]));
                ZthreeWinding[2] = new Complex(0.5 * (resistencias[1] + resistencias[2] - resistencias[0]), 0.5 * (react[1] + react[2] - react[0]));
                Zrama12 = new Complex(resistencias[0], react[0]);
                Zrama13 = new Complex(resistencias[1], react[1]);
                Zrama23 = new Complex(resistencias[2], react[2]);
                Zreales[0] = Complex.add((Complex)Zrama12, (Complex)Complex.divide((Complex)Complex.multiply((Complex)ZthreeWinding[0], (Complex)ZthreeWinding[1]), (Complex)ZthreeWinding[2]));
                Zreales[1] = Complex.add((Complex)Zrama13, (Complex)Complex.divide((Complex)Complex.multiply((Complex)ZthreeWinding[0], (Complex)ZthreeWinding[2]), (Complex)ZthreeWinding[1]));
                Zreales[2] = Complex.add((Complex)Zrama23, (Complex)Complex.divide((Complex)Complex.multiply((Complex)ZthreeWinding[1], (Complex)ZthreeWinding[2]), (Complex)ZthreeWinding[0]));
                auxc3 = new Complex(0.0, b);
                fintrafo = countBra + 3;
                c = 0;
                while (countBra < fintrafo) {
                    this.BranchX[countBra] = Zreales[c].im;
                    this.BranchR[countBra] = Zreales[c].re;
                    this.BranchB[countBra] = b;
                    if (c == 0) {
                        this.BranchI[countBra] = con1;
                        this.BranchJ[countBra] = con2;
                    } else if (c == 1) {
                        this.BranchI[countBra] = con1;
                        this.BranchJ[countBra] = con3;
                    } else if (c == 2) {
                        this.BranchI[countBra] = con2;
                        this.BranchJ[countBra] = con3;
                    }
                    this.NomBranch[countBra] = TempThreeWindingTrafo.getName();
                    ++c;
                    ++countBra;
                }
                --countBra;
                continue;
            }
            if (!(TempComponent instanceof ndb_inj) || !(TempComponent instanceof Generator)) continue;
            TempComponent.InformAllComponents();
            TempGenerator = (Generator)TempComponent;
            TempNdb_inj = (ndb_inj)TempComponent;
            mula = this.numbus(TempNdb_inj.getcon2());
            if (mula < 0) {
                throw new JavaShCException("Genrator '" + TempGenerator.getName() + " is not connected to any busbar. Use View->View Connections to visualize connection errors");
            }
            this.NumBusGen[countGen] = mula;
            assert (TempGenerator.getxd1() != 0.0) : "Why this wasn't checked in 'Verifica'???";
            this.BranchXd[countGen] = TempGenerator.getxd1() * this.sref / TempGenerator.getsn();
            this.NomGen[countGen] = TempGenerator.getName();
            if (!this.BusGen[mula]) {
                this.BusGen[mula] = true;
                ++countbusgen;
                if (!this.BusShunt[mula]) {
                    this.BusShunt[mula] = true;
                    ++countshunt;
                }
            }
            if (this.method == "Complete") {
                double Pgen = TempGenerator.getp() / this.sref;
                double Qgen = TempGenerator.getq() * -1.0 / this.sref;
                this.Sconj[countGen] = new Complex(Pgen, Qgen);
            }
            ++countGen;
        }
        this.numbusgen = countbusgen;
        this.numshunt = countshunt;
    }

    public void BuildZData() {
        int i = 0;
        int j = 0;
        this.ZDataC1 = new int[this.numbra + this.numshunt];
        this.ZDataC2 = new int[this.numbra + this.numshunt];
        this.ZDataC3 = new double[this.numbra + this.numshunt];
        this.ZDataC4 = new double[this.numbra + this.numshunt];
        this.ZDataC5 = new double[this.numbra + this.numshunt];
        int[] Ncreado = new int[this.numnod];
        boolean auxn = false;
        boolean auxm = false;
        double auxr = 0.0;
        double auxx = 0.0;
        double auxb = 0.0;
        int countbraf = 0;
        int countgenf = 0;
        int auxi = 0;
        int auxj = 0;
        int k = 0;
        int r = 0;
        boolean nnuevo = true;
        this.TipoBranch = new int[this.numbra + this.numshunt];
        int[] GenBusbar = new int[this.numbusgen];
        int countbusgen = 0;
        int ubica = 0;
        boolean existe = false;
        for (i = 0; i < this.numgen; ++i) {
            if (this.NumBusGen[i] == this.numref) {
                ++countgenf;
            }
            if (i == 0) {
                this.ZDataC1[i] = -1;
                this.ZDataC2[i] = this.NumBusGen[i];
                Ncreado[i] = this.ZDataC2[i];
                this.ZDataC3[i] = 0.0;
                this.ZDataC4[i] = this.BranchXd[i];
                this.ZDataC5[i] = 0.0;
                this.TipoBranch[i] = 1;
                countbusgen = 1;
                GenBusbar[i] = this.NumBusGen[i];
                continue;
            }
            existe = false;
            for (j = 0; j < countbusgen; ++j) {
                if (this.NumBusGen[i] != GenBusbar[j]) continue;
                existe = true;
                ubica = j;
            }
            if (existe) {
                this.ZDataC4[ubica] = this.ZDataC4[ubica] * this.BranchXd[i] / (this.ZDataC4[ubica] + this.BranchXd[i]);
                continue;
            }
            this.ZDataC1[countbusgen] = -1;
            this.ZDataC2[countbusgen] = this.NumBusGen[i];
            Ncreado[countbusgen] = this.ZDataC2[countbusgen];
            this.ZDataC3[countbusgen] = 0.0;
            this.ZDataC4[countbusgen] = this.BranchXd[i];
            this.ZDataC5[countbusgen] = 0.0;
            this.TipoBranch[countbusgen] = 1;
            GenBusbar[countbusgen] = this.NumBusGen[i];
            ++countbusgen;
        }
        this.numgenf = countgenf;
        int countcreado = this.numbusgen;
        if (this.method.equals("Complete")) {
            for (i = 0; i < this.numload; ++i) {
                this.RLoad[i] = Complex.abs((Complex)this.Vpre[this.NumBusLoad[i]]) * Complex.abs((Complex)this.Vpre[this.NumBusLoad[i]]) * this.RLoad[i];
                this.XLoad[i] = Complex.abs((Complex)this.Vpre[this.NumBusLoad[i]]) * Complex.abs((Complex)this.Vpre[this.NumBusLoad[i]]) * this.XLoad[i];
                existe = false;
                for (j = 0; j < countcreado; ++j) {
                    if (this.NumBusLoad[i] != Ncreado[j]) continue;
                    existe = true;
                    ubica = j;
                }
                if (existe) {
                    double r1 = this.ZDataC3[ubica];
                    double x1 = this.ZDataC4[ubica];
                    double r2 = this.RLoad[i];
                    double x2 = this.XLoad[i];
                    this.ZDataC3[ubica] = ((r1 * r2 - x1 * x2) * (r1 + r2) + (r1 * x2 + r2 * x1) * (x1 + x2)) / ((r1 + r2) * (r1 + r2) + (x1 + x2) * (x1 + x2));
                    this.ZDataC4[ubica] = ((r1 * x2 + r2 * x1) * (r1 + r2) - (r1 * r2 - x1 * x2) * (x1 + x2)) / ((r1 + r2) * (r1 + r2) + (x1 + x2) * (x1 + x2));
                    continue;
                }
                this.ZDataC1[countcreado] = -1;
                this.ZDataC2[countcreado] = this.NumBusLoad[i];
                Ncreado[countcreado] = this.ZDataC2[countcreado];
                this.ZDataC3[countcreado] = this.RLoad[i];
                this.ZDataC4[countcreado] = this.XLoad[i];
                this.ZDataC5[countcreado] = 0.0;
                this.TipoBranch[countcreado] = 1;
                ++countcreado;
            }
        }
        this.numshunt = countcreado;
        for (i = 0; i < this.numbra; ++i) {
            this.ZDataC1[this.numshunt + i] = this.BranchI[i];
            this.ZDataC2[this.numshunt + i] = this.BranchJ[i];
            this.ZDataC3[this.numshunt + i] = this.BranchR[i];
            this.ZDataC4[this.numshunt + i] = this.BranchX[i];
            this.ZDataC5[this.numshunt + i] = this.BranchB[i];
            this.TipoBranch[this.numshunt + i] = 3;
            if (this.BranchI[i] != this.numref && this.BranchJ[i] != this.numref) continue;
            ++countbraf;
        }
        this.numbraf = countbraf;
        k = this.numshunt;
        for (i = 0; i < this.numnod && k < this.numnod; ++i) {
            for (j = k; j < this.numbra + this.numshunt; ++j) {
                if (Ncreado[i] == this.ZDataC1[j]) {
                    nnuevo = true;
                    for (r = 0; r < k; ++r) {
                        if (this.ZDataC2[j] != Ncreado[r]) continue;
                        nnuevo = false;
                    }
                    if (!nnuevo) continue;
                    auxi = this.ZDataC1[j];
                    auxj = this.ZDataC2[j];
                    auxr = this.ZDataC3[j];
                    auxx = this.ZDataC4[j];
                    auxb = this.ZDataC5[j];
                    Ncreado[k] = this.ZDataC2[j];
                    this.ZDataC1[j] = this.ZDataC1[k];
                    this.ZDataC2[j] = this.ZDataC2[k];
                    this.ZDataC3[j] = this.ZDataC3[k];
                    this.ZDataC4[j] = this.ZDataC4[k];
                    this.ZDataC5[j] = this.ZDataC5[k];
                    this.ZDataC1[k] = auxi;
                    this.ZDataC2[k] = auxj;
                    this.ZDataC3[k] = auxr;
                    this.ZDataC4[k] = auxx;
                    this.ZDataC5[k] = auxb;
                    this.TipoBranch[k] = 2;
                    ++k;
                    continue;
                }
                if (Ncreado[i] != this.ZDataC2[j]) continue;
                nnuevo = true;
                for (r = 0; r < k; ++r) {
                    if (this.ZDataC1[j] != Ncreado[r]) continue;
                    nnuevo = false;
                }
                if (!nnuevo) continue;
                auxi = this.ZDataC1[j];
                auxj = this.ZDataC2[j];
                auxr = this.ZDataC3[j];
                auxx = this.ZDataC4[j];
                auxb = this.ZDataC5[j];
                Ncreado[k] = this.ZDataC1[j];
                this.ZDataC1[j] = this.ZDataC1[k];
                this.ZDataC2[j] = this.ZDataC2[k];
                this.ZDataC3[j] = this.ZDataC3[k];
                this.ZDataC4[j] = this.ZDataC4[k];
                this.ZDataC5[j] = this.ZDataC5[k];
                this.ZDataC1[k] = auxi;
                this.ZDataC2[k] = auxj;
                this.ZDataC3[k] = auxr;
                this.ZDataC4[k] = auxx;
                this.ZDataC5[k] = auxb;
                this.TipoBranch[k] = 2;
                ++k;
            }
        }
    }

    public void BuildZMatrix() throws JavaShCException {
        int m = 0;
        int i = 0;
        int j = 0;
        this.MatZaux = new Complex[this.numnod + 2][this.numnod + 2];
        int dim = 0;
        int[] ntree = new int[this.numbra + this.numshunt];
        this.IdNod = new int[this.numnod];
        int p = -100;
        int q = -100;
        for (i = 0; i < this.numnod; ++i) {
            this.IdNod[i] = -100;
            for (j = 0; j < this.numnod; ++j) {
                this.MatZaux[i][j] = new Complex(0.0, 0.0);
            }
        }
        for (i = 0; i < this.numnod + 1; ++i) {
            this.MatZaux[i][this.numnod] = new Complex(0.0, 0.0);
            this.MatZaux[this.numnod][i] = new Complex(0.0, 0.0);
        }
        for (i = 0; i < this.numbra + this.numshunt; ++i) {
            this.ZDataC1[i] = this.ZDataC1[i] + 1;
            this.ZDataC2[i] = this.ZDataC2[i] + 1;
        }
        for (m = 0; m < this.numbra + this.numshunt; ++m) {
            Complex auxc1;
            if (this.TipoBranch[m] == 0) {
                System.out.println(" Error en branch, de " + this.ZDataC1[m] + " a " + this.ZDataC2[m] + " NO tipificada ==> verifique red ");
                System.out.println(" NO sigue la ejecucin normal");
                this.myPPrintStream.println(" Error en branch, de " + this.ZDataC1[m] + " a " + this.ZDataC2[m] + " NO tipificada ==> verifique red ");
                throw new JavaShCException("Error en branch, de " + this.ZDataC1[m] + " a " + this.ZDataC2[m] + " NO tipificada ==> verifique red ");
            }
            if (this.TipoBranch[m] == 1) {
                this.IdNod[dim] = this.ZDataC1[m] == 0 ? this.ZDataC2[m] - 1 : this.ZDataC1[m] - 1;
                p = this.IdNod[dim];
                auxc1 = new Complex(this.ZDataC3[m], this.ZDataC4[m]);
                this.MatZaux[p][p].add(auxc1);
                ++dim;
                continue;
            }
            if (this.TipoBranch[m] == 2) {
                boolean estaC1 = false;
                boolean estaC2 = false;
                for (i = 0; i < m; ++i) {
                    if (this.ZDataC1[i] == this.ZDataC1[m] || this.ZDataC2[i] == this.ZDataC1[m]) {
                        estaC1 = true;
                    }
                    if (this.ZDataC2[i] != this.ZDataC2[m] && this.ZDataC1[i] != this.ZDataC2[m]) continue;
                    estaC2 = true;
                }
                if (estaC1 && !estaC2) {
                    q = this.ZDataC2[m] - 1;
                    p = this.ZDataC1[m] - 1;
                } else if (!estaC1 && estaC2) {
                    q = this.ZDataC1[m] - 1;
                    p = this.ZDataC2[m] - 1;
                } else if (!estaC1 && !estaC2 || estaC1 && estaC2) {
                    assert (false) : "why did you get to this place? Is there a problem with schematic?";
                    throw new JavaShCException("Unexpected exception. Contact provider");
                }
                this.IdNod[dim] = q;
                for (i = 0; i < dim; ++i) {
                    this.MatZaux[this.IdNod[i]][q].add(this.MatZaux[this.IdNod[i]][p]);
                    this.MatZaux[q][this.IdNod[i]].add(this.MatZaux[p][this.IdNod[i]]);
                }
                auxc1 = new Complex(this.ZDataC3[m], this.ZDataC4[m]);
                this.MatZaux[q][q] = Complex.add((Complex)auxc1, (Complex)this.MatZaux[p][q]);
                ++dim;
                if (!this.method.equals("Complete") || !this.uselineshunt) continue;
                this.includetransimp(m, p, dim);
                this.includetransimp(m, q, dim);
                continue;
            }
            if (this.TipoBranch[m] != 3) continue;
            Complex[] DZ = new Complex[this.numnod];
            Complex zll = new Complex(0.0, 0.0);
            Complex zpq = new Complex(this.ZDataC3[m], this.ZDataC4[m]);
            p = this.ZDataC1[m] - 1;
            q = this.ZDataC2[m] - 1;
            Complex[][] Zmod = new Complex[this.numnod][this.numnod];
            zll = Complex.add((Complex)this.MatZaux[p][q], (Complex)this.MatZaux[q][p]);
            zll = Complex.subtract((Complex)zpq, (Complex)zll);
            zll = Complex.add((Complex)zll, (Complex)this.MatZaux[p][p]);
            zll = Complex.add((Complex)zll, (Complex)this.MatZaux[q][q]);
            for (i = 0; i < this.numnod; ++i) {
                DZ[i] = new Complex(0.0, 0.0);
                for (j = 0; j < this.numnod; ++j) {
                    Zmod[i][j] = new Complex(0.0, 0.0);
                }
            }
            for (i = 0; i < dim; ++i) {
                DZ[this.IdNod[i]] = Complex.add((Complex)DZ[this.IdNod[i]], (Complex)this.MatZaux[this.IdNod[i]][q]);
                DZ[this.IdNod[i]] = Complex.subtract((Complex)DZ[this.IdNod[i]], (Complex)this.MatZaux[this.IdNod[i]][p]);
            }
            for (i = 0; i < dim; ++i) {
                for (j = 0; j < dim; ++j) {
                    int ii = this.IdNod[i];
                    int jj = this.IdNod[j];
                    Zmod[ii][jj] = Complex.multiply((Complex)DZ[ii], (Complex)DZ[jj]);
                    Zmod[ii][jj] = Complex.divide((Complex)Zmod[ii][jj], (Complex)zll);
                }
            }
            for (i = 0; i < dim; ++i) {
                for (j = 0; j < dim; ++j) {
                    this.MatZaux[this.IdNod[i]][this.IdNod[j]] = Complex.subtract((Complex)this.MatZaux[this.IdNod[i]][this.IdNod[j]], (Complex)Zmod[this.IdNod[i]][this.IdNod[j]]);
                }
            }
            if (!this.method.equals("Complete") || !this.uselineshunt) continue;
            this.includetransimp(m, p, dim);
            this.includetransimp(m, q, dim);
        }
        for (i = 0; i < this.numbra + this.numshunt; ++i) {
            this.ZDataC1[i] = this.ZDataC1[i] - 1;
            this.ZDataC2[i] = this.ZDataC2[i] - 1;
        }
    }

    public void CalculaIFault(Busbar Fallada) {
        int i = 0;
        int nf = this.numbus(Fallada.getName());
        Complex ac = new Complex(this.rzeta, this.xzeta);
        ac.add(this.MatZaux[nf][nf]);
        this.IFalla = new Complex(0.0, 0.0);
        this.IFalla = Complex.divide((Complex)this.Vpre[nf], (Complex)ac);
        int countgenf = 0;
        int countbraf = 0;
        boolean countgen = false;
        boolean countbra = false;
        double rx = 0.0;
        Complex Xdgen = new Complex(0.0, 0.0);
        Complex Zbranch = new Complex(0.0, 0.0);
        Complex[] DV = new Complex[this.numnod];
        this.Ifbranchf = new Complex[this.numbraf];
        this.Ifgenf = new Complex[this.numgenf];
        this.Vpost = new Complex[this.numnod];
        this.Ifbranch = new Complex[this.numbra];
        this.Ifgen = new Complex[this.numgen];
        this.NomBranchf = new String[this.numbraf];
        this.NomGenf = new String[this.numgenf];
        this.Eint = new Complex[this.numgen];
        rx = this.MatZaux[nf][nf].re / this.MatZaux[nf][nf].im;
        this.factork = 1.02 + 0.98 * Math.exp(-3.0 * rx);
        this.Ifpick = Math.sqrt(2.0) * this.factork * Complex.abs((Complex)this.IFalla);
        for (i = 0; i < this.numnod; ++i) {
            if (i == nf) {
                this.Vpost[i] = new Complex(0.0, 0.0);
                this.Vpost[i] = Complex.multiply((Complex)new Complex(this.rzeta, this.xzeta), (Complex)this.IFalla);
                continue;
            }
            DV[i] = new Complex(0.0, 0.0);
            this.Vpost[i] = new Complex(0.0, 0.0);
            DV[i] = Complex.multiply((Complex)this.MatZaux[i][nf], (Complex)this.IFalla);
            this.Vpost[i] = Complex.subtract((Complex)this.Vpre[i], (Complex)DV[i]);
        }
        this.ifpromedio = 0.0;
        for (i = 0; i < this.numbra; ++i) {
            this.Ifbranch[i] = new Complex(0.0, 0.0);
            Zbranch = new Complex(this.BranchR[i], this.BranchX[i]);
            this.Ifbranch[i] = Complex.subtract((Complex)this.Vpost[this.BranchI[i]], (Complex)this.Vpost[this.BranchJ[i]]);
            this.Ifbranch[i] = Complex.divide((Complex)this.Ifbranch[i], (Complex)Zbranch);
            this.ifpromedio = Complex.abs((Complex)this.Ifbranch[i]) + this.ifpromedio;
            if (this.BranchI[i] == nf) {
                this.Ifbranchf[countbraf] = new Complex(0.0, 0.0);
                this.Ifbranchf[countbraf] = this.Ifbranch[i];
                this.NomBranchf[countbraf] = this.NomBranch[i];
                ++countbraf;
                continue;
            }
            if (this.BranchJ[i] != nf) continue;
            this.Ifbranchf[countbraf] = new Complex(0.0, 0.0);
            this.Ifbranchf[countbraf] = Complex.subtract((Complex)new Complex(0.0, 0.0), (Complex)this.Ifbranch[i]);
            this.NomBranchf[countbraf] = this.NomBranch[i];
            ++countbraf;
        }
        this.ifpromedio /= (double)this.numbra;
        this.numbraf = countbraf;
        for (i = 0; i < this.numgen; ++i) {
            this.Ifgen[i] = new Complex(0.0, 0.0);
            Zbranch = new Complex(0.0, this.BranchXd[i]);
            if (this.method.equals("IEC909")) {
                this.Ifgen[i] = Complex.subtract((Complex)this.Vpre[this.NumBusGen[i]], (Complex)this.Vpost[this.NumBusGen[i]]);
                this.Ifgen[i] = Complex.divide((Complex)this.Ifgen[i], (Complex)Zbranch);
            } else {
                this.Eint[i] = new Complex(this.Vpre[this.NumBusGen[i]].re, -1.0 * this.Vpre[this.NumBusGen[i]].im);
                this.Eint[i] = Complex.divide((Complex)this.Sconj[i], (Complex)this.Eint[i]);
                this.Eint[i] = Complex.multiply((Complex)Zbranch, (Complex)this.Eint[i]);
                this.Eint[i] = Complex.add((Complex)this.Vpre[this.NumBusGen[i]], (Complex)this.Eint[i]);
                this.Ifgen[i] = Complex.subtract((Complex)this.Eint[i], (Complex)this.Vpost[this.NumBusGen[i]]);
                this.Ifgen[i] = Complex.divide((Complex)this.Ifgen[i], (Complex)Zbranch);
            }
            if (this.NumBusGen[i] != nf) continue;
            this.Ifgenf[countgenf] = new Complex(0.0, 0.0);
            this.Ifgenf[countgenf] = this.Ifgen[i];
            this.NomGenf[countgenf] = this.NomGen[i];
            ++countgenf;
        }
        this.numgenf = countgenf;
    }

    public int numbus(String Busbarname) {
        int ix = 0;
        for (ix = 0; ix < this.BusbarVectorI.size(); ++ix) {
            comp TempComponent = (comp)this.BusbarVectorI.elementAt(ix);
            if (TempComponent.getName().hashCode() != Busbarname.hashCode() || !TempComponent.getName().equals(Busbarname)) continue;
            return ix;
        }
        return -1;
    }

    public void setParameters(String metodo, String busbar, boolean reporte, double rz, double xz, String selectmaxmin, String tolerancia, double voltagefactor, boolean imptransitoria, String Amethod, boolean lineimp, boolean completeout, String ctrla) {
        this.method = metodo;
        this.maxmin = selectmaxmin;
        this.barra = busbar;
        if (reporte) {
            this.rep = true;
            if (completeout) {
                this.compout = true;
            }
        } else {
            this.rep = false;
        }
        this.rzeta = rz;
        this.xzeta = xz;
        this.tolerance = tolerancia;
        this.cfactor = voltagefactor;
        this.transimp = imptransitoria;
        this.uselineshunt = lineimp;
        this.rxMethod = Amethod;
        this.ctrla = ctrla;
    }

    public String Formato(double e) {
        boolean ceroder;
        boolean ceroiz;
        int i = 0;
        String formato = "0000.0000";
        DecimalFormatSymbols coma = new DecimalFormatSymbols();
        coma.setDecimalSeparator('.');
        DecimalFormat myFormatter = new DecimalFormat(formato);
        myFormatter.setDecimalFormatSymbols(coma);
        String numerostr = myFormatter.format(e);
        int lon = numerostr.length();
        StringBuffer mybuffer = new StringBuffer(numerostr);
        if (mybuffer.charAt(0) == '0') {
            mybuffer.setCharAt(0, ' ');
            ceroiz = true;
        } else {
            ceroiz = false;
        }
        if (mybuffer.charAt(lon - 1) == '0') {
            mybuffer.setCharAt(lon - 1, ' ');
            ceroder = true;
        } else {
            ceroder = false;
        }
        for (i = 1; i < 3; ++i) {
            if (mybuffer.charAt(i) == '0' && ceroiz) {
                mybuffer.setCharAt(i, ' ');
                ceroiz = true;
            } else {
                ceroiz = false;
            }
            if (mybuffer.charAt(lon - 1 - i) == '0' && ceroder) {
                mybuffer.setCharAt(lon - 1 - i, ' ');
                ceroder = true;
                continue;
            }
            ceroder = false;
        }
        mybuffer.setLength(9);
        String S = mybuffer.toString();
        return S;
    }

    public String FormatoString(String elementstring) {
        int i = 0;
        int longbuffer = 0;
        StringBuffer elementname = new StringBuffer(15);
        longbuffer = elementstring.length() < 15 ? elementstring.length() : 14;
        for (i = 0; i < longbuffer; ++i) {
            elementname.append(elementstring.charAt(i));
        }
        for (i = longbuffer; i <= 14; ++i) {
            elementname.append(' ');
        }
        String formatoelement = elementname.toString();
        return formatoelement;
    }

    public void includetransimp(int m, int p, int dim) {
        if (this.ZDataC5[m] != 0.0) {
            int k;
            int i;
            double Xlinshunt = -1.0 / this.ZDataC5[m];
            Complex[] Zkq = new Complex[this.numnod];
            Complex[] Zqk = new Complex[this.numnod];
            Complex[][] ZMod = new Complex[this.numnod][this.numnod];
            for (i = 0; i < this.numnod; ++i) {
                for (k = 0; k < this.numnod; ++k) {
                    ZMod[i][k] = new Complex(0.0, 0.0);
                }
                Zkq[i] = new Complex(0.0, 0.0);
                Zqk[i] = new Complex(0.0, 0.0);
            }
            for (i = 0; i < dim; ++i) {
                Zkq[this.IdNod[i]] = this.MatZaux[p][this.IdNod[i]];
                Zqk[this.IdNod[i]] = this.MatZaux[this.IdNod[i]][p];
            }
            Complex Zqq = new Complex(0.0, Xlinshunt);
            Zqq = Complex.add((Complex)this.MatZaux[p][p], (Complex)Zqq);
            Zqq = Complex.divide((Complex)new Complex(1.0, 0.0), (Complex)Zqq);
            for (i = 0; i < this.numnod; ++i) {
                Zkq[i] = Complex.multiply((Complex)Zqq, (Complex)Zkq[i]);
                for (k = 0; k < this.numnod; ++k) {
                    ZMod[i][k] = Complex.multiply((Complex)Zkq[i], (Complex)Zqk[k]);
                    this.MatZaux[i][k] = Complex.subtract((Complex)this.MatZaux[i][k], (Complex)ZMod[i][k]);
                }
            }
        }
    }

    @Override
    public void run() {
        try {
            this.Calculate();
        }
        catch (Exception e) {
            JLabel lblMessage = new JLabel(e.getMessage());
            lblMessage.setFont(DeepEdit.TextFont);
            JOptionPane.showMessageDialog(DeepEdit.frame, lblMessage, "Short circuit validation error", 0);
            e.printStackTrace(System.out);
        }
    }
}

