/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import VisualNumerics.math.Complex;
import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.impl.DenseDoubleMatrix1D;
import cern.colt.matrix.impl.DenseDoubleMatrix2D;
import cern.colt.matrix.linalg.Algebra;
import cern.colt.matrix.linalg.LUDecomposition;
import cern.jet.math.Functions;
import cern.jet.random.ChiSquare;
import cern.jet.random.Normal;
import cern.jet.random.engine.DRand;
import cern.jet.random.engine.RandomEngine;
import de.core.AnalysisTool;
import de.core.Busbar;
import de.core.DEMainChartFrame;
import de.core.DeepEdit;
import de.core.JavaSEException;
import de.core.JavaSEFrame;
import de.core.JavaSEVisualFrame;
import de.core.Schematic;
import de.core.comp;
import de.core.ndb_branch;
import de.core.ndb_comp;
import de.utils.StringUtil;
import java.awt.Color;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.StringTokenizer;
import java.util.Vector;

public final class JavaSE
extends AnalysisTool {
    JavaSEFrame MyJavaSEFrame = null;
    JavaSEVisualFrame MyJSEVFrame = null;
    String ctrla = null;
    DEMainChartFrame myMChartFrame = null;
    protected DeepEdit deepEdApp;
    protected FileOutputStream os = null;
    protected PrintWriter myPrintStream = null;
    protected Schematic mySch;
    private String errorMsg = null;
    private double sref = 100.0;
    double[][] residualHistory;
    String[] residualIteration;
    String[] seriesLabel;
    String[] graphLabel;
    Integer stringIter;
    private static final String WORK_FILE = "JavaSE.dat";
    static Connection probeDB;
    private Statement stmt;
    private ResultSet rs;
    boolean moreRs = false;
    private boolean getFromDB = false;
    private boolean runSE = false;
    private boolean showCrp = false;
    private boolean runBDTest = false;
    private boolean addNoise = false;
    private double noiseSD = 0.0;
    private double tolerance = 0.0;
    private int maxIter = 0;
    Complex[][] Ybus;
    protected Vector BusbarVector;
    double[] BranchR;
    double[] BranchX;
    double[] BranchB;
    int[] BranchI;
    int[] BranchJ;
    int numbran = 0;
    private DenseDoubleMatrix2D Gbus;
    private DenseDoubleMatrix2D Bbus;
    private boolean[][] matCx;
    boolean simplecalc = false;
    private String[] Zprobe;
    private int[] Ztype;
    private int[] Zbus1;
    private int[] Zbus2;
    private int numZ = 0;
    private DenseDoubleMatrix1D Z;
    private DenseDoubleMatrix2D W;
    private comp auxComps;
    private DenseDoubleMatrix1D SE_h;
    private DenseDoubleMatrix2D SE_H;
    private DenseDoubleMatrix1D SE_V;
    private DenseDoubleMatrix1D SE_D;
    private String status = "ok";
    protected DenseDoubleMatrix2D Oo;
    protected Vector unObsBranch;
    private int[] tipobarra;
    private int indic_bSL = -1;

    public JavaSE(DeepEdit deepApplet, Schematic sch) {
        super(sch);
        this.mySch = sch;
        this.sref = this.getSref();
    }

    public JavaSE(DeepEdit deepApplet, Schematic sch, boolean simple) {
        super(sch);
        this.mySch = sch;
        this.simplecalc = simple;
        this.sref = this.getSref();
    }

    public void Calculate(String cctrla) throws Exception {
    }

    public void getNetwork() throws Exception {
    }

    public int numbus(String Busbarname) {
        for (int ix = 0; ix < this.BusbarVector.size(); ++ix) {
            comp TempComponent = (comp)this.BusbarVector.elementAt(ix);
            if (TempComponent.getName().hashCode() != Busbarname.hashCode() || !TempComponent.getName().equals(Busbarname)) continue;
            return ix;
        }
        return -1;
    }

    private void ini_var_sist() {
        this.Ybus = new Complex[this.numnod][this.numnod];
        this.Gbus = new DenseDoubleMatrix2D(this.numnod, this.numnod);
        this.Bbus = new DenseDoubleMatrix2D(this.numnod, this.numnod);
        this.tipobarra = new int[this.numnod];
        this.matCx = new boolean[this.numnod][this.numnod];
        this.BranchR = new double[this.numbran];
        this.BranchX = new double[this.numbran];
        this.BranchB = new double[this.numbran];
        this.BranchI = new int[this.numbran];
        this.BranchJ = new int[this.numbran];
        for (int i = 0; i < this.numnod; ++i) {
            for (int j = 0; j < this.numnod; ++j) {
                this.Ybus[i][j] = new Complex(0.0, 0.0);
            }
        }
        this.Zprobe = new String[this.numZ];
        this.Ztype = new int[this.numZ];
        this.Zbus1 = new int[this.numZ];
        this.Zbus2 = new int[this.numZ];
        this.Z = new DenseDoubleMatrix1D(this.numZ);
        this.W = new DenseDoubleMatrix2D(this.numZ, this.numZ);
        this.SE_h = new DenseDoubleMatrix1D(this.Z.size());
        this.SE_V = new DenseDoubleMatrix1D(this.numnod);
        this.SE_D = new DenseDoubleMatrix1D(this.numnod);
        this.SE_V.assign(1.0);
        this.SE_D.assign(0.0);
    }

    private void writeResults() {
    }

    public void setParameters(boolean getFDB, boolean runStateEstimation, boolean showConvergence, boolean runBadDataTest, boolean addGausseanNoise, double noiseSDeviation, double tolerancia, int maxIterations) {
        this.getFromDB = getFDB;
        this.runSE = runStateEstimation;
        this.showCrp = showConvergence;
        this.runBDTest = runBadDataTest;
        this.addNoise = addGausseanNoise;
        this.noiseSD = noiseSDeviation;
        this.tolerance = tolerancia;
        this.maxIter = maxIterations;
    }

    private void verificarGrafo() throws Exception {
        int i;
        int[] grupnod1 = new int[this.numnod + 1];
        boolean[] ingrup1 = new boolean[this.numnod];
        grupnod1[0] = 1;
        grupnod1[1] = 0;
        ingrup1[0] = true;
        for (i = 1; i <= grupnod1[0]; ++i) {
            for (int j = 0; j < this.numnod; ++j) {
                if (!this.matCx[grupnod1[i]][j] || ingrup1[j]) continue;
                grupnod1[0] = grupnod1[0] + 1;
                grupnod1[grupnod1[0]] = j;
                ingrup1[j] = true;
            }
            if (grupnod1[0] == this.numnod) break;
        }
        if (grupnod1[0] < this.numnod) {
            for (i = 0; i < this.numnod && ingrup1[i]; ++i) {
            }
            Busbar TempBusbar = (Busbar)this.BusbarVector.elementAt(i);
            this.javaSE_Error("There's an isolated Subsystem; \"" + TempBusbar.getName() + "\"," + "...");
        }
    }

    public void finalize() {
        this.Ybus = null;
        this.matCx = null;
        this.tipobarra = null;
        this.Gbus = null;
        this.Bbus = null;
    }

    public void fillJacobian() {
        int jj;
        int ii;
        double tempX1;
        int jj2;
        double tempX2;
        int Hcol;
        int Hrow;
        double tempX3 = 0.0;
        for (Hrow = 0; Hrow < this.Zprobe.length; ++Hrow) {
            block15: for (Hcol = 0; Hcol < this.numnod; ++Hcol) {
                switch (this.Ztype[Hrow]) {
                    case 1: {
                        this.SE_H.set(Hrow, Hcol, 0.0);
                        continue block15;
                    }
                    case 2: {
                        if (this.Zbus1[Hrow] == Hcol) {
                            tempX2 = 0.0;
                            for (jj2 = 0; jj2 < this.numnod; ++jj2) {
                                tempX1 = 0.0;
                                tempX1 = -this.Gbus.get(Hcol, jj2) * Math.sin(this.SE_D.get(jj2) - this.SE_D.get(Hcol));
                                tempX1 += this.Bbus.get(Hcol, jj2) * Math.cos(this.SE_D.get(jj2) - this.SE_D.get(Hcol));
                                tempX2 += (tempX1 *= this.SE_V.get(Hcol) * this.SE_V.get(jj2));
                            }
                            tempX1 = this.SE_V.get(Hcol) * this.SE_V.get(Hcol) * this.Bbus.get(Hcol, Hcol);
                            this.SE_H.set(Hrow, Hcol, -(tempX2 - tempX1));
                            continue block15;
                        }
                        tempX1 = 0.0;
                        ii = this.Zbus1[Hrow];
                        jj = Hcol;
                        tempX1 = this.Gbus.get(ii, jj) * Math.sin(this.SE_D.get(jj) - this.SE_D.get(ii));
                        tempX1 -= this.Bbus.get(ii, jj) * Math.cos(this.SE_D.get(jj) - this.SE_D.get(ii));
                        this.SE_H.set(Hrow, Hcol, -(tempX1 *= this.SE_V.get(ii) * this.SE_V.get(jj)));
                        continue block15;
                    }
                    case 3: {
                        if (this.Zbus1[Hrow] == Hcol) {
                            tempX2 = 0.0;
                            for (jj2 = 0; jj2 < this.numnod; ++jj2) {
                                tempX1 = 0.0;
                                tempX1 = this.Gbus.get(Hcol, jj2) * Math.cos(this.SE_D.get(Hcol) - this.SE_D.get(jj2));
                                tempX1 += this.Bbus.get(Hcol, jj2) * Math.sin(this.SE_D.get(Hcol) - this.SE_D.get(jj2));
                                tempX2 += (tempX1 *= this.SE_V.get(Hcol) * this.SE_V.get(jj2));
                            }
                            tempX1 = this.SE_V.get(Hcol) * this.SE_V.get(Hcol) * this.Gbus.get(Hcol, Hcol);
                            this.SE_H.set(Hrow, Hcol, -(tempX2 - tempX1));
                            continue block15;
                        }
                        tempX1 = 0.0;
                        ii = this.Zbus1[Hrow];
                        jj = Hcol;
                        tempX1 = this.Gbus.get(ii, jj) * Math.cos(this.SE_D.get(ii) - this.SE_D.get(jj));
                        tempX1 += this.Bbus.get(ii, jj) * Math.sin(this.SE_D.get(ii) - this.SE_D.get(jj));
                        this.SE_H.set(Hrow, Hcol, tempX1 *= this.SE_V.get(ii) * this.SE_V.get(jj));
                        continue block15;
                    }
                    case 4: {
                        if (this.Zbus1[Hrow] == Hcol) {
                            tempX1 = 0.0;
                            ii = this.Zbus1[Hrow];
                            jj = this.Zbus2[Hrow];
                            tempX1 = -this.Gbus.get(ii, jj) * Math.sin(this.SE_D.get(ii) - this.SE_D.get(jj));
                            tempX1 += this.Bbus.get(ii, jj) * Math.cos(this.SE_D.get(ii) - this.SE_D.get(jj));
                            this.SE_H.set(Hrow, Hcol, tempX1 *= this.SE_V.get(ii) * this.SE_V.get(jj));
                            continue block15;
                        }
                        if (this.Zbus2[Hrow] == Hcol) {
                            tempX1 = 0.0;
                            ii = this.Zbus1[Hrow];
                            jj = this.Zbus2[Hrow];
                            tempX1 = this.Gbus.get(ii, jj) * Math.sin(this.SE_D.get(ii) - this.SE_D.get(jj));
                            tempX1 -= this.Bbus.get(ii, jj) * Math.cos(this.SE_D.get(ii) - this.SE_D.get(jj));
                            this.SE_H.set(Hrow, Hcol, tempX1 *= this.SE_V.get(ii) * this.SE_V.get(jj));
                            continue block15;
                        }
                        if (this.Zbus1[Hrow] == Hcol || this.Zbus2[Hrow] == Hcol) continue block15;
                        tempX1 = 0.0;
                        this.SE_H.set(Hrow, Hcol, tempX1);
                        continue block15;
                    }
                    case 5: {
                        if (this.Zbus1[Hrow] == Hcol) {
                            tempX1 = 0.0;
                            ii = this.Zbus1[Hrow];
                            jj = this.Zbus2[Hrow];
                            tempX1 = this.Gbus.get(ii, jj) * Math.cos(this.SE_D.get(ii) - this.SE_D.get(jj));
                            tempX1 += this.Bbus.get(ii, jj) * Math.sin(this.SE_D.get(ii) - this.SE_D.get(jj));
                            this.SE_H.set(Hrow, Hcol, tempX1 *= this.SE_V.get(ii) * this.SE_V.get(jj));
                            continue block15;
                        }
                        if (this.Zbus2[Hrow] == Hcol) {
                            tempX1 = 0.0;
                            ii = this.Zbus1[Hrow];
                            jj = this.Zbus2[Hrow];
                            tempX1 = this.Gbus.get(ii, jj) * Math.cos(this.SE_D.get(ii) - this.SE_D.get(jj));
                            tempX1 += this.Bbus.get(ii, jj) * Math.sin(this.SE_D.get(ii) - this.SE_D.get(jj));
                            this.SE_H.set(Hrow, Hcol, -(tempX1 *= this.SE_V.get(ii) * this.SE_V.get(jj)));
                            continue block15;
                        }
                        if (this.Zbus1[Hrow] == Hcol || this.Zbus2[Hrow] == Hcol) continue block15;
                        tempX1 = 0.0;
                        this.SE_H.set(Hrow, Hcol, tempX1);
                    }
                }
            }
        }
        for (Hrow = 0; Hrow < this.Zprobe.length; ++Hrow) {
            block19: for (Hcol = 0; Hcol < this.numnod; ++Hcol) {
                switch (this.Ztype[Hrow]) {
                    case 1: {
                        if (this.Zbus1[Hrow] == Hcol) {
                            this.SE_H.set(Hrow, Hcol + this.numnod, 1.0);
                            this.SE_h.set(Hrow, this.SE_V.get(Hcol));
                            continue block19;
                        }
                        this.SE_H.set(Hrow, Hcol + this.numnod, 0.0);
                        continue block19;
                    }
                    case 2: {
                        if (this.Zbus1[Hrow] == Hcol) {
                            tempX2 = 0.0;
                            for (jj2 = 0; jj2 < this.numnod; ++jj2) {
                                tempX1 = 0.0;
                                tempX1 = this.Gbus.get(Hcol, jj2) * Math.cos(this.SE_D.get(jj2) - this.SE_D.get(Hcol));
                                tempX1 += this.Bbus.get(Hcol, jj2) * Math.sin(this.SE_D.get(jj2) - this.SE_D.get(Hcol));
                                tempX2 += (tempX1 *= this.SE_V.get(jj2));
                            }
                            tempX1 = this.SE_V.get(Hcol) * this.Gbus.get(Hcol, Hcol);
                            tempX3 = this.SE_V.get(Hcol) * tempX2;
                            this.SE_H.set(Hrow, Hcol + this.numnod, tempX2 + tempX1);
                            this.SE_h.set(Hrow, tempX3);
                            continue block19;
                        }
                        tempX1 = 0.0;
                        ii = this.Zbus1[Hrow];
                        jj = Hcol;
                        tempX1 = this.Gbus.get(ii, jj) * Math.cos(this.SE_D.get(jj) - this.SE_D.get(ii));
                        tempX1 += this.Bbus.get(ii, jj) * Math.sin(this.SE_D.get(jj) - this.SE_D.get(ii));
                        this.SE_H.set(Hrow, Hcol + this.numnod, tempX1 *= this.SE_V.get(ii));
                        continue block19;
                    }
                    case 3: {
                        if (this.Zbus1[Hrow] == Hcol) {
                            tempX2 = 0.0;
                            for (jj2 = 0; jj2 < this.numnod; ++jj2) {
                                tempX1 = 0.0;
                                tempX1 = this.Gbus.get(Hcol, jj2) * Math.sin(this.SE_D.get(Hcol) - this.SE_D.get(jj2));
                                tempX1 -= this.Bbus.get(Hcol, jj2) * Math.cos(this.SE_D.get(Hcol) - this.SE_D.get(jj2));
                                tempX2 += (tempX1 *= this.SE_V.get(jj2));
                            }
                            tempX1 = this.SE_V.get(Hcol) * this.Bbus.get(Hcol, Hcol);
                            tempX3 = this.SE_V.get(Hcol) * tempX2;
                            this.SE_H.set(Hrow, Hcol + this.numnod, -(tempX2 - tempX1));
                            this.SE_h.set(Hrow, -tempX3);
                            continue block19;
                        }
                        tempX1 = 0.0;
                        ii = this.Zbus1[Hrow];
                        jj = Hcol;
                        tempX1 = this.Gbus.get(ii, jj) * Math.sin(this.SE_D.get(ii) - this.SE_D.get(jj));
                        tempX1 -= this.Bbus.get(ii, jj) * Math.cos(this.SE_D.get(ii) - this.SE_D.get(jj));
                        this.SE_H.set(Hrow, Hcol + this.numnod, -(tempX1 *= this.SE_V.get(ii)));
                        continue block19;
                    }
                    case 4: {
                        if (this.Zbus1[Hrow] == Hcol) {
                            tempX1 = 0.0;
                            ii = this.Zbus1[Hrow];
                            jj = this.Zbus2[Hrow];
                            tempX1 = this.Gbus.get(ii, jj) * Math.cos(this.SE_D.get(ii) - this.SE_D.get(jj));
                            tempX1 += this.Bbus.get(ii, jj) * Math.sin(this.SE_D.get(ii) - this.SE_D.get(jj));
                            tempX2 = 2.0 * this.SE_V.get(ii) * this.Gbus.get(ii, jj);
                            this.SE_H.set(Hrow, Hcol + this.numnod, (tempX1 *= this.SE_V.get(jj)) - tempX2);
                            continue block19;
                        }
                        if (this.Zbus2[Hrow] == Hcol) {
                            tempX1 = 0.0;
                            ii = this.Zbus1[Hrow];
                            jj = this.Zbus2[Hrow];
                            tempX1 = this.Gbus.get(ii, jj) * Math.cos(this.SE_D.get(ii) - this.SE_D.get(jj));
                            tempX1 += this.Bbus.get(ii, jj) * Math.sin(this.SE_D.get(ii) - this.SE_D.get(jj));
                            tempX2 = this.Gbus.get(ii, jj) * this.SE_V.get(ii) * this.SE_V.get(ii);
                            tempX3 = (tempX1 *= this.SE_V.get(ii)) * this.SE_V.get(jj);
                            this.SE_H.set(Hrow, Hcol + this.numnod, tempX1);
                            this.SE_h.set(Hrow, tempX3 - tempX2);
                            continue block19;
                        }
                        if (this.Zbus1[Hrow] == Hcol || this.Zbus2[Hrow] == Hcol) continue block19;
                        tempX1 = 0.0;
                        this.SE_H.set(Hrow, Hcol + this.numnod, tempX1);
                        continue block19;
                    }
                    case 5: {
                        if (this.Zbus1[Hrow] == Hcol) {
                            tempX1 = 0.0;
                            ii = this.Zbus1[Hrow];
                            jj = this.Zbus2[Hrow];
                            tempX1 = this.Gbus.get(ii, jj) * Math.sin(this.SE_D.get(ii) - this.SE_D.get(jj));
                            tempX1 -= this.Bbus.get(ii, jj) * Math.cos(this.SE_D.get(ii) - this.SE_D.get(jj));
                            tempX2 = 2.0 * this.SE_V.get(ii) * this.Bbus.get(ii, jj);
                            this.SE_H.set(Hrow, Hcol + this.numnod, (tempX1 *= this.SE_V.get(jj)) + tempX2);
                            continue block19;
                        }
                        if (this.Zbus2[Hrow] == Hcol) {
                            tempX1 = 0.0;
                            ii = this.Zbus1[Hrow];
                            jj = this.Zbus2[Hrow];
                            tempX1 = this.Gbus.get(ii, jj) * Math.sin(this.SE_D.get(ii) - this.SE_D.get(jj));
                            tempX1 -= this.Bbus.get(ii, jj) * Math.cos(this.SE_D.get(ii) - this.SE_D.get(jj));
                            tempX2 = this.Bbus.get(ii, jj) * this.SE_V.get(ii) * this.SE_V.get(ii);
                            tempX3 = (tempX1 *= this.SE_V.get(ii)) * this.SE_V.get(jj);
                            this.SE_H.set(Hrow, Hcol + this.numnod, tempX1);
                            this.SE_h.set(Hrow, tempX2 + tempX3);
                            continue block19;
                        }
                        if (this.Zbus1[Hrow] == Hcol || this.Zbus2[Hrow] == Hcol) continue block19;
                        tempX1 = 0.0;
                        this.SE_H.set(Hrow, Hcol + this.numnod, tempX1);
                    }
                }
            }
        }
    }

    public void updateState(DenseDoubleMatrix2D Xx) {
        int counter = 0;
        for (int iii = 0; iii < this.numnod; ++iii) {
            if (iii != this.indic_bSL) {
                this.SE_D.set(iii, this.SE_D.get(iii) + Xx.get(counter, 0));
                ++counter;
            } else {
                this.SE_D.set(iii, 0.0);
            }
            this.SE_V.set(iii, this.SE_V.get(iii) + Xx.get(iii + this.numnod - 1, 0));
        }
    }

    public void getZsort() {
        int kk;
        int[] order = new int[this.Z.size()];
        int pos = 0;
        int[] mType = new int[]{4, 2, 5, 3, 1};
        for (int m = 0; m < 5; ++m) {
            for (int kk2 = 0; kk2 < this.Z.size(); ++kk2) {
                if (this.Ztype[kk2] != mType[m]) continue;
                order[pos] = kk2;
                ++pos;
            }
        }
        DenseDoubleMatrix1D Zs = new DenseDoubleMatrix1D(this.Z.toArray());
        DenseDoubleMatrix2D Ws = new DenseDoubleMatrix2D(this.W.toArray());
        String[] ZprobeS = new String[this.Z.size()];
        int[] ZtypeS = new int[this.Z.size()];
        int[] Zbus1S = new int[this.Z.size()];
        int[] Zbus2S = new int[this.Z.size()];
        for (kk = 0; kk < this.Z.size(); ++kk) {
            Zs.set(kk, this.Z.get(order[kk]));
            Ws.set(kk, kk, this.W.get(order[kk], order[kk]));
            ZprobeS[kk] = this.Zprobe[order[kk]];
            ZtypeS[kk] = this.Ztype[order[kk]];
            Zbus1S[kk] = this.Zbus1[order[kk]];
            Zbus2S[kk] = this.Zbus2[order[kk]];
        }
        for (kk = 0; kk < this.Z.size(); ++kk) {
            this.Z.set(kk, Zs.get(kk));
            this.W.set(kk, kk, Ws.get(kk, kk));
            this.Zprobe[kk] = ZprobeS[kk];
            this.Ztype[kk] = ZtypeS[kk];
            this.Zbus1[kk] = Zbus1S[kk];
            this.Zbus2[kk] = Zbus2S[kk];
        }
    }

    public DenseDoubleMatrix2D getHaa() throws Exception {
        int validMeasure = 0;
        for (int kk = 0; kk < this.Z.size(); ++kk) {
            if (this.Ztype[kk] != 2 && this.Ztype[kk] != 4) continue;
            ++validMeasure;
        }
        if (validMeasure < 1) {
            this.javaSE_Error("Not enough power measurements to run Observability Test. Insert at least one Power Measurement");
        }
        DenseDoubleMatrix2D auxHaa = new DenseDoubleMatrix2D(validMeasure, this.numnod);
        validMeasure = 0;
        for (int kk = 0; kk < this.Z.size(); ++kk) {
            if (this.Ztype[kk] != 2 && this.Ztype[kk] != 4) continue;
            for (int mm = 0; mm < this.numnod; ++mm) {
                auxHaa.set(validMeasure, mm, this.SE_H.get(kk, mm));
            }
            ++validMeasure;
        }
        return auxHaa;
    }

    public double chiSquareTest(int freedomDegrees, double testedValue) {
        DRand DR = new DRand();
        ChiSquare ChSq = new ChiSquare((double)freedomDegrees, (RandomEngine)DR);
        return ChSq.cdf(testedValue);
    }

    public void perturbZ() {
        DRand DR = new DRand();
        Normal gsNs = new Normal(0.0, this.noiseSD, (RandomEngine)DR);
        double tempNum = 0.0;
        double tempNoise = 0.0;
        for (int kk = 0; kk < this.Z.size(); ++kk) {
            tempNoise = gsNs.nextDouble();
            tempNum = this.Z.get(kk);
            this.Z.set(kk, tempNum + tempNoise);
        }
    }

    private double getFromDB(String ProbeName, String valueType) throws SQLException {
        String message;
        double resultado = 0.0;
        try {
            probeDB = this.openDataBase("Probe");
            probeDB.setAutoCommit(true);
        }
        catch (Exception e) {
            message = e.toString();
            System.out.println("Open Probe Database error:" + e);
        }
        try {
            this.stmt = probeDB.createStatement();
            this.rs = this.stmt.executeQuery("SELECT " + valueType + " FROM Probe" + " WHERE (Name = '" + ProbeName + "')");
            this.moreRs = this.rs.next();
            if (this.moreRs) {
                resultado = this.rs.getDouble(valueType);
            }
        }
        catch (Exception e) {
            message = e.toString();
            System.out.println("Open Probe Database error:" + e);
        }
        if (!this.moreRs) {
            System.out.println("DATABASE ERROR: " + ProbeName + " has no " + valueType + " data");
        }
        this.rs.close();
        this.stmt.close();
        return resultado;
    }

    private void NewtonRaphson() throws Exception {
        int numIter = 1;
        double residual = 0.0;
        Functions F = Functions.functions;
        Algebra ALG = new Algebra();
        this.residualHistory = new double[1][this.maxIter];
        this.residualIteration = new String[this.maxIter];
        Integer stringIter = new Integer(0);
        this.myPrintStream.println("\n Matriz de admitancia");
        JavaSE.printMatrix(this.myPrintStream, this.Ybus, this.numnod, this.numnod);
        if (!this.runSE) {
            this.maxIter = 1;
        }
        while (numIter < this.maxIter + 1 && this.status == "ok") {
            this.myPrintStream.println("-----Iteration number: " + numIter + " of: " + this.maxIter + " -----");
            this.SE_H = new DenseDoubleMatrix2D(this.Z.size(), 2 * this.numnod);
            this.fillJacobian();
            JavaSE.printMatrix(this.myPrintStream, this.SE_h, "h(x)");
            JavaSE.printMatrix(this.myPrintStream, this.SE_H, "H(x)");
            this.SE_H = this.deleteColumn(this.SE_H, this.indic_bSL);
            JavaSE.printMatrix(this.myPrintStream, this.SE_H, "H(x) no slack");
            DenseDoubleMatrix2D HtW = (DenseDoubleMatrix2D)ALG.mult(ALG.transpose((DoubleMatrix2D)this.SE_H), (DoubleMatrix2D)this.W);
            DenseDoubleMatrix2D G = (DenseDoubleMatrix2D)ALG.mult((DoubleMatrix2D)HtW, (DoubleMatrix2D)this.SE_H);
            for (int fil = 0; fil < G.rows(); ++fil) {
                for (int cols = 0; cols < G.columns(); ++cols) {
                    if (fil != cols) continue;
                    G.set(fil, cols, G.get(fil, cols) + 0.001);
                }
            }
            JavaSE.printMatrix(this.myPrintStream, G, "G(x)");
            DenseDoubleMatrix1D dZ = (DenseDoubleMatrix1D)this.Z.copy();
            dZ.assign((DoubleMatrix1D)this.SE_h, Functions.minus);
            JavaSE.printMatrix(this.myPrintStream, this.Z, "Z");
            JavaSE.printMatrix(this.myPrintStream, this.SE_h, "h(x)");
            JavaSE.printMatrix(this.myPrintStream, dZ, "dZ(x)");
            residual = ALG.mult((DoubleMatrix1D)dZ, ALG.mult((DoubleMatrix2D)this.W, (DoubleMatrix1D)dZ));
            this.myPrintStream.println("Residual function J(x)=|W\u00b7dZ^2|= " + residual + ", iteration: " + numIter + ", m=" + this.numZ);
            this.residualHistory[0][numIter - 1] = residual;
            this.residualIteration[numIter - 1] = Integer.toString(numIter);
            if (residual < this.tolerance) {
                this.maxIter = numIter;
            }
            try {
                DenseDoubleMatrix2D X = (DenseDoubleMatrix2D)ALG.solve((DoubleMatrix2D)G, ALG.mult((DoubleMatrix2D)HtW, (DoubleMatrix2D)this.convert2D(dZ)));
                JavaSE.printMatrix(this.myPrintStream, X, "X");
                this.updateState(X);
            }
            catch (Exception e) {
                System.out.println(e.toString() + " Numerically unobservable system, on iteration " + numIter);
                this.status = "Numerically unobservable";
            }
            JavaSE.printMatrix(this.myPrintStream, this.SE_D, "Angle");
            JavaSE.printMatrix(this.myPrintStream, this.SE_V, "Voltage");
            ++numIter;
        }
    }

    private void observableIslands() throws Exception {
        int Ii;
        int obsNodes = 0;
        int unobsNodes = 0;
        int[] pivots = new int[this.numnod];
        Functions F = Functions.functions;
        Algebra ALG = new Algebra();
        boolean count = false;
        int con1 = 10000;
        int con2 = 10000;
        this.unObsBranch = new Vector();
        System.out.println("starting observable island detection");
        this.SE_H = new DenseDoubleMatrix2D(this.Z.size(), 2 * this.numnod);
        this.fillJacobian();
        DenseDoubleMatrix2D Haa = this.getHaa();
        JavaSE.printMatrix(this.myPrintStream, Haa, "Haa");
        DenseDoubleMatrix2D Gaa = (DenseDoubleMatrix2D)ALG.mult((DoubleMatrix2D)((DenseDoubleMatrix2D)ALG.transpose((DoubleMatrix2D)Haa)), (DoubleMatrix2D)Haa);
        LUDecomposition myLUD = new LUDecomposition((DoubleMatrix2D)Gaa);
        JavaSE.printMatrix(this.myPrintStream, Gaa, "Gaa");
        DenseDoubleMatrix2D U = (DenseDoubleMatrix2D)myLUD.getU();
        JavaSE.printMatrix(this.myPrintStream, (DenseDoubleMatrix2D)myLUD.getU(), "U");
        int[] gPermut = myLUD.getPivot();
        JavaSE.printVector(this.myPrintStream, gPermut, gPermut.length);
        for (int pv = 0; pv < Gaa.rows(); ++pv) {
            int rp;
            if (Math.abs(U.get(pv, pv)) > 10.0) {
                for (rp = 0; rp < gPermut.length; ++rp) {
                    if (gPermut[rp] != pv) continue;
                    pivots[obsNodes] = rp;
                }
                ++obsNodes;
                continue;
            }
            for (rp = 0; rp < gPermut.length; ++rp) {
                if (gPermut[rp] != pv) continue;
                pivots[this.numnod - 1 - unobsNodes] = rp;
            }
            ++unobsNodes;
        }
        DenseDoubleMatrix2D G11 = new DenseDoubleMatrix2D(obsNodes, obsNodes);
        DenseDoubleMatrix2D G12 = new DenseDoubleMatrix2D(obsNodes, unobsNodes);
        for (Ii = 0; Ii < obsNodes; ++Ii) {
            int Jj;
            for (Jj = 0; Jj < obsNodes; ++Jj) {
                G11.set(Ii, Jj, Gaa.get(pivots[Ii], pivots[Jj]));
            }
            for (Jj = obsNodes; Jj < this.numnod; ++Jj) {
                G12.set(Ii, Jj - obsNodes, Gaa.get(pivots[Ii], pivots[Jj]));
            }
        }
        JavaSE.printMatrix(this.myPrintStream, G11, "G11");
        JavaSE.printMatrix(this.myPrintStream, G12, "G12");
        DenseDoubleMatrix2D Oa = new DenseDoubleMatrix2D(obsNodes, 1);
        DenseDoubleMatrix2D Ob = new DenseDoubleMatrix2D(unobsNodes, 1);
        for (Ii = 0; Ii < unobsNodes; ++Ii) {
            Ob.set(Ii, 0, (double)((Ii + 2) * 2));
        }
        Oa = (DenseDoubleMatrix2D)ALG.mult(ALG.inverse((DoubleMatrix2D)G11), ALG.mult((DoubleMatrix2D)G12, (DoubleMatrix2D)Ob)).assign(Functions.mult((double)-1.0));
        this.Oo = new DenseDoubleMatrix2D(this.numnod, 1);
        for (Ii = 0; Ii < obsNodes; ++Ii) {
            this.Oo.set(pivots[Ii], 0, Oa.get(Ii, 0));
        }
        for (Ii = obsNodes; Ii < this.numnod; ++Ii) {
            this.Oo.set(pivots[Ii], 0, Ob.get(Ii - obsNodes, 0));
        }
        JavaSE.printMatrix(this.myPrintStream, this.Oo, "Oo");
        for (int ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
            ndb_branch TempBran;
            ndb_comp TempNdb_comp;
            comp TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
            if (!(TempComponent instanceof ndb_comp) || !(TempNdb_comp = (ndb_comp)TempComponent).getctrla().equals(this.ctrla) && !this.ctrla.equals("ALL CONTROL AREAS") || !TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice() || !(TempComponent instanceof ndb_branch) || (con1 = this.numbus((TempBran = (ndb_branch)TempComponent).getcon1())) <= -1 || (con2 = this.numbus(TempBran.getcon2())) <= -1 || !(Math.abs(this.Oo.get(con1, 0) - this.Oo.get(con2, 0)) > 0.5)) continue;
            this.unObsBranch.addElement(TempBran);
            this.status = "Unobservable";
            System.out.println(TempComponent.getName() + "  Detected");
        }
    }

    private void getObservableBranches() {
        int ix;
        if (this.MyJSEVFrame == null) {
            this.MyJSEVFrame = new JavaSEVisualFrame(this.mySch);
        } else {
            this.MyJSEVFrame.setVisible(true);
        }
        boolean count = false;
        int con1 = 10000;
        int con2 = 10000;
        boolean cnbr = false;
        Color ObsColor = Color.yellow;
        Color unObsColor = Color.red;
        for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
            comp TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
            if (!TempComponent.getactive() || !TempComponent.getinservice() || !(TempComponent instanceof ndb_comp)) continue;
            ndb_comp TempNdb_comp = (ndb_comp)TempComponent;
            ndb_comp.Color1 = ObsColor;
            ndb_comp.Color2 = ObsColor;
            ndb_comp.Color3 = ObsColor;
            TempNdb_comp.setAlternatekv_Color(ObsColor);
        }
        for (ix = 0; ix < this.unObsBranch.size(); ++ix) {
            ndb_branch TempBran = (ndb_branch)this.unObsBranch.elementAt(ix);
            System.out.println(TempBran.getName() + " Unobservable");
            TempBran.setAlternatekv_Color(unObsColor);
        }
    }

    private void convergenceReport() {
        this.seriesLabel = new String[1];
        this.seriesLabel[0] = "J(x) Residual evolution";
        this.graphLabel = new String[3];
        this.graphLabel[0] = "Residual function evolution";
        this.graphLabel[1] = "Iteration number";
        this.graphLabel[2] = "Residual \n function";
        this.myMChartFrame = new DEMainChartFrame(this.deepEdApp, "DeepEdit Desktop Chart Window");
        this.myMChartFrame.addChart("Convergence report", this.myMChartFrame.makeDefLineChart(this.residualHistory, this.seriesLabel, this.residualIteration, this.graphLabel), null);
        this.myMChartFrame.setVisible(true);
    }

    private void badDataTest() {
        if (this.numZ - (2 * this.numnod - 1) > 0) {
            int freeDg = this.numZ - 2 * this.numnod - 1;
            double ChSqr = 100.0 * this.chiSquareTest(freeDg, this.residualHistory[0][this.maxIter - 1]);
            this.myPrintStream.println("\nChi-square Bad-Data Test Results:");
            this.myPrintStream.println("   Residual     J(x)=|W\u00b7dZ^2| = " + StringUtil.numformat(this.residualHistory[0][this.maxIter - 1], 6, 2) + "\n   Prob. of Non-Gaussean meas.= " + StringUtil.numformat(ChSqr, 3, 2) + "%" + "\n");
        } else {
            double ChSqr = -1.0;
            this.myPrintStream.println("\nX-square test");
            this.myPrintStream.println("   not enough measures Residual =" + this.Z.size() + " ChiSquare test result=" + ChSqr + "%");
        }
    }

    void javaSE_Error(String mensaje) throws JavaSEException {
        StringTokenizer st = new StringTokenizer(mensaje, ":");
        mensaje = st.nextToken();
        throw new JavaSEException(mensaje);
    }

    void javaSE_Warning(String mensaje) {
        System.out.println(mensaje);
    }

    public Connection openDataBase(String DBName) throws SQLException {
        System.out.println("---------- In " + DBName + " ------------");
        try {
            Class.forName("sun.jdbc.odbc.JdbcOdbcDriver");
        }
        catch (Exception e) {
            String message = e.toString();
            System.out.println("Open Probe Database error:" + e);
        }
        String dsn = "jdbc:odbc:" + DBName;
        String user = "Administrator";
        String password = "lilo";
        return DriverManager.getConnection(dsn, user, password);
    }

    private DenseDoubleMatrix2D convert2D(DenseDoubleMatrix1D v1D) {
        DenseDoubleMatrix2D v2D = new DenseDoubleMatrix2D(v1D.size(), 1);
        for (int rrr = 0; rrr < v1D.size(); ++rrr) {
            v2D.set(rrr, 0, v1D.get(rrr));
        }
        return v2D;
    }

    private DenseDoubleMatrix2D deleteColumn(DenseDoubleMatrix2D mJ, int column) {
        DenseDoubleMatrix2D mJr = new DenseDoubleMatrix2D(mJ.rows(), mJ.columns() - 1);
        int delCol = 0;
        for (int j = 0; j < mJ.columns(); ++j) {
            if (j == column) continue;
            for (int i = 0; i < mJ.rows(); ++i) {
                mJr.set(i, delCol, mJ.get(i, j));
            }
            ++delCol;
        }
        return mJr;
    }

    private DenseDoubleMatrix2D deleteRow(DenseDoubleMatrix2D mJ, int row) {
        DenseDoubleMatrix2D mJr = new DenseDoubleMatrix2D(mJ.rows() - 1, mJ.columns());
        int delRow = 0;
        for (int i = 0; i < mJ.rows(); ++i) {
            if (i == row) continue;
            for (int j = 0; j < mJ.columns(); ++j) {
                mJr.set(delRow, j, mJ.get(i, j));
            }
            ++delRow;
        }
        return mJr;
    }

    public static void printMatrix(PrintWriter myPrintStream, Complex[][] m, int ii, int jj) {
        String plus_minus = " +";
        for (int i = 0; i < ii; ++i) {
            for (int j = 0; j < jj; ++j) {
                plus_minus = m[i][j].im > 0.0 ? " +" : " ";
                myPrintStream.print(StringUtil.numformat(m[i][j].re, 5, 2) + plus_minus + StringUtil.numformat(m[i][j].im, 5, 2) + "\t \t");
            }
            myPrintStream.println();
        }
        myPrintStream.println();
    }

    public static void printMatrix(PrintWriter myPrintStream, DenseDoubleMatrix2D m, String TitleOf) {
        myPrintStream.println(TitleOf);
        for (int rri = 0; rri < m.rows(); ++rri) {
            for (int ccj = 0; ccj < m.columns(); ++ccj) {
                myPrintStream.print(StringUtil.numformat(m.get(rri, ccj), 11, 2) + "\t");
            }
            myPrintStream.println();
        }
        myPrintStream.println();
    }

    public static void printMatrix(PrintWriter myPrintStream, DenseDoubleMatrix1D m, String TitleOf) {
        myPrintStream.println(TitleOf);
        for (int rri = 0; rri < m.size(); ++rri) {
            myPrintStream.print(StringUtil.numformat(m.get(rri), 11, 5));
            myPrintStream.println();
        }
        myPrintStream.println();
    }

    public static void printVector(PrintWriter myPrintStream, int[] v, int ii) {
        for (int i = 0; i < ii; ++i) {
            myPrintStream.print(i + "\t" + v[i] + "\t");
            myPrintStream.println();
        }
        myPrintStream.println();
    }

    public void printStateVector(PrintWriter myPrintStream, DenseDoubleMatrix1D Z, DenseDoubleMatrix2D W) {
        String[] textProbe = new String[]{"V ", "P ", "Q ", "Pf", "Qf"};
        Busbar TempBusbar = null;
        myPrintStream.println("\nZprobe       Z      W    Ztype     Zbus1-->Zbus2   Busbar1--->Busbar2");
        for (int mm = 0; mm < this.Zprobe.length; ++mm) {
            String Busbar2;
            TempBusbar = (Busbar)this.BusbarVector.elementAt(this.Zbus1[mm]);
            String Busbar1 = TempBusbar.getName();
            if (this.Zbus2[mm] == -1) {
                Busbar2 = "";
            } else {
                TempBusbar = (Busbar)this.BusbarVector.elementAt(this.Zbus2[mm]);
                Busbar2 = TempBusbar.getName();
            }
            myPrintStream.println(StringUtil.strformat(this.Zprobe[mm], 8) + "  " + StringUtil.numformat(Z.get(mm), 6, 4) + "  " + StringUtil.numformat(W.get(mm, mm), 5, 0) + "    " + StringUtil.strformat(textProbe[this.Ztype[mm] - 1], 5) + "    " + StringUtil.numformat(this.Zbus1[mm], 3, 0) + "     " + StringUtil.numformat(this.Zbus2[mm], 3, 0) + "      " + StringUtil.strformat(Busbar1, 8) + "  " + StringUtil.strformat(Busbar2, 8));
        }
        myPrintStream.println("");
    }
}

