/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import VisualNumerics.math.Complex;
import de.core.AnalysisTool;
import de.core.Busbar;
import de.core.CFuzzytra;
import de.core.DeepEdit;
import de.core.DeepEditFrame;
import de.core.Generator;
import de.core.Injection;
import de.core.JavaLFException;
import de.core.JavaLFFuzzyFrame;
import de.core.Line;
import de.core.Load;
import de.core.Schematic;
import de.core.SimpleDialog;
import de.core.Trafo;
import de.core.comp;
import de.core.ndb_1pol;
import de.core.ndb_branch;
import de.core.ndb_comp;
import de.core.ndb_inj;
import de.utils.StringUtil;
import drasys.or.linear.algebra.Algebra;
import drasys.or.linear.algebra.CroutPivot;
import drasys.or.matrix.DenseVector;
import drasys.or.matrix.MatrixI;
import drasys.or.matrix.SparseMatrix;
import drasys.or.matrix.VectorI;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.StringTokenizer;
import java.util.Vector;

public final class JavaLFFuzzy
extends AnalysisTool {
    JavaLFFuzzyFrame MyJavaLFFuzzyFrame = null;
    String ctrla = null;
    Complex[][] Ybus;
    protected Vector BusbarVector;
    protected Vector GeneratorVector;
    protected Vector LoadVector;
    protected Vector LineVector;
    protected Vector TrafoVector;
    double[] BranchR;
    double[] BranchX;
    double[] BranchB;
    int[] BranchI;
    int[] BranchJ;
    int numbran = 0;
    boolean retriang = false;
    boolean repconv = true;
    boolean verifQlim = true;
    private double[] Pinj;
    private double[] Qinj;
    private double[] QGmin;
    private double[] QGmax;
    private double[][] deltaP;
    private double[][] deltaQ;
    private double[][] deltaV;
    private double[][] deltaGra;
    private int[] tipobarra;
    private int indic_bSL = -1;
    private int[] indic_bPX;
    private int[] indic_bPQ;
    private int[] indic_bPV;
    private int[] indic_bsetPV;
    private int[] indic_bvQ;
    private int numload = 0;
    private int numgen = 0;
    private double[] volt_state;
    private double[] delta_state;
    private double angref = 0.0;
    private SparseMatrix Gbus;
    private SparseMatrix Bbus;
    private boolean[][] matCx;
    private double tol = 1.0E-4;
    final double tolaj = 0.01;
    final int nmaxiter = 50;
    final double tresh = 1.0E-10;
    final double eliminador = 1.0E200;
    final boolean flat_start = true;
    final double max_err_tol = 100.0;
    private double[] vk;
    private double[] vkAnt;
    private double[] dk;
    private double[] dkAnt;
    private double[] Dv;
    private double[] Ddv;
    private double[] Pdat;
    private double[] Pk;
    private double[] Qdat;
    private double[] Qk;
    private double[] DPv;
    private double[] DQv;
    private int itercount = 0;
    private int convergen = 0;
    private double max_err_volt = 10.0;
    private double max_err_delta = 10.0;
    private double max_err_P = 100.0;
    private double max_err_Q = 100.0;
    private String errorMsg = null;
    private SparseMatrix LFJ;
    private SparseMatrix RJ;
    private CroutPivot LU_LFJ;
    private CroutPivot LU_RJ;
    protected DeepEdit deepEdApp;
    boolean borrar = true;
    private double sref = 100.0;

    public JavaLFFuzzy(DeepEdit deepApplet, Schematic sch) {
        super(sch);
        this.deepEdApp = deepApplet;
        System.out.println("---------- Java Fuzzy Load Flow Started ------------");
        this.sref = this.getSref();
        if (this.MyJavaLFFuzzyFrame == null) {
            this.MyJavaLFFuzzyFrame = new JavaLFFuzzyFrame(this);
        } else {
            this.MyJavaLFFuzzyFrame.setVisible(true);
        }
    }

    public void Calculate(String cctrla) throws Exception {
        FileOutputStream os = null;
        String LFsal = WORK_FOLDER + File.separator + "JavaLFFuzzy.dat";
        this.ctrla = cctrla;
        long inicio = System.currentTimeMillis();
        DeepEdit.MySchematicPanel.repaint();
        String message = "Some problems, sorry!";
        try {
            AnalysisTool.CreateDirectory(WORK_FOLDER);
            os = new FileOutputStream(LFsal);
            this.getNetwork(os);
            this.calcular_LF(os);
            this.Valores_Fuzzy(os);
            if (this.convergen > 0) {
                this.Caculate_FLF();
                this.printMatrixDouble(os, this.deltaV, this.numnod, 5);
                this.printMatrixDouble(os, this.deltaGra, this.numnod, 5);
                this.grabaVoltajes();
                this.CalculaFlujos(os);
            }
            switch (this.convergen) {
                case 2: {
                    message = "Convergence Reached";
                    break;
                }
                case 1: {
                    message = "Partial Convergence Reached";
                    break;
                }
                case -1: {
                    message = "Convergence not Reached !";
                    break;
                }
                case -2: {
                    message = "Algorithm Diverges !";
                    break;
                }
                default: {
                    message = "Out of Range Results !";
                }
            }
            System.out.println(message);
            if (this.convergen > 0) {
                this.writeresults(os);
                this.listarResult(os);
                this.DoListResults(LFsal);
                this.ActSchematic.Modified = false;
                this.ActSchematic.Modifiedstate = false;
                this.ActSchematic.changeGIS = true;
                DeepEdit.MySchematicPanel.repaint();
            } else {
                if (this.repconv) {
                    this.DoListResults(LFsal);
                }
                String[] DlgButtons = new String[]{"OK"};
                SimpleDialog NoconvDialog = new SimpleDialog(DeepEdit.frame, "Java Fuzzy Load Flow", message, DlgButtons, 1, 0, 0, 2);
            }
            if (this.convergen > 0) {
                // empty if block
            }
            os.close();
        }
        catch (Exception e) {
            message = this.errorMsg != null ? this.errorMsg : e.toString();
            String[] DlgButtons = new String[]{"OK"};
            SimpleDialog ExceptionDialog = new SimpleDialog(DeepEdit.frame, "Java Fuzzy Load Flow", message, DlgButtons, 1, 0, 0, 1);
        }
        try {
            if (os != null) {
                os.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        this.finalize();
    }

    public void getNetwork(FileOutputStream os) throws Exception {
        ndb_inj TempInj;
        Line TempLine;
        ndb_comp TempNdb_comp;
        comp TempComponent;
        PrintWriter myPrintStream = new PrintWriter(os, true);
        int indicbus = 0;
        int ix = 0;
        int i = 0;
        int j = 0;
        int count = 0;
        int con1 = 10000;
        int con2 = 10000;
        this.BusbarVector = new Vector();
        this.GeneratorVector = new Vector();
        this.LoadVector = new Vector();
        this.LineVector = new Vector();
        this.TrafoVector = new Vector();
        double ueb = 0.0;
        double res = 0.0;
        double z = 0.0;
        double reac = 0.0;
        double y1 = 0.0;
        double y2 = 0.0;
        double b = 0.0;
        Complex auxc1 = new Complex(0.0, 0.0);
        this.numbran = 0;
        this.numnod = 0;
        for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
            TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
            if (!(TempComponent instanceof ndb_comp) || !(TempNdb_comp = (ndb_comp)TempComponent).getctrla().equals(this.ctrla) && !this.ctrla.equals("ALL CONTROL AREAS") || !TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice()) continue;
            if (TempComponent instanceof Busbar) {
                TempComponent.InformAllComponents();
                Busbar TempBusbar = (Busbar)TempComponent;
                if (this.numbus(TempComponent.getName()) != -1) {
                    this.javaLF_Error("There\u00b4s more than one busbar with name \"" + TempComponent.getName() + "\"");
                }
                this.BusbarVector.addElement(TempComponent);
                ++this.numnod;
                continue;
            }
            if (!(TempComponent instanceof ndb_branch)) continue;
            if (TempComponent instanceof Line) {
                TempLine = (Line)TempComponent;
                TempLine.InformPartner(TempLine.ConnComps1, TempLine.getx1(), TempLine.gety1(), 1);
                TempLine.InformPartner(TempLine.ConnComps2, TempLine.getx2(), TempLine.gety2(), 2);
                ++this.numlin;
            }
            if (TempComponent instanceof Trafo) {
                TempComponent.InformAllComponents();
                ++this.numtran;
            }
            ++this.numbran;
        }
        this.BranchR = new double[this.numbran];
        this.BranchX = new double[this.numbran];
        this.BranchB = new double[this.numbran];
        this.BranchI = new int[this.numbran];
        this.BranchJ = new int[this.numbran];
        this.slack = -1;
        this.ini_var_sist();
        indicbus = 0;
        int tipocomp = 0;
        String strcomp = "";
        if (this.numnod < 2) {
            this.javaLF_Error("Not valid System, Area or Editor");
        }
        for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
            int indice;
            Complex auxc2;
            TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
            if (!(TempComponent instanceof ndb_comp) || !(TempNdb_comp = (ndb_comp)TempComponent).getctrla().equals(this.ctrla) && !this.ctrla.equals("ALL CONTROL AREAS") || !TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice()) continue;
            if (TempComponent instanceof Line) {
                TempLine = (Line)TempComponent;
                this.LineVector.addElement(TempLine);
                con1 = this.numbus(TempLine.getcon1());
                if (con1 > -1 && (con2 = this.numbus(TempLine.getcon2())) > -1) {
                    this.BranchX[count] = TempLine.getxx1() * TempLine.getlen() * this.sref / (TempLine.getun1() * TempLine.getun1());
                    this.BranchR[count] = TempLine.getr1() * TempLine.getlen() * this.sref / (TempLine.getun1() * TempLine.getun1());
                    this.BranchB[count] = TempLine.getb1() * TempLine.getlen() / 2.0 / this.sref * (TempLine.getun1() * TempLine.getun1());
                    this.BranchI[count] = con1;
                    this.BranchJ[count] = con2;
                    auxc1 = new Complex(this.BranchR[count], this.BranchX[count]);
                    if (Complex.abs((Complex)auxc1) < 1.0E-9) {
                        this.javaLF_Error("Line \"" + TempLine.getName() + "\"" + ", too low Impedance.");
                    }
                    auxc2 = new Complex(1.0);
                    auxc1 = auxc2.divide(auxc1);
                    auxc2 = new Complex(0.0, this.BranchB[count]);
                    this.Ybus[this.BranchJ[count]][this.BranchI[count]].add(Complex.negate((Complex)auxc1));
                    this.Ybus[this.BranchI[count]][this.BranchJ[count]].add(Complex.negate((Complex)auxc1));
                    this.Ybus[this.BranchI[count]][this.BranchI[count]].add(Complex.add((Complex)auxc1, (Complex)auxc2));
                    this.Ybus[this.BranchJ[count]][this.BranchJ[count]].add(Complex.add((Complex)auxc1, (Complex)auxc2));
                    this.matCx[this.BranchJ[count]][this.BranchI[count]] = true;
                    this.matCx[this.BranchI[count]][this.BranchJ[count]] = true;
                    ++count;
                    continue;
                }
                this.javaLF_Error("Line \"" + TempLine.getName() + "\"" + ", is not connected");
                continue;
            }
            if (TempComponent instanceof Trafo) {
                Trafo TempTrafo = (Trafo)TempComponent;
                this.TrafoVector.addElement(TempTrafo);
                TempTrafo.actualizet();
                con1 = this.numbus(TempTrafo.getcon1());
                if (con1 > -1 && (con2 = this.numbus(TempTrafo.getcon2())) > -1) {
                    ueb = TempTrafo.getun1() / TempTrafo.getun2() / (TempTrafo.getur1() / TempTrafo.getur2());
                    res = TempTrafo.getpcu() * 0.001 * ueb * ueb / TempTrafo.getsn() * this.sref / TempTrafo.getsn();
                    z = TempTrafo.getuk() * 0.01 * ueb * ueb * this.sref / TempTrafo.getsn();
                    b = TempTrafo.geti0() * 0.01 * 0.5 / this.sref * TempTrafo.getsn();
                    reac = TempTrafo.getuk() >= 0.0 ? Math.sqrt(z * z - res * res) : -Math.sqrt(z * z - res * res);
                    this.BranchX[count] = reac;
                    this.BranchR[count] = res;
                    this.BranchB[count] = b;
                    this.BranchI[count] = con1;
                    this.BranchJ[count] = con2;
                    auxc1 = new Complex(this.BranchR[count], this.BranchX[count]);
                    if (Complex.abs((Complex)auxc1) < 1.0E-9) {
                        this.javaLF_Error("Trafo \"" + TempTrafo.getName() + "\"" + ", too low Impedance.");
                    }
                    auxc2 = new Complex(1.0);
                    auxc1 = Complex.divide((Complex)auxc2, (Complex)auxc1);
                    auxc2 = new Complex(0.0, this.BranchB[count]);
                    this.Ybus[this.BranchJ[count]][this.BranchI[count]].add(Complex.negate((Complex)Complex.divide((Complex)auxc1, (double)TempTrafo.gett_re())));
                    this.Ybus[this.BranchI[count]][this.BranchJ[count]].add(Complex.negate((Complex)Complex.divide((Complex)auxc1, (double)TempTrafo.gett_re())));
                    this.Ybus[this.BranchI[count]][this.BranchI[count]].add(Complex.add((Complex)auxc1, (Complex)auxc2).divide(TempTrafo.gett_re() * TempTrafo.gett_re()));
                    this.Ybus[this.BranchJ[count]][this.BranchJ[count]].add(Complex.add((Complex)auxc1, (Complex)auxc2));
                    this.matCx[this.BranchJ[count]][this.BranchI[count]] = true;
                    this.matCx[this.BranchI[count]][this.BranchJ[count]] = true;
                    ++count;
                    continue;
                }
                this.javaLF_Error("Trafo \"" + TempTrafo.getName() + "\"" + ", is not connected.");
                continue;
            }
            if (!(TempComponent instanceof ndb_1pol)) continue;
            TempComponent.InformAllComponents();
            ndb_1pol Temp1pol = (ndb_1pol)TempComponent;
            double p0 = -Temp1pol.getp0() / this.sref;
            double q0 = -Temp1pol.getq0() / this.sref;
            if (Temp1pol instanceof Busbar) {
                tipocomp = 0;
                strcomp = "Busbar";
                indice = indicbus++;
                continue;
            }
            indice = this.numbus(Temp1pol.getcon2());
            if (Temp1pol instanceof Load) {
                tipocomp = 1;
                strcomp = "Load";
                this.LoadVector.addElement(TempComponent);
                ++this.numload;
            } else if (Temp1pol instanceof Generator) {
                p0 = -p0;
                q0 = -q0;
                tipocomp = 4;
                strcomp = "Generator";
                this.GeneratorVector.addElement(TempComponent);
                ++this.numgen;
            } else if (Temp1pol instanceof Injection) {
                p0 = -p0;
                q0 = -q0;
                tipocomp = 5;
                strcomp = "Injection";
            } else {
                this.javaLF_Error("There\u00b4s an unknown componenet in system");
            }
            if (indice == -1) {
                this.javaLF_Error(strcomp + " \"" + Temp1pol.getName() + "\"" + ", is not properly connected.");
            }
            if (Temp1pol.getlf_type() != 4) {
                if (tipocomp == 4) {
                    if (Temp1pol.getlf_type() == 3) {
                        if (this.slack > -1) {
                            if (this.indic_bSL != indice) {
                                Generator TempGenerator = (Generator)this.ActSchematic.Components.elementAt(this.slack);
                                strcomp = TempGenerator.getName();
                                this.javaLF_Error("There\u00b4s more than one slack busbar \"" + Temp1pol.getName() + "\" " + "\"" + strcomp + "\"");
                            }
                        } else {
                            this.slack = ix;
                            this.indic_bSL = indice;
                            p0 = 0.0;
                        }
                    }
                    if (Temp1pol.getlf_type() > 1) {
                        this.tipobarra[indice] = Temp1pol.getlf_type();
                        TempInj = (ndb_inj)Temp1pol;
                        this.vk[indice] = TempInj.getus();
                        if (this.vk[indice] > 1.5 || this.vk[indice] < 0.5) {
                            this.javaLF_Warning("Voltaje impuesto en \"" + Temp1pol.getName() + "\" ");
                        }
                        q0 = 0.0;
                        if (TempInj.getqmin() >= TempInj.getqmax()) {
                            this.javaLF_Error(strcomp + " \"" + Temp1pol.getName() + "\"" + ", not valid rective generation limits.");
                        }
                        int n = indice;
                        this.QGmin[n] = this.QGmin[n] + TempInj.getqmin() / this.sref;
                        int n2 = indice;
                        this.QGmax[n2] = this.QGmax[n2] + TempInj.getqmax() / this.sref;
                    }
                }
                int n = indice;
                this.Pinj[n] = this.Pinj[n] + p0;
                int n3 = indice;
                this.Qinj[n3] = this.Qinj[n3] + q0;
                continue;
            }
            auxc1.re = -Temp1pol.getp0() / this.sref;
            auxc1.im = Temp1pol.getq0() / this.sref;
            this.Ybus[indice][indice].add(auxc1);
        }
        System.out.println("Initial load finished.");
        System.out.print("Verifying Cx...");
        this.verificarGrafo();
        System.out.println(" OK.");
        if (this.slack < 0) {
            this.javaLF_Error("there\u00b4s not slack busbar in system");
        }
        if ((TempComponent = (comp)this.ActSchematic.Components.elementAt(this.slack)) instanceof ndb_inj) {
            TempInj = (ndb_inj)TempComponent;
            this.angref = TempInj.getdelta_s() * Math.PI / 180.0;
        } else {
            this.javaLF_Error("The slack busbar isn't a generation busbar");
        }
        for (i = 0; i < this.numnod; ++i) {
            this.dk[i] = this.angref;
            if (this.tipobarra[i] != 1) continue;
            this.vk[i] = 1.0;
        }
        for (i = 0; i < this.numnod; ++i) {
            this.Pdat[i] = this.Pinj[i];
            this.Qdat[i] = this.Qinj[i];
            switch (this.tipobarra[i]) {
                case 1: {
                    this.indic_bPQ[0] = this.indic_bPQ[0] + 1;
                    this.indic_bPQ[this.indic_bPQ[0]] = i;
                    this.indic_bPX[0] = this.indic_bPX[0] + 1;
                    this.indic_bPX[this.indic_bPQ[0]] = i;
                    break;
                }
                case 2: {
                    this.indic_bPX[0] = this.indic_bPX[0] + 1;
                    this.indic_bPX[this.indic_bPX[0]] = i;
                    this.indic_bPV[0] = this.indic_bPV[0] + 1;
                    this.indic_bPV[this.indic_bPV[0]] = i;
                    break;
                }
                case 3: {
                    this.indic_bSL = i;
                    this.indic_bPV[0] = this.indic_bPV[0] + 1;
                    this.indic_bPV[this.indic_bPV[0]] = i;
                    break;
                }
                default: {
                    this.javaLF_Error("There\u00b4s an unknown type of busbar in system");
                }
            }
            for (j = 0; j < this.numnod; ++j) {
                if (this.Ybus[i][j].re != 0.0) {
                    this.Gbus.setElementAt(i, j, this.Ybus[i][j].re);
                    this.LFJ.setElementAt(i, j, 1.1);
                }
                if (this.Ybus[i][j].im == 0.0) continue;
                this.Bbus.setElementAt(i, j, this.Ybus[i][j].im);
                this.LFJ.setElementAt(i, j, 1.1);
            }
            for (j = 0; j < this.numnod; ++j) {
                if (this.Ybus[i][j].re == 0.0 && this.Ybus[i][j].im == 0.0) continue;
                this.LFJ.setElementAt(i, j + this.numnod, 1.1);
            }
        }
        for (i = 0; i <= this.indic_bPV[0]; ++i) {
            this.indic_bsetPV[i] = this.indic_bPV[i];
        }
        for (i = 0; i < this.numnod; ++i) {
            for (j = 0; j < this.numnod; ++j) {
                if (this.Ybus[i][j].re == 0.0 && this.Ybus[i][j].im == 0.0) continue;
                this.LFJ.setElementAt(i + this.numnod, j, 1.1);
            }
            for (j = 0; j < this.numnod; ++j) {
                if (this.Ybus[i][j].re == 0.0 && this.Ybus[i][j].im == 0.0) continue;
                this.LFJ.setElementAt(i + this.numnod, j + this.numnod, 1.1);
            }
        }
        this.RJ = new SparseMatrix((MatrixI)this.LFJ);
        this.Ybus = null;
    }

    public int numbus(String Busbarname) {
        for (int ix = 0; ix < this.BusbarVector.size(); ++ix) {
            comp TempComponent = (comp)this.BusbarVector.elementAt(ix);
            if (TempComponent.getName().hashCode() != Busbarname.hashCode() || !TempComponent.getName().equals(Busbarname)) continue;
            return ix;
        }
        return -1;
    }

    private void ini_var_sist() {
        int i;
        this.Ybus = new Complex[this.numnod][this.numnod];
        this.matCx = new boolean[this.numnod][this.numnod];
        for (i = 0; i < this.numnod; ++i) {
            for (int j = 0; j < this.numnod; ++j) {
                this.Ybus[i][j] = new Complex(0.0, 0.0);
            }
        }
        this.Pinj = new double[this.numnod];
        this.Qinj = new double[this.numnod];
        this.QGmin = new double[this.numnod];
        this.QGmax = new double[this.numnod];
        this.tipobarra = new int[this.numnod];
        this.indic_bPX = new int[this.numnod + 1];
        this.indic_bPQ = new int[this.numnod + 1];
        this.indic_bPV = new int[this.numnod + 1];
        this.indic_bvQ = new int[this.numnod + 1];
        this.indic_bsetPV = new int[this.numnod + 1];
        this.volt_state = new double[this.numnod];
        this.delta_state = new double[this.numnod];
        for (i = 0; i < this.numnod; ++i) {
            this.tipobarra[i] = 1;
            this.volt_state[i] = 1.0;
        }
        this.indic_bvQ[0] = 0;
        this.indic_bPV[0] = 0;
        this.indic_bPQ[0] = 0;
        this.indic_bPX[0] = 0;
        this.Gbus = new SparseMatrix(this.numnod, this.numnod);
        this.Bbus = new SparseMatrix(this.numnod, this.numnod);
        this.LFJ = new SparseMatrix(2 * this.numnod, 2 * this.numnod);
        this.LFJ.setEpsilon(1.0E-10);
        this.vk = new double[this.numnod];
        this.vkAnt = new double[this.numnod];
        this.dk = new double[this.numnod];
        this.dkAnt = new double[this.numnod];
        this.Dv = new double[this.numnod];
        this.Ddv = new double[this.numnod];
        this.Pdat = new double[this.numnod];
        this.Pk = new double[this.numnod];
        this.Qdat = new double[this.numnod];
        this.Qk = new double[this.numnod];
        this.DPv = new double[this.numnod];
        this.DQv = new double[this.numnod];
    }

    void javaLF_Error(String mensaje) throws JavaLFException {
        StringTokenizer st = new StringTokenizer(mensaje, ":");
        mensaje = st.nextToken();
        throw new JavaLFException(mensaje);
    }

    void javaLF_Warning(String mensaje) {
        System.out.println(mensaje);
    }

    private void calcular_LF(FileOutputStream os) throws Exception {
        int i;
        PrintWriter myPrintStream = new PrintWriter(os, true);
        DataInputStream inData = new DataInputStream(System.in);
        double[] auxun = new double[this.numnod];
        double max_err_med0 = 0.0;
        double max_err_med1 = 0.0;
        boolean seguir = true;
        boolean QgOK = false;
        boolean converge = false;
        boolean re3angonit = true;
        for (i = 0; i < this.numnod; ++i) {
            auxun[i] = 1.0;
        }
        QgOK = !this.verifQlim;
        System.out.println("\nJava Load Flow Applied to System: " + this.ActSchematic.getsysname());
        myPrintStream.println("Java Load Flow Applied to System: " + this.ActSchematic.getsysname());
        if (!this.ctrla.equals("ALL CONTROL AREAS")) {
            System.out.println("restricted to area: " + this.ctrla);
            myPrintStream.println("restricted to area: " + this.ctrla);
        }
        myPrintStream.println("\n\n");
        System.out.println("\n");
        System.out.println("\n\t\tCalculation Process Started");
        System.out.println("\t\t---------------------------");
        System.out.println("\nIn process Iteration: " + this.itercount);
        if (this.repconv) {
            myPrintStream.println("\n\t\t           Convergence Report");
            myPrintStream.println("\t\t           ------------------");
            myPrintStream.println("\nSatating calculus: " + this.itercount);
        }
        this.actualizar_PkQk(this.Pk, this.Qk, this.vk, this.dk, this.Gbus, this.Bbus);
        this.calc_desv_Pot(this.DPv, this.Pdat, this.Pk, this.vk);
        this.calc_desv_Pot(this.DQv, this.Qdat, this.Qk, this.vk);
        this.anularD_bPVSL(this.DPv, this.DQv, this.indic_bSL, this.indic_bPV);
        this.max_err_P = this.max_err(this.DPv, this.vk);
        this.max_err_Q = this.max_err(this.DQv, this.vk);
        max_err_med1 = Math.sqrt(this.max_err_P * this.max_err_P + this.max_err_Q * this.max_err_Q);
        System.out.println("* Maximum Mismatchs: P= " + StringUtil.numformat(this.max_err_P * this.sref, 11, 5) + " [MW], Q= " + StringUtil.numformat(this.max_err_Q * this.sref, 11, 5) + " [MVAR].");
        if (this.repconv) {
            myPrintStream.println("* Maximum Mismatchs: P= " + StringUtil.numformat(this.max_err_P * this.sref, 11, 5) + " [MW], Q= " + StringUtil.numformat(this.max_err_Q * this.sref, 11, 5) + " [MVAR].");
        }
        if (this.max_err_P < 0.01 && this.max_err_Q < 0.01) {
            seguir = false;
            this.convergen = 1;
        }
        while (this.convergen == 0) {
            if (QgOK && this.max_err_P < this.tol && this.max_err_Q < this.tol) {
                seguir = false;
                this.convergen = 2;
            }
            while (seguir) {
                ++this.itercount;
                System.out.println("\nIn process Iteration: " + this.itercount);
                if (this.repconv) {
                    myPrintStream.println("\nEvents on Iteration: " + this.itercount);
                }
                if (this.retriang || re3angonit) {
                    this.calcular_LFJ(this.LFJ, this.Bbus, this.Gbus, this.vk, this.dk, this.Pk, this.Qk);
                    this.elim_LFJ_bPVSL(this.LFJ, this.DPv, this.DQv, this.indic_bPV, this.indic_bSL);
                    this.printMatrixSM(os, this.LFJ);
                    if (this.repconv) {
                        myPrintStream.println("* LF Jacobian Matrix Calculated and Retringularized.");
                    }
                    try {
                        this.LU_LFJ = new CroutPivot((MatrixI)this.LFJ);
                    }
                    catch (Exception ex) {
                        String msg = new String(ex + "Singular Jacobian on iteration " + this.itercount);
                        this.javaLF_Error(msg);
                    }
                }
                this.sol_lin(this.LU_LFJ, this.LFJ, this.Dv, this.Ddv, this.DPv, this.DQv);
                this.vkAnt = this.vk;
                this.dkAnt = this.dk;
                this.actualizar_volt(this.vk, this.dk, this.Dv, this.Ddv);
                this.actualizar_PkQk(this.Pk, this.Qk, this.vk, this.dk, this.Gbus, this.Bbus);
                this.calc_desv_Pot(this.DPv, this.Pdat, this.Pk, this.vk);
                this.calc_desv_Pot(this.DQv, this.Qdat, this.Qk, this.vk);
                this.anularD_bPVSL(this.DPv, this.DQv, this.indic_bSL, this.indic_bPV);
                this.max_err_P = this.max_err(this.DPv, this.vk);
                this.max_err_Q = this.max_err(this.DQv, this.vk);
                System.out.println("* Maximum Mismatchs: P= " + StringUtil.numformat(this.max_err_P * this.sref, 11, 5) + " [MW], Q= " + StringUtil.numformat(this.max_err_Q * this.sref, 11, 5) + " [MVAR].");
                if (this.repconv) {
                    myPrintStream.println("* Maximum Mismatchs: P= " + StringUtil.numformat(this.max_err_P * this.sref, 11, 5) + " [MW], Q= " + StringUtil.numformat(this.max_err_Q * this.sref, 11, 5) + " [MVAR].");
                }
                max_err_med0 = max_err_med1;
                max_err_med1 = Math.sqrt(this.max_err_P * this.max_err_P + this.max_err_Q * this.max_err_Q);
                re3angonit = !(max_err_med1 / max_err_med0 < 0.5 && this.max_err_P < 0.5 && this.max_err_Q < 0.5);
                seguir = false;
                if (this.max_err_P < 0.01 && this.max_err_Q < 0.01) {
                    this.convergen = 1;
                    continue;
                }
                if (this.itercount > 50) {
                    this.convergen = -1;
                    continue;
                }
                if (this.max_err_P > 100.0 || this.max_err_Q > 100.0) {
                    this.convergen = -2;
                    continue;
                }
                seguir = true;
            }
            if (this.convergen != 1) continue;
            this.convergen = 0;
            seguir = true;
            if (QgOK) {
                if (!(this.max_err_P < this.tol) || !(this.max_err_Q < this.tol)) continue;
                this.convergen = 2;
                continue;
            }
            System.out.println("* Verifying Reactive Power Limits");
            if (this.repconv && this.verifQlim) {
                myPrintStream.print("* Verifying Reactive Power Limits: ");
            }
            myPrintStream.flush();
            QgOK = true;
            if (!QgOK) {
                re3angonit = true;
                this.calc_desv_Pot(this.DQv, this.Qdat, this.Qk, this.vk);
                this.anularD_bPVSL(this.DPv, this.DQv, this.indic_bSL, this.indic_bPV);
                this.max_err_Q = this.max_err(this.DQv, this.vk);
            }
            if (!this.repconv || !QgOK || !this.verifQlim) continue;
            myPrintStream.println(" OK !");
        }
        this.max_err_volt = this.max_err(this.Dv, auxun);
        for (i = 0; i < this.numnod; ++i) {
            this.Ddv[i] = this.Ddv[i] / this.vk[i];
        }
        this.max_err_delta = this.max_err(this.Ddv, auxun);
        System.out.println("Calculating Process Finished.");
        if (this.repconv) {
            myPrintStream.println("\n");
        }
    }

    private void actualizar_PkQk(double[] P, double[] Q, double[] volt, double[] ang, SparseMatrix G, SparseMatrix B) throws Exception {
        DenseVector e = new DenseVector(volt);
        DenseVector f = new DenseVector(volt);
        Algebra oper = new Algebra();
        try {
            int i;
            for (i = 0; i < volt.length; ++i) {
                e.setElementAt(i, volt[i] * Math.cos(ang[i]));
                f.setElementAt(i, volt[i] * Math.sin(ang[i]));
            }
            DenseVector eG = oper.multiply((MatrixI)G, (VectorI)e);
            DenseVector eB = oper.multiply((MatrixI)B, (VectorI)e);
            DenseVector fG = oper.multiply((MatrixI)G, (VectorI)f);
            DenseVector fB = oper.multiply((MatrixI)B, (VectorI)f);
            eG = oper.subtract((VectorI)eG, (VectorI)fB);
            eB = oper.add((VectorI)eB, (VectorI)fG);
            for (i = 0; i < volt.length; ++i) {
                P[i] = e.elementAt(i) * eG.elementAt(i) + f.elementAt(i) * eB.elementAt(i);
                Q[i] = f.elementAt(i) * eG.elementAt(i) - e.elementAt(i) * eB.elementAt(i);
            }
        }
        catch (Exception ex) {
            String msg = new String(ex + "on updating powers, incompatible dimensions");
            this.javaLF_Error(msg);
        }
    }

    private void calc_desv_Pot(double[] DXv, double[] Xdat, double[] X, double[] v) {
        for (int i = 0; i < v.length; ++i) {
            DXv[i] = (Xdat[i] - X[i]) / v[i];
        }
    }

    private void calc_var_Pot(double[] DXv, double[] Xdat, double[] X) {
        for (int i = 0; i < X.length; ++i) {
            DXv[i] = Xdat[i] - X[i];
        }
    }

    private void anularD_bPVSL(double[] DP2, double[] DQ, int bSL, int[] bPV) {
        DP2[bSL] = 0.0;
        for (int i = 1; i <= bPV[0]; ++i) {
            DQ[bPV[i]] = 0.0;
        }
    }

    private void actualizar_volt(double[] vnew, double[] dnew, double[] Deltav, double[] Deltadv) {
        for (int i = 0; i < vnew.length; ++i) {
            dnew[i] = dnew[i] + Deltadv[i] / vnew[i];
            vnew[i] = vnew[i] + Deltav[i];
        }
    }

    private void actualiza_VarVolt(double[] vact, double[] dact, double[] vnew, double[] dnew, double[] Deltav, double[] Deltadv, double[] Dv, double[] Dd) {
        for (int i = 0; i < vnew.length; ++i) {
            dnew[i] = dact[i] + Deltadv[i] / vact[i] + Dd[i];
            vnew[i] = vact[i] + Deltav[i] + Dv[i];
        }
    }

    private double max_err(double[] Desvv, double[] v) {
        double max = 0.0;
        for (int i = 0; i < v.length; ++i) {
            double aux = Math.abs(Desvv[i] * v[i]);
            if (!(aux > max)) continue;
            max = aux;
        }
        return max;
    }

    private void calcular_LFJ(SparseMatrix mJ, SparseMatrix B, SparseMatrix G, double[] v, double[] d, double[] P, double[] Q) {
        boolean mJijesNulo = true;
        double lij = 0.0;
        double nij = 0.0;
        double mij = 0.0;
        double hij = 0.0;
        for (int i = 0; i < v.length; ++i) {
            for (int j = 0; j < v.length; ++j) {
                if (i != j) {
                    boolean bl = mJijesNulo = B.isNull(i, j) && G.isNull(i, j);
                    if (!mJijesNulo) {
                        double sij = Math.sin(d[i] - d[j]);
                        double cij = Math.cos(d[i] - d[j]);
                        hij = G.elementAt(i, j) * sij - B.elementAt(i, j) * cij;
                        nij = G.elementAt(i, j) * cij + B.elementAt(i, j) * sij;
                        mij = -G.elementAt(i, j) * cij - B.elementAt(i, j) * sij;
                        lij = G.elementAt(i, j) * sij - B.elementAt(i, j) * cij;
                    }
                } else {
                    mJijesNulo = false;
                    hij = -B.elementAt(i, j) - Q[i] / (v[i] * v[i]);
                    nij = G.elementAt(i, j) + P[i] / (v[i] * v[i]);
                    mij = -G.elementAt(i, j) + P[i] / (v[i] * v[i]);
                    lij = -B.elementAt(i, j) + Q[i] / (v[i] * v[i]);
                }
                if (mJijesNulo) continue;
                mJ.setElementAt(i, j, hij);
                mJ.setElementAt(i, j + v.length, nij);
                mJ.setElementAt(i + v.length, j, mij);
                mJ.setElementAt(i + v.length, j + v.length, lij);
            }
        }
    }

    private void calcular_J(SparseMatrix mJ, SparseMatrix B, SparseMatrix G, double[] v, double[] d, double[] P, double[] Q, double[] DP2, double[] DQ) {
        boolean mJijesNulo = true;
        double lij = 0.0;
        double nij = 0.0;
        double mij = 0.0;
        double hij = 0.0;
        for (int i = 0; i < v.length; ++i) {
            for (int j = 0; j < v.length; ++j) {
                if (i != j) {
                    boolean bl = mJijesNulo = B.isNull(i, j) || G.isNull(i, j);
                    if (!mJijesNulo) {
                        double sij = Math.sin(d[i] - d[j]);
                        double cij = Math.cos(d[i] - d[j]);
                        hij = (G.elementAt(i, j) * sij - B.elementAt(i, j) * cij) * v[i] * v[j];
                        nij = (G.elementAt(i, j) * cij + B.elementAt(i, j) * sij) * v[i];
                        mij = (-G.elementAt(i, j) * cij - B.elementAt(i, j) * sij) * v[i] * v[j];
                        lij = (G.elementAt(i, j) * sij - B.elementAt(i, j) * cij) * v[i];
                    }
                } else {
                    mJijesNulo = false;
                    hij = -B.elementAt(i, j) * v[i] * v[i] - Q[i];
                    nij = G.elementAt(i, j) * v[i] + P[i] / v[i];
                    mij = -G.elementAt(i, j) * v[i] * v[i] + P[i];
                    lij = -B.elementAt(i, j) * v[i] + Q[i] / v[i];
                }
                if (mJijesNulo) continue;
                mJ.setElementAt(i, j, hij);
                mJ.setElementAt(i, j + v.length, nij);
                mJ.setElementAt(i + v.length, j, mij);
                mJ.setElementAt(i + v.length, j + v.length, lij);
            }
        }
        this.elim_LFJ_bPVSL(mJ, DP2, DQ, this.indic_bPV, this.indic_bSL);
    }

    private void elim_LFJ_bPVSL(SparseMatrix mJ, double[] auxDPv, double[] auxDQv, int[] indic_bPV, int indic_bSL) {
        for (int i = 1; i <= indic_bPV[0]; ++i) {
            mJ.setElementAt(indic_bPV[i] + this.numnod, indic_bPV[i] + this.numnod, 1.0E200);
            auxDQv[indic_bPV[i]] = 0.0;
        }
        mJ.setElementAt(indic_bSL, indic_bSL, 1.0E200);
        auxDPv[indic_bSL] = 0.0;
    }

    private void sol_lin(CroutPivot LU, SparseMatrix A, double[] v1, double[] v2, double[] p1, double[] p2) throws Exception {
        Algebra oper = new Algebra();
        DenseVector b = new DenseVector(2 * v1.length);
        DenseVector x = new DenseVector();
        DenseVector Db = new DenseVector();
        DenseVector Dx = new DenseVector();
        try {
            int i;
            for (i = 0; i < v1.length; ++i) {
                b.setElementAt(i, p1[i]);
                b.setElementAt(i + v1.length, p2[i]);
            }
            x = LU.solveEquations((VectorI)b);
            DenseVector bk = oper.multiply((MatrixI)A, (VectorI)x);
            Db = oper.subtract((VectorI)b, (VectorI)bk);
            Dx = LU.solveEquations((VectorI)Db);
            x = oper.add((VectorI)x, (VectorI)Dx);
            for (i = 0; i < v1.length; ++i) {
                v2[i] = x.elementAt(i);
                v1[i] = x.elementAt(i + v1.length);
            }
        }
        catch (Exception ex) {
            String msg = new String(ex + "On linear system calculation on iter:" + this.itercount);
            this.javaLF_Error(msg);
        }
    }

    private boolean satisf_Qlim(FileOutputStream os) {
        boolean conver2PQ = false;
        boolean limites_OK = true;
        PrintWriter myPrintStream = new PrintWriter(os, true);
        for (int i = 1; i <= this.indic_bPV[0]; ++i) {
            comp tempComp;
            int ib = this.indic_bPV[i];
            if (this.Qk[ib] - this.Qinj[ib] > this.QGmax[ib]) {
                if (ib == this.indic_bSL) {
                    tempComp = (comp)this.BusbarVector.elementAt(ib);
                    myPrintStream.println("\n**************************** Warning !! ****************************");
                    myPrintStream.println(" Slack Busbar " + tempComp.getName() + " is out of its reactive power");
                    myPrintStream.println(" generation upper limit.");
                    myPrintStream.println("********************************************************************\n");
                } else {
                    conver2PQ = true;
                    this.Qdat[ib] = this.Qinj[ib] + this.QGmax[ib];
                }
            } else if (this.Qk[ib] - this.Qinj[ib] < this.QGmin[ib]) {
                if (ib == this.indic_bSL) {
                    tempComp = (comp)this.BusbarVector.elementAt(ib);
                    myPrintStream.println("\n**************************** Warning !! ****************************");
                    myPrintStream.println(" Slack Busbar " + tempComp.getName() + " is out of its reactive power");
                    myPrintStream.println(" generation lower limit.");
                    myPrintStream.println("********************************************************************\n");
                } else {
                    conver2PQ = true;
                    this.Qdat[ib] = this.Qinj[ib] + this.QGmin[ib];
                }
            }
            if (!conver2PQ) continue;
            tempComp = (comp)this.BusbarVector.elementAt(ib);
            if (this.repconv) {
                myPrintStream.println("\n  > Generator Q limits violation at busbar: \"" + tempComp.getName() + "\" " + " Switched to \"PQ\"");
            }
            System.out.println("\n  > Generator Q limits violation at busbar: \"" + tempComp.getName() + "\" " + " Switched to \"PQ\"");
            limites_OK = false;
            conver2PQ = false;
            this.indic_bvQ[0] = this.indic_bvQ[0] + 1;
            this.indic_bvQ[this.indic_bvQ[0]] = ib;
            this.indic_bPQ[0] = this.indic_bPQ[0] + 1;
            this.indic_bPQ[this.indic_bPQ[0]] = ib;
            for (int j = i; j < this.indic_bPV[0]; ++j) {
                this.indic_bPV[j] = this.indic_bPV[j + 1];
            }
            this.indic_bPV[0] = this.indic_bPV[0] - 1;
        }
        return limites_OK;
    }

    private void listarResult(FileOutputStream os) {
        PrintWriter myPrintStream = new PrintWriter(os, true);
        myPrintStream.println();
        myPrintStream.println("Busbar    Name             type     Volt[kV]   Deg[grad]  Pinj[p.u.]  Qinj[p.u.]");
        myPrintStream.println("------  ----------------   ----    ----------  ---------  ----------  ----------");
        for (int i = 0; i < this.numnod; ++i) {
            String tipo;
            switch (this.tipobarra[i]) {
                case 1: {
                    tipo = "PQ";
                    break;
                }
                case 2: {
                    tipo = "PV";
                    break;
                }
                case 3: {
                    tipo = "SL";
                    break;
                }
                case 4: {
                    tipo = "VD";
                    break;
                }
                default: {
                    tipo = "NR";
                }
            }
            for (int j = 1; j <= this.indic_bvQ[0]; ++j) {
                if (this.indic_bvQ[j] != i) continue;
                tipo = tipo + "*";
            }
            Busbar TempBusbar = (Busbar)this.BusbarVector.elementAt(i);
            String si = StringUtil.numformat(i + 1, 4);
            String sv = StringUtil.numformat(this.vk[i] * TempBusbar.getun1(), 9, 3);
            String sang = StringUtil.numformat(this.dk[i] * 180.0 / Math.PI, 9, 2);
            String spg = StringUtil.numformat(this.Pk[i], 9, 4);
            String sqg = StringUtil.numformat(this.Qk[i], 9, 4);
            myPrintStream.println(si + " \t" + StringUtil.strformat(TempBusbar.getName(), 20) + tipo + "    " + sv + " " + sang + "   " + spg + "   " + sqg);
        }
    }

    private void writeresults(FileOutputStream os) {
        ndb_branch TempBran;
        ndb_1pol Temp1pol;
        Generator TempGenerator;
        ndb_comp TempNdb_comp;
        comp TempComponent;
        int i;
        PrintWriter myPrintStream = new PrintWriter(os, true);
        DataInputStream inData = new DataInputStream(System.in);
        int ix = 0;
        int count = 0;
        int con1 = 0;
        int con2 = 0;
        Vector<Generator> genAonbSL = new Vector<Generator>();
        Vector[] genRonbPV = new Vector[this.indic_bsetPV[0] + 1];
        for (i = 1; i <= this.indic_bsetPV[0]; ++i) {
            genRonbPV[i] = new Vector();
        }
        Complex ysh1 = new Complex();
        Complex ysh2 = new Complex();
        Complex ybr = new Complex();
        Complex v1 = new Complex();
        Complex v2 = new Complex();
        double[] Qg = new double[this.numnod];
        double Ploss = 0.0;
        double Qloss = 0.0;
        double Ploadtot = 0.0;
        double Qloadtot = 0.0;
        for (ix = 0; ix < this.BusbarVector.size(); ++ix) {
            Busbar TempBusbar = (Busbar)this.BusbarVector.elementAt(ix);
            TempBusbar.setun2(this.vk[ix] * TempBusbar.getun1());
            TempBusbar.setdelta2(this.dk[ix] * 180.0 / Math.PI);
            Qg[ix] = this.Qk[ix] * this.sref;
            Ploss += this.Pk[ix];
            Qloss += this.Qk[ix];
        }
        double PgbSL = this.Pk[this.indic_bSL] * this.sref;
        Ploss *= this.sref;
        Qloss *= this.sref;
        for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
            TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
            if (!(TempComponent instanceof ndb_comp) || !(TempNdb_comp = (ndb_comp)TempComponent).getctrla().equals(this.ctrla) && !this.ctrla.equals("ALL CONTROL AREAS") || !TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice() || !(TempComponent instanceof ndb_1pol)) continue;
            if (TempComponent instanceof ndb_inj) {
                ndb_inj TempInj = (ndb_inj)TempComponent;
                TempInj.setp(TempInj.getp0());
                TempInj.setq(TempInj.getq0());
                con1 = this.numbus(TempInj.getcon2());
                if (TempInj instanceof Generator) {
                    TempGenerator = (Generator)TempInj;
                    for (i = 1; i <= this.indic_bvQ[0]; ++i) {
                        if (this.indic_bvQ[i] != con1) continue;
                        TempGenerator.setlf_type_s(1);
                        break;
                    }
                    if (TempGenerator.getlf_type() != 3 && con1 == this.indic_bSL) {
                        PgbSL -= TempGenerator.getp0();
                    }
                    if (TempGenerator.getlf_type() == 1) {
                        int n = con1;
                        Qg[n] = Qg[n] - TempGenerator.getq0();
                    }
                    if (TempGenerator.getlf_type() != 2 && TempGenerator.getlf_type() != 3) continue;
                    for (i = 1; i <= this.indic_bsetPV[0]; ++i) {
                        if (this.indic_bsetPV[i] != con1) continue;
                        genRonbPV[i].addElement(TempGenerator);
                        break;
                    }
                    if (TempGenerator.getlf_type() != 3) continue;
                    genAonbSL.addElement(TempGenerator);
                    continue;
                }
                int n = con1;
                Qg[n] = Qg[n] - TempInj.getq0();
                if (con1 != this.indic_bSL) continue;
                PgbSL -= TempInj.getp0();
                continue;
            }
            if (TempComponent instanceof Busbar || (Temp1pol = (ndb_1pol)TempComponent).getlf_type() == 4) continue;
            int n = con1 = this.numbus(Temp1pol.getcon2());
            Qg[n] = Qg[n] + Temp1pol.getq0();
            Qloadtot += Temp1pol.getq0();
            Ploadtot += Temp1pol.getp0();
            if (con1 != this.indic_bSL) continue;
            PgbSL += Temp1pol.getp0();
        }
        for (ix = 0; ix < genAonbSL.size(); ++ix) {
            TempGenerator = (Generator)genAonbSL.elementAt(ix);
            TempGenerator.setp(PgbSL);
            if (ix + 1 < genAonbSL.size()) {
                if (TempGenerator.getp() > TempGenerator.getpmax()) {
                    TempGenerator.setp(TempGenerator.getpmax());
                } else if (TempGenerator.getp() < TempGenerator.getpmin()) {
                    TempGenerator.setp(TempGenerator.getpmin());
                }
            }
            PgbSL -= TempGenerator.getp();
            TempGenerator.setp((double)Math.round(TempGenerator.getp() * 1000000.0) / 1000000.0);
        }
        for (i = 1; i <= this.indic_bsetPV[0]; ++i) {
            for (ix = 0; ix < genRonbPV[i].size(); ++ix) {
                TempGenerator = (Generator)genRonbPV[i].elementAt(ix);
                double QgbPV = Qg[this.indic_bsetPV[i]];
                TempGenerator.setq(QgbPV);
                if (ix + 1 < genRonbPV[i].size()) {
                    if (TempGenerator.getq() > TempGenerator.getqmax()) {
                        TempGenerator.setq(TempGenerator.getqmax());
                    } else if (TempGenerator.getq() < TempGenerator.getqmin()) {
                        TempGenerator.setq(TempGenerator.getqmin());
                    }
                }
                TempGenerator.setq((double)Math.round(TempGenerator.getq() * 1000000.0) / 1000000.0);
                QgbPV -= TempGenerator.getq();
            }
        }
        for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
            TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
            if (!(TempComponent instanceof ndb_comp) || !(TempNdb_comp = (ndb_comp)TempComponent).getctrla().equals(this.ctrla) && !this.ctrla.equals("ALL CONTROL AREAS") || !TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice() || !(TempComponent instanceof ndb_branch) || (con1 = this.numbus((TempBran = (ndb_branch)TempComponent).getcon1())) <= -1 || (con2 = this.numbus(TempBran.getcon2())) <= -1) continue;
            ybr.re = this.BranchR[count];
            ybr.im = this.BranchX[count];
            ybr = Complex.divide((Complex)new Complex(1.0, 0.0), (Complex)ybr);
            ysh2.re = 0.0;
            ysh1.re = 0.0;
            ysh1.im = ysh2.im = this.BranchB[count];
            if (TempBran instanceof Trafo) {
                Trafo TempTrafo = (Trafo)TempBran;
                ysh2.add(Complex.multiply((Complex)ybr, (double)(1.0 - 1.0 / TempTrafo.gett_re())));
                ysh1.add(Complex.multiply((Complex)ybr, (double)(1.0 - TempTrafo.gett_re())));
                ysh1.divide(TempTrafo.gett_re() * TempTrafo.gett_re());
                ybr = Complex.divide((Complex)ybr, (double)TempTrafo.gett_re());
            }
            v1.re = this.vk[con1] * Math.cos(this.dk[con1]);
            v1.im = this.vk[con1] * Math.sin(this.dk[con1]);
            v2.re = this.vk[con2] * Math.cos(this.dk[con2]);
            v2.im = this.vk[con2] * Math.sin(this.dk[con2]);
            Complex s1 = Complex.multiply((Complex)v1, (Complex)Complex.conjugate((Complex)Complex.multiply((Complex)v1, (Complex)ysh1)));
            Complex s2 = Complex.multiply((Complex)v2, (Complex)Complex.conjugate((Complex)Complex.multiply((Complex)v2, (Complex)ysh2)));
            Complex s12 = Complex.multiply((Complex)v1, (Complex)Complex.conjugate((Complex)Complex.multiply((Complex)Complex.subtract((Complex)v1, (Complex)v2), (Complex)ybr)));
            Complex s21 = Complex.multiply((Complex)v2, (Complex)Complex.conjugate((Complex)Complex.multiply((Complex)Complex.subtract((Complex)v2, (Complex)v1), (Complex)ybr)));
            double p12 = (double)Math.round((s1.re + s12.re) * 10000.0) / 10000.0;
            double q12 = (double)Math.round((s1.im + s12.im) * 10000.0) / 10000.0;
            double p21 = (double)Math.round((s2.re + s21.re) * 10000.0) / 10000.0;
            double q21 = (double)Math.round((s2.im + s21.im) * 10000.0) / 10000.0;
            TempBran.setp12(p12);
            TempBran.setq12(q12);
            TempBran.setp21(p21);
            TempBran.setq21(q21);
            ++count;
        }
        for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
            TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
            if (!(TempComponent instanceof ndb_comp) || ((TempNdb_comp = (ndb_comp)TempComponent).getctrla().equals(this.ctrla) || this.ctrla.equals("ALL CONTROL AREAS")) && TempComponent.getactive() && TempComponent.getvalid() && TempComponent.getinservice()) continue;
            if (TempComponent instanceof ndb_branch) {
                TempBran = (ndb_branch)TempComponent;
                TempBran.setp12(0.0);
                TempBran.setq12(0.0);
                TempBran.setp21(0.0);
                TempBran.setq21(0.0);
                continue;
            }
            if (!(TempComponent instanceof ndb_1pol)) continue;
            Temp1pol = (ndb_1pol)TempComponent;
            Temp1pol.setp(0.0);
            Temp1pol.setq(0.0);
        }
        myPrintStream.println();
        myPrintStream.println("        Total System Power Statistics");
        myPrintStream.println("        -----------------------------");
        myPrintStream.println();
        double auxd = Ploss + Ploadtot;
        myPrintStream.println("Ptot Gen =" + StringUtil.numformat(auxd, 12, 2) + " [ MW ]");
        auxd = Ploadtot;
        myPrintStream.println("Ptot Load=" + StringUtil.numformat(auxd, 12, 2) + " [ MW ]");
        auxd = Ploss + Ploadtot;
        myPrintStream.println("P Nt.Loss=" + StringUtil.numformat(Ploss, 12, 2) + " [ MW ], " + StringUtil.numformat(Ploss / auxd * 100.0, 6, 1) + " [%]");
        auxd = Qloss + Qloadtot;
        myPrintStream.println("Qtot Gen =" + StringUtil.numformat(auxd, 12, 2) + " [MVAR]");
        auxd = Qloadtot;
        myPrintStream.println("Qtot Load=" + StringUtil.numformat(auxd, 12, 2) + " [MVAR]");
        auxd = Qloss;
        myPrintStream.println("Q Nt.Loss=" + StringUtil.numformat(auxd, 12, 2) + " [MVAR]");
        myPrintStream.println();
    }

    public void setParameters(double tolerancia, boolean constantJacob, boolean qlimsat, boolean convrep) {
        this.tol = tolerancia > 1.0 ? 1.0 / this.sref : (tolerancia < 0.001 ? 0.001 / this.sref : tolerancia / this.sref);
        this.retriang = !constantJacob;
        this.verifQlim = qlimsat;
        this.repconv = convrep;
    }

    private void verificarGrafo() throws Exception {
        int i;
        int[] grupnod1 = new int[this.numnod + 1];
        boolean[] ingrup1 = new boolean[this.numnod];
        grupnod1[0] = 1;
        grupnod1[1] = 0;
        ingrup1[0] = true;
        for (i = 1; i <= grupnod1[0]; ++i) {
            for (int j = 0; j < this.numnod; ++j) {
                if (!this.matCx[grupnod1[i]][j] || ingrup1[j]) continue;
                grupnod1[0] = grupnod1[0] + 1;
                grupnod1[grupnod1[0]] = j;
                ingrup1[j] = true;
            }
            if (grupnod1[0] == this.numnod) break;
        }
        if (grupnod1[0] < this.numnod) {
            for (i = 0; i < this.numnod && ingrup1[i]; ++i) {
            }
            Busbar TempBusbar = (Busbar)this.BusbarVector.elementAt(i);
            this.javaLF_Error("There's an isolated Subsystem; \"" + TempBusbar.getName() + "\"," + "...");
        }
    }

    public void finalize() {
        this.Ybus = null;
        this.matCx = null;
        this.Pinj = null;
        this.Qinj = null;
        this.QGmin = null;
        this.QGmax = null;
        this.tipobarra = null;
        this.indic_bPX = null;
        this.indic_bPQ = null;
        this.indic_bPV = null;
        this.indic_bvQ = null;
        this.indic_bsetPV = null;
        this.volt_state = null;
        this.delta_state = null;
        this.Gbus = null;
        this.Bbus = null;
        this.LFJ = null;
        this.vk = null;
        this.dk = null;
        this.Dv = null;
        this.Ddv = null;
        this.Pdat = null;
        this.Pk = null;
        this.Qdat = null;
        this.Qk = null;
        this.DPv = null;
        this.DQv = null;
    }

    public void printMatrixSM(FileOutputStream os, SparseMatrix mJ) {
        PrintWriter myPrintStream = new PrintWriter(os, true);
        for (int i = 0; i < mJ.sizeOfRows(); ++i) {
            for (int j = 0; j < mJ.sizeOfColumns(); ++j) {
                if (mJ.elementAt(i, j) != 0.0) {
                    myPrintStream.print(mJ.elementAt(i, j) + "\t");
                    continue;
                }
                myPrintStream.print(mJ.elementAt(i, j) + "\t\t\t");
            }
            myPrintStream.println();
        }
    }

    public void printMatrixDouble(FileOutputStream os, double[][] m, int ii, int jj) {
        PrintWriter myPrintStream = new PrintWriter(os, true);
        for (int i = 0; i < ii; ++i) {
            for (int j = 0; j < jj; ++j) {
                myPrintStream.print(m[i][j] + "\t \t \t");
            }
            myPrintStream.println();
        }
        myPrintStream.println();
    }

    public void printArregloDouble(FileOutputStream os, double[] m, int ii) {
        PrintWriter myPrintStream = new PrintWriter(os, true);
        for (int i = 0; i < ii; ++i) {
            myPrintStream.println(m[i]);
        }
    }

    public int numbusgen(String Genname) {
        for (int ix = 0; ix < this.GeneratorVector.size(); ++ix) {
            comp TempComponent = (comp)this.GeneratorVector.elementAt(ix);
            if (!(TempComponent instanceof ndb_inj) || !Genname.equals(TempComponent.getName())) continue;
            ndb_inj TempInj = (ndb_inj)TempComponent;
            TempInj.InformAllComponents();
            if (TempInj.getlf_type() == 3) {
                int BarraRef = this.numbus(TempInj.getcon2());
                return BarraRef;
            }
            return this.numbus(TempInj.getcon2());
        }
        System.out.println("Error en NUMBUSGEN");
        return -1;
    }

    public int numbusload(String Loadname) {
        for (int ix = 0; ix < this.LoadVector.size(); ++ix) {
            comp TempComponent = (comp)this.LoadVector.elementAt(ix);
            if (!(TempComponent instanceof Load) || !Loadname.equals(TempComponent.getName())) continue;
            Load TempLoad = (Load)TempComponent;
            TempLoad.InformAllComponents();
            return this.numbus(TempLoad.getcon2());
        }
        System.out.println("Error en NUMBUSLOAD");
        return -1;
    }

    public void Caculate_FLF() {
        this.deltaV = new double[this.numnod][5];
        this.deltaGra = new double[this.numnod][5];
        double[] DPaux = new double[this.numnod];
        double[] DQaux = new double[this.numnod];
        double[] Dvol = new double[this.numnod];
        double[] Dgra = new double[this.numnod];
        double[] vaux = new double[this.numnod];
        double[] daux = new double[this.numnod];
        this.agregaColumna(this.deltaV, this.vkAnt, 4);
        this.agregaColumna(this.deltaGra, this.dkAnt, 4);
        try {
            this.calcular_J(this.RJ, this.Bbus, this.Gbus, this.vkAnt, this.dkAnt, this.Pk, this.Qk, DPaux, DQaux);
            try {
                this.LU_RJ = new CroutPivot((MatrixI)this.RJ);
            }
            catch (Exception ex) {
                String msg = new String(ex + "Singular Jacobian on iteration " + this.itercount);
                this.javaLF_Error(msg);
            }
            for (int i = 0; i < 4; ++i) {
                this.calc_var_Pot(DPaux, this.columnaArreglo(this.deltaP, i), this.columnaArreglo(this.deltaP, 4));
                this.calc_var_Pot(DQaux, this.columnaArreglo(this.deltaQ, i), this.columnaArreglo(this.deltaQ, 4));
                this.anularD_bPVSL(DPaux, DQaux, this.indic_bSL, this.indic_bPV);
                this.sol_lin(this.LU_RJ, this.RJ, Dvol, Dgra, DPaux, DQaux);
                this.actualiza_VarVolt(this.vkAnt, this.dkAnt, vaux, daux, this.Dv, this.Ddv, Dvol, Dgra);
                this.agregaColumna(this.deltaV, vaux, i);
                this.agregaColumna(this.deltaGra, daux, i);
            }
        }
        catch (Exception e) {
            this.message = this.errorMsg != null ? this.errorMsg : e.toString();
            String[] DlgButtons = new String[]{"OK"};
            SimpleDialog ExceptionDialog = new SimpleDialog(DeepEdit.frame, "Java Fuzzy Load Flow", this.message, DlgButtons, 1, 0, 0, 1);
        }
    }

    public void Valores_Fuzzy(FileOutputStream os) {
        PrintWriter myPrintStream = new PrintWriter(os, true);
        this.deltaP = new double[this.numnod][5];
        this.deltaQ = new double[this.numnod][5];
        try {
            SimpleDialog ExceptionDialog;
            String[] DlgButtons;
            double medioQ;
            double Qdd;
            double Qcc;
            double Qbb;
            double Qaa;
            double medioP;
            int indice;
            String nombre;
            double Pdd;
            double Pcc;
            double Pbb;
            double Paa;
            Statement stmt = DeepEditFrame.conFuzzy.createStatement();
            String query = "SELECT * FROM Generator";
            ResultSet rs = stmt.executeQuery(query);
            boolean more = rs.next();
            while (more) {
                Paa = Double.valueOf(rs.getString("Pa")) / this.sref;
                Pbb = Double.valueOf(rs.getString("Pb")) / this.sref;
                Pcc = Double.valueOf(rs.getString("Pc")) / this.sref;
                Pdd = Double.valueOf(rs.getString("Pd")) / this.sref;
                nombre = rs.getString("Name");
                indice = this.numbusgen(nombre);
                medioP = (Pbb + Pcc) / 2.0;
                Qaa = Double.valueOf(rs.getString("Qa")) / this.sref;
                Qbb = Double.valueOf(rs.getString("Qb")) / this.sref;
                Qcc = Double.valueOf(rs.getString("Qc")) / this.sref;
                Qdd = Double.valueOf(rs.getString("Qd")) / this.sref;
                medioQ = (Qbb + Qcc) / 2.0;
                if (indice == -1) {
                    DlgButtons = new String[]{"OK"};
                    ExceptionDialog = new SimpleDialog(DeepEdit.frame, "1- JavaFuzzyLF Read", "Barra asociada a " + nombre + " no existe!!!", DlgButtons, 1, 0, 0, 1);
                } else {
                    double[] dArray = this.deltaP[indice];
                    dArray[0] = dArray[0] + Paa;
                    double[] dArray2 = this.deltaP[indice];
                    dArray2[1] = dArray2[1] + Pbb;
                    double[] dArray3 = this.deltaP[indice];
                    dArray3[2] = dArray3[2] + Pcc;
                    double[] dArray4 = this.deltaP[indice];
                    dArray4[3] = dArray4[3] + Pdd;
                    double[] dArray5 = this.deltaP[indice];
                    dArray5[4] = dArray5[4] + medioP;
                    double[] dArray6 = this.deltaQ[indice];
                    dArray6[0] = dArray6[0] + Qaa;
                    double[] dArray7 = this.deltaQ[indice];
                    dArray7[1] = dArray7[1] + Qbb;
                    double[] dArray8 = this.deltaQ[indice];
                    dArray8[2] = dArray8[2] + Qcc;
                    double[] dArray9 = this.deltaQ[indice];
                    dArray9[3] = dArray9[3] + Qdd;
                    double[] dArray10 = this.deltaQ[indice];
                    dArray10[4] = dArray10[4] + medioQ;
                    myPrintStream.println("Valores antes de sumar " + nombre + " - " + indice + " valores --> " + Paa + " | " + Pbb + " | " + Pcc + " | " + Pdd);
                }
                more = rs.next();
            }
            rs.close();
            query = "SELECT * FROM Load";
            rs = stmt.executeQuery(query);
            more = rs.next();
            while (more) {
                Paa = Double.valueOf(rs.getString("Pa")) / this.sref;
                Pbb = Double.valueOf(rs.getString("Pb")) / this.sref;
                Pcc = Double.valueOf(rs.getString("Pc")) / this.sref;
                Pdd = Double.valueOf(rs.getString("Pd")) / this.sref;
                nombre = rs.getString("Name");
                indice = this.numbusload(nombre);
                medioP = (Pbb + Pcc) / 2.0;
                Qaa = Double.valueOf(rs.getString("Qa")) / this.sref;
                Qbb = Double.valueOf(rs.getString("Qb")) / this.sref;
                Qcc = Double.valueOf(rs.getString("Qc")) / this.sref;
                Qdd = Double.valueOf(rs.getString("Qd")) / this.sref;
                medioQ = (Qbb + Qcc) / 2.0;
                if (indice == -1) {
                    DlgButtons = new String[]{"OK"};
                    ExceptionDialog = new SimpleDialog(DeepEdit.frame, "2- JavaFuzzyLF Read", "Barra " + nombre + " no existe!!!", DlgButtons, 1, 0, 0, 1);
                } else {
                    double[] dArray = this.deltaP[indice];
                    dArray[0] = dArray[0] - Pdd;
                    double[] dArray11 = this.deltaP[indice];
                    dArray11[1] = dArray11[1] - Pcc;
                    double[] dArray12 = this.deltaP[indice];
                    dArray12[2] = dArray12[2] - Pbb;
                    double[] dArray13 = this.deltaP[indice];
                    dArray13[3] = dArray13[3] - Paa;
                    double[] dArray14 = this.deltaP[indice];
                    dArray14[4] = dArray14[4] - medioP;
                    double[] dArray15 = this.deltaQ[indice];
                    dArray15[0] = dArray15[0] - Qdd;
                    double[] dArray16 = this.deltaQ[indice];
                    dArray16[1] = dArray16[1] - Qcc;
                    double[] dArray17 = this.deltaQ[indice];
                    dArray17[2] = dArray17[2] - Qbb;
                    double[] dArray18 = this.deltaQ[indice];
                    dArray18[3] = dArray18[3] - Qaa;
                    double[] dArray19 = this.deltaQ[indice];
                    dArray19[4] = dArray19[4] - medioQ;
                    myPrintStream.println("valores antes de restar " + nombre + " - " + indice + " valores --> " + Paa + " | " + Pbb + " | " + Pcc + " | " + Pdd);
                }
                more = rs.next();
            }
            rs.close();
            stmt.close();
        }
        catch (Exception e) {
            String message = e.toString();
            String[] DlgButtons = new String[]{"OK"};
            SimpleDialog ExceptionDialog = new SimpleDialog(DeepEdit.frame, "JavaFuzzyLF", message, DlgButtons, 1, 0, 0, 1);
            return;
        }
        this.printMatrixDouble(os, this.deltaP, this.numnod, 5);
        this.printMatrixDouble(os, this.deltaQ, this.numnod, 5);
    }

    public double[] columnaArreglo(double[][] m, int j) {
        double[] res = new double[this.numnod];
        for (int i = 0; i < this.numnod; ++i) {
            res[i] = m[i][j];
        }
        return res;
    }

    public void agregaColumna(double[][] m, double[] a, int n) {
        for (int i = 0; i < this.numnod; ++i) {
            m[i][n] = a[i];
        }
    }

    public void sumaArreglos(double[] a, double[] b) {
        for (int i = 0; i < a.length; ++i) {
            int n = i;
            a[n] = a[n] + b[i];
        }
    }

    public void CalculaFlujos(FileOutputStream os) {
        PrintWriter myPrintStream = new PrintWriter(os, true);
        double[][] Pflu = new double[this.numnod][this.numnod];
        double[][] Qflu = new double[this.numnod][this.numnod];
        double[] dp = new double[4];
        double[] dq = new double[4];
        for (int i = 0; i < this.numnod; ++i) {
            for (int j = 0; j < this.numnod; ++j) {
                Pflu[i][j] = 0.0;
                Qflu[i][j] = 0.0;
                if (i == j || this.Bbus.elementAt(i, j) == 0.0) continue;
                double sij = Math.sin(this.deltaGra[i][4] - this.deltaGra[j][4]);
                double cij = Math.cos(this.deltaGra[i][4] - this.deltaGra[j][4]);
                dp = new double[4];
                dq = new double[4];
                Busbar tempb1 = (Busbar)this.BusbarVector.elementAt(i);
                Busbar tempb2 = (Busbar)this.BusbarVector.elementAt(j);
                Pflu[i][j] = -this.Gbus.elementAt(i, j) * this.deltaV[i][4] * this.deltaV[i][4] + this.deltaV[i][4] * this.deltaV[j][4] * (this.Gbus.elementAt(i, j) * cij + this.Bbus.elementAt(i, j) * sij);
                Qflu[i][j] = this.Bbus.elementAt(i, j) * this.deltaV[i][4] * this.deltaV[i][4] + this.deltaV[i][4] * this.deltaV[j][4] * (-this.Bbus.elementAt(i, j) * cij + this.Gbus.elementAt(i, j) * sij);
                for (int y = 0; y < 4; ++y) {
                    dp[y] = 0.0;
                    dq[y] = 0.0;
                    int n = y;
                    dp[n] = dp[n] + (-2.0 * this.Gbus.elementAt(i, j) * this.deltaV[i][4] + this.deltaV[j][4] * (this.Gbus.elementAt(i, j) * cij + this.Bbus.elementAt(i, j) * sij)) * (this.deltaV[i][y] - this.deltaV[i][4]);
                    int n2 = y;
                    dp[n2] = dp[n2] + this.deltaV[i][4] * (this.Gbus.elementAt(i, j) * cij + this.Bbus.elementAt(i, j) * sij) * (this.deltaV[j][y] - this.deltaV[j][4]);
                    int n3 = y;
                    dp[n3] = dp[n3] + this.deltaV[i][4] * this.deltaV[j][4] * (-this.Gbus.elementAt(i, j) * sij + this.Bbus.elementAt(i, j) * cij) * (this.deltaGra[i][y] - this.deltaGra[i][4]);
                    int n4 = y;
                    dp[n4] = dp[n4] + -(this.deltaV[i][4] * this.deltaV[j][4] * (-this.Gbus.elementAt(i, j) * sij + this.Bbus.elementAt(i, j) * cij)) * (this.deltaGra[j][y] - this.deltaGra[j][4]);
                    int n5 = y;
                    dq[n5] = dq[n5] + (2.0 * this.Bbus.elementAt(i, j) * this.deltaV[i][4] + this.deltaV[j][4] * (this.Gbus.elementAt(i, j) * sij - this.Bbus.elementAt(i, j) * cij)) * (this.deltaV[i][y] - this.deltaV[i][4]);
                    int n6 = y;
                    dq[n6] = dq[n6] + this.deltaV[i][4] * (this.Gbus.elementAt(i, j) * sij - this.Bbus.elementAt(i, j) * cij) * (this.deltaV[j][y] - this.deltaV[j][4]);
                    int n7 = y;
                    dq[n7] = dq[n7] + this.deltaV[i][4] * this.deltaV[j][4] * (this.Gbus.elementAt(i, j) * cij + this.Bbus.elementAt(i, j) * sij) * (this.deltaGra[i][y] - this.deltaGra[i][4]);
                    int n8 = y;
                    dq[n8] = dq[n8] + this.deltaV[i][4] * this.deltaV[j][4] * (-this.Gbus.elementAt(i, j) * cij - this.Bbus.elementAt(i, j) * sij) * (this.deltaGra[j][y] - this.deltaGra[j][4]);
                }
                CFuzzytra tempFP = new CFuzzytra(dp[0], dp[1], dp[2], dp[3]);
                tempFP.sumaElemento(Pflu[i][j]);
                tempFP.pond(this.sref);
                CFuzzytra tempFQ = new CFuzzytra(dq[0], dq[1], dq[2], dq[3]);
                tempFQ.sumaElemento(Qflu[i][j]);
                tempFQ.pond(this.sref);
                try {
                    this.SaveDBFuzzyLine(this.NameLine(i, j), tempb1.getName(), tempb2.getName(), tempFP, tempFQ);
                }
                catch (Exception e) {
                    // empty catch block
                }
                dp = null;
                dq = null;
            }
        }
        this.borrar = true;
    }

    public void SaveDBFuzzyLine(String name, String bus1, String bus2, CFuzzytra P, CFuzzytra Q) throws SQLException {
        String query;
        int x = 0;
        Statement stmt = DeepEditFrame.conFuzzy.createStatement();
        if (this.borrar) {
            query = "DELETE * FROM Line";
            x = stmt.executeUpdate(query);
        }
        this.borrar = false;
        System.out.println(name);
        query = "INSERT INTO Line (Name,c1,c2,Pa,Pb,Pc,Pd,Qa,Qb,Qc,Qd) VALUES ('" + name + "','" + bus1 + "','" + bus2 + "'," + StringUtil.numformat(P.a, 9, 3) + "," + StringUtil.numformat(P.b, 9, 3) + "," + StringUtil.numformat(P.c, 9, 3) + "," + StringUtil.numformat(P.d, 9, 3) + "," + StringUtil.numformat(Q.a, 9, 3) + "," + StringUtil.numformat(Q.b, 9, 3) + "," + StringUtil.numformat(Q.c, 9, 3) + "," + StringUtil.numformat(Q.d, 9, 3) + ")";
        x = stmt.executeUpdate(query);
        stmt.close();
    }

    public void grabaVoltajes() {
        for (int i = 0; i < this.numnod; ++i) {
            Busbar tempBusbar = (Busbar)this.BusbarVector.elementAt(i);
            CFuzzytra tempV = new CFuzzytra(this.deltaV[i][0], this.deltaV[i][1], this.deltaV[i][2], this.deltaV[i][3]);
            CFuzzytra tempGra = new CFuzzytra(this.deltaGra[i][0], this.deltaGra[i][1], this.deltaGra[i][2], this.deltaGra[i][3]);
            tempV.pond(tempBusbar.getun1());
            tempGra.pond(57.29577951308232);
            try {
                this.SaveDBFuzzyVoltage(tempBusbar.getName(), tempV, tempGra);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        this.borrar = true;
    }

    public void SaveDBFuzzyVoltage(String name, CFuzzytra V, CFuzzytra G) throws SQLException {
        String query;
        int x = 0;
        Statement stmt = DeepEditFrame.conFuzzy.createStatement();
        if (this.borrar) {
            query = "DELETE * FROM VoltajesPorto";
            x = stmt.executeUpdate(query);
        }
        this.borrar = false;
        System.out.println(name);
        query = "INSERT INTO VoltajesPorto (Name,Va,Vb,Vc,Vd,Dega,Degb,Degc,Degd) VALUES ('" + name + "'," + StringUtil.numformat(V.a, 9, 3) + "," + StringUtil.numformat(V.b, 9, 3) + "," + StringUtil.numformat(V.c, 9, 3) + "," + StringUtil.numformat(V.d, 9, 3) + "," + StringUtil.numformat(G.a, 9, 3) + "," + StringUtil.numformat(G.b, 9, 3) + "," + StringUtil.numformat(G.c, 9, 3) + "," + StringUtil.numformat(G.d, 9, 3) + ")";
        x = stmt.executeUpdate(query);
        stmt.close();
    }

    public String NameLine(int c1, int c2) {
        for (int ix = 0; ix < this.LineVector.size(); ++ix) {
            comp TempComponent = (comp)this.LineVector.elementAt(ix);
            Line TempLine = (Line)TempComponent;
            TempLine.InformAllComponents();
            if (!(TempComponent instanceof Line) || (this.numbus(TempLine.getcon1()) != c1 || this.numbus(TempLine.getcon2()) != c2) && (this.numbus(TempLine.getcon1()) != c2 || this.numbus(TempLine.getcon2()) != c1)) continue;
            return TempLine.getName();
        }
        return this.NameTrafo(c1, c2);
    }

    public String NameTrafo(int c1, int c2) {
        for (int ix = 0; ix < this.TrafoVector.size(); ++ix) {
            comp TempComponent = (comp)this.TrafoVector.elementAt(ix);
            Trafo TempTrafo = (Trafo)TempComponent;
            TempTrafo.InformAllComponents();
            if (!(TempComponent instanceof Trafo) || (this.numbus(TempTrafo.getcon1()) != c1 || this.numbus(TempTrafo.getcon2()) != c2) && (this.numbus(TempTrafo.getcon1()) != c2 || this.numbus(TempTrafo.getcon2()) != c1)) continue;
            return TempTrafo.getName();
        }
        System.out.println("Error en No Encontro Linea ");
        return "No Hay nada";
    }
}

