/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import VisualNumerics.math.Complex;
import de.core.AnalysisTool;
import de.core.Busbar;
import de.core.DeepEdit;
import de.core.Generator;
import de.core.GeneratorFrame;
import de.core.Injection;
import de.core.JavaLFException;
import de.core.JavaLFFrame;
import de.core.Line;
import de.core.LineDC;
import de.core.Load;
import de.core.MMS;
import de.core.SVC;
import de.core.Schematic;
import de.core.SimpleDialog;
import de.core.ThreeWindingTrafo;
import de.core.Trafo;
import de.core.Upfc;
import de.core.YearlyDCLFStatistics;
import de.core.comp;
import de.core.ndb_1pol;
import de.core.ndb_branch;
import de.core.ndb_comp;
import de.core.ndb_inj;
import de.utils.StringUtil;
import drasys.or.linear.algebra.Algebra;
import drasys.or.linear.algebra.CroutPivot;
import drasys.or.matrix.DenseVector;
import drasys.or.matrix.MatrixI;
import drasys.or.matrix.SparseMatrix;
import drasys.or.matrix.VectorI;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.StringTokenizer;
import java.util.Vector;

public final class JavaLF
extends AnalysisTool {
    JavaLFFrame MyJavaLFFrame = null;
    String ctrla = null;
    Complex[][] Ybus;
    Complex[] ZthreeWinding;
    Complex[] Zreales;
    protected Vector BusbarVector;
    double[] BranchR;
    double[] BranchX;
    double[] BranchB;
    int[] BranchI;
    int[] BranchJ;
    double[] react;
    double[] resistencias;
    int numbran = 0;
    boolean retriang = false;
    boolean repconv = true;
    boolean verifQlim = true;
    private int[][] TOupfc;
    private double[] Pesp;
    private double[] QEesp;
    private double[] QBesp;
    private double[][] Pfexc;
    private double[][] Pfboost;
    private double[][] Qfexc;
    private double[][] Qfboost;
    private double[][] PARupfc;
    private double[][] VARupfc;
    private int[][] TOlinedc;
    private double[] Pdr;
    private double[] Pdi;
    private double[] Id;
    private double[] Qrect;
    private double[] Qinver;
    private double[][] PARlinedc;
    private double[][] PARrect;
    private double[][] PARinver;
    private double[][] VARlinedc_k;
    private double[][] DVlinedc;
    private double[][] LimVARlinedc;
    private int[] indic_brect;
    private int[] indic_binver;
    private double[][] Rk;
    private double[][] DR;
    private double[][] Rfijo;
    private String[] NombreLinedc;
    private double[] nb;
    private double[] leng;
    private double[] Pinj;
    private double[] Qinj;
    private double[] QGmin;
    private double[] QGmax;
    private int[] tipobarra;
    private int indic_bSL = -1;
    private int[] indic_bPX;
    private int[] indic_bPQ;
    private int[] indic_bPV;
    private int[] indic_bsetPV;
    private int[] indic_bvQ;
    private double[] volt_state;
    private double[] delta_state;
    private double angref = 0.0;
    private SparseMatrix Gbus;
    private SparseMatrix Bbus;
    private boolean[][] matCx;
    private double tol = 1.0E-4;
    final double tolaj = 0.01;
    final int nmaxiter = 50;
    final double tresh = 1.0E-10;
    final double eliminador = 1.0E200;
    final boolean flat_start = true;
    final double max_err_tol = 100.0;
    private double[] vk;
    double[] vk0;
    private double[] dk;
    private double[] Dv;
    private double[] Ddv;
    private double[] Pdatfijo;
    private double[] Pdatactual;
    private double[] Pk;
    private double[] Qdatfijo;
    private double[] Qdatactual;
    private double[] Qk;
    private double[] DPv;
    private double[] DQv;
    private int itercount = 0;
    private int convergen = 0;
    public int conver = 3;
    private double max_err_volt = 10.0;
    private double max_err_delta = 10.0;
    private double max_err_P = 100.0;
    private double max_err_Q = 100.0;
    private String errorMsg = null;
    private SparseMatrix LFJ;
    private CroutPivot LU_LFJ;
    protected DeepEdit deepEdApp;
    boolean flowrep = false;
    String[] NomBra;
    double[] FlujosP;
    double[] FlujosQ;
    double[] PerdP;
    double[] PerdQ;
    int nbr;
    boolean archivo_csv;
    Load[] loadVD;
    int[] barraloadVD;
    public boolean limqrect;
    private static final String WORK_FILE = "JavaLF.dat";
    Load Temploadyearly;
    Generator Tempgenyearly = null;
    YearlyDCLFStatistics MyYearlylf;
    MMS MyMMS;
    boolean yearlylf = false;
    Schematic schh;
    private double sref = 100.0;

    JavaLF(DeepEdit deepApplet, Schematic sch) {
        super(sch);
        this.deepEdApp = deepApplet;
        this.sref = this.getSref();
        System.out.println("---------- Java Load Flow Started ------------");
        if (this.MyJavaLFFrame == null) {
            this.MyJavaLFFrame = new JavaLFFrame(this);
        } else {
            this.MyJavaLFFrame.setVisible(true);
        }
    }

    JavaLF(DeepEdit deepApplet, Schematic sch, YearlyDCLFStatistics MMyYearlylf) {
        super(sch);
        this.sref = this.getSref();
        this.deepEdApp = deepApplet;
        this.schh = sch;
        this.MyYearlylf = MMyYearlylf;
    }

    JavaLF(DeepEdit deepApplet, Schematic sch, MMS MMyYearlylf) {
        super(sch);
        this.sref = this.getSref();
        this.deepEdApp = deepApplet;
        this.schh = sch;
        this.MyMMS = MMyYearlylf;
    }

    public void Calculate(String cctrla) throws Exception {
        FileOutputStream os = null;
        this.ctrla = cctrla;
        String LFsal = WORK_FOLDER + File.separator + WORK_FILE;
        DeepEdit.MySchematicPanel.repaint();
        this.message = "Some problems, sorry!";
        try {
            JavaLF.CreateDirectory(WORK_FOLDER);
            os = new FileOutputStream(LFsal);
            this.getNetwork(os);
            this.calcular_LF(os);
            switch (this.convergen) {
                case 2: {
                    this.message = "Convergence Reached";
                    break;
                }
                case 1: {
                    this.message = "Partial Convergence Reached";
                    break;
                }
                case -1: {
                    this.message = "Convergence not Reached !";
                    break;
                }
                case -2: {
                    this.message = "Algorithm Diverges !";
                    break;
                }
                default: {
                    this.message = "Out of Range Results !";
                }
            }
            System.out.println(this.message);
            if (this.convergen > 0) {
                this.writeresults(os);
                this.listarResult(os);
                this.DoListResults(LFsal);
                this.ActSchematic.Modified = false;
                this.ActSchematic.Modifiedstate = false;
                this.ActSchematic.changeGIS = true;
                DeepEdit.MySchematicPanel.repaint();
            } else {
                if (this.repconv) {
                    this.DoListResults(LFsal);
                }
                String[] DlgButtons = new String[]{"OK"};
                SimpleDialog NoconvDialog = new SimpleDialog(DeepEdit.frame, "Java Load Flow", this.message, DlgButtons, 1, 0, 0, 2);
            }
            if (this.convergen > 0) {
                // empty if block
            }
            os.close();
        }
        catch (Exception e) {
            this.message = this.errorMsg != null ? this.errorMsg : e.toString();
            String[] DlgButtons = new String[]{"OK"};
            SimpleDialog ExceptionDialog = new SimpleDialog(DeepEdit.frame, "Java Load Flow", this.message, DlgButtons, 1, 0, 0, 1);
        }
        try {
            if (os != null) {
                os.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        this.finalize();
    }

    public void Calculate(String cctrla, double[] vvoltyearly) throws Exception {
        FileOutputStream os = null;
        String LFsal = "./database/YearlyStatVolt.dat";
        this.ctrla = cctrla;
        this.repconv = !this.yearlylf;
        DeepEdit.MySchematicPanel.repaint();
        this.message = "Some problems, sorry!";
        try {
            os = new FileOutputStream(LFsal);
            this.getNetwork(os);
            this.calcular_LF(os);
            switch (this.convergen) {
                case 2: {
                    this.message = "Convergence Reached";
                    break;
                }
                case 1: {
                    this.message = "Partial Convergence Reached";
                    break;
                }
                case -1: {
                    this.message = "Convergence not Reached !";
                    break;
                }
                case -2: {
                    this.message = "Algorithm Diverges !";
                    break;
                }
                default: {
                    this.message = "Out of Range Results !";
                }
            }
            System.out.println(this.message);
            if (this.MyYearlylf != null) {
                this.resultyearly(this.MyYearlylf.os_yearly);
            } else {
                this.resultyearly(this.MyMMS.os_yearly);
            }
            this.volt_yearlytool(vvoltyearly);
            if (this.conver == 3) {
                this.conver = this.convergen;
            }
            if (this.convergen > 0) {
                this.writeresults(os);
                this.listarResult(os);
                this.ActSchematic.Modified = false;
                this.ActSchematic.Modifiedstate = false;
                this.ActSchematic.changeGIS = true;
                DeepEdit.MySchematicPanel.repaint();
            } else if (this.repconv) {
                String[] DlgButtons = new String[]{"OK"};
                SimpleDialog NoconvDialog = new SimpleDialog(DeepEdit.frame, "Java Load Flow", this.message, DlgButtons, 1, 0, 0, 2);
            }
            if (this.convergen > 0) {
                // empty if block
            }
            os.close();
        }
        catch (Exception e) {
            this.message = this.errorMsg != null ? this.errorMsg : e.toString();
            String[] DlgButtons = new String[]{"OK"};
            SimpleDialog ExceptionDialog = new SimpleDialog(DeepEdit.frame, "Java Load Flow", this.message, DlgButtons, 1, 0, 0, 1);
        }
        try {
            if (os != null) {
                os.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        this.finalize();
    }

    public void getNetwork(FileOutputStream os) throws Exception {
        ndb_inj TempInj;
        Load TemploadVD;
        Line TempLine;
        ndb_comp TempNdb_comp;
        comp TempComponent;
        Complex segundiag;
        Complex Zrama23;
        Complex invertapnodiag;
        Complex Afinal;
        Complex factor;
        Complex auxc3;
        PrintWriter myPrintStream = new PrintWriter(os, true);
        int indicbus = 0;
        double qmin_diag = -100000.0;
        double qmax_diag = 100000.0;
        int ix = 0;
        int i = 0;
        int j = 0;
        boolean k = false;
        int c = 0;
        int count = 0;
        int countupfc = 0;
        int countaux = 0;
        int countlinedc = 0;
        int con1 = 10000;
        int con2 = 10000;
        int con3 = 10000;
        int parestrafo = 0;
        int fintrafo = 0;
        double modulo = 0.0;
        double partimag = 0.0;
        double tapdiag1 = 0.0;
        double tapdiag2 = 0.0;
        double tapnodiag = 0.0;
        this.BusbarVector = new Vector();
        double ueb = 0.0;
        double ueb1 = 0.0;
        double ueb2 = 0.0;
        double ueb3 = 0.0;
        double res = 0.0;
        double z = 0.0;
        double reac = 0.0;
        double y1 = 0.0;
        double y2 = 0.0;
        double b = 0.0;
        double Zk12 = 0.0;
        double Zk13 = 0.0;
        double Zk23 = 0.0;
        double rserie = 0.0;
        double xserie = 0.0;
        double gshunt = 0.0;
        double bshunt = 0.0;
        double tap1 = 1.0;
        double tap2 = 1.0;
        double tap3 = 1.0;
        double potapa1 = 0.0;
        double potapa2 = 0.0;
        double potapa3 = 0.0;
        Complex auxc2 = auxc3 = new Complex(0.0, 0.0);
        Complex auxc1 = auxc3;
        Complex auxupfc = new Complex(0.0, 0.0);
        Complex factory = factor = new Complex(0.0, 0.0);
        Complex invertA3 = Afinal = new Complex(0.0, 0.0);
        Complex A3 = Afinal;
        Complex A2 = Afinal;
        Complex A1 = Afinal;
        Complex ramaY3 = Afinal;
        Complex ramaY2 = Afinal;
        Complex ramaY1 = Afinal;
        Complex ramaY = Afinal;
        Complex neutro = new Complex(1.0, 0.0);
        Complex invertapdiag2 = invertapnodiag = new Complex(0.0, 0.0);
        Complex invertapdiag1 = invertapnodiag;
        Complex Zrama13 = Zrama23 = new Complex(0.0, 0.0);
        Complex Zrama12 = Zrama23;
        Complex primerdiag = segundiag = new Complex(0.0, 0.0);
        double npuente = 0.0;
        double rlinedc = 0.0;
        double vdi = 0.0;
        double svolt = 0.0;
        double discri = 0.0;
        double auxang = Math.PI / 180;
        this.numbran = 0;
        this.numnod = 0;
        for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
            TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
            if (!(TempComponent instanceof ndb_comp) || !(TempNdb_comp = (ndb_comp)TempComponent).getctrla().equals(this.ctrla) && !this.ctrla.equals("ALL CONTROL AREAS") || !TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice()) continue;
            if (TempComponent instanceof Busbar) {
                TempComponent.InformAllComponents();
                Busbar TempBusbar = (Busbar)TempComponent;
                if (this.numbus(TempComponent.getName()) != -1) {
                    this.javaLF_Error("There\u00b4s more than one busbar with name \"" + TempComponent.getName() + "\"");
                }
                this.BusbarVector.addElement(TempComponent);
                ++this.numnod;
                continue;
            }
            if (TempComponent instanceof ndb_branch) {
                if (TempComponent instanceof Line) {
                    TempLine = (Line)TempComponent;
                    TempLine.InformPartner(TempLine.ConnComps1, TempLine.getx1(), TempLine.gety1(), 1);
                    TempLine.InformPartner(TempLine.ConnComps2, TempLine.getx2(), TempLine.gety2(), 2);
                    ++this.numlin;
                }
                if (TempComponent instanceof Trafo) {
                    TempComponent.InformAllComponents();
                    ++this.numtran;
                }
                if (TempComponent instanceof ThreeWindingTrafo) {
                    TempComponent.InformAllComponents();
                    ++this.numtranthree;
                    this.numbran += 2;
                }
                if (TempComponent instanceof Upfc) {
                    TempComponent.InformAllComponents();
                    ++this.numupfc;
                }
                if (TempComponent instanceof LineDC) {
                    TempComponent.InformAllComponents();
                    ++this.numlinedc;
                }
                ++this.numbran;
            }
            if (!(TempComponent instanceof Load) || (TemploadVD = (Load)TempComponent).getvd_p() == 0.0 && TemploadVD.getvd_q() == 0.0) continue;
            ++this.numloadvd;
        }
        this.BranchR = new double[this.numbran - this.numlinedc];
        this.BranchX = new double[this.numbran - this.numlinedc];
        this.BranchB = new double[this.numbran - this.numlinedc];
        this.BranchI = new int[this.numbran];
        this.BranchJ = new int[this.numbran];
        this.react = new double[3];
        this.resistencias = new double[3];
        this.ZthreeWinding = new Complex[3];
        this.Zreales = new Complex[3];
        this.nbr = this.numbran - this.numlinedc;
        this.NomBra = new String[this.nbr];
        this.FlujosP = new double[this.nbr];
        this.FlujosQ = new double[this.nbr];
        this.PerdP = new double[this.nbr];
        this.PerdQ = new double[this.nbr];
        this.loadVD = new Load[this.numloadvd];
        this.barraloadVD = new int[this.numloadvd];
        this.slack = -1;
        this.ini_var_sist();
        indicbus = 0;
        int tipocomp = 0;
        String strcomp = "";
        if (this.numupfc > 0) {
            this.TOupfc = new int[this.numupfc][2];
            this.Pesp = new double[this.numupfc];
            this.QEesp = new double[this.numupfc];
            this.QBesp = new double[this.numupfc];
            this.VARupfc = new double[this.numupfc][4];
            this.PARupfc = new double[this.numupfc][4];
            this.Pfexc = new double[this.numnod][this.numupfc];
            this.Pfboost = new double[this.numnod][this.numupfc];
            this.Qfexc = new double[this.numnod][this.numupfc];
            this.Qfboost = new double[this.numnod][this.numupfc];
            for (i = 0; i < this.numupfc; ++i) {
                this.Pesp[i] = 0.0;
                this.QEesp[i] = 0.0;
                this.QBesp[i] = 0.0;
                for (j = 0; j < 2; ++j) {
                    this.TOupfc[i][j] = -1;
                }
                for (j = 0; j < 4; ++j) {
                    this.PARupfc[i][j] = 0.0;
                    this.VARupfc[i][j] = 0.0;
                }
                for (j = 0; j < this.numnod; ++j) {
                    this.Pfexc[j][i] = 0.0;
                    this.Pfboost[j][i] = 0.0;
                    this.Qfexc[j][i] = 0.0;
                    this.Qfboost[j][i] = 0.0;
                }
            }
        }
        if (this.numlinedc > 0) {
            this.TOlinedc = new int[this.numlinedc][2];
            this.Pdr = new double[this.numlinedc];
            this.Pdi = new double[this.numlinedc];
            this.Id = new double[this.numlinedc];
            this.Qrect = new double[this.numlinedc];
            this.Qinver = new double[this.numlinedc];
            this.VARlinedc_k = new double[this.numlinedc][4];
            this.DVlinedc = new double[this.numlinedc][4];
            this.Rk = new double[this.numlinedc][4];
            this.Rfijo = new double[this.numlinedc][4];
            this.DR = new double[this.numlinedc][4];
            this.LimVARlinedc = new double[this.numlinedc][8];
            this.PARlinedc = new double[this.numlinedc][3];
            this.PARrect = new double[this.numlinedc][2];
            this.PARinver = new double[this.numlinedc][2];
            this.NombreLinedc = new String[this.numlinedc];
            this.nb = new double[this.numlinedc];
            this.leng = new double[this.numlinedc];
            for (i = 0; i < this.numlinedc; ++i) {
                this.Pdr[i] = 0.0;
                this.Pdi[i] = 0.0;
                this.Id[i] = 0.0;
                this.Qrect[i] = 0.0;
                this.Qinver[i] = 0.0;
                this.nb[i] = 1.0;
                this.NombreLinedc[i] = " ";
                this.leng[i] = 0.0;
                for (j = 0; j < 2; ++j) {
                    this.TOlinedc[i][j] = -1;
                    this.PARrect[i][j] = 0.0;
                    this.PARinver[i][j] = 0.0;
                }
                for (j = 0; j < 4; ++j) {
                    this.VARlinedc_k[i][j] = 1.0;
                    this.DVlinedc[i][j] = 0.0;
                    this.Rk[i][j] = 0.0;
                    this.Rfijo[i][j] = 0.0;
                    this.DR[i][j] = 0.0;
                }
                for (j = 0; j < 3; ++j) {
                    this.PARlinedc[i][j] = 0.0;
                }
                for (j = 0; j < 8; ++j) {
                    this.LimVARlinedc[i][j] = 0.0;
                }
            }
        }
        for (int f = 0; f < this.numnod; ++f) {
            this.vk0[f] = 1.0;
        }
        for (i = 0; i < 3; ++i) {
            this.react[i] = 0.0;
            this.resistencias[i] = 0.0;
            this.ZthreeWinding[i] = new Complex(1.0, 0.0);
            this.Zreales[i] = new Complex(0.0, 0.0);
        }
        if (this.numnod < 2) {
            this.javaLF_Error("Not valid System, Area or Editor");
        }
        if (this.yearlylf) {
            int barra = 0;
            block17: for (int ip = 0; ip < this.ActSchematic.Components.size(); ++ip) {
                int g;
                TempComponent = (comp)this.ActSchematic.Components.elementAt(ip);
                if (!(TempComponent instanceof ndb_comp) || !(TempNdb_comp = (ndb_comp)TempComponent).getctrla().equals(this.ctrla) && !this.ctrla.equals("ALL CONTROL AREAS")) continue;
                if (TempComponent.getactive() && TempComponent.getvalid() && TempComponent.getinservice() && TempComponent instanceof Load) {
                    int e;
                    TempComponent.InformAllComponents();
                    this.Temploadyearly = (Load)TempComponent;
                    if (this.MyYearlylf != null) {
                        for (e = 0; e < this.MyYearlylf.NameLDB.length; ++e) {
                            if (!this.MyYearlylf.NameLDB[e].equals(this.Temploadyearly.getName())) continue;
                            this.Temploadyearly.setp0(this.MyYearlylf.actLas[e]);
                            this.Temploadyearly.setq0(this.MyYearlylf.reactLas[e]);
                            break;
                        }
                    } else {
                        for (e = 0; e < this.MyMMS.NameLDB.length; ++e) {
                            if (!this.MyMMS.NameLDB[e].equals(this.Temploadyearly.getName())) continue;
                            this.Temploadyearly.setp0(this.MyMMS.actLas[e]);
                            this.Temploadyearly.setq0(this.MyMMS.reactLas[e]);
                            break;
                        }
                    }
                }
                if (!TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice() || !(TempComponent instanceof Generator)) continue;
                TempComponent.InformAllComponents();
                this.Tempgenyearly = (Generator)TempComponent;
                if (this.MyYearlylf != null) {
                    for (g = 0; g < this.MyYearlylf.NameGenDB.length; ++g) {
                        if (!this.MyYearlylf.NameGenDB[g].equals(this.Tempgenyearly.getName())) continue;
                        this.Tempgenyearly.setp0(this.MyYearlylf.actGen[barra]);
                        ++barra;
                        continue block17;
                    }
                    continue;
                }
                for (g = 0; g < this.MyMMS.NameGenDB.length; ++g) {
                    if (!this.MyMMS.NameGenDB[g].equals(this.Tempgenyearly.getName())) continue;
                    this.Tempgenyearly.setp0(this.MyMMS.actGen[barra]);
                    ++barra;
                    continue block17;
                }
            }
        }
        for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
            int indice;
            TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
            if (!(TempComponent instanceof ndb_comp) || !(TempNdb_comp = (ndb_comp)TempComponent).getctrla().equals(this.ctrla) && !this.ctrla.equals("ALL CONTROL AREAS") || !TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice()) continue;
            if (TempComponent instanceof Line) {
                TempLine = (Line)TempComponent;
                con1 = this.numbus(TempLine.getcon1());
                if (con1 > -1 && (con2 = this.numbus(TempLine.getcon2())) > -1) {
                    if (Math.sqrt(TempLine.getxx1() * TempLine.getb1()) * TempLine.getlen() > 0.1396) {
                        System.out.println("No approximations were considered while modeling line: " + TempLine.getName());
                        double[] param = JavaLF.getExactLineParam(TempLine.getr1(), TempLine.getxx1(), TempLine.getg1(), TempLine.getb1(), TempLine.getlen());
                        this.BranchR[count] = param[0];
                        this.BranchX[count] = param[1];
                        this.BranchB[count] = param[3];
                    } else {
                        this.BranchX[count] = TempLine.getxx1() * TempLine.getlen();
                        this.BranchR[count] = TempLine.getr1() * TempLine.getlen();
                        this.BranchB[count] = TempLine.getb1() * TempLine.getlen() / 2.0;
                    }
                    this.BranchI[count] = con1;
                    this.BranchJ[count] = con2;
                    double Ybase = this.sref / (TempLine.getun1() * TempLine.getun1());
                    this.BranchX[count] = this.BranchX[count] * Ybase;
                    this.BranchR[count] = this.BranchR[count] * Ybase;
                    this.BranchB[count] = this.BranchB[count] / Ybase;
                    auxc1 = new Complex(this.BranchR[count], this.BranchX[count]);
                    if (Complex.abs((Complex)auxc1) < 1.0E-9) {
                        this.javaLF_Error("Line \"" + TempLine.getName() + "\"" + ", too low Impedance.");
                    }
                    auxc2 = new Complex(1.0);
                    auxc1 = auxc2.divide(auxc1);
                    auxc2 = new Complex(0.0, this.BranchB[count]);
                    this.Ybus[this.BranchJ[count]][this.BranchI[count]].add(Complex.negate((Complex)auxc1));
                    this.Ybus[this.BranchI[count]][this.BranchJ[count]].add(Complex.negate((Complex)auxc1));
                    this.Ybus[this.BranchI[count]][this.BranchI[count]].add(Complex.add((Complex)auxc1, (Complex)auxc2));
                    this.Ybus[this.BranchJ[count]][this.BranchJ[count]].add(Complex.add((Complex)auxc1, (Complex)auxc2));
                    this.matCx[this.BranchJ[count]][this.BranchI[count]] = true;
                    this.matCx[this.BranchI[count]][this.BranchJ[count]] = true;
                    ++count;
                    continue;
                }
                this.javaLF_Error("Line \"" + TempLine.getName() + "\"" + ", is not connected");
                continue;
            }
            if (TempComponent instanceof Trafo) {
                Trafo TempTrafo = (Trafo)TempComponent;
                TempTrafo.actualizet();
                con1 = this.numbus(TempTrafo.getcon1());
                if (con1 > -1 && (con2 = this.numbus(TempTrafo.getcon2())) > -1) {
                    ueb1 = TempTrafo.getun1() / TempTrafo.getun2() / (TempTrafo.getur1() / TempTrafo.getur2());
                    ueb = TempTrafo.getur1() / TempTrafo.getun1();
                    res = TempTrafo.getpcu() * 0.001 * ueb * ueb / TempTrafo.getsn() * this.sref / TempTrafo.getsn() * ueb1 * ueb1;
                    z = TempTrafo.getuk() * 0.01 * ueb * ueb * this.sref / TempTrafo.getsn() * ueb1 * ueb1;
                    b = TempTrafo.geti0() * 0.01 * 0.5 / this.sref * TempTrafo.getsn() / ueb / ueb;
                    reac = TempTrafo.getuk() >= 0.0 ? Math.sqrt(z * z - res * res) : -Math.sqrt(z * z - res * res);
                    this.BranchX[count] = reac;
                    this.BranchR[count] = res;
                    this.BranchB[count] = -b;
                    this.BranchI[count] = con1;
                    this.BranchJ[count] = con2;
                    auxc1 = new Complex(this.BranchR[count], this.BranchX[count]);
                    if (Complex.abs((Complex)auxc1) < 1.0E-9) {
                        this.javaLF_Error("Trafo \"" + TempTrafo.getName() + "\"" + ", too low Impedance.");
                    }
                    auxc2 = new Complex(1.0);
                    auxc1 = Complex.divide((Complex)auxc2, (Complex)auxc1);
                    auxc2 = new Complex(0.0, this.BranchB[count]);
                    this.Ybus[this.BranchJ[count]][this.BranchI[count]].add(Complex.negate((Complex)Complex.divide((Complex)auxc1, (double)TempTrafo.gett_re())));
                    this.Ybus[this.BranchI[count]][this.BranchJ[count]].add(Complex.negate((Complex)Complex.divide((Complex)auxc1, (double)TempTrafo.gett_re())));
                    this.Ybus[this.BranchI[count]][this.BranchI[count]].add(Complex.add((Complex)auxc1, (Complex)auxc2).divide(TempTrafo.gett_re() * TempTrafo.gett_re()));
                    this.Ybus[this.BranchJ[count]][this.BranchJ[count]].add(Complex.add((Complex)auxc1, (Complex)auxc2));
                    this.matCx[this.BranchJ[count]][this.BranchI[count]] = true;
                    this.matCx[this.BranchI[count]][this.BranchJ[count]] = true;
                    ++count;
                    continue;
                }
                this.javaLF_Error("Trafo \"" + TempTrafo.getName() + "\"" + ", is not connected.");
                continue;
            }
            if (TempComponent instanceof ThreeWindingTrafo) {
                ThreeWindingTrafo tempTrafo3enr = (ThreeWindingTrafo)TempComponent;
                tempTrafo3enr.actualizet();
                con1 = this.numbus(tempTrafo3enr.getcon1());
                if (con1 > -1 && (con2 = this.numbus(tempTrafo3enr.getcon2())) > -1 && (con3 = this.numbus(tempTrafo3enr.getcon3())) > -1) {
                    ueb1 = tempTrafo3enr.getun1() / tempTrafo3enr.getun2() / (tempTrafo3enr.getur1() / tempTrafo3enr.getur2());
                    ueb2 = tempTrafo3enr.getun1() / tempTrafo3enr.getun3() / (tempTrafo3enr.getur1() / tempTrafo3enr.getur3());
                    ueb3 = tempTrafo3enr.getun2() / tempTrafo3enr.getun3() / (tempTrafo3enr.getur2() / tempTrafo3enr.getur3());
                    potapa1 = tempTrafo3enr.getsn() > tempTrafo3enr.getsn1() ? tempTrafo3enr.getsn1() : tempTrafo3enr.getsn();
                    potapa2 = tempTrafo3enr.getsn() > tempTrafo3enr.getsn2() ? tempTrafo3enr.getsn2() : tempTrafo3enr.getsn();
                    potapa3 = tempTrafo3enr.getsn1() > tempTrafo3enr.getsn2() ? tempTrafo3enr.getsn2() : tempTrafo3enr.getsn1();
                    this.resistencias[0] = tempTrafo3enr.getpcu() * (0.001 / (potapa1 * potapa1)) * this.sref;
                    this.resistencias[1] = tempTrafo3enr.getpcu13() * (0.001 / (potapa2 * potapa2)) * this.sref;
                    this.resistencias[2] = tempTrafo3enr.getpcu23() * (0.001 / (potapa3 * potapa3)) * this.sref;
                    Zk12 = tempTrafo3enr.getuk12() * 0.01 * this.sref / potapa1;
                    Zk13 = tempTrafo3enr.getuk13() * 0.01 * this.sref / potapa2;
                    Zk23 = tempTrafo3enr.getuk23() * 0.01 * this.sref / potapa3;
                    tap1 = tempTrafo3enr.gett_re();
                    tap2 = tempTrafo3enr.gett_re1();
                    tap3 = tempTrafo3enr.gett_re2();
                    c = 0;
                    parestrafo = 0;
                    this.react[0] = tempTrafo3enr.getuk12() >= 0.0 ? Math.sqrt(Zk12 * Zk12 - this.resistencias[0] * this.resistencias[0]) : -Math.sqrt(Zk12 * Zk12 - this.resistencias[0] * this.resistencias[0]);
                    this.react[1] = tempTrafo3enr.getuk13() >= 0.0 ? Math.sqrt(Zk13 * Zk13 - this.resistencias[1] * this.resistencias[1]) : -Math.sqrt(Zk13 * Zk13 - this.resistencias[1] * this.resistencias[1]);
                    this.react[2] = tempTrafo3enr.getuk23() >= 0.0 ? Math.sqrt(Zk23 * Zk23 - this.resistencias[2] * this.resistencias[2]) : -Math.sqrt(Zk23 * Zk23 - this.resistencias[2] * this.resistencias[2]);
                    this.ZthreeWinding[0] = new Complex(0.5 * (this.resistencias[0] + this.resistencias[1] - this.resistencias[2]), 0.5 * (this.react[0] + this.react[1] - this.react[2]));
                    this.ZthreeWinding[1] = new Complex(0.5 * (this.resistencias[0] + this.resistencias[2] - this.resistencias[1]), 0.5 * (this.react[0] + this.react[2] - this.react[1]));
                    this.ZthreeWinding[2] = new Complex(0.5 * (this.resistencias[1] + this.resistencias[2] - this.resistencias[0]), 0.5 * (this.react[1] + this.react[2] - this.react[0]));
                    Zrama12 = new Complex(this.resistencias[0], this.react[0]);
                    Zrama13 = new Complex(this.resistencias[1], this.react[1]);
                    Zrama23 = new Complex(this.resistencias[2], this.react[2]);
                    this.Zreales[0] = Complex.add((Complex)Zrama12, (Complex)Complex.divide((Complex)Complex.multiply((Complex)this.ZthreeWinding[0], (Complex)this.ZthreeWinding[1]), (Complex)this.ZthreeWinding[2]));
                    this.Zreales[1] = Complex.add((Complex)Zrama13, (Complex)Complex.divide((Complex)Complex.multiply((Complex)this.ZthreeWinding[0], (Complex)this.ZthreeWinding[2]), (Complex)this.ZthreeWinding[1]));
                    this.Zreales[2] = Complex.add((Complex)Zrama23, (Complex)Complex.divide((Complex)Complex.multiply((Complex)this.ZthreeWinding[1], (Complex)this.ZthreeWinding[2]), (Complex)this.ZthreeWinding[0]));
                    auxc3 = new Complex(0.0, b);
                    fintrafo = count + 3;
                    for (count = countaux = count; count < fintrafo; ++count) {
                        this.BranchX[count] = this.Zreales[c].im;
                        this.BranchR[count] = this.Zreales[c].re;
                        this.BranchB[count] = -b;
                        auxc1 = new Complex(this.ZthreeWinding[c]);
                        if (Complex.abs((Complex)auxc1) < 1.0E-9) {
                            this.javaLF_Error("Three Winding Trafo \"" + tempTrafo3enr.getName() + "\"" + ", too low Impedance.");
                        }
                        auxc2 = new Complex(1.0);
                        auxc1 = Complex.divide((Complex)auxc2, (Complex)auxc1);
                        auxc2 = new Complex(0.0, this.BranchB[count]);
                        if (c == 0) {
                            ramaY1 = auxc1;
                        } else if (c == 1) {
                            ramaY2 = auxc1;
                        } else if (c == 2) {
                            ramaY3 = auxc1;
                        }
                        ++c;
                    }
                    A1 = Complex.divide((Complex)ramaY1, (Complex)Complex.add((Complex)ramaY1, (Complex)Complex.add((Complex)ramaY2, (Complex)ramaY3)));
                    A2 = Complex.divide((Complex)ramaY2, (Complex)Complex.add((Complex)ramaY1, (Complex)Complex.add((Complex)ramaY2, (Complex)ramaY3)));
                    A3 = Complex.add((Complex)ramaY1, (Complex)Complex.add((Complex)ramaY2, (Complex)ramaY3));
                    invertA3 = Complex.divide((Complex)neutro, (Complex)A3);
                    factory = Complex.multiply((Complex)A3, (Complex)auxc3);
                    for (count = countaux; count < fintrafo; ++count) {
                        if (parestrafo == 0) {
                            this.BranchI[count] = con1;
                            this.BranchJ[count] = con2;
                            Afinal = A1;
                            ramaY = ramaY2;
                            tapdiag1 = tap1 * tap1;
                            tapnodiag = tap1 * tap2;
                            tapdiag2 = tap2 * tap2;
                            if (tempTrafo3enr.getlado().equals("HV")) {
                                primerdiag = factory;
                                segundiag = new Complex(0.0, 0.0);
                            }
                        } else if (parestrafo == 1) {
                            this.BranchI[count] = con1;
                            this.BranchJ[count] = con3;
                            Afinal = A1;
                            ramaY = ramaY3;
                            tapdiag1 = tap1 * tap1;
                            tapnodiag = tap1 * tap3;
                            tapdiag2 = tap3 * tap3;
                            if (tempTrafo3enr.getlado().equals("LV")) {
                                primerdiag = new Complex(0.0, 0.0);
                                segundiag = factory;
                            }
                        } else if (parestrafo == 2) {
                            this.BranchI[count] = con2;
                            this.BranchJ[count] = con3;
                            Afinal = A2;
                            ramaY = ramaY3;
                            tapdiag1 = tap2 * tap2;
                            tapnodiag = tap2 * tap3;
                            tapdiag2 = tap3 * tap3;
                            if (tempTrafo3enr.getlado().equals("MV")) {
                                primerdiag = factory;
                                segundiag = new Complex(0.0, 0.0);
                            }
                        }
                        invertapdiag1 = new Complex(tapdiag1, 0.0);
                        invertapnodiag = new Complex(tapnodiag, 0.0);
                        invertapdiag2 = new Complex(tapdiag2, 0.0);
                        invertapdiag1 = Complex.divide((Complex)neutro, (double)tapdiag1);
                        invertapnodiag = Complex.divide((Complex)neutro, (double)tapnodiag);
                        invertapdiag2 = Complex.divide((Complex)neutro, (double)tapdiag2);
                        this.Ybus[this.BranchJ[count]][this.BranchI[count]].add(Complex.negate((Complex)Complex.multiply((Complex)ramaY, (Complex)Complex.multiply((Complex)Afinal, (Complex)invertapnodiag))));
                        this.Ybus[this.BranchI[count]][this.BranchJ[count]].add(Complex.negate((Complex)Complex.multiply((Complex)ramaY, (Complex)Complex.multiply((Complex)Afinal, (Complex)invertapnodiag))));
                        this.Ybus[this.BranchI[count]][this.BranchI[count]].add(Complex.add((Complex)Complex.multiply((Complex)ramaY, (Complex)Complex.multiply((Complex)Afinal, (Complex)invertapdiag1)), (Complex)Complex.multiply((Complex)primerdiag, (Complex)Complex.multiply((Complex)invertA3, (Complex)invertapdiag1))));
                        this.Ybus[this.BranchJ[count]][this.BranchJ[count]].add(Complex.add((Complex)Complex.multiply((Complex)ramaY, (Complex)Complex.multiply((Complex)Afinal, (Complex)invertapdiag2)), (Complex)Complex.multiply((Complex)segundiag, (Complex)Complex.multiply((Complex)invertA3, (Complex)invertapdiag2))));
                        this.matCx[this.BranchJ[count]][this.BranchI[count]] = true;
                        this.matCx[this.BranchI[count]][this.BranchJ[count]] = true;
                        ++parestrafo;
                        primerdiag = new Complex(0.0, 0.0);
                        segundiag = new Complex(0.0, 0.0);
                    }
                    continue;
                }
                this.javaLF_Error("Three Winding Trafo \"" + tempTrafo3enr.getName() + "\"" + ", is not connected.");
                continue;
            }
            if (TempComponent instanceof Upfc) {
                Upfc TempUpfc = (Upfc)TempComponent;
                con1 = this.numbus(TempUpfc.getcon1());
                if (con1 > -1 && (con2 = this.numbus(TempUpfc.getcon2())) > -1) {
                    double auxr = TempUpfc.getun1() * TempUpfc.getun1() / this.sref;
                    rserie = 0.0;
                    xserie = TempUpfc.getxboost() / auxr;
                    gshunt = 0.0;
                    bshunt = 1.0 / (TempUpfc.getxexc() / auxr);
                    this.BranchX[count] = xserie;
                    this.BranchR[count] = rserie;
                    this.BranchB[count] = bshunt;
                    this.BranchI[count] = con1;
                    this.BranchJ[count] = con2;
                    this.PARupfc[countupfc][0] = rserie;
                    this.PARupfc[countupfc][1] = xserie;
                    this.PARupfc[countupfc][2] = gshunt;
                    this.PARupfc[countupfc][3] = bshunt;
                    this.TOupfc[countupfc][0] = this.BranchI[count];
                    this.TOupfc[countupfc][1] = this.BranchJ[count];
                    this.Pesp[countupfc] = TempUpfc.getpspec() / this.sref;
                    this.QEesp[countupfc] = TempUpfc.getqeinj() / this.sref;
                    this.QBesp[countupfc] = TempUpfc.getqbinj() / this.sref;
                    auxc1 = new Complex(this.BranchR[count], this.BranchX[count]);
                    if (Complex.abs((Complex)auxc1) < 1.0E-9) {
                        this.javaLF_Error("Upfc \"" + TempUpfc.getName() + "\"" + ", too low Impedance.");
                    }
                    auxc2 = new Complex(1.0, 0.0);
                    auxc1 = Complex.divide((Complex)auxc2, (Complex)auxc1);
                    auxc2 = new Complex(0.0, this.BranchB[count]);
                    Complex auxzero = new Complex(0.0, 0.0);
                    this.Ybus[this.BranchJ[count]][this.BranchI[count]].add(Complex.negate((Complex)auxzero));
                    this.Ybus[this.BranchI[count]][this.BranchJ[count]].add(Complex.negate((Complex)auxzero));
                    this.Ybus[this.BranchI[count]][this.BranchI[count]].add(Complex.add((Complex)auxzero, (Complex)auxzero));
                    this.Ybus[this.BranchJ[count]][this.BranchJ[count]].add(Complex.add((Complex)auxzero, (Complex)auxzero));
                    int n = this.BranchI[count];
                    this.Pinj[n] = this.Pinj[n] - this.Pesp[countupfc];
                    int n2 = this.BranchJ[count];
                    this.Pinj[n2] = this.Pinj[n2] + this.Pesp[countupfc];
                    int n3 = this.BranchI[count];
                    this.Qinj[n3] = this.Qinj[n3] - this.QEesp[countupfc];
                    int n4 = this.BranchJ[count];
                    this.Qinj[n4] = this.Qinj[n4] - this.QBesp[countupfc];
                    this.matCx[this.BranchJ[count]][this.BranchI[count]] = true;
                    this.matCx[this.BranchI[count]][this.BranchJ[count]] = true;
                    ++count;
                    ++countupfc;
                    continue;
                }
                this.javaLF_Error("Upfc \"" + TempUpfc.getName() + "\"" + ", is not connected.");
                continue;
            }
            if (TempComponent instanceof LineDC) {
                LineDC TempLineDC = (LineDC)TempComponent;
                this.NombreLinedc[countlinedc] = TempLineDC.getName();
                this.nb[countlinedc] = TempLineDC.getnbridge();
                con1 = this.numbus(TempLineDC.getcon1());
                if (con1 > -1 && (con2 = this.numbus(TempLineDC.getcon2())) > -1) {
                    double sapo1 = 1.0;
                    double sapo2 = 1.0;
                    double zbase = TempLineDC.getun1() * TempLineDC.getun1() / this.sref;
                    double vbase = TempLineDC.getun1();
                    this.leng[countlinedc] = TempLineDC.getlen();
                    rlinedc = TempLineDC.getlresis() / zbase * this.leng[countlinedc];
                    svolt = TempLineDC.getsv() / vbase;
                    npuente = TempLineDC.getnbridge();
                    this.BranchI[count] = con1;
                    this.BranchJ[count] = con2;
                    this.TOlinedc[countlinedc][0] = this.BranchI[count];
                    this.TOlinedc[countlinedc][1] = this.BranchJ[count];
                    this.Pdr[countlinedc] = TempLineDC.getpotdrec() / this.sref;
                    vdi = TempLineDC.getvinv() / vbase;
                    discri = Math.pow(vdi, 2.0) + 4.0 * rlinedc * this.Pdr[countlinedc];
                    this.Id[countlinedc] = -vdi / (2.0 * rlinedc) + Math.sqrt(discri) / (2.0 * rlinedc);
                    this.Pdi[countlinedc] = vdi * this.Id[countlinedc];
                    this.Qrect[countlinedc] = TempLineDC.getqrect() / this.sref;
                    this.Qinver[countlinedc] = TempLineDC.getqinver() / this.sref;
                    this.Rfijo[countlinedc][0] = this.Pdr[countlinedc];
                    this.Rfijo[countlinedc][1] = this.Pdi[countlinedc];
                    this.Rfijo[countlinedc][2] = Math.pow(this.Pdr[countlinedc], 2.0) + Math.pow(this.Qrect[countlinedc], 2.0);
                    this.Rfijo[countlinedc][3] = Math.pow(this.Pdi[countlinedc], 2.0) + Math.pow(this.Qinver[countlinedc], 2.0);
                    int n = this.BranchI[count];
                    this.Pinj[n] = this.Pinj[n] - this.Pdr[countlinedc];
                    int n5 = this.BranchI[count];
                    this.Qinj[n5] = this.Qinj[n5] - this.Qrect[countlinedc];
                    int n6 = this.BranchJ[count];
                    this.Pinj[n6] = this.Pinj[n6] + this.Pdi[countlinedc];
                    int n7 = this.BranchJ[count];
                    this.Qinj[n7] = this.Qinj[n7] - this.Qinver[countlinedc];
                    this.LimVARlinedc[countlinedc][0] = TempLineDC.getminfir() * auxang;
                    this.LimVARlinedc[countlinedc][1] = TempLineDC.getmaxfir() * auxang;
                    this.LimVARlinedc[countlinedc][2] = TempLineDC.getminext() * auxang;
                    this.LimVARlinedc[countlinedc][3] = TempLineDC.getmaxext() * auxang;
                    this.LimVARlinedc[countlinedc][4] = TempLineDC.getmintapr();
                    this.LimVARlinedc[countlinedc][5] = TempLineDC.getmaxtapr();
                    this.LimVARlinedc[countlinedc][6] = TempLineDC.getmintapi();
                    this.LimVARlinedc[countlinedc][7] = TempLineDC.getmaxtapi();
                    this.VARlinedc_k[countlinedc][0] = this.LimVARlinedc[countlinedc][0];
                    this.VARlinedc_k[countlinedc][1] = this.LimVARlinedc[countlinedc][2];
                    this.VARlinedc_k[countlinedc][2] = sapo1;
                    this.VARlinedc_k[countlinedc][3] = sapo2;
                    this.PARlinedc[countlinedc][0] = npuente;
                    this.PARlinedc[countlinedc][1] = rlinedc;
                    this.PARlinedc[countlinedc][2] = svolt;
                    this.PARrect[countlinedc][0] = TempLineDC.getreacrec();
                    this.PARrect[countlinedc][1] = TempLineDC.getresrec() / zbase;
                    this.PARinver[countlinedc][0] = TempLineDC.getreacinv();
                    this.PARinver[countlinedc][1] = TempLineDC.getresinv() / zbase;
                    this.matCx[this.BranchJ[count]][this.BranchI[count]] = true;
                    this.matCx[this.BranchI[count]][this.BranchJ[count]] = true;
                    ++count;
                    ++countlinedc;
                    continue;
                }
                this.javaLF_Error("Line DC \"" + TempLineDC.getName() + "\"" + ", is not connected.");
                continue;
            }
            if (!(TempComponent instanceof ndb_1pol)) continue;
            TempComponent.InformAllComponents();
            ndb_1pol Temp1pol = (ndb_1pol)TempComponent;
            double p0 = -Temp1pol.getp0() / this.sref;
            double q0 = -Temp1pol.getq0() / this.sref;
            if (Temp1pol instanceof Busbar) {
                tipocomp = 0;
                strcomp = "Busbar";
                indice = indicbus++;
                continue;
            }
            indice = this.numbus(Temp1pol.getcon2());
            if (Temp1pol instanceof Load) {
                Load Temp1load = (Load)Temp1pol;
                tipocomp = 1;
                strcomp = "Load";
                if (Temp1load.getvd_p() != 0.0) {
                    p0 = 0.0;
                    q0 = 0.0;
                }
                if (Temp1load.getvd_q() != 0.0) {
                    p0 = 0.0;
                    q0 = 0.0;
                }
                Temp1load = null;
            } else if (Temp1pol instanceof Generator) {
                p0 = -p0;
                q0 = -q0;
                tipocomp = 4;
                strcomp = "Generator";
                if (!this.limqrect) {
                    Generator Tempgen = (Generator)Temp1pol;
                    GeneratorFrame Mygenframe = new GeneratorFrame(Tempgen, this.limqrect);
                    qmin_diag = Mygenframe.getlimqmin();
                    qmax_diag = Mygenframe.getlimqmax();
                    if (qmin_diag < -Tempgen.getsmax() || qmax_diag > Tempgen.getsmax() || qmax_diag <= 0.0) {
                        System.out.println("Error en calculo de limites de Q. Revice Diag. de Oper. de: " + Tempgen.getName().trim());
                        this.javaLF_Error("En c\u00e1lculo de l\u00edmites de reactivos de: " + Tempgen.getName().trim());
                    }
                }
            } else if (Temp1pol instanceof Injection) {
                p0 = -p0;
                q0 = -q0;
                tipocomp = 5;
                strcomp = "Injection";
            } else if (Temp1pol instanceof SVC) {
                p0 = 0.0;
                q0 = -q0;
                tipocomp = 6;
                strcomp = "SVC";
            } else {
                this.javaLF_Error("There\u00b4s an unknown component in system");
            }
            if (indice == -1) {
                this.javaLF_Error(strcomp + " \"" + Temp1pol.getName() + "\"" + ", is not properly connected.");
            }
            if (Temp1pol.getlf_type() != 4) {
                if (tipocomp == 4) {
                    if (Temp1pol.getlf_type() == 3) {
                        if (this.slack > -1) {
                            if (this.indic_bSL != indice) {
                                Generator TempGenerator = (Generator)this.ActSchematic.Components.elementAt(this.slack);
                                strcomp = TempGenerator.getName();
                                this.javaLF_Error("There\u00b4s more than one slack busbar \"" + Temp1pol.getName() + "\" " + "\"" + strcomp + "\"");
                            }
                        } else {
                            this.slack = ix;
                            this.indic_bSL = indice;
                            p0 = 0.0;
                        }
                    }
                    if (Temp1pol.getlf_type() > 1) {
                        this.tipobarra[indice] = Temp1pol.getlf_type();
                        TempInj = (ndb_inj)Temp1pol;
                        this.vk[indice] = TempInj.getus();
                        if (this.vk[indice] > 1.5 || this.vk[indice] < 0.5) {
                            this.conver = -2;
                        }
                        if (this.vk[indice] > 1.5 || this.vk[indice] < 0.5) {
                            this.javaLF_Warning("Voltaje impuesto en \"" + Temp1pol.getName() + "\" ");
                        }
                        q0 = 0.0;
                        if (TempInj.getqmin() >= TempInj.getqmax()) {
                            this.javaLF_Error(strcomp + " \"" + Temp1pol.getName() + "\"" + ", not valid rective generation limits.");
                        }
                        if (!this.limqrect) {
                            int n = indice;
                            this.QGmin[n] = this.QGmin[n] + qmin_diag / this.sref;
                            int n8 = indice;
                            this.QGmax[n8] = this.QGmax[n8] + qmax_diag / this.sref;
                        } else {
                            int n = indice;
                            this.QGmin[n] = this.QGmin[n] + TempInj.getqmin() / this.sref;
                            int n9 = indice;
                            this.QGmax[n9] = this.QGmax[n9] + TempInj.getqmax() / this.sref;
                        }
                    }
                }
                if (tipocomp == 6 && Temp1pol.getlf_type() > 1) {
                    this.tipobarra[indice] = Temp1pol.getlf_type();
                    TempInj = (ndb_inj)Temp1pol;
                    this.vk[indice] = TempInj.getus();
                    if (this.vk[indice] > 1.5 || this.vk[indice] < 0.5) {
                        this.javaLF_Warning("Voltaje impuesto en \"" + Temp1pol.getName() + "\" ");
                    }
                    q0 = 0.0;
                    if (TempInj.getqmin() >= TempInj.getqmax()) {
                        this.javaLF_Error(strcomp + " \"" + Temp1pol.getName() + "\"" + ", not valid rective generation limits.");
                    }
                    int n = indice;
                    this.QGmin[n] = this.QGmin[n] + TempInj.getqmin() / this.sref;
                    int n10 = indice;
                    this.QGmax[n10] = this.QGmax[n10] + TempInj.getqmax() / this.sref;
                }
                int n = indice;
                this.Pinj[n] = this.Pinj[n] + p0;
                int n11 = indice;
                this.Qinj[n11] = this.Qinj[n11] + q0;
                continue;
            }
            auxc1.re = -Temp1pol.getp0() / this.sref;
            auxc1.im = Temp1pol.getq0() / this.sref;
            this.Ybus[indice][indice].add(auxc1);
        }
        int id = 0;
        TempComponent = null;
        ix = 0;
        for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
            TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
            if (!TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice() || !(TempComponent instanceof Load)) continue;
            TempComponent.InformAllComponents();
            TemploadVD = (Load)TempComponent;
            if (TemploadVD.getvd_p() == 0.0 && TemploadVD.getvd_q() == 0.0) continue;
            this.loadVD[id] = TemploadVD;
            this.barraloadVD[id] = this.numbus(TemploadVD.getcon2());
            ++id;
            TemploadVD = null;
            TempComponent = null;
        }
        System.out.println("Initial load finished.");
        System.out.print("Verifying Cx...");
        this.verificarGrafo();
        System.out.println(" OK.");
        if (this.slack < 0) {
            this.javaLF_Error("there\u00b4s not slack busbar in system");
        }
        if ((TempComponent = (comp)this.ActSchematic.Components.elementAt(this.slack)) instanceof ndb_inj) {
            TempInj = (ndb_inj)TempComponent;
            this.angref = TempInj.getdelta_s() * Math.PI / 180.0;
        } else {
            this.javaLF_Error("The slack busbar isn't a generation busbar");
        }
        for (i = 0; i < this.numnod; ++i) {
            this.dk[i] = this.angref;
            if (this.tipobarra[i] != 1) continue;
            this.vk[i] = 1.0;
        }
        System.out.println("Cargado voltajes OK");
        for (i = 0; i < this.numnod; ++i) {
            this.Pdatfijo[i] = this.Pinj[i];
            this.Qdatfijo[i] = this.Qinj[i];
            switch (this.tipobarra[i]) {
                case 1: {
                    this.indic_bPQ[0] = this.indic_bPQ[0] + 1;
                    this.indic_bPQ[this.indic_bPQ[0]] = i;
                    this.indic_bPX[0] = this.indic_bPX[0] + 1;
                    this.indic_bPX[this.indic_bPQ[0]] = i;
                    break;
                }
                case 2: {
                    this.indic_bPX[0] = this.indic_bPX[0] + 1;
                    this.indic_bPX[this.indic_bPX[0]] = i;
                    this.indic_bPV[0] = this.indic_bPV[0] + 1;
                    this.indic_bPV[this.indic_bPV[0]] = i;
                    break;
                }
                case 3: {
                    this.indic_bSL = i;
                    this.indic_bPV[0] = this.indic_bPV[0] + 1;
                    this.indic_bPV[this.indic_bPV[0]] = i;
                    break;
                }
                default: {
                    this.javaLF_Error("There\u00b4s an unknown type of busbar in system");
                }
            }
            for (j = 0; j < this.numnod; ++j) {
                if (this.Ybus[i][j].re != 0.0) {
                    this.Gbus.setElementAt(i, j, this.Ybus[i][j].re);
                    this.LFJ.setElementAt(i, j, 1.1);
                }
                if (this.Ybus[i][j].im == 0.0) continue;
                this.Bbus.setElementAt(i, j, this.Ybus[i][j].im);
                this.LFJ.setElementAt(i, j, 1.1);
            }
            for (j = 0; j < this.numnod; ++j) {
                if (this.Ybus[i][j].re == 0.0 && this.Ybus[i][j].im == 0.0) continue;
                this.LFJ.setElementAt(i, j + this.numnod, 1.1);
            }
        }
        for (i = 0; i <= this.indic_bPV[0]; ++i) {
            this.indic_bsetPV[i] = this.indic_bPV[i];
        }
        for (i = 0; i < this.numnod; ++i) {
            for (j = 0; j < this.numnod; ++j) {
                if (this.Ybus[i][j].re == 0.0 && this.Ybus[i][j].im == 0.0) continue;
                this.LFJ.setElementAt(i + this.numnod, j, 1.1);
            }
            for (j = 0; j < this.numnod; ++j) {
                if (this.Ybus[i][j].re == 0.0 && this.Ybus[i][j].im == 0.0) continue;
                this.LFJ.setElementAt(i + this.numnod, j + this.numnod, 1.1);
            }
        }
        this.Ybus = null;
    }

    public int numbus(String Busbarname) {
        for (int ix = 0; ix < this.BusbarVector.size(); ++ix) {
            comp TempComponent = (comp)this.BusbarVector.elementAt(ix);
            if (TempComponent.getName().hashCode() != Busbarname.hashCode() || !TempComponent.getName().equals(Busbarname)) continue;
            return ix;
        }
        return -1;
    }

    private void ini_var_sist() {
        int i;
        this.Ybus = new Complex[this.numnod][this.numnod];
        this.matCx = new boolean[this.numnod][this.numnod];
        for (i = 0; i < this.numnod; ++i) {
            for (int j = 0; j < this.numnod; ++j) {
                this.Ybus[i][j] = new Complex(0.0, 0.0);
            }
        }
        this.Pinj = new double[this.numnod];
        this.Qinj = new double[this.numnod];
        this.QGmin = new double[this.numnod];
        this.QGmax = new double[this.numnod];
        this.tipobarra = new int[this.numnod];
        this.indic_bPX = new int[this.numnod + 1];
        this.indic_bPQ = new int[this.numnod + 1];
        this.indic_bPV = new int[this.numnod + 1];
        this.indic_bvQ = new int[this.numnod + 1];
        this.indic_bsetPV = new int[this.numnod + 1];
        this.volt_state = new double[this.numnod];
        this.delta_state = new double[this.numnod];
        for (i = 0; i < this.numnod; ++i) {
            this.tipobarra[i] = 1;
            this.volt_state[i] = 1.0;
        }
        this.indic_bvQ[0] = 0;
        this.indic_bPV[0] = 0;
        this.indic_bPQ[0] = 0;
        this.indic_bPX[0] = 0;
        this.Gbus = new SparseMatrix(this.numnod, this.numnod);
        this.Bbus = new SparseMatrix(this.numnod, this.numnod);
        this.LFJ = new SparseMatrix(2 * this.numnod + 4 * this.numlinedc, 2 * this.numnod + 4 * this.numlinedc);
        this.LFJ.setEpsilon(1.0E-10);
        this.vk = new double[this.numnod];
        this.vk0 = new double[this.numnod];
        this.dk = new double[this.numnod];
        this.Dv = new double[this.numnod];
        this.Ddv = new double[this.numnod];
        this.Pdatfijo = new double[this.numnod];
        this.Pdatactual = new double[this.numnod];
        this.Pk = new double[this.numnod];
        this.Qdatfijo = new double[this.numnod];
        this.Qdatactual = new double[this.numnod];
        this.Qk = new double[this.numnod];
        this.DPv = new double[this.numnod];
        this.DQv = new double[this.numnod];
    }

    void javaLF_Error(String mensaje) throws JavaLFException {
        StringTokenizer st = new StringTokenizer(mensaje, ":");
        mensaje = st.nextToken();
        throw new JavaLFException(mensaje);
    }

    void javaLF_Warning(String mensaje) {
        System.out.println(mensaje);
    }

    private void calcular_LF(FileOutputStream os) throws Exception {
        int i;
        PrintWriter myPrintStream = new PrintWriter(os, true);
        DataInputStream inData = new DataInputStream(System.in);
        double[] vold = new double[this.numnod];
        double[] dold = new double[this.numnod];
        double[][] VARold = new double[this.numlinedc][4];
        double[] auxun = new double[this.numnod];
        double max_err_med0 = 0.0;
        double max_err_med1 = 0.0;
        double max_err_DC = 0.0;
        boolean seguir = true;
        boolean QgOK = false;
        boolean converge = false;
        boolean re3angonit = true;
        for (i = 0; i < this.numnod; ++i) {
            auxun[i] = 1.0;
        }
        boolean bl = QgOK = !this.verifQlim;
        if (!this.yearlylf) {
            System.out.println("\nJava Load Flow Applied to System: " + this.ActSchematic.getsysname());
        }
        if (this.repconv) {
            myPrintStream.println("Java Load Flow Applied to System: " + this.ActSchematic.getsysname());
        }
        if (!this.ctrla.equals("ALL CONTROL AREAS")) {
            System.out.println("restricted to area: " + this.ctrla);
            myPrintStream.println("restricted to area: " + this.ctrla);
        }
        myPrintStream.println("\n\n");
        if (!this.yearlylf) {
            System.out.println("\n");
            System.out.println("\n\t\tCalculation Process Started");
            System.out.println("\t\t---------------------------");
            System.out.println("\nIn process Iteration: " + this.itercount);
        }
        if (this.repconv) {
            myPrintStream.println("\n\t\t           Convergence Report");
            myPrintStream.println("\t\t           ------------------");
            myPrintStream.println("\nSatating calculus: " + this.itercount);
        }
        this.actualizar_PkQk(this.Pk, this.Qk, this.vk, this.dk, this.Gbus, this.Bbus);
        this.actualizar_PdatQdat(this.loadVD, this.barraloadVD, this.Pdatfijo, this.Pdatactual, this.vk0, this.vk);
        this.actualizar_PdatQdat(this.loadVD, this.barraloadVD, this.Qdatfijo, this.Qdatactual, this.vk0, this.vk);
        this.actualizar_Rk(this.Rk, this.VARlinedc_k, this.vk, this.PARlinedc, this.Id, this.TOlinedc, this.PARrect, this.PARinver, this.numlinedc, this.nb);
        this.calc_desv_Pot(this.DPv, this.Pdatactual, this.Pk, this.vk);
        this.calc_desv_Pot(this.DQv, this.Qdatactual, this.Qk, this.vk);
        this.anularD_bPVSL(this.DPv, this.DQv, this.indic_bSL, this.indic_bPV);
        this.max_err_P = this.max_err(this.DPv, this.vk);
        this.max_err_Q = this.max_err(this.DQv, this.vk);
        max_err_DC = this.max_err_Ldc(this.DR);
        max_err_med1 = Math.sqrt(this.max_err_P * this.max_err_P + this.max_err_Q * this.max_err_Q + max_err_DC * max_err_DC);
        if (!this.yearlylf) {
            System.out.println("* Maximum Mismatchs: P= " + StringUtil.numformat(this.max_err_P * this.sref, 11, 5) + " [MW], Q= " + StringUtil.numformat(this.max_err_Q * this.sref, 11, 5) + " [MVAR].");
        }
        if (this.repconv) {
            myPrintStream.println("* Maximum Mismatchs: P= " + StringUtil.numformat(this.max_err_P * this.sref, 11, 5) + " [MW], Q= " + StringUtil.numformat(this.max_err_Q * this.sref, 11, 5) + " [MVAR].");
        }
        if (this.max_err_P < this.tol && this.max_err_Q < this.tol && max_err_DC < this.tol) {
            seguir = false;
            this.convergen = 1;
        }
        while (this.convergen == 0) {
            if (QgOK && this.max_err_P < this.tol && this.max_err_Q < this.tol && max_err_DC < this.tol) {
                seguir = false;
                this.convergen = 2;
            }
            while (seguir) {
                ++this.itercount;
                if (!this.yearlylf) {
                    System.out.println("\nIn process Iteration: " + this.itercount);
                }
                if (this.repconv) {
                    myPrintStream.println("\nEvents on Iteration: " + this.itercount);
                }
                if (this.retriang || re3angonit) {
                    this.calcular_LFJ(this.LFJ, this.Bbus, this.Gbus, this.vk, this.dk, this.Pk, this.Qk, this.VARlinedc_k, this.Id, this.numlinedc);
                    this.elim_LFJ_bPVSL(this.LFJ, this.DPv, this.DQv, this.indic_bPV, this.indic_bSL);
                    if (this.repconv) {
                        myPrintStream.println("* LF Jacobian Matrix Calculated and Retringularized.");
                    }
                    try {
                        this.LU_LFJ = new CroutPivot((MatrixI)this.LFJ);
                    }
                    catch (Exception ex) {
                        String msg = new String(ex + "Singular Jacobian on iteration " + this.itercount);
                        this.javaLF_Error(msg);
                    }
                }
                this.sol_lin(this.LU_LFJ, this.LFJ, this.Dv, this.Ddv, this.DPv, this.DQv, this.DR, this.DVlinedc);
                for (int ax1 = 0; ax1 < this.numnod; ++ax1) {
                    vold[ax1] = this.vk[ax1];
                    dold[ax1] = this.dk[ax1];
                }
                for (int ax2 = 0; ax2 < this.numlinedc; ++ax2) {
                    for (int ax3 = 0; ax3 < 4; ++ax3) {
                        VARold[ax2][ax3] = this.VARlinedc_k[ax2][ax3];
                    }
                }
                this.actualizar_Var_DC(this.VARlinedc_k, this.DVlinedc, this.LimVARlinedc, 1.0);
                this.actualizar_volt(this.vk, this.dk, this.Dv, this.Ddv, 1.0);
                this.actualizar_PkQk(this.Pk, this.Qk, this.vk, this.dk, this.Gbus, this.Bbus);
                this.actualizar_PdatQdat(this.loadVD, this.barraloadVD, this.Pdatfijo, this.Pdatactual, this.vk0, this.vk);
                this.actualizar_PdatQdat(this.loadVD, this.barraloadVD, this.Qdatfijo, this.Qdatactual, this.vk0, this.vk);
                this.calc_desv_Pot(this.DPv, this.Pdatactual, this.Pk, this.vk);
                this.calc_desv_Pot(this.DQv, this.Qdatactual, this.Qk, this.vk);
                this.anularD_bPVSL(this.DPv, this.DQv, this.indic_bSL, this.indic_bPV);
                this.calc_desv_R(this.DR, this.Rk, this.Rfijo);
                this.max_err_P = this.max_err(this.DPv, this.vk);
                this.max_err_Q = this.max_err(this.DQv, this.vk);
                max_err_DC = this.max_err_Ldc(this.DR);
                max_err_med0 = max_err_med1;
                max_err_med1 = Math.sqrt(this.max_err_P * this.max_err_P + this.max_err_Q * this.max_err_Q + max_err_DC * max_err_DC);
                if (max_err_med1 / max_err_med0 > 1.0 || max_err_med1 / max_err_med0 > 0.1 && this.itercount == 1) {
                    double[] auxv = this.vk;
                    this.vk = vold;
                    vold = auxv;
                    auxv = this.dk;
                    this.dk = dold;
                    dold = auxv;
                    double[][] auxvdc = this.VARlinedc_k;
                    this.VARlinedc_k = VARold;
                    VARold = auxvdc;
                    this.actualizar_volt(this.vk, this.dk, this.Dv, this.Ddv, 0.5);
                    this.actualizar_PkQk(this.Pk, this.Qk, this.vk, this.dk, this.Gbus, this.Bbus);
                    this.actualizar_Var_DC(this.VARlinedc_k, this.DVlinedc, this.LimVARlinedc, 1.0);
                    this.actualizar_PdatQdat(this.loadVD, this.barraloadVD, this.Pdatfijo, this.Pdatactual, this.vk0, this.vk);
                    this.actualizar_PdatQdat(this.loadVD, this.barraloadVD, this.Qdatfijo, this.Qdatactual, this.vk0, this.vk);
                    this.actualizar_Rk(this.Rk, this.VARlinedc_k, this.vk, this.PARlinedc, this.Id, this.TOlinedc, this.PARrect, this.PARinver, this.numlinedc, this.nb);
                    this.calc_desv_Pot(this.DPv, this.Pdatactual, this.Pk, this.vk);
                    this.calc_desv_Pot(this.DQv, this.Qdatactual, this.Qk, this.vk);
                    this.anularD_bPVSL(this.DPv, this.DQv, this.indic_bSL, this.indic_bPV);
                    this.calc_desv_R(this.DR, this.Rk, this.Rfijo);
                    this.max_err_P = this.max_err(this.DPv, this.vk);
                    this.max_err_Q = this.max_err(this.DQv, this.vk);
                    max_err_DC = this.max_err_Ldc(this.DR);
                    max_err_med1 = Math.sqrt(this.max_err_P * this.max_err_P + this.max_err_Q * this.max_err_Q + max_err_DC * max_err_DC);
                    System.out.println("* Half N-R step used.");
                    if (this.repconv) {
                        myPrintStream.println("* Half N-R step used.");
                    }
                }
                re3angonit = !(max_err_med1 / max_err_med0 < 0.5 && this.max_err_P < 0.5 && this.max_err_Q < 0.5 && max_err_DC < 0.5);
                if (!this.yearlylf) {
                    System.out.println("* Maximum Mismatchs: P= " + StringUtil.numformat(this.max_err_P * this.sref, 11, 5) + " [MW], Q= " + StringUtil.numformat(this.max_err_Q * this.sref, 11, 5) + " [MVAR].");
                }
                if (this.repconv) {
                    myPrintStream.println("* Maximum Mismatchs: P= " + StringUtil.numformat(this.max_err_P * this.sref, 11, 5) + " [MW], Q= " + StringUtil.numformat(this.max_err_Q * this.sref, 11, 5) + " [MVAR].");
                }
                seguir = false;
                if (this.max_err_P < 0.01 && this.max_err_Q < 0.01) {
                    this.convergen = 1;
                    continue;
                }
                if (this.itercount > 50) {
                    this.convergen = -1;
                    continue;
                }
                if (this.max_err_P > 100.0 || this.max_err_Q > 100.0 || max_err_DC > 100.0) {
                    this.convergen = -2;
                    continue;
                }
                seguir = true;
            }
            if (this.convergen != 1) continue;
            this.convergen = 0;
            seguir = true;
            if (QgOK) {
                if (!(this.max_err_P < this.tol) || !(this.max_err_Q < this.tol)) continue;
                this.convergen = 2;
                continue;
            }
            if (!this.yearlylf) {
                System.out.println("* Verifying Reactive Power Limits");
            }
            if (this.repconv && this.verifQlim) {
                myPrintStream.print("* Verifying Reactive Power Limits: ");
            }
            myPrintStream.flush();
            QgOK = this.satisf_Qlim(os);
            if (!QgOK) {
                re3angonit = true;
                this.actualizar_PdatQdat(this.loadVD, this.barraloadVD, this.Qdatfijo, this.Qdatactual, this.vk0, this.vk);
                this.calc_desv_Pot(this.DQv, this.Qdatactual, this.Qk, this.vk);
                this.anularD_bPVSL(this.DPv, this.DQv, this.indic_bSL, this.indic_bPV);
                this.max_err_Q = this.max_err(this.DQv, this.vk);
                max_err_med1 = Math.sqrt(this.max_err_P * this.max_err_P + this.max_err_Q * this.max_err_Q);
            }
            if (!this.repconv || !QgOK || !this.verifQlim) continue;
            myPrintStream.println(" OK !");
        }
        this.max_err_volt = this.max_err(this.Dv, auxun);
        for (i = 0; i < this.numnod; ++i) {
            this.Ddv[i] = this.Ddv[i] / this.vk[i];
        }
        this.max_err_delta = this.max_err(this.Ddv, auxun);
        System.out.println("Calculating Process Finished.");
        if (this.repconv) {
            myPrintStream.println("\n");
        }
    }

    private void actualizar_PkQk(double[] P, double[] Q, double[] volt, double[] ang, SparseMatrix G, SparseMatrix B) throws Exception {
        DenseVector e = new DenseVector(volt);
        DenseVector f = new DenseVector(volt);
        Algebra oper = new Algebra();
        try {
            int i;
            for (i = 0; i < volt.length; ++i) {
                e.setElementAt(i, volt[i] * Math.cos(ang[i]));
                f.setElementAt(i, volt[i] * Math.sin(ang[i]));
            }
            DenseVector eG = oper.multiply((MatrixI)G, (VectorI)e);
            DenseVector eB = oper.multiply((MatrixI)B, (VectorI)e);
            DenseVector fG = oper.multiply((MatrixI)G, (VectorI)f);
            DenseVector fB = oper.multiply((MatrixI)B, (VectorI)f);
            eG = oper.subtract((VectorI)eG, (VectorI)fB);
            eB = oper.add((VectorI)eB, (VectorI)fG);
            for (i = 0; i < volt.length; ++i) {
                P[i] = e.elementAt(i) * eG.elementAt(i) + f.elementAt(i) * eB.elementAt(i);
                Q[i] = f.elementAt(i) * eG.elementAt(i) - e.elementAt(i) * eB.elementAt(i);
            }
        }
        catch (Exception ex) {
            String msg = new String(ex + "on updating powers, incompatible dimensions");
            this.javaLF_Error(msg);
        }
    }

    private void actualizar_Rk(double[][] R, double[][] VAcon, double[] voltk, double[][] PARlinedc, double[] Idc, int[][] barLdc, double[][] ParR, double[][] ParI, int lindc, double[] nbr) {
        double k = 0.995;
        double k0 = 3.0 * Math.sqrt(2.0) / Math.PI;
        double k1 = 0.954929658551372;
        if (lindc != 0) {
            for (int i = 0; i < lindc; ++i) {
                R[i][0] = k0 * VAcon[i][2] * voltk[barLdc[i][0]] * Idc[i] * Math.cos(VAcon[i][0]) * nbr[i] - k1 * ParR[i][0] * Math.pow(Idc[i], 2.0) * nbr[i];
                R[i][1] = k0 * VAcon[i][3] * voltk[barLdc[i][1]] * Idc[i] * Math.cos(VAcon[i][1]) * nbr[i] - k1 * ParI[i][0] * Math.pow(Idc[i], 2.0) * nbr[i];
                R[i][2] = Math.pow(k * k0 * Idc[i] * VAcon[i][2] * voltk[barLdc[i][0]] * nbr[i], 2.0);
                R[i][3] = Math.pow(k * k0 * Idc[i] * VAcon[i][3] * voltk[barLdc[i][1]] * nbr[i], 2.0);
            }
        }
    }

    private void actualizar_PdatQdat(Load[] VD, int[] posvd, double[] Xfijo, double[] Xact, double[] v0, double[] v) {
        int k;
        int i;
        for (i = 0; i < this.numnod; ++i) {
            Xact[i] = Xfijo[i];
        }
        if (Xfijo == this.Pdatfijo) {
            for (i = 0; i < this.numnod; ++i) {
                for (k = 0; k < posvd.length; ++k) {
                    if (i != posvd[k]) continue;
                    Xact[i] = Xact[i] - VD[k].getp0() / this.sref * Math.pow(v[i] / v0[i], VD[k].getvd_p());
                }
            }
        }
        if (Xfijo == this.Qdatfijo) {
            for (i = 0; i < this.numnod; ++i) {
                for (k = 0; k < posvd.length; ++k) {
                    if (i != posvd[k]) continue;
                    Xact[i] = Xact[i] - VD[k].getq0() / this.sref * Math.pow(v[i] / v0[i], VD[k].getvd_q());
                }
            }
        }
    }

    private void calc_desv_Pot(double[] DXv, double[] Xdat, double[] X, double[] v) {
        for (int i = 0; i < v.length; ++i) {
            DXv[i] = (Xdat[i] - X[i]) / v[i];
        }
    }

    private void calc_desv_R(double[][] DeltaR, double[][] R, double[][] Rcte) {
        for (int i = 0; i < this.numlinedc; ++i) {
            for (int j = 0; j < 4; ++j) {
                DeltaR[i][j] = Rcte[i][j] - R[i][j];
            }
        }
    }

    private void anularD_bPVSL(double[] DP2, double[] DQ, int bSL, int[] bPV) {
        DP2[bSL] = 0.0;
        for (int i = 1; i <= bPV[0]; ++i) {
            DQ[bPV[i]] = 0.0;
        }
    }

    public void volt_yearlytool(double[] vy) {
        for (int mv = 0; mv < this.vk.length; ++mv) {
            vy[mv] = this.vk[mv];
        }
    }

    private void actualizar_volt(double[] vnew, double[] dnew, double[] Deltav, double[] Deltadv, double lambda2) {
        for (int i = 0; i < vnew.length; ++i) {
            dnew[i] = dnew[i] + lambda2 * Deltadv[i] / vnew[i];
            vnew[i] = vnew[i] + lambda2 * Deltav[i];
        }
    }

    private void actualizar_Var_DC(double[][] VARnew, double[][] DVAR, double[][] lim, double lambda2) {
        for (int i = 0; i < this.numlinedc; ++i) {
            for (int j = 0; j < 4; ++j) {
                VARnew[i][j] = VARnew[i][j] + lambda2 * DVAR[i][j];
            }
            if (VARnew[i][0] < lim[i][0]) {
                VARnew[i][0] = lim[i][0];
                continue;
            }
            if (VARnew[i][0] > lim[i][1]) {
                VARnew[i][0] = lim[i][1];
                continue;
            }
            if (VARnew[i][1] < lim[i][2]) {
                VARnew[i][1] = lim[i][2];
                continue;
            }
            if (VARnew[i][1] > lim[i][3]) {
                VARnew[i][1] = lim[i][3];
                continue;
            }
            if (VARnew[i][2] < lim[i][4]) {
                VARnew[i][2] = lim[i][4];
                continue;
            }
            if (VARnew[i][2] > lim[i][5]) {
                VARnew[i][2] = lim[i][5];
                continue;
            }
            if (VARnew[i][3] < lim[i][6]) {
                VARnew[i][3] = lim[i][6];
                continue;
            }
            if (!(VARnew[i][3] > lim[i][7])) continue;
            VARnew[i][3] = lim[i][7];
        }
    }

    private double max_err(double[] Desvv, double[] v) {
        double max = 0.0;
        for (int i = 0; i < v.length; ++i) {
            double aux = Math.abs(Desvv[i] * v[i]);
            if (!(aux > max)) continue;
            max = aux;
        }
        return max;
    }

    private double max_err_Ldc(double[][] DesvR) {
        double max = 0.0;
        for (int i = 0; i < this.numlinedc; ++i) {
            for (int j = 0; j < 4; ++j) {
                double aux = Math.abs(DesvR[i][j]);
                if (!(aux > max)) continue;
                max = aux;
            }
        }
        return max;
    }

    private void calcular_LFJ(SparseMatrix mJ, SparseMatrix B, SparseMatrix G, double[] v, double[] d, double[] P, double[] Q, double[][] mVARlinedc, double[] mId, int nlindc) {
        int i;
        double k0 = 0.0;
        double[][] voluvk = new double[this.numlinedc][2];
        boolean mJijesNulo = true;
        double k = 0.995;
        double kk0 = 3.0 * Math.sqrt(2.0) / Math.PI;
        double lij = 0.0;
        double nij = 0.0;
        double mij = 0.0;
        double hij = 0.0;
        for (i = 0; i < v.length; ++i) {
            for (int j = 0; j < v.length; ++j) {
                if (i != j) {
                    boolean bl = mJijesNulo = B.isNull(i, j) && G.isNull(i, j);
                    if (!mJijesNulo) {
                        double sij = Math.sin(d[i] - d[j]);
                        double cij = Math.cos(d[i] - d[j]);
                        hij = G.elementAt(i, j) * sij - B.elementAt(i, j) * cij;
                        nij = G.elementAt(i, j) * cij + B.elementAt(i, j) * sij;
                        mij = -G.elementAt(i, j) * cij - B.elementAt(i, j) * sij;
                        lij = G.elementAt(i, j) * sij - B.elementAt(i, j) * cij;
                    }
                } else {
                    mJijesNulo = false;
                    hij = -B.elementAt(i, j) - Q[i] / (v[i] * v[i]);
                    nij = G.elementAt(i, j) + P[i] / (v[i] * v[i]);
                    mij = -G.elementAt(i, j) + P[i] / (v[i] * v[i]);
                    lij = -B.elementAt(i, j) + Q[i] / (v[i] * v[i]);
                }
                if (mJijesNulo) continue;
                mJ.setElementAt(i, j, hij);
                mJ.setElementAt(i, j + v.length, nij);
                mJ.setElementAt(i + v.length, j, mij);
                mJ.setElementAt(i + v.length, j + v.length, lij);
            }
        }
        if (nlindc != 0) {
            int alt = 4 * nlindc;
            int nrec = 0;
            int ninv = 0;
            for (int l = 0; l < nlindc; ++l) {
                for (i = 0; i < v.length; ++i) {
                    if (this.indic_bPQ[i] == this.TOlinedc[l][0]) {
                        double dfdvr1 = kk0 * mVARlinedc[l][2] * mId[l] * Math.cos(mVARlinedc[l][0]);
                        double dfdvr3 = 2.0 * Math.pow(k * kk0 * mId[l] * mVARlinedc[l][2], 2.0) * v[i];
                        mJ.setElementAt(2 * v.length + alt * l, v.length + i, dfdvr1);
                        int a = 2 * v.length + alt * l;
                        int b = v.length + i;
                        mJ.setElementAt(2 * v.length + alt * l + 2, v.length + i, dfdvr3);
                        int c = 2 * v.length + alt * l + 2;
                        voluvk[l][0] = v[i];
                        ++nrec;
                        continue;
                    }
                    if (this.indic_bPQ[i] != this.TOlinedc[l][1]) continue;
                    double dfdvi2 = kk0 * mVARlinedc[l][3] * mId[l] * Math.cos(mVARlinedc[l][1]);
                    double dfdvi4 = 2.0 * Math.pow(k * kk0 * mId[l] * mVARlinedc[l][3], 2.0) * v[i];
                    mJ.setElementAt(2 * v.length + alt * l + 1, v.length + i, dfdvi2);
                    mJ.setElementAt(2 * v.length + alt * l + 3, v.length + i, dfdvi4);
                    voluvk[l][1] = v[i];
                    ++ninv;
                }
                double df1dar = -kk0 * mVARlinedc[l][2] * mId[l] * voluvk[l][0] * Math.sin(mVARlinedc[l][0]);
                double df2dg = -kk0 * mVARlinedc[l][3] * mId[l] * voluvk[l][1] * Math.sin(mVARlinedc[l][1]);
                double df1dtr = kk0 * voluvk[l][0] * mId[l] * Math.cos(mVARlinedc[l][0]);
                double df3dtr = 2.0 * Math.pow(k * kk0 * mId[l] * voluvk[l][0], 2.0) * mVARlinedc[l][2];
                double df2dti = kk0 * voluvk[l][1] * mId[l] * Math.cos(mVARlinedc[l][1]);
                double df4dti = 2.0 * Math.pow(k * kk0 * mId[l] * voluvk[l][1], 2.0) * mVARlinedc[l][3];
                mJ.setElementAt(2 * v.length + alt * l, 2 * v.length + alt * l, df1dar);
                mJ.setElementAt(2 * v.length + alt * l + 1, 2 * v.length + alt * l + 1, df2dg);
                mJ.setElementAt(2 * v.length + alt * l, 2 * v.length + alt * l + 2, df1dtr);
                mJ.setElementAt(2 * v.length + alt * l + 2, 2 * v.length + alt * l + 2, df3dtr);
                mJ.setElementAt(2 * v.length + alt * l + 1, 2 * v.length + alt * l + 3, df2dti);
                mJ.setElementAt(2 * v.length + alt * l + 3, 2 * v.length + alt * l + 3, df4dti);
            }
        }
    }

    private void elim_LFJ_bPVSL(SparseMatrix mJ, double[] DPv, double[] DQv, int[] indic_bPV, int indic_bSL) {
        for (int i = 1; i <= indic_bPV[0]; ++i) {
            mJ.setElementAt(indic_bPV[i] + this.numnod, indic_bPV[i] + this.numnod, 1.0E200);
            DQv[indic_bPV[i]] = 0.0;
        }
        mJ.setElementAt(indic_bSL, indic_bSL, 1.0E200);
        DPv[indic_bSL] = 0.0;
    }

    private void sol_lin(CroutPivot LU, SparseMatrix A, double[] v1, double[] v2, double[] p1, double[] p2, double[][] p3, double[][] v3) throws Exception {
        Algebra oper = new Algebra();
        DenseVector b = new DenseVector(2 * v1.length + 4 * this.numlinedc);
        DenseVector x = new DenseVector();
        DenseVector Db = new DenseVector();
        DenseVector Dx = new DenseVector();
        try {
            int k;
            int j;
            int i;
            for (i = 0; i < v1.length; ++i) {
                b.setElementAt(i, p1[i]);
                b.setElementAt(i + v1.length, p2[i]);
            }
            if (this.numlinedc != 0) {
                int sapo = 0;
                for (j = 0; j < this.numlinedc; ++j) {
                    for (k = 0; k < 4; ++k) {
                        sapo = k + 4 * j + 2 * v1.length;
                        b.setElementAt(sapo, p3[j][k]);
                    }
                }
            }
            x = LU.solveEquations((VectorI)b);
            DenseVector bk = oper.multiply((MatrixI)A, (VectorI)x);
            Db = oper.subtract((VectorI)b, (VectorI)bk);
            Dx = LU.solveEquations((VectorI)Db);
            x = oper.add((VectorI)x, (VectorI)Dx);
            for (i = 0; i < v1.length; ++i) {
                v2[i] = x.elementAt(i);
                v1[i] = x.elementAt(i + v1.length);
            }
            for (j = 0; j < this.numlinedc; ++j) {
                for (k = 0; k < 4; ++k) {
                    v3[j][k] = x.elementAt(k + 4 * j + 2 * v1.length);
                }
            }
        }
        catch (Exception ex) {
            String msg = new String(ex + "On linear system calculation on iter:" + this.itercount);
            this.javaLF_Error(msg);
        }
    }

    private boolean satisf_Qlim(FileOutputStream os) {
        boolean conver2PQ = false;
        boolean limites_OK = true;
        PrintWriter myPrintStream = new PrintWriter(os, true);
        for (int i = 1; i <= this.indic_bPV[0]; ++i) {
            comp tempComp;
            int ib = this.indic_bPV[i];
            if (this.Qk[ib] - this.Qdatactual[ib] > this.QGmax[ib]) {
                if (ib == this.indic_bSL) {
                    tempComp = (comp)this.BusbarVector.elementAt(ib);
                    myPrintStream.println("\n**************************** Warning !! ****************************");
                    myPrintStream.println(" Slack Busbar " + tempComp.getName() + " is out of its reactive power");
                    myPrintStream.println(" generation upper limit.");
                    myPrintStream.println("********************************************************************\n");
                } else {
                    conver2PQ = true;
                    this.Qdatfijo[ib] = this.Qdatfijo[ib] + this.QGmax[ib];
                }
            } else if (this.Qk[ib] - this.Qdatactual[ib] < this.QGmin[ib]) {
                if (ib == this.indic_bSL) {
                    tempComp = (comp)this.BusbarVector.elementAt(ib);
                    myPrintStream.println("\n**************************** Warning !! ****************************");
                    myPrintStream.println(" Slack Busbar " + tempComp.getName() + " is out of its reactive power");
                    myPrintStream.println(" generation lower limit.");
                    myPrintStream.println("********************************************************************\n");
                } else {
                    conver2PQ = true;
                    this.Qdatfijo[ib] = this.Qdatfijo[ib] + this.QGmin[ib];
                }
            }
            if (!conver2PQ) continue;
            tempComp = (comp)this.BusbarVector.elementAt(ib);
            if (this.repconv) {
                myPrintStream.println("\n  > Generator Q limits violation at busbar: \"" + tempComp.getName() + "\" " + " Switched to \"PQ\"");
            }
            System.out.println("\n  > Generator Q limits violation at busbar: \"" + tempComp.getName() + "\" " + " Switched to \"PQ\"");
            limites_OK = false;
            conver2PQ = false;
            this.indic_bvQ[0] = this.indic_bvQ[0] + 1;
            this.indic_bvQ[this.indic_bvQ[0]] = ib;
            this.indic_bPQ[0] = this.indic_bPQ[0] + 1;
            this.indic_bPQ[this.indic_bPQ[0]] = ib;
            for (int j = i; j < this.indic_bPV[0]; ++j) {
                this.indic_bPV[j] = this.indic_bPV[j + 1];
            }
            this.indic_bPV[0] = this.indic_bPV[0] - 1;
            --i;
        }
        return limites_OK;
    }

    private void listarResult(FileOutputStream os) {
        this.archivo_csv = false;
        this.listarResult(os, this.archivo_csv, this.yearlylf);
    }

    private void listarResult(FileOutputStream os, boolean aarchivo_csv, boolean yyearlylf) {
        if (!yyearlylf) {
            String sp = null;
            PrintWriter myPrintStream = null;
            if (aarchivo_csv) {
                sp = ",";
                FileOutputStream os_csv = null;
                String LFsal = WORK_FOLDER + File.separator + WORK_FILE;
                try {
                    JavaLF.CreateDirectory(WORK_FOLDER);
                    os_csv = new FileOutputStream(LFsal);
                    myPrintStream = new PrintWriter(os_csv, true);
                }
                catch (Exception e) {}
            } else {
                sp = "\t";
                myPrintStream = new PrintWriter(os, true);
            }
            myPrintStream.println();
            myPrintStream.println("Busbar" + sp + "      Name  " + sp + "       type" + sp + "  Volt[kV]" + sp + "  Deg[grad]" + sp + " Pinj[p.u.]" + sp + " Qinj[p.u.]");
            if (!aarchivo_csv) {
                myPrintStream.println("-----  ----------------    ----    ----------     ---------    ----------    ----------");
            }
            for (int i = 0; i < this.numnod; ++i) {
                String tipo;
                switch (this.tipobarra[i]) {
                    case 1: {
                        tipo = "PQ";
                        break;
                    }
                    case 2: {
                        tipo = "PV";
                        break;
                    }
                    case 3: {
                        tipo = "SL";
                        break;
                    }
                    case 4: {
                        tipo = "VD";
                        break;
                    }
                    default: {
                        tipo = "NR";
                    }
                }
                for (int j = 1; j <= this.indic_bvQ[0]; ++j) {
                    if (this.indic_bvQ[j] != i) continue;
                    tipo = tipo + "*";
                }
                Busbar TempBusbar = (Busbar)this.BusbarVector.elementAt(i);
                String si = StringUtil.numformat(i + 1, 4);
                String sv = StringUtil.numformat(this.vk[i] * TempBusbar.getun1(), 9, 3);
                String sang = StringUtil.numformat(this.dk[i] * 180.0 / Math.PI, 9, 2);
                String spg = StringUtil.numformat(this.Pk[i], 9, 4);
                String sqg = StringUtil.numformat(this.Qk[i], 9, 4);
                if (aarchivo_csv) {
                    spg.trim();
                    sqg.trim();
                    sang.trim();
                    sv.trim();
                }
                myPrintStream.println(si + sp + StringUtil.strformat(TempBusbar.getName(), 20) + sp + tipo + sp + sv + sp + sang + sp + spg + sp + sqg + sp);
            }
            if (this.numupfc > 0) {
                for (int k = 0; k < this.numupfc; ++k) {
                    int sw1 = k + 1;
                    int sw2 = this.TOupfc[k][0] + 1;
                    int sw3 = this.TOupfc[k][1] + 1;
                    myPrintStream.println("");
                    myPrintStream.println("Inyecciones de Potencia UPFC n\u00ba " + sw1);
                    myPrintStream.println("En nodo excitaci\u00f3n n\u00ba " + sw2);
                    myPrintStream.println("Pexc[pu] = " + this.Pfexc[this.TOupfc[k][0]][k]);
                    myPrintStream.println("Qexc[pu] = " + this.Qfexc[this.TOupfc[k][0]][k]);
                    myPrintStream.println("En nodo acoplamiento n\u00ba " + sw3);
                    myPrintStream.println("Pboost[pu] = " + this.Pfboost[this.TOupfc[k][1]][k]);
                    myPrintStream.println("Qboost[pu] = " + this.Qfboost[this.TOupfc[k][1]][k]);
                    myPrintStream.println("");
                    myPrintStream.println("Variables de Control UPFC n\u00ba " + sw1);
                    myPrintStream.println("Vboost[pu] = " + this.VARupfc[k][0]);
                    myPrintStream.println("Argboost[rad] = " + this.VARupfc[k][1]);
                    myPrintStream.println("Vexc[pu] = " + this.VARupfc[k][2]);
                    myPrintStream.println("Argexc[rad] = " + this.VARupfc[k][3]);
                }
            }
            if (this.numlinedc > 0) {
                myPrintStream.println("-----  ----------------    ----    ----------     ---------    ----------    ----------");
                for (int s = 0; s < this.numlinedc; ++s) {
                    String angr = StringUtil.numformat(this.VARlinedc_k[s][0] * 180.0 / Math.PI - 2.35, 9, 3);
                    String angi = StringUtil.numformat(this.VARlinedc_k[s][1] * 180.0 / Math.PI, 9, 3);
                    String tapr = StringUtil.numformat(this.VARlinedc_k[s][2], 9, 4);
                    String tapi = StringUtil.numformat(this.VARlinedc_k[s][3], 9, 4);
                    String prec = StringUtil.numformat(this.Pdr[s], 9, 4);
                    String pinv = StringUtil.numformat(this.Rk[s][1], 9, 4);
                    double au1 = this.Rk[s][2] - Math.pow(this.Pdr[s], 2.0);
                    double au2 = Math.sqrt(au1);
                    double au3 = this.Rk[s][3] - Math.pow(this.Rk[s][1], 2.0);
                    double au4 = Math.sqrt(au3);
                    String qrec = StringUtil.numformat(au2, 9, 4);
                    String qinv = StringUtil.numformat(au4, 9, 4);
                    myPrintStream.println("Enlace HVDC     :" + StringUtil.strformat(this.NombreLinedc[s], 20));
                    myPrintStream.println("------------------------------");
                    myPrintStream.println(sp + sp + "               Rectificador" + sp + sp + "Inversor" + sp);
                    myPrintStream.println("Angulo Estaci\u00f3n          = " + angr + sp + sp + angi);
                    myPrintStream.println("Tap Transformador        =  " + tapr + sp + sp + tapi);
                    myPrintStream.println("Potencia Activa [pu]     =  " + prec + sp + sp + pinv);
                    myPrintStream.println("Potencia Reactiva [pu]   =  " + qrec + sp + sp + qinv);
                }
            }
            if (this.flowrep) {
                myPrintStream.println(" ");
                myPrintStream.println(" Flujo por Ramas");
                myPrintStream.println(" Nombre Rama   " + sp + sp + " Flujo P [pu]" + sp + " Flujo Q [pu]" + sp + "  Pperd [pu]" + sp + "  Qperd [pu]");
                if (!aarchivo_csv) {
                    myPrintStream.println("----------------            ----------     ----------    ----------   ----------");
                }
                for (int jp = 0; jp < this.nbr; ++jp) {
                    myPrintStream.println(StringUtil.strformat(this.NomBra[jp], 20) + sp + sp + StringUtil.numformat(this.FlujosP[jp], 10, 3) + sp + StringUtil.numformat(this.FlujosQ[jp], 10, 3) + sp + StringUtil.numformat(this.PerdP[jp], 10, 3) + sp + StringUtil.numformat(this.PerdQ[jp], 10, 3));
                }
                myPrintStream.println(" ");
            }
            if (!aarchivo_csv) {
                this.listarResult(os, true, false);
            }
        }
    }

    public void resultyearly(FileOutputStream os) {
        String sp = null;
        String acomsp = null;
        PrintStream myPrintStream = null;
        sp = ",";
        acomsp = ",";
        myPrintStream = new PrintStream(os, true);
        if (this.MyYearlylf != null) {
            if (this.MyYearlylf.countacflow == 1) {
                myPrintStream.println("Name" + acomsp + "  Volt");
            }
        } else if (this.MyMMS.countacflow == 1) {
            myPrintStream.println("Name" + acomsp + "  Volt");
        }
        for (int q = 0; q < this.numnod; ++q) {
            Busbar TempBusbar = (Busbar)this.BusbarVector.elementAt(q);
            String sv = StringUtil.numformat(this.vk[q] * 1.0, 9, 3);
            String nombre = StringUtil.strformat(TempBusbar.getName(), 20);
            sv.trim();
            nombre.trim();
            myPrintStream.println(nombre + acomsp + sv);
        }
    }

    private void writeresults(FileOutputStream os) {
        ndb_branch TempBran;
        double QgbPV;
        ndb_1pol Temp1pol;
        SVC TempSVC;
        Generator TempGenerator;
        ndb_comp TempNdb_comp;
        comp TempComponent;
        int i;
        PrintWriter myPrintStream = new PrintWriter(os, true);
        DataInputStream inData = new DataInputStream(System.in);
        int ix = 0;
        int count = 0;
        int con1 = 0;
        int con2 = 0;
        int con3 = 0;
        int countupfc = 0;
        boolean con0 = false;
        int countlinedc = 0;
        int fintrafo = 0;
        int rama = 0;
        Vector<Generator> genAonbSL = new Vector<Generator>();
        Vector[] genRonbPV = new Vector[this.indic_bsetPV[0] + 1];
        Vector[] svcRonbPV = new Vector[this.indic_bsetPV[0] + 1];
        for (i = 1; i <= this.indic_bsetPV[0]; ++i) {
            genRonbPV[i] = new Vector();
        }
        for (i = 1; i <= this.indic_bsetPV[0]; ++i) {
            svcRonbPV[i] = new Vector();
        }
        Complex ysh1 = new Complex();
        Complex ysh2 = new Complex();
        Complex ramashunt = new Complex(0.0, 0.0);
        Complex ybr = new Complex();
        Complex ybr12 = new Complex();
        Complex ybr21 = new Complex();
        Complex ctimag = new Complex();
        Complex unidad = new Complex(1.0, 0.0);
        Complex v1 = new Complex();
        Complex v2 = new Complex();
        Complex v3 = new Complex();
        Complex s12 = new Complex();
        Complex s21 = new Complex();
        Complex tapchange1 = new Complex();
        Complex tapchange2 = new Complex();
        Complex tapchange3 = new Complex();
        Complex cY12 = new Complex();
        Complex cY13 = new Complex();
        Complex cY23 = new Complex();
        Complex sumY1 = new Complex();
        Complex sumY2 = new Complex();
        Complex sumY3 = new Complex();
        Complex factor1 = new Complex();
        Complex factor2 = new Complex();
        Complex factor3 = new Complex();
        Complex elem1 = new Complex();
        Complex elem2 = new Complex();
        Complex elem3 = new Complex();
        double[] Qg = new double[this.numnod];
        double Ploss = 0.0;
        double Qloss = 0.0;
        double Ploadtot = 0.0;
        double Qloadtot = 0.0;
        double rserie = 0.0;
        double xserie = 0.0;
        double gshunt = 0.0;
        double bshunt = 0.0;
        double vboost = 0.0;
        double vexc = 0.0;
        double thboost = 0.0;
        double thexc = 0.0;
        double buffer = 0.0;
        double avisador = 0.0;
        double timag = 0.0;
        double ueb1 = 0.0;
        boolean c = false;
        for (ix = 0; ix < this.BusbarVector.size(); ++ix) {
            Busbar TempBusbar = (Busbar)this.BusbarVector.elementAt(ix);
            TempBusbar.setun2(this.vk[ix] * TempBusbar.getun1());
            TempBusbar.setdelta2(this.dk[ix] * 180.0 / Math.PI);
            Qg[ix] = this.Qk[ix] * this.sref;
            Ploss += this.Pk[ix];
            Qloss += this.Qk[ix];
        }
        for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
            TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
            if (!TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice() || !(TempComponent instanceof Load)) continue;
            TempComponent.InformAllComponents();
            Load Temploadaux = (Load)TempComponent;
            Temploadaux.p1 = Temploadaux.getp0();
            Temploadaux.q1 = Temploadaux.getq0();
            Temploadaux = null;
            TempComponent = null;
        }
        for (int e = 0; e < this.loadVD.length; ++e) {
            Load TempLoadVD = this.loadVD[e];
            TempLoadVD.loadVD = true;
            TempLoadVD.p1 = TempLoadVD.getp0() * Math.pow(this.vk[this.barraloadVD[e]], TempLoadVD.getvd_p());
            TempLoadVD.q1 = TempLoadVD.getq0() * Math.pow(this.vk[this.barraloadVD[e]], TempLoadVD.getvd_q());
        }
        double PgbSL = this.Pk[this.indic_bSL] * this.sref;
        Ploss *= this.sref;
        Qloss *= this.sref;
        block5: for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
            TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
            if (!(TempComponent instanceof ndb_comp) || !(TempNdb_comp = (ndb_comp)TempComponent).getctrla().equals(this.ctrla) && !this.ctrla.equals("ALL CONTROL AREAS") || !TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice() || !(TempComponent instanceof ndb_1pol)) continue;
            if (TempComponent instanceof ndb_inj) {
                ndb_inj TempInj = (ndb_inj)TempComponent;
                TempInj.setp(TempInj.getp0());
                TempInj.setq(TempInj.getq0());
                con1 = this.numbus(TempInj.getcon2());
                if (TempInj instanceof Generator) {
                    TempGenerator = (Generator)TempInj;
                    TempGenerator.setlf_type_s(TempGenerator.getlf_type());
                    for (i = 1; i <= this.indic_bvQ[0]; ++i) {
                        if (this.indic_bvQ[i] != con1) continue;
                        TempGenerator.setlf_type_s(1);
                        break;
                    }
                    if (TempGenerator.getlf_type() != 3 && con1 == this.indic_bSL) {
                        PgbSL -= TempGenerator.getp0();
                    }
                    if (TempGenerator.getlf_type() == 1) {
                        int n = con1;
                        Qg[n] = Qg[n] - TempGenerator.getq0();
                    }
                    if (TempGenerator.getlf_type() != 2 && TempGenerator.getlf_type() != 3) continue;
                    for (i = 1; i <= this.indic_bsetPV[0]; ++i) {
                        if (this.indic_bsetPV[i] != con1) continue;
                        genRonbPV[i].addElement(TempGenerator);
                        break;
                    }
                    if (TempGenerator.getlf_type() != 3) continue;
                    genAonbSL.addElement(TempGenerator);
                    continue;
                }
                if (TempInj instanceof SVC) {
                    TempSVC = (SVC)TempInj;
                    for (i = 1; i <= this.indic_bvQ[0]; ++i) {
                        if (this.indic_bvQ[i] != con1) continue;
                        TempSVC.setlf_type_s(1);
                        break;
                    }
                    if (TempSVC.getlf_type() == 1) {
                        int n = con1;
                        Qg[n] = Qg[n] - TempSVC.getq0();
                    }
                    if (TempSVC.getlf_type() != 2) continue;
                    for (i = 1; i <= this.indic_bsetPV[0]; ++i) {
                        if (this.indic_bsetPV[i] != con1) continue;
                        svcRonbPV[i].addElement(TempSVC);
                        continue block5;
                    }
                    continue;
                }
                int n = con1;
                Qg[n] = Qg[n] - TempInj.getq0();
                if (con1 != this.indic_bSL) continue;
                PgbSL -= TempInj.getp0();
                continue;
            }
            if (TempComponent instanceof Busbar || (Temp1pol = (ndb_1pol)TempComponent).getlf_type() == 4) continue;
            con1 = this.numbus(Temp1pol.getcon2());
            Load TempLoad2 = (Load)Temp1pol;
            int n = con1;
            Qg[n] = Qg[n] + TempLoad2.getq0() * Math.pow(this.vk[con1] / this.vk0[con1], TempLoad2.getvd_q());
            Qloadtot += Temp1pol.getq0();
            Ploadtot += Temp1pol.getp0();
            if (con1 != this.indic_bSL) continue;
            PgbSL += Temp1pol.getp0();
        }
        for (ix = 0; ix < genAonbSL.size(); ++ix) {
            TempGenerator = (Generator)genAonbSL.elementAt(ix);
            TempGenerator.setp(PgbSL);
            if (ix + 1 < genAonbSL.size()) {
                if (TempGenerator.getp() > TempGenerator.getpmax()) {
                    TempGenerator.setp(TempGenerator.getpmax());
                } else if (TempGenerator.getp() < TempGenerator.getpmin()) {
                    TempGenerator.setp(TempGenerator.getpmin());
                }
            }
            PgbSL -= TempGenerator.getp();
            TempGenerator.setp((double)Math.round(TempGenerator.getp() * 1000000.0) / 1000000.0);
        }
        for (i = 1; i <= this.indic_bsetPV[0]; ++i) {
            QgbPV = Qg[this.indic_bsetPV[i]];
            for (ix = 0; ix < genRonbPV[i].size(); ++ix) {
                TempGenerator = (Generator)genRonbPV[i].elementAt(ix);
                TempGenerator.setq(QgbPV);
                if (ix + 1 < genRonbPV[i].size()) {
                    if (TempGenerator.getq() > TempGenerator.getqmax()) {
                        TempGenerator.setq(TempGenerator.getqmax());
                    } else if (TempGenerator.getq() < TempGenerator.getqmin()) {
                        TempGenerator.setq(TempGenerator.getqmin());
                    }
                }
                TempGenerator.setq((double)Math.round(TempGenerator.getq() * 1000000.0) / 1000000.0);
                QgbPV -= TempGenerator.getq();
            }
        }
        for (i = 1; i <= this.indic_bsetPV[0]; ++i) {
            for (ix = 0; ix < svcRonbPV[i].size(); ++ix) {
                TempSVC = (SVC)svcRonbPV[i].elementAt(ix);
                QgbPV = Qg[this.indic_bsetPV[i]];
                TempSVC.setq(QgbPV);
                if (ix + 1 < svcRonbPV[i].size()) {
                    if (TempSVC.getq() > TempSVC.getqmax()) {
                        TempSVC.setq(TempSVC.getqmax());
                    } else if (TempSVC.getq() < TempSVC.getqmin()) {
                        TempSVC.setq(TempSVC.getqmin());
                    }
                }
                TempSVC.setq((double)Math.round(TempSVC.getq() * 1000000.0) / 1000000.0);
                QgbPV -= TempSVC.getq();
            }
        }
        for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
            double q21;
            double p21;
            double q12;
            double p12;
            Complex s2;
            Complex s1;
            TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
            if (!(TempComponent instanceof ndb_comp) || !(TempNdb_comp = (ndb_comp)TempComponent).getctrla().equals(this.ctrla) && !this.ctrla.equals("ALL CONTROL AREAS") || !TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice() || !(TempComponent instanceof ndb_branch) || (con1 = this.numbus((TempBran = (ndb_branch)TempComponent).getcon1())) <= -1 || (con2 = this.numbus(TempBran.getcon2())) <= -1) continue;
            TempBran.setu1(this.vk[con1] * TempBran.getun1());
            TempBran.setu2(this.vk[con2] * TempBran.getun2());
            if (TempBran instanceof LineDC) {
                LineDC TempLineDC = (LineDC)TempBran;
                TempLineDC.setpotinv(this.Rk[countlinedc][1] * this.sref);
                TempLineDC.setangfir(this.VARlinedc_k[countlinedc][0] * 180.0 / Math.PI);
                TempLineDC.setangext(this.VARlinedc_k[countlinedc][1] * 180.0 / Math.PI);
                ++countlinedc;
            }
            if (TempBran instanceof Line) {
                Line TempLine = (Line)TempBran;
                ybr.re = this.BranchR[count];
                ybr.im = this.BranchX[count];
                ybr = Complex.divide((Complex)new Complex(1.0, 0.0), (Complex)ybr);
                ysh2.re = 0.0;
                ysh1.re = 0.0;
                ysh1.im = ysh2.im = this.BranchB[count];
                v1.re = this.vk[con1] * Math.cos(this.dk[con1]);
                v1.im = this.vk[con1] * Math.sin(this.dk[con1]);
                v2.re = this.vk[con2] * Math.cos(this.dk[con2]);
                v2.im = this.vk[con2] * Math.sin(this.dk[con2]);
                s1 = Complex.multiply((Complex)v1, (Complex)Complex.conjugate((Complex)Complex.multiply((Complex)v1, (Complex)ysh1)));
                s2 = Complex.multiply((Complex)v2, (Complex)Complex.conjugate((Complex)Complex.multiply((Complex)v2, (Complex)ysh2)));
                s12 = Complex.multiply((Complex)v1, (Complex)Complex.conjugate((Complex)Complex.multiply((Complex)Complex.subtract((Complex)v1, (Complex)v2), (Complex)ybr)));
                s21 = Complex.multiply((Complex)v2, (Complex)Complex.conjugate((Complex)Complex.multiply((Complex)Complex.subtract((Complex)v2, (Complex)v1), (Complex)ybr)));
                p12 = (double)Math.round((s1.re + s12.re) * 10000.0) / 10000.0;
                q12 = (double)Math.round((s1.im + s12.im) * 10000.0) / 10000.0;
                p21 = (double)Math.round((s2.re + s21.re) * 10000.0) / 10000.0;
                q21 = (double)Math.round((s2.im + s21.im) * 10000.0) / 10000.0;
                TempBran.setp12(p12);
                TempBran.setq12(q12);
                TempBran.setp21(p21);
                TempBran.setq21(q21);
            }
            if (TempBran instanceof Trafo) {
                Trafo TempTrafo = (Trafo)TempBran;
                ybr.re = this.BranchR[count];
                ybr.im = this.BranchX[count];
                ybr12 = ybr = Complex.divide((Complex)new Complex(1.0, 0.0), (Complex)ybr);
                ybr21 = ybr;
                ysh2.re = 0.0;
                ysh1.re = 0.0;
                ysh1.im = ysh2.im = this.BranchB[count];
                ueb1 = TempTrafo.getun1() / TempTrafo.getun2() / (TempTrafo.getur1() / TempTrafo.getur2());
                ysh2.add(Complex.multiply((Complex)ybr, (double)(1.0 - 1.0 / TempTrafo.gett_re() * ueb1)));
                ysh1.add(Complex.multiply((Complex)ybr, (double)(1.0 - TempTrafo.gett_re() / ueb1)));
                ysh1.divide(TempTrafo.gett_re() * TempTrafo.gett_re() / ueb1 / ueb1);
                ybr = Complex.divide((Complex)ybr, (double)(TempTrafo.gett_re() / ueb1));
                v1.re = this.vk[con1] * Math.cos(this.dk[con1]);
                v1.im = this.vk[con1] * Math.sin(this.dk[con1]);
                v2.re = this.vk[con2] * Math.cos(this.dk[con2]);
                v2.im = this.vk[con2] * Math.sin(this.dk[con2]);
                s1 = Complex.multiply((Complex)v1, (Complex)Complex.conjugate((Complex)Complex.multiply((Complex)v1, (Complex)ysh1)));
                s2 = Complex.multiply((Complex)v2, (Complex)Complex.conjugate((Complex)Complex.multiply((Complex)v2, (Complex)ysh2)));
                if (avisador == 0.0) {
                    s12 = Complex.multiply((Complex)v1, (Complex)Complex.conjugate((Complex)Complex.multiply((Complex)Complex.subtract((Complex)v1, (Complex)v2), (Complex)ybr)));
                    s21 = Complex.multiply((Complex)v2, (Complex)Complex.conjugate((Complex)Complex.multiply((Complex)Complex.subtract((Complex)v2, (Complex)v1), (Complex)ybr)));
                } else if (avisador == 1.0) {
                    s12 = Complex.multiply((Complex)v1, (Complex)Complex.conjugate((Complex)Complex.multiply((Complex)Complex.subtract((Complex)v1, (Complex)v2), (Complex)ybr12)));
                    s21 = Complex.multiply((Complex)v2, (Complex)Complex.conjugate((Complex)Complex.multiply((Complex)Complex.subtract((Complex)v2, (Complex)v1), (Complex)ybr21)));
                    avisador = 0.0;
                }
                p12 = (double)Math.round((s1.re + s12.re) * 10000.0) / 10000.0;
                q12 = (double)Math.round((s1.im + s12.im) * 10000.0) / 10000.0;
                p21 = (double)Math.round((s2.re + s21.re) * 10000.0) / 10000.0;
                q21 = (double)Math.round((s2.im + s21.im) * 10000.0) / 10000.0;
                TempBran.setp12(p12);
                TempBran.setq12(q12);
                TempBran.setp21(p21);
                TempBran.setq21(q21);
            }
            if (TempBran instanceof ThreeWindingTrafo) {
                con3 = this.numbus(TempBran.getcon3());
                ThreeWindingTrafo TempThreeWindingTrafo = (ThreeWindingTrafo)TempBran;
                ++rama;
                fintrafo = count + 3;
                v1.re = this.vk[con1] * Math.cos(this.dk[con1]);
                v1.im = this.vk[con1] * Math.sin(this.dk[con1]);
                v2.re = this.vk[con2] * Math.cos(this.dk[con2]);
                v2.im = this.vk[con2] * Math.sin(this.dk[con2]);
                v3.re = this.vk[con3] * Math.cos(this.dk[con3]);
                v3.im = this.vk[con3] * Math.sin(this.dk[con3]);
                TempThreeWindingTrafo.setu1(this.vk[con1] * TempThreeWindingTrafo.getun1());
                TempThreeWindingTrafo.setu2(this.vk[con2] * TempThreeWindingTrafo.getun2());
                TempThreeWindingTrafo.setu3(this.vk[con3] * TempThreeWindingTrafo.getun3());
                tapchange1 = Complex.divide((Complex)new Complex(1.0, 0.0), (Complex)new Complex(TempThreeWindingTrafo.gett_re(), 0.0));
                tapchange2 = Complex.divide((Complex)new Complex(1.0, 0.0), (Complex)new Complex(TempThreeWindingTrafo.gett_re1(), 0.0));
                tapchange3 = Complex.divide((Complex)new Complex(1.0, 0.0), (Complex)new Complex(TempThreeWindingTrafo.gett_re2(), 0.0));
                elem1 = new Complex(this.ZthreeWinding[0]);
                elem1 = Complex.divide((Complex)new Complex(1.0, 0.0), (Complex)elem1);
                elem2 = new Complex(this.ZthreeWinding[1]);
                elem2 = Complex.divide((Complex)new Complex(1.0, 0.0), (Complex)elem2);
                elem3 = new Complex(this.ZthreeWinding[2]);
                elem3 = Complex.divide((Complex)new Complex(1.0, 0.0), (Complex)elem3);
                ramashunt = new Complex(0.0, this.BranchB[count]);
                cY12 = Complex.divide((Complex)Complex.multiply((Complex)elem1, (Complex)elem2), (Complex)Complex.add((Complex)elem1, (Complex)Complex.add((Complex)elem2, (Complex)elem3)));
                cY13 = Complex.divide((Complex)Complex.multiply((Complex)elem1, (Complex)elem3), (Complex)Complex.add((Complex)elem1, (Complex)Complex.add((Complex)elem2, (Complex)elem3)));
                cY23 = Complex.divide((Complex)Complex.multiply((Complex)elem2, (Complex)elem3), (Complex)Complex.add((Complex)elem1, (Complex)Complex.add((Complex)elem2, (Complex)elem3)));
                sumY1 = Complex.add((Complex)cY12, (Complex)cY13);
                sumY2 = Complex.add((Complex)cY12, (Complex)cY23);
                sumY3 = Complex.add((Complex)cY13, (Complex)cY23);
                if (TempThreeWindingTrafo.getlado() == "HV") {
                    sumY1 = Complex.add((Complex)sumY1, (Complex)ramashunt);
                } else if (TempThreeWindingTrafo.getlado() == "MV") {
                    sumY2 = Complex.add((Complex)sumY2, (Complex)ramashunt);
                } else if (TempThreeWindingTrafo.getlado() == "LV") {
                    sumY3 = Complex.add((Complex)sumY3, (Complex)ramashunt);
                }
                cY12 = Complex.negate((Complex)Complex.multiply((Complex)cY12, (Complex)Complex.multiply((Complex)tapchange1, (Complex)tapchange2)));
                cY13 = Complex.negate((Complex)Complex.multiply((Complex)cY13, (Complex)Complex.multiply((Complex)tapchange1, (Complex)tapchange3)));
                cY23 = Complex.negate((Complex)Complex.multiply((Complex)cY23, (Complex)Complex.multiply((Complex)tapchange2, (Complex)tapchange3)));
                sumY1 = Complex.multiply((Complex)sumY1, (Complex)Complex.multiply((Complex)tapchange1, (Complex)tapchange1));
                sumY2 = Complex.multiply((Complex)sumY2, (Complex)Complex.multiply((Complex)tapchange2, (Complex)tapchange2));
                sumY3 = Complex.multiply((Complex)sumY3, (Complex)Complex.multiply((Complex)tapchange3, (Complex)tapchange3));
                factor1 = Complex.add((Complex)sumY1, (Complex)Complex.add((Complex)cY12, (Complex)cY13));
                factor2 = Complex.add((Complex)sumY2, (Complex)Complex.add((Complex)cY12, (Complex)cY23));
                factor3 = Complex.add((Complex)sumY3, (Complex)Complex.add((Complex)cY13, (Complex)cY23));
                s1 = Complex.multiply((Complex)v1, (Complex)Complex.conjugate((Complex)Complex.multiply((Complex)v1, (Complex)factor1)));
                s2 = Complex.multiply((Complex)v2, (Complex)Complex.conjugate((Complex)Complex.multiply((Complex)v2, (Complex)factor2)));
                Complex s3 = Complex.multiply((Complex)v3, (Complex)Complex.conjugate((Complex)Complex.multiply((Complex)v3, (Complex)factor3)));
                s12 = Complex.multiply((Complex)v1, (Complex)Complex.conjugate((Complex)Complex.multiply((Complex)Complex.subtract((Complex)v1, (Complex)v2), (Complex)Complex.negate((Complex)cY12))));
                s21 = Complex.multiply((Complex)v2, (Complex)Complex.conjugate((Complex)Complex.multiply((Complex)Complex.subtract((Complex)v2, (Complex)v1), (Complex)Complex.negate((Complex)cY12))));
                Complex s13 = Complex.multiply((Complex)v1, (Complex)Complex.conjugate((Complex)Complex.multiply((Complex)Complex.subtract((Complex)v1, (Complex)v3), (Complex)Complex.negate((Complex)cY13))));
                Complex s31 = Complex.multiply((Complex)v3, (Complex)Complex.conjugate((Complex)Complex.multiply((Complex)Complex.subtract((Complex)v3, (Complex)v1), (Complex)Complex.negate((Complex)cY13))));
                Complex s23 = Complex.multiply((Complex)v2, (Complex)Complex.conjugate((Complex)Complex.multiply((Complex)Complex.subtract((Complex)v2, (Complex)v3), (Complex)Complex.negate((Complex)cY23))));
                Complex s32 = Complex.multiply((Complex)v3, (Complex)Complex.conjugate((Complex)Complex.multiply((Complex)Complex.subtract((Complex)v3, (Complex)v2), (Complex)Complex.negate((Complex)cY23))));
                p12 = (double)Math.round((s1.re + s12.re) * 10000.0) / 10000.0;
                q12 = (double)Math.round((s1.im + s12.im) * 10000.0) / 10000.0;
                p21 = (double)Math.round((s2.re + s21.re) * 10000.0) / 10000.0;
                q21 = (double)Math.round((s2.im + s21.im) * 10000.0) / 10000.0;
                double p13 = (double)Math.round(s13.re * 10000.0) / 10000.0;
                double q13 = (double)Math.round(s13.im * 10000.0) / 10000.0;
                double p31 = (double)Math.round((s3.re + s31.re) * 10000.0) / 10000.0;
                double q31 = (double)Math.round((s3.im + s31.im) * 10000.0) / 10000.0;
                double p23 = (double)Math.round(s23.re * 10000.0) / 10000.0;
                double q23 = (double)Math.round(s23.im * 10000.0) / 10000.0;
                double p32 = (double)Math.round(s32.re * 10000.0) / 10000.0;
                double q32 = (double)Math.round(s32.im * 10000.0) / 10000.0;
                TempBran.setp12(p12);
                TempBran.setq12(q12);
                TempBran.setp21(p21);
                TempBran.setq21(q21);
                TempBran.setp13(p13);
                TempBran.setq13(q13);
                TempBran.setp31(p31);
                TempBran.setq31(q31);
                TempBran.setp23(p23);
                TempBran.setq23(q23);
                TempBran.setp32(p32);
                TempBran.setq32(q32);
                c = false;
                count += 2;
            }
            if (TempBran instanceof Upfc) {
                Upfc TempUpfc = (Upfc)TempBran;
                rserie = this.PARupfc[countupfc][0];
                xserie = this.PARupfc[countupfc][1];
                gshunt = this.PARupfc[countupfc][2];
                bshunt = this.PARupfc[countupfc][3];
                this.Pfexc[con1][countupfc] = this.Pesp[countupfc];
                this.Pfboost[con2][countupfc] = -this.Pesp[countupfc];
                this.Qfexc[con1][countupfc] = this.QEesp[countupfc];
                this.Qfboost[con2][countupfc] = this.QBesp[countupfc];
                TempUpfc.setpfinj(this.Pfexc[con1][countupfc] * this.sref);
                TempUpfc.setqeinj(this.Qfexc[con1][countupfc] * this.sref);
                TempUpfc.setqbinj(this.Qfboost[con2][countupfc] * this.sref);
                Complex sw1 = new Complex(rserie, xserie);
                Complex sw2 = new Complex(1.0, 0.0);
                Complex sw3 = Complex.divide((Complex)sw2, (Complex)sw1);
                sw1 = Complex.conjugate((Complex)sw3);
                sw2 = new Complex(this.vk[con2], this.dk[con2]);
                sw3 = new Complex(this.Pfboost[con2][countupfc], this.Qfboost[con2][countupfc]);
                Complex sw4 = Complex.negate((Complex)Complex.divide((Complex)sw3, (Complex)Complex.multiply((Complex)sw1, (Complex)sw2)));
                vboost = Complex.abs((Complex)Complex.conjugate((Complex)sw4));
                thboost = Complex.argument((Complex)Complex.conjugate((Complex)sw4));
                sw2 = new Complex(gshunt, -bshunt);
                sw3 = new Complex(this.vk[con1], this.dk[con1]);
                Complex sw5 = new Complex(this.Pfexc[con1][countupfc], this.Qfexc[con1][countupfc]);
                Complex sw6 = Complex.subtract((Complex)Complex.multiply((Complex)sw4, (Complex)sw1), (Complex)Complex.divide((Complex)sw5, (Complex)sw3));
                Complex sw7 = Complex.divide((Complex)sw6, (Complex)sw2);
                vexc = Complex.abs((Complex)Complex.conjugate((Complex)sw7));
                thexc = Complex.argument((Complex)Complex.conjugate((Complex)sw7));
                this.VARupfc[countupfc][0] = vboost;
                this.VARupfc[countupfc][1] = thboost;
                this.VARupfc[countupfc][2] = vexc;
                this.VARupfc[countupfc][3] = thexc;
                TempUpfc.setboostv(this.VARupfc[countupfc][0] * TempUpfc.getun1());
                TempUpfc.setexcv(this.VARupfc[countupfc][2] * TempUpfc.getun1());
                TempUpfc.setboostang(this.VARupfc[countupfc][1] * 180.0 / Math.PI);
                TempUpfc.setexcang(this.VARupfc[countupfc][3] * 180.0 / Math.PI);
                p12 = this.Pesp[countupfc];
                p21 = -this.Pesp[countupfc];
                q12 = this.QEesp[countupfc];
                q21 = this.QBesp[countupfc];
                TempUpfc.setp12(p12);
                TempUpfc.setq12(q12);
                TempUpfc.setp21(p21);
                TempUpfc.setq21(q21);
                ++countupfc;
            }
            ++count;
        }
        for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
            TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
            if (!(TempComponent instanceof ndb_comp) || ((TempNdb_comp = (ndb_comp)TempComponent).getctrla().equals(this.ctrla) || this.ctrla.equals("ALL CONTROL AREAS")) && TempComponent.getactive() && TempComponent.getvalid() && TempComponent.getinservice()) continue;
            if (TempComponent instanceof ndb_branch) {
                TempBran = (ndb_branch)TempComponent;
                TempBran.setp12(0.0);
                TempBran.setq12(0.0);
                TempBran.setp21(0.0);
                TempBran.setq21(0.0);
                continue;
            }
            if (!(TempComponent instanceof ndb_1pol)) continue;
            Temp1pol = (ndb_1pol)TempComponent;
            Temp1pol.setp(0.0);
            Temp1pol.setq(0.0);
        }
        int cnbr = 0;
        for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
            TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
            if (!(TempComponent instanceof ndb_comp) || !(TempNdb_comp = (ndb_comp)TempComponent).getctrla().equals(this.ctrla) && !this.ctrla.equals("ALL CONTROL AREAS") || !TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice() || !(TempComponent instanceof ndb_branch) || (TempBran = (ndb_branch)TempComponent) instanceof LineDC) continue;
            con1 = this.numbus(TempBran.getcon1());
            if (con1 > -1 && (con2 = this.numbus(TempBran.getcon2())) > -1 && (con3 = this.numbus(TempBran.getcon3())) == -1) {
                this.NomBra[cnbr] = TempBran.getName();
                this.FlujosP[cnbr] = TempBran.getp12() - (TempBran.getp12() + TempBran.getp21()) / 2.0;
                this.FlujosQ[cnbr] = TempBran.getq12() - (TempBran.getq12() + TempBran.getq21()) / 2.0;
                this.PerdP[cnbr] = TempBran.getp12() + TempBran.getp21();
                this.PerdQ[cnbr] = TempBran.getq12() + TempBran.getq21();
                ++cnbr;
                continue;
            }
            con1 = this.numbus(TempBran.getcon1());
            if (con1 <= -1 || (con2 = this.numbus(TempBran.getcon2())) <= -1 || (con3 = this.numbus(TempBran.getcon3())) <= -1) continue;
            this.NomBra[cnbr] = TempBran.getName();
            this.FlujosP[cnbr] = TempBran.getp12() - (TempBran.getp12() + TempBran.getp21()) / 2.0;
            this.FlujosQ[cnbr] = TempBran.getq12() - (TempBran.getq12() + TempBran.getq21()) / 2.0;
            this.PerdP[cnbr] = TempBran.getp12() + TempBran.getp21();
            this.PerdQ[cnbr] = TempBran.getq12() + TempBran.getq21();
            this.NomBra[++cnbr] = TempBran.getName();
            this.FlujosP[cnbr] = TempBran.getp13() - (TempBran.getp13() + TempBran.getp31()) / 2.0;
            this.FlujosQ[cnbr] = TempBran.getq13() - (TempBran.getq13() + TempBran.getq31()) / 2.0;
            this.PerdP[cnbr] = TempBran.getp13() + TempBran.getp31();
            this.PerdQ[cnbr] = TempBran.getq13() + TempBran.getq31();
            this.NomBra[++cnbr] = TempBran.getName();
            this.FlujosP[cnbr] = TempBran.getp23() - (TempBran.getp23() + TempBran.getp32()) / 2.0;
            this.FlujosQ[cnbr] = TempBran.getq23() - (TempBran.getq23() + TempBran.getq32()) / 2.0;
            this.PerdP[cnbr] = TempBran.getp23() + TempBran.getp32();
            this.PerdQ[cnbr] = TempBran.getq23() + TempBran.getq32();
            ++cnbr;
        }
        if (!this.yearlylf) {
            myPrintStream.println();
            myPrintStream.println("        Total System Power Statistics");
            myPrintStream.println("        -----------------------------");
            myPrintStream.println();
            double auxd = Ploss + Ploadtot;
            myPrintStream.println("Ptot Gen =" + StringUtil.numformat(auxd, 12, 2) + " [ MW ]");
            auxd = Ploadtot;
            myPrintStream.println("Ptot Load=" + StringUtil.numformat(auxd, 12, 2) + " [ MW ]");
            auxd = Ploss + Ploadtot;
            myPrintStream.println("P Nt.Loss=" + StringUtil.numformat(Ploss, 12, 2) + " [ MW ], " + StringUtil.numformat(Ploss / auxd * 100.0, 6, 1) + " [%]");
            auxd = Qloss + Qloadtot;
            myPrintStream.println("Qtot Gen =" + StringUtil.numformat(auxd, 12, 2) + " [MVAR]");
            auxd = Qloadtot;
            myPrintStream.println("Qtot Load=" + StringUtil.numformat(auxd, 12, 2) + " [MVAR]");
            auxd = Qloss;
            myPrintStream.println("Q Nt.Loss=" + StringUtil.numformat(auxd, 12, 2) + " [MVAR]");
            myPrintStream.println();
        }
    }

    public void setParameters(double tolerancia, boolean constantJacob, boolean qlimsat, boolean convrep, boolean flowr, boolean limq) {
        this.tol = tolerancia > 1.0 ? 1.0 / this.sref : (tolerancia < 0.001 ? 0.001 / this.sref : tolerancia / this.sref);
        this.retriang = !constantJacob;
        this.verifQlim = qlimsat;
        this.repconv = convrep;
        this.flowrep = flowr;
        this.limqrect = limq;
    }

    private void verificarGrafo() throws Exception {
        int i;
        int[] grupnod1 = new int[this.numnod + 1];
        boolean[] ingrup1 = new boolean[this.numnod];
        grupnod1[0] = 1;
        grupnod1[1] = 0;
        ingrup1[0] = true;
        for (i = 1; i <= grupnod1[0]; ++i) {
            for (int j = 0; j < this.numnod; ++j) {
                if (!this.matCx[grupnod1[i]][j] || ingrup1[j]) continue;
                grupnod1[0] = grupnod1[0] + 1;
                grupnod1[grupnod1[0]] = j;
                ingrup1[j] = true;
            }
            if (grupnod1[0] == this.numnod) break;
        }
        if (grupnod1[0] < this.numnod) {
            for (i = 0; i < this.numnod && ingrup1[i]; ++i) {
            }
            System.out.println("Valor: " + ingrup1[i]);
            Busbar TempBusbar = (Busbar)this.BusbarVector.elementAt(i);
            this.javaLF_Error("There's an isolated Subsystem; \"" + TempBusbar.getName() + "\"," + "...");
        }
    }

    public void finalize() {
        this.Ybus = null;
        this.matCx = null;
        this.Pinj = null;
        this.Qinj = null;
        this.QGmin = null;
        this.QGmax = null;
        this.tipobarra = null;
        this.indic_bPX = null;
        this.indic_bPQ = null;
        this.indic_bPV = null;
        this.indic_bvQ = null;
        this.indic_bsetPV = null;
        this.volt_state = null;
        this.delta_state = null;
        this.Pfboost = null;
        this.Qfboost = null;
        this.Pfexc = null;
        this.Qfexc = null;
        this.PARupfc = null;
        this.VARupfc = null;
        this.TOupfc = null;
        this.Pesp = null;
        this.QEesp = null;
        this.QBesp = null;
        this.TOlinedc = null;
        this.Pdr = null;
        this.Pdi = null;
        this.Id = null;
        this.Qrect = null;
        this.Qinver = null;
        this.VARlinedc_k = null;
        this.DVlinedc = null;
        this.Rk = null;
        this.Rfijo = null;
        this.DR = null;
        this.LimVARlinedc = null;
        this.PARlinedc = null;
        this.PARrect = null;
        this.PARinver = null;
        this.NombreLinedc = null;
        this.nb = null;
        this.leng = null;
        this.Gbus = null;
        this.Bbus = null;
        this.LFJ = null;
        this.vk = null;
        this.vk0 = null;
        this.dk = null;
        this.Dv = null;
        this.Ddv = null;
        this.Pdatfijo = null;
        this.Pdatactual = null;
        this.Pk = null;
        this.Qdatfijo = null;
        this.Qdatactual = null;
        this.Qk = null;
        this.DPv = null;
        this.DQv = null;
    }
}

