/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import de.core.ArrayNode;
import de.core.DeepEdit;
import de.core.comp;
import de.data.DE_GeneralEnums;
import de.data.ParameterData;
import de.data.ValidationRule;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.table.TableCellEditor;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.JXTreeTable;
import org.jdesktop.swingx.decorator.ColorHighlighter;
import org.jdesktop.swingx.decorator.HighlightPredicate;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.treetable.DefaultTreeTableModel;
import org.jdesktop.swingx.treetable.MutableTreeTableNode;
import org.jdesktop.swingx.treetable.TreeTableModel;
import org.jdesktop.swingx.treetable.TreeTableNode;

class JXParameterTreeTable
extends JXTreeTable {
    private comp compOwner;
    private String className;
    private String compName;

    public JXParameterTreeTable() {
        this.initComponents();
    }

    public JXParameterTreeTable(comp selectedComp) {
        this.initComponents();
        this.setComponent(selectedComp);
    }

    public JXParameterTreeTable(String className, String compName) {
        this.initComponents();
        this.className = className;
        this.compName = compName;
    }

    private void initComponents() {
        ArrayNode root = new ArrayNode(new Object[]{"root", ""});
        for (DE_GeneralEnums.parameterGroup p : DE_GeneralEnums.parameterGroup.values()) {
            root.add((MutableTreeTableNode)new ArrayNode(new Object[]{p.toString(), ""}));
        }
        DefaultTreeTableModel mdl = new DefaultTreeTableModel((TreeTableNode)root);
        String[] header = new String[]{"Name", "Value"};
        ArrayList<String> colNames = new ArrayList<String>(Arrays.asList(header));
        mdl.setColumnIdentifiers(colNames);
        this.setTreeTableModel((TreeTableModel)mdl);
        this.setLeafIcon(null);
        this.setOpenIcon(null);
        this.setClosedIcon(null);
        this.setHighlighters(new Highlighter[]{new ColorHighlighter(HighlightPredicate.IS_FOLDER, Color.lightGray, Color.BLACK)});
    }

    public TableCellEditor getCellEditor(int row, int column) {
        ParameterData pdata;
        Object oName = this.getValueAt(row, 0);
        Object oVal = this.getValueAt(row, 1);
        String sValidation = null;
        if (oName != null && this.compOwner != null) {
            pdata = this.compOwner.getDefaultParameterInfo(oName.toString());
            sValidation = pdata.getValidationRule(0);
            switch (pdata.geteDataType()) {
                case BooleanValue: {
                    return new JXTable.BooleanEditor();
                }
                case IntegerValue: {
                    return new JXTable.NumberEditor();
                }
                case DoubleValue: {
                    return new JXTable.NumberEditor();
                }
            }
        } else if (oName != null && this.className != null && (pdata = DeepEdit.getDefaultParameterInfo(this.className, oName.toString())) != null) {
            sValidation = pdata.getValidationRule(0);
        }
        if (sValidation != null && !sValidation.isEmpty() && ValidationRule.isListType(sValidation)) {
            JComboBox<String> cboValidation = new JComboBox<String>(ValidationRule.getValidRangeList(sValidation));
            return new DefaultCellEditor(cboValidation);
        }
        return super.getCellEditor(row, column);
    }

    public final comp getComponent() {
        return this.compOwner;
    }

    public final String getName() {
        if (this.compOwner != null) {
            return this.compOwner.getClassName() + "::" + this.compOwner.getName();
        }
        return this.className + "::" + this.compName;
    }

    public final void setComponent(comp oComp) {
        if (oComp != null) {
            this.compOwner = oComp;
            this.clear();
            for (ParameterData pdata : oComp.getAllParametersInfo()) {
                if (!DeepEdit.isParameterShowInGUI(oComp.getClassName(), pdata.Name)) continue;
                this.addParameter(pdata);
            }
            if (this.getRowCount() > 0) {
                this.expandRow(0);
            }
        }
    }

    public void clear() {
        DefaultTreeTableModel model = (DefaultTreeTableModel)this.getTreeTableModel();
        ArrayNode root = (ArrayNode)model.getRoot();
        for (int i = 0; i < root.getChildCount(); ++i) {
            ArrayNode dataNode = (ArrayNode)root.getChildAt(i);
            while (dataNode.getChildCount() > 0) {
                dataNode.remove(0);
            }
        }
        model.setRoot((TreeTableNode)root);
    }

    public void addParameter(ParameterData pdata) {
        if (pdata != null) {
            this.addParameter(pdata.Name, pdata.getValue(), pdata.geteDataType(), pdata.geteGroup());
        }
    }

    private void addParameter(String ParameterName, String sValue, DE_GeneralEnums.databaseDataType dataType, DE_GeneralEnums.parameterGroup ParameterGroup) {
        boolean existsGroup = false;
        boolean existsParameter = false;
        ArrayNode myRoot = (ArrayNode)((Object)this.getTreeTableModel().getRoot());
        for (int i = 0; i < myRoot.getChildCount(); ++i) {
            if (!myRoot.getChildAt(i).getValueAt(0).toString().equals(ParameterGroup.toString())) continue;
            existsGroup = true;
            ArrayNode myChild = (ArrayNode)myRoot.getChildAt(i);
            for (int k = 0; k < myChild.getChildCount(); ++k) {
                if (!myChild.getChildAt(k).getValueAt(0).toString().equals(ParameterName)) continue;
                existsParameter = true;
                myChild.getChildAt(k).setValueAt((Object)sValue, 1);
                break;
            }
            if (existsParameter) continue;
            myChild.add((MutableTreeTableNode)new ArrayNode(new Object[]{ParameterName, sValue}));
        }
        assert (existsGroup) : "Why the parameter belongs to an inexistant group?" + (Object)((Object)ParameterGroup);
        ((DefaultTreeTableModel)this.getTreeTableModel()).setRoot((TreeTableNode)myRoot);
    }
}

