/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import de.core.JMapPoint;
import java.awt.Point;
import java.awt.Rectangle;

class JMapTransformBase {
    protected Rectangle screen_;
    protected double scale_;
    protected double centerMap_;
    protected double centerScreen_;
    protected double latScale_;
    protected double ox_;
    protected double oy_;
    protected double x1_;
    protected double x2_;
    protected double y1_;
    protected double y2_;

    JMapTransformBase(Rectangle screen, double x1, double y1, double x2, double y2) {
        this.x1_ = x1;
        this.x2_ = x2;
        this.y1_ = y1;
        this.y2_ = y2;
        this.screen_ = new Rectangle(screen.x, screen.y, screen.width, screen.height);
        this.ox_ = x1;
        this.oy_ = y1;
    }

    public Rectangle getScreen() {
        return this.screen_;
    }

    public double getScale() {
        return this.scale_;
    }

    public double getlatScale() {
        return this.latScale_;
    }

    public double getOffsetX() {
        return this.ox_;
    }

    public double getOffsetY() {
        return this.oy_;
    }

    public JMapPoint getMapTL() {
        return new JMapPoint(this.x1_, this.y1_);
    }

    public JMapPoint getMapBR() {
        return new JMapPoint(this.x2_, this.y2_);
    }

    public JMapPoint getPoint(int x, int y) {
        return new JMapPoint(0.0, 0.0);
    }

    public JMapPoint getPoint(Point p) {
        return this.getPoint(p.x, p.y);
    }

    public Point getPoint(double x, double y) {
        return new Point(0, 0);
    }

    public Point getPoint(JMapPoint mp) {
        return this.getPoint(mp.x, mp.y);
    }

    public double getfac() {
        return Math.abs(this.y1_ - this.y2_) * 111.0;
    }
}

