/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import de.core.DeepEdit;
import de.core.JMapTag;
import de.core.JTokenParser;
import java.awt.Image;
import java.awt.MediaTracker;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.ContentHandler;
import java.net.URLConnection;
import java.util.StringTokenizer;
import java.util.Vector;

class JMapTagsContentHandler
extends ContentHandler {
    private String strBuffer_ = "";
    private int iBufPos = 0;
    private int iLength = 0;
    private int iImage = 1;
    private MediaTracker mediaTracker;
    protected Vector vecTagObjects_ = new Vector();
    protected Vector vecLevels_ = new Vector();
    DeepEdit applet;

    public JMapTagsContentHandler(DeepEdit aapplet) {
        this.applet = aapplet;
        this.mediaTracker = new MediaTracker(DeepEdit.frame);
    }

    @Override
    public Object getContent(URLConnection urlc) {
        try {
            InputStream is = urlc.getInputStream();
            DataInputStream ds = new DataInputStream(is);
            this.iLength = urlc.getContentLength();
            if (this.iLength != -1) {
                byte[] bBuffer = new byte[this.iLength];
                ds.readFully(bBuffer);
                this.strBuffer_ = new String(bBuffer, 0);
            } else {
                int i = is.read();
                while (i != -1) {
                    this.strBuffer_ = this.strBuffer_ + (char)i;
                    i = is.read();
                }
            }
            return this.parseDataBuffer();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    protected Object parseDataBuffer() {
        String strToken = new String("");
        StringTokenizer st = new StringTokenizer(this.strBuffer_, " \t\n\r");
        while (st.hasMoreTokens()) {
            strToken = st.nextToken(" \t\n\r");
            if (strToken.equalsIgnoreCase("TAG") && st.hasMoreTokens()) {
                this.vecTagObjects_.addElement(this.parseTAG(st));
                continue;
            }
            if (!strToken.equalsIgnoreCase("DISPLAYLEVEL") || !st.hasMoreTokens()) continue;
            this.parseDISPLAYLEVEL(st);
        }
        try {
            this.mediaTracker.waitForAll(500L);
        }
        catch (InterruptedException e) {
            e.printStackTrace(System.out);
        }
        return this.vecTagObjects_;
    }

    protected JMapTag parseTAG(StringTokenizer sts) {
        String lineToken = "";
        String strObjType = JTokenParser.parseQuoteString(sts);
        JMapTag tag = new JMapTag(strObjType);
        lineToken = sts.nextToken();
        while (sts.hasMoreTokens() && !lineToken.equalsIgnoreCase("END")) {
            block16: {
                Image im;
                if (lineToken.equalsIgnoreCase("DL")) {
                    tag.addLevels(JTokenParser.parseIntegerVec(sts));
                } else if (lineToken.equalsIgnoreCase("COLOR")) {
                    tag.setColor(JTokenParser.parseIntegerVec(sts));
                } else if (lineToken.equalsIgnoreCase("IMAGE")) {
                    lineToken = JTokenParser.parseQuoteString(sts);
                    try {
                        im = this.applet.getImage(this.applet.getCodeBase(), lineToken);
                        if (im != null) {
                            this.mediaTracker.addImage(im, this.iImage++);
                            tag.setImage(im);
                            break block16;
                        }
                        System.out.println("Couldn't load image: " + lineToken + " define with tag 'IMAGE' in MAP.TAG file. Check tag file in map folder" + " and make sure the location of the image file is correct.");
                    }
                    catch (Exception e) {
                        e.printStackTrace(System.out);
                    }
                } else if (lineToken.equalsIgnoreCase("IMAGE1")) {
                    lineToken = JTokenParser.parseQuoteString(sts);
                    try {
                        im = this.applet.getImage(this.applet.getCodeBase(), lineToken);
                        if (im != null) {
                            this.mediaTracker.addImage(im, this.iImage++);
                            tag.setImage1(im);
                            break block16;
                        }
                        System.out.println("Couldn't load image: " + lineToken + " define with tag 'IMAGE1' in MAP.TAG file. Check tag file in map folder" + " and make sure the location of the image file is correct.");
                    }
                    catch (Exception e) {
                        e.printStackTrace(System.out);
                    }
                } else if (lineToken.equalsIgnoreCase("SUBTYPE")) {
                    lineToken = sts.nextToken();
                }
            }
            lineToken = sts.nextToken();
        }
        return tag;
    }

    protected void parseDISPLAYLEVEL(StringTokenizer sts) {
        String lineToken = sts.nextToken();
        Vector v = JTokenParser.parseIntegerVec(sts);
        Vector<String> dl = new Vector<String>();
        dl.addElement(lineToken);
    }
}

