/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import de.core.JMapCanvas;
import de.core.JMapObserverBase;
import de.core.JMapPoint;
import de.core.JMapTransformBase;
import de.core.JMapTransformEqui;
import de.core.JMapTransformMercator;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Observable;

class JMapObserverZoom
extends JMapObserverBase {
    int lock_ = 0;

    JMapObserverZoom(JMapCanvas canvas) {
        super(canvas);
        canvas.obMouseAreaSelection().addObserver(this);
        canvas.obMouseButtonPressed().addObserver(this);
    }

    @Override
    public void update(Observable o, Object obj) {
        if (this.lock_ == 0) {
            this.lock_ = 1;
            if (this.canvas_.isVisible() && this.canvas_.isValid()) {
                this.transform_ = this.canvas_.getTransform();
                if (obj instanceof Rectangle) {
                    this.zoom((Rectangle)obj);
                }
                if (obj instanceof Point) {
                    this.dezoom();
                }
            }
            this.lock_ = 0;
        }
    }

    public void dezoom() {
        this.transform_ = this.canvas_.popTransform();
        this.canvas_.repaint();
    }

    public void zoom(Rectangle zr) {
        Point p2;
        Point p1;
        JMapTransformBase lastTransform_;
        Rectangle r = new Rectangle();
        r = this.canvas_.bounds();
        double oldAspect = (double)r.width / (double)r.height;
        double newAspect = (double)zr.width / (double)zr.height;
        int xshift = 0;
        int yshift = 0;
        if (oldAspect > newAspect) {
            xshift = (int)((oldAspect / newAspect - 1.0) * (double)zr.width / 2.0);
        }
        if (oldAspect < newAspect) {
            yshift = (int)((newAspect / oldAspect - 1.0) * (double)zr.height / 2.0);
        }
        JMapPoint mp0 = this.transform_.getPoint(zr.x - xshift, zr.y - yshift);
        JMapPoint mp1 = this.transform_.getPoint(zr.x + zr.width + xshift, zr.y + zr.height + yshift);
        if (this.canvas_.applet.MyGIS.projection.equals("Equirectangle")) {
            this.canvas_.pushTransform(new JMapTransformEqui(r, mp0.x, mp0.y, mp1.x, mp1.y));
        } else {
            this.canvas_.pushTransform(new JMapTransformMercator(r, mp0.x, mp0.y, mp1.x, mp1.y));
        }
        this.canvas_.repaint();
        if (this.canvas_.applet.MyGIS.projection.equals("Equirectangle")) {
            lastTransform_ = (JMapTransformEqui)this.canvas_.getTransform();
            p1 = ((JMapTransformEqui)lastTransform_).getPoint(mp0.x, mp0.y);
            p2 = ((JMapTransformEqui)lastTransform_).getPoint(mp1.x, mp1.y);
            JMapPoint mp2 = ((JMapTransformEqui)lastTransform_).getPoint(p1.x, p1.y);
            JMapPoint mp3 = ((JMapTransformEqui)lastTransform_).getPoint(p2.x, p2.y);
        } else {
            lastTransform_ = (JMapTransformMercator)this.canvas_.getTransform();
            p1 = ((JMapTransformMercator)lastTransform_).getPoint(mp0.x, mp0.y);
            p2 = ((JMapTransformMercator)lastTransform_).getPoint(mp1.x, mp1.y);
            JMapPoint mp2 = ((JMapTransformMercator)lastTransform_).getPoint(p1.x, p1.y);
            JMapPoint mp3 = ((JMapTransformMercator)lastTransform_).getPoint(p2.x, p2.y);
        }
        if (p1 == p2) {
            Graphics g = this.canvas_.getGraphics();
        }
    }
}

