/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import de.core.JMapCanvas;
import de.core.JMapObserverBase;
import de.core.JMapPoint;
import de.utils.StringUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.util.Observable;

class JMapObserverPosition
extends JMapObserverBase {
    int lock_ = 0;
    int width_ = 0;

    JMapObserverPosition(JMapCanvas canvas) {
        super(canvas);
        canvas.obMouseMove().addObserver(this);
        canvas.obMouseDrag().addObserver(this);
    }

    @Override
    public void update(Observable o, Object obj) {
        if (this.lock_ == 0) {
            this.lock_ = 1;
            if (this.canvas_.isVisible() && this.canvas_.isValid()) {
                this.transform_ = this.canvas_.getTransform();
                if (obj instanceof Point) {
                    this.drawPosition((Point)obj);
                }
            }
            this.lock_ = 0;
        }
    }

    public void drawPosition(Point p) {
        double aux2;
        double aux1;
        Graphics g = this.canvas_.getGraphics();
        JMapPoint mp = this.transform_.getPoint(p);
        Double dx = new Double(mp.x);
        Double dy = new Double(mp.y);
        String sLat = "lat: ";
        String sLon = "lon: ";
        if (mp.y >= 0.0) {
            aux1 = mp.y;
            aux2 = Math.floor(aux1);
            sLat = sLat + StringUtil.printf((int)aux2, 4) + " ";
            aux1 = (aux1 - aux2) * 60.0;
            aux2 = Math.floor(aux1);
            sLat = sLat + StringUtil.printf((int)aux2, 4) + " ";
            aux1 = (aux1 - aux2) * 60.0;
            aux2 = Math.floor(aux1);
            sLat = sLat + StringUtil.printf((int)aux2, 4) + " N ";
        } else {
            aux1 = Math.abs(mp.y);
            aux2 = Math.floor(aux1);
            sLat = sLat + StringUtil.printf((int)(-aux2), 4) + " ";
            aux1 = (aux1 - aux2) * 60.0;
            aux2 = Math.floor(aux1);
            sLat = sLat + StringUtil.printf((int)(-aux2), 4) + " ";
            aux1 = (aux1 - aux2) * 60.0;
            aux2 = Math.floor(aux1);
            sLat = sLat + StringUtil.printf((int)(-aux2), 4) + " S ";
        }
        if (mp.x >= 0.0) {
            aux1 = mp.x;
            aux2 = Math.floor(aux1);
            aux1 = (aux1 - aux2) * 60.0;
            sLon = sLon + StringUtil.printf((int)aux2, 4) + " ";
            aux2 = Math.floor(aux1);
            aux1 = (aux1 - aux2) * 60.0;
            sLon = sLon + StringUtil.printf((int)aux2, 4) + " ";
            aux2 = Math.floor(aux1);
            sLon = sLon + StringUtil.printf((int)aux2, 4) + " W ";
        } else {
            aux1 = Math.abs(mp.x);
            aux2 = Math.floor(aux1);
            aux1 = (aux1 - aux2) * 60.0;
            sLon = sLon + StringUtil.printf((int)(-aux2), 4) + " ";
            aux2 = Math.floor(aux1);
            aux1 = (aux1 - aux2) * 60.0;
            sLon = sLon + StringUtil.printf((int)(-aux2), 4) + " ";
            aux2 = Math.floor(aux1);
            sLon = sLon + StringUtil.printf((int)(-aux2), 4) + " E ";
        }
        g.setFont(new Font("Monospaced", 0, 9));
        FontMetrics fm = g.getFontMetrics();
        if (this.width_ == 0) {
            this.width_ = fm.stringWidth(sLat) + 10;
        }
        g.setColor(Color.lightGray);
        g.fill3DRect(this.canvas_.bounds().width - this.width_ - 5, this.canvas_.bounds().height - fm.getHeight() * 2 - 10, this.width_, fm.getHeight() * 2 + 5, true);
        g.setColor(Color.black);
        g.drawString(sLat, this.canvas_.bounds().width - this.width_, this.canvas_.bounds().height - fm.getHeight() - 10);
        g.drawString(sLon, this.canvas_.bounds().width - this.width_, this.canvas_.bounds().height - 10);
    }
}

