/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import de.core.DeepEdit;
import de.core.DeepEditFrame;
import de.core.JMapCanvas;
import de.core.JMapDataRepository;
import de.core.JMapObject;
import de.core.JMapObserverBase;
import de.core.JMapPoint;
import de.core.JMapTag;
import de.core.Line;
import de.core.comp;
import de.core.tdb_centroid;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.util.Vector;

class JMapObserverFeatures
extends JMapObserverBase {
    int lock_ = 0;
    JMapDataRepository dataRepository_;
    double fac = 1.0;

    JMapObserverFeatures(JMapCanvas canvas, JMapDataRepository drep) {
        super(canvas);
        this.dataRepository_ = drep;
        canvas.obDraw().addObserver(this);
    }

    @Override
    protected void draw(Graphics g) {
        JMapObject mo = null;
        JMapObject mo1 = null;
        Polygon poli = null;
        Polygon poli2 = null;
        Rectangle mirect = null;
        Image im = null;
        tdb_centroid Tempcentroid = null;
        if (this.lock_ == 0 && this.canvas_.isVisible() && this.canvas_.isValid()) {
            comp TempComponent;
            Point p1;
            Point p0;
            int j;
            Vector pItr;
            JMapPoint mp1;
            JMapPoint mp0;
            Color c;
            int i;
            int FontHeight;
            FontMetrics MyFontMetrics;
            this.fac = this.transform_.getfac() / this.canvas_.applet.MyGIS.HR;
            if (this.fac <= 1.0) {
                g.setFont(new Font("Serif", 0, 12));
                MyFontMetrics = g.getFontMetrics();
                FontHeight = MyFontMetrics.getHeight();
            } else {
                g.setFont(DeepEdit.TextFont);
                MyFontMetrics = g.getFontMetrics();
                FontHeight = MyFontMetrics.getHeight();
            }
            this.lock_ = 1;
            Rectangle r = new Rectangle();
            r = this.canvas_.bounds();
            Vector itr = this.dataRepository_.getVecFeatures();
            for (i = 0; i < itr.size(); ++i) {
                mo = (JMapObject)itr.elementAt(i);
                if (mo.getObjType().equals("line")) continue;
                if (mo.getObjType().equals("river") || mo.getObjType().equals("coastline") || mo.getObjType().equals("island") || mo.getObjType().equals("lake") || mo.getObjType().equals("zone")) {
                    poli = new Polygon();
                    poli2 = new Polygon();
                }
                if ((c = this.getColor(mo.getObjType())) == null) continue;
                g.setColor(c);
                mp0 = this.transform_.getPoint(0, 0);
                mp1 = this.transform_.getPoint(r.width, r.height);
                if (mo.intersects(mp0, mp1) != 1) continue;
                pItr = mo.getVector();
                for (j = 0; j < pItr.size() - 1; ++j) {
                    mp0 = (JMapPoint)pItr.elementAt(j);
                    mp1 = (JMapPoint)pItr.elementAt(j + 1);
                    p0 = this.transform_.getPoint(mp0.x, mp0.y);
                    p1 = this.transform_.getPoint(mp1.x, mp1.y);
                    if (mo.getObjType().equals("river") || mo.getObjType().equals("coastline") || mo.getObjType().equals("island") || mo.getObjType().equals("lake") || mo.getObjType().equals("zone")) {
                        poli.addPoint(p0.x, p0.y);
                        if (!mo.getObjType().equals("coastline")) continue;
                        poli2.addPoint(p0.x + 3, p0.y + 3);
                        continue;
                    }
                    g.drawLine(p0.x, p0.y, p1.x, p1.y);
                }
                if (mo.getObjType().equals("river")) {
                    g.setColor(c);
                    g.fillPolygon(poli);
                    g.setColor(c.darker());
                    g.drawPolygon(poli);
                }
                if (mo.getObjType().equals("island")) {
                    g.setColor(Color.lightGray);
                    g.fillPolygon(poli);
                    g.setColor(c.darker());
                    g.drawPolygon(poli);
                }
                if (mo.getObjType().equals("lake")) {
                    g.setColor(c);
                    g.fillPolygon(poli);
                    g.setColor(c.darker());
                    g.drawPolygon(poli);
                }
                if (mo.getObjType().equals("zone")) {
                    DeepEdit cfr_ignored_0 = this.canvas_.applet;
                    if (DeepEditFrame.MyPietEditFrame != null && (this.canvas_.applet.GISDL & 0x200) != 0) {
                        j = 0;
                        while (true) {
                            DeepEdit cfr_ignored_1 = this.canvas_.applet;
                            if (j >= DeepEditFrame.MyPietEditFrame.MyPietSchematic.Components.size()) break;
                            DeepEdit cfr_ignored_2 = this.canvas_.applet;
                            TempComponent = (comp)DeepEditFrame.MyPietEditFrame.MyPietSchematic.Components.elementAt(j);
                            if (TempComponent instanceof tdb_centroid && TempComponent.getName().equals(mo.getLabel())) {
                                Tempcentroid = (tdb_centroid)TempComponent;
                                if (TempComponent.isSelected()) {
                                    g.setColor(Tempcentroid.giscolor1);
                                    g.fillPolygon(poli);
                                    mirect = poli.getBounds();
                                    g.setColor(Color.blue);
                                    g.drawRect(mirect.x, mirect.y, mirect.width, mirect.height);
                                    g.setColor(Color.black);
                                    g.drawString(TempComponent.getName(), (int)((double)mirect.x + (double)mirect.width / 2.0), (int)((double)mirect.y + (double)mirect.height / 2.0));
                                }
                                g.setColor(Tempcentroid.giscolor2);
                                g.drawPolygon(poli);
                            }
                            ++j;
                        }
                    }
                }
                if (!mo.getObjType().equals("coastline")) continue;
                g.setColor(Color.black);
                g.fillPolygon(poli2);
                g.setColor(Color.lightGray);
                g.fillPolygon(poli);
                g.setColor(c);
                g.drawPolygon(poli);
            }
            i = 0;
            while (true) {
                Line TempLine;
                DeepEdit cfr_ignored_3 = this.canvas_.applet;
                if (i >= DeepEdit.MySchematic.Components.size()) break;
                DeepEdit cfr_ignored_4 = this.canvas_.applet;
                TempComponent = (comp)DeepEdit.MySchematic.Components.elementAt(i);
                if (TempComponent instanceof Line && (TempLine = (Line)TempComponent).getmo() != null && (this.canvas_.applet.GISDL & 0x10) != 0 && (c = this.getColor((mo = TempLine.getmo()).getObjType())) != null) {
                    g.setColor(c);
                    mp0 = this.transform_.getPoint(0, 0);
                    mp1 = this.transform_.getPoint(r.width, r.height);
                    if (mo.intersects(mp0, mp1) == 1) {
                        pItr = mo.getVector();
                        if ((this.canvas_.applet.GISDL & 1) != 0 || TempComponent.isSelected()) {
                            mp0 = (JMapPoint)pItr.elementAt(pItr.size() / 2);
                            p0 = this.transform_.getPoint(mp0.x, mp0.y);
                            g.drawString(TempComponent.getName(), p0.x, p0.y);
                        }
                        if (TempComponent.isSelected()) {
                            mo1 = new JMapObject("kreuz", "");
                            mp0 = (JMapPoint)pItr.elementAt(pItr.size() / 2);
                            p0 = this.transform_.getPoint(mp0.x, mp0.y);
                            im = this.getImage(mo1.getObjType());
                            g.drawImage(im, p0.x - im.getWidth(this.canvas_) / 2, p0.y - im.getHeight(this.canvas_) / 2, im.getWidth(this.canvas_), im.getHeight(this.canvas_), this.canvas_);
                        }
                        for (j = 0; j < pItr.size() - 1; ++j) {
                            mp0 = (JMapPoint)pItr.elementAt(j);
                            mp1 = (JMapPoint)pItr.elementAt(j + 1);
                            p0 = this.transform_.getPoint(mp0.x, mp0.y);
                            p1 = this.transform_.getPoint(mp1.x, mp1.y);
                            g.setColor(TempLine.getkv_color1());
                            g.drawLine(p0.x, p0.y, p1.x, p1.y);
                        }
                    }
                }
                ++i;
            }
            this.lock_ = 0;
        }
    }

    private Color getColor(String type) {
        Vector tags = this.dataRepository_.getVecTags();
        for (int i = 0; i < tags.size(); ++i) {
            String tag = ((JMapTag)tags.elementAt(i)).getObjType();
            if (!type.equals(tag)) continue;
            return ((JMapTag)tags.elementAt(i)).getColor();
        }
        return new Color(217, 118, 50);
    }

    private Image getImage(String type) {
        Vector tags = this.dataRepository_.getVecTags();
        for (int i = 0; i < tags.size(); ++i) {
            String tag = ((JMapTag)tags.elementAt(i)).getObjType();
            if (!type.equals(tag)) continue;
            if (this.fac <= 1.0) {
                return ((JMapTag)tags.elementAt(i)).getImage();
            }
            return ((JMapTag)tags.elementAt(i)).getImage1();
        }
        return null;
    }
}

