/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import de.core.DeepEdit;
import de.core.JMapContentHandler;
import de.core.JMapObject;
import de.core.JMapRectangle;
import de.core.JMapTagsContentHandler;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Vector;

class JMapDataRepository {
    private Vector vecFeatures_ = new Vector();
    private Vector vecIcons_ = new Vector();
    private Vector vecTags_ = new Vector();
    private JMapRectangle recInitialMap_;
    private URL urlDataSource_;
    private URL urlTagSource_;
    JMapContentHandler handler;
    JMapTagsContentHandler tagHandler;
    DeepEdit applet;

    public JMapDataRepository(String dataSource, String tagSource, DeepEdit aapplet) {
        this.applet = aapplet;
        this.getDataFromSource(dataSource, tagSource);
        this.recInitialMap_ = this.handler.getInitialMap();
    }

    public JMapDataRepository() {
    }

    public JMapRectangle getMapRectangle() {
        return new JMapRectangle(this.recInitialMap_);
    }

    public boolean getDataFromSource(String dataSource, String tagSource) {
        Object o;
        URLConnection urlConnect;
        this.tagHandler = new JMapTagsContentHandler(this.applet);
        try {
            this.urlTagSource_ = new URL(this.applet.getDocumentBase(), tagSource);
        }
        catch (MalformedURLException e) {
            System.out.println("Error: " + e);
        }
        try {
            urlConnect = this.urlTagSource_.openConnection();
            urlConnect.connect();
            o = this.tagHandler.getContent(urlConnect);
            if (o instanceof Vector) {
                this.vecTags_ = (Vector)o;
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        if (this.vecTags_.size() > 0) {
            this.handler = new JMapContentHandler(this.vecTags_);
            try {
                File f = new File(dataSource);
                this.urlDataSource_ = f.toURI().toURL();
            }
            catch (MalformedURLException e) {
                System.out.println("Error: " + e);
            }
            try {
                urlConnect = this.urlDataSource_.openConnection();
                urlConnect.connect();
                o = this.handler.getContent(urlConnect);
                if (o instanceof Vector) {
                    this.vecFeatures_ = (Vector)o;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return true;
    }

    public int getFeatureEntries() {
        return this.vecFeatures_.size();
    }

    public int getIconEntries() {
        return this.vecIcons_.size();
    }

    public int getTagEntries() {
        return this.vecTags_.size();
    }

    public JMapObject getFeatureAt(int i) {
        return (JMapObject)this.vecFeatures_.elementAt(i);
    }

    public JMapObject getIconAt(int i) {
        return (JMapObject)this.vecIcons_.elementAt(i);
    }

    public Vector getVecFeatures() {
        return this.vecFeatures_;
    }

    public Vector getVecIcon() {
        return this.vecIcons_;
    }

    public Vector getVecTags() {
        return this.vecTags_;
    }
}

