/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import de.core.JMapObject;
import de.core.JMapRectangle;
import de.core.JTokenParser;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.ContentHandler;
import java.net.URLConnection;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;

class JMapContentHandler
extends ContentHandler {
    String strBuffer_ = "";
    int iBufPos = 0;
    int iLength = 0;
    Vector vecMapObjects_;
    Vector vecTags_;
    private JMapRectangle recInitialMap_;

    JMapContentHandler(Vector tags) {
        this.vecTags_ = tags;
    }

    @Override
    public Object getContent(URLConnection urlc) {
        this.vecMapObjects_ = new Vector();
        try {
            InputStream is = urlc.getInputStream();
            DataInputStream ds = new DataInputStream(is);
            this.iLength = urlc.getContentLength();
            if (this.iLength != -1) {
                byte[] bBuffer = new byte[this.iLength];
                ds.readFully(bBuffer);
                this.strBuffer_ = new String(bBuffer, 0);
            } else {
                int i = is.read();
                while (i != -1) {
                    this.strBuffer_ = this.strBuffer_ + (char)i;
                    i = is.read();
                }
            }
            return this.parseDataBuffer();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    protected Object parseDataBuffer() {
        String lineToken = "";
        boolean isMatch = false;
        StringTokenizer st = new StringTokenizer(this.strBuffer_, "\t\n\r");
        block2: while (st.hasMoreTokens()) {
            String strToken = st.nextToken();
            if ((strToken.equalsIgnoreCase("INITIALMAP") || strToken.equalsIgnoreCase("INITIALMAP ")) && st.hasMoreTokens()) {
                this.parseINITALMAP(st);
            }
            isMatch = false;
            for (int j = 0; j < this.vecTags_.size(); ++j) {
                String tagName = this.vecTags_.elementAt(j).toString();
                if (strToken.startsWith(tagName)) {
                    isMatch = true;
                    StringTokenizer sts = new StringTokenizer(strToken, " \t\n\r");
                    String strObjType = sts.nextToken();
                    String strObjLabel = sts.hasMoreTokens() ? new String(sts.nextToken()) : new String("no label");
                    JMapObject mapObject = new JMapObject(strObjType, strObjLabel);
                    lineToken = new String(strObjType);
                    while (st.hasMoreTokens() && !lineToken.equals("end")) {
                        strToken = st.nextToken();
                        sts = new StringTokenizer(strToken, " \t\n\r");
                        lineToken = sts.nextToken();
                        if (lineToken.equals("latlon") || lineToken.equals("icon_location")) {
                            try {
                                Integer deglat = Integer.valueOf(sts.nextToken());
                                Integer minlat = Integer.valueOf(sts.nextToken());
                                Integer seclat = Integer.valueOf(sts.nextToken());
                                String charHeading = sts.nextToken();
                                Integer deglon = Integer.valueOf(sts.nextToken());
                                Integer minlon = Integer.valueOf(sts.nextToken());
                                Integer seclon = Integer.valueOf(sts.nextToken());
                                charHeading = sts.nextToken();
                                double lat = deglat.doubleValue() + minlat.doubleValue() / 60.0 + seclat.doubleValue() / 3600.0;
                                double lon = deglon.doubleValue() + minlon.doubleValue() / 60.0 + seclon.doubleValue() / 3600.0;
                                mapObject.insert(lon, lat);
                            }
                            catch (NoSuchElementException e) {
                                // empty catch block
                            }
                        }
                        if (!lineToken.equals("end")) continue;
                        this.vecMapObjects_.addElement(mapObject);
                        break;
                    }
                }
                if (isMatch) continue block2;
            }
        }
        isMatch = false;
        return this.vecMapObjects_;
    }

    protected int buildMapObject(int type, String label) {
        return 0;
    }

    protected void parseINITALMAP(StringTokenizer sts) {
        this.recInitialMap_ = new JMapRectangle(JTokenParser.parseDoubleVec(sts));
    }

    public JMapRectangle getInitialMap() {
        return this.recInitialMap_;
    }
}

