/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import de.core.DeepEdit;
import de.core.JMapObservable;
import de.core.JMapPoint;
import de.core.JMapTransformBase;
import de.core.ndb_1pol;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Event;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Vector;

class JMapCanvas
extends Canvas {
    public DeepEdit applet;
    private Point p1_;
    private Point p2_;
    private Point pCurrent_;
    private boolean isPressed_;
    private Image imgCanvas_ = null;
    private JMapTransformBase lastTransform_ = null;
    private JMapTransformBase prevTransform_ = null;
    private Vector vecTransform = new Vector();
    private Vector vecImages = new Vector();
    private JMapObservable obDraw_;
    private JMapObservable obConfigure_;
    private JMapObservable obMouseAreaSelection_;
    private JMapObservable obMouseButtonPressed_;
    private JMapObservable obMouseMove_;
    private JMapObservable obMouseDrag_;
    public FileOutputStream os;
    public PrintStream myPrintStream;

    public JMapObservable obDraw() {
        return this.obDraw_;
    }

    public JMapObservable obConfigure() {
        return this.obConfigure_;
    }

    public JMapObservable obMouseAreaSelection() {
        return this.obMouseAreaSelection_;
    }

    public JMapObservable obMouseButtonPressed() {
        return this.obMouseButtonPressed_;
    }

    public JMapObservable obMouseMove() {
        return this.obMouseMove_;
    }

    public JMapObservable obMouseDrag() {
        return this.obMouseDrag_;
    }

    public void pushTransform(JMapTransformBase mt) {
        this.vecTransform.addElement(mt);
    }

    public JMapTransformBase popTransform() {
        if (this.vecTransform.size() > 1) {
            this.vecTransform.removeElement(this.vecTransform.lastElement());
        }
        return (JMapTransformBase)this.vecTransform.lastElement();
    }

    public JMapTransformBase prevTransform() {
        if (this.vecTransform.size() > 1) {
            return (JMapTransformBase)this.vecTransform.elementAt(this.vecTransform.size() - 2);
        }
        return null;
    }

    public JMapTransformBase getTransform() {
        return (JMapTransformBase)this.vecTransform.lastElement();
    }

    JMapCanvas(DeepEdit aapplet) {
        this.applet = aapplet;
        try {
            this.os = new FileOutputStream("./maps/maps.tmp");
            this.myPrintStream = new PrintStream(this.os);
        }
        catch (Exception e) {
            System.out.println("in SaveFileName maps.tmp: " + e);
        }
        this.p1_ = new Point(0, 0);
        this.p2_ = new Point(0, 0);
        this.pCurrent_ = new Point(0, 0);
        this.obDraw_ = new JMapObservable();
        this.obConfigure_ = new JMapObservable();
        this.obMouseAreaSelection_ = new JMapObservable();
        this.obMouseButtonPressed_ = new JMapObservable();
        this.obMouseMove_ = new JMapObservable();
        this.obMouseDrag_ = new JMapObservable();
    }

    public void drawAreaSelection() {
        Graphics g = this.getGraphics();
        g.setXORMode(Color.white);
        g.setColor(Color.black);
        Point p0_ = this.pCurrent_;
        if (this.p1_.x == p0_.x && this.p1_.y == p0_.y) {
            return;
        }
        if (this.p1_.x == p0_.x || this.p1_.y == p0_.y) {
            g.drawLine(this.p1_.x, this.p1_.y, p0_.x, p0_.y);
        } else if (this.p1_.x < p0_.x) {
            if (this.p1_.y < p0_.y) {
                g.drawRect(this.p1_.x, this.p1_.y, p0_.x - this.p1_.x, p0_.y - this.p1_.y);
            } else {
                g.drawRect(this.p1_.x, p0_.y, p0_.x - this.p1_.x, this.p1_.y - p0_.y);
            }
        } else if (this.p1_.y > p0_.y) {
            g.drawRect(p0_.x, p0_.y, this.p1_.x - p0_.x, this.p1_.y - p0_.y);
        } else {
            g.drawRect(p0_.x, this.p1_.y, this.p1_.x - p0_.x, p0_.y - this.p1_.y);
        }
    }

    void JMapCanvas_MouseDrag(Event event) {
        this.drawAreaSelection();
        this.pCurrent_.x = event.x;
        this.pCurrent_.y = event.y;
        this.drawAreaSelection();
        this.isPressed_ = true;
        this.obMouseDrag_.notifyObservers(this.pCurrent_);
    }

    void JMapCanvas_MouseMove(Event event) {
        this.pCurrent_.x = event.x;
        this.pCurrent_.y = event.y;
        this.isPressed_ = false;
        this.obMouseMove_.notifyObservers(this.pCurrent_);
    }

    void JMapCanvas_MouseUp(Event event) {
        int minZoomSize = 10;
        this.p2_.x = event.x;
        this.p2_.y = event.y;
        if (this.isPressed_) {
            Graphics g = this.getGraphics();
            g.setPaintMode();
            if (this.p2_.x == this.p1_.x && this.p2_.y == this.p1_.y) {
                this.obMouseButtonPressed_.notifyObservers(this.pCurrent_);
            } else if (this.p1_.x + minZoomSize < this.p2_.x) {
                if (this.p1_.y + minZoomSize < this.p2_.y) {
                    this.obMouseAreaSelection_.notifyObservers(new Rectangle(this.p1_.x, this.p1_.y, this.p2_.x - this.p1_.x, this.p2_.y - this.p1_.y));
                } else if (this.p1_.y > this.p2_.y + minZoomSize) {
                    this.obMouseAreaSelection_.notifyObservers(new Rectangle(this.p1_.x, this.p2_.y, this.p2_.x - this.p1_.x, this.p1_.y - this.p2_.y));
                }
            } else if (this.p1_.x > this.p2_.x + minZoomSize) {
                if (this.p1_.y > this.p2_.y + minZoomSize) {
                    this.obMouseAreaSelection_.notifyObservers(new Rectangle(this.p2_.x, this.p2_.y, this.p1_.x - this.p2_.x, this.p1_.y - this.p2_.y));
                } else if (this.p1_.y + minZoomSize < this.p2_.y) {
                    this.obMouseAreaSelection_.notifyObservers(new Rectangle(this.p2_.x, this.p1_.y, this.p1_.x - this.p2_.x, this.p2_.y - this.p1_.y));
                }
            } else {
                this.drawAreaSelection();
            }
        }
        this.isPressed_ = false;
    }

    void JMapCanvas_KeyPress(Event event) {
        String auxs = "";
        JMapPoint mp = this.getTransform().getPoint(this.pCurrent_);
        if (403 == 1025) {
            auxs = "  ";
        }
        if (event.key == 10) {
            Vector tmpComps = DeepEdit.MySchematicPanel.SelectSchematic.getcomponents();
            if (tmpComps != null && tmpComps.size() == 1 && tmpComps.elementAt(0) instanceof ndb_1pol) {
                ((ndb_1pol)tmpComps.elementAt(0)).setlatitude((float)mp.y);
                ((ndb_1pol)tmpComps.elementAt(0)).setlongitude((float)mp.x);
                DeepEdit.MySchematic.changeGIS = true;
                this.applet.MyGIS.canvasMap.repaint();
            }
        } else {
            double aux2;
            double aux1;
            if (mp.y >= 0.0) {
                aux1 = mp.y;
                aux2 = Math.floor(aux1);
                auxs = "latlon " + (int)aux2 + " ";
                aux1 = (aux1 - aux2) * 60.0;
                aux2 = Math.floor(aux1);
                auxs = auxs + (int)aux2 + " ";
                aux1 = (aux1 - aux2) * 60.0;
                aux2 = Math.floor(aux1);
                auxs = auxs + (int)aux2 + " N ";
            } else {
                aux1 = Math.abs(mp.y);
                aux2 = Math.floor(aux1);
                auxs = "latlon " + (int)(-aux2) + " ";
                aux1 = (aux1 - aux2) * 60.0;
                aux2 = Math.floor(aux1);
                auxs = auxs + (int)(-aux2) + " ";
                aux1 = (aux1 - aux2) * 60.0;
                aux2 = Math.floor(aux1);
                auxs = auxs + (int)(-aux2) + " S ";
            }
            if (mp.x >= 0.0) {
                aux1 = mp.x;
                aux2 = Math.floor(aux1);
                aux1 = (aux1 - aux2) * 60.0;
                auxs = auxs + (int)aux2 + " ";
                aux2 = Math.floor(aux1);
                aux1 = (aux1 - aux2) * 60.0;
                auxs = auxs + (int)aux2 + " ";
                aux2 = Math.floor(aux1);
                auxs = auxs + (int)aux2 + " W ";
            } else {
                aux1 = Math.abs(mp.x);
                aux2 = Math.floor(aux1);
                aux1 = (aux1 - aux2) * 60.0;
                auxs = auxs + (int)(-aux2) + " ";
                aux2 = Math.floor(aux1);
                aux1 = (aux1 - aux2) * 60.0;
                auxs = auxs + (int)(-aux2) + " ";
                aux2 = Math.floor(aux1);
                auxs = auxs + (int)(-aux2) + " E ";
            }
        }
        this.myPrintStream.println(auxs);
    }

    void JMapCanvas_MouseDown(Event event) {
        this.p1_.x = event.x;
        this.p1_.y = event.y;
        this.pCurrent_.x = this.p1_.x;
        this.pCurrent_.y = this.p1_.y;
        this.p2_.x = this.p1_.x;
        this.p2_.y = this.p1_.y;
        this.isPressed_ = true;
    }

    @Override
    public void paint(Graphics g) {
        if (DeepEdit.MySchematic.changeGIS || this.getTransform() != this.lastTransform_ || this.imgCanvas_ == null) {
            DeepEdit.MySchematic.changeGIS = false;
            this.lastTransform_ = this.getTransform();
            this.imgCanvas_ = this.createImage(this.size().width, this.size().height);
            this.vecImages.addElement(this.imgCanvas_);
            Graphics ig = this.imgCanvas_.getGraphics();
            ig.setPaintMode();
            this.obConfigure_.notifyObservers(this.getTransform());
            this.obDraw_.notifyObservers(ig);
            ig.setColor(new Color(0, 0, 0));
            ig.drawRect(0, 0, this.imgCanvas_.getWidth(this) - 1, this.imgCanvas_.getHeight(this) - 1);
        }
        this.prevTransform_ = this.prevTransform();
        g.drawImage(this.imgCanvas_, 0, 0, this);
    }

    @Override
    public boolean handleEvent(Event event) {
        if (event.target == this && event.id == 401) {
            this.JMapCanvas_KeyPress(event);
            return true;
        }
        if (event.target == this && event.id == 502) {
            this.JMapCanvas_MouseUp(event);
            return true;
        }
        if (event.target == this && event.id == 501) {
            this.JMapCanvas_MouseDown(event);
            return true;
        }
        if (event.target == this && event.id == 503) {
            this.JMapCanvas_MouseMove(event);
            return true;
        }
        if (event.target == this && event.id == 506) {
            this.JMapCanvas_MouseDrag(event);
            return true;
        }
        return super.handleEvent(event);
    }
}

