/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import java.awt.Graphics;

class ImageButton {
    protected int Xpos;
    protected boolean selected;
    protected boolean pressed;
    protected boolean enabled;
    protected String Name;

    public ImageButton(String name, int x) {
        this.Xpos = x;
        this.selected = false;
        this.pressed = false;
        this.enabled = false;
        this.Name = name;
    }

    public String getName() {
        return this.Name;
    }

    public boolean CheckIfPressed(int x, int y) {
        if (y < 0 || y > 24) {
            return false;
        }
        if ((x -= this.Xpos) < 0 || x > 24) {
            return false;
        }
        if (this.enabled) {
            this.pressed = true;
            return true;
        }
        return false;
    }

    public void Draw(Graphics g) {
        int Yoffset = !this.enabled ? 24 : (this.pressed ? 72 : (this.selected ? 96 : 48));
        g.copyArea(this.Xpos, Yoffset, 24, 24, 0, -Yoffset);
    }

    public void Select() {
        if (this.enabled) {
            this.pressed = false;
            this.selected = true;
        }
    }

    public void Unselect() {
        this.pressed = false;
        this.selected = false;
    }

    public void Enable() {
        this.pressed = false;
        this.enabled = true;
    }

    public void Disable() {
        this.pressed = false;
        this.enabled = false;
    }
}

