/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import de.core.DeepEdit;
import de.core.Hyperactive;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;

public class HtmlHelp
extends JFrame {
    protected String newline = "\n";

    public HtmlHelp(DeepEdit app) {
        super("DeepEdit Html Help System");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                HtmlHelp.this.dispose();
            }
        });
        JToolBar toolBar = new JToolBar();
        this.addButtons(toolBar);
        JEditorPane editorPane = new JEditorPane();
        editorPane.setEditable(false);
        editorPane.addHyperlinkListener(new Hyperactive());
        String s = null;
        try {
            s = "html/index.html";
            URL helpURL = new URL(app.getCodeBase(), s);
            editorPane.setPage(helpURL);
        }
        catch (Exception e) {
            System.err.println("Couldn't create help URL: " + s);
        }
        JScrollPane editorScrollPane = new JScrollPane(editorPane);
        editorScrollPane.setVerticalScrollBarPolicy(22);
        editorScrollPane.setPreferredSize(new Dimension(400, 500));
        editorScrollPane.setMinimumSize(new Dimension(10, 10));
        JPanel contentPane = new JPanel();
        contentPane.setLayout(new BorderLayout());
        contentPane.setPreferredSize(new Dimension(400, 550));
        contentPane.add((Component)toolBar, "North");
        contentPane.add((Component)editorScrollPane, "Center");
        this.setContentPane(contentPane);
        this.setIconImage(app.getFrameIconImage());
    }

    protected void addButtons(JToolBar toolBar) {
        JButton button = null;
        button = new JButton(new ImageIcon(this.getClass().getResource("/images/left.gif")));
        button.setToolTipText("This is the left button");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HtmlHelp.this.displayResult("Action for first button");
            }
        });
        toolBar.add(button);
        button = new JButton(new ImageIcon(this.getClass().getResource("/images/middle.gif")));
        button.setToolTipText("This is the middle button");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HtmlHelp.this.displayResult("Action for second button");
                HtmlHelp.this.dispose();
            }
        });
        toolBar.add(button);
        button = new JButton(new ImageIcon(this.getClass().getResource("/images/right.gif")));
        button.setToolTipText("This is the right button");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HtmlHelp.this.displayResult("Action for third button");
            }
        });
        toolBar.add(button);
    }

    protected void displayResult(String actionDescription) {
    }
}

