/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import de.core.DeepEdit;
import de.core.HTGLED;
import de.core.SwingWorker;
import java.awt.CheckboxGroup;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.InputVerifier;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;

class HTGLEDFrame
extends JDialog
implements KeyListener,
ActionListener {
    private HTGLED Myequiv;
    private String ctrla;
    private JComboBox chSolver;
    private JComboBox chMaxIter;
    private JComboBox chMaxRHSTol;
    private JComboBox chMaxCostTol;
    private JRadioButton chbCuadLoss;
    private JRadioButton chbCoseLoss;
    private CheckboxGroup chbgLossMod;
    private JFormattedTextField tfduration;
    private JCheckBox lin;
    private JButton buttonCalc;
    private JButton buttonCancel;
    private SwingWorker worker;
    private Vector dialogJComps2disable;
    protected Font TextDialogFont;
    protected FontMetrics TextDialogFontMetrics;

    HTGLEDFrame(HTGLED ms) {
        DeepEdit cfr_ignored_0 = ms.applet;
        super(DeepEdit.frame, "HTGLED Calculation Options", true);
        this.chSolver = null;
        this.chMaxIter = null;
        this.chMaxRHSTol = null;
        this.chMaxCostTol = null;
        this.chbCuadLoss = null;
        this.chbCoseLoss = null;
        this.chbgLossMod = null;
        this.tfduration = null;
        this.worker = null;
        this.dialogJComps2disable = null;
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            // empty catch block
        }
        this.Myequiv = ms;
        this.TextDialogFont = DeepEdit.TextFont;
        JPanel opModelPanel = new JPanel();
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c1 = new GridBagConstraints();
        GridBagConstraints c2 = new GridBagConstraints();
        this.dialogJComps2disable = new Vector(20);
        c1.gridheight = 1;
        c1.gridwidth = 1;
        c1.anchor = 17;
        c2.gridheight = 1;
        c2.gridwidth = 0;
        c2.fill = 2;
        c2.insets = new Insets(1, 1, 1, 1);
        opModelPanel.setLayout(gridbag);
        JLabel auxLab = new JLabel(" Period Duration ", 2);
        this.dialogJComps2disable.add(auxLab);
        auxLab.setFont(this.TextDialogFont);
        opModelPanel.add((Component)auxLab, c1);
        this.tfduration = new JFormattedTextField();
        this.tfduration.setColumns(5);
        this.tfduration.setValue(new Integer(744));
        this.tfduration.setHorizontalAlignment(4);
        this.tfduration.setInputVerifier(new InputVerifier(){

            @Override
            public boolean verify(JComponent input) {
                JFormattedTextField tf = (JFormattedTextField)input;
                int val = 0;
                try {
                    val = Integer.parseInt(tf.getText());
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
                if (val > 0 && val < 8761) {
                    return true;
                }
                tf.setText(tf.getValue().toString());
                return false;
            }
        });
        this.dialogJComps2disable.add(this.tfduration);
        this.tfduration.setFont(this.TextDialogFont);
        opModelPanel.add((Component)this.tfduration, c1);
        auxLab = new JLabel(" [hours] ", 2);
        this.dialogJComps2disable.add(auxLab);
        auxLab.setFont(this.TextDialogFont);
        opModelPanel.add((Component)auxLab, c2);
        auxLab = new JLabel(" Losses Model ", 2);
        this.dialogJComps2disable.add(auxLab);
        auxLab.setFont(this.TextDialogFont);
        gridbag.setConstraints(auxLab, c1);
        opModelPanel.add(auxLab);
        ButtonGroup chbgLossMod = new ButtonGroup();
        this.chbCuadLoss = new JRadioButton("R\u2219I\u00b2", true);
        this.dialogJComps2disable.add(this.chbCuadLoss);
        this.chbCuadLoss.setFont(this.TextDialogFont);
        opModelPanel.add((Component)this.chbCuadLoss, c1);
        chbgLossMod.add(this.chbCuadLoss);
        this.chbCoseLoss = new JRadioButton("2G\u2219Cos(\u2206\u03b4)", false);
        this.dialogJComps2disable.add(this.chbCoseLoss);
        this.chbCoseLoss.setFont(this.TextDialogFont);
        opModelPanel.add((Component)this.chbCoseLoss, c2);
        chbgLossMod.add(this.chbCoseLoss);
        auxLab = new JLabel(" Aditional Constraints    ", 2);
        this.dialogJComps2disable.add(auxLab);
        auxLab.setFont(this.TextDialogFont);
        opModelPanel.add((Component)auxLab, c1);
        this.lin = new JCheckBox(" Line Limits", true);
        this.dialogJComps2disable.add(this.lin);
        this.lin.setFont(this.TextDialogFont);
        gridbag.setConstraints(this.lin, c2);
        opModelPanel.add(this.lin);
        TitledBorder inB = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "MODEL'S PARAMETERS", 2, 2, this.TextDialogFont, Color.blue);
        opModelPanel.setBorder(inB);
        this.getContentPane().add((Component)opModelPanel, "North");
        JPanel opSolverPanel = new JPanel(){
            Insets inSet = new Insets(20, 0, 15, 0);

            @Override
            public Insets getInsets() {
                return this.inSet;
            }
        };
        gridbag = new GridBagLayout();
        opSolverPanel.setLayout(gridbag);
        auxLab = new JLabel(" Subproblems Solver    ", 2);
        this.dialogJComps2disable.add(auxLab);
        auxLab.setFont(this.TextDialogFont);
        gridbag.setConstraints(auxLab, c1);
        opSolverPanel.add(auxLab);
        this.chSolver = new JComboBox();
        this.dialogJComps2disable.add(this.chSolver);
        this.chSolver.addItem(HTGLED.solverOptions[0] + "                ");
        this.chSolver.addItem(HTGLED.solverOptions[1]);
        this.chSolver.setFont(this.TextDialogFont);
        this.chSolver.setSelectedIndex(0);
        opSolverPanel.add((Component)this.chSolver, c2);
        auxLab = new JLabel(" Maximum Iterations", 2);
        this.dialogJComps2disable.add(auxLab);
        auxLab.setFont(this.TextDialogFont);
        gridbag.setConstraints(auxLab, c1);
        opSolverPanel.add(auxLab);
        this.chMaxIter = new JComboBox<String>(HTGLED.maxIterOptions);
        this.dialogJComps2disable.add(this.chMaxIter);
        this.chMaxIter.setFont(this.TextDialogFont);
        this.chMaxIter.setSelectedIndex(0);
        opSolverPanel.add((Component)this.chMaxIter, c2);
        auxLab = new JLabel(" RHS Tolerance [%]", 2);
        this.dialogJComps2disable.add(auxLab);
        auxLab.setFont(this.TextDialogFont);
        gridbag.setConstraints(auxLab, c1);
        opSolverPanel.add(auxLab);
        this.chMaxRHSTol = new JComboBox<String>(HTGLED.maxRHSTolOptions);
        this.dialogJComps2disable.add(this.chMaxRHSTol);
        this.chMaxRHSTol.setFont(this.TextDialogFont);
        this.chMaxRHSTol.setSelectedIndex(2);
        opSolverPanel.add((Component)this.chMaxRHSTol, c2);
        auxLab = new JLabel(" Cost Tolerance [%]", 2);
        this.dialogJComps2disable.add(auxLab);
        auxLab.setFont(this.TextDialogFont);
        gridbag.setConstraints(auxLab, c1);
        opSolverPanel.add(auxLab);
        this.chMaxCostTol = new JComboBox<String>(HTGLED.maxCostTolOptions);
        this.dialogJComps2disable.add(this.chMaxCostTol);
        this.chMaxCostTol.setFont(this.TextDialogFont);
        this.chMaxCostTol.setSelectedIndex(4);
        opSolverPanel.add((Component)this.chMaxCostTol, c2);
        inB = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "SOLVER PARAMETERS", 2, 2, this.TextDialogFont, Color.blue);
        opSolverPanel.setBorder(inB);
        this.getContentPane().add((Component)opSolverPanel, "Center");
        JPanel controlP = new JPanel();
        controlP.setLayout(new FlowLayout());
        this.buttonCalc = new JButton("Calculate");
        this.dialogJComps2disable.add(this.buttonCalc);
        this.buttonCalc.setFont(this.TextDialogFont);
        controlP.add(this.buttonCalc);
        this.buttonCalc.addActionListener(this);
        this.buttonCancel = new JButton("Cancel");
        this.buttonCancel.setFont(this.TextDialogFont);
        controlP.add(this.buttonCancel);
        this.buttonCancel.addActionListener(this);
        this.getContentPane().add((Component)controlP, "South");
        ((JPanel)this.getContentPane()).setBorder(BorderFactory.createEmptyBorder(4, 2, 4, 2));
        this.buttonCancel.addKeyListener(this);
        DeepEdit cfr_ignored_1 = ms.applet;
        this.setLocationRelativeTo(DeepEdit.frame);
        this.setLocation(200, 50);
        this.setResizable(false);
        this.pack();
        this.setVisible(true);
    }

    @Override
    public void keyPressed(KeyEvent event) {
        if (event.getKeyCode() == 27) {
            this.setVisible(false);
            this.dispose();
            this.Myequiv.MyHTGLEDFrame = null;
        }
    }

    @Override
    public void keyReleased(KeyEvent event) {
    }

    @Override
    public void keyTyped(KeyEvent event) {
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        Object obj = ev.getSource();
        String label = ev.getActionCommand();
        if (obj == this.buttonCalc) {
            try {
                this.disableComponents();
                this.setDefaultCloseOperation(0);
                this.runSolver();
            }
            catch (Exception e) {
                this.setVisible(false);
                JOptionPane.showMessageDialog(DeepEdit.frame, e.toString(), "HTGLD Error", 0);
                this.finishProcess(false);
            }
        }
        if (obj == this.buttonCancel) {
            try {
                if (this.worker != null) {
                    this.worker.interrupt();
                }
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(DeepEdit.frame, e.toString(), "HTGLD Error", 0);
                e.printStackTrace();
            }
            this.finishProcess(false);
        }
    }

    private void disableComponents() {
        for (int i = 0; i < this.dialogJComps2disable.size(); ++i) {
            ((JComponent)this.dialogJComps2disable.elementAt(i)).setEnabled(false);
        }
    }

    private void runSolver() {
        this.Myequiv.setModelParam(((Integer)this.tfduration.getValue()).intValue(), this.lin.isSelected(), this.chbCuadLoss.isSelected());
        this.Myequiv.setSolverParam(this.chSolver.getSelectedIndex(), this.chMaxIter.getSelectedIndex(), this.chMaxRHSTol.getSelectedIndex(), this.chMaxCostTol.getSelectedIndex());
        this.worker = new SwingWorker(){

            @Override
            public Object construct() {
                HTGLEDFrame.this.Myequiv.Calculate(true, 1);
                return new Object();
            }

            @Override
            public void finished() {
                HTGLEDFrame.this.finishProcess(true);
            }
        };
        this.worker.start();
    }

    private void finishProcess(boolean allOK) {
        this.dispose();
        this.Myequiv.MyHTGLEDFrame = null;
        if (allOK) {
            this.Myequiv.showResults();
        }
        Runtime.getRuntime().gc();
    }
}

