/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import VisualNumerics.math.Complex;
import de.core.AnalysisTool;
import de.core.Busbar;
import de.core.DeepEdit;
import de.core.Generator;
import de.core.HTGLEDException;
import de.core.HTGLEDFrame;
import de.core.Injection;
import de.core.Line;
import de.core.Load;
import de.core.PLPFrame;
import de.core.Schematic;
import de.core.SimpleDialog;
import de.core.Trafo;
import de.core.comp;
import de.core.hdb_affl;
import de.core.hdb_comp;
import de.core.hdb_irr;
import de.core.hdb_link;
import de.core.hdb_paspur;
import de.core.hdb_res;
import de.core.hdb_ser;
import de.core.hdb_unit;
import de.core.ndb_1pol;
import de.core.ndb_inj;
import de.core.seeds.SEEDS_BendCut;
import de.core.seeds.SEEDS_Exception;
import ilog.concert.IloException;
import ilog.concert.IloLinearNumExpr;
import ilog.concert.IloNumExpr;
import ilog.concert.IloNumVar;
import ilog.concert.IloRange;
import ilog.cplex.IloCplex;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Vector;

public class HTGLED
extends AnalysisTool {
    HTGLEDFrame MyHTGLEDFrame = null;
    double[][] MatG;
    double[][] MatX;
    int numbran = 0;
    int numnod = 0;
    int numgen = 0;
    int numtrafo = 0;
    int numload = 0;
    int numvarEl = 0;
    int numresEl = 0;
    int numvarHy = 0;
    int numresHy = 0;
    int numvar = 0;
    int numres = 0;
    double[] BranchR;
    double[] BranchX;
    double[] BranchB;
    int[] BranchI;
    int[] BranchJ;
    int[] VarNode;
    boolean overiter = false;
    double mean_c = 1000000.0;
    double[] vec_xminabs;
    double[] vec_xmaxabs;
    double[] vec_xmin;
    double[] vec_xmax;
    double[] vec_xtemp;
    double[] vec_xtempabs;
    double[] vec_c;
    double[] vec_RHS;
    double[] vec_Grad;
    double[] vec_lam;
    double[] DiagMat_Q;
    double[] nod_Pdem;
    int[] vec_clave;
    double totcost = 0.0;
    double totgen = 0.0;
    double totunser = 0.0;
    double totloss = 0.0;
    double totdem = 0.0;
    double totincome = 0.0;
    double totsales = 0.0;
    int iteraciones;
    double tolerancia;
    double tolcost;
    double tolfeas;
    int metodo = 1;
    double[][] mat_W;
    double[][] mat_A;
    double[][] mat_Avar;
    DeepEdit applet;
    boolean islinres = true;
    boolean cuadLossModel = false;
    static final String[] solverOptions = new String[]{"Minos", "Cplex", "Cplex7"};
    static final String[] maxIterOptions = new String[]{"5", "10", "15", "20", "30", "40", "50"};
    static final String[] maxRHSTolOptions = new String[]{"0.0001", "0.001", "0.01", "0.1", "1", "5", "10"};
    static final String[] maxCostTolOptions = new String[]{"0.0001", "0.001", "0.01", "0.1", "0.5", "1", "5", "10"};
    private Injection[] injGen;
    private Line[] lines;
    private Trafo[] trafos;
    private Busbar[] busbars;
    private Load[] loads;
    private ndb_inj[] geners;
    private double dTb = 744.0;
    private double hydroFailCost = 600.0;
    private Vector vBC;
    private Generator[] thermalGen;
    private Generator[] resEleGen;
    private Generator[] serEleGen;
    private Generator[] ppEleGen;
    private hdb_res[] resHydUnit;
    private hdb_ser[] serHydUnit;
    private hdb_paspur[] ppHydUnit;
    private hdb_irr[] irrHydUnit;
    private hdb_affl[][] ppaff;
    private hdb_affl[][] seraff;
    private hdb_affl[][] resaff;
    private hdb_affl[][] irraff;
    private double[][] HCx;
    private double[] mDrE;
    private double[] mDrS;
    private double[] mDbvE;
    private double[] mDfE;
    private double[][] MFCP;
    private double[] bFCP;
    private PrintStream myPPrintStream;
    private FileOutputStream myOS;
    private boolean writeSolFile = true;
    private String outResPath = "./results/HTGLEDres.csv";
    private double eliminatorF = 1.0;
    private double eliminatorA = 0.0;
    protected static double fEscBC = 1000000.0;
    private static double infTx = 1000000.0;
    private double sref = 100.0;

    public HTGLED(Schematic sch) {
        super(sch);
        System.out.println("---------- In HTGLED Calculation Tool ------------");
        this.sref = this.getSref();
        if (this.MyHTGLEDFrame == null) {
            this.MyHTGLEDFrame = new HTGLEDFrame(this);
        } else {
            this.MyHTGLEDFrame.setVisible(true);
        }
    }

    public void Calculate(boolean sino, int modelo) {
        boolean konv = false;
        double cost1 = 0.0;
        double cost2 = 0.0;
        double cost3 = 0.0;
        double tol = 0.0;
        FileOutputStream os = null;
        FileInputStream is1 = null;
        int iteration = 0;
        int i = 0;
        int j = 0;
        String HTGHLDdat = "./results/HTGLED.dat";
        long initime = System.currentTimeMillis();
        long currtime = 0L;
        try {
            this.myOS = new FileOutputStream(HTGHLDdat);
            this.myPPrintStream = new PrintStream(this.myOS);
            this.initNetwork();
            this.startPoint();
            this.make_vec_c();
            this.make_DiagMat_Q();
            this.make_mat_Afix();
            this.make_vec_clave();
            cost1 = cost2 = this.make_cost();
            this.make_vec_RHS();
            while (!konv && iteration < this.iteraciones) {
                System.out.println("HTGLED-iteration... " + ++iteration);
                this.make_vec_Grad();
                System.out.println(" Assembling A ");
                this.makeAdd_mat_Avar();
                System.out.println(" Assembling W ");
                this.make_mat_W();
                this.update_vec_xlimits();
                System.out.println(" Updating Xlim ");
                this.myPPrintStream.println("*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-");
                this.myPPrintStream.println("                   ITERATION: " + iteration);
                this.myPPrintStream.println("*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-");
                this.myPPrintStream.println(" ");
                System.out.println(" Starting Solver Comunication.");
                if (this.metodo == 1) {
                    SimpleDialog ExceptionDialog;
                    String message;
                    PrintStream myPrintStream;
                    BufferedOutputStream bos;
                    try {
                        SEEDS_BendCut tempBC;
                        initime = System.currentTimeMillis();
                        os = new FileOutputStream("./economic.dat");
                        bos = new BufferedOutputStream(os, 32768);
                        myPrintStream = new PrintStream(bos, false);
                        System.out.println("Writing economic.dat");
                        myPrintStream.println(this.numvar);
                        myPrintStream.println(" ");
                        myPrintStream.println(this.numres + this.vBC.size());
                        myPrintStream.println(" ");
                        for (i = 0; i < this.numvar; ++i) {
                            myPrintStream.println(this.vec_Grad[i] / fEscBC);
                        }
                        myPrintStream.println(" ");
                        for (i = 0; i < this.numres; ++i) {
                            myPrintStream.println(this.vec_RHS[i]);
                        }
                        for (i = 0; i < this.vBC.size(); ++i) {
                            tempBC = (SEEDS_BendCut)this.vBC.elementAt(i);
                            myPrintStream.println("" + tempBC.f0 / fEscBC);
                        }
                        myPrintStream.println(" ");
                        for (i = 0; i < this.numres; ++i) {
                            for (j = 0; j < this.numvar; ++j) {
                                myPrintStream.println(this.mat_A[i][j]);
                            }
                            myPrintStream.println(" ");
                        }
                        int offVar = this.numvarEl + this.numvarHy - this.resHydUnit.length;
                        for (i = 0; i < this.vBC.size(); ++i) {
                            tempBC = (SEEDS_BendCut)this.vBC.elementAt(i);
                            for (j = 0; j < offVar; ++j) {
                                myPrintStream.println("0.0");
                            }
                            for (j = 0; j < this.resHydUnit.length; ++j) {
                                myPrintStream.println("" + tempBC.mi[j] / fEscBC);
                            }
                            myPrintStream.println("1.0");
                            myPrintStream.println(" ");
                        }
                        myPrintStream.println(" ");
                        for (i = 0; i < this.numres; ++i) {
                            myPrintStream.println(this.vec_clave[i]);
                        }
                        for (i = 0; i < this.vBC.size(); ++i) {
                            myPrintStream.println("1");
                        }
                        myPrintStream.println(" ");
                        for (i = 0; i < this.numvar; ++i) {
                            myPrintStream.println(this.vec_xmin[i]);
                        }
                        myPrintStream.println(" ");
                        for (i = 0; i < this.numvar; ++i) {
                            myPrintStream.println(this.vec_xmax[i]);
                        }
                        myPrintStream.println(" ");
                        myPrintStream.println("min");
                        myPrintStream.println("Ergebnisse aus SQP");
                        myPrintStream.close();
                    }
                    catch (Exception e) {
                        message = e.toString();
                        e.printStackTrace();
                        String[] DlgButtons = new String[]{"OK"};
                        ExceptionDialog = new SimpleDialog(DeepEdit.frame, "SQPB-economic.dat", message + " C1", DlgButtons, 1, 0, 0, 1);
                        return;
                    }
                    try {
                        os = new FileOutputStream("./matw.dat");
                        bos = new BufferedOutputStream(os, 32768);
                        myPrintStream = new PrintStream(bos, false);
                        myPrintStream.println(this.numvar);
                        myPrintStream.println(" ");
                        for (i = 0; i < this.numvar; ++i) {
                            for (j = 0; j < this.numvar; ++j) {
                                if (i < this.numvarEl && j < this.numvarEl) {
                                    myPrintStream.println(this.mat_W[i][j] / fEscBC);
                                    continue;
                                }
                                myPrintStream.println(0.0);
                            }
                            myPrintStream.println(" ");
                        }
                        myPrintStream.println(" ");
                        myPrintStream.close();
                    }
                    catch (Exception e) {
                        message = e.toString();
                        e.printStackTrace();
                        String[] DlgButtons = new String[]{"OK"};
                        ExceptionDialog = new SimpleDialog(DeepEdit.frame, "SQPB-Matw", message + " C2", DlgButtons, 1, 0, 0, 1);
                        return;
                    }
                    System.out.println("Call Solver");
                    try {
                        HTGLED.Dorun(DeepEdit.PathDOS + "cuadra.bat", DeepEdit.PathUNIX + "cuadra.bat");
                    }
                    catch (Exception e) {
                        message = e.toString();
                        String[] DlgButtons = new String[]{"OK"};
                        ExceptionDialog = new SimpleDialog(DeepEdit.frame, "Call Cuadra", message + " C3", DlgButtons, 1, 0, 0, 1);
                        return;
                    }
                    System.out.println("End Solver");
                    try {
                        is1 = new FileInputStream("./soluci.dat");
                        BufferedReader is = new BufferedReader(new InputStreamReader(is1));
                        String ln = is.readLine();
                        if (ln == null) {
                            throw new SEEDS_Exception("No MINOS Solution Found on soluci.dat");
                        }
                        j = this.numvar + this.numres;
                        for (i = 0; (ln = is.readLine()) != null && i < j; ++i) {
                            if (i < this.numvar) {
                                this.vec_xtemp[i] = Double.valueOf(ln);
                                continue;
                            }
                            this.vec_lam[i - this.numvar] = Double.valueOf(ln) * fEscBC;
                        }
                        is.close();
                        is = null;
                    }
                    catch (Exception e) {
                        message = e.toString();
                        e.printStackTrace();
                        String[] DlgButtons = new String[]{"OK"};
                        ExceptionDialog = new SimpleDialog(DeepEdit.frame, "SQPB, reading soluci.dat", message + " C4", DlgButtons, 1, 0, 0, 1);
                    }
                    currtime = System.currentTimeMillis() - initime + currtime;
                } else if (this.metodo == 2 || this.metodo == 3) {
                    initime = System.currentTimeMillis();
                    try {
                        double[] coef;
                        IloCplex cplex;
                        IloCplex qp = cplex = new IloCplex();
                        IloNumVar[] var = qp.numVarArray(this.numvar, this.vec_xmin, this.vec_xmax);
                        IloLinearNumExpr lin = cplex.scalProd(this.vec_Grad, var);
                        IloNumExpr aux3 = cplex.sum(0.0, (IloNumExpr)var[0]);
                        for (j = 0; j < this.numvarEl; ++j) {
                            for (i = 0; i < this.numvarEl; ++i) {
                                IloNumExpr aux2;
                                if (this.mat_W[i][j] == 0.0) continue;
                                if (i == j) {
                                    aux2 = cplex.prod(this.mat_W[i][j] / 2.0, cplex.square(var[i]));
                                    aux3 = cplex.sum(aux3, aux2);
                                    continue;
                                }
                                IloNumExpr aux1 = cplex.prod(this.mat_W[i][j] / 2.0, (IloNumExpr)var[j]);
                                aux2 = cplex.prod(aux1, (IloNumExpr)var[i]);
                                aux3 = cplex.sum(aux3, aux2);
                            }
                        }
                        IloNumExpr obj = cplex.sum((IloNumExpr)lin, aux3);
                        qp.addMinimize(obj);
                        IloRange[] res = new IloRange[this.numres];
                        for (i = 0; i < this.numnod; ++i) {
                            coef = this.mat_A[i];
                            res[i] = cplex.addEq(this.vec_RHS[i], (IloNumExpr)cplex.scalProd(coef, var));
                        }
                        int to = this.numnod + this.numbran;
                        while (i < to) {
                            coef = this.mat_A[i];
                            res[i] = cplex.addGe(this.vec_RHS[i], (IloNumExpr)cplex.scalProd(coef, var));
                            coef = this.mat_A[i + this.numbran];
                            res[i + this.numbran] = cplex.addLe(this.vec_RHS[i + this.numbran], (IloNumExpr)cplex.scalProd(coef, var));
                            ++i;
                        }
                        i += this.numbran;
                        to = this.numresEl + this.resEleGen.length + this.serEleGen.length + 2 * this.resHydUnit.length + this.serHydUnit.length + this.irrHydUnit.length;
                        while (i < to) {
                            coef = this.mat_A[i];
                            res[i] = cplex.addEq(this.vec_RHS[i], (IloNumExpr)cplex.scalProd(coef, var));
                            ++i;
                        }
                        while (i < this.numres) {
                            coef = this.mat_A[i];
                            res[i] = cplex.addLe(this.vec_RHS[i], (IloNumExpr)cplex.scalProd(coef, var));
                            ++i;
                        }
                        cplex.setOut(this.myOS);
                        cplex.setWarning(this.myOS);
                        if (cplex.solve()) {
                            System.out.println("\n Optimal Solution Found");
                            cost3 = cplex.getObjValue();
                            this.vec_xtemp = cplex.getValues(var);
                            for (i = 0; i < this.numres; ++i) {
                                this.vec_lam[i] = cplex.getDual(res[i]);
                            }
                            System.out.println(" ");
                        } else {
                            System.out.println("");
                            System.out.println("  No Optimal Solution Found");
                            System.out.println("   Some troubles in problem definition ");
                        }
                        cplex.end();
                        currtime = System.currentTimeMillis() - initime + currtime;
                    }
                    catch (IloException e) {
                        System.err.println(" Concert exception caugth : " + e);
                        return;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return;
                    }
                }
                for (i = 0; i < this.numvarEl; ++i) {
                    int n = i;
                    this.vec_xtempabs[n] = this.vec_xtempabs[n] + this.vec_xtemp[i];
                }
                cost2 = this.make_cost();
                tol = (cost2 - cost1) * (cost2 - cost1);
                double feasIndex = 0.0;
                this.update_vec_RHS();
                double maxModRHS = 0.0;
                for (i = 0; i < this.numnod; ++i) {
                    feasIndex += this.vec_RHS[i] * this.vec_RHS[i];
                    if (!(Math.abs(this.vec_RHS[i]) > maxModRHS)) continue;
                    maxModRHS = Math.abs(this.vec_RHS[i]);
                }
                feasIndex = Math.sqrt(feasIndex) / (double)this.numnod;
                System.out.println(" ----------------------------------------------");
                System.out.println(" RHS TOL [MW]        = " + feasIndex * this.sref);
                System.out.println(" COS TOL [%]         = " + Math.abs(cost2 - cost1) * 200.0 / (cost2 + cost1));
                System.out.println(" ----------------------------------------------");
                System.out.println(" Feasibility [p.u.]  = " + feasIndex);
                System.out.println(" Max RHS dev. [MW]   = " + maxModRHS * this.sref);
                System.out.println(" ----------------------------------------------");
                System.out.println(" Absolute Obj Dev    = " + Math.abs(cost2 - cost1));
                System.out.println(" Mean Cost           = " + (cost2 + cost1) / 2.0);
                System.out.println(" ----------------------------------------------");
                System.out.println(" ----------------------------------------------");
                System.out.println(" Last Obj Value [$]  = " + cost2);
                System.out.println(" ----------------------------------------------");
                this.myPPrintStream.println(" ----------------------------------------------");
                this.myPPrintStream.println(" RHS TOL [MW]        = " + feasIndex * this.sref);
                this.myPPrintStream.println(" COS TOL [%]         = " + Math.abs(cost2 - cost1) * 200.0 / (cost2 + cost1));
                this.myPPrintStream.println(" ----------------------------------------------");
                this.myPPrintStream.println(" Feasibility [p.u.]  = " + feasIndex);
                this.myPPrintStream.println(" Max RHS dev. [MW]   = " + maxModRHS);
                this.myPPrintStream.println(" SP Result [$]       = " + cost3);
                this.myPPrintStream.println(" ----------------------------------------------");
                this.myPPrintStream.println(" Absolute Obj Dev    = " + Math.abs(cost2 - cost1));
                this.myPPrintStream.println(" Mean Cost           = " + (cost2 + cost1) / 2.0);
                this.myPPrintStream.println(" ----------------------------------------------");
                this.myPPrintStream.println(" ----------------------------------------------");
                this.myPPrintStream.println(" Last Obj Value [$]  = " + cost2);
                this.myPPrintStream.println(" ----------------------------------------------");
                if (feasIndex * this.sref <= this.tolfeas && Math.abs(cost2 - cost1) <= this.tolcost * (cost2 + cost1) / 200.0) {
                    System.out.println("   ");
                    System.out.println("          **************************  ");
                    System.out.println("          ** Convergence Achieved **  ");
                    System.out.println("          **************************  ");
                    System.out.println("   ");
                    this.myPPrintStream.println("   ");
                    this.myPPrintStream.println("          **************************  ");
                    this.myPPrintStream.println("          ** Convergence Achieved **  ");
                    this.myPPrintStream.println("          **************************  ");
                    this.myPPrintStream.println("   ");
                    konv = true;
                }
                cost1 = cost2;
                if (iteration == 1) {
                    konv = false;
                }
                if (iteration > this.iteraciones) {
                    this.overiter = true;
                }
                if (this.metodo == 4 && !konv && iteration < this.iteraciones) {
                    for (i = 0; i < this.numnod; ++i) {
                        if (!(this.vec_lam[i] < 0.0)) continue;
                        this.vec_lam[i] = 0.0;
                    }
                }
                if (!konv) continue;
                for (i = this.numvarEl; i < this.numvar; ++i) {
                    this.vec_xtempabs[i] = this.vec_xtemp[i];
                }
            }
            this.ActSchematic.setfitnes(-cost2);
            this.totcost = cost2;
            this.ActSchematic.settotcost(this.totcost);
            this.WriteResults();
            this.ActSchematic.settotgen(this.totgen);
            this.ActSchematic.settotunser(this.totunser);
            this.totloss = this.totgen + this.totunser - this.totdem;
            this.ActSchematic.settotloss(this.totloss);
            this.ActSchematic.settotdem(this.totdem);
            this.totincome = 0.0;
            this.totsales = 0.0;
            for (i = 0; i < this.numnod; ++i) {
                this.totsales += this.nod_Pdem[i] * this.vec_lam[i];
            }
            for (i = this.numload; i < this.numload + this.numgen; ++i) {
                this.totincome += this.vec_lam[this.VarNode[i]] * this.vec_xtempabs[i];
            }
            System.out.println("************************************************************");
            System.out.println(" Optimization Results");
            System.out.println(" Objective Function  [$]  = " + cost2);
            System.out.println("************************************************************");
            System.out.println(" Operation costs          = " + this.totcost + " [$]");
            System.out.println(" Active Generation        = " + this.totgen + " [MW]");
            System.out.println(" Unserved Load            = " + this.totunser + " [MW]");
            System.out.println(" Total Active Loss        = " + this.totloss + " <=> " + 100.0 * this.totloss / this.totdem + " [%]");
            System.out.println(" Total Active Demand      = " + this.totdem + " [MW]");
            System.out.println(" Total Load Sales         = " + this.totsales + " [$]");
            System.out.println(" Total Generator Income   = " + this.totincome + " [$]");
            System.out.println("************************************************************");
            this.myPPrintStream.println("************************************************************");
            this.myPPrintStream.println(" Optimization Results");
            this.myPPrintStream.println(" Objective Function  [$]  = " + cost2);
            this.myPPrintStream.println("************************************************************");
            this.myPPrintStream.println(" Operation costs          = " + this.totcost + " [$]");
            this.myPPrintStream.println(" Active Generation        = " + this.totgen + " [MW]");
            this.myPPrintStream.println(" Load Unserved            = " + this.totunser + " [MW]");
            this.myPPrintStream.println(" Total Active Loss        = " + this.totloss + " <=> " + 100.0 * this.totloss / this.totdem + " [%]");
            this.myPPrintStream.println(" Total Active Demand      = " + this.totdem + " [MW]");
            this.myPPrintStream.println(" Total Load Sales         = " + this.totsales + " [$]");
            this.myPPrintStream.println(" Total Generator Income   = " + this.totincome + " [$]");
            this.myPPrintStream.println("************************************************************");
            this.myPPrintStream.println("\n Reservoir water balance dual variables.");
            this.myPPrintStream.println("ResName  \t Dual value\t\t\t Cost[US$/m3]\t\t Cost[US$/Dm3]\t\t FC, vol[p.u] ");
            int from = this.numresEl + this.resEleGen.length + this.serEleGen.length;
            for (i = 0; i < this.resHydUnit.length; ++i) {
                this.myPPrintStream.println(this.resHydUnit[i].getName() + ":\t" + this.vec_lam[from + i] + "\t" + this.vec_lam[from + i] / this.dTb + "\t" + this.vec_lam[from + i] / this.dTb * 1000.0 + "\t " + this.vec_lam[from + i] * this.mDbvE[i]);
            }
            this.myPPrintStream.println("\n Reservoir filtering balance dual variables.");
            this.myPPrintStream.println("ResName  \t Dual value\t\t\t Cost[US$/m3]\t\t Cost[US$/Dm3]\t\t FC, vol[p.u] ");
            from = this.numresEl + this.resEleGen.length + this.serEleGen.length + this.resHydUnit.length + this.serHydUnit.length + this.irrHydUnit.length;
            for (i = 0; i < this.resHydUnit.length; ++i) {
                this.myPPrintStream.println(this.resHydUnit[i].getName() + ":\t" + this.vec_lam[from + i] + "\t" + this.vec_lam[from + i] / this.dTb + "\t" + this.vec_lam[from + i] / this.dTb * 1000.0 + "\t " + this.vec_lam[from + i] * this.mDbvE[i]);
            }
            if (this.metodo > 1) {
                System.out.println("\nOption CPlex Exec Time= " + currtime + " [ms]");
            } else {
                System.out.println("\nOption Minos Exec Time= " + currtime + " [ms]");
            }
            System.out.println("over " + iteration + " iterations.");
            if (os != null) {
                os.close();
            }
            this.IdidntRealize();
        }
        catch (Exception e) {
            String message = e.toString();
            e.printStackTrace();
            String[] DlgButtons = new String[]{"OK"};
            SimpleDialog ExceptionDialog = new SimpleDialog(DeepEdit.frame, "HTGLED", "Calculation Error: " + message, DlgButtons, 1, 0, 0, 1);
            return;
        }
        try {
            this.myPPrintStream.close();
            if (this.myOS != null) {
                this.myOS.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void showResults() {
        for (int ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
            comp TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
            if (!(TempComponent instanceof hdb_link)) continue;
            ((hdb_link)TempComponent).InformEndComponents();
        }
        this.ActSchematic.Modified = false;
        this.ActSchematic.Modifiedstate = false;
        this.ActSchematic.changeGIS = true;
        PLPFrame.View = true;
        DeepEdit.MySchematicPanel.repaint();
        Runtime r = Runtime.getRuntime();
        try {
            r.exec("write ./results/HTGLED.dat");
        }
        catch (Exception e) {
            System.out.println(e + ": error al abrir wordpad");
        }
    }

    public void initNetwork() throws Exception {
        Complex auxc2;
        Complex auxc1;
        int con2;
        int con1;
        int jx;
        int ix;
        this.myPPrintStream.println("Datos, System Name:  " + this.ActSchematic.getsysname());
        double ueb = 0.0;
        double res = 0.0;
        double z = 0.0;
        double reac = 0.0;
        double yy = 0.0;
        double y1 = 0.0;
        double y2 = 0.0;
        double b = 0.0;
        this.initLSSchemObj(this.myPPrintStream);
        this.loadBCs();
        this.numnod = this.busbars.length;
        this.numlin = this.lines.length;
        this.numtran = this.trafos.length;
        this.numbran = this.numlin + this.numtran;
        this.numgen = this.geners.length;
        this.numload = this.loads.length;
        this.totdem = 0.0;
        for (ix = 0; ix < this.loads.length; ++ix) {
            this.totdem += this.loads[ix].getp();
        }
        this.numvarEl = this.numload + this.numgen + this.numnod;
        this.numvarHy = 4 * this.resHydUnit.length + 2 * this.serHydUnit.length + 2 * this.irrHydUnit.length;
        this.numresEl = this.numnod + 2 * this.numbran;
        this.numresHy = this.resEleGen.length + this.serEleGen.length + 2 * this.resHydUnit.length + this.serHydUnit.length + this.irrHydUnit.length;
        this.numvar = this.numvarEl + this.numvarHy + 1;
        this.numres = this.numresEl + this.numresHy + this.vBC.size();
        this.BranchR = new double[this.numbran];
        this.BranchX = new double[this.numbran];
        this.BranchB = new double[this.numbran];
        this.BranchI = new int[this.numbran];
        this.BranchJ = new int[this.numbran];
        this.VarNode = new int[this.numvarEl];
        this.vec_clave = new int[this.numres];
        this.vec_xminabs = new double[this.numvar];
        this.vec_xmaxabs = new double[this.numvar];
        this.vec_xmin = new double[this.numvar];
        this.vec_xmax = new double[this.numvar];
        this.vec_xtemp = new double[this.numvar];
        this.vec_xtempabs = new double[this.numvar];
        this.vec_lam = new double[this.numres];
        this.vec_c = new double[this.numvar];
        this.vec_RHS = new double[this.numres];
        this.vec_Grad = new double[this.numvar];
        this.DiagMat_Q = new double[this.numvarEl];
        this.nod_Pdem = new double[this.numnod];
        this.MatG = new double[this.numnod][this.numnod];
        this.MatX = new double[this.numnod][this.numnod];
        this.mat_A = new double[this.numres][this.numvar];
        this.mat_Avar = new double[this.numnod][this.numnod];
        this.mat_W = new double[this.numvarEl][this.numvarEl];
        Complex[][] MatY = new Complex[this.numnod][this.numnod];
        for (ix = 0; ix < this.numnod; ++ix) {
            for (jx = 0; jx < this.numnod; ++jx) {
                MatY[ix][jx] = new Complex();
            }
        }
        for (ix = 0; ix < this.lines.length; ++ix) {
            con1 = this.numbus(this.lines[ix].getcon1());
            con2 = this.numbus(this.lines[ix].getcon2());
            if (con1 > -1 && con2 > -1) {
                this.BranchX[ix] = this.lines[ix].getxx1() * this.lines[ix].getlen() * this.sref / (this.lines[ix].getun1() * this.lines[ix].getun1());
                this.BranchR[ix] = this.lines[ix].getr1() * this.lines[ix].getlen() * this.sref / (this.lines[ix].getun1() * this.lines[ix].getun1());
                this.BranchB[ix] = this.lines[ix].getb1() * this.lines[ix].getlen() / 2.0 / this.sref * (this.lines[ix].getun1() * this.lines[ix].getun1());
                this.BranchI[ix] = con1;
                this.BranchJ[ix] = con2;
                auxc1 = new Complex(this.BranchR[ix], this.BranchX[ix]);
                auxc2 = new Complex(1.0);
                auxc1 = auxc2.divide(auxc1);
                auxc2 = new Complex(0.0, this.BranchB[ix]);
                MatY[this.BranchJ[ix]][this.BranchI[ix]].add(Complex.negate((Complex)auxc1));
                MatY[this.BranchI[ix]][this.BranchJ[ix]].add(Complex.negate((Complex)auxc1));
                MatY[this.BranchI[ix]][this.BranchI[ix]].add(Complex.add((Complex)auxc1, (Complex)auxc2));
                MatY[this.BranchJ[ix]][this.BranchJ[ix]].add(Complex.add((Complex)auxc1, (Complex)auxc2));
                continue;
            }
            System.out.println("Wrong Connceted Line: " + this.lines[ix].getName());
        }
        int count = this.lines.length;
        for (ix = 0; ix < this.trafos.length; ++ix) {
            this.trafos[ix].actualizet();
            this.trafos[ix].sett_re_old(this.trafos[ix].gett_re());
            con1 = this.numbus(this.trafos[ix].getcon1());
            con2 = this.numbus(this.trafos[ix].getcon2());
            if (con1 > -1 && con2 > -1) {
                ueb = this.trafos[ix].getun1() / this.trafos[ix].getun2() / (this.trafos[ix].getur1() / this.trafos[ix].getur2());
                res = this.trafos[ix].getpcu() * 0.001 * ueb * ueb / this.trafos[ix].getsn() * this.sref / this.trafos[ix].getsn();
                z = this.trafos[ix].getuk() * 0.01 * ueb * ueb * this.sref / this.trafos[ix].getsn();
                b = this.trafos[ix].geti0() * 0.01 * 0.5 / this.sref * this.trafos[ix].getsn();
                reac = this.trafos[ix].getuk() >= 0.0 ? Math.sqrt(z * z - res * res) : -Math.sqrt(z * z - res * res);
                this.BranchX[count] = reac;
                this.BranchR[count] = res;
                this.BranchB[count] = b;
                this.BranchI[count] = con1;
                this.BranchJ[count] = con2;
                auxc1 = new Complex(this.BranchR[count], this.BranchX[count]);
                auxc2 = new Complex(1.0);
                auxc1 = Complex.divide((Complex)auxc2, (Complex)auxc1);
                auxc2 = new Complex(0.0, this.BranchB[count]);
                MatY[this.BranchJ[count]][this.BranchI[count]].add(Complex.negate((Complex)Complex.divide((Complex)auxc1, (double)this.trafos[ix].gett_re())));
                MatY[this.BranchI[count]][this.BranchJ[count]].add(Complex.negate((Complex)Complex.divide((Complex)auxc1, (double)this.trafos[ix].gett_re())));
                MatY[this.BranchI[count]][this.BranchI[count]].add(Complex.add((Complex)auxc1, (Complex)auxc2).divide(this.trafos[ix].gett_re() * this.trafos[ix].gett_re()));
                MatY[this.BranchJ[count]][this.BranchJ[count]].add(Complex.add((Complex)auxc1, (Complex)auxc2));
                ++count;
                continue;
            }
            System.out.println("Wrong Connceted Trafo: " + this.trafos[ix].getName());
        }
        int countVar = 0;
        for (ix = 0; ix < this.loads.length; ++ix) {
            this.vec_xmaxabs[countVar] = this.loads[ix].getp() / this.sref;
            this.VarNode[ix] = this.numbus(this.loads[ix].getcon2());
            int n = this.VarNode[ix];
            this.nod_Pdem[n] = this.nod_Pdem[n] + this.loads[ix].getp0() / this.sref;
            ++countVar;
        }
        for (ix = 0; ix < this.geners.length; ++ix) {
            this.vec_xminabs[countVar] = this.geners[ix].getpmin() / this.sref;
            this.vec_xmaxabs[countVar] = this.geners[ix].getpmax() / this.sref;
            this.VarNode[countVar] = this.numbus(this.geners[ix].getcon2());
            ++countVar;
        }
        countVar = this.loads.length + this.injGen.length + this.thermalGen.length;
        for (ix = 0; ix < this.ppEleGen.length; ++ix) {
            this.vec_xmaxabs[countVar] = Math.min(this.vec_xmaxabs[countVar], this.ppHydUnit[ix].getWat2PowRate() * this.sumQAffl(this.ppaff[ix]) / this.sref);
            ++countVar;
        }
        countVar += this.resEleGen.length + this.serEleGen.length;
        for (ix = 0; ix < this.busbars.length; ++ix) {
            this.vec_xminabs[countVar] = -3.14;
            this.vec_xmaxabs[countVar] = 3.14;
            ++countVar;
        }
        for (ix = 0; ix < this.resHydUnit.length; ++ix) {
            this.vec_xmaxabs[countVar] = this.resHydUnit[ix].getTurbmax();
            ++countVar;
        }
        for (ix = 0; ix < this.serHydUnit.length; ++ix) {
            this.vec_xmaxabs[countVar] = this.serHydUnit[ix].getTurbmax();
            ++countVar;
        }
        for (ix = 0; ix < this.resHydUnit.length; ++ix) {
            this.vec_xmaxabs[countVar] = 1.0E100;
            ++countVar;
        }
        for (ix = 0; ix < this.serHydUnit.length; ++ix) {
            this.vec_xmaxabs[countVar] = 1.0E100;
            ++countVar;
        }
        for (ix = 0; ix < this.resHydUnit.length; ++ix) {
            this.vec_xmaxabs[countVar] = 1.0E100;
            ++countVar;
        }
        for (ix = 0; ix < this.irrHydUnit.length; ++ix) {
            this.vec_xmaxabs[countVar] = 1.0E100;
            ++countVar;
        }
        for (ix = 0; ix < this.irrHydUnit.length; ++ix) {
            this.vec_xmaxabs[countVar] = this.irrHydUnit[ix].getSpillmax();
            ++countVar;
        }
        for (ix = 0; ix < this.resHydUnit.length; ++ix) {
            this.vec_xmaxabs[countVar] = 1.0;
            ++countVar;
        }
        this.vec_xmaxabs[countVar] = 1.0E100;
        double are = 0.0;
        double aim = 0.0;
        Complex aco = new Complex();
        for (ix = 0; ix < this.numnod; ++ix) {
            for (jx = 0; jx < this.numnod; ++jx) {
                if (Complex.abs((Complex)MatY[ix][jx]) > 1.0E-6 && ix != jx) {
                    aco = new Complex(1.0, 0.0);
                    aco = Complex.negate((Complex)Complex.divide((Complex)aco, (Complex)MatY[ix][jx]));
                    are = aco.re;
                    aim = aco.im;
                    this.MatG[ix][jx] = are / (are * are + aim * aim);
                    this.MatX[ix][jx] = aim;
                    continue;
                }
                this.MatG[ix][jx] = 0.0;
                this.MatX[ix][jx] = 0.0;
            }
        }
    }

    public static void printMatrix(PrintStream myPrintStream, Complex[][] m, int ii, int jj) {
        for (int i = 0; i < ii; ++i) {
            for (int j = 0; j < jj; ++j) {
                myPrintStream.print(m[i][j] + "\t ");
            }
            myPrintStream.println();
        }
        myPrintStream.println();
    }

    public static void printMatrix(PrintStream myPrintStream, double[][] m, int ii, int jj) {
        for (int i = 0; i < ii; ++i) {
            for (int j = 0; j < jj; ++j) {
                myPrintStream.print(m[i][j] + "\t ");
            }
            myPrintStream.println();
        }
        myPrintStream.println();
    }

    public static void printMatrix(double[][] m, int ii, int jj) {
        for (int i = 0; i < ii; ++i) {
            for (int j = 0; j < jj; ++j) {
                System.out.print(m[i][j] + "\t ");
            }
            System.out.println();
        }
        System.out.println();
    }

    public static void printVector(PrintStream myPrintStream, Complex[] v, int ii) {
        for (int i = 0; i < ii; ++i) {
            myPrintStream.print(i + "\t" + v[i] + "\t");
            myPrintStream.println();
        }
        myPrintStream.println();
    }

    public static void printVector(PrintStream myPrintStream, double[] v, int ii) {
        for (int i = 0; i < ii; ++i) {
            myPrintStream.print(i + "\t" + v[i] + "\t");
            myPrintStream.println();
        }
        myPrintStream.println();
    }

    public static void printVector(int[] v, int ii) {
        for (int i = 0; i < ii; ++i) {
            System.out.print(i + "\t" + v[i] + "\t");
            System.out.println();
        }
        System.out.println();
    }

    public void update_vec_xlimits() {
        for (int i = 0; i < this.numvar; ++i) {
            this.vec_xmin[i] = this.vec_xminabs[i] - this.vec_xtempabs[i];
            this.vec_xmax[i] = this.vec_xmaxabs[i] - this.vec_xtempabs[i];
        }
    }

    public void make_vec_c() {
        int ix;
        for (ix = 0; ix < this.loads.length; ++ix) {
            this.vec_c[ix] = this.loads[ix].getbeta() * this.sref * this.dTb;
        }
        int countVar = this.loads.length;
        for (ix = 0; ix < this.geners.length; ++ix) {
            this.vec_c[countVar] = this.geners[ix].getbeta() * this.sref * this.dTb;
            ++countVar;
        }
        countVar = this.numvarEl + 3 * this.resHydUnit.length + 2 * this.serHydUnit.length + this.irrHydUnit.length;
        for (ix = 0; ix < this.irrHydUnit.length; ++ix) {
            this.vec_c[countVar] = this.hydroFailCost * this.dTb;
            ++countVar;
        }
        this.vec_c[countVar += this.resHydUnit.length] = fEscBC;
    }

    public void make_mat_Afix() throws Exception {
        double xij;
        int con2;
        int con1;
        int ix;
        for (ix = 0; ix < this.loads.length; ++ix) {
            this.mat_A[this.VarNode[ix]][ix] = 1.0;
        }
        int jx = this.loads.length + this.geners.length;
        for (ix = this.loads.length; ix < jx; ++ix) {
            this.mat_A[this.VarNode[ix]][ix] = 1.0;
        }
        for (ix = 0; ix < this.lines.length; ++ix) {
            con1 = this.BranchI[ix];
            con2 = this.BranchJ[ix];
            xij = this.BranchX[ix];
            this.mat_A[this.numnod + ix][this.numgen + this.numload + con1] = 1.0 / xij;
            this.mat_A[this.numnod + ix][this.numgen + this.numload + con2] = -1.0 / xij;
            this.mat_A[this.numnod + this.numbran + ix][this.numgen + this.numload + con1] = 1.0 / xij;
            this.mat_A[this.numnod + this.numbran + ix][this.numgen + this.numload + con2] = -1.0 / xij;
        }
        int countRes = this.lines.length;
        for (ix = 0; ix < this.trafos.length; ++ix) {
            con1 = this.BranchI[countRes];
            con2 = this.BranchJ[countRes];
            xij = this.BranchX[countRes];
            this.mat_A[this.numnod + countRes][this.numgen + this.numload + con1] = 1.0 / xij;
            this.mat_A[this.numnod + countRes][this.numgen + this.numload + con2] = -1.0 / xij;
            this.mat_A[this.numnod + this.numbran + countRes][this.numgen + this.numload + con1] = 1.0 / xij;
            this.mat_A[this.numnod + this.numbran + countRes][this.numgen + this.numload + con2] = -1.0 / xij;
            ++countRes;
        }
        this.makeHSubMatrix(this.myPPrintStream);
        int offVar = this.loads.length + this.injGen.length + this.thermalGen.length + this.ppEleGen.length;
        int offVar2 = this.numvarEl;
        int offRes = this.numresEl;
        for (ix = 0; ix < this.resEleGen.length; ++ix) {
            this.mat_A[offRes + ix][offVar + ix] = 1.0;
            this.mat_A[offRes + ix][offVar2 + ix] = -this.mDrE[ix];
        }
        offVar += this.resEleGen.length;
        offVar2 += this.resHydUnit.length;
        offRes += this.resEleGen.length;
        for (ix = 0; ix < this.serEleGen.length; ++ix) {
            this.mat_A[offRes + ix][offVar + ix] = 1.0;
            this.mat_A[offRes + ix][offVar2 + ix] = -this.mDrS[ix];
        }
        offVar = this.numvarEl;
        offRes = this.numresEl + this.resEleGen.length + this.serEleGen.length;
        for (ix = 0; ix < this.HCx.length; ++ix) {
            for (jx = 0; jx < this.HCx[0].length; ++jx) {
                this.mat_A[offRes + ix][offVar + jx] = this.HCx[ix][jx];
            }
        }
        offVar += 3 * this.resHydUnit.length + 2 * this.serHydUnit.length + 2 * this.irrHydUnit.length;
        for (ix = 0; ix < this.resHydUnit.length; ++ix) {
            this.mat_A[offRes + ix][offVar + ix] = this.mDbvE[ix];
        }
        offVar2 = this.numvarEl + 2 * (this.resHydUnit.length + this.serHydUnit.length);
        offRes = this.numresEl + this.resEleGen.length + this.serEleGen.length + this.resHydUnit.length + this.serHydUnit.length + this.irrHydUnit.length;
        for (ix = 0; ix < this.resHydUnit.length; ++ix) {
            this.mat_A[offRes + ix][offVar + ix] = -this.mDfE[ix];
            this.mat_A[offRes + ix][offVar2 + ix] = 1.0;
        }
    }

    public void make_mat_W() {
        int j;
        int i;
        int nn = this.numnod;
        int off = this.numgen + this.numload;
        for (i = 0; i < this.numvarEl; ++i) {
            for (j = 0; j < this.numvarEl; ++j) {
                this.mat_W[i][j] = 0.0;
            }
        }
        for (i = 0; i < off; ++i) {
            this.mat_W[i][i] = this.DiagMat_Q[i];
        }
        if (this.cuadLossModel) {
            for (int k = 0; k < nn; ++k) {
                for (j = 0; j < nn; ++j) {
                    if (k == j || !(Math.abs(this.MatG[k][j]) > 1.0E-6)) continue;
                    double[] dArray = this.mat_W[k + off];
                    int n = k + off;
                    dArray[n] = dArray[n] + this.vec_lam[k] * this.MatG[k][j];
                    double[] dArray2 = this.mat_W[j + off];
                    int n2 = j + off;
                    dArray2[n2] = dArray2[n2] + this.vec_lam[k] * this.MatG[k][j];
                    double[] dArray3 = this.mat_W[k + off];
                    int n3 = j + off;
                    dArray3[n3] = dArray3[n3] - this.vec_lam[k] * this.MatG[k][j];
                    double[] dArray4 = this.mat_W[j + off];
                    int n4 = k + off;
                    dArray4[n4] = dArray4[n4] - this.vec_lam[k] * this.MatG[k][j];
                }
            }
        } else {
            for (int k = 0; k < nn; ++k) {
                for (j = 0; j < nn; ++j) {
                    if (k == j || !(Math.abs(this.MatG[k][j]) > 1.0E-6)) continue;
                    double[] dArray = this.mat_W[k + off];
                    int n = k + off;
                    dArray[n] = dArray[n] + this.vec_lam[k] * this.MatG[k][j] * Math.cos(this.vec_xtempabs[off + k] - this.vec_xtempabs[off + j]);
                    double[] dArray5 = this.mat_W[j + off];
                    int n5 = j + off;
                    dArray5[n5] = dArray5[n5] + this.vec_lam[k] * this.MatG[k][j] * Math.cos(this.vec_xtempabs[off + k] - this.vec_xtempabs[off + j]);
                    double[] dArray6 = this.mat_W[k + off];
                    int n6 = j + off;
                    dArray6[n6] = dArray6[n6] - this.vec_lam[k] * this.MatG[k][j] * Math.cos(this.vec_xtempabs[off + k] - this.vec_xtempabs[off + j]);
                    double[] dArray7 = this.mat_W[j + off];
                    int n7 = k + off;
                    dArray7[n7] = dArray7[n7] - this.vec_lam[k] * this.MatG[k][j] * Math.cos(this.vec_xtempabs[off + k] - this.vec_xtempabs[off + j]);
                }
            }
        }
    }

    public void make_DiagMat_Q() {
        int ix = 0;
        int countVar = 0;
        for (ix = 0; ix < this.numvarEl; ++ix) {
            this.DiagMat_Q[ix] = 0.0;
        }
        for (ix = 0; ix < this.loads.length; ++ix) {
            this.DiagMat_Q[ix] = 2.0 * this.loads[ix].getgamma() * this.sref * this.sref * this.dTb;
        }
        countVar = this.loads.length;
        for (ix = 0; ix < this.geners.length; ++ix) {
            this.DiagMat_Q[countVar] = 2.0 * this.geners[ix].getgamma() * this.sref * this.sref * this.dTb;
            ++countVar;
        }
    }

    public void startPoint() {
        for (int i = 0; i < this.numvar; ++i) {
            this.vec_xtempabs[i] = 0.0;
        }
    }

    public double make_cost() {
        int i;
        double cost = 0.0;
        int fr = 0;
        int to = this.numgen + this.numload;
        for (i = fr; i < to; ++i) {
            cost += this.vec_xtempabs[i] * (this.vec_c[i] + this.DiagMat_Q[i] / 2.0 * this.vec_xtempabs[i]);
        }
        fr = this.numvarEl + 3 * this.resHydUnit.length + 2 * this.serHydUnit.length + this.irrHydUnit.length;
        to = fr + this.irrHydUnit.length;
        for (i = fr; i < to; ++i) {
            cost += this.vec_xtempabs[i] * this.vec_c[i];
        }
        return cost;
    }

    public int numbus(String Busbarname) {
        for (int ix = 0; ix < this.busbars.length; ++ix) {
            if (!this.busbars[ix].getName().equals(Busbarname)) continue;
            return ix;
        }
        return -1;
    }

    public void make_vec_Grad() {
        int i;
        for (i = 0; i < this.numgen + this.numload; ++i) {
            this.vec_Grad[i] = this.vec_c[i] + this.DiagMat_Q[i] * this.vec_xtempabs[i];
        }
        while (i < this.numvar) {
            this.vec_Grad[i] = this.vec_c[i];
            ++i;
        }
    }

    public void makeAdd_mat_Avar() {
        int j;
        int i;
        int off = this.numgen + this.numload;
        for (i = 0; i < this.numnod; ++i) {
            for (j = 0; j < this.numnod; ++j) {
                this.mat_Avar[i][j] = 0.0;
            }
        }
        if (this.cuadLossModel) {
            for (i = 0; i < this.numnod; ++i) {
                for (j = 0; j < this.numnod; ++j) {
                    if (!(Math.abs(this.MatX[i][j]) > 1.0E-6) || i == j) continue;
                    double[] dArray = this.mat_Avar[i];
                    int n = i;
                    dArray[n] = dArray[n] - (this.MatG[i][j] * (this.vec_xtempabs[off + i] - this.vec_xtempabs[off + j]) + 1.0 / this.MatX[i][j]);
                    double[] dArray2 = this.mat_Avar[i];
                    int n2 = j;
                    dArray2[n2] = dArray2[n2] + (this.MatG[i][j] * (this.vec_xtempabs[off + i] - this.vec_xtempabs[off + j]) + 1.0 / this.MatX[i][j]);
                }
            }
        } else {
            for (i = 0; i < this.numnod; ++i) {
                for (j = 0; j < this.numnod; ++j) {
                    if (!(Math.abs(this.MatX[i][j]) > 1.0E-6) || i == j) continue;
                    double[] dArray = this.mat_Avar[i];
                    int n = i;
                    dArray[n] = dArray[n] - (this.MatG[i][j] * Math.sin(this.vec_xtempabs[off + i] - this.vec_xtempabs[off + j]) + 1.0 / this.MatX[i][j]);
                    double[] dArray3 = this.mat_Avar[i];
                    int n3 = j;
                    dArray3[n3] = dArray3[n3] + (this.MatG[i][j] * Math.sin(this.vec_xtempabs[off + i] - this.vec_xtempabs[off + j]) + 1.0 / this.MatX[i][j]);
                }
            }
        }
        for (i = 0; i < this.numnod; ++i) {
            for (j = 0; j < this.numnod; ++j) {
                this.mat_A[i][off + j] = this.mat_Avar[i][j];
            }
        }
    }

    public void make_vec_RHS() {
        double aux;
        int ix;
        this.update_vec_RHS();
        int offVar = this.numvarEl;
        int offRes = this.numresEl + this.resEleGen.length + this.serEleGen.length;
        for (ix = 0; ix < this.HCx.length; ++ix) {
            for (int jx = 0; jx < this.HCx[0].length; ++jx) {
                if (this.HCx[ix][jx] == 0.0) continue;
                this.vec_RHS[offRes + ix] = -this.HCx[ix][jx] * this.vec_xtempabs[offVar + ix];
            }
        }
        offVar += 3 * this.resHydUnit.length + 2 * this.serHydUnit.length + 2 * this.irrHydUnit.length;
        for (ix = 0; ix < this.resHydUnit.length; ++ix) {
            int n = offRes + ix;
            this.vec_RHS[n] = this.vec_RHS[n] - this.mDbvE[ix] * this.vec_xtempabs[offVar + ix];
        }
        int offVar2 = this.numvarEl + 2 * (this.resHydUnit.length + this.serHydUnit.length);
        offRes = this.numresEl + this.resEleGen.length + this.serEleGen.length + this.resHydUnit.length + this.serHydUnit.length + this.irrHydUnit.length;
        for (ix = 0; ix < this.resHydUnit.length; ++ix) {
            if (this.resHydUnit[ix].getFiltType() > 0) {
                this.vec_RHS[offRes + ix] = this.mDfE[ix] * this.vec_xtempabs[offVar + ix] - this.vec_xtempabs[offVar2 + ix];
                aux = (this.resHydUnit[ix].getVini() - this.resHydUnit[ix].getVmin()) * 1000.0 / 3.6;
                int n = offRes + ix;
                this.vec_RHS[n] = this.vec_RHS[n] + this.resHydUnit[ix].getAvfiltf() * aux / this.dTb / 2.0 * this.dTb / 730.0;
                continue;
            }
            this.vec_RHS[offRes + ix] = 0.0;
        }
        offRes = this.numresEl + this.resEleGen.length + this.serEleGen.length;
        for (ix = 0; ix < this.resHydUnit.length; ++ix) {
            aux = (this.resHydUnit[ix].getVini() - this.resHydUnit[ix].getVmin()) * 1000.0 / 3.6;
            int n = offRes + ix;
            this.vec_RHS[n] = this.vec_RHS[n] + (aux / this.dTb + this.sumQAffl(this.resaff[ix]));
        }
        offRes += this.resHydUnit.length;
        for (ix = 0; ix < this.serHydUnit.length; ++ix) {
            int n = offRes + ix;
            this.vec_RHS[n] = this.vec_RHS[n] + this.sumQAffl(this.seraff[ix]);
        }
        offRes += this.serHydUnit.length;
        for (ix = 0; ix < this.irrHydUnit.length; ++ix) {
            int n = offRes + ix;
            this.vec_RHS[n] = this.vec_RHS[n] + (this.sumQAffl(this.irraff[ix]) - this.irrHydUnit[ix].getSpillmax());
        }
    }

    public void update_vec_RHS() {
        int count;
        int ix;
        double dang;
        int j;
        double transm;
        int i;
        for (i = 0; i < this.numnod; ++i) {
            this.vec_RHS[i] = this.nod_Pdem[i];
        }
        for (i = 0; i < this.numload; ++i) {
            int n = this.VarNode[i];
            this.vec_RHS[n] = this.vec_RHS[n] - this.vec_xtempabs[i];
        }
        for (i = 0; i < this.numgen; ++i) {
            int n = this.VarNode[i + this.numload];
            this.vec_RHS[n] = this.vec_RHS[n] - this.vec_xtempabs[i + this.numload];
        }
        int off = this.numgen + this.numload;
        if (this.cuadLossModel) {
            i = 0;
            while (i < this.numnod) {
                transm = 0.0;
                for (j = 0; j < this.numnod; ++j) {
                    if (!(Math.abs(this.MatX[i][j]) > 1.0E-6) || j == i) continue;
                    dang = this.vec_xtempabs[off + i] - this.vec_xtempabs[off + j];
                    transm += this.MatG[i][j] / 2.0 * dang * dang + dang / this.MatX[i][j];
                }
                int n = i++;
                this.vec_RHS[n] = this.vec_RHS[n] + transm;
            }
        } else {
            i = 0;
            while (i < this.numnod) {
                transm = 0.0;
                for (j = 0; j < this.numnod; ++j) {
                    if (!(Math.abs(this.MatX[i][j]) > 1.0E-6) || j == i) continue;
                    dang = this.vec_xtempabs[off + i] - this.vec_xtempabs[off + j];
                    transm += this.MatG[i][j] * (1.0 - Math.cos(dang)) + dang / this.MatX[i][j];
                }
                int n = i++;
                this.vec_RHS[n] = this.vec_RHS[n] + transm;
            }
        }
        off = this.numgen + this.numload;
        if (this.islinres) {
            double xij;
            int con2;
            int con1;
            for (ix = 0; ix < this.lines.length; ++ix) {
                con1 = this.BranchI[ix];
                con2 = this.BranchJ[ix];
                xij = this.BranchX[ix];
                dang = this.vec_xtempabs[off + con1] - this.vec_xtempabs[off + con2];
                this.vec_RHS[this.numnod + ix] = this.lines[ix].getsmax() / this.sref - dang / xij;
                this.vec_RHS[this.numnod + this.numbran + ix] = -this.lines[ix].getsmax() / this.sref - dang / xij;
            }
            count = this.lines.length;
            for (ix = 0; ix < this.trafos.length; ++ix) {
                con1 = this.BranchI[count];
                con2 = this.BranchJ[count];
                xij = this.BranchX[count];
                dang = this.vec_xtempabs[off + con1] - this.vec_xtempabs[off + con2];
                this.vec_RHS[this.numnod + count] = this.trafos[ix].getsmax() / this.sref - dang / xij;
                this.vec_RHS[this.numnod + this.numbran + count] = -this.trafos[ix].getsmax() / this.sref - dang / xij;
                ++count;
            }
        } else {
            for (ix = 0; ix < this.lines.length; ++ix) {
                this.vec_RHS[this.numnod + ix] = infTx;
                this.vec_RHS[this.numnod + this.numbran + ix] = -infTx;
            }
            count = this.lines.length;
            for (ix = 0; ix < this.trafos.length; ++ix) {
                this.vec_RHS[this.numnod + count] = infTx;
                this.vec_RHS[this.numnod + this.numbran + count] = -infTx;
                ++count;
            }
        }
        int offVar = this.loads.length + this.injGen.length + this.thermalGen.length + this.ppEleGen.length;
        int offVar2 = this.numvarEl;
        int offRes = this.busbars.length + 2 * this.numbran;
        for (ix = 0; ix < this.resEleGen.length; ++ix) {
            this.vec_RHS[offRes + ix] = this.mDrE[ix] * this.vec_xtempabs[offVar2 + ix] - this.vec_xtempabs[offVar + ix];
        }
        offVar += this.resEleGen.length;
        offVar2 += this.resHydUnit.length;
        offRes += this.resEleGen.length;
        for (ix = 0; ix < this.serEleGen.length; ++ix) {
            this.vec_RHS[offRes + ix] = this.mDrS[ix] * this.vec_xtempabs[offVar2 + ix] - this.vec_xtempabs[offVar + ix];
        }
    }

    public double[] make_AbsEqRHSdev() {
        int i;
        double[] deviations = new double[this.numnod];
        for (i = 0; i < this.numnod; ++i) {
            deviations[i] = this.vec_RHS[i];
        }
        for (i = 0; i < this.numload; ++i) {
            int n = this.VarNode[i];
            deviations[n] = deviations[n] - this.vec_xtemp[i];
        }
        for (i = 0; i < this.numgen; ++i) {
            int n = this.VarNode[i + this.numload];
            this.vec_RHS[n] = this.vec_RHS[n] - this.vec_xtemp[i + this.numload];
        }
        return deviations;
    }

    public void make_vec_clave() {
        int i;
        int f = 0;
        int t = this.numnod;
        for (i = f; i < t; ++i) {
            this.vec_clave[i] = 1;
        }
        f = t;
        t += this.numbran;
        for (i = f; i < t; ++i) {
            this.vec_clave[i] = 2;
        }
        f = t;
        t += this.numbran;
        for (i = f; i < t; ++i) {
            this.vec_clave[i] = 3;
        }
        f = t;
        t = this.numresEl + this.resEleGen.length + this.serEleGen.length + 2 * this.resHydUnit.length + this.serHydUnit.length + this.irrHydUnit.length;
        for (i = f; i < t; ++i) {
            this.vec_clave[i] = 1;
        }
        f = t;
        t = this.numres;
        for (i = f; i < t; ++i) {
            this.vec_clave[i] = 3;
        }
    }

    public void WriteResults() {
        double f21;
        double f12;
        double gmula;
        int con2;
        int con1;
        int ix = 0;
        double refdelta = 0.0;
        this.totgen = 0.0;
        this.totdem = 0.0;
        for (ix = 0; ix < this.loads.length; ++ix) {
            this.totunser += this.vec_xtempabs[ix] * this.sref;
            this.totdem += this.loads[ix].getp();
            if (Math.abs(this.vec_xtempabs[ix] * this.sref) < 0.001) {
                this.loads[ix].setunser_p(0.0);
                continue;
            }
            this.loads[ix].setunser_p(this.vec_xtempabs[ix] * this.sref);
        }
        int off = this.loads.length;
        for (ix = 0; ix < this.geners.length; ++ix) {
            this.totgen += this.vec_xtempabs[ix + off] * this.sref;
            if (Math.abs(this.vec_xtempabs[ix + off] * this.sref) < 0.001) {
                this.geners[ix].setp(0.0);
                continue;
            }
            this.geners[ix].setp(this.vec_xtempabs[ix + off] * this.sref);
        }
        off += this.geners.length;
        for (ix = 0; ix < this.busbars.length; ++ix) {
            double angulin = this.vec_xtempabs[ix + off] * 180.0 / Math.PI;
            this.busbars[ix].setdelta2(angulin);
            double spotin = this.vec_lam[ix] / this.sref / this.dTb;
            this.busbars[ix].setspot_p(spotin);
        }
        for (ix = 0; ix < this.lines.length; ++ix) {
            con1 = this.BranchI[ix];
            con2 = this.BranchJ[ix];
            if (Math.abs(this.BranchX[ix]) > 1.0E-6) {
                gmula = this.BranchR[ix] / (this.BranchR[ix] * this.BranchR[ix] + this.BranchX[ix] * this.BranchX[ix]);
                f12 = (this.vec_xtempabs[off + con1] - this.vec_xtempabs[off + con2]) / this.BranchX[ix] + gmula * (1.0 - Math.cos(this.vec_xtempabs[off + con1] - this.vec_xtempabs[off + con2]));
                f21 = (this.vec_xtempabs[off + con2] - this.vec_xtempabs[off + con1]) / this.BranchX[ix] + gmula * (1.0 - Math.cos(this.vec_xtempabs[off + con2] - this.vec_xtempabs[off + con1]));
            } else {
                f12 = 0.0;
                f21 = 0.0;
            }
            this.lines[ix].setp12(f12);
            this.lines[ix].setp21(f21);
        }
        int to = this.lines.length + this.trafos.length;
        while (ix < to) {
            con1 = this.BranchI[ix];
            con2 = this.BranchJ[ix];
            if (this.trafos[ix - this.lines.length].gett_re() > 1.0E-6) {
                this.BranchX[ix] = this.BranchX[ix] * this.trafos[ix - this.lines.length].gett_re();
                this.BranchR[ix] = this.BranchR[ix] * this.trafos[ix - this.lines.length].gett_re();
            }
            if (Math.abs(this.BranchX[ix]) > 1.0E-6) {
                gmula = this.BranchR[ix] / (this.BranchR[ix] * this.BranchR[ix] + this.BranchX[ix] * this.BranchX[ix]);
                f12 = (this.vec_xtempabs[off + con1] - this.vec_xtempabs[off + con2]) / this.BranchX[ix] + gmula * (1.0 - Math.cos(this.vec_xtempabs[off + con1] - this.vec_xtempabs[off + con2]));
                f21 = (this.vec_xtempabs[off + con2] - this.vec_xtempabs[off + con1]) / this.BranchX[ix] + gmula * (1.0 - Math.cos(this.vec_xtempabs[off + con2] - this.vec_xtempabs[off + con1]));
            } else {
                System.out.println("Reactancia muy baja!!!");
                f12 = 0.0;
                f21 = 0.0;
            }
            this.trafos[ix - this.lines.length].setp12(f12);
            this.trafos[ix - this.lines.length].setp21(f21);
            ++ix;
        }
        off = this.loads.length + this.injGen.length + this.thermalGen.length;
        for (ix = 0; ix < this.ppHydUnit.length; ++ix) {
            this.ppHydUnit[ix].caudaffl = this.sumQAffl(this.ppaff[ix]);
            double aux = this.ppHydUnit[ix].getWat2PowRate() <= 0.0 ? 0.0 : this.vec_xtempabs[off + ix] * this.sref / this.ppHydUnit[ix].getWat2PowRate();
            this.ppHydUnit[ix].caudgener = aux;
            this.ppHydUnit[ix].caudspill = this.ppHydUnit[ix].caudaffl - aux;
        }
        off = this.numvarEl;
        int off1 = this.numvarEl + this.resHydUnit.length + this.serHydUnit.length;
        int off2 = this.numvarEl + 2 * this.resHydUnit.length + 2 * this.serHydUnit.length;
        int off3 = this.numvarEl + 3 * this.resHydUnit.length + 2 * this.serHydUnit.length + 2 * this.irrHydUnit.length;
        for (ix = 0; ix < this.resHydUnit.length; ++ix) {
            this.resHydUnit[ix].caudaffl = this.sumQAffl(this.resaff[ix]);
            this.resHydUnit[ix].caudgener = this.vec_xtempabs[off + ix];
            this.resHydUnit[ix].caudspill = this.vec_xtempabs[off1 + ix];
            this.resHydUnit[ix].caudfilt = this.vec_xtempabs[off2 + ix];
            this.resHydUnit[ix].Vfin = this.vec_xtempabs[off3 + ix] * (this.resHydUnit[ix].getVmax() - this.resHydUnit[ix].getVmin()) + this.resHydUnit[ix].getVmin();
        }
        off = this.numvarEl + this.resHydUnit.length;
        off1 = this.numvarEl + 2 * this.resHydUnit.length + this.serHydUnit.length;
        for (ix = 0; ix < this.serHydUnit.length; ++ix) {
            this.serHydUnit[ix].caudaffl = this.sumQAffl(this.seraff[ix]);
            this.serHydUnit[ix].caudgener = this.vec_xtempabs[off + ix];
            this.serHydUnit[ix].caudspill = this.vec_xtempabs[off1 + ix];
        }
        off = this.numvarEl + 3 * this.resHydUnit.length + 2 * this.serHydUnit.length;
        off1 = off + this.irrHydUnit.length;
        for (ix = 0; ix < this.irrHydUnit.length; ++ix) {
            this.irrHydUnit[ix].caudaffl = this.sumQAffl(this.irraff[ix]) + this.vec_xtempabs[off1 + ix];
            this.irrHydUnit[ix].caudgener = this.irrHydUnit[ix].getSpillmax();
            this.irrHydUnit[ix].caudspill = this.vec_xtempabs[off + ix];
        }
        if (this.writeSolFile) {
            try {
                FileOutputStream resOS = new FileOutputStream(new File(this.outResPath));
                PrintWriter myPW = new PrintWriter(resOS);
                String auxString = "";
                myPW.println("Results for System: " + this.ActSchematic.getsysname());
                auxString = this.cuadLossModel ? "Quadratic" : "Sinusoidal";
                myPW.println("Loss Model : " + auxString);
                myPW.println("\nLoad Results");
                myPW.println("Name,UnServP [MW]");
                for (ix = 0; ix < this.loads.length; ++ix) {
                    myPW.println(this.loads[ix].getName() + "," + this.loads[ix].getunser_p());
                }
                myPW.println("\nGenerator Results");
                myPW.println("Name,GenP [MW]");
                for (ix = 0; ix < this.geners.length; ++ix) {
                    myPW.println(this.geners[ix].getName() + "," + this.geners[ix].getp());
                }
                myPW.println("\nBusbar Results");
                myPW.println("Name,Angle [deg],Spot Price [US$/MWh]");
                for (ix = 0; ix < this.busbars.length; ++ix) {
                    myPW.println(this.busbars[ix].getName() + "," + this.busbars[ix].getdelta2() + "," + this.busbars[ix].getspot_p());
                }
                myPW.println("\nLine Results");
                myPW.println("Name,Bus1,Bus2,Flux12 [MW],Flux21 [MW],Loss [MW]");
                for (ix = 0; ix < this.lines.length; ++ix) {
                    con1 = this.BranchI[ix];
                    con2 = this.BranchJ[ix];
                    myPW.println(this.lines[ix].getName() + "," + this.busbars[con1].getName() + "," + this.busbars[con2].getName() + "," + this.lines[ix].getp12() * this.sref + "," + this.lines[ix].getp21() * this.sref + "," + Math.abs(this.lines[ix].getp12() + this.lines[ix].getp21()) * this.sref);
                }
                if (this.trafos.length > 0) {
                    myPW.println("\nTrafo Results");
                    myPW.println("Name,Bus1,Bus2,Flux12 [MW],Flux21 [MW],Loss [MW]");
                }
                to = this.lines.length + this.trafos.length;
                while (ix < to) {
                    con1 = this.BranchI[ix];
                    con2 = this.BranchJ[ix];
                    myPW.println(this.trafos[ix - this.lines.length].getName() + "," + this.busbars[con1].getName() + "," + this.busbars[con2].getName() + "," + this.trafos[ix - this.lines.length].getp12() * this.sref + "," + this.trafos[ix - this.lines.length].getp21() * this.sref + "," + Math.abs(this.trafos[ix - this.lines.length].getp12() + this.trafos[ix - this.lines.length].getp21()) * this.sref);
                    ++ix;
                }
                if (this.ppHydUnit.length > 0) {
                    myPW.println("\nRunOfRiver Hydro Units Results");
                    myPW.println("Name,ElecGen,Qgen [m3/s],Qsp [m3/s], Qaff[m3/s]");
                }
                for (ix = 0; ix < this.ppHydUnit.length; ++ix) {
                    auxString = this.ppEleGen.length < ix ? this.ppEleGen[ix].getName() : "nec";
                    myPW.println(this.ppHydUnit[ix].getName() + "," + auxString + "," + this.ppHydUnit[ix].caudgener + "," + this.ppHydUnit[ix].caudspill + "," + this.ppHydUnit[ix].caudaffl);
                }
                if (this.resHydUnit.length > 0) {
                    myPW.println("\nReservoir  Hydro Units Results");
                    myPW.println("Name,ElecGen,Qgen [m3/s],Qsp [m3/s], Qfil [m3/s], Qaff[m3/s], Vini[Mm3], Vfin[Mm3]");
                }
                for (ix = 0; ix < this.resHydUnit.length; ++ix) {
                    auxString = ix < this.resEleGen.length ? this.resEleGen[ix].getName() : "nec";
                    myPW.println(this.resHydUnit[ix].getName() + "," + auxString + "," + this.resHydUnit[ix].caudgener + "," + this.resHydUnit[ix].caudspill + "," + this.resHydUnit[ix].caudfilt + "," + this.resHydUnit[ix].caudaffl + "," + this.resHydUnit[ix].Vini + "," + this.resHydUnit[ix].Vfin);
                }
                if (this.serHydUnit.length > 0) {
                    myPW.println("\nSeries Hydro Units Results");
                    myPW.println("Name,ElecGen,Qgen [m3/s],Qsp [m3/s], Qaff[m3/s]");
                }
                for (ix = 0; ix < this.serHydUnit.length; ++ix) {
                    auxString = ix < this.serEleGen.length ? this.serEleGen[ix].getName() : "nec";
                    myPW.println(this.serHydUnit[ix].getName() + "," + auxString + "," + this.serHydUnit[ix].caudgener + "," + this.serHydUnit[ix].caudspill + "," + this.serHydUnit[ix].caudaffl);
                }
                if (this.irrHydUnit.length > 0) {
                    myPW.println("\nIrrigation Hydro Units Results");
                    myPW.println("Name,Qext [m3/s],Qrem [m3/s], Qaff[m3/s], Qfault[m3/s]");
                }
                off1 = this.numvarEl + 3 * this.resHydUnit.length + 2 * this.serHydUnit.length + this.irrHydUnit.length;
                for (ix = 0; ix < this.irrHydUnit.length; ++ix) {
                    this.irrHydUnit[ix].caudaffl = this.sumQAffl(this.irraff[ix]) + this.vec_xtempabs[off1 + ix];
                    this.irrHydUnit[ix].caudgener = this.irrHydUnit[ix].getSpillmax();
                    this.irrHydUnit[ix].caudspill = this.vec_xtempabs[off + ix];
                    myPW.println(this.irrHydUnit[ix].getName() + "," + this.irrHydUnit[ix].caudgener + "," + this.irrHydUnit[ix].caudspill + "," + (this.irrHydUnit[ix].caudaffl - this.vec_xtempabs[off1 + ix]) + "," + this.vec_xtempabs[off1 + ix]);
                }
                myPW.close();
                resOS.close();
            }
            catch (FileNotFoundException e) {
                System.out.println(e);
            }
            catch (IOException e) {
                System.out.println(e);
            }
        }
    }

    public void setSolverParam(int solverOpIndex, int iterOpIndex, int tolRHSIndex, int tolCostOpIndex) {
        if (solverOpIndex == 0) {
            this.metodo = 1;
        } else if (solverOpIndex == 1) {
            this.metodo = 2;
        }
        this.iteraciones = Integer.parseInt(maxIterOptions[iterOpIndex]);
        this.tolfeas = Double.parseDouble(maxRHSTolOptions[tolRHSIndex]);
        this.tolcost = Double.parseDouble(maxRHSTolOptions[tolCostOpIndex]);
    }

    public void setModelParam(double duration, boolean linr, boolean lossMod) {
        this.dTb = duration;
        this.islinres = linr;
        this.cuadLossModel = lossMod;
    }

    public void IdidntRealize() {
        this.MyHTGLEDFrame = null;
        this.MatG = null;
        this.MatX = null;
        this.BranchR = null;
        this.BranchX = null;
        this.BranchB = null;
        this.BranchI = null;
        this.BranchJ = null;
        this.VarNode = null;
        this.vec_xminabs = null;
        this.vec_xmaxabs = null;
        this.vec_xmin = null;
        this.vec_xmax = null;
        this.vec_xtemp = null;
        this.vec_xtempabs = null;
        this.vec_c = null;
        this.vec_RHS = null;
        this.vec_Grad = null;
        this.vec_lam = null;
        this.DiagMat_Q = null;
        this.nod_Pdem = null;
        this.vec_clave = null;
        this.mat_W = null;
        this.mat_A = null;
    }

    private void initLSSchemObj(PrintStream myPrintStream) throws Exception {
        comp tempcomp;
        int ix;
        Vector<comp> ppHUVec = new Vector<comp>(10);
        Vector<comp> afflVec = new Vector<comp>(30);
        Vector<comp> serHUVecNoGr = new Vector<comp>(20);
        Vector<comp> serHUVecGnd = new Vector<comp>(20);
        Vector<comp> resHUVecNoGr = new Vector<comp>(10);
        Vector<comp> resHUVecGnd = new Vector<comp>(10);
        Vector<comp> irrHUVec = new Vector<comp>(15);
        Vector<comp> eleGenVec = new Vector<comp>(70);
        Vector<comp> injGenVec = new Vector<comp>(20);
        Vector<comp> lineVec = new Vector<comp>(70);
        Vector<comp> trafoVec = new Vector<comp>(20);
        Vector<comp> busbarVec = new Vector<comp>(70);
        Vector<comp> loadVec = new Vector<comp>(70);
        Object tempGen = null;
        Object temphdb = null;
        hdb_ser tempSer = null;
        hdb_res tempRes = null;
        hdb_irr tempIrr = null;
        Object tempInj = null;
        Line TempLine = null;
        for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
            tempcomp = (comp)this.ActSchematic.Components.elementAt(ix);
            if (!tempcomp.getinservice()) continue;
            if (tempcomp instanceof hdb_link) {
                ((hdb_link)tempcomp).InformEndComponents();
                continue;
            }
            if (tempcomp instanceof ndb_1pol) {
                ((ndb_1pol)tempcomp).InformAllComponents();
                continue;
            }
            if (tempcomp instanceof Trafo) {
                ((Trafo)tempcomp).InformAllComponents();
                continue;
            }
            if (!(tempcomp instanceof Line)) continue;
            TempLine = (Line)tempcomp;
            TempLine.InformPartner(TempLine.ConnComps1, TempLine.getx1(), TempLine.gety1(), 1);
            TempLine.InformPartner(TempLine.ConnComps2, TempLine.getx2(), TempLine.gety2(), 2);
        }
        for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
            tempcomp = (comp)this.ActSchematic.Components.elementAt(ix);
            if (!tempcomp.getinservice()) continue;
            if (tempcomp instanceof hdb_comp) {
                if (tempcomp instanceof hdb_affl) {
                    afflVec.add(tempcomp);
                    continue;
                }
                if (!(tempcomp instanceof hdb_unit)) continue;
                ((hdb_unit)tempcomp).InformRiverUpComps();
                if (tempcomp instanceof hdb_paspur) {
                    ppHUVec.add(tempcomp);
                    continue;
                }
                if (tempcomp instanceof hdb_irr) {
                    irrHUVec.add(tempcomp);
                    tempIrr = (hdb_irr)tempcomp;
                    tempIrr.InformRecipients();
                    continue;
                }
                if (tempcomp instanceof hdb_res) {
                    tempRes = (hdb_res)tempcomp;
                    tempRes.InformRecipients();
                    if (tempRes.getgrounded()) {
                        resHUVecGnd.add(tempcomp);
                        continue;
                    }
                    resHUVecNoGr.add(tempcomp);
                    continue;
                }
                if (!(tempcomp instanceof hdb_ser)) continue;
                tempSer = (hdb_ser)tempcomp;
                tempSer.InformRecipients();
                if (tempSer.getgrounded()) {
                    serHUVecGnd.add(tempcomp);
                    continue;
                }
                serHUVecNoGr.add(tempcomp);
                continue;
            }
            if (tempcomp instanceof Generator) {
                eleGenVec.add(tempcomp);
                continue;
            }
            if (tempcomp instanceof ndb_inj) {
                injGenVec.add(tempcomp);
                continue;
            }
            if (tempcomp instanceof Line) {
                lineVec.add(tempcomp);
                continue;
            }
            if (tempcomp instanceof Trafo) {
                trafoVec.add(tempcomp);
                continue;
            }
            if (tempcomp instanceof Busbar) {
                busbarVec.add(tempcomp);
                continue;
            }
            if (!(tempcomp instanceof Load)) continue;
            loadVec.add(tempcomp);
        }
        this.injGen = new Injection[injGenVec.size()];
        for (ix = 0; ix < injGenVec.size(); ++ix) {
            this.injGen[ix] = (Injection)injGenVec.elementAt(ix);
        }
        this.lines = new Line[lineVec.size()];
        for (ix = 0; ix < lineVec.size(); ++ix) {
            this.lines[ix] = (Line)lineVec.elementAt(ix);
        }
        this.trafos = new Trafo[trafoVec.size()];
        for (ix = 0; ix < trafoVec.size(); ++ix) {
            this.trafos[ix] = (Trafo)trafoVec.elementAt(ix);
        }
        this.busbars = new Busbar[busbarVec.size()];
        for (ix = 0; ix < busbarVec.size(); ++ix) {
            this.busbars[ix] = (Busbar)busbarVec.elementAt(ix);
        }
        this.loads = new Load[loadVec.size()];
        for (ix = 0; ix < loadVec.size(); ++ix) {
            this.loads[ix] = (Load)loadVec.elementAt(ix);
        }
        this.irrHydUnit = new hdb_irr[irrHUVec.size()];
        for (ix = 0; ix < irrHUVec.size(); ++ix) {
            this.irrHydUnit[ix] = (hdb_irr)irrHUVec.elementAt(ix);
        }
        this.ppHydUnit = new hdb_paspur[ppHUVec.size()];
        for (ix = 0; ix < ppHUVec.size(); ++ix) {
            this.ppHydUnit[ix] = (hdb_paspur)ppHUVec.elementAt(ix);
        }
        this.serHydUnit = new hdb_ser[serHUVecGnd.size() + serHUVecNoGr.size()];
        for (ix = 0; ix < serHUVecNoGr.size(); ++ix) {
            this.serHydUnit[ix] = (hdb_ser)serHUVecNoGr.elementAt(ix);
        }
        for (ix = 0; ix < serHUVecGnd.size(); ++ix) {
            this.serHydUnit[serHUVecNoGr.size() + ix] = (hdb_ser)serHUVecGnd.elementAt(ix);
        }
        this.resHydUnit = new hdb_res[resHUVecGnd.size() + resHUVecNoGr.size()];
        for (ix = 0; ix < resHUVecNoGr.size(); ++ix) {
            this.resHydUnit[ix] = (hdb_res)resHUVecNoGr.elementAt(ix);
        }
        for (ix = 0; ix < resHUVecGnd.size(); ++ix) {
            this.resHydUnit[resHUVecNoGr.size() + ix] = (hdb_res)resHUVecGnd.elementAt(ix);
        }
        this.ppEleGen = new Generator[this.ppHydUnit.length];
        for (ix = 0; ix < this.ppHydUnit.length; ++ix) {
            this.ppEleGen[ix] = (Generator)this.extractComp(this.ppHydUnit[ix].getName(), eleGenVec);
        }
        this.serEleGen = new Generator[serHUVecNoGr.size()];
        for (ix = 0; ix < this.serEleGen.length; ++ix) {
            this.serEleGen[ix] = (Generator)this.extractComp(this.serHydUnit[ix].getName(), eleGenVec);
        }
        this.resEleGen = new Generator[resHUVecNoGr.size()];
        for (ix = 0; ix < this.resEleGen.length; ++ix) {
            this.resEleGen[ix] = (Generator)this.extractComp(this.resHydUnit[ix].getName(), eleGenVec);
        }
        this.thermalGen = new Generator[eleGenVec.size()];
        for (ix = 0; ix < this.thermalGen.length; ++ix) {
            this.thermalGen[ix] = (Generator)eleGenVec.elementAt(ix);
        }
        int sx = this.injGen.length + this.thermalGen.length + this.ppEleGen.length + this.resEleGen.length + this.serEleGen.length;
        this.geners = new ndb_inj[sx];
        sx = 0;
        for (ix = 0; ix < this.injGen.length; ++ix) {
            this.geners[ix] = this.injGen[ix];
        }
        sx = this.injGen.length;
        for (ix = 0; ix < this.thermalGen.length; ++ix) {
            this.geners[sx + ix] = this.thermalGen[ix];
        }
        sx += this.thermalGen.length;
        for (ix = 0; ix < this.ppEleGen.length; ++ix) {
            this.geners[sx + ix] = this.ppEleGen[ix];
        }
        sx += this.ppEleGen.length;
        for (ix = 0; ix < this.resEleGen.length; ++ix) {
            this.geners[sx + ix] = this.resEleGen[ix];
        }
        sx += this.resEleGen.length;
        for (ix = 0; ix < this.serEleGen.length; ++ix) {
            this.geners[sx + ix] = this.serEleGen[ix];
        }
        this.irraff = new hdb_affl[this.irrHydUnit.length][0];
        this.ppaff = new hdb_affl[this.ppHydUnit.length][0];
        this.seraff = new hdb_affl[this.serHydUnit.length][0];
        this.resaff = new hdb_affl[this.resHydUnit.length][0];
        Vector<comp> tempVec = new Vector<comp>(10);
        for (ix = 0; ix < this.irrHydUnit.length; ++ix) {
            for (sx = 0; sx < this.irrHydUnit[ix].riverUpComps.size(); ++sx) {
                tempcomp = (comp)this.irrHydUnit[ix].riverUpComps.elementAt(sx);
                if (!(tempcomp instanceof hdb_affl)) continue;
                tempVec.addElement(tempcomp);
            }
            this.irraff[ix] = new hdb_affl[tempVec.size()];
            for (sx = 0; sx < this.irraff[ix].length; ++sx) {
                this.irraff[ix][sx] = (hdb_affl)tempVec.elementAt(sx);
                this.extractComp(this.irraff[ix][sx].getName(), afflVec);
            }
            tempVec.removeAllElements();
        }
        for (ix = 0; ix < this.ppHydUnit.length; ++ix) {
            for (sx = 0; sx < this.ppHydUnit[ix].riverUpComps.size(); ++sx) {
                tempcomp = (comp)this.ppHydUnit[ix].riverUpComps.elementAt(sx);
                if (!(tempcomp instanceof hdb_affl)) continue;
                tempVec.addElement(tempcomp);
            }
            this.ppaff[ix] = new hdb_affl[tempVec.size()];
            for (sx = 0; sx < this.ppaff[ix].length; ++sx) {
                this.ppaff[ix][sx] = (hdb_affl)tempVec.elementAt(sx);
                this.extractComp(this.ppaff[ix][sx].getName(), afflVec);
            }
            tempVec.removeAllElements();
        }
        for (ix = 0; ix < this.serHydUnit.length; ++ix) {
            for (sx = 0; sx < this.serHydUnit[ix].riverUpComps.size(); ++sx) {
                tempcomp = (comp)this.serHydUnit[ix].riverUpComps.elementAt(sx);
                if (!(tempcomp instanceof hdb_affl)) continue;
                tempVec.addElement(tempcomp);
            }
            this.seraff[ix] = new hdb_affl[tempVec.size()];
            for (sx = 0; sx < this.seraff[ix].length; ++sx) {
                this.seraff[ix][sx] = (hdb_affl)tempVec.elementAt(sx);
                this.extractComp(this.seraff[ix][sx].getName(), afflVec);
            }
            tempVec.removeAllElements();
        }
        for (ix = 0; ix < this.resHydUnit.length; ++ix) {
            for (sx = 0; sx < this.resHydUnit[ix].riverUpComps.size(); ++sx) {
                tempcomp = (comp)this.resHydUnit[ix].riverUpComps.elementAt(sx);
                if (!(tempcomp instanceof hdb_affl)) continue;
                tempVec.addElement(tempcomp);
            }
            this.resaff[ix] = new hdb_affl[tempVec.size()];
            for (sx = 0; sx < this.resaff[ix].length; ++sx) {
                this.resaff[ix][sx] = (hdb_affl)tempVec.elementAt(sx);
                this.extractComp(this.resaff[ix][sx].getName(), afflVec);
            }
            tempVec.removeAllElements();
        }
    }

    private void makeHSubMatrix(PrintStream myPrintStream) throws Exception {
        hdb_unit temphun;
        int row;
        int col;
        int ix;
        int numfil = this.resHydUnit.length + this.serHydUnit.length + this.irrHydUnit.length;
        int numcol = 3 * this.resHydUnit.length + 2 * this.serHydUnit.length + 2 * this.irrHydUnit.length;
        this.HCx = new double[numfil][numcol];
        int rowbias = 0;
        int colbias1 = 0;
        int colbias2 = this.resHydUnit.length + this.serHydUnit.length;
        int colbias3 = 2 * colbias2;
        for (ix = 0; ix < this.resHydUnit.length; ++ix) {
            col = ix;
            row = ix;
            this.HCx[row][col] = 1.0;
            temphun = this.resHydUnit[ix].getTurbRecComp();
            if (temphun != null) {
                row = this.getRecipientRow(temphun);
                this.HCx[row][col] = -1.0;
            }
            col = ix + colbias2;
            row = ix;
            this.HCx[row][col] = 1.0;
            temphun = this.resHydUnit[ix].getSpilRecComp();
            if (temphun != null) {
                row = this.getRecipientRow(temphun);
                this.HCx[row][col] = -1.0;
            }
            col = ix + colbias3;
            row = ix;
            this.HCx[row][col] = 1.0;
            temphun = this.resHydUnit[ix].getFiltRecComp();
            if (temphun == null) continue;
            row = this.getRecipientRow(temphun);
            this.HCx[row][col] = -1.0;
        }
        rowbias = this.resHydUnit.length;
        colbias1 = this.resHydUnit.length;
        colbias2 = 2 * this.resHydUnit.length + this.serHydUnit.length;
        for (ix = 0; ix < this.serHydUnit.length; ++ix) {
            col = ix + colbias1;
            row = ix + rowbias;
            this.HCx[row][col] = 1.0;
            temphun = this.serHydUnit[ix].getTurbRecComp();
            if (temphun != null) {
                row = this.getRecipientRow(temphun);
                this.HCx[row][col] = -1.0;
            }
            col = ix + colbias2;
            row = ix + rowbias;
            this.HCx[row][col] = 1.0;
            temphun = this.serHydUnit[ix].getSpilRecComp();
            if (temphun == null) continue;
            row = this.getRecipientRow(temphun);
            this.HCx[row][col] = -1.0;
        }
        rowbias = this.resHydUnit.length + this.serHydUnit.length;
        colbias1 = 3 * this.resHydUnit.length + 2 * this.serHydUnit.length;
        colbias2 = colbias1 + this.irrHydUnit.length;
        for (ix = 0; ix < this.irrHydUnit.length; ++ix) {
            col = ix + colbias1;
            row = ix + rowbias;
            this.HCx[row][col] = 1.0;
            temphun = this.irrHydUnit[ix].getTurbRecComp();
            if (temphun != null) {
                row = this.getRecipientRow(temphun);
                this.HCx[row][col] = -1.0;
            }
            col = ix + colbias2;
            row = ix + rowbias;
            this.HCx[row][col] = -1.0;
        }
        this.mDrE = new double[this.resEleGen.length];
        for (ix = 0; ix < this.resEleGen.length; ++ix) {
            this.mDrE[ix] = this.resHydUnit[ix].getWat2PowRate() / this.sref;
        }
        this.mDrS = new double[this.serEleGen.length];
        for (ix = 0; ix < this.serEleGen.length; ++ix) {
            this.mDrS[ix] = this.serHydUnit[ix].getWat2PowRate() / this.sref;
        }
        this.mDbvE = new double[this.resHydUnit.length];
        this.mDfE = new double[this.resHydUnit.length];
        for (ix = 0; ix < this.resHydUnit.length; ++ix) {
            double capacity = (this.resHydUnit[ix].getVmax() - this.resHydUnit[ix].getVmin()) * 1000.0 / 3.6;
            this.mDbvE[ix] = capacity / this.dTb;
            this.mDfE[ix] = this.resHydUnit[ix].getFiltType() > 0 ? this.mDbvE[ix] * this.resHydUnit[ix].getAvfiltf() / 2.0 * this.dTb / 730.0 : 0.0;
        }
    }

    private void loadBCs() {
        this.vBC = new Vector();
        double[] points = new double[this.resHydUnit.length];
        double[] slopes = new double[this.resHydUnit.length];
        double capa = 0.0;
        for (int ix = 0; ix < this.resHydUnit.length; ++ix) {
            capa = this.resHydUnit[ix].getVmax() - this.resHydUnit[ix].getVmin();
            slopes[ix] = this.resHydUnit[ix].getWaterVal() * capa * 1000.0;
        }
        this.vBC.add(new SEEDS_BendCut(slopes, points, 1.0E9));
    }

    private void buildEndEFCFfRVLS(double[][] resEFCFP, String resName) {
        int ix;
        if (resEFCFP.length == 0) {
            return;
        }
        int resPos = -1;
        for (ix = 0; ix < this.resHydUnit.length; ++ix) {
            if (!resName.equals(this.resHydUnit[ix].getName())) continue;
            resPos = ix;
            break;
        }
        if (resPos == -1) {
            return;
        }
        double[] aproxSlopes = new double[this.resHydUnit.length];
        double[] aproxPoints = new double[this.resHydUnit.length];
        for (ix = 0; ix < this.resHydUnit.length; ++ix) {
            aproxSlopes[ix] = 0.0;
            aproxPoints[ix] = 1.0;
        }
        double aproxFC = 0.0;
        double prevV = 1.0;
        double prevS = resEFCFP[resEFCFP.length - 1][1];
        for (int k = resEFCFP.length - 1; k > -1; --k) {
            aproxPoints[resPos] = resEFCFP[k][0];
            aproxSlopes[resPos] = -resEFCFP[k][1];
            this.vBC.add(new SEEDS_BendCut(aproxSlopes, aproxPoints, aproxFC += (resEFCFP[k][1] + prevS) * (prevV - resEFCFP[k][0]) / 2.0));
            prevV = resEFCFP[k][0];
            prevS = resEFCFP[k][1];
        }
    }

    private comp extractComp(String compName, Vector compVec) throws HTGLEDException {
        comp comp2ret = null;
        for (int pos = 0; pos < compVec.size(); ++pos) {
            if (!compName.equals(((comp)compVec.elementAt(pos)).getName())) continue;
            comp2ret = (comp)compVec.elementAt(pos);
            compVec.remove(pos);
            return comp2ret;
        }
        throw new HTGLEDException("Object's name'" + compName + "' not found in Vector of components.");
    }

    private int findArrPos(comp comp2find, Object[] arrComp) throws HTGLEDException {
        for (int pos = 0; pos < arrComp.length; ++pos) {
            if (comp2find != arrComp[pos]) continue;
            return pos;
        }
        throw new HTGLEDException("Index of '" + comp2find.getName() + "' component not found in array.");
    }

    private int getRecipientRow(hdb_comp temphdb) throws HTGLEDException {
        int row = -1;
        if (temphdb instanceof hdb_res) {
            row = this.findArrPos(temphdb, this.resHydUnit);
        } else if (temphdb instanceof hdb_ser) {
            row = this.resHydUnit.length + this.findArrPos(temphdb, this.serHydUnit);
        } else if (temphdb instanceof hdb_irr) {
            row = this.resHydUnit.length + this.serHydUnit.length + this.findArrPos(temphdb, this.irrHydUnit);
        } else {
            throw new HTGLEDException("Hydro recipient object '" + temphdb.getName() + "' is not allowed.");
        }
        return row;
    }

    private double sumQAffl(hdb_affl[] aff) {
        double sum = 0.0;
        for (int i = 0; i < aff.length; ++i) {
            sum += aff[i].getQ();
        }
        return sum;
    }
}

