/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Polygon;

public class GraphicsUtil {
    public static void drawArc(Graphics2D g, int left, int top, int width, int height, int startAngle, int deltaAngle, int lineWidth) {
        left -= lineWidth / 2;
        top -= lineWidth / 2;
        width += lineWidth;
        height += lineWidth;
        for (int I = 0; I < lineWidth; ++I) {
            g.drawArc(left, top, width, height, startAngle, deltaAngle);
            if (I + 1 >= lineWidth) continue;
            g.drawArc(left, top, width - 1, height - 1, startAngle, deltaAngle);
            g.drawArc(left + 1, top, width - 1, height - 1, startAngle, deltaAngle);
            g.drawArc(left, top + 1, width - 1, height - 1, startAngle, deltaAngle);
            g.drawArc(left + 1, top + 1, width - 1, height - 1, startAngle, deltaAngle);
            ++left;
            ++top;
            width -= 2;
            height -= 2;
        }
    }

    public static void drawArc(Graphics2D g, int left, int top, int width, int height, int startAngle, int deltaAngle, int lineWidth, Color c) {
        Color origColor = g.getColor();
        g.setColor(c);
        GraphicsUtil.drawArc(g, left, top, width, height, startAngle, deltaAngle, lineWidth);
        g.setColor(origColor);
    }

    public static void drawArc(Graphics2D g, int left, int top, int width, int height, int startAngle, int deltaAngle, Color c) {
        Color origColor = g.getColor();
        g.setColor(c);
        g.drawArc(left, top, width, height, startAngle, deltaAngle);
        g.setColor(origColor);
    }

    public static void fillArc(Graphics2D g, int left, int top, int width, int height, int startAngle, int deltaAngle, Color c) {
        Color origColor = g.getColor();
        g.setColor(c);
        g.fillArc(left, top, width, height, startAngle, deltaAngle);
        g.setColor(origColor);
    }

    public static void drawChars(Graphics2D g, char[] chars, int start, int numChars, int x, int y, Color c) {
        Color origColor = g.getColor();
        g.setColor(c);
        g.drawChars(chars, start, numChars, x, y);
        g.setColor(origColor);
    }

    public static void drawChars(Graphics2D g, char[] chars, int start, int numChars, int x, int y, Font f) {
        Font origFont = g.getFont();
        g.setFont(f);
        g.drawChars(chars, start, numChars, x, y);
        g.setFont(origFont);
    }

    public static void drawChars(Graphics2D g, char[] chars, int start, int numChars, int x, int y, Font f, Color c) {
        Font origFont = g.getFont();
        g.setFont(f);
        GraphicsUtil.drawChars(g, chars, start, numChars, x, y, c);
        g.setFont(origFont);
    }

    public static void drawCircle(Graphics2D g, int x, int y, int r) {
        g.drawOval(x - r, y - r, 2 * r, 2 * r);
    }

    public static void drawCircle(Graphics2D g, int x, int y, int r, int lineWidth) {
        r += lineWidth / 2;
        for (int I = 0; I < lineWidth; ++I) {
            GraphicsUtil.drawCircle(g, x, y, r);
            if (I + 1 >= lineWidth) continue;
            GraphicsUtil.drawCircle(g, x + 1, y, r - 1);
            GraphicsUtil.drawCircle(g, x - 1, y, r - 1);
            GraphicsUtil.drawCircle(g, x, y + 1, r - 1);
            GraphicsUtil.drawCircle(g, x, y - 1, r - 1);
            --r;
        }
    }

    public static void drawCircle(Graphics2D g, int x, int y, int r, int lineWidth, Color c) {
        Color origColor = g.getColor();
        g.setColor(c);
        GraphicsUtil.drawCircle(g, x, y, r, lineWidth);
        g.setColor(origColor);
    }

    public static void drawCircle(Graphics2D g, int x, int y, int r, Color c) {
        GraphicsUtil.drawCircle(g, x, y, r, 1, c);
    }

    public static void fillCircle(Graphics2D g, int x, int y, int r) {
        g.fillOval(x - r, y - r, 2 * r, 2 * r);
    }

    public static void fillCircle(Graphics2D g, int x, int y, int r, Color c) {
        Color origColor = g.getColor();
        g.setColor(c);
        GraphicsUtil.fillCircle(g, x, y, r);
        g.setColor(origColor);
    }

    public static void drawLine(Graphics2D g, int x1, int y1, int x2, int y2, int lineWidth) {
        double Delta_x = x2 - x1;
        double Delta_y = y2 - y1;
        double R = (double)lineWidth / 2.0;
        double angle = x1 == x2 ? Math.PI : Math.atan(Delta_y / Delta_x) + 1.5707963267948966;
        double cosAngle = Math.cos(angle);
        double sinAngle = Math.sin(angle);
        double tan1Angle = Math.tan(angle + 0.7853981633974483);
        double tan2Angle = Math.tan(angle - 0.7853981633974483);
        x1 -= (int)(R * cosAngle);
        x2 -= (int)(R * cosAngle);
        y1 -= (int)(R * sinAngle);
        y2 -= (int)(R * sinAngle);
        for (int I = 0; I < lineWidth; ++I) {
            double Double_I = I;
            g.drawLine(x1 + (int)(Double_I * cosAngle), y1 + (int)(Double_I * sinAngle), x2 + (int)(Double_I * cosAngle), y2 + (int)(Double_I * sinAngle));
            if (I + 1 >= lineWidth) continue;
            g.drawLine(x1 + 1 + (int)(Double_I * cosAngle), y1 + (int)(Double_I * sinAngle), x2 + 1 + (int)(Double_I * cosAngle), y2 + (int)(Double_I * sinAngle));
        }
    }

    public static void drawArrow(Graphics2D g, int x1, int y1, int x2, int y2, int lineWidth, int arrowlenght) {
        double angle1;
        double angle;
        double Delta_x = x2 - x1;
        double Delta_y = y2 - y1;
        double R = (double)lineWidth / 2.0;
        double tan1Anglex = 0.0;
        double tan2Anglex = 0.0;
        double tan1Angley = 0.0;
        double tan2Angley = 0.0;
        if (x1 == x2) {
            angle = Math.PI;
            angle1 = y2 <= y1 ? 1.5707963267948966 : -1.5707963267948966;
        } else {
            angle = Math.atan(Delta_y / Delta_x) + 1.5707963267948966;
            angle1 = -Math.atan(Delta_y / Delta_x);
        }
        double cosAngle = Math.cos(angle);
        double sinAngle = Math.sin(angle);
        if (Math.abs(angle1 - 0.7853981633974483) == 1.5707963267948966) {
            tan1Anglex = 0.0;
            tan1Angley = arrowlenght;
            tan2Anglex = Math.sqrt((double)(arrowlenght * arrowlenght) / (1.0 + Math.tan(angle1 + 0.7853981633974483) * Math.tan(angle1 + 0.7853981633974483)));
            tan2Angley = Math.tan(angle1 + 0.7853981633974483) * Math.sqrt((double)(arrowlenght * arrowlenght) / (1.0 + Math.tan(angle1 + 0.7853981633974483) * Math.tan(angle1 + 0.7853981633974483)));
        }
        if (Math.abs(angle1 + 0.7853981633974483) == 1.5707963267948966) {
            tan1Anglex = Math.sqrt((double)(arrowlenght * arrowlenght) / (1.0 + Math.tan(angle1 - 0.7853981633974483) * Math.tan(angle1 - 0.7853981633974483)));
            tan1Angley = Math.tan(angle1 - 0.7853981633974483) * Math.sqrt((double)(arrowlenght * arrowlenght) / (1.0 + Math.tan(angle1 - 0.7853981633974483) * Math.tan(angle1 - 0.7853981633974483)));
            tan2Anglex = 0.0;
            tan2Angley = -arrowlenght;
        }
        if (Math.abs(angle1 + 0.7853981633974483) != 1.5707963267948966 && Math.abs(angle1 - 0.7853981633974483) != 1.5707963267948966) {
            tan1Anglex = Math.sqrt((double)(arrowlenght * arrowlenght) / (1.0 + Math.tan(angle1 - 0.7853981633974483) * Math.tan(angle1 - 0.7853981633974483)));
            tan1Angley = Math.tan(angle1 - 0.7853981633974483) * Math.sqrt((double)(arrowlenght * arrowlenght) / (1.0 + Math.tan(angle1 - 0.7853981633974483) * Math.tan(angle1 - 0.7853981633974483)));
            tan2Anglex = Math.sqrt((double)(arrowlenght * arrowlenght) / (1.0 + Math.tan(angle1 + 0.7853981633974483) * Math.tan(angle1 + 0.7853981633974483)));
            tan2Angley = Math.tan(angle1 + 0.7853981633974483) * Math.sqrt((double)(arrowlenght * arrowlenght) / (1.0 + Math.tan(angle1 + 0.7853981633974483) * Math.tan(angle1 + 0.7853981633974483)));
        }
        x1 -= (int)(R * cosAngle);
        x2 -= (int)(R * cosAngle);
        y1 -= (int)(R * sinAngle);
        y2 -= (int)(R * sinAngle);
        for (int I = 0; I < lineWidth; ++I) {
            double Double_I = I;
            g.drawLine(x1 + (int)(Double_I * cosAngle), y1 + (int)(Double_I * sinAngle), x2 + (int)(Double_I * cosAngle), y2 + (int)(Double_I * sinAngle));
            if (I + 1 >= lineWidth) continue;
            g.drawLine(x1 + 1 + (int)(Double_I * cosAngle), y1 + (int)(Double_I * sinAngle), x2 + 1 + (int)(Double_I * cosAngle), y2 + (int)(Double_I * sinAngle));
        }
        if (Math.abs(angle1) < 0.7853981633974483) {
            if (Delta_x <= 0.0) {
                g.drawLine(x2, y2, x2 + (int)tan1Anglex, y2 - (int)tan1Angley);
                g.drawLine(x2, y2, x2 + (int)tan2Anglex, y2 - (int)tan2Angley);
            } else {
                g.drawLine(x2, y2, x2 - (int)tan1Anglex, y2 + (int)tan1Angley);
                g.drawLine(x2, y2, x2 - (int)tan2Anglex, y2 + (int)tan2Angley);
            }
        } else if (Delta_y >= 0.0) {
            g.drawLine(x2, y2, x2 + (int)tan1Anglex, y2 - (int)tan1Angley);
            g.drawLine(x2, y2, x2 - (int)tan2Anglex, y2 + (int)tan2Angley);
        } else {
            g.drawLine(x2, y2, x2 - (int)tan1Anglex, y2 + (int)tan1Angley);
            g.drawLine(x2, y2, x2 + (int)tan2Anglex, y2 - (int)tan2Angley);
        }
    }

    public static void drawLine(Graphics2D g, int x1, int y1, int x2, int y2, int lineWidth, Color c) {
        Color origColor = g.getColor();
        g.setColor(c);
        GraphicsUtil.drawLine(g, x1, y1, x2, y2, lineWidth);
        g.setColor(origColor);
    }

    public static void drawLine(Graphics2D g, int x1, int y1, int x2, int y2, Color c) {
        GraphicsUtil.drawLine(g, x1, y1, x2, y2, 1, c);
    }

    public static void drawOval(Graphics2D g, int left, int top, int width, int height, int lineWidth) {
        left -= lineWidth / 2;
        top -= lineWidth / 2;
        width += lineWidth;
        height += lineWidth;
        for (int I = 0; I < lineWidth; ++I) {
            g.drawOval(left, top, width, height);
            if (I + 1 >= lineWidth) continue;
            g.drawOval(left, top, width - 1, height - 1);
            g.drawOval(left + 1, top, width - 1, height - 1);
            g.drawOval(left, top + 1, width - 1, height - 1);
            g.drawOval(left + 1, top + 1, width - 1, height - 1);
            ++left;
            ++top;
            width -= 2;
            height -= 2;
        }
    }

    public static void drawOval(Graphics2D g, int left, int top, int width, int height, int lineWidth, Color c) {
        Color origColor = g.getColor();
        g.setColor(c);
        GraphicsUtil.drawOval(g, left, top, width, height, lineWidth);
        g.setColor(origColor);
    }

    public static void drawOval(Graphics2D g, int left, int top, int width, int height, Color c) {
        GraphicsUtil.drawOval(g, left, top, width, height, 1, c);
    }

    public static void fillOval(Graphics2D g, int left, int top, int width, int height, Color c) {
        Color origColor = g.getColor();
        g.setColor(c);
        g.fillOval(left, top, width, height);
        g.setColor(origColor);
    }

    public static void drawPolygon(Graphics2D g, int[] xs, int[] ys, int Num_Points, Color c) {
        Color origColor = g.getColor();
        g.setColor(c);
        g.drawPolygon(xs, ys, Num_Points);
        g.setColor(origColor);
    }

    public static void drawPolygon(Graphics2D g, Polygon P, Color c) {
        Color origColor = g.getColor();
        g.setColor(c);
        g.drawPolygon(P);
        g.setColor(origColor);
    }

    public static void fillPolygon(Graphics2D g, int[] xs, int[] ys, int Num_Points, Color c) {
        Color origColor = g.getColor();
        g.setColor(c);
        g.fillPolygon(xs, ys, Num_Points);
        g.setColor(origColor);
    }

    public static void fillPolygon(Graphics2D g, Polygon P, Color c) {
        Color origColor = g.getColor();
        g.setColor(c);
        g.fillPolygon(P);
        g.setColor(origColor);
    }

    public static void drawRect(Graphics2D g, int left, int top, int width, int height, int lineWidth) {
        left -= lineWidth / 2;
        top -= lineWidth / 2;
        width += lineWidth;
        height += lineWidth;
        for (int I = 0; I < lineWidth; ++I) {
            g.drawRect(left, top, width, height);
            ++left;
            ++top;
            width -= 2;
            height -= 2;
        }
    }

    public static void drawRect(Graphics2D g, int left, int top, int width, int height, int lineWidth, Color c) {
        Color origColor = g.getColor();
        g.setColor(c);
        GraphicsUtil.drawRect(g, left, top, width, height, lineWidth);
        g.setColor(origColor);
    }

    public static void drawRect(Graphics2D g, int left, int top, int width, int height, Color c) {
        GraphicsUtil.drawRect(g, left, top, width, height, 1, c);
    }

    public static void fillRect(Graphics2D g, int left, int top, int width, int height, Color c) {
        Color origColor = g.getColor();
        g.setColor(c);
        g.fillRect(left, top, width, height);
        g.setColor(origColor);
    }

    public static void drawRoundRect(Graphics2D g, int left, int top, int width, int height, int arcWidth, int arcHeight, int lineWidth) {
        left -= lineWidth / 2;
        top -= lineWidth / 2;
        width += lineWidth;
        height += lineWidth;
        for (int I = 0; I < lineWidth; ++I) {
            g.drawRoundRect(left, top, width, height, arcWidth, arcHeight);
            if (I + 1 >= lineWidth) continue;
            g.drawRoundRect(left, top, width - 1, height - 1, arcWidth, arcHeight);
            g.drawRoundRect(left + 1, top, width - 1, height - 1, arcWidth, arcHeight);
            g.drawRoundRect(left, top + 1, width - 1, height - 1, arcWidth, arcHeight);
            g.drawRoundRect(left + 1, top + 1, width - 1, height - 1, arcWidth, arcHeight);
            ++left;
            ++top;
            width -= 2;
            height -= 2;
        }
    }

    public static void drawRoundRect(Graphics2D g, int left, int top, int width, int height, int arcWidth, int arcHeight, int lineWidth, Color c) {
        Color origColor = g.getColor();
        g.setColor(c);
        GraphicsUtil.drawRoundRect(g, left, top, width, height, arcWidth, arcHeight, lineWidth);
        g.setColor(origColor);
    }

    public static void drawRoundRect(Graphics2D g, int left, int top, int width, int height, int arcWidth, int arcHeight, Color c) {
        GraphicsUtil.drawRoundRect(g, left, top, width, height, arcWidth, arcHeight, 1, c);
    }

    public static void fillRoundRect(Graphics2D g, int left, int top, int width, int height, int arcWidth, int arcHeight, Color c) {
        Color origColor = g.getColor();
        g.setColor(c);
        g.fillRoundRect(left, top, width, height, arcWidth, arcHeight);
        g.setColor(origColor);
    }

    public static void draw3DRect(Graphics2D g, int left, int top, int width, int height, boolean isRaised, int lineWidth) {
        left -= lineWidth / 2;
        top -= lineWidth / 2;
        width += lineWidth;
        height += lineWidth;
        for (int I = 0; I < lineWidth; ++I) {
            g.draw3DRect(left, top, width, height, isRaised);
            ++left;
            ++top;
            width -= 2;
            height -= 2;
        }
    }

    public static void draw3DRect(Graphics2D g, int left, int top, int width, int height, boolean isRaised, int lineWidth, Color c) {
        Color origColor = g.getColor();
        g.setColor(c);
        GraphicsUtil.draw3DRect(g, left, top, width, height, isRaised, lineWidth);
        g.setColor(origColor);
    }

    public static void draw3DRect(Graphics2D g, int left, int top, int width, int height, boolean isRaised, Color c) {
        GraphicsUtil.draw3DRect(g, left, top, width, height, isRaised, 1, c);
    }

    public static void fill3DRect(Graphics2D g, int left, int top, int width, int height, boolean isRaised, Color c) {
        Color origColor = g.getColor();
        g.setColor(c);
        g.fill3DRect(left, top, width, height, isRaised);
        g.setColor(origColor);
    }

    public static void drawString(Graphics2D g, String s, int x, int y, Color c) {
        Color origColor = g.getColor();
        g.setColor(c);
        g.drawString(s, x, y);
        g.setColor(origColor);
    }

    public static void drawString(Graphics2D g, String s, int x, int y, Font f) {
        Font origFont = g.getFont();
        g.setFont(f);
        g.drawString(s, x, y);
        g.setFont(origFont);
    }

    public static void drawString(Graphics2D g, String s, int x, int y, Font f, Color c) {
        Font origFont = g.getFont();
        g.setFont(f);
        GraphicsUtil.drawString(g, s, x, y, c);
        g.setFont(origFont);
    }

    public static void drawPipe(Graphics2D g, int x1, int y1, int x2, int y2, int gs, int arrow) {
        double Delta_x = x2 - x1;
        double Delta_y = y2 - y1;
        double angulo = 0.0;
        double L = Math.sqrt(Math.pow((double)gs * Delta_x, 2.0) + Math.pow((double)gs * Delta_y, 2.0));
        double paso_x = 0.0;
        double paso_y = 0.0;
        int npelotas = (int)L / gs / gs;
        if (Delta_x > 0.0 && Delta_y > 0.0) {
            angulo = Math.atan(Delta_y / Delta_x);
        } else if (Delta_x < 0.0 && Delta_y > 0.0) {
            angulo = Math.PI + Math.atan(Delta_y / Delta_x);
        } else if (Delta_x < 0.0 && Delta_y < 0.0) {
            angulo = Math.PI + Math.atan(Delta_y / Delta_x);
        } else if (Delta_x > 0.0 && Delta_y < 0.0) {
            angulo = Math.PI * 2 + Math.atan(Delta_y / Delta_x);
        } else if (Delta_x == 0.0 && Delta_y < 0.0) {
            angulo = -1.5707963267948966;
        } else if (Delta_x == 0.0 && Delta_y > 0.0) {
            angulo = 1.5707963267948966;
        } else if (Delta_x > 0.0 && Delta_y == 0.0) {
            angulo = 0.0;
        } else if (Delta_x < 0.0 && Delta_y == 0.0) {
            angulo = Math.PI;
        }
        paso_x = (double)gs * Math.cos(angulo);
        paso_y = (double)gs * Math.sin(angulo);
        for (int i = 0; i < npelotas; ++i) {
            g.drawOval((int)((double)x1 + (double)i * paso_x - 0.1 * (double)gs), (int)((double)y1 + (double)i * paso_y - 0.1 * (double)gs), (int)(0.2 * (double)gs), (int)(0.2 * (double)gs));
        }
        if (arrow == 1) {
            GraphicsUtil.drawArrow(g, (int)((double)x2 - paso_x), (int)((double)y2 - paso_y), x2, y2, gs, 3 * gs);
        }
    }

    public static void drawTrain(Graphics2D g, int x1, int y1, int x2, int y2, int gs, int arrow) {
        double Delta_x = x2 - x1;
        double Delta_y = y2 - y1;
        double angulo = Math.atan(Delta_x / Delta_y);
        double L = Math.sqrt(Math.pow(Delta_x, 2.0) + Math.pow(Delta_y, 2.0));
        int npelotas = (int)L / gs;
        double paso_x = 0.0;
        double paso_y = 0.0;
        if (Delta_x > 0.0 && Delta_y > 0.0) {
            angulo = Math.atan(Delta_y / Delta_x);
        } else if (Delta_x < 0.0 && Delta_y > 0.0) {
            angulo = Math.PI + Math.atan(Delta_y / Delta_x);
        } else if (Delta_x < 0.0 && Delta_y < 0.0) {
            angulo = Math.PI + Math.atan(Delta_y / Delta_x);
        } else if (Delta_x > 0.0 && Delta_y < 0.0) {
            angulo = Math.PI * 2 + Math.atan(Delta_y / Delta_x);
        } else if (Delta_x == 0.0 && Delta_y < 0.0) {
            angulo = -1.5707963267948966;
        } else if (Delta_x == 0.0 && Delta_y > 0.0) {
            angulo = 1.5707963267948966;
        } else if (Delta_x > 0.0 && Delta_y == 0.0) {
            angulo = 0.0;
        } else if (Delta_x < 0.0 && Delta_y == 0.0) {
            angulo = Math.PI;
        }
        paso_x = (double)gs * Math.cos(angulo);
        paso_y = (double)gs * Math.sin(angulo);
        for (int i = 1; i < npelotas - 1; ++i) {
            g.drawLine((int)((double)x1 + (double)i * paso_x + (double)(gs / 2) * Math.sin(angulo)), (int)((double)y1 + (double)i * paso_y - (double)(gs / 2) * Math.cos(angulo)), (int)((double)x1 + (double)i * paso_x - (double)(gs / 2) * Math.sin(angulo)), (int)((double)y1 + (double)i * paso_y + (double)(gs / 2) * Math.cos(angulo)));
        }
        if (arrow == 1) {
            GraphicsUtil.drawArrow(g, (int)((double)x2 - paso_x), (int)((double)y2 - paso_y), x2, y2, gs, 3 * gs);
        }
    }

    public static void drawTruck(Graphics2D g, int x1, int y1, int x2, int y2, int gs, int arrow) {
        double Delta_x = x2 - x1;
        double Delta_y = y2 - y1;
        double angulo = Math.atan(Delta_x / Delta_y);
        double paso_x = 0.0;
        double paso_y = 0.0;
        if (Delta_x > 0.0 && Delta_y > 0.0) {
            angulo = Math.atan(Delta_y / Delta_x);
        } else if (Delta_x < 0.0 && Delta_y > 0.0) {
            angulo = Math.PI + Math.atan(Delta_y / Delta_x);
        } else if (Delta_x < 0.0 && Delta_y < 0.0) {
            angulo = Math.PI + Math.atan(Delta_y / Delta_x);
        } else if (Delta_x > 0.0 && Delta_y < 0.0) {
            angulo = Math.PI * 2 + Math.atan(Delta_y / Delta_x);
        } else if (Delta_x == 0.0 && Delta_y < 0.0) {
            angulo = -1.5707963267948966;
        } else if (Delta_x == 0.0 && Delta_y > 0.0) {
            angulo = 1.5707963267948966;
        } else if (Delta_x > 0.0 && Delta_y == 0.0) {
            angulo = 0.0;
        } else if (Delta_x < 0.0 && Delta_y == 0.0) {
            angulo = Math.PI;
        }
        paso_x = (double)gs * Math.cos(angulo);
        paso_y = (double)gs * Math.sin(angulo);
        g.drawLine(x1, y1, x2, y2);
        if (arrow == 1) {
            GraphicsUtil.drawArrow(g, (int)((double)x2 - paso_x), (int)((double)y2 - paso_y), x2, y2, gs, 3 * gs);
        }
    }

    public static void drawShip(Graphics2D g, int x1, int y1, int x2, int y2, int gs, int arrow) {
        double Delta_x = x2 - x1;
        double Delta_y = y2 - y1;
        double angulo = Math.atan(Delta_x / Delta_y);
        double L = Math.sqrt(Math.pow(Delta_x, 2.0) + Math.pow(Delta_y, 2.0));
        int npelotas = (int)L / gs;
        double paso_x = 0.0;
        double paso_y = 0.0;
        int px = x1;
        int py = y1;
        if (Delta_x > 0.0 && Delta_y > 0.0) {
            angulo = Math.atan(Delta_y / Delta_x);
        } else if (Delta_x < 0.0 && Delta_y > 0.0) {
            angulo = Math.PI + Math.atan(Delta_y / Delta_x);
        } else if (Delta_x < 0.0 && Delta_y < 0.0) {
            angulo = Math.PI + Math.atan(Delta_y / Delta_x);
        } else if (Delta_x > 0.0 && Delta_y < 0.0) {
            angulo = Math.PI * 2 + Math.atan(Delta_y / Delta_x);
        } else if (Delta_x == 0.0 && Delta_y < 0.0) {
            angulo = -1.5707963267948966;
        } else if (Delta_x == 0.0 && Delta_y > 0.0) {
            angulo = 1.5707963267948966;
        } else if (Delta_x > 0.0 && Delta_y == 0.0) {
            angulo = 0.0;
        } else if (Delta_x < 0.0 && Delta_y == 0.0) {
            angulo = Math.PI;
        }
        paso_x = (double)gs * Math.cos(angulo);
        paso_y = (double)gs * Math.sin(angulo);
        for (int i = 1; i < npelotas - 1; ++i) {
            g.drawLine((int)((double)x1 + (double)i * paso_x + (double)(gs / 2) * Math.sin(angulo)), (int)((double)y1 + (double)i * paso_y - (double)(gs / 2) * Math.cos(angulo)), (int)((double)x1 + (double)i * paso_x - (double)(gs / 2) * Math.sin(angulo)), (int)((double)y1 + (double)i * paso_y + (double)(gs / 2) * Math.cos(angulo)));
            g.drawLine((int)((double)x1 + (double)i * paso_x + (double)(gs / 2) * Math.sin(angulo)), (int)((double)y1 + (double)i * paso_y - (double)(gs / 2) * Math.cos(angulo)), (int)((double)x1 + (double)(i + 1) * paso_x - (double)(gs / 2) * Math.sin(angulo)), (int)((double)y1 + (double)(i + 1) * paso_y + (double)(gs / 2) * Math.cos(angulo)));
        }
        if (arrow == 1) {
            GraphicsUtil.drawArrow(g, (int)((double)x2 - paso_x), (int)((double)y2 - paso_y), x2, y2, gs, 3 * gs);
        }
    }
}

