/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import de.core.DeepEdit;
import de.core.JMapCanvas;
import de.core.JMapDataRepository;
import de.core.JMapObject;
import de.core.JMapObserverFeatures;
import de.core.JMapObserverGridLines;
import de.core.JMapObserverIcons;
import de.core.JMapObserverPosition;
import de.core.JMapObserverTransform;
import de.core.JMapObserverZoom;
import de.core.JMapRectangle;
import de.core.JMapTransformEqui;
import de.core.JMapTransformMercator;
import java.awt.Button;
import java.awt.Color;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;

class GeoMap
extends Frame
implements KeyListener,
ActionListener {
    DeepEdit applet;
    public double HR = 200.0;
    public double GSlon = 1.0;
    public double GSlat = 1.0;
    public String projection = "Equirectangle";
    public int screenw = 300;
    public int screenh = 700;
    public JMapCanvas canvasMap;
    private JMapDataRepository dataRep;

    public GeoMap(DeepEdit aapplet, int sscreenw, int sscreenh, String pprojection, String mapname) {
        super("DeepEdit-GIS");
        this.screenw = sscreenw;
        this.screenh = sscreenh;
        this.projection = pprojection;
        System.out.println("Using Map File: " + mapname);
        this.applet = aapplet;
        this.setLayout(null);
        this.addNotify();
        this.resize(this.screenw, this.screenh);
        String strTag = "maps/maps.tag";
        this.dataRep = new JMapDataRepository(mapname, strTag, this.applet);
        this.canvasMap = new JMapCanvas(this.applet);
        this.canvasMap.reshape(0, 0, this.bounds().width, this.bounds().height);
        this.canvasMap.setBackground(Color.white);
        JMapRectangle rec = this.dataRep.getMapRectangle();
        if (this.projection.equals("Equirectangle")) {
            this.canvasMap.pushTransform(new JMapTransformEqui(new Rectangle(0, 20, this.bounds().width, this.bounds().height), rec.x1, rec.y1, rec.x2, rec.y2));
        } else {
            this.canvasMap.pushTransform(new JMapTransformMercator(new Rectangle(0, 20, this.bounds().width, this.bounds().height), rec.x1, rec.y1, rec.x2, rec.y2));
        }
        this.add(this.canvasMap);
        new JMapObserverGridLines(this.canvasMap);
        new JMapObserverIcons(this.canvasMap, this.dataRep);
        new JMapObserverFeatures(this.canvasMap, this.dataRep);
        new JMapObserverZoom(this.canvasMap);
        new JMapObserverPosition(this.canvasMap);
        new JMapObserverTransform(this.canvasMap);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                GeoMap.this.setVisible(false);
                GeoMap.this.applet.UserWantsGIS(false);
            }
        });
        this.updateLines();
        this.setIconImage(this.applet.getFrameIconImage());
        this.setVisible(true);
    }

    public void updateLines() {
        Vector itr = this.dataRep.getVecFeatures();
        for (int i = 0; i < itr.size(); ++i) {
            JMapObject mo = (JMapObject)itr.elementAt(i);
            if (!mo.getObjType().equals("line") && !mo.getObjType().equals("tdbarc") && !mo.getObjType().equals("fdblink")) continue;
            if (!DeepEdit.MySchematic.assignJMap(mo)) continue;
        }
    }

    @Override
    public void keyPressed(KeyEvent event) {
        if (event.getKeyCode() == 27) {
            this.setVisible(false);
            this.applet.UserWantsGIS(false);
        }
    }

    @Override
    public void keyReleased(KeyEvent event) {
    }

    @Override
    public void keyTyped(KeyEvent event) {
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        Object obj = ev.getSource();
        String label = ev.getActionCommand();
        if (obj instanceof Button) {
            if (label.equals("Exit")) {
                this.setVisible(false);
                this.applet.UserWantsGIS(false);
            } else {
                this.repaint();
            }
        }
    }
}

